"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.Interactive = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _ = require("../");

var _Tooltip = _interopRequireDefault(require("../../Tooltip"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/ProgressIndicator'
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_.ProgressIndicator, null, /*#__PURE__*/_react.default.createElement(_.ProgressStep, {
    label: "First step",
    description: "Step 1: Getting started with Carbon Design System",
    secondaryLabel: "Optional label"
  }), /*#__PURE__*/_react.default.createElement(_.ProgressStep, {
    label: "Second step with tooltip",
    description: "Step 2: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "bx--progress-label",
        triggerText: 'Second step with tooltip',
        tooltipId: "tooltipId-0"
      }, /*#__PURE__*/_react.default.createElement("p", null, "Overflow tooltip content."));
    }
  }), /*#__PURE__*/_react.default.createElement(_.ProgressStep, {
    label: "Third step with tooltip",
    description: "Step 3: Getting started with Carbon Design System",
    renderLabel: function renderLabel() {
      return /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "bx--progress-label",
        triggerText: 'Second step with tooltip',
        tooltipId: "tooltipId-0"
      }, /*#__PURE__*/_react.default.createElement("p", null, "Overflow tooltip content."));
    }
  }), /*#__PURE__*/_react.default.createElement(_.ProgressStep, {
    label: "Fourth step",
    description: "Step 4: Getting started with Carbon Design System",
    invalid: true,
    secondaryLabel: "Example invalid step"
  }), /*#__PURE__*/_react.default.createElement(_.ProgressStep, {
    label: "Fifth step",
    description: "Step 5: Getting started with Carbon Design System",
    disabled: true
  }));
};

exports.Default = Default;

var Interactive = function Interactive() {
  return /*#__PURE__*/_react.default.createElement(_.ProgressIndicator, {
    currentIndex: 1,
    onChange: function onChange() {
      return alert('Clicked');
    }
  }, /*#__PURE__*/_react.default.createElement(_.ProgressStep, {
    label: "Click me",
    description: "Step 1: Register a onChange event"
  }), /*#__PURE__*/_react.default.createElement(_.ProgressStep, {
    label: "Really long label",
    description: "The progress indicator will listen for clicks on the steps"
  }), /*#__PURE__*/_react.default.createElement(_.ProgressStep, {
    label: "Tooltip and really long label",
    description: "The progress indicator will listen for clicks on the steps",
    renderLabel: function renderLabel() {
      return /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        direction: "bottom",
        showIcon: false,
        triggerClassName: "bx--progress-label",
        triggerText: "Tooltip and really long label",
        tooltipId: "tooltipId-1"
      }, /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor, sit amet consectetur adipisicing elit. Animi consequuntur hic ratione aliquid cupiditate, nesciunt saepe iste blanditiis cumque maxime tenetur veniam est illo deserunt sint quae pariatur. Laboriosam, consequatur."));
    }
  }));
};

exports.Interactive = Interactive;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_.ProgressIndicatorSkeleton, null);
};

exports.Skeleton = Skeleton;