"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.RadioButton = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _warning = require("../../internal/warning");

var _uniqueId = _interopRequireDefault(require("../../tools/uniqueId"));

var _Text = require("../Text");

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "labelText", "labelPosition", "innerRef", "hideLabel"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var RadioButton = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(RadioButton, _React$Component);

  var _super = _createSuper(RadioButton);

  function RadioButton() {
    var _this;

    (0, _classCallCheck2.default)(this, RadioButton);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "prefix", _this.context);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "uid", _this.props.id || (0, _uniqueId.default)());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleChange", function (evt) {
      _this.props.onChange(_this.props.value, _this.props.name, evt);
    });
    return _this;
  }

  (0, _createClass2.default)(RadioButton, [{
    key: "render",
    value: function render() {
      var prefix = this.prefix;
      var _this$props = this.props,
          className = _this$props.className,
          labelText = _this$props.labelText,
          labelPosition = _this$props.labelPosition,
          ref = _this$props.innerRef,
          hideLabel = _this$props.hideLabel,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);

      if (process.env.NODE_ENV !== "production") {
        process.env.NODE_ENV !== "production" ? (0, _warning.warning)(labelPosition !== 'top' && labelPosition !== 'bottom', '`top`/`bottom` values for `labelPosition` property in the `RadioButton` component is deprecated ' + 'and being removed in the next release of `carbon-components-react`.') : void 0;
      }

      var innerLabelClasses = (0, _classnames.default)((0, _defineProperty2.default)({}, "".concat(prefix, "--visually-hidden"), hideLabel));
      var wrapperClasses = (0, _classnames.default)(className, "".concat(prefix, "--radio-button-wrapper"), (0, _defineProperty2.default)({}, "".concat(prefix, "--radio-button-wrapper--label-").concat(labelPosition), labelPosition !== 'right'));
      return /*#__PURE__*/_react.default.createElement("div", {
        className: wrapperClasses
      }, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, other, {
        type: "radio",
        className: "".concat(prefix, "--radio-button"),
        onChange: this.handleChange,
        id: this.uid,
        ref: ref
      })), /*#__PURE__*/_react.default.createElement("label", {
        htmlFor: this.uid,
        className: "".concat(prefix, "--radio-button__label")
      }, /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--radio-button__appearance")
      }), labelText && /*#__PURE__*/_react.default.createElement(_Text.Text, {
        className: innerLabelClasses
      }, labelText)));
    }
  }]);
  return RadioButton;
}(_react.default.Component);

exports.RadioButton = RadioButton;
(0, _defineProperty2.default)(RadioButton, "propTypes", {
  /**
   * Specify whether the <RadioButton> is currently checked
   */
  checked: _propTypes.default.bool,

  /**
   * Provide an optional className to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the <RadioButton> should be checked by default
   */
  defaultChecked: _propTypes.default.bool,

  /**
   * Specify whether the control is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Provide a unique id for the underlying `<input>` node
   */
  id: _propTypes.default.string,

  /**
   * Provide where label text should be placed
   * NOTE: `top`/`bottom` are deprecated
   */
  labelPosition: _propTypes.default.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * Provide label text to be read by screen readers when interacting with the
   * control
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Provide a name for the underlying `<input>` node
   */
  name: _propTypes.default.string,

  /**
   * Provide an optional `onChange` hook that is called each time the value of
   * the underlying `<input>` changes
   */
  onChange: _propTypes.default.func,

  /**
   * Provide a handler that is invoked when a user clicks on the control
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the value of the <RadioButton>
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired
});
(0, _defineProperty2.default)(RadioButton, "contextType", _usePrefix.PrefixContext);
(0, _defineProperty2.default)(RadioButton, "defaultProps", {
  labelText: '',
  labelPosition: 'right',
  onChange: function onChange() {},
  value: ''
});

var _default = function () {
  var forwardRef = function forwardRef(props, ref) {
    return /*#__PURE__*/_react.default.createElement(RadioButton, (0, _extends2.default)({}, props, {
      innerRef: ref
    }));
  };

  forwardRef.displayName = 'RadioButton';
  return /*#__PURE__*/_react.default.forwardRef(forwardRef);
}();

exports.default = _default;