"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _iconsReact = require("@carbon/icons-react");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _focus = require("../../../internal/focus");

var _keyboard = require("../../../internal/keyboard");

var _useId = require("../../../internal/useId");

var _usePrefix = require("../../../internal/usePrefix");

var _deprecate = _interopRequireDefault(require("../../../prop-types/deprecate"));

var _events = require("../../../tools/events");

var _excluded = ["autoComplete", "className", "closeButtonLabelText", "defaultValue", "disabled", "id", "labelText", "light", "onChange", "onClear", "onKeyDown", "placeHolderText", "placeholder", "renderIcon", "role", "size", "small", "type", "value"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function Search(_ref) {
  var _cx, _cx2;

  var _ref$autoComplete = _ref.autoComplete,
      autoComplete = _ref$autoComplete === void 0 ? 'off' : _ref$autoComplete,
      className = _ref.className,
      _ref$closeButtonLabel = _ref.closeButtonLabelText,
      closeButtonLabelText = _ref$closeButtonLabel === void 0 ? 'Clear search input' : _ref$closeButtonLabel,
      defaultValue = _ref.defaultValue,
      disabled = _ref.disabled,
      id = _ref.id,
      labelText = _ref.labelText,
      light = _ref.light,
      _ref$onChange = _ref.onChange,
      onChange = _ref$onChange === void 0 ? function () {} : _ref$onChange,
      _ref$onClear = _ref.onClear,
      onClear = _ref$onClear === void 0 ? function () {} : _ref$onClear,
      onKeyDown = _ref.onKeyDown,
      placeHolderText = _ref.placeHolderText,
      _ref$placeholder = _ref.placeholder,
      placeholder = _ref$placeholder === void 0 ? '' : _ref$placeholder,
      renderIcon = _ref.renderIcon,
      _ref$role = _ref.role,
      role = _ref$role === void 0 ? 'searchbox' : _ref$role,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? !small ? 'lg' : 'sm' : _ref$size,
      small = _ref.small,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'text' : _ref$type,
      value = _ref.value,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var input = (0, _react.useRef)(null);
  var magnifier = (0, _react.useRef)(null);
  var inputId = (0, _useId.useId)('search-input');
  var uniqueId = id || inputId;
  var searchId = "".concat(uniqueId, "-search");

  var _useState = (0, _react.useState)(value || defaultValue || false),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      hasContent = _useState2[0],
      setHasContent = _useState2[1];

  var _useState3 = (0, _react.useState)(value),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      prevValue = _useState4[0],
      setPrevValue = _useState4[1];

  var searchClasses = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--search"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--search--sm"), size === 'sm'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--search--md"), size === 'md'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--search--lg"), size === 'lg'), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--search--light"), light), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--search--disabled"), disabled), (0, _defineProperty2.default)(_cx, className, className), _cx));
  var clearClasses = (0, _classnames.default)((_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--search-close"), true), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--search-close--hidden"), !hasContent), _cx2));

  if (value !== prevValue) {
    setHasContent(!!value);
    setPrevValue(value);
  }

  function clearInput(event) {
    if (!value) {
      input.current.value = '';
      onChange(event);
    } else {
      var clearedEvt = Object.assign({}, event.target, {
        target: {
          value: ''
        }
      });
      onChange(clearedEvt);
    }

    onClear();
    setHasContent(false);
    (0, _focus.focus)(input);
  }

  function handleChange(event) {
    setHasContent(event.target.value !== '');
  }

  function handleKeyDown(event) {
    if ((0, _keyboard.match)(event, _keyboard.keys.Escape)) {
      event.stopPropagation();
      clearInput(event);
    }
  }

  return /*#__PURE__*/_react.default.createElement("div", {
    role: "search",
    "aria-labelledby": searchId,
    className: searchClasses
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--search-magnifier"),
    ref: magnifier
  }, /*#__PURE__*/_react.default.createElement(SearchIcon, {
    icon: renderIcon
  })), /*#__PURE__*/_react.default.createElement("label", {
    id: searchId,
    htmlFor: uniqueId,
    className: "".concat(prefix, "--label")
  }, labelText), /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, rest, {
    autoComplete: autoComplete,
    className: "".concat(prefix, "--search-input"),
    defaultValue: defaultValue,
    disabled: disabled,
    role: role,
    ref: input,
    id: uniqueId,
    onChange: (0, _events.composeEventHandlers)([onChange, handleChange]),
    onKeyDown: (0, _events.composeEventHandlers)([onKeyDown, handleKeyDown]),
    placeholder: placeHolderText || placeholder,
    type: type,
    value: value
  })), /*#__PURE__*/_react.default.createElement("button", {
    "aria-label": closeButtonLabelText,
    className: clearClasses,
    disabled: disabled,
    onClick: clearInput,
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Close16, null)));
}

Search.propTypes = {
  /**
   * Specify an optional value for the `autocomplete` property on the underlying
   * `<input>`, defaults to "off"
   */
  autoComplete: _propTypes.default.string,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify a label to be read by screen readers on the "close" button
   */
  closeButtonLabelText: _propTypes.default.string,

  /**
   * Optionally provide the default value of the `<input>`
   */
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the `<input>` should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify a custom `id` for the input
   */
  id: _propTypes.default.string,

  /**
   * Provide the label text for the Search icon
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Specify light version or default version of this control
   */
  light: _propTypes.default.bool,

  /**
   * Optional callback called when the search value changes.
   */
  onChange: _propTypes.default.func,

  /**
   * Optional callback called when the search value is cleared.
   */
  onClear: _propTypes.default.func,

  /**
   * Provide a handler that is invoked on the key down event for the input
   */
  onKeyDown: _propTypes.default.func,

  /**
   * Deprecated in favor of `placeholder`
   */
  placeHolderText: (0, _deprecate.default)(_propTypes.default.string, "\nThe prop `placeHolderText` for Search has been deprecated in favor of `placeholder`. Please use `placeholder` instead."),

  /**
   * Provide an optional placeholder text for the Search.
   * Note: if the label and placeholder differ,
   * VoiceOver on Mac will read both
   */
  placeholder: _propTypes.default.string,

  /**
   * Rendered icon for the Search.
   * Can be a React component class
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Specify the role for the underlying `<input>`, defaults to `searchbox`
   */
  role: _propTypes.default.string,

  /**
   * Specify the search size
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify whether the Search should be a small variant
   */

  /**
   * Specify whether the load was successful
   */
  small: (0, _deprecate.default)(_propTypes.default.bool, "\nThe prop `small` for Search has been deprecated in favor of `size`. Please use `size=\"sm\"` instead."),

  /**
   * Optional prop to specify the type of the `<input>`
   */
  type: _propTypes.default.string,

  /**
   * Specify the value of the `<input>`
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number])
};

function SearchIcon(_ref2) {
  var icon = _ref2.icon;
  var prefix = (0, _usePrefix.usePrefix)();

  if (icon) {
    return /*#__PURE__*/_react.default.cloneElement(icon, {
      className: "".concat(prefix, "--search-magnifier-icon")
    });
  }

  return /*#__PURE__*/_react.default.createElement(_iconsReact.Search16, {
    className: "".concat(prefix, "--search-magnifier-icon")
  });
}

SearchIcon.propTypes = {
  /**
   * Rendered icon for the Search. Can be a React component class
   */
  icon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object])
};
var _default = Search;
exports.default = _default;