"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableWithLayer = exports.withLayer = exports.Expandable = exports.Disabled = exports.Default = exports.default = void 0;

var _carbonComponentsReact = require("carbon-components-react");

var _react = _interopRequireDefault(require("react"));

var _Layer = require("../../Layer");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/Search'
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Search, {
    size: "lg",
    defaultValue: "A default value",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  });
};

exports.Default = Default;

var Disabled = function Disabled() {
  return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Search, {
    disabled: true,
    size: "lg",
    defaultValue: "A default value",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  });
};

exports.Disabled = Disabled;

var Expandable = function Expandable() {
  return /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.ExpandableSearch, {
    size: "lg",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-expandable-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  });
};

exports.Expandable = Expandable;

var withLayer = function withLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Search, {
    size: "lg",
    defaultValue: "First Layer",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Search, {
    size: "lg",
    defaultValue: "Second Layer",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.Search, {
    size: "lg",
    defaultValue: "Third Layer",
    labelText: "Search",
    closeButtonLabelText: "Clear search input",
    id: "search-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }))));
};

exports.withLayer = withLayer;

var ExpandableWithLayer = function ExpandableWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.ExpandableSearch, {
    size: "lg",
    labelText: "First Layer",
    closeButtonLabelText: "Clear search input",
    id: "search-expandable-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.ExpandableSearch, {
    size: "lg",
    labelText: "Second Layer",
    closeButtonLabelText: "Clear search input",
    id: "search-expandable-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_carbonComponentsReact.ExpandableSearch, {
    size: "lg",
    labelText: "Third Layer",
    closeButtonLabelText: "Clear search input",
    id: "search-expandable-1",
    onChange: function onChange() {},
    onKeyDown: function onKeyDown() {}
  }))));
};

exports.ExpandableWithLayer = ExpandableWithLayer;