"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _warning = require("../../internal/warning");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;
var didWarnAboutDeprecation = false;
/**
 * The layout button for `<Search>`.
 */

var SearchLayoutButton = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(SearchLayoutButton, _Component);

  var _super = _createSuper(SearchLayoutButton);

  function SearchLayoutButton(props) {
    var _this;

    (0, _classCallCheck2.default)(this, SearchLayoutButton);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      format: 'list'
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "toggleLayout", function () {
      var format = _this.state.format === 'list' ? 'grid' : 'list';

      _this.setState({
        format: format
      }, function () {
        var onChangeFormat = _this.props.onChangeFormat;

        if (typeof onChangeFormat === 'function') {
          onChangeFormat({
            format: format
          });
        }
      });
    });

    if (process.env.NODE_ENV !== "production") {
      process.env.NODE_ENV !== "production" ? (0, _warning.warning)(didWarnAboutDeprecation, 'The SearchLayoutButton component has been deprecated and will be removed in the next major release of `carbon-components-react`') : void 0;
      didWarnAboutDeprecation = true;
    }

    return _this;
  }
  /**
   * Toggles the button state upon user-initiated event.
   */


  (0, _createClass2.default)(SearchLayoutButton, [{
    key: "render",
    value: function render() {
      var _this2 = this;

      var _this$props = this.props,
          labelText = _this$props.labelText,
          iconDescriptionList = _this$props.iconDescriptionList,
          iconDescriptionGrid = _this$props.iconDescriptionGrid;

      var SearchLayoutButtonIcon = function SearchLayoutButtonIcon() {
        if (_this2.state.format === 'list') {
          return /*#__PURE__*/_react.default.createElement(_iconsReact.ListBulleted16, {
            className: "".concat(prefix, "--search-view"),
            "aria-label": iconDescriptionList
          });
        }

        return /*#__PURE__*/_react.default.createElement(_iconsReact.Grid16, {
          className: "".concat(prefix, "--search-view"),
          "aria-label": iconDescriptionGrid
        });
      };

      return /*#__PURE__*/_react.default.createElement("button", {
        className: "".concat(prefix, "--search-button"),
        type: "button",
        onClick: this.toggleLayout,
        "aria-label": labelText,
        title: labelText
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--search__toggle-layout__container")
      }, /*#__PURE__*/_react.default.createElement(SearchLayoutButtonIcon, null)));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var format = _ref.format;
      var prevFormat = state.prevFormat;
      return prevFormat === format ? null : {
        format: format || 'list',
        prevFormat: format
      };
    }
  }]);
  return SearchLayoutButton;
}(_react.Component);

(0, _defineProperty2.default)(SearchLayoutButton, "propTypes", {
  /**
   * The layout.
   */
  format: _propTypes.default.oneOf(['list', 'grid']),

  /**
   * The description for the "grid" icon.
   */
  iconDescriptionGrid: _propTypes.default.string,

  /**
   * The description for the "list" icon.
   */
  iconDescriptionList: _propTypes.default.string,

  /**
   * The a11y label text.
   */
  labelText: _propTypes.default.string,

  /**
   * The callback called when layout switches.
   */
  onChangeFormat: _propTypes.default.func
});
(0, _defineProperty2.default)(SearchLayoutButton, "defaultProps", {
  labelText: 'Filter',
  iconDescriptionList: 'list',
  iconDescriptionGrid: 'grid'
});
var _default = SearchLayoutButton;
exports.default = _default;