"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["hideLabel", "className"];

var SelectSkeleton = function SelectSkeleton(_ref) {
  var hideLabel = _ref.hideLabel,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: (0, _classnames.default)("".concat(prefix, "--form-item"), className)
  }, rest), !hideLabel && /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--label ").concat(prefix, "--skeleton")
  }), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--select ").concat(prefix, "--skeleton")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--select-input")
  })));
};

SelectSkeleton.propTypes = {
  /**
   * Specify an optional className to add to the form item wrapper.
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: _propTypes.default.bool
};
var _default = SelectSkeleton;
exports.default = _default;