"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.withLayer = exports._Skeleton = exports.Inline = exports._Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _ = _interopRequireWildcard(require("../"));

var _SelectItem = _interopRequireDefault(require("../../SelectItem"));

var _SelectItemGroup = _interopRequireDefault(require("../../SelectItemGroup"));

var _Layer = require("../../Layer");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/Select',
  decorators: [function (story) {
    return /*#__PURE__*/_react.default.createElement("div", {
      style: {
        width: '400px'
      }
    }, story());
  }],
  parameters: {
    component: _.default,
    subcomponents: {
      SelectItem: _SelectItem.default,
      SelectItemGroup: _SelectItemGroup.default,
      SelectSkeleton: _.SelectSkeleton
    }
  }
};
exports.default = _default;

var _Default = function _Default() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "Select an option",
    helperText: "Optional helper text"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, {
    label: "Category 1"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, {
    label: "Category 2"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-4",
    text: "Option 4"
  }))));
};

exports._Default = _Default;

var Inline = function Inline() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_.default, {
    inline: true,
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "",
    helperText: "Optional helper text"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, {
    label: "Category 1"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/_react.default.createElement(_SelectItemGroup.default, {
    label: "Category 2"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-4",
    text: "Option 4"
  }))));
};

exports.Inline = Inline;

var _Skeleton = function _Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    "aria-label": "loading select",
    "aria-live": "assertive",
    role: "status",
    tabIndex: "0" // eslint-disable-line jsx-a11y/no-noninteractive-tabindex

  }, /*#__PURE__*/_react.default.createElement(_.SelectSkeleton, null));
};

exports._Skeleton = _Skeleton;

var withLayer = function withLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "",
    helperText: "First layer"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "",
    helperText: " Second layer"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-4",
    text: "Option 4"
  })), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "",
    helperText: "Third layer"
  }, /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-2",
    text: "Option 2"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/_react.default.createElement(_SelectItem.default, {
    value: "option-4",
    text: "Option 4"
  })))));
};

exports.withLayer = withLayer;