"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.ControlledSliderWithLayer = exports.withLayer = exports.ControlledSlider = exports.Default = exports.default = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _Slider = _interopRequireWildcard(require("../../Slider"));

var _Layer = require("../../Layer");

var _Slider2 = _interopRequireDefault(require("./Slider.mdx"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
// import { action } from '@storybook/addon-actions';
// import { withKnobs, boolean, number, text } from '@storybook/addon-knobs';
// import { sliderValuePropSync } from '../../../../react/src/internal/FeatureFlags';
var _default = {
  title: 'Components/Slider',
  parameters: {
    component: _Slider.default,
    docs: {
      page: _Slider2.default
    },
    subcomponents: {
      SliderSkeleton: _Slider.SliderSkeleton
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_Slider.default, {
    labelText: "Slider Label",
    value: 50,
    min: 0,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  });
};

exports.Default = Default;
Default.story = {
  name: 'Slider'
};

var ControlledSlider = function ControlledSlider() {
  var _useState = (0, _react.useState)(87),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      val = _useState2[0],
      setVal = _useState2[1];

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/_react.default.createElement(_Slider.default, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref) {
      var value = _ref.value;
      return setVal(value);
    }
  }), /*#__PURE__*/_react.default.createElement("h1", null, val));
};

exports.ControlledSlider = ControlledSlider;

var withLayer = function withLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Slider.default, {
    labelText: "First Layer",
    value: 50,
    min: 0,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_Slider.default, {
    labelText: "Second Layer",
    value: 50,
    min: 0,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  }), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_Slider.default, {
    labelText: "Third Layer",
    value: 50,
    min: 0,
    max: 100,
    step: 1,
    stepMultiplier: 10,
    novalidate: true
  }))));
};

exports.withLayer = withLayer;

var ControlledSliderWithLayer = function ControlledSliderWithLayer() {
  var _useState3 = (0, _react.useState)(87),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      val = _useState4[0],
      setVal = _useState4[1];

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/_react.default.createElement(_Slider.default, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref2) {
      var value = _ref2.value;
      return setVal(value);
    }
  }), /*#__PURE__*/_react.default.createElement("h1", null, val), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/_react.default.createElement(_Slider.default, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref3) {
      var value = _ref3.value;
      return setVal(value);
    }
  }), /*#__PURE__*/_react.default.createElement("h1", null, val), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setVal(Math.round(Math.random() * 100));
    }
  }, "randomize value"), /*#__PURE__*/_react.default.createElement(_Slider.default, {
    max: 100,
    min: 0,
    value: val,
    onChange: function onChange(_ref4) {
      var value = _ref4.value;
      return setVal(value);
    }
  }), /*#__PURE__*/_react.default.createElement("h1", null, val))));
};

exports.ControlledSliderWithLayer = ControlledSliderWithLayer;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement(_Slider.SliderSkeleton, null);
};

exports.Skeleton = Skeleton;