"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Stack = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _layout = require("@carbon/layout");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["as", "children", "className", "gap", "orientation"];

/**
 * The steps in the spacing scale
 * @type {Array<number>}
 */
var SPACING_STEPS = Array.from({
  length: _layout.spacing.length - 1
}).map(function (_, step) {
  return step + 1;
});
/**
 * The Stack component is a useful layout utility in a component-based model.
 * This allows components to not use margin and instead delegate the
 * responsibility of positioning and layout to parent components.
 *
 * In the case of the Stack component, it uses the spacing scale from the
 * Design Language in order to determine how much space there should be between
 * items rendered by the Stack component. It also supports a custom `gap` prop
 * which will allow a user to provide a custom value for the gap of the layout.
 *
 * This component supports both horizontal and vertical orientations.
 *
 * Inspiration for this component:
 *
 * - https://paste.twilio.design/layout/stack/
 * - https://github.com/Workday/canvas-kit/blob/f2f599654876700f483a1d8c5de82a41315c76f1/modules/labs-react/layout/lib/Stack.tsx
 */

var Stack = /*#__PURE__*/_react.default.forwardRef(function Stack(props, ref) {
  var _cx;

  var _props$as = props.as,
      BaseComponent = _props$as === void 0 ? 'div' : _props$as,
      children = props.children,
      customClassName = props.className,
      gap = props.gap,
      _props$orientation = props.orientation,
      orientation = _props$orientation === void 0 ? 'vertical' : _props$orientation,
      rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)(customClassName, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--stack-").concat(orientation), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--stack-scale-").concat(gap), typeof gap === 'number'), _cx));
  var style = {};

  if (typeof gap === 'string') {
    style["--".concat(prefix, "-stack-gap")] = gap;
  }

  return /*#__PURE__*/_react.default.createElement(BaseComponent, (0, _extends2.default)({}, rest, {
    ref: ref,
    className: className,
    style: style
  }), children);
});

exports.Stack = Stack;
Stack.propTypes = {
  /**
   * Provide a custom element type to render as the outermost element in
   * the Stack component. By default, this component will render a `div`.
   */
  as: _propTypes.default.elementType,

  /**
   * Provide the elements that will be rendered as children inside of the Stack
   * component. These elements will have having spacing between them according
   * to the `step` and `orientation` prop
   */
  children: _propTypes.default.node,

  /**
   * Provide a custom class name to be used by the outermost element rendered by
   * Stack
   */
  className: _propTypes.default.string,

  /**
   * Provide either a custom value or a step from the spacing scale to be used
   * as the gap in the layout
   */
  gap: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.oneOf(SPACING_STEPS)]),

  /**
   * Specify the orientation of them items in the Stack
   */
  orientation: _propTypes.default.oneOf(['horizontal', 'vertical'])
};