"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.Selection = exports.Playground = exports.Simple = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _iconsReact = require("@carbon/icons-react");

var _addonKnobs = require("@storybook/addon-knobs");

var _StructuredList = require("../StructuredList");

var _StructuredList2 = _interopRequireDefault(require("../StructuredList/StructuredList.Skeleton"));

var _carbonComponents = require("carbon-components");

var _StructuredList3 = _interopRequireDefault(require("./StructuredList.mdx"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var prefix = _carbonComponents.settings.prefix;

var props = function props() {
  return {
    isCondensed: (0, _addonKnobs.boolean)('Condensed', false),
    isFlush: (0, _addonKnobs.boolean)('Flush alignment', false)
  };
};

var _default = {
  title: 'Components/StructuredList',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _StructuredList.StructuredListWrapper,
    docs: {
      page: _StructuredList3.default
    },
    subcomponents: {
      StructuredListHead: _StructuredList.StructuredListHead,
      StructuredListBody: _StructuredList.StructuredListBody,
      StructuredListRow: _StructuredList.StructuredListRow,
      StructuredListInput: _StructuredList.StructuredListInput,
      StructuredListCell: _StructuredList.StructuredListCell
    }
  }
};
exports.default = _default;

var Simple = function Simple() {
  return /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListWrapper, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListHead, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListRow, {
    head: true
  }, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, "ColumnA"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, "ColumnB"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, "ColumnC"))), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListBody, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListRow, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    noWrap: true
  }, "Row 1"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Row 1"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum.")), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListRow, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    noWrap: true
  }, "Row 2"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Row 2"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum."))));
};

exports.Simple = Simple;
Simple.parameters = {
  info: {
    text: "\n        Structured Lists group content that is similar or related, such as terms or definitions.\n      "
  }
};

var Playground = function Playground() {
  return /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListWrapper, props(), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListHead, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListRow, {
    head: true
  }, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, "ColumnA"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, "ColumnB"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, "ColumnC"))), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListBody, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListRow, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    noWrap: true
  }, "Row 1"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Row 1"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum.")), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListRow, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    noWrap: true
  }, "Row 2"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Row 2"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum."))));
};

exports.Playground = Playground;
Playground.parameters = {
  info: {
    text: "\n        Structured Lists group content that is similar or related, such as terms or definitions.\n      "
  }
};

var Selection = function Selection() {
  var structuredListBodyRowGenerator = function structuredListBodyRowGenerator(numRows) {
    return Array.apply(null, Array(numRows)).map(function (n, i) {
      return /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListRow, {
        label: true,
        key: "row-".concat(i)
      }, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Row ", i), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Row ", i), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, "Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc dui magna, finibus id tortor sed, aliquet bibendum augue. Aenean posuere sem vel euismod dignissim. Nulla ut cursus dolor. Pellentesque vulputate nisl a porttitor interdum."), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListInput, {
        id: "row-".concat(i),
        value: "row-".concat(i),
        title: "row-".concat(i),
        name: "row-0",
        defaultChecked: !i || null
      }), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, null, /*#__PURE__*/_react.default.createElement(_iconsReact.CheckmarkFilled16, {
        className: "".concat(prefix, "--structured-list-svg"),
        "aria-label": "select an option"
      }, /*#__PURE__*/_react.default.createElement("title", null, "select an option"))));
    });
  };

  return /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListWrapper, (0, _extends2.default)({
    selection: true
  }, props()), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListHead, null, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListRow, {
    head: true
  }, /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, "ColumnA"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, "ColumnB"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, "ColumnC"), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListCell, {
    head: true
  }, ''))), /*#__PURE__*/_react.default.createElement(_StructuredList.StructuredListBody, null, structuredListBodyRowGenerator(4)));
};

exports.Selection = Selection;
Selection.parameters = {
  info: {
    text: "\n    Structured Lists with selection allow a row of list content to be selected.\n  "
  }
};

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", {
    style: {
      width: '800px'
    }
  }, /*#__PURE__*/_react.default.createElement(_StructuredList2.default, null), /*#__PURE__*/_react.default.createElement(_StructuredList2.default, null));
};

exports.Skeleton = Skeleton;
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n        Placeholder skeleton state to use when content is loading.\n      "
  }
};