"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var FeatureFlags = _interopRequireWildcard(require("@carbon/feature-flags"));

var _carbonComponents = require("carbon-components");

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _excluded = ["id", "className", "handleTabClick", "handleTabKeyDown", "disabled", "href", "index", "label", "selected", "tabIndex", "onClick", "onKeyDown", "renderAnchor", "renderButton", "renderContent", "role"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;

var Tab = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(Tab, _React$Component);

  var _super = _createSuper(Tab);

  function Tab() {
    (0, _classCallCheck2.default)(this, Tab);
    return _super.apply(this, arguments);
  }

  (0, _createClass2.default)(Tab, [{
    key: "render",
    value: function render() {
      var _classNames,
          _this = this,
          _buttonProps;

      var _this$props = this.props,
          id = _this$props.id,
          className = _this$props.className,
          handleTabClick = _this$props.handleTabClick,
          handleTabKeyDown = _this$props.handleTabKeyDown,
          disabled = _this$props.disabled,
          _this$props$href = _this$props.href,
          href = _this$props$href === void 0 ? '#' : _this$props$href,
          index = _this$props.index,
          label = _this$props.label,
          selected = _this$props.selected,
          _this$props$tabIndex = _this$props.tabIndex,
          tabIndex = _this$props$tabIndex === void 0 ? 0 : _this$props$tabIndex,
          _onClick = _this$props.onClick,
          _onKeyDown = _this$props.onKeyDown,
          renderAnchor = _this$props.renderAnchor,
          renderButton = _this$props.renderButton,
          renderContent = _this$props.renderContent,
          role = _this$props.role,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var classes = (0, _classnames.default)(className, // TODO: remove scrollable in next major release
      // `${prefix}--tabs__nav-item`,
      "".concat(prefix, "--tabs--scrollable__nav-item"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tabs__nav-item--disabled"), disabled), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tabs__nav-item--selected"), selected), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tabs--scrollable__nav-item--disabled"), disabled), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tabs--scrollable__nav-item--selected"), selected), _classNames));
      var buttonProps = (_buttonProps = {}, (0, _defineProperty2.default)(_buttonProps, 'aria-selected', selected), (0, _defineProperty2.default)(_buttonProps, 'aria-disabled', disabled), (0, _defineProperty2.default)(_buttonProps, 'aria-controls', id && "".concat(id, "__panel")), (0, _defineProperty2.default)(_buttonProps, "id", id), (0, _defineProperty2.default)(_buttonProps, "className", "".concat(prefix, "--tabs--scrollable__nav-link")), (0, _defineProperty2.default)(_buttonProps, "href", href), (0, _defineProperty2.default)(_buttonProps, "tabIndex", !disabled ? tabIndex : -1), (0, _defineProperty2.default)(_buttonProps, "ref", function ref(e) {
        _this.tabAnchor = e;
      }), _buttonProps);
      var renderElement = renderButton || renderAnchor;
      return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({}, other, {
        className: classes,
        onClick: function onClick(evt) {
          if (disabled) {
            return;
          }

          if (handleTabClick) {
            handleTabClick(index, evt);
          }

          _onClick(evt);
        },
        onKeyDown: function onKeyDown(evt) {
          if (disabled) {
            return;
          }

          if (handleTabKeyDown) {
            handleTabKeyDown(index, evt);
          }

          _onKeyDown(evt);
        },
        role: "presentation"
      }), renderElement ? renderElement(buttonProps) : /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
        type: "button",
        role: "tab"
      }, buttonProps), label));
    }
  }]);
  return Tab;
}(_react.default.Component);

exports.default = Tab;
(0, _defineProperty2.default)(Tab, "propTypes", {
  /**
   * Specify an optional className to be added to your Tab
   */
  className: _propTypes.default.string,

  /**
   * Whether your Tab is disabled.
   */
  disabled: _propTypes.default.bool,

  /**
   * A handler that is invoked when a user clicks on the control.
   * Reserved for usage in Tabs
   */
  handleTabClick: _propTypes.default.func,

  /**
   * A handler that is invoked on the key down event for the control.
   * Reserved for usage in Tabs
   */
  handleTabKeyDown: _propTypes.default.func,

  /**
   * Provide a string that represents the `href` of the Tab
   */
  href: (0, _deprecate.default)(_propTypes.default.string),

  /**
   * The element ID for the top-level element.
   */
  id: _propTypes.default.string,

  /**
   * The index of your Tab in your Tabs. Reserved for usage in Tabs
   */
  index: _propTypes.default.number,

  /**
   * Provide the contents of your Tab
   */
  label: FeatureFlags.enabled('enable-v11-release') ? _propTypes.default.node.isRequired : _propTypes.default.node,

  /**
   * Provide a handler that is invoked when a user clicks on the control
   */
  onClick: _propTypes.default.func.isRequired,

  /**
   * Provide a handler that is invoked on the key down event for the control
   */
  onKeyDown: _propTypes.default.func.isRequired,

  /*
   * An optional parameter to allow overriding the anchor rendering.
   * Useful for using Tab along with react-router or other client
   * side router libraries.
   **/
  renderAnchor: (0, _deprecate.default)(_propTypes.default.func),
  renderButton: _propTypes.default.func,

  /*
   * An optional parameter to allow overriding the content rendering.
   **/
  renderContent: _propTypes.default.func,

  /**
   * Provide an accessibility role for your Tab
   */
  role: (0, _deprecate.default)(_propTypes.default.string),

  /**
   * Whether your Tab is selected.
   * Reserved for usage in Tabs
   */
  selected: _propTypes.default.bool.isRequired,

  /**
   * Specify the tab index of the `<button>` node
   */
  tabIndex: _propTypes.default.number
});
(0, _defineProperty2.default)(Tab, "defaultProps", {
  label: FeatureFlags.enabled('enable-v11-release') ? undefined : 'provide a label',
  selected: false,
  onClick: function onClick() {},
  onKeyDown: function onKeyDown() {}
});