"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _TabContent = _interopRequireDefault(require("../TabContent"));

var _react2 = require("@testing-library/react");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('TabContent', function () {
  describe('renders as expected', function () {
    it('renders children as expected', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TabContent.default, {
        selected: true
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "child"
      }, "content"), /*#__PURE__*/_react.default.createElement("div", {
        className: "child"
      }, "content")));
      expect(_react2.screen.getByRole('tabpanel').children.length).toEqual(2);
    });
    it('sets selected and hidden props with opposite boolean values', function () {
      var _render = (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TabContent.default, null, /*#__PURE__*/_react.default.createElement("div", {
        className: "child"
      }, "content"), /*#__PURE__*/_react.default.createElement("div", {
        className: "child"
      }, "content"))),
          rerender = _render.rerender;

      expect(_react2.screen.queryByRole('tabpanel')).not.toBeInTheDocument();
      rerender( /*#__PURE__*/_react.default.createElement(_TabContent.default, {
        selected: true
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: "child"
      }, "content"), /*#__PURE__*/_react.default.createElement("div", {
        className: "child"
      }, "content")));
      expect(_react2.screen.getByRole('tabpanel')).toBeVisible();
    });
    it('includes the content container in the tabbable index when no tab contents are provided', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TabContent.default, {
        selected: true
      }, /*#__PURE__*/_react.default.createElement("p", null, "content")));
      expect(_react2.screen.getByRole('tabpanel')).toHaveAttribute('tabindex', '0');
    });
    it('does not include the content container in the tabbable index when tab contents are provided', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TabContent.default, {
        selected: true
      }, /*#__PURE__*/_react.default.createElement("a", {
        href: "https://www.ibm.com/"
      }, "content")));
      expect(_react2.screen.getByRole('tabpanel')).not.toHaveAttribute('tabindex', '0');
    });
  });
});