"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["className", "type"];

function Tab() {
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "".concat(prefix, "--tabs--scrollable__nav-item")
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tabs__nav-link")
  }, /*#__PURE__*/_react.default.createElement("span", null)));
}

function TabsSkeleton(_ref) {
  var className = _ref.className,
      type = _ref.type,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var tabClasses = (0, _classnames.default)(className, "".concat(prefix, "--tabs"), "".concat(prefix, "--skeleton"), "".concat(prefix, "--tabs--scrollable"), (0, _defineProperty2.default)({}, "".concat(prefix, "--tabs--scrollable--container"), type === 'container'));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: tabClasses
  }, rest), /*#__PURE__*/_react.default.createElement("ul", {
    className: "".concat(prefix, "--tabs--scrollable__nav")
  }, Tab(), Tab(), Tab(), Tab(), Tab()));
}

TabsSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Provide the type of Tab
   */
  type: _propTypes.default.oneOf(['', 'default', 'container'])
};
var _default = TabsSkeleton;
exports.default = _default;