"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _Tabs = require("./Tabs");

var _react2 = require("@testing-library/react");

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

describe('Tabs', function () {
  it('should update selected index based on the default provided', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, {
      defaultSelectedIndex: 1
    }, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 3")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"))));
    expect(_react2.screen.getByText('Tab Label 2')).toHaveAttribute('aria-selected', 'true');
  });
  it('should set a className from props on outermost element in TabList', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
      "aria-label": "List of tabs",
      className: "custom-class"
    }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
      disabled: true
    }, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 3")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"))));
    expect(_react2.screen.getByRole('tablist')).toHaveClass('custom-class');
  });
});
describe('Tab', function () {
  it('should set a className from props on outermost element in Tab', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
      disabled: true
    }, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
      className: "custom-class"
    }, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 3")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"))));
    expect(_react2.screen.getByText('Tab Label 2')).toHaveClass('custom-class');
  });
  it('should not select a disabled tab and select next tab', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
      disabled: true
    }, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 3")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"))));
    expect(_react2.screen.getByText('Tab Label 1')).toHaveAttribute('aria-selected', 'false'); // By default, if a Tab is disabled, the next Tab should be selected

    expect(_react2.screen.getByText('Tab Label 2')).toHaveAttribute('aria-selected', 'true');
  });
  it('should provide a custom element to render instead of default button if provided', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
      as: "div"
    }, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 3")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"))));
    expect(_react2.screen.getByText('Tab Label 1').tagName).toBe('DIV');
  });
  it('should call onClick from props if provided', function () {
    var onClick = jest.fn();
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
      onClick: onClick
    }, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 3")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"))));

    _userEvent.default.click(_react2.screen.getByText('Tab Label 1'));

    expect(onClick).toHaveBeenCalled();
  });
  it('should call onKeyDown from props if provided', function () {
    var onKeyDown = jest.fn();
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, {
      onKeyDown: onKeyDown
    }, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 3")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"))));

    _userEvent.default.type(_react2.screen.getByText('Tab Label 1'), 'enter');

    expect(onKeyDown).toHaveBeenCalled();
  });
});
describe('TabPanel', function () {
  it('should have a className if provided by props', function () {
    (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tabs.Tabs, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabList, {
      "aria-label": "List of tabs"
    }, /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 1"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 2"), /*#__PURE__*/_react.default.createElement(_Tabs.Tab, null, "Tab Label 3")), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanels, null, /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, {
      className: "custom-class"
    }, "Tab Panel 1"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 2"), /*#__PURE__*/_react.default.createElement(_Tabs.TabPanel, null, "Tab Panel 3"))));
    expect(_react2.screen.getByText('Tab Panel 1')).toHaveClass('custom-class');
  });
});