"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _carbonComponents = require("carbon-components");

var _iconsReact = require("@carbon/icons-react");

var _useNormalizedInputProps = require("../../internal/useNormalizedInputProps");

var _util = require("./util");

var _FluidForm = require("../FluidForm");

var _excluded = ["labelText", "className", "disabled", "id", "placeholder", "onChange", "onClick", "hideLabel", "inline", "invalid", "invalidText", "helperText", "light", "tooltipPosition", "tooltipAlignment", "type", "hidePasswordLabel", "showPasswordLabel", "size", "onTogglePasswordVisibility", "warn", "warnText"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var prefix = _carbonComponents.settings.prefix;

var PasswordInput = /*#__PURE__*/_react.default.forwardRef(function PasswordInput(_ref, ref) {
  var _classNames, _classNames2, _classNames3, _classNames4, _classNames7, _classNames8;

  var labelText = _ref.labelText,
      className = _ref.className,
      disabled = _ref.disabled,
      id = _ref.id,
      placeholder = _ref.placeholder,
      _onChange = _ref.onChange,
      _onClick = _ref.onClick,
      hideLabel = _ref.hideLabel,
      inline = _ref.inline,
      invalid = _ref.invalid,
      invalidText = _ref.invalidText,
      helperText = _ref.helperText,
      light = _ref.light,
      _ref$tooltipPosition = _ref.tooltipPosition,
      tooltipPosition = _ref$tooltipPosition === void 0 ? 'bottom' : _ref$tooltipPosition,
      _ref$tooltipAlignment = _ref.tooltipAlignment,
      tooltipAlignment = _ref$tooltipAlignment === void 0 ? 'center' : _ref$tooltipAlignment,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? 'password' : _ref$type,
      _ref$hidePasswordLabe = _ref.hidePasswordLabel,
      hidePasswordLabel = _ref$hidePasswordLabe === void 0 ? 'Hide password' : _ref$hidePasswordLabe,
      _ref$showPasswordLabe = _ref.showPasswordLabel,
      showPasswordLabel = _ref$showPasswordLabe === void 0 ? 'Show password' : _ref$showPasswordLabe,
      size = _ref.size,
      onTogglePasswordVisibility = _ref.onTogglePasswordVisibility,
      warn = _ref.warn,
      warnText = _ref.warnText,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useState = (0, _react.useState)(type),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      inputType = _useState2[0],
      setInputType = _useState2[1];

  var normalizedProps = (0, _useNormalizedInputProps.useNormalizedInputProps)({
    id: id,
    invalid: invalid,
    invalidText: invalidText,
    warn: warn,
    warnText: warnText
  });

  var handleTogglePasswordVisibility = function handleTogglePasswordVisibility(event) {
    setInputType(inputType === 'password' ? 'text' : 'password');
    onTogglePasswordVisibility && onTogglePasswordVisibility(event);
  };

  var textInputClasses = (0, _classnames.default)("".concat(prefix, "--text-input"), "".concat(prefix, "--password-input"), className, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--text-input--light"), light), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--text-input--invalid"), normalizedProps.invalid), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--text-input--warning"), normalizedProps.warn), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--text-input--").concat(size), size), _classNames));

  var sharedTextInputProps = _objectSpread({
    id: id,
    onChange: function onChange(evt) {
      if (!disabled) {
        _onChange(evt);
      }
    },
    onClick: function onClick(evt) {
      if (!disabled) {
        _onClick(evt);
      }
    },
    placeholder: placeholder,
    type: inputType,
    className: textInputClasses,
    ref: ref
  }, other);

  var inputWrapperClasses = (0, _classnames.default)("".concat(prefix, "--form-item"), "".concat(prefix, "--text-input-wrapper"), "".concat(prefix, "--password-input-wrapper"), (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--text-input-wrapper--light"), light), (0, _defineProperty2.default)(_classNames2, "".concat(prefix, "--text-input-wrapper--inline"), inline), _classNames2));
  var labelClasses = (0, _classnames.default)("".concat(prefix, "--label"), (_classNames3 = {}, (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--visually-hidden"), hideLabel), (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--label--disabled"), disabled), (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--label--inline"), inline), (0, _defineProperty2.default)(_classNames3, "".concat(prefix, "--label--inline--").concat(size), inline && !!size), _classNames3));
  var helperTextClasses = (0, _classnames.default)("".concat(prefix, "--form__helper-text"), (_classNames4 = {}, (0, _defineProperty2.default)(_classNames4, "".concat(prefix, "--form__helper-text--disabled"), disabled), (0, _defineProperty2.default)(_classNames4, "".concat(prefix, "--form__helper-text--inline"), inline), _classNames4));
  var fieldOuterWrapperClasses = (0, _classnames.default)("".concat(prefix, "--text-input__field-outer-wrapper"), (0, _defineProperty2.default)({}, "".concat(prefix, "--text-input__field-outer-wrapper--inline"), inline));
  var fieldWrapperClasses = (0, _classnames.default)("".concat(prefix, "--text-input__field-wrapper"), (0, _defineProperty2.default)({}, "".concat(prefix, "--text-input__field-wrapper--warning"), normalizedProps.warn));
  var iconClasses = (0, _classnames.default)((_classNames7 = {}, (0, _defineProperty2.default)(_classNames7, "".concat(prefix, "--text-input__invalid-icon"), normalizedProps.invalid || normalizedProps.warn), (0, _defineProperty2.default)(_classNames7, "".concat(prefix, "--text-input__invalid-icon--warning"), normalizedProps.warn), _classNames7));
  var label = labelText ? /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: id,
    className: labelClasses
  }, labelText) : null;
  var helper = helperText ? /*#__PURE__*/_react.default.createElement("div", {
    className: helperTextClasses
  }, helperText) : null;
  var passwordIsVisible = inputType === 'text';
  var passwordVisibilityIcon = passwordIsVisible ? /*#__PURE__*/_react.default.createElement(_iconsReact.ViewOff16, {
    className: "".concat(prefix, "--icon-visibility-off")
  }) : /*#__PURE__*/_react.default.createElement(_iconsReact.View16, {
    className: "".concat(prefix, "--icon-visibility-on")
  });
  var passwordVisibilityToggleClasses = (0, _classnames.default)("".concat(prefix, "--text-input--password__visibility__toggle"), "".concat(prefix, "--btn"), "".concat(prefix, "--btn--icon-only"), "".concat(prefix, "--tooltip__trigger"), "".concat(prefix, "--tooltip--a11y"), (_classNames8 = {}, (0, _defineProperty2.default)(_classNames8, "".concat(prefix, "--btn--disabled"), disabled), (0, _defineProperty2.default)(_classNames8, "".concat(prefix, "--tooltip--").concat(tooltipPosition), tooltipPosition), (0, _defineProperty2.default)(_classNames8, "".concat(prefix, "--tooltip--align-").concat(tooltipAlignment), tooltipAlignment), _classNames8));

  var input = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, (0, _util.textInputProps)({
    sharedTextInputProps: sharedTextInputProps,
    invalid: normalizedProps.invalid,
    invalidId: normalizedProps.invalidId,
    warn: normalizedProps.warn,
    warnId: normalizedProps.warnId
  }), {
    disabled: disabled,
    "data-toggle-password-visibility": inputType === 'password'
  })), /*#__PURE__*/_react.default.createElement("button", {
    type: "button",
    className: passwordVisibilityToggleClasses,
    disabled: disabled,
    onClick: handleTogglePasswordVisibility
  }, !disabled && /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--assistive-text")
  }, passwordIsVisible ? hidePasswordLabel : showPasswordLabel), passwordVisibilityIcon));

  var _useContext = (0, _react.useContext)(_FluidForm.FormContext),
      isFluid = _useContext.isFluid;

  (0, _react.useEffect)(function () {
    setInputType(type);
  }, [type]);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: inputWrapperClasses
  }, !inline ? label : /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--text-input__label-helper-wrapper")
  }, label, !isFluid && helper), /*#__PURE__*/_react.default.createElement("div", {
    className: fieldOuterWrapperClasses
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: fieldWrapperClasses,
    "data-invalid": normalizedProps.invalid || null
  }, normalizedProps.icon && /*#__PURE__*/_react.default.createElement(normalizedProps.icon, {
    className: iconClasses
  }), input, isFluid && !inline && normalizedProps.validation), !isFluid && !inline && (normalizedProps.validation || helper)));
});

PasswordInput.displayName = 'PasswordInput';
PasswordInput.propTypes = {
  /**
   * Provide a custom className that is applied directly to the underlying
   * `<input>` node
   */
  className: _propTypes.default.string,

  /**
   * Optionally provide the default value of the `<input>`
   */
  defaultValue: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the control is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: _propTypes.default.node,

  /**
   * Specify whether or not the underlying label is visually hidden
   */
  hideLabel: _propTypes.default.bool,

  /**
   * "Hide password" tooltip text on password visibility toggle
   */
  hidePasswordLabel: _propTypes.default.string,

  /**
   * Provide a unique identifier for the input field
   */
  id: _propTypes.default.string.isRequired,

  /**
   * `true` to use the inline version.
   */
  inline: _propTypes.default.bool,

  /**
   * Specify whether the control is currently invalid
   */
  invalid: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in an invalid state
   */
  invalidText: _propTypes.default.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: _propTypes.default.bool,

  /**
   * Optionally provide an `onChange` handler that is called whenever `<input>`
   * is updated
   */
  onChange: _propTypes.default.func,

  /**
   * Optionally provide an `onClick` handler that is called whenever the
   * `<input>` is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Callback function that is called whenever the toggle password visibility
   * button is clicked
   */
  onTogglePasswordVisibility: _propTypes.default.func,

  /**
   * Specify the placeholder attribute for the `<input>`
   */
  placeholder: _propTypes.default.string,

  /**
   * "Show password" tooltip text on password visibility toggle
   */
  showPasswordLabel: _propTypes.default.string,

  /**
   * Specify the size of the Text Input. Currently supports either `small` or `large` as an option. If omitted, defaults to standard size
   */
  size: _propTypes.default.string,

  /**
   * Specify the alignment of the tooltip to the icon-only button.
   * Can be one of: start, center, or end.
   */
  tooltipAlignment: _propTypes.default.oneOf(['start', 'center', 'end']),

  /**
   * Specify the direction of the tooltip for icon-only buttons.
   * Can be either top, right, bottom, or left.
   */
  tooltipPosition: _propTypes.default.oneOf(['top', 'right', 'bottom', 'left']),

  /**
   * The input type, either password or text
   */
  type: _propTypes.default.oneOf(['password', 'text']),

  /**
   * Provide the current value of the `<input>`
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]),

  /**
   * Specify whether the control is currently in warning state
   */
  warn: _propTypes.default.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: _propTypes.default.node
};
PasswordInput.defaultProps = {
  className: '${prefix}--text__input',
  disabled: false,
  onChange: function onChange() {},
  onClick: function onClick() {},
  invalid: false,
  invalidText: '',
  helperText: '',
  light: false,
  size: ''
};
var _default = PasswordInput;
exports.default = _default;