"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.WithLayer = exports.UseTheme = exports.Default = exports.default = void 0;

require("./Theme-story.scss");

var _react = _interopRequireDefault(require("react"));

var _Theme = require("../../Theme");

var _Layer = require("../../Layer");

var _Theme2 = _interopRequireDefault(require("./Theme.mdx"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/Theme',
  component: _Theme.Theme,
  parameters: {
    controls: {
      hideNoControlsWarning: true
    },
    docs: {
      page: _Theme2.default
    }
  },
  argTypes: {
    as: {
      table: {
        disable: true
      }
    },
    children: {
      table: {
        disable: true
      }
    },
    theme: {
      defaultValue: 'g10'
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_Theme.Theme, {
    theme: "g100"
  }, /*#__PURE__*/_react.default.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/_react.default.createElement("p", null, "g100 theme"))), /*#__PURE__*/_react.default.createElement(_Theme.Theme, {
    theme: "g90"
  }, /*#__PURE__*/_react.default.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/_react.default.createElement("p", null, "g90 theme"))), /*#__PURE__*/_react.default.createElement(_Theme.Theme, {
    theme: "g10"
  }, /*#__PURE__*/_react.default.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/_react.default.createElement("p", null, "g10 theme"))), /*#__PURE__*/_react.default.createElement(_Theme.Theme, {
    theme: "white"
  }, /*#__PURE__*/_react.default.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/_react.default.createElement("p", null, "white theme"))));
};

exports.Default = Default;

var UseTheme = function UseTheme() {
  function Example() {
    var _useTheme = (0, _Theme.useTheme)(),
        theme = _useTheme.theme;

    return /*#__PURE__*/_react.default.createElement("div", {
      className: "theme-section"
    }, "The current theme is: ", theme);
  }

  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(Example, null), /*#__PURE__*/_react.default.createElement(_Theme.Theme, {
    theme: "g100"
  }, /*#__PURE__*/_react.default.createElement(Example, null)));
};

exports.UseTheme = UseTheme;
UseTheme.storyName = 'useTheme';

var WithLayer = function WithLayer() {
  function Layers() {
    var _useTheme2 = (0, _Theme.useTheme)(),
        theme = _useTheme2.theme;

    return /*#__PURE__*/_react.default.createElement("article", {
      className: "theme-layer-example"
    }, /*#__PURE__*/_react.default.createElement("header", {
      className: "theme-layer-header"
    }, theme, " theme"), /*#__PURE__*/_react.default.createElement("div", {
      className: "theme-with-layer"
    }, "Layer one"), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "theme-with-layer"
    }, "Layer two"), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement("div", {
      className: "theme-with-layer"
    }, "Layer three"))));
  }

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(Layers, null), /*#__PURE__*/_react.default.createElement(_Theme.Theme, {
    theme: "g10"
  }, /*#__PURE__*/_react.default.createElement(Layers, null), /*#__PURE__*/_react.default.createElement(_Theme.Theme, {
    theme: "g90"
  }, /*#__PURE__*/_react.default.createElement(Layers, null), /*#__PURE__*/_react.default.createElement(_Theme.Theme, {
    theme: "g100"
  }, /*#__PURE__*/_react.default.createElement(Layers, null)))));
};

exports.WithLayer = WithLayer;

var PlaygroundStory = function PlaygroundStory(args) {
  return /*#__PURE__*/_react.default.createElement(_Theme.Theme, args, /*#__PURE__*/_react.default.createElement("section", {
    className: "theme-section"
  }, /*#__PURE__*/_react.default.createElement("p", null, args.theme, " theme")));
};

var Playground = PlaygroundStory.bind({});
exports.Playground = Playground;