"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableTile = ExpandableTile;
exports.TileBelowTheFoldContent = exports.TileAboveTheFoldContent = exports.SelectableTile = exports.ClickableTile = exports.Tile = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _Link = _interopRequireDefault(require("../../Link"));

var _keyboard = require("../../../internal/keyboard");

var _deprecate = _interopRequireDefault(require("../../../prop-types/deprecate"));

var _events = require("../../../tools/events");

var _usePrefix = require("../../../internal/usePrefix");

var _useIsomorphicEffect = _interopRequireDefault(require("../../../internal/useIsomorphicEffect"));

var _excluded = ["children", "className", "light"],
    _excluded2 = ["children", "className", "clicked", "handleClick", "handleKeyDown", "href", "light", "onClick", "onKeyDown"],
    _excluded3 = ["children", "className", "disabled", "handleClick", "handleKeyDown", "iconDescription", "id", "light", "name", "onClick", "onChange", "onKeyDown", "selected", "tabIndex", "title", "value"],
    _excluded4 = ["tabIndex", "className", "children", "expanded", "tileMaxHeight", "tilePadding", "onClick", "onKeyUp", "tileCollapsedIconText", "tileExpandedIconText", "tileCollapsedLabel", "tileExpandedLabel", "onBeforeClick", "light"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

var Tile = /*#__PURE__*/_react.default.forwardRef(function Tile(_ref, ref) {
  var children = _ref.children,
      className = _ref.className,
      _ref$light = _ref.light,
      light = _ref$light === void 0 ? false : _ref$light,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var tileClasses = (0, _classnames.default)("".concat(prefix, "--tile"), (0, _defineProperty2.default)({}, "".concat(prefix, "--tile--light"), light), className);
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
    className: tileClasses,
    ref: ref
  }, rest), children);
});

exports.Tile = Tile;
Tile.displayName = 'Tile';
Tile.propTypes = {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: (0, _deprecate.default)(_propTypes.default.bool, 'The `light` prop for `Tile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.')
};

var ClickableTile = /*#__PURE__*/_react.default.forwardRef(function ClickableTile(_ref2, ref) {
  var _cx2;

  var children = _ref2.children,
      className = _ref2.className,
      _ref2$clicked = _ref2.clicked,
      clicked = _ref2$clicked === void 0 ? false : _ref2$clicked,
      handleClick = _ref2.handleClick,
      handleKeyDown = _ref2.handleKeyDown,
      href = _ref2.href,
      _ref2$light = _ref2.light,
      light = _ref2$light === void 0 ? false : _ref2$light,
      _ref2$onClick = _ref2.onClick,
      onClick = _ref2$onClick === void 0 ? function () {} : _ref2$onClick,
      _ref2$onKeyDown = _ref2.onKeyDown,
      onKeyDown = _ref2$onKeyDown === void 0 ? function () {} : _ref2$onKeyDown,
      rest = (0, _objectWithoutProperties2.default)(_ref2, _excluded2);
  var prefix = (0, _usePrefix.usePrefix)();
  var classes = (0, _classnames.default)("".concat(prefix, "--tile"), "".concat(prefix, "--tile--clickable"), (_cx2 = {}, (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--tile--is-clicked"), clicked), (0, _defineProperty2.default)(_cx2, "".concat(prefix, "--tile--light"), light), _cx2), className);

  var _useState = (0, _react.useState)(clicked),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      isSelected = _useState2[0],
      setIsSelected = _useState2[1]; // TODO: replace with onClick when handleClick prop is deprecated


  var clickHandler = handleClick || onClick; // TODO: replace with onClick when handleClick prop is deprecated

  var keyDownHandler = handleKeyDown || onKeyDown;

  function handleOnClick(evt) {
    evt.persist();
    setIsSelected(!isSelected);
    clickHandler(evt);
  }

  function handleOnKeyDown(evt) {
    evt.persist();

    if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
      evt.preventDefault();
      setIsSelected(!isSelected);
      keyDownHandler(evt);
    }

    keyDownHandler(evt);
  }

  return /*#__PURE__*/_react.default.createElement(_Link.default, (0, _extends2.default)({
    className: classes,
    href: href,
    onClick: handleOnClick,
    onKeyDown: handleOnKeyDown,
    ref: ref
  }, rest), children);
});

exports.ClickableTile = ClickableTile;
ClickableTile.displayName = 'ClickableTile';
ClickableTile.propTypes = {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * Boolean for whether a tile has been clicked.
   */
  clicked: _propTypes.default.bool,

  /**
   * Deprecated in v11. Use 'onClick' instead.
   */
  handleClick: (0, _deprecate.default)(_propTypes.default.func, 'The handleClick prop for ClickableTile has been deprecated in favor of onClick. It will be removed in the next major release.'),

  /**
   * Specify the function to run when the ClickableTile is interacted with via a keyboard
   */
  handleKeyDown: (0, _deprecate.default)(_propTypes.default.func, 'The handleKeyDown prop for ClickableTile has been deprecated in favor of onKeyDown. It will be removed in the next major release.'),

  /**
   * The href for the link.
   */
  href: _propTypes.default.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: (0, _deprecate.default)(_propTypes.default.bool, 'The `light` prop for `ClickableTile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.'),

  /**
   * Specify the function to run when the ClickableTile is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the function to run when the ClickableTile is interacted with via a keyboard
   */
  onKeyDown: _propTypes.default.func,

  /**
   * The rel property for the link.
   */
  rel: _propTypes.default.string
};

var SelectableTile = /*#__PURE__*/_react.default.forwardRef(function SelectableTile(_ref3, ref) {
  var _cx3;

  var children = _ref3.children,
      className = _ref3.className,
      disabled = _ref3.disabled,
      handleClick = _ref3.handleClick,
      handleKeyDown = _ref3.handleKeyDown,
      iconDescription = _ref3.iconDescription,
      id = _ref3.id,
      _ref3$light = _ref3.light,
      light = _ref3$light === void 0 ? false : _ref3$light,
      name = _ref3.name,
      _ref3$onClick = _ref3.onClick,
      onClick = _ref3$onClick === void 0 ? function () {} : _ref3$onClick,
      _ref3$onChange = _ref3.onChange,
      onChange = _ref3$onChange === void 0 ? function () {} : _ref3$onChange,
      _ref3$onKeyDown = _ref3.onKeyDown,
      onKeyDown = _ref3$onKeyDown === void 0 ? function () {} : _ref3$onKeyDown,
      _ref3$selected = _ref3.selected,
      selected = _ref3$selected === void 0 ? false : _ref3$selected,
      _ref3$tabIndex = _ref3.tabIndex,
      tabIndex = _ref3$tabIndex === void 0 ? 0 : _ref3$tabIndex,
      _ref3$title = _ref3.title,
      title = _ref3$title === void 0 ? 'title' : _ref3$title,
      _ref3$value = _ref3.value,
      value = _ref3$value === void 0 ? 'value' : _ref3$value,
      rest = (0, _objectWithoutProperties2.default)(_ref3, _excluded3);
  var prefix = (0, _usePrefix.usePrefix)(); // TODO: replace with onClick when handleClick prop is deprecated

  var clickHandler = handleClick || onClick; // TODO: replace with onKeyDown when handleKeyDown prop is deprecated

  var keyDownHandler = handleKeyDown || onKeyDown;

  var _useState3 = (0, _react.useState)(selected),
      _useState4 = (0, _slicedToArray2.default)(_useState3, 2),
      isSelected = _useState4[0],
      setIsSelected = _useState4[1];

  var _useState5 = (0, _react.useState)(selected),
      _useState6 = (0, _slicedToArray2.default)(_useState5, 2),
      prevSelected = _useState6[0],
      setPrevSelected = _useState6[1];

  var classes = (0, _classnames.default)("".concat(prefix, "--tile"), "".concat(prefix, "--tile--selectable"), (_cx3 = {}, (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--tile--is-selected"), isSelected), (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--tile--light"), light), (0, _defineProperty2.default)(_cx3, "".concat(prefix, "--tile--disabled"), disabled), _cx3), className);
  var inputClasses = (0, _classnames.default)("".concat(prefix, "--tile-input"), (0, _defineProperty2.default)({}, "".concat(prefix, "--tile-input--checked"), isSelected)); // TODO: rename to handleClick when handleClick prop is deprecated

  function handleOnClick(evt) {
    evt.preventDefault();
    evt.persist();
    setIsSelected(!isSelected);
    clickHandler(evt);
    onChange(evt);
  } // TODO: rename to handleKeyDown when handleKeyDown prop is deprecated


  function handleOnKeyDown(evt) {
    evt.persist();

    if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
      evt.preventDefault();
      setIsSelected(!isSelected);
      onChange(evt);
    }

    keyDownHandler(evt);
  }

  function handleChange(event) {
    setIsSelected(event.target.checked);
    onChange(event);
  }

  if (selected !== prevSelected) {
    setIsSelected(selected);
    setPrevSelected(selected);
  }

  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("input", {
    checked: isSelected,
    className: inputClasses,
    disabled: disabled,
    id: id,
    name: name,
    onChange: !disabled ? handleChange : null,
    ref: ref,
    tabIndex: -1,
    title: title,
    type: "checkbox",
    value: value
  }), /*#__PURE__*/_react.default.createElement("label", (0, _extends2.default)({
    className: classes,
    htmlFor: id,
    onClick: !disabled ? handleOnClick : null,
    onKeyDown: !disabled ? handleOnKeyDown : null // eslint-disable-next-line jsx-a11y/no-noninteractive-tabindex
    ,
    tabIndex: !disabled ? tabIndex : null
  }, rest), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--tile__checkmark ").concat(prefix, "--tile__checkmark--persistent")
  }, isSelected ? /*#__PURE__*/_react.default.createElement(_iconsReact.CheckboxCheckedFilled16, null) : /*#__PURE__*/_react.default.createElement(_iconsReact.Checkbox16, null)), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--tile-content")
  }, children)));
});

exports.SelectableTile = SelectableTile;
SelectableTile.displayName = 'SelectableTile';
SelectableTile.propTypes = {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the SelectableTile should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  handleClick: (0, _deprecate.default)(_propTypes.default.func, 'The `handleClick` prop for `SelectableTile` has been deprecated in favor of `onClick`. It will be removed in the next major release.'),

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  handleKeyDown: (0, _deprecate.default)(_propTypes.default.func, 'The `handleKeyDown` prop for `SelectableTile` has been deprecated in favor of `onKeyDown`. It will be removed in the next major release.'),

  /**
   * The description of the checkmark icon.
   */
  iconDescription: (0, _deprecate.default)(_propTypes.default.string, 'The `iconDescription` prop for `SelectableTile` is no longer needed and has ' + 'been deprecated. It will be removed in the next major release.'),

  /**
   * The ID of the `<input>`.
   */
  id: _propTypes.default.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: (0, _deprecate.default)(_propTypes.default.bool, 'The `light` prop for `SelectableTile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.'),

  /**
   * The `name` of the `<input>`.
   */
  name: _propTypes.default.string,

  /**
   * The empty handler of the `<input>`.
   */
  onChange: _propTypes.default.func,

  /**
   * Specify the function to run when the SelectableTile is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Specify the function to run when the SelectableTile is interacted with via a keyboard
   */
  onKeyDown: _propTypes.default.func,

  /**
   * `true` to select this tile.
   */
  selected: _propTypes.default.bool,

  /**
   * Specify the tab index of the wrapper element
   */
  tabIndex: _propTypes.default.number,

  /**
   * The `title` of the `<input>`.
   */
  title: _propTypes.default.string,

  /**
   * The value of the `<input>`.
   */
  value: _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.number]).isRequired
};

function ExpandableTile(_ref4) {
  var _cx5;

  var tabIndex = _ref4.tabIndex,
      className = _ref4.className,
      children = _ref4.children,
      expanded = _ref4.expanded,
      tileMaxHeight = _ref4.tileMaxHeight,
      tilePadding = _ref4.tilePadding,
      onClick = _ref4.onClick,
      onKeyUp = _ref4.onKeyUp,
      tileCollapsedIconText = _ref4.tileCollapsedIconText,
      tileExpandedIconText = _ref4.tileExpandedIconText,
      tileCollapsedLabel = _ref4.tileCollapsedLabel,
      tileExpandedLabel = _ref4.tileExpandedLabel,
      onBeforeClick = _ref4.onBeforeClick,
      light = _ref4.light,
      rest = (0, _objectWithoutProperties2.default)(_ref4, _excluded4);

  var _useState7 = (0, _react.useState)(tileMaxHeight),
      _useState8 = (0, _slicedToArray2.default)(_useState7, 2),
      isTileMaxHeight = _useState8[0],
      setIsTileMaxHeight = _useState8[1];

  var _useState9 = (0, _react.useState)(tilePadding),
      _useState10 = (0, _slicedToArray2.default)(_useState9, 2),
      isTilePadding = _useState10[0],
      setIsTilePadding = _useState10[1];

  var _useState11 = (0, _react.useState)(expanded),
      _useState12 = (0, _slicedToArray2.default)(_useState11, 2),
      prevExpanded = _useState12[0],
      setPrevExpanded = _useState12[1];

  var _useState13 = (0, _react.useState)(tileMaxHeight),
      _useState14 = (0, _slicedToArray2.default)(_useState13, 2),
      prevTileMaxHeight = _useState14[0],
      setPrevTileMaxHeight = _useState14[1];

  var _useState15 = (0, _react.useState)(tilePadding),
      _useState16 = (0, _slicedToArray2.default)(_useState15, 2),
      prevTilePadding = _useState16[0],
      setPrevTilePadding = _useState16[1];

  var _useState17 = (0, _react.useState)(expanded),
      _useState18 = (0, _slicedToArray2.default)(_useState17, 2),
      isExpanded = _useState18[0],
      setIsExpanded = _useState18[1];

  var aboveTheFold = (0, _react.useRef)(null);
  var tileContent = (0, _react.useRef)(null);
  var tile = (0, _react.useRef)(null);
  var prefix = (0, _usePrefix.usePrefix)();

  if (expanded !== prevExpanded) {
    setIsExpanded(expanded);
    setPrevExpanded(expanded);
    setMaxHeight();
  }

  if (tileMaxHeight !== prevTileMaxHeight) {
    setIsTileMaxHeight(tileMaxHeight);
    setPrevTileMaxHeight(tileMaxHeight);
  }

  if (tilePadding !== prevTilePadding) {
    setIsTilePadding(tilePadding);
    setPrevTilePadding(tilePadding);
  }

  function setMaxHeight() {
    if (isExpanded) {
      setIsTileMaxHeight(tileContent.current.getBoundingClientRect().height);
    }

    setIsTileMaxHeight(aboveTheFold.current.getBoundingClientRect().height);
  }

  function handleClick(evt) {
    if (!onBeforeClick(evt) || evt.target.tagName === 'INPUT') {
      return;
    }

    evt.persist();
    setIsExpanded(!isExpanded);
    setMaxHeight();

    if (onClick) {
      onClick(evt);
    }
  }

  function handleKeyUp(evt) {
    if (evt.target !== tile.current) {
      if ((0, _keyboard.matches)(evt, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
        evt.preventDefault();
      }
    }
  }

  function getChildren() {
    return _react.default.Children.toArray(children);
  }

  var classes = (0, _classnames.default)("".concat(prefix, "--tile"), "".concat(prefix, "--tile--expandable"), (_cx5 = {}, (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--tile--is-expanded"), isExpanded), (0, _defineProperty2.default)(_cx5, "".concat(prefix, "--tile--light"), light), _cx5), className);
  var tileStyle = {
    maxHeight: isExpanded ? null : isTileMaxHeight + isTilePadding
  };
  var childrenAsArray = getChildren();
  (0, _useIsomorphicEffect.default)(function () {
    var getStyle = window.getComputedStyle(tile.current, null);
    var node = aboveTheFold.current;

    var _node$getBoundingClie = node.getBoundingClientRect(),
        height = _node$getBoundingClie.height;

    var paddingTop = parseInt(getStyle.getPropertyValue('padding-top'), 10);
    var paddingBottom = parseInt(getStyle.getPropertyValue('padding-bottom'), 10);
    setIsTileMaxHeight(height);
    setIsTilePadding(paddingTop + paddingBottom);
  }, []);
  (0, _react.useEffect)(function () {
    var resizeObserver = new ResizeObserver(function (entries) {
      var _entries = (0, _slicedToArray2.default)(entries, 1),
          aboveTheFold = _entries[0];

      setIsTileMaxHeight(aboveTheFold.contentRect.height);
    });
    resizeObserver.observe(aboveTheFold.current);
    return function () {
      return resizeObserver.disconnect();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({
    type: "button",
    ref: tile,
    style: tileStyle,
    className: classes,
    "aria-expanded": isExpanded,
    title: isExpanded ? tileExpandedIconText : tileCollapsedIconText
  }, rest, {
    onKeyUp: (0, _events.composeEventHandlers)([onKeyUp, handleKeyUp]),
    onClick: (0, _events.composeEventHandlers)([onClick, handleClick]),
    tabIndex: tabIndex
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: tileContent
  }, /*#__PURE__*/_react.default.createElement("div", {
    ref: aboveTheFold,
    className: "".concat(prefix, "--tile-content")
  }, childrenAsArray[0]), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tile__chevron")
  }, /*#__PURE__*/_react.default.createElement("span", null, isExpanded ? tileExpandedLabel : tileCollapsedLabel), /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronDown16, null)), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--tile-content")
  }, childrenAsArray[1])));
}

ExpandableTile.propTypes = {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * `true` if the tile is expanded.
   */
  expanded: _propTypes.default.bool,

  /**
   * An ID that can be provided to aria-labelledby
   */
  id: _propTypes.default.string,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: (0, _deprecate.default)(_propTypes.default.bool, 'The `light` prop for `ExpandableTile` is no longer needed and has been deprecated. It will be removed in the next major release. Use the Layer component instead.'),

  /**
   * optional handler to decide whether to ignore a click. returns false if click should be ignored
   */
  onBeforeClick: _propTypes.default.func,

  /**
   * Specify the function to run when the ExpandableTile is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * optional handler to trigger a function when a key is pressed
   */
  onKeyUp: _propTypes.default.func,

  /**
   * The `tabindex` attribute.
   */
  tabIndex: _propTypes.default.number,

  /**
   * The description of the "collapsed" icon that can be read by screen readers.
   */
  tileCollapsedIconText: _propTypes.default.string,

  /**
   * When "collapsed", a label to appear next to the chevron (e.g., "View more").
   */
  tileCollapsedLabel: _propTypes.default.string,

  /**
   * The description of the "expanded" icon that can be read by screen readers.
   */
  tileExpandedIconText: _propTypes.default.string,

  /**
   * When "expanded", a label to appear next to the chevron (e.g., "View less").
   */
  tileExpandedLabel: _propTypes.default.string
};
ExpandableTile.defaultProps = {
  tabIndex: 0,
  expanded: false,
  tileMaxHeight: 0,
  tilePadding: 0,
  onBeforeClick: function onBeforeClick() {
    return true;
  },
  onClick: function onClick() {},
  tileCollapsedIconText: 'Interact to expand Tile',
  tileExpandedIconText: 'Interact to collapse Tile'
};
ExpandableTile.displayName = 'ExpandableTile';

var TileAboveTheFoldContent = /*#__PURE__*/_react.default.forwardRef(function TilAboveTheFoldContent(_ref5, ref) {
  var children = _ref5.children;
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement("span", {
    ref: ref,
    className: "".concat(prefix, "--tile-content__above-the-fold")
  }, children);
});

exports.TileAboveTheFoldContent = TileAboveTheFoldContent;
TileAboveTheFoldContent.propTypes = {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node
};
TileAboveTheFoldContent.displayName = 'TileAboveTheFoldContent';

var TileBelowTheFoldContent = /*#__PURE__*/_react.default.forwardRef(function TileBelowTheFoldContent(_ref6, ref) {
  var children = _ref6.children;
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement("span", {
    ref: ref,
    className: "".concat(prefix, "--tile-content__below-the-fold")
  }, children);
});

exports.TileBelowTheFoldContent = TileBelowTheFoldContent;
TileBelowTheFoldContent.propTypes = {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node
};
TileBelowTheFoldContent.displayName = 'TileBelowTheFoldContent';