"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandableWithLayer = exports.Expandable = exports.RadioWithLayer = exports.Radio = exports.SelectableWithLayer = exports.MultiSelect = exports.ClickableWithLayer = exports.Clickable = exports.DefaultWithLayer = exports.Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Link = _interopRequireDefault(require("../../Link"));

var _TextInput = _interopRequireDefault(require("../../TextInput"));

var _RadioTile = _interopRequireDefault(require("../../RadioTile"));

var _ = require("../");

var _TileGroup = _interopRequireDefault(require("../../TileGroup"));

var _Layer = require("../../Layer");

require("./tile-story.scss");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/Tile',
  parameters: {
    component: _.Tile,
    subcomponents: {
      ClickableTile: _.ClickableTile,
      SelectableTile: _.SelectableTile,
      ExpandableTile: _.ExpandableTile,
      RadioTile: _RadioTile.default,
      TileGroup: _TileGroup.default,
      TileAboveTheFoldContent: _.TileAboveTheFoldContent,
      TileBelowTheFoldContent: _.TileBelowTheFoldContent
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_.Tile, null, "Default tile", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Link.default, {
    href: "https://www.carbondesignsystem.com"
  }, "Link"));
};

exports.Default = Default;

var DefaultWithLayer = function DefaultWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.Tile, null, "First layer", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Link.default, {
    href: "https://www.carbondesignsystem.com"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.Tile, null, "Second layer", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Link.default, {
    href: "https://www.carbondesignsystem.com"
  }, "Link")), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.Tile, null, "Third layer", /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_Link.default, {
    href: "https://www.carbondesignsystem.com"
  }, "Link")))));
};

exports.DefaultWithLayer = DefaultWithLayer;

var Clickable = function Clickable() {
  return /*#__PURE__*/_react.default.createElement(_.ClickableTile, null, "Clickable Tile");
};

exports.Clickable = Clickable;

var ClickableWithLayer = function ClickableWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.ClickableTile, null, "First layer"), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.ClickableTile, null, "Second layer"), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.ClickableTile, null, "Third layer"))));
};

exports.ClickableWithLayer = ClickableWithLayer;

var MultiSelect = function MultiSelect() {
  return /*#__PURE__*/_react.default.createElement("div", {
    role: "group",
    "aria-label": "selectable tiles"
  }, /*#__PURE__*/_react.default.createElement(_.SelectableTile, {
    id: "tile-1",
    name: "tiles"
  }, "Option 1"), /*#__PURE__*/_react.default.createElement(_.SelectableTile, {
    id: "tile-2",
    name: "tiles"
  }, "Option 2"), /*#__PURE__*/_react.default.createElement(_.SelectableTile, {
    id: "tile-3",
    name: "tiles"
  }, "Option 3"));
};

exports.MultiSelect = MultiSelect;

var SelectableWithLayer = function SelectableWithLayer() {
  /*#__PURE__*/
  _react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.SelectableTile, {
    id: "tile-3",
    name: "tiles"
  }, "First layer"), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.SelectableTile, {
    id: "tile-3",
    name: "tiles"
  }, "Second layer"), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.SelectableTile, {
    id: "tile-3",
    name: "tiles"
  }, "Third layer"))));
};

exports.SelectableWithLayer = SelectableWithLayer;

var Radio = function Radio() {
  return /*#__PURE__*/_react.default.createElement(_TileGroup.default, {
    defaultSelected: "default-selected",
    legend: "Radio Tile Group",
    name: "radio tile group"
  }, /*#__PURE__*/_react.default.createElement(_RadioTile.default, {
    value: "standard",
    style: {
      marginBottom: '.5rem'
    }
  }, "Option 1"), /*#__PURE__*/_react.default.createElement(_RadioTile.default, {
    value: "default-selected",
    id: "tile-2"
  }, "Option 2"), /*#__PURE__*/_react.default.createElement(_RadioTile.default, {
    value: "selected",
    id: "tile-3"
  }, "Option 3"));
};

exports.Radio = Radio;

var RadioWithLayer = function RadioWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_TileGroup.default, {
    defaultSelected: "default-selected",
    legend: "First layer",
    name: "radio tile group"
  }, /*#__PURE__*/_react.default.createElement(_RadioTile.default, {
    value: "standard",
    style: {
      marginBottom: '.5rem'
    }
  }, "Option 1"), /*#__PURE__*/_react.default.createElement(_RadioTile.default, {
    value: "default-selected",
    id: "tile-2"
  }, "Option 2")), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_TileGroup.default, {
    defaultSelected: "default-selected",
    legend: "Second Layer",
    name: "radio tile group"
  }, /*#__PURE__*/_react.default.createElement(_RadioTile.default, {
    value: "standard",
    style: {
      marginBottom: '.5rem'
    }
  }, "Option 1"), /*#__PURE__*/_react.default.createElement(_RadioTile.default, {
    value: "default-selected",
    id: "tile-2"
  }, "Option 2")), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_TileGroup.default, {
    defaultSelected: "default-selected",
    legend: "Third Layer",
    name: "radio tile group"
  }, /*#__PURE__*/_react.default.createElement(_RadioTile.default, {
    value: "standard",
    style: {
      marginBottom: '.5rem'
    }
  }, "Option 1"), /*#__PURE__*/_react.default.createElement(_RadioTile.default, {
    value: "default-selected",
    id: "tile-2"
  }, "Option 2")))));
};

exports.RadioWithLayer = RadioWithLayer;

var Expandable = function Expandable() {
  return /*#__PURE__*/_react.default.createElement(_.ExpandableTile, {
    tileCollapsedIconText: "Interact to Expand tile",
    tileExpandedIconText: "Interact to Collapse tile"
  }, /*#__PURE__*/_react.default.createElement(_.TileAboveTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '200px'
    }
  }, "Above the fold content here")), /*#__PURE__*/_react.default.createElement(_.TileBelowTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "test2",
    invalidText: "A valid value is required"
  }))));
};

exports.Expandable = Expandable;

var ExpandableWithLayer = function ExpandableWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.ExpandableTile, {
    tileCollapsedIconText: "Interact to Expand tile",
    tileExpandedIconText: "Interact to Collapse tile"
  }, /*#__PURE__*/_react.default.createElement(_.TileAboveTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '200px'
    }
  }, "First layer")), /*#__PURE__*/_react.default.createElement(_.TileBelowTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "test2",
    invalidText: "A valid value is required"
  })))), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.ExpandableTile, {
    tileCollapsedIconText: "Interact to Expand tile",
    tileExpandedIconText: "Interact to Collapse tile"
  }, /*#__PURE__*/_react.default.createElement(_.TileAboveTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '200px'
    }
  }, "Second layer")), /*#__PURE__*/_react.default.createElement(_.TileBelowTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "test2",
    invalidText: "A valid value is required"
  })))), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.ExpandableTile, {
    tileCollapsedIconText: "Interact to Expand tile",
    tileExpandedIconText: "Interact to Collapse tile"
  }, /*#__PURE__*/_react.default.createElement(_.TileAboveTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '200px'
    }
  }, "Third layer")), /*#__PURE__*/_react.default.createElement(_.TileBelowTheFoldContent, null, /*#__PURE__*/_react.default.createElement("div", {
    style: {
      height: '400px'
    }
  }, "Below the fold content here", /*#__PURE__*/_react.default.createElement(_TextInput.default, {
    id: "test2",
    invalidText: "A valid value is required"
  })))))));
};

exports.ExpandableWithLayer = ExpandableWithLayer;