"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _TimePicker = _interopRequireDefault(require("./TimePicker"));

var _react2 = require("@testing-library/react");

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('TimePicker', function () {
  describe('input', function () {
    it('renders as expected', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TimePicker.default, {
        id: "time-picker"
      }));
      expect(_react2.screen.getByRole('textbox')).toBeInTheDocument();
    });
    it('passes classNames as expected', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TimePicker.default, {
        id: "time-picker",
        className: "\uD83D\uDE80"
      }));
      expect(_react2.screen.getByRole('textbox')).toHaveClass('🚀');
    });
    it('should set type as expected', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TimePicker.default, {
        id: "time-picker"
      }));
      expect(_react2.screen.getByRole('textbox')).toHaveAttribute('type', 'text');
    });
    it('should set value as expected', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TimePicker.default, {
        id: "time-picker",
        value: "\uD83D\uDC36"
      }));
      expect(_react2.screen.getByRole('textbox')).toHaveAttribute('value', '🐶');
    });
    it('should set disabled as expected', function () {
      var onClick = jest.fn();
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TimePicker.default, {
        id: "time-picker",
        onClick: onClick,
        disabled: true
      }));

      _react2.fireEvent.click(_react2.screen.getByRole('textbox'));

      expect(onClick).not.toHaveBeenCalled();
    });
    it('should set placeholder as expected', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TimePicker.default, {
        id: "time-picker",
        placeholder: "\uD83E\uDDF8"
      }));
      expect(_react2.screen.getByPlaceholderText('🧸')).toBeInTheDocument();
    });
  });
  describe('label', function () {
    it('does not render a label by default', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TimePicker.default, {
        id: "time-picker"
      }));
      expect(_react2.screen.queryByLabelText('🐳')).not.toBeInTheDocument();
    });
    it('renders a label as expected', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TimePicker.default, {
        id: "time-picker",
        labelText: "\uD83D\uDC33"
      }));
      expect(_react2.screen.getByLabelText('🐳')).toBeInTheDocument();
    });
  });
  describe('events', function () {
    it('should write text inside the textbox', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_TimePicker.default, {
        id: "time-picker"
      }));

      _userEvent.default.type(_react2.screen.getByRole('textbox'), '🧛');

      expect(_react2.screen.getByRole('textbox')).toHaveValue('🧛');
    });
  });
});