"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _usePrefix = require("../../../internal/usePrefix");

var _deprecate = _interopRequireDefault(require("../../../prop-types/deprecate"));

var _excluded = ["aria-label", "children", "id", "disabled", "className"];

var TimePickerSelect = /*#__PURE__*/_react.default.forwardRef(function TimePickerSelect(_ref, ref) {
  var _cx;

  var _ref$ariaLabel = _ref['aria-label'],
      ariaLabel = _ref$ariaLabel === void 0 ? 'open list of options' : _ref$ariaLabel,
      children = _ref.children,
      id = _ref.id,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var selectClasses = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--select"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--time-picker__select"), true), (0, _defineProperty2.default)(_cx, className, className), _cx));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: selectClasses
  }, /*#__PURE__*/_react.default.createElement("select", (0, _extends2.default)({
    "aria-label": ariaLabel,
    className: "".concat(prefix, "--select-input"),
    disabled: disabled,
    id: id,
    ref: ref
  }, rest), children), /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronDown16, {
    className: "".concat(prefix, "--select__arrow"),
    "aria-hidden": "true"
  }));
});

TimePickerSelect.propTypes = {
  /**
   * Provide the contents of your TimePickerSelect
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the node containing the label and the select box
   */
  className: _propTypes.default.string,

  /**
   * Optionally provide the default value of the `<select>`
   */
  defaultValue: _propTypes.default.any,

  /**
   * Specify whether the control is disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Provide a description for the twistie icon that can be read by screen readers
   */
  iconDescription: (0, _deprecate.default)(_propTypes.default.string, 'The `iconDescription` prop for `TimePickerSelect` is no longer needed and has ' + 'been deprecated. It will be moved in the next major release. Use "aria-label" instead'),

  /**
   * Specify a custom `id` for the `<select>`
   */
  id: _propTypes.default.string.isRequired
};
var _default = TimePickerSelect;
exports.default = _default;