"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Toggle = Toggle;
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _useControllableState3 = require("../../../internal/useControllableState");

var _excluded = ["className", "defaultToggled", "disabled", "hideLabel", "id", "labelA", "labelB", "labelText", "onClick", "onToggle", "size", "toggled"];
var prefix = _carbonComponents.settings.prefix;

function Toggle(_ref) {
  var className = _ref.className,
      _ref$defaultToggled = _ref.defaultToggled,
      defaultToggled = _ref$defaultToggled === void 0 ? false : _ref$defaultToggled,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$hideLabel = _ref.hideLabel,
      hideLabel = _ref$hideLabel === void 0 ? false : _ref$hideLabel,
      id = _ref.id,
      _ref$labelA = _ref.labelA,
      labelA = _ref$labelA === void 0 ? 'Off' : _ref$labelA,
      _ref$labelB = _ref.labelB,
      labelB = _ref$labelB === void 0 ? 'On' : _ref$labelB,
      labelText = _ref.labelText,
      onClick = _ref.onClick,
      onToggle = _ref.onToggle,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 'md' : _ref$size,
      toggled = _ref.toggled,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);

  var _useControllableState = (0, _useControllableState3.useControllableState)({
    value: toggled,
    onChange: onToggle,
    defaultValue: defaultToggled
  }),
      _useControllableState2 = (0, _slicedToArray2.default)(_useControllableState, 2),
      checked = _useControllableState2[0],
      setChecked = _useControllableState2[1];

  function handleClick(e) {
    setChecked(!checked);

    if (onClick) {
      onClick(e);
    }
  }

  var isSm = size === 'sm';
  var sideLabel = hideLabel ? labelText : checked ? labelB : labelA;
  var wrapperClasses = (0, _classnames.default)("".concat(prefix, "--toggle"), (0, _defineProperty2.default)({}, "".concat(prefix, "--toggle--disabled"), disabled), className);
  var labelTextClasses = (0, _classnames.default)("".concat(prefix, "--toggle__label-text"), (0, _defineProperty2.default)({}, "".concat(prefix, "--visually-hidden"), hideLabel));
  var appearanceClasses = (0, _classnames.default)("".concat(prefix, "--toggle__appearance"), (0, _defineProperty2.default)({}, "".concat(prefix, "--toggle__appearance--sm"), isSm));
  var switchClasses = (0, _classnames.default)("".concat(prefix, "--toggle__switch"), (0, _defineProperty2.default)({}, "".concat(prefix, "--toggle__switch--checked"), checked));
  return /*#__PURE__*/_react.default.createElement("div", {
    className: wrapperClasses
  }, /*#__PURE__*/_react.default.createElement("button", (0, _extends2.default)({}, other, {
    id: id,
    className: "".concat(prefix, "--toggle__button"),
    role: "switch",
    type: "button",
    "aria-checked": checked,
    disabled: disabled,
    onClick: handleClick
  })), /*#__PURE__*/_react.default.createElement("label", {
    htmlFor: id,
    className: "".concat(prefix, "--toggle__label")
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: labelTextClasses
  }, labelText), /*#__PURE__*/_react.default.createElement("div", {
    className: appearanceClasses
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: switchClasses
  }, isSm && /*#__PURE__*/_react.default.createElement("svg", {
    className: "".concat(prefix, "--toggle__check"),
    width: "6px",
    height: "5px",
    viewBox: "0 0 6 5"
  }, /*#__PURE__*/_react.default.createElement("path", {
    d: "M2.2 2.7L5 0 6 1 2.2 5 0 2.7 1 1.5z"
  }))), /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--toggle__text"),
    "aria-hidden": "true"
  }, sideLabel))));
}

Toggle.propTypes = {
  /**
   * Specify a custom className to apply to the form-item node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the toggle should be on by default
   */
  defaultToggled: _propTypes.default.bool,

  /**
   * Whether this control should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: _propTypes.default.bool,

  /**
   * Provide an id that unique represents the underlying `<button>`
   */
  id: _propTypes.default.string.isRequired,

  /**
   * Specify the label for the "off" position
   */
  labelA: _propTypes.default.node,

  /**
   * Specify the label for the "on" position
   */
  labelB: _propTypes.default.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: _propTypes.default.node.isRequired,

  /**
   * Provide an event listener that is called when the control is clicked
   */
  onClick: _propTypes.default.func,

  /**
   * Provide an event listener that is called when the control is toggled
   */
  onToggle: _propTypes.default.func,

  /**
   * Specify the size of the Toggle. Currently only supports 'sm' or 'md' (default)
   */
  size: _propTypes.default.oneOf(['sm', 'md']),

  /**
   * Specify whether the control is toggled
   */
  toggled: _propTypes.default.bool
};
var _default = Toggle;
exports.default = _default;