"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _ClickListener = _interopRequireDefault(require("../../internal/ClickListener"));

var _warning = require("../../internal/warning");

var _excluded = ["className", "type", "id", "placeHolderText", "labelText", "role", "labelId"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;
var didWarnAboutDeprecation = false;

var ToolbarSearch = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(ToolbarSearch, _Component);

  var _super = _createSuper(ToolbarSearch);

  function ToolbarSearch(props) {
    var _this;

    (0, _classCallCheck2.default)(this, ToolbarSearch);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "state", {
      expanded: false
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "expandSearch", function () {
      _this.setState({
        expanded: !_this.state.expanded
      });

      _this.input.focus();
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleClickOutside", function () {
      _this.setState({
        expanded: false
      });
    });

    if (process.env.NODE_ENV !== "production") {
      process.env.NODE_ENV !== "production" ? (0, _warning.warning)(didWarnAboutDeprecation, 'The ToolbarSearch component has been deprecated and will be removed in the next major release of `carbon-components-react`') : void 0;
      didWarnAboutDeprecation = true;
    }

    return _this;
  }

  (0, _createClass2.default)(ToolbarSearch, [{
    key: "render",
    value: function render() {
      var _classNames,
          _this2 = this;

      var _this$props = this.props,
          className = _this$props.className,
          type = _this$props.type,
          id = _this$props.id,
          placeHolderText = _this$props.placeHolderText,
          labelText = _this$props.labelText,
          role = _this$props.role,
          labelId = _this$props.labelId,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);
      var searchClasses = (0, _classnames.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--search ").concat(prefix, "--search--sm ").concat(prefix, "--toolbar-search"), true), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--toolbar-search--active"), this.state.expanded), (0, _defineProperty2.default)(_classNames, className, className), _classNames));
      return /*#__PURE__*/_react.default.createElement(_ClickListener.default, {
        onClickOutside: this.handleClickOutside
      }, /*#__PURE__*/_react.default.createElement("div", {
        className: searchClasses,
        role: role
      }, /*#__PURE__*/_react.default.createElement("label", {
        htmlFor: id,
        className: "".concat(prefix, "--label"),
        id: labelId
      }, labelText), /*#__PURE__*/_react.default.createElement("input", (0, _extends2.default)({}, other, {
        type: type,
        className: "".concat(prefix, "--search-input"),
        id: id,
        "aria-labelledby": labelId,
        placeholder: placeHolderText,
        ref: function ref(input) {
          _this2.input = input;
        }
      })), /*#__PURE__*/_react.default.createElement("button", {
        type: "button",
        className: "".concat(prefix, "--toolbar-search__btn"),
        title: labelText,
        onClick: this.expandSearch
      }, /*#__PURE__*/_react.default.createElement(_iconsReact.Search16, {
        className: "".concat(prefix, "--search-magnifier"),
        "aria-label": labelText
      }))));
    }
  }]);
  return ToolbarSearch;
}(_react.Component);

exports.default = ToolbarSearch;
(0, _defineProperty2.default)(ToolbarSearch, "propTypes", {
  /**
   * The child nodes.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names.
   */
  className: _propTypes.default.string,

  /**
   * The ID of the `<input>`.
   */
  id: _propTypes.default.string,

  /**
   * The ID of the `<label>`.
   */
  labelId: _propTypes.default.string,

  /**
   * The text in the `<label>`.
   */
  labelText: _propTypes.default.node,

  /**
   * The placeholder text of the `<input>`.
   */
  placeHolderText: _propTypes.default.string,

  /**
   * Optional prop to specify the role of the ToolbarSearch
   */
  role: _propTypes.default.string,

  /**
   * `true` to use the small version of the UI.
   */
  small: _propTypes.default.bool,

  /**
   * The `type` of the `<input>`.
   */
  type: _propTypes.default.string
});
(0, _defineProperty2.default)(ToolbarSearch, "defaultProps", {
  type: 'search',
  id: 'search__input',
  labelText: '',
  placeHolderText: '',
  role: 'search',
  labelId: 'search__label'
});