"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _react = _interopRequireWildcard(require("react"));

var _lodash = _interopRequireDefault(require("lodash.debounce"));

var _FloatingMenu = _interopRequireDefault(require("../../internal/FloatingMenu"));

var _Tooltip = _interopRequireDefault(require("../Tooltip"));

var _enzyme = require("enzyme");

var _react2 = require("@testing-library/react");

var _userEvent = _interopRequireDefault(require("@testing-library/user-event"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

require("@testing-library/jest-dom");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;
jest.mock('lodash.debounce', function () {
  return function (fn) {
    fn.cancel = jest.fn();
    return fn;
  };
});
describe('Tooltip', function () {
  // An icon component class
  var CustomIcon = /*#__PURE__*/function (_Component) {
    (0, _inherits2.default)(CustomIcon, _Component);

    var _super = _createSuper(CustomIcon);

    function CustomIcon() {
      (0, _classCallCheck2.default)(this, CustomIcon);
      return _super.apply(this, arguments);
    }

    (0, _createClass2.default)(CustomIcon, [{
      key: "render",
      value: function render() {
        return /*#__PURE__*/_react.default.createElement("div", null);
      }
    }]);
    return CustomIcon;
  }(_react.Component);

  describe('Renders as expected with defaults', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
      triggerText: "Tooltip"
    }, /*#__PURE__*/_react.default.createElement("p", {
      className: "".concat(prefix, "--tooltip__label")
    }, "Tooltip label"), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet")));
    var trigger = wrapper.find(".".concat(prefix, "--tooltip__trigger"));
    describe('tooltip trigger', function () {
      it('renders a tooltip container', function () {
        expect(trigger.length).toEqual(1);
      });
      it('renders the info icon', function () {
        var icon = trigger.find(_iconsReact.Information16);
        expect(icon.length).toBe(1);
      });
    });
  });
  describe('Renders as expected with specified properties', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
      className: "tooltip--class",
      triggerClassName: "tooltip--trigger-class",
      triggerText: "Tooltip",
      direction: "bottom",
      menuOffset: {
        left: 10,
        top: 15
      },
      showIcon: false,
      open: true
    }, /*#__PURE__*/_react.default.createElement("p", null, "Tooltip label"), /*#__PURE__*/_react.default.createElement("p", null, "Lorem ipsum dolor sit amet")));
    var label = wrapper.find(".".concat(prefix, "--tooltip__label"));
    var floatingMenu = wrapper.find(_FloatingMenu.default);
    describe('tooltip container', function () {
      it("sets the tooltip's position", function () {
        expect(floatingMenu.prop('menuDirection')).toEqual('bottom');
      });
      it("sets the tooltip's offset", function () {
        expect(floatingMenu.prop('menuOffset')).toEqual({
          left: 10,
          top: 15
        });
      });
      it('does not render info icon', function () {
        var icon = label.find(_iconsReact.Information16);
        expect(icon.exists()).toBe(false);
      });
      it('sets the tooltip class', function () {
        expect(floatingMenu.find('[data-floating-menu-direction]').first().prop('className')).toBe("".concat(prefix, "--tooltip ").concat(prefix, "--tooltip--shown ").concat(prefix, "--tooltip--bottom ").concat(prefix, "--tooltip--align-center tooltip--class"));
      });
      it('sets the trigger class', function () {
        expect(label.prop('className')).toBe("".concat(prefix, "--tooltip__label tooltip--trigger-class"));
      });
    });
  });
  describe('Renders as expected when an Icon component wrapped with forwardRef is provided', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
      renderIcon: _iconsReact.Add16
    }));
    it('does render Icon', function () {
      var icon = wrapper.find(_iconsReact.Add16);
      expect(icon.exists()).toBe(true);
    });
  });
  describe('Renders as expected when custom icon component with forwardRef is provided', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
      renderIcon: /*#__PURE__*/_react.default.forwardRef(function () {
        return /*#__PURE__*/_react.default.createElement(CustomIcon, null);
      })
    }));
    it('does render provided custom icon component instance', function () {
      var icon = wrapper.find(CustomIcon);
      expect(icon.exists()).toBe(true);
    });
  });
  describe('Renders as expected when custom icon component with inner forwardRef is provided', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
      renderIcon: _iconsReact.OverflowMenuVertical16
    }));
    it('does render provided custom icon component instance', function () {
      var icon = wrapper.find(_iconsReact.OverflowMenuVertical16);
      expect(icon.exists()).toBe(true);
    });
  });
  describe('events', function () {
    it('A different key press does not change state', function () {
      var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        triggerText: "Tooltip"
      }));
      var icon = wrapper.find(_iconsReact.Information16);
      icon.simulate('keyDown', {
        which: 'x'
      }); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(wrapper.find('Tooltip').instance().state.open).toBeFalsy();
    });
    it('A different key press does not change state when custom icon is set', function () {
      var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        renderIcon: /*#__PURE__*/_react.default.forwardRef(function (props, ref) {
          return /*#__PURE__*/_react.default.createElement("div", {
            className: "custom-icon",
            ref: ref
          });
        }),
        triggerText: "Tooltip"
      }));
      var icon = wrapper.find('.custom-icon');
      icon.simulate('keyDown', {
        which: 'x'
      }); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(wrapper.find('Tooltip').instance().state.open).toBeFalsy();
    });
    it('should be in a closed state after handleOutsideClick() is invoked', function () {
      var rootWrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        triggerText: "Tooltip"
      })); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toBeFalsy(); // Enzyme doesn't seem to allow setState() in a forwardRef-wrapped class component

      rootWrapper.find('Tooltip').instance().setState({
        open: true
      });
      rootWrapper.update();
      rootWrapper.find('Tooltip').instance().handleClickOutside(); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toEqual(false);
    });
    it('prop.open change should update open state', function () {
      var rootWrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        open: false,
        triggerText: "Tooltip"
      })); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toEqual(false);
      rootWrapper.setProps({
        open: true,
        triggerText: 'Tooltip'
      }); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toEqual(true);
    });
    it('should avoid change the open state upon setting props, unless there the value actually changes', function () {
      var rootWrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, null));
      rootWrapper.setProps({
        open: true
      }); // Enzyme doesn't seem to allow setState() in a forwardRef-wrapped class component

      rootWrapper.find('Tooltip').instance().setState({
        open: false
      });
      rootWrapper.update();
      rootWrapper.setProps({
        open: true
      }); // Enzyme doesn't seem to allow state() in a forwardRef-wrapped class component

      expect(rootWrapper.find('Tooltip').instance().state.open).toEqual(false);
    });
    it('escape key keyDown should not bubble outside the tooltip', function () {
      var onKeyDown = jest.fn();
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        onKeyDown: onKeyDown
      }, /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        triggerText: "Tooltip"
      }))));

      _userEvent.default.click(_react2.screen.getAllByRole('button')[0]);

      _userEvent.default.keyboard('{esc}');

      expect(onKeyDown).not.toHaveBeenCalled();
    });
    it('should close the tooltip when escape key is pressed', function () {
      (0, _react2.render)( /*#__PURE__*/_react.default.createElement(_Tooltip.default, {
        triggerText: "trigger text",
        tooltipBodyId: "tooltip-body"
      }, /*#__PURE__*/_react.default.createElement("p", {
        id: "tooltip-body"
      }, "tooltip body")));
      expect(_react2.screen.queryByText('trigger text')).toBeInTheDocument();
      expect(_react2.screen.queryByText('tooltip body')).not.toBeInTheDocument();

      var triggerButton = _react2.screen.getByRole('button');

      _userEvent.default.click(triggerButton); // I am unsure why, but the trigger must be clicked a second time for the tooltip body to appear


      _userEvent.default.click(triggerButton);

      expect(_react2.screen.queryByText('tooltip body')).toBeInTheDocument();

      _userEvent.default.keyboard('{esc}');

      expect(_react2.screen.queryByText('tooltip body')).not.toBeInTheDocument();
    });
  });
});