"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Tooltip = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _reactIs = require("react-is");

var _lodash = _interopRequireDefault(require("lodash.debounce"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _FloatingMenu = _interopRequireWildcard(require("../../internal/FloatingMenu"));

var _ClickListener = _interopRequireDefault(require("../../internal/ClickListener"));

var _mergeRefs = _interopRequireDefault(require("../../tools/mergeRefs"));

var _keyboard = require("../../internal/keyboard");

var _isRequiredOneOf = _interopRequireDefault(require("../../prop-types/isRequiredOneOf"));

var _requiredIfValueExists = _interopRequireDefault(require("../../prop-types/requiredIfValueExists"));

var _FeatureFlags = require("../../internal/FeatureFlags");

var _excluded = ["triggerId", "tooltipBodyId", "children", "className", "triggerClassName", "focusTrap", "triggerText", "showIcon", "iconName", "iconDescription", "renderIcon", "menuOffset", "tabIndex", "innerRef", "selectorPrimaryFocus", "tooltipId"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var prefix = _carbonComponents.settings.prefix;
/**
 * @param {Element} menuBody The menu body with the menu arrow.
 * @param {string} menuDirection Where the floating menu menu should be placed relative to the trigger button.
 * @returns {FloatingMenu~offset} The adjustment of the floating menu position, upon the position of the menu arrow.
 * @private
 */

var getMenuOffset = function getMenuOffset(menuBody, menuDirection) {
  var _DIRECTION_LEFT$DIREC, _DIRECTION_LEFT$DIREC2;

  var arrowStyle = menuBody.ownerDocument.defaultView.getComputedStyle(menuBody, ':before');
  var arrowPositionProp = (_DIRECTION_LEFT$DIREC = {}, (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC, _FloatingMenu.DIRECTION_LEFT, 'right'), (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC, _FloatingMenu.DIRECTION_TOP, 'bottom'), (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC, _FloatingMenu.DIRECTION_RIGHT, 'left'), (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC, _FloatingMenu.DIRECTION_BOTTOM, 'top'), _DIRECTION_LEFT$DIREC)[menuDirection];
  var menuPositionAdjustmentProp = (_DIRECTION_LEFT$DIREC2 = {}, (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC2, _FloatingMenu.DIRECTION_LEFT, 'left'), (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC2, _FloatingMenu.DIRECTION_TOP, 'top'), (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC2, _FloatingMenu.DIRECTION_RIGHT, 'left'), (0, _defineProperty2.default)(_DIRECTION_LEFT$DIREC2, _FloatingMenu.DIRECTION_BOTTOM, 'top'), _DIRECTION_LEFT$DIREC2)[menuDirection];
  var values = [arrowPositionProp, 'border-bottom-width'].reduce(function (o, name) {
    return _objectSpread(_objectSpread({}, o), {}, (0, _defineProperty2.default)({}, name, Number((/^([\d-]+)px$/.exec(arrowStyle.getPropertyValue(name)) || [])[1])));
  }, {});
  values[arrowPositionProp] = values[arrowPositionProp] || -6; // IE, etc.

  if (Object.keys(values).every(function (name) {
    return !isNaN(values[name]);
  })) {
    var arrowPosition = values[arrowPositionProp],
        borderBottomWidth = values['border-bottom-width'];
    return (0, _defineProperty2.default)({
      left: 0,
      top: 0
    }, menuPositionAdjustmentProp, Math.sqrt(Math.pow(borderBottomWidth, 2) * 2) - arrowPosition);
  }
};

var Tooltip = /*#__PURE__*/function (_Component) {
  (0, _inherits2.default)(Tooltip, _Component);

  var _super = _createSuper(Tooltip);

  function Tooltip(props) {
    var _this;

    (0, _classCallCheck2.default)(this, Tooltip);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_tooltipEl", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_triggerRef", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_tooltipId", _this.props.id || _this.props.tooltipId || "__carbon-tooltip_".concat(Math.random().toString(36).substr(2)));
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_tooltipDismissed", false);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "updateOrientation", function (params) {
      if (_this.props.autoOrientation) {
        var newOrientation = _this.getBestDirection(params);

        var direction = newOrientation.direction,
            align = newOrientation.align;

        if (direction !== _this.state.storedDirection) {
          _this.setState({
            open: false
          }, function () {
            _this.setState({
              open: true,
              storedDirection: direction
            });
          });
        }

        if (align === 'original') {
          _this.setState({
            storedAlign: _this.props.align
          });
        } else {
          _this.setState({
            storedAlign: align
          });
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "getBestDirection", function (_ref2) {
      var menuSize = _ref2.menuSize,
          _ref2$refPosition = _ref2.refPosition,
          refPosition = _ref2$refPosition === void 0 ? {} : _ref2$refPosition,
          _ref2$offset = _ref2.offset,
          offset = _ref2$offset === void 0 ? {} : _ref2$offset,
          _ref2$direction = _ref2.direction,
          direction = _ref2$direction === void 0 ? _FloatingMenu.DIRECTION_BOTTOM : _ref2$direction,
          _ref2$scrollX = _ref2.scrollX,
          pageXOffset = _ref2$scrollX === void 0 ? 0 : _ref2$scrollX,
          _ref2$scrollY = _ref2.scrollY,
          pageYOffset = _ref2$scrollY === void 0 ? 0 : _ref2$scrollY,
          container = _ref2.container;
      var _refPosition$left = refPosition.left,
          refLeft = _refPosition$left === void 0 ? 0 : _refPosition$left,
          _refPosition$top = refPosition.top,
          refTop = _refPosition$top === void 0 ? 0 : _refPosition$top,
          _refPosition$right = refPosition.right,
          refRight = _refPosition$right === void 0 ? 0 : _refPosition$right,
          _refPosition$bottom = refPosition.bottom,
          refBottom = _refPosition$bottom === void 0 ? 0 : _refPosition$bottom;
      var scrollX = container.position !== 'static' ? 0 : pageXOffset;
      var scrollY = container.position !== 'static' ? 0 : pageYOffset;
      var relativeDiff = {
        top: container.position !== 'static' ? container.rect.top : 0,
        left: container.position !== 'static' ? container.rect.left : 0
      };
      var width = menuSize.width,
          height = menuSize.height;
      var _offset$top = offset.top,
          top = _offset$top === void 0 ? 0 : _offset$top,
          _offset$left = offset.left,
          left = _offset$left === void 0 ? 0 : _offset$left;
      var refCenterHorizontal = (refLeft + refRight) / 2;
      var refCenterVertical = (refTop + refBottom) / 2; // Calculate whether a new direction is needed to stay in parent.
      // It will switch the current direction to the opposite i.e.
      // If the direction="top" and the top boundary is overflowed
      // then it switches the direction to "bottom".

      var newDirection = function newDirection() {
        switch (direction) {
          case _FloatingMenu.DIRECTION_LEFT:
            return refLeft - width + scrollX - left - relativeDiff.left < 0 ? _FloatingMenu.DIRECTION_RIGHT : direction;

          case _FloatingMenu.DIRECTION_TOP:
            return refTop - height + scrollY - top - relativeDiff.top < 0 ? _FloatingMenu.DIRECTION_BOTTOM : direction;

          case _FloatingMenu.DIRECTION_RIGHT:
            return refRight + scrollX + left - relativeDiff.left + width > container.rect.width ? _FloatingMenu.DIRECTION_LEFT : direction;

          case _FloatingMenu.DIRECTION_BOTTOM:
            return refBottom + scrollY + top - relativeDiff.top + height > container.rect.height ? _FloatingMenu.DIRECTION_TOP : direction;

          default:
            // If there is a new direction then ignore the logic above
            return direction;
        }
      }; // Calculate whether a new alignment is needed to stay in parent
      // If the direction is left or right this involves checking the
      // overflow in the vertical direction. If the direction is top or
      // bottom, this involves checking overflow in the horizontal direction.
      // "original" is used to signify no change.


      var newAlignment = function newAlignment() {
        switch (direction) {
          case _FloatingMenu.DIRECTION_LEFT:
          case _FloatingMenu.DIRECTION_RIGHT:
            if (refCenterVertical - height / 2 + scrollY + top - 9 - relativeDiff.top < 0) {
              // If goes above the top boundary
              return 'start';
            } else if (refCenterVertical - height / 2 + scrollY + top - 9 - relativeDiff.top + height > container.rect.height) {
              // If goes below the bottom boundary
              return 'end';
            } else {
              // No need to change alignment
              return 'original';
            }

          case _FloatingMenu.DIRECTION_TOP:
          case _FloatingMenu.DIRECTION_BOTTOM:
            if (refCenterHorizontal - width / 2 + scrollX + left - relativeDiff.left < 0) {
              // If goes below the left boundary
              return 'start';
            } else if (refCenterHorizontal - width / 2 + scrollX + left - relativeDiff.left + width > container.rect.width) {
              // If it goes over the right boundary
              return 'end';
            } else {
              // No need to change alignment
              return 'original';
            }

          default:
            // No need to change alignment
            return 'original';
        }
      };

      return {
        direction: newDirection(),
        align: newAlignment()
      };
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_handleUserInputOpenClose", function (event, _ref3) {
      var open = _ref3.open;

      if (_this.isControlled && _this.props.onChange) {
        // Callback to the parent to let them decide what to do
        _this.props.onChange(event, {
          open: open
        });

        return;
      } // capture tooltip body element before it is removed from the DOM


      var tooltipBody = _this._tooltipEl;

      _this.setState({
        open: open
      }, function () {
        if (_this.props.onChange) {
          _this.props.onChange(event, {
            open: open
          });
        }

        if (!open && tooltipBody && tooltipBody.id === _this._tooltipId) {
          _this._tooltipDismissed = true;
          var currentActiveNode = event === null || event === void 0 ? void 0 : event.relatedTarget;

          if (!currentActiveNode && document.activeElement === document.body && (event === null || event === void 0 ? void 0 : event.type) !== 'click') {
            var _this$_triggerRef;

            (_this$_triggerRef = _this._triggerRef) === null || _this$_triggerRef === void 0 ? void 0 : _this$_triggerRef.current.focus();
          }
        }
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_handleFocus", function (state, evt) {
      var currentTarget = evt.currentTarget,
          relatedTarget = evt.relatedTarget;

      if (currentTarget !== relatedTarget) {
        _this._tooltipDismissed = false;
      }

      if (state === 'over') {
        if (!_this._tooltipDismissed) {
          _this._handleUserInputOpenClose(evt, {
            open: true
          });
        }

        _this._tooltipDismissed = false;
      } else if (state !== 'out') {
        // Note: SVGElement in IE11 does not have `.contains()`
        var triggerEl = _this._triggerRef.current;

        var shouldPreventClose = relatedTarget && (triggerEl && (triggerEl === null || triggerEl === void 0 ? void 0 : triggerEl.contains(relatedTarget)) || _this._tooltipEl && _this._tooltipEl.contains(relatedTarget));

        if (!shouldPreventClose) {
          _this._handleUserInputOpenClose(evt, {
            open: false
          });
        }
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_debouncedHandleFocus", null);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "_getTarget", function () {
      var triggerEl = _this._triggerRef.current;
      return triggerEl && triggerEl.closest('[data-floating-menu-container]') || document.body;
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleMouse", function (evt) {
      evt.persist();
      var state = {
        focus: 'over',
        blur: 'out',
        click: 'click'
      }[evt.type];
      var hadContextMenu = _this._hasContextMenu;

      if (evt.type === 'click' || evt.type === 'contextmenu') {
        _this._hasContextMenu = evt.type === 'contextmenu';
      }

      if (_this._hasContextMenu) {
        _this._handleUserInputOpenClose(evt, {
          open: false
        });

        return;
      }

      if (state === 'click') {
        evt.preventDefault();
        var shouldOpen = _this.isControlled ? !_this.props.open : !_this.state.open;

        _this._handleUserInputOpenClose(evt, {
          open: shouldOpen
        });
      } else if (state && (state !== 'out' || !hadContextMenu)) {
        var _assertThisInitialize;

        (_assertThisInitialize = (0, _assertThisInitialized2.default)(_this)) === null || _assertThisInitialize === void 0 ? void 0 : _assertThisInitialize._debouncedHandleFocus(state, evt);
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleClickOutside", function (evt) {
      var shouldPreventClose = evt && evt.target && _this._tooltipEl && _this._tooltipEl.contains(evt.target);

      if (!shouldPreventClose && _this.state.open) {
        _this._handleUserInputOpenClose(evt, {
          open: false
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleKeyPress", function (event) {
      if ((0, _keyboard.matches)(event, [_keyboard.keys.Escape, _keyboard.keys.Tab])) {
        event.stopPropagation();

        _this._handleUserInputOpenClose(event, {
          open: false
        });
      }

      if ((0, _keyboard.matches)(event, [_keyboard.keys.Enter, _keyboard.keys.Space])) {
        event.stopPropagation();
        event.preventDefault();
        var shouldOpen = _this.isControlled ? !_this.props.open : !_this.state.open;

        _this._handleUserInputOpenClose(event, {
          open: shouldOpen
        });
      }
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleEscKeyPress", function (event) {
      var _ref4 = _this.isControlled ? _this.props : _this.state,
          open = _ref4.open;

      if (open && (0, _keyboard.matches)(event, [_keyboard.keys.Escape])) {
        event.stopPropagation();
        return _this._handleUserInputOpenClose(event, {
          open: false
        });
      }
    });
    _this.isControlled = props.open !== undefined;

    if (_FeatureFlags.useControlledStateWithValue && _this.isControlled) {
      // Skips the logic of setting initial state if this component is controlled
      return (0, _possibleConstructorReturn2.default)(_this);
    }

    var _open = _FeatureFlags.useControlledStateWithValue ? props.defaultOpen : props.open;

    _this.state = {
      open: _open,
      storedDirection: props.direction,
      storedAlign: props.align
    };
    return _this;
  }

  (0, _createClass2.default)(Tooltip, [{
    key: "componentDidMount",
    value: function componentDidMount() {
      if (!this._debouncedHandleFocus) {
        this._debouncedHandleFocus = (0, _lodash.default)(this._handleFocus, 200);
      }
    }
  }, {
    key: "componentDidUpdate",
    value: function componentDidUpdate(prevProps, prevState) {
      if (prevProps.direction != this.props.direction) {
        this.setState({
          storedDirection: this.props.direction
        });
      }

      if (prevProps.align != this.props.align) {
        this.setState({
          storedAlign: this.props.align
        });
      }

      if (prevState.open && !this.state.open) {
        // Reset orientation when closing
        this.setState({
          storedDirection: this.props.direction,
          storedAlign: this.props.align
        });
      }
    }
  }, {
    key: "componentWillUnmount",
    value: function componentWillUnmount() {
      if (this._debouncedHandleFocus) {
        this._debouncedHandleFocus.cancel();

        this._debouncedHandleFocus = null;
      }
    }
  }, {
    key: "render",
    value: function render() {
      var _classNames,
          _this2 = this;

      var _this$props = this.props,
          _this$props$triggerId = _this$props.triggerId,
          triggerId = _this$props$triggerId === void 0 ? this.triggerId = this.triggerId || "__carbon-tooltip-trigger_".concat(Math.random().toString(36).substr(2)) : _this$props$triggerId,
          tooltipBodyId = _this$props.tooltipBodyId,
          children = _this$props.children,
          className = _this$props.className,
          triggerClassName = _this$props.triggerClassName,
          focusTrap = _this$props.focusTrap,
          triggerText = _this$props.triggerText,
          showIcon = _this$props.showIcon,
          iconName = _this$props.iconName,
          iconDescription = _this$props.iconDescription,
          IconCustomElement = _this$props.renderIcon,
          menuOffset = _this$props.menuOffset,
          _this$props$tabIndex = _this$props.tabIndex,
          tabIndex = _this$props$tabIndex === void 0 ? 0 : _this$props$tabIndex,
          ref = _this$props.innerRef,
          selectorPrimaryFocus = _this$props.selectorPrimaryFocus,
          tooltipId = _this$props.tooltipId,
          other = (0, _objectWithoutProperties2.default)(_this$props, _excluded);

      var _ref5 = this.isControlled ? this.props : this.state,
          open = _ref5.open;

      var _this$state = this.state,
          storedDirection = _this$state.storedDirection,
          storedAlign = _this$state.storedAlign;
      var tooltipClasses = (0, _classnames.default)("".concat(prefix, "--tooltip"), (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tooltip--shown"), open), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tooltip--").concat(storedDirection), storedDirection), (0, _defineProperty2.default)(_classNames, "".concat(prefix, "--tooltip--align-").concat(storedAlign), storedAlign), _classNames), className);
      var triggerClasses = (0, _classnames.default)("".concat(prefix, "--tooltip__label"), triggerClassName);
      var refProp = (0, _mergeRefs.default)(this._triggerRef, ref);
      var iconProperties = {
        name: iconName,
        role: null,
        description: null
      };

      var properties = _objectSpread({
        role: 'button',
        tabIndex: tabIndex,
        onClick: this.handleMouse,
        onContextMenu: this.handleMouse,
        onKeyDown: this.handleKeyPress,
        onMouseOver: this.handleMouse,
        onMouseOut: this.handleMouse,
        onFocus: this.handleMouse,
        onBlur: this.handleMouse,
        'aria-controls': !open ? undefined : this._tooltipId,
        'aria-expanded': open,
        'aria-describedby': open ? this._tooltipId : null
      }, triggerText ? {
        'aria-labelledby': triggerId
      } : {
        'aria-label': iconDescription
      });

      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_ClickListener.default, {
        onClickOutside: this.handleClickOutside
      }, showIcon ? /*#__PURE__*/_react.default.createElement("div", {
        id: triggerId,
        className: triggerClasses
      }, triggerText, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        className: "".concat(prefix, "--tooltip__trigger")
      }, properties, {
        ref: refProp,
        "aria-describedby": tooltipBodyId || properties['aria-describedby']
      }), /*#__PURE__*/_react.default.createElement(IconCustomElement, iconProperties))) : /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        id: triggerId,
        className: triggerClasses,
        ref: refProp
      }, properties, {
        "aria-describedby": tooltipBodyId || properties['aria-describedby']
      }), triggerText)), open && /*#__PURE__*/_react.default.createElement(_FloatingMenu.default, {
        focusTrap: focusTrap,
        selectorPrimaryFocus: this.props.selectorPrimaryFocus,
        target: this._getTarget,
        triggerRef: this._triggerRef,
        menuDirection: storedDirection,
        menuOffset: menuOffset,
        menuRef: function menuRef(node) {
          _this2._tooltipEl = node;
        },
        updateOrientation: this.updateOrientation
      }, /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({
        className: tooltipClasses,
        onKeyDown: this.handleEscKeyPress
      }, other, {
        id: this._tooltipId,
        "data-floating-menu-direction": storedDirection,
        onMouseOver: this.handleMouse,
        onMouseOut: this.handleMouse,
        onFocus: this.handleMouse,
        onBlur: this.handleMouse,
        onContextMenu: this.handleMouse
      }), /*#__PURE__*/_react.default.createElement("span", {
        className: "".concat(prefix, "--tooltip__caret")
      }), /*#__PURE__*/_react.default.createElement("div", {
        className: "".concat(prefix, "--tooltip__content"),
        "aria-labelledby": this._tooltipId,
        role: "dialog"
      }, children))));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref6, state) {
      var open = _ref6.open;

      /**
       * so that tooltip can be controlled programmatically through this `open` prop
       */
      var prevOpen = state.prevOpen;
      return prevOpen === open ? null : {
        open: open,
        prevOpen: open
      };
    }
  }]);
  return Tooltip;
}(_react.Component);

exports.Tooltip = Tooltip;
(0, _defineProperty2.default)(Tooltip, "propTypes", _objectSpread({
  /**
   * Specify the alignment (to the trigger button) of the tooltip.
   * Can be one of: start, center, or end.
   */
  align: _propTypes.default.oneOf(['start', 'center', 'end']),

  /**
   * Whether or not to re-orientate the tooltip if it goes outside,
   * of the bounds of the parent.
   */
  autoOrientation: _propTypes.default.bool,

  /**
   * Contents to put into the tooltip.
   */
  children: _propTypes.default.node,

  /**
   * The CSS class names of the tooltip.
   */
  className: _propTypes.default.string,

  /**
   * Optional starting value for uncontrolled state
   */
  defaultOpen: _propTypes.default.bool,

  /**
   * Where to put the tooltip, relative to the trigger UI.
   */
  direction: _propTypes.default.oneOf(['bottom', 'top', 'left', 'right']),

  /**
   * Enable or disable focus trap behavior
   */
  focusTrap: _propTypes.default.bool,

  /**
   * The name of the default tooltip icon.
   */
  iconName: _propTypes.default.string,

  /**
   * The adjustment of the tooltip position.
   */
  menuOffset: _propTypes.default.oneOfType([_propTypes.default.shape({
    top: _propTypes.default.number,
    left: _propTypes.default.number
  }), _propTypes.default.func]),

  /**
   * * the signature of the event handler will be:
   * * `onChange(event, { open })` where:
   *   * `event` is the (React) raw event
   *   * `open` is the new value
   */
  onChange: !_FeatureFlags.useControlledStateWithValue ? _propTypes.default.func : (0, _requiredIfValueExists.default)(_propTypes.default.func),

  /**
   * Open/closed state.
   */
  open: _propTypes.default.bool,

  /**
   * The callback function to optionally render the icon element.
   * It should be a component with React.forwardRef().
   */
  renderIcon: function renderIcon(props, propName, componentName) {
    if (props[propName] == undefined) {
      return;
    }

    var RefForwardingComponent = props[propName];

    if (!(0, _reactIs.isForwardRef)( /*#__PURE__*/_react.default.createElement(RefForwardingComponent, null))) {
      return new Error("Invalid value of prop '".concat(propName, "' supplied to '").concat(componentName, "',\n                          it should be created/wrapped with React.forwardRef() to have a ref and access the proper\n                          DOM node of the element to calculate its position in the viewport."));
    }
  },

  /**
   * Specify a CSS selector that matches the DOM element that should
   * be focused when the Tooltip opens
   */
  selectorPrimaryFocus: _propTypes.default.string,

  /**
   * `true` to show the default tooltip icon.
   */
  showIcon: _propTypes.default.bool,

  /**
   * Optional prop to specify the tabIndex of the Tooltip
   */
  tabIndex: _propTypes.default.number,

  /**
   * The ID of the tooltip body content.
   */
  tooltipBodyId: _propTypes.default.string,

  /**
   * The ID of the tooltip content.
   */
  tooltipId: _propTypes.default.string,

  /**
   * The CSS class names of the trigger UI.
   */
  triggerClassName: _propTypes.default.string,

  /**
   * The ID of the trigger button.
   */
  triggerId: _propTypes.default.string
}, (0, _isRequiredOneOf.default)({
  /**
   * The content to put into the trigger UI, except the (default) tooltip icon.
   */
  triggerText: _propTypes.default.node,

  /**
   * The description of the default tooltip icon, to be put in its SVG 'aria-label' and 'alt' .
   */
  iconDescription: _propTypes.default.string
})));
(0, _defineProperty2.default)(Tooltip, "defaultProps", {
  align: 'center',
  direction: _FloatingMenu.DIRECTION_BOTTOM,
  focusTrap: true,
  renderIcon: _iconsReact.Information16,
  showIcon: true,
  triggerText: null,
  menuOffset: getMenuOffset,
  selectorPrimaryFocus: '[data-tooltip-primary-focus]'
});

var _default = function () {
  var forwardRef = function forwardRef(props, ref) {
    return /*#__PURE__*/_react.default.createElement(Tooltip, (0, _extends2.default)({}, props, {
      innerRef: ref
    }));
  };

  forwardRef.displayName = 'Tooltip';
  return /*#__PURE__*/_react.default.forwardRef(forwardRef);
}();

exports.default = _default;