"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Playground = exports.Duration = exports.Default = exports.default = void 0;

require("./story.scss");

var _iconsReact = require("@carbon/icons-react");

var _react = _interopRequireDefault(require("react"));

var _next = require("../next");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Experimental/unstable_Tooltip',
  component: _next.Tooltip,
  parameters: {
    controls: {
      hideNoControlsWarning: true
    },
    layout: 'centered'
  },
  argTypes: {
    children: {
      table: {
        disable: true
      }
    },
    className: {
      table: {
        disable: true
      }
    }
  }
};
exports.default = _default;

var Default = function Default() {
  var label = 'Occassionally, services are updated in a specified time window to ensure no down time for customers.';
  return /*#__PURE__*/_react.default.createElement(_next.Tooltip, {
    align: "bottom",
    defaultOpen: true,
    label: label
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Checkbox16, null)));
};

exports.Default = Default;

var Duration = function Duration() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_next.Tooltip, {
    label: "Label one",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Checkbox16, null))), /*#__PURE__*/_react.default.createElement(_next.Tooltip, {
    label: "Label two",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Checkbox16, null))), /*#__PURE__*/_react.default.createElement(_next.Tooltip, {
    label: "Label three",
    enterDelayMs: 500,
    leaveDelayMs: 500
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Checkbox16, null))));
};

exports.Duration = Duration;

var PlaygroundStory = function PlaygroundStory(props) {
  var align = props.align,
      defaultOpen = props.defaultOpen,
      description = props.description,
      enterDelayMs = props.enterDelayMs,
      label = props.label,
      leaveDelayMs = props.leaveDelayMs;
  return /*#__PURE__*/_react.default.createElement(_next.Tooltip, {
    align: align,
    defaultOpen: defaultOpen,
    description: description,
    enterDelayMs: enterDelayMs,
    label: label,
    leaveDelayMs: leaveDelayMs
  }, /*#__PURE__*/_react.default.createElement("button", {
    className: "demo-tooltip-trigger",
    type: "button"
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.Checkbox16, null)));
};

var Playground = PlaygroundStory.bind({});
exports.Playground = Playground;
Playground.argTypes = {
  align: {
    defaultValue: 'bottom',
    options: ['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top'],
    control: {
      type: 'select'
    }
  },
  defaultOpen: {
    defaultValue: true
  },
  label: {
    control: {
      type: 'text'
    },
    defaultValue: 'Custom label'
  },
  description: {
    control: {
      type: 'text'
    }
  }
};