"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tooltip = Tooltip;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireWildcard(require("react"));

var _Popover = require("../../Popover");

var _keyboard = require("../../../internal/keyboard");

var _useDelayedState3 = require("../../../internal/useDelayedState");

var _useId = require("../../../internal/useId");

var _useNoInteractiveChildren = require("../../../internal/useNoInteractiveChildren");

var _usePrefix = require("../../../internal/usePrefix");

var _excluded = ["align", "className", "children", "label", "description", "enterDelayMs", "leaveDelayMs", "defaultOpen"];

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function Tooltip(_ref) {
  var _ref$align = _ref.align,
      align = _ref$align === void 0 ? 'top' : _ref$align,
      customClassName = _ref.className,
      children = _ref.children,
      label = _ref.label,
      description = _ref.description,
      _ref$enterDelayMs = _ref.enterDelayMs,
      enterDelayMs = _ref$enterDelayMs === void 0 ? 100 : _ref$enterDelayMs,
      _ref$leaveDelayMs = _ref.leaveDelayMs,
      leaveDelayMs = _ref$leaveDelayMs === void 0 ? 300 : _ref$leaveDelayMs,
      _ref$defaultOpen = _ref.defaultOpen,
      defaultOpen = _ref$defaultOpen === void 0 ? false : _ref$defaultOpen,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var containerRef = (0, _react.useRef)(null);
  var tooltipRef = (0, _react.useRef)(null);

  var _useDelayedState = (0, _useDelayedState3.useDelayedState)(defaultOpen),
      _useDelayedState2 = (0, _slicedToArray2.default)(_useDelayedState, 2),
      open = _useDelayedState2[0],
      setOpen = _useDelayedState2[1];

  var id = (0, _useId.useId)('tooltip');
  var prefix = (0, _usePrefix.usePrefix)();

  var child = _react.default.Children.only(children);

  var triggerProps = {
    onFocus: function onFocus() {
      return setOpen(true);
    },
    onBlur: function onBlur() {
      return setOpen(false);
    },
    // This should be placed on the trigger in case the element is disabled
    onMouseEnter: onMouseEnter
  };

  if (label) {
    triggerProps['aria-labelledby'] = id;
  } else {
    triggerProps['aria-describedby'] = id;
  }

  function onKeyDown(event) {
    if (open && (0, _keyboard.match)(event, _keyboard.keys.Escape)) {
      event.stopPropagation();
      setOpen(false);
    }
  }

  function onMouseEnter() {
    setOpen(true, enterDelayMs);
  }

  function onMouseLeave() {
    setOpen(false, leaveDelayMs);
  }

  (0, _useNoInteractiveChildren.useNoInteractiveChildren)(tooltipRef, 'The Tooltip component must have no interactive content rendered by the' + '`label` or `description` prop');
  return /*#__PURE__*/_react.default.createElement(_Popover.Popover, (0, _extends2.default)({}, rest, {
    align: align,
    className: (0, _classnames.default)("".concat(prefix, "--tooltip"), customClassName),
    dropShadow: false,
    highContrast: true,
    onKeyDown: onKeyDown,
    onMouseLeave: onMouseLeave,
    open: open,
    ref: containerRef
  }), /*#__PURE__*/_react.default.cloneElement(child, triggerProps), /*#__PURE__*/_react.default.createElement(_Popover.PopoverContent, {
    "aria-hidden": "true",
    className: "".concat(prefix, "--tooltip-content"),
    id: id,
    ref: tooltipRef,
    role: "tooltip"
  }, label || description));
}

Tooltip.propTypes = {
  /**
   * Specify how the trigger should align with the tooltip
   */
  align: _propTypes.default.oneOf(['top', 'top-left', 'top-right', 'bottom', 'bottom-left', 'bottom-right', 'left', 'left-bottom', 'left-top', 'right', 'right-bottom', 'right-top']),

  /**
   * Pass in the child to which the tooltip will be applied
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the tooltip should be open when it first renders
   */
  defaultOpen: _propTypes.default.bool,

  /**
   * Provide the description to be rendered inside of the Tooltip. The
   * description will use `aria-describedby` and will describe the child node
   * in addition to the text rendered inside of the child. This means that if you
   * have text in the child node, that it will be announced alongside the
   * description to the screen reader.
   *
   * Note: if label and description are both provided, label will be used and
   * description will not be used
   */
  description: _propTypes.default.node,

  /**
   * Specify the duration in milliseconds to delay before displaying the tooltip
   */
  enterDelayMs: _propTypes.default.number,

  /**
   * Provide the label to be rendered inside of the Tooltip. The label will use
   * `aria-labelledby` and will fully describe the child node that is provided.
   * This means that if you have text in the child node, that it will not be
   * announced to the screen reader.
   *
   * Note: if label and description are both provided, description will not be
   * used
   */
  label: _propTypes.default.node,

  /**
   * Specify the duration in milliseconds to delay before hiding the tooltip
   */
  leaveDelayMs: _propTypes.default.number
};