"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _enzyme = require("enzyme");

var _TooltipIcon = _interopRequireDefault(require("../TooltipIcon"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
describe('TooltipIcon', function () {
  var mockProps;
  beforeEach(function () {
    mockProps = {
      direction: 'bottom',
      children: /*#__PURE__*/_react.default.createElement("svg", null),
      className: 'custom-class',
      tooltipText: 'tooltip text'
    };
  });
  it('should render', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_TooltipIcon.default, mockProps));
    expect(wrapper).toMatchSnapshot();
  });
  it('should add extra classes via className', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_TooltipIcon.default, mockProps));
    expect(wrapper.hasClass('custom-class')).toBe(true);
  });
  it('should have an ID on the content container by default', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_TooltipIcon.default, mockProps));
    expect(wrapper.find('.bx--assistive-text').props().id).toBeTruthy();
  });
  it('should allow the user to specify the direction', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_TooltipIcon.default, (0, _extends2.default)({}, mockProps, {
      direction: "top"
    })));
    expect(wrapper).toMatchSnapshot();
  });
});