"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _classnames = _interopRequireDefault(require("classnames"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _usePrefix = require("../../internal/usePrefix");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var HeaderSideNavItems = function HeaderSideNavItems(_ref) {
  var _cx;

  var customClassName = _ref.className,
      children = _ref.children,
      hasDivider = _ref.hasDivider;
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__header-navigation"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__header-divider"), hasDivider), _cx), customClassName);
  return /*#__PURE__*/_react.default.createElement("div", {
    className: className
  }, children);
};

HeaderSideNavItems.propTypes = {
  /**
   * The child nodes to be rendered
   */
  children: _propTypes.default.node,

  /**
   * Optionally provide a custom class name that is applied to the underlying
   * button
   */
  className: _propTypes.default.string,

  /**
   * Optionally specify if container will have a bottom divider to differentiate
   * between original sidenav items and header menu items. False by default.
   */
  hasDivider: _propTypes.default.bool
};
HeaderSideNavItems.defaultProps = {
  hasDivider: false
};
var _default = HeaderSideNavItems;
exports.default = _default;