"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.SideNavMenu = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _iconsReact = require("@carbon/icons-react");

var _carbonComponents = require("carbon-components");

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _SideNavIcon = _interopRequireDefault(require("./SideNavIcon"));

var _keyboard = require("../../internal/keyboard");

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

var prefix = _carbonComponents.settings.prefix;

var SideNavMenu = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(SideNavMenu, _React$Component);

  var _super = _createSuper(SideNavMenu);

  function SideNavMenu(props) {
    var _this;

    (0, _classCallCheck2.default)(this, SideNavMenu);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleToggleExpand", function () {
      _this.setState(function (state) {
        return {
          isExpanded: !state.isExpanded
        };
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleKeyDown", function (event) {
      if ((0, _keyboard.match)(event, _keyboard.keys.Escape)) {
        _this.setState(function () {
          return {
            isExpanded: false
          };
        });
      }
    });
    _this.state = {
      isExpanded: props.defaultExpanded || false,
      wasPreviouslyExpanded: props.defaultExpanded || false
    };
    return _this;
  }

  (0, _createClass2.default)(SideNavMenu, [{
    key: "render",
    value: function render() {
      var _cx;

      var _this$props = this.props,
          buttonRef = _this$props.buttonRef,
          customClassName = _this$props.className,
          children = _this$props.children,
          IconElement = _this$props.renderIcon,
          isActive = _this$props.isActive,
          title = _this$props.title,
          large = _this$props.large;
      var isExpanded = this.state.isExpanded;
      var hasActiveChild;

      if (children) {
        // if we have children, either a single or multiple, find if it is active
        hasActiveChild = Array.isArray(children) ? children.some(function (child) {
          if (child.props && (child.props.isActive === true || child.props['aria-current'])) {
            return true;
          }

          return false;
        }) : children.props && (children.props.isActive === true || children.props['aria-current']);
      }

      var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item--active"), isActive || hasActiveChild && !isExpanded), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item--icon"), IconElement), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__item--large"), large), (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), _cx));
      return (
        /*#__PURE__*/
        // eslint-disable-next-line jsx-a11y/no-noninteractive-element-interactions
        _react.default.createElement("li", {
          className: className,
          onKeyDown: this.handleKeyDown
        }, /*#__PURE__*/_react.default.createElement("button", {
          "aria-expanded": isExpanded,
          className: "".concat(prefix, "--side-nav__submenu"),
          onClick: this.handleToggleExpand,
          ref: buttonRef,
          type: "button"
        }, IconElement && /*#__PURE__*/_react.default.createElement(_SideNavIcon.default, null, /*#__PURE__*/_react.default.createElement(IconElement, null)), /*#__PURE__*/_react.default.createElement("span", {
          className: "".concat(prefix, "--side-nav__submenu-title")
        }, title), /*#__PURE__*/_react.default.createElement(_SideNavIcon.default, {
          className: "".concat(prefix, "--side-nav__submenu-chevron"),
          small: true
        }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronDown20, null))), /*#__PURE__*/_react.default.createElement("ul", {
          className: "".concat(prefix, "--side-nav__menu")
        }, children))
      );
    }
  }]);
  return SideNavMenu;
}(_react.default.Component);

exports.SideNavMenu = SideNavMenu;
(0, _defineProperty2.default)(SideNavMenu, "propTypes", {
  buttonRef: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.shape({
    current: _propTypes.default.any
  })]),

  /**
   * Provide <SideNavMenuItem>'s inside of the `SideNavMenu`
   */
  children: _propTypes.default.node,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether the menu should default to expanded. By default, it will
   * be closed.
   */
  defaultExpanded: _propTypes.default.bool,

  /**
   * Specify whether the `SideNavMenu` is "active". `SideNavMenu` should be
   * considered active if one of its menu items are a link for the current
   * page.
   */
  isActive: _propTypes.default.bool,

  /**
   * Property to indicate if the side nav container is open (or not). Use to
   * keep local state and styling in step with the SideNav expansion state.
   */
  isSideNavExpanded: _propTypes.default.bool,

  /**
   * Specify if this is a large variation of the SideNavMenu
   */
  large: _propTypes.default.bool,

  /**
   * Pass in a custom icon to render next to the `SideNavMenu` title
   */
  renderIcon: _propTypes.default.oneOfType([_propTypes.default.func, _propTypes.default.object]),

  /**
   * Provide the text for the overall menu name
   */
  title: _propTypes.default.string.isRequired
});
(0, _defineProperty2.default)(SideNavMenu, "defaultProps", {
  defaultExpanded: false,
  isActive: false,
  large: false
});
(0, _defineProperty2.default)(SideNavMenu, "getDerivedStateFromProps", function (props, state) {
  var derivedState = null;

  if (props.isSideNavExpanded === false && state.isExpanded === true) {
    derivedState = {
      isExpanded: props.isSideNavExpanded,
      wasPreviouslyExpanded: true
    };
  } else if (props.isSideNavExpanded === true && state.wasPreviouslyExpanded === true) {
    derivedState = {
      isExpanded: props.isSideNavExpanded,
      wasPreviouslyExpanded: false
    };
  }

  return derivedState;
});

var SideNavMenuForwardRef = /*#__PURE__*/_react.default.forwardRef(function (props, ref) {
  return /*#__PURE__*/_react.default.createElement(SideNavMenu, (0, _extends2.default)({}, props, {
    buttonRef: ref
  }));
});

SideNavMenuForwardRef.displayName = 'SideNavMenu';
var _default = SideNavMenuForwardRef;
exports.default = _default;