"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _SideNavLinkText = _interopRequireDefault(require("./SideNavLinkText"));

var _Link = _interopRequireDefault(require("./Link"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["children", "className", "isActive"];

var SideNavMenuItem = /*#__PURE__*/_react.default.forwardRef(function SideNavMenuItem(props, ref) {
  var _cx;

  var prefix = (0, _usePrefix.usePrefix)();
  var children = props.children,
      customClassName = props.className,
      isActive = props.isActive,
      rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var className = (0, _classnames.default)("".concat(prefix, "--side-nav__menu-item"), customClassName);
  var linkClassName = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__link"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--side-nav__link--current"), isActive), _cx));
  return /*#__PURE__*/_react.default.createElement("li", {
    className: className
  }, /*#__PURE__*/_react.default.createElement(_Link.default, (0, _extends2.default)({}, rest, {
    className: linkClassName,
    ref: ref
  }), /*#__PURE__*/_react.default.createElement(_SideNavLinkText.default, null, children)));
});

SideNavMenuItem.displayName = 'SideNavMenuItem';
SideNavMenuItem.propTypes = {
  /**
   * Specify the children to be rendered inside of the `SideNavMenuItem`
   */
  children: _propTypes.default.node,

  /**
   * Provide an optional class to be applied to the containing node
   */
  className: _propTypes.default.string,

  /**
   * Optionally specify whether the link is "active". An active link is one that
   * has an href that is the same as the current page. Can also pass in
   * `aria-current="page"`, as well.
   */
  isActive: _propTypes.default.bool
};
var _default = SideNavMenuItem;
exports.default = _default;