"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _AriaPropTypes = require("../../prop-types/AriaPropTypes");

var _Link = _interopRequireDefault(require("./Link"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["aria-label", "aria-labelledby", "className", "children", "isSelected"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { (0, _defineProperty2.default)(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

var SwitcherItem = /*#__PURE__*/_react.default.forwardRef(function SwitcherItem(props, ref) {
  var prefix = (0, _usePrefix.usePrefix)();
  var ariaLabel = props['aria-label'],
      ariaLabelledBy = props['aria-labelledby'],
      customClassName = props.className,
      children = props.children,
      isSelected = props.isSelected,
      rest = (0, _objectWithoutProperties2.default)(props, _excluded);
  var className = (0, _classnames.default)("".concat(prefix, "--switcher__item"), (0, _defineProperty2.default)({}, customClassName, !!customClassName));
  var accessibilityLabel = {
    'aria-label': ariaLabel,
    'aria-labelledby': ariaLabelledBy
  };
  var linkClassName = (0, _classnames.default)("".concat(prefix, "--switcher__item-link"), (0, _defineProperty2.default)({}, "".concat(prefix, "--switcher__item-link--selected"), isSelected));
  return /*#__PURE__*/_react.default.createElement("li", {
    className: className
  }, /*#__PURE__*/_react.default.createElement(_Link.default, (0, _extends2.default)({}, rest, {
    ref: ref,
    className: linkClassName,
    tabIndex: 0
  }, accessibilityLabel), children));
});

SwitcherItem.displayName = 'SwitcherItem';
SwitcherItem.propTypes = _objectSpread(_objectSpread({}, _AriaPropTypes.AriaLabelPropType), {}, {
  /**
   * Specify the text content for the link
   */
  children: _propTypes.default.node.isRequired,

  /**
   * Optionally provide a custom class to apply to the underlying `<li>` node
   */
  className: _propTypes.default.string
});
var _default = SwitcherItem;
exports.default = _default;