"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames2 = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["children", "className", "nested", "isExpressive"];

var UnorderedList = function UnorderedList(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      nested = _ref.nested,
      isExpressive = _ref.isExpressive,
      other = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var classNames = (0, _classnames2.default)("".concat(prefix, "--list--unordered"), className, (_classnames = {}, (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--list--nested"), nested), (0, _defineProperty2.default)(_classnames, "".concat(prefix, "--list--expressive"), isExpressive), _classnames));
  return /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
    className: classNames
  }, other), children);
};

UnorderedList.propTypes = {
  /**
   * Specify a collection of ListItem's to be rendered in the UnorderedList
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the underlying `<ul>` node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether this ordered list expressive or not
   */
  isExpressive: _propTypes.default.bool,

  /**
   * Specify whether the list is nested, or not
   */
  nested: _propTypes.default.bool
};
UnorderedList.defaultProps = {
  nested: false,
  isExpressive: false
};
var _default = UnorderedList;
exports.default = _default;