"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSelection = useSelection;
exports.default = void 0;

var _classCallCheck2 = _interopRequireDefault(require("@babel/runtime/helpers/classCallCheck"));

var _createClass2 = _interopRequireDefault(require("@babel/runtime/helpers/createClass"));

var _assertThisInitialized2 = _interopRequireDefault(require("@babel/runtime/helpers/assertThisInitialized"));

var _inherits2 = _interopRequireDefault(require("@babel/runtime/helpers/inherits"));

var _possibleConstructorReturn2 = _interopRequireDefault(require("@babel/runtime/helpers/possibleConstructorReturn"));

var _getPrototypeOf2 = _interopRequireDefault(require("@babel/runtime/helpers/getPrototypeOf"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = _interopRequireWildcard(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _lodash = _interopRequireDefault(require("lodash.isequal"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = (0, _getPrototypeOf2.default)(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = (0, _getPrototypeOf2.default)(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return (0, _possibleConstructorReturn2.default)(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

function callOnChangeHandler(_ref) {
  var isControlled = _ref.isControlled,
      isMounted = _ref.isMounted,
      onChangeHandlerControlled = _ref.onChangeHandlerControlled,
      onChangeHandlerUncontrolled = _ref.onChangeHandlerUncontrolled,
      selectedItems = _ref.selectedItems;

  if (isControlled) {
    if (isMounted && onChangeHandlerControlled) {
      onChangeHandlerControlled({
        selectedItems: selectedItems
      });
    }
  } else {
    onChangeHandlerUncontrolled(selectedItems);
  }
}

function useSelection(_ref2) {
  var disabled = _ref2.disabled,
      onChange = _ref2.onChange,
      _ref2$initialSelected = _ref2.initialSelectedItems,
      initialSelectedItems = _ref2$initialSelected === void 0 ? [] : _ref2$initialSelected,
      controlledItems = _ref2.selectedItems;
  var isMounted = (0, _react.useRef)(false);
  var savedOnChange = (0, _react.useRef)(onChange);

  var _useState = (0, _react.useState)(initialSelectedItems),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      uncontrolledItems = _useState2[0],
      setUncontrolledItems = _useState2[1];

  var isControlled = !!controlledItems;
  var selectedItems = isControlled ? controlledItems : uncontrolledItems;
  var onItemChange = (0, _react.useCallback)(function (item) {
    if (disabled) {
      return;
    }

    var selectedIndex;
    selectedItems.forEach(function (selectedItem, index) {
      if ((0, _lodash.default)(selectedItem, item)) {
        selectedIndex = index;
      }
    });
    var newSelectedItems;

    if (selectedIndex === undefined) {
      newSelectedItems = selectedItems.concat(item);
      callOnChangeHandler({
        isControlled: isControlled,
        isMounted: isMounted.current,
        onChangeHandlerControlled: savedOnChange.current,
        onChangeHandlerUncontrolled: setUncontrolledItems,
        selectedItems: newSelectedItems
      });
      return;
    }

    newSelectedItems = removeAtIndex(selectedItems, selectedIndex);
    callOnChangeHandler({
      isControlled: isControlled,
      isMounted: isMounted.current,
      onChangeHandlerControlled: savedOnChange.current,
      onChangeHandlerUncontrolled: setUncontrolledItems,
      selectedItems: newSelectedItems
    });
  }, [disabled, isControlled, selectedItems]);
  var clearSelection = (0, _react.useCallback)(function () {
    if (disabled) {
      return;
    }

    callOnChangeHandler({
      isControlled: isControlled,
      isMounted: isMounted.current,
      onChangeHandlerControlled: savedOnChange.current,
      onChangeHandlerUncontrolled: setUncontrolledItems,
      selectedItems: []
    });
  }, [disabled, isControlled]);
  (0, _react.useEffect)(function () {
    savedOnChange.current = onChange;
  }, [onChange]);
  (0, _react.useEffect)(function () {
    if (isMounted.current && savedOnChange.current && !isControlled) {
      savedOnChange.current({
        selectedItems: selectedItems
      });
    }
  }, [isControlled, selectedItems]);
  (0, _react.useEffect)(function () {
    isMounted.current = true;
    return function () {
      isMounted.current = false;
    };
  }, []);
  return {
    selectedItems: selectedItems,
    onItemChange: onItemChange,
    clearSelection: clearSelection
  };
}

var Selection = /*#__PURE__*/function (_React$Component) {
  (0, _inherits2.default)(Selection, _React$Component);

  var _super = _createSuper(Selection);

  function Selection(props) {
    var _this;

    (0, _classCallCheck2.default)(this, Selection);
    _this = _super.call(this, props);
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "internalSetState", function (stateToSet, callback) {
      return _this.setState(stateToSet, function () {
        if (callback) {
          callback();
        }

        if (_this.props.onChange) {
          _this.props.onChange(_this.state);
        }
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleClearSelection", function () {
      if (_this.props.disabled) {
        return;
      }

      _this.internalSetState({
        selectedItems: []
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleSelectItem", function (item) {
      _this.internalSetState(function (state) {
        return {
          selectedItems: state.selectedItems.concat(item)
        };
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleRemoveItem", function (index) {
      _this.internalSetState(function (state) {
        return {
          selectedItems: removeAtIndex(state.selectedItems, index)
        };
      });
    });
    (0, _defineProperty2.default)((0, _assertThisInitialized2.default)(_this), "handleOnItemChange", function (item) {
      if (_this.props.disabled) {
        return;
      }

      var selectedItems = _this.state.selectedItems;
      var selectedIndex;
      selectedItems.forEach(function (selectedItem, index) {
        if ((0, _lodash.default)(selectedItem, item)) {
          selectedIndex = index;
        }
      });

      if (selectedIndex === undefined) {
        _this.handleSelectItem(item);

        return;
      }

      _this.handleRemoveItem(selectedIndex);
    });
    _this.state = {
      selectedItems: props.initialSelectedItems
    };
    return _this;
  }

  (0, _createClass2.default)(Selection, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          render = _this$props.render;
      var selectedItems = this.state.selectedItems;
      var renderProps = {
        selectedItems: selectedItems,
        onItemChange: this.handleOnItemChange,
        clearSelection: this.handleClearSelection
      };

      if (render !== undefined) {
        return render(renderProps);
      }

      if (children !== undefined) {
        return children(renderProps);
      }

      return null;
    }
  }]);
  return Selection;
}(_react.default.Component); // Generic utility for safely removing an element at a given index from an
// array.


exports.default = Selection;
(0, _defineProperty2.default)(Selection, "propTypes", {
  children: _propTypes.default.func,
  disabled: _propTypes.default.bool,
  initialSelectedItems: _propTypes.default.array.isRequired,
  onChange: _propTypes.default.func,
  render: _propTypes.default.func
});
(0, _defineProperty2.default)(Selection, "defaultProps", {
  initialSelectedItems: []
});

var removeAtIndex = function removeAtIndex(array, index) {
  var result = array.slice();
  result.splice(index, 1);
  return result;
};