"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useDelayedState = useDelayedState;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

var _react = require("react");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * `useDelayedState` mirrors `useState` but also allows you to add a delay to
 * when your state updates. You can provide a second argument to `setState`,
 * `delayMs`, which will be the time in milliseconds after which the state is
 * updated.
 *
 * This hook will clean up pending timers in `useEffect` and will cancel any
 * pending timers when a `setState` is called before the state is updated from
 * a previous call
 */
function useDelayedState(initialState) {
  var _useState = (0, _react.useState)(initialState),
      _useState2 = (0, _slicedToArray2.default)(_useState, 2),
      state = _useState2[0],
      setState = _useState2[1];

  var timeoutId = (0, _react.useRef)(null); // We use `useCallback` to match the signature of React's `useState` which will
  // always return the same reference for the `setState` updater

  var setStateWithDelay = (0, _react.useCallback)(function (stateToSet) {
    var delayMs = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
    clearTimeout(timeoutId.current);
    timeoutId.current = null;

    if (delayMs === 0) {
      setState(stateToSet);
      return;
    }

    timeoutId.current = setTimeout(function () {
      setState(stateToSet);
      timeoutId.current = null;
    }, delayMs);
  }, []);
  (0, _react.useEffect)(function () {
    return function () {
      clearTimeout(timeoutId.current);
    };
  }, []);
  return [state, setStateWithDelay];
}