"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useOutsideClick = useOutsideClick;

var _react = require("react");

var _useEvent = require("./useEvent");

var _environment = require("./environment");

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
function useOutsideClick(ref, callback) {
  var savedCallback = (0, _react.useRef)(callback);
  (0, _react.useEffect)(function () {
    savedCallback.current = callback;
  }); // We conditionally guard the `useEvent` hook for SSR. `canUseDOM` can be
  // treated as a constant as it will be false when executed in a Node.js
  // environment and true when executed in the browser

  if (_environment.canUseDOM) {
    // eslint-disable-next-line react-hooks/rules-of-hooks
    (0, _useEvent.useEvent)(window, 'click', function (event) {
      if (ref.current && !ref.current.contains(event.target)) {
        savedCallback.current(event);
      }
    });
  }
}