"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mapDownshiftProps = void 0;

var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */

/**
 * Create an adapter that converts an object of props with potentially deprecated
 * prop names to the replacement prop names in a newer version. Useful for guarding
 * against breaking changes when a prop has been renamed
 *
 * @param {Array} spec - an array of options which specify a text or regex
 * matcher alongside a replacement if there is a match
 * @returns {Function}
 */
function createPropAdapter(spec) {
  // if props aren't passed in we should default the prop to empty object
  return function () {
    var input = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    var output = {};
    Object.keys(input).forEach(function (key) {
      var match = spec.find(function (_ref) {
        var _ref2 = (0, _slicedToArray2.default)(_ref, 1),
            regex = _ref2[0];

        return key.match(regex);
      });

      if (match) {
        var _match = (0, _slicedToArray2.default)(match, 2),
            regex = _match[0],
            replacer = _match[1];

        output[key.replace(regex, replacer)] = input[key];
        return;
      }

      output[key] = input[key];
    });
    return output;
  };
}
/**
 * TODO: REMOVE IN v11
 * props staring with "default..." were changed to "initial..." in Downshift v3
 *
 * @see https://github.com/downshift-js/downshift/releases/tag/v3.0.0
 */


var mapDownshiftProps = createPropAdapter([[/^default/g, 'initial']]);
exports.mapDownshiftProps = mapDownshiftProps;