"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _pluginClientCommon = require("@kui-shell/plugin-client-common");

var _proxy = _interopRequireDefault(require("@kui-shell/client/config.d/proxy.json"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-proxy-support');
/** class designation for our offline indicator */

const buttonDesignation = 'kui--plugin-bash-like--pty-offline-indicator';

class ProxyOfflineIndicator extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.cleaners = [];
    const {
      proxyServer
    } = _proxy.default;
    const proxyEnabled = proxyServer['enabled'] === undefined || proxyServer['enabled'] !== false;
    this.state = {
      proxyEnabled,
      offline: true
    };
  }

  componentDidMount() {
    const onOnline = () => this.setState({
      offline: false
    });

    _core.eventChannelUnsafe.on('/proxy/online', onOnline);

    this.cleaners.push(() => _core.eventChannelUnsafe.off('/proxy/online', onOnline));

    const onOffline = () => this.setState({
      offline: true
    });

    _core.eventChannelUnsafe.on('/proxy/offline', onOffline);

    this.cleaners.push(() => _core.eventChannelUnsafe.off('/proxy/offline', onOffline));
  }

  componentWillUnmount() {
    this.cleaners.forEach(cleaner => cleaner());
    this.cleaners = [];
  }
  /** If the proxy is enabled, and we are offline, then render a widget indicating such. */


  render() {
    if (!this.state.proxyEnabled || !this.state.offline || !(0, _core.inBrowser)()) {
      return _react.default.createElement(_react.default.Fragment, null);
    } else {
      return _react.default.createElement(_pluginClientCommon.TagWidget, {
        id: buttonDesignation,
        type: "error"
      }, strings('Offline'));
    }
  }

}

exports.default = ProxyOfflineIndicator;