"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _debug = _interopRequireDefault(require("debug"));

var _child_process = require("child_process");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const debug = (0, _debug.default)('plugins/bash-like/pty/kuirc');

/**
 * Preprocess bash/zsh aliases
 *
 */
function prefetchAliases() {
  // eslint-disable-next-line no-async-promise-executor
  return new Promise((resolve, reject) => __awaiter(this, void 0, void 0, function* () {
    if (process.platform === 'win32') {
      debug('skipping prefetchAliases');
      return resolve('');
    }

    debug('prefetchAliases');
    const os = Promise.resolve().then(() => require('os'));
    const fs = Promise.resolve().then(() => require('fs'));
    const path = Promise.resolve().then(() => require('path'));
    const uuid = Promise.resolve().then(() => require('uuid'));
    const {
      getLoginShell
    } = yield Promise.resolve().then(() => require('./server'));
    const shell = yield getLoginShell();
    debug('prefetchAliases got shell', shell);
    (0, _child_process.exec)(`${shell} -l -c alias`, (err, stdout, stderr) => __awaiter(this, void 0, void 0, function* () {
      try {
        if (stderr) {
          debug(stderr);
        }

        if (err) {
          debug('error in prefetchAliases 1', err);
          reject(err);
        } else {
          debug('got aliases');
          const aliases = stdout.toString().split(/\n/).filter(_ => _).map(alias => {
            if (!/^alias /.test(alias)) {
              return `alias ${alias}`;
            } else {
              return alias;
            }
          }).join('\n');
          const kuirc = (yield path).join((yield os).tmpdir(), `kuirc-${(yield uuid).v4()}`);
          debug('kuirc', kuirc);
          (yield fs).writeFile(kuirc, aliases, err => {
            if (err) {
              debug(err);
              reject(err);
            } else {
              resolve(kuirc);
            }
          });
        }
      } catch (err) {
        console.error('error in prefetchEnv 2', err);
        reject(err);
      }
    }));
  }));
}

const kuirc = prefetchAliases();
var _default = kuirc;
exports.default = _default;