"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.showResponseAsMMR = showResponseAsMMR;
exports.default = void 0;

var _debug = _interopRequireDefault(require("debug"));

var _path = require("path");

var _core = require("@kui-shell/core");

var _open = require("./open");

var _delegates = require("../vfs/delegates");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

const strings = (0, _core.i18n)('plugin-bash-like');
const debug = (0, _debug.default)('plugins/bash-like/cmds/head');

function showResponseAsMMR(filepath, data) {
  const suffix = filepath.substring(filepath.lastIndexOf('.') + 1);
  const enclosingDirectory = (0, _path.dirname)(filepath);
  const packageName = enclosingDirectory === '.' ? undefined : enclosingDirectory;
  const mode = {
    mode: 'view',
    label: strings('View'),
    contentType: (0, _open.contentTypeOf)(suffix),
    content: data
  };
  const response = {
    apiVersion: 'kui-shell/v1',
    kind: 'File',
    metadata: {
      name: (0, _path.basename)(filepath),
      namespace: packageName
    },
    modes: [mode],
    spec: {
      filepath,
      size: 0,
      fullpath: (0, _core.findFile)((0, _core.expandHomeDir)(filepath))
    }
  };
  return response;
}

function head(args) {
  return __awaiter(this, void 0, void 0, function* () {
    const {
      argvNoOptions,
      parsedOptions
    } = args;
    const filepath = argvNoOptions[argvNoOptions.indexOf('head') + 1];
    debug('head', filepath);

    if (typeof filepath === 'number' && filepath < 0) {
      // special case for command: e.g. head -10 file
      // change `head -10 file` to `head -n 10 file`
      const newarg = `-n ${filepath * -1}`;
      return args.REPL.qexec(args.command.replace(filepath, newarg));
    }

    try {
      const data = yield (0, _delegates.fslice)(filepath, 0, parsedOptions.c || parsedOptions.n || 10, parsedOptions.c ? 'bytes' : 'lines');
      return showResponseAsMMR(filepath, data);
    } catch (err) {
      throw new Error(`head: ${err.message}`);
    }
  });
}
/**
 * Register command handlers
 *
 */


var _default = registrar => {
  registrar.listen('/head', head, {
    requiresLocal: true
  });
};

exports.default = _default;