"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _cd = _interopRequireDefault(require("./lib/cd"));

var _ls = _interopRequireDefault(require("./lib/ls"));

var _edit = _interopRequireDefault(require("./lib/edit"));

var _head = _interopRequireDefault(require("./lib/head"));

var _tail = _interopRequireDefault(require("./lib/tail"));

var _open = _interopRequireDefault(require("./lib/open"));

var _fwrite = _interopRequireDefault(require("./lib/fwrite"));

var _mkTemp = _interopRequireDefault(require("./lib/mkTemp"));

var _controller = _interopRequireDefault(require("./vfs/controller"));

var _tabCompletion = require("./lib/tab-completion");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2019 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

/**
 * This is the module
 *
 */
var _default = registrar => __awaiter(void 0, void 0, void 0, function* () {
  yield Promise.all([(0, _cd.default)(registrar), (0, _ls.default)(registrar), (0, _edit.default)(registrar), (0, _head.default)(registrar), (0, _tail.default)(registrar), (0, _open.default)(registrar), (0, _fwrite.default)(registrar), (0, _mkTemp.default)(registrar), (0, _controller.default)(registrar), (0, _tabCompletion.plugin)(registrar)]);
});

exports.default = _default;