# Change Log

All notable changes to this project will be documented in this file.
See [Conventional Commits](https://conventionalcommits.org) for commit guidelines.

## [10.3.27](https://github.com/IBM/kui/compare/v10.3.26...v10.3.27) (2021-06-30)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.26](https://github.com/IBM/kui/compare/v10.3.25...v10.3.26) (2021-06-29)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.25](https://github.com/IBM/kui/compare/v10.3.24...v10.3.25) (2021-06-29)

### Bug Fixes

- **plugins/plugin-client-common:** kubectl Status cell can be empty with splits ([85f5fc7](https://github.com/IBM/kui/commit/85f5fc7)), closes [#7726](https://github.com/IBM/kui/issues/7726)

## [10.3.24](https://github.com/IBM/kui/compare/v10.3.23...v10.3.24) (2021-06-24)

### Bug Fixes

- **plugins/plugin-client-common:** Logs/Terminal container selector cannot be interacted with ([aca39f4](https://github.com/IBM/kui/commit/aca39f4)), closes [#7707](https://github.com/IBM/kui/issues/7707)

## [10.3.23](https://github.com/IBM/kui/compare/v10.3.22...v10.3.23) (2021-06-18)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.22](https://github.com/IBM/kui/compare/v10.3.21...v10.3.22) (2021-06-15)

### Bug Fixes

- **plugins/plugin-kubectl:** CurrentContext/CurrentNamespace widgets show nothing while loading ([3453fb2](https://github.com/IBM/kui/commit/3453fb2)), closes [#7629](https://github.com/IBM/kui/issues/7629)

## [10.3.21](https://github.com/IBM/kui/compare/v10.3.20...v10.3.21) (2021-06-14)

### Bug Fixes

- **plugins/plugin-client-common:** clicking on split blank space does not focus active block ([cb63e34](https://github.com/IBM/kui/commit/cb63e34)), closes [#7618](https://github.com/IBM/kui/issues/7618)
- **plugins/plugin-client-common:** sidecar editor buttons have no padding ([3d85733](https://github.com/IBM/kui/commit/3d85733)), closes [#7616](https://github.com/IBM/kui/issues/7616)

## [10.3.20](https://github.com/IBM/kui/compare/v10.3.19...v10.3.20) (2021-06-10)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.19](https://github.com/IBM/kui/compare/v10.3.18...v10.3.19) (2021-06-10)

### Bug Fixes

- width of vi not correct after closing splits ([0ac9af0](https://github.com/IBM/kui/commit/0ac9af0)), closes [#7600](https://github.com/IBM/kui/issues/7600)
- **plugins/plugin-client-common:** after clicking split Clear button, that split's input should have focus ([d7fb8af](https://github.com/IBM/kui/commit/d7fb8af)), closes [#7585](https://github.com/IBM/kui/issues/7585)
- **plugins/plugin-client-common:** Block UI has transient orange outline on focus ([8000b66](https://github.com/IBM/kui/commit/8000b66)), closes [#7596](https://github.com/IBM/kui/issues/7596)
- **plugins/plugin-client-common:** fullscreen pty apps like vi are a bit too tall ([b65e507](https://github.com/IBM/kui/commit/b65e507)), closes [#7598](https://github.com/IBM/kui/issues/7598)
- history commands in bottom-input mode show history of Primary Tab instead of Split ([f467a8d](https://github.com/IBM/kui/commit/f467a8d))
- **plugins/plugin-client-common:** remove the "press ctrl+d to close this split" placeholder text ([01e6799](https://github.com/IBM/kui/commit/01e6799)), closes [#7587](https://github.com/IBM/kui/issues/7587)
- StatusStripe text can oddly overflow ([9d989fd](https://github.com/IBM/kui/commit/9d989fd))

## [10.3.18](https://github.com/IBM/kui/compare/v10.3.17...v10.3.18) (2021-06-08)

### Bug Fixes

- **plugins/plugin-client-common:** icons in dropdown in sidecar toolbar are too small ([52f41c6](https://github.com/IBM/kui/commit/52f41c6))
- **plugins/plugin-client-common:** rerunning a block when there is an active block seems to insert a new block ([028e738](https://github.com/IBM/kui/commit/028e738))
- sidecar toolbar buttons use different tooltip style than split close/clear buttons ([ef90713](https://github.com/IBM/kui/commit/ef90713)), closes [#7568](https://github.com/IBM/kui/issues/7568)
- split close button is not tab navigable ([3c79ff6](https://github.com/IBM/kui/commit/3c79ff6))

## [10.3.17](https://github.com/IBM/kui/compare/v10.3.16...v10.3.17) (2021-06-07)

### Features

- SplitHeader should have a clear button ([bced3f9](https://github.com/IBM/kui/commit/bced3f9))

## [10.3.16](https://github.com/IBM/kui/compare/v10.3.15...v10.3.16) (2021-06-07)

### Bug Fixes

- **plugins/plugin-client-common:** new tab and new split tooltips suggest incorrect keyboard shortcuts inBrowser ([36b58f4](https://github.com/IBM/kui/commit/36b58f4)), closes [#7515](https://github.com/IBM/kui/issues/7515)
- **plugins/plugin-client-common:** sidecar drilldown can result in react warning in console ([be2c7cb](https://github.com/IBM/kui/commit/be2c7cb)), closes [#7539](https://github.com/IBM/kui/issues/7539)
- **plugins/plugin-client-common:** split close button lacks tooltip ([7162bd8](https://github.com/IBM/kui/commit/7162bd8)), closes [#7549](https://github.com/IBM/kui/issues/7549)
- **plugins/plugin-client-common:** split headers have low contrast in dark themes ([0e22862](https://github.com/IBM/kui/commit/0e22862)), closes [#7538](https://github.com/IBM/kui/issues/7538)
- **plugins/plugin-client-common:** StatusStripe widgets may have double borders ([cff3551](https://github.com/IBM/kui/commit/cff3551)), closes [#7544](https://github.com/IBM/kui/issues/7544)

## [10.3.15](https://github.com/IBM/kui/compare/v10.3.14...v10.3.15) (2021-06-04)

### Bug Fixes

- **plugins/plugin-client-common:** when rerunning blocks, output always scrolls to bottom ([23e6728](https://github.com/IBM/kui/commit/23e6728)), closes [#7527](https://github.com/IBM/kui/issues/7527)

### Features

- **plugins/plugin-client-common:** ability to close a split via UI gesture ([de275f6](https://github.com/IBM/kui/commit/de275f6)), closes [#7530](https://github.com/IBM/kui/issues/7530)

## [10.3.14](https://github.com/IBM/kui/compare/v10.3.13...v10.3.14) (2021-06-04)

### Bug Fixes

- **plugins/plugin-client-common:** content does not always reliably scroll into view after command execution ([bf6d6c1](https://github.com/IBM/kui/commit/bf6d6c1)), closes [#7524](https://github.com/IBM/kui/issues/7524)

## [10.3.13](https://github.com/IBM/kui/compare/v10.3.12...v10.3.13) (2021-06-02)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.12](https://github.com/IBM/kui/compare/v10.3.11...v10.3.12) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.11](https://github.com/IBM/kui/compare/v10.3.10...v10.3.11) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.10](https://github.com/IBM/kui/compare/v10.3.9...v10.3.10) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.9](https://github.com/IBM/kui/compare/v10.3.8...v10.3.9) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.8](https://github.com/IBM/kui/compare/v10.3.7...v10.3.8) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.7](https://github.com/IBM/kui/compare/v10.3.6...v10.3.7) (2021-06-01)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.6](https://github.com/IBM/kui/compare/v10.3.5...v10.3.6) (2021-05-28)

### Bug Fixes

- 3-way split should probably have equal-height ([70045bb](https://github.com/IBM/kui/commit/70045bb))
- **plugins/plugin-client-common:** Close button in confirm dialog does not work ([0712ab6](https://github.com/IBM/kui/commit/0712ab6))
- **plugins/plugin-client-common:** Popover and Dropdowns require double-click to close ([0eaac09](https://github.com/IBM/kui/commit/0eaac09))
- **plugins/plugin-client-common:** sidecar Kebab menu has nested <button> ([9488ea5](https://github.com/IBM/kui/commit/9488ea5))
- **plugins/plugin-client-common:** sidecar screenshot button is visible even inBrowser ([b3db2c2](https://github.com/IBM/kui/commit/b3db2c2))
- **plugins/plugin-client-common:** sidecar toolbar buttons are not vertically centered ([a4802c5](https://github.com/IBM/kui/commit/a4802c5)), closes [#7488](https://github.com/IBM/kui/issues/7488)
- vi doesn't take up the full dimensions of the viewport ([cc884a5](https://github.com/IBM/kui/commit/cc884a5)), closes [#7482](https://github.com/IBM/kui/issues/7482)

## [10.3.5](https://github.com/IBM/kui/compare/v10.3.4...v10.3.5) (2021-05-27)

### Bug Fixes

- using / for division is deprecated for sass ([d3e51a4](https://github.com/IBM/kui/commit/d3e51a4))
- **plugins/plugin-bash-like:** new tab in browser-based clients may result in multiple new sessions ([5044461](https://github.com/IBM/kui/commit/5044461)), closes [#7465](https://github.com/IBM/kui/issues/7465)
- **plugins/plugin-client-common:** input cursor will move to the end after tab-completes ([3aa474c](https://github.com/IBM/kui/commit/3aa474c))

## [10.3.4](https://github.com/IBM/kui/compare/v10.3.3...v10.3.4) (2021-05-24)

### Bug Fixes

- **plugins/plugin-client-common:** sourceRef's color isn't right in PatternFly Dark ([7f78ef3](https://github.com/IBM/kui/commit/7f78ef3))
- **plugins/plugin-client-common:** watchable blocks when replaced by rerun/reexec are not aborted ([bfbeace](https://github.com/IBM/kui/commit/bfbeace))

## [10.3.3](https://github.com/IBM/kui/compare/v10.3.2...v10.3.3) (2021-05-22)

### Bug Fixes

- **plugins/plugin-client-common:** clicking on YAML tab incorrectly shows "You are in edit mode" even if you aren't ([1525724](https://github.com/IBM/kui/commit/1525724)), closes [#7426](https://github.com/IBM/kui/issues/7426) [#7385](https://github.com/IBM/kui/issues/7385)
- **plugins/plugin-client-common:** the first time PTY output appears, Kui flashes briefly ([8178967](https://github.com/IBM/kui/commit/8178967))

## [10.3.2](https://github.com/IBM/kui/compare/v10.3.1...v10.3.2) (2021-05-20)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.3.1](https://github.com/IBM/kui/compare/v10.3.0...v10.3.1) (2021-05-18)

### Bug Fixes

- **plugins/plugin-client-common:** Add sass mixins for Grid cells and Card Footer ([b1f3b53](https://github.com/IBM/kui/commit/b1f3b53)), closes [#7410](https://github.com/IBM/kui/issues/7410)
- **plugins/plugin-client-common:** SequenceDiagram bars have odd transparent 1px border ([95fb07c](https://github.com/IBM/kui/commit/95fb07c)), closes [#7397](https://github.com/IBM/kui/issues/7397)

### Features

- **plugins/plugin-client-common:** Allow Grid provider to specify css attributes for cell UI ([4326c07](https://github.com/IBM/kui/commit/4326c07)), closes [#7408](https://github.com/IBM/kui/issues/7408)
- **plugins/plugin-kubectl:** allow for pinning a Kubernetes Context or Namespace to a tab ([91507c5](https://github.com/IBM/kui/commit/91507c5))

# [10.3.0](https://github.com/IBM/kui/compare/v4.5.0...v10.3.0) (2021-05-11)

### Bug Fixes

- **packages/core:** the pipeStages splitting logic should not remove quotes and backslash escapes ([1cd235b](https://github.com/IBM/kui/commit/1cd235b)), closes [#7199](https://github.com/IBM/kui/issues/7199)
- **plugin-client-common:** show the last input block in minisplit ([7997ef0](https://github.com/IBM/kui/commit/7997ef0)), closes [#5756](https://github.com/IBM/kui/issues/5756)
- **plugins-client-common:** bump carbon-components-react to 7.22 ([8b98791](https://github.com/IBM/kui/commit/8b98791)), closes [#6011](https://github.com/IBM/kui/issues/6011)
- **plugins/plugin-client-common:** "Drilled down to..." text is not aligned with the Input area ([fd139d2](https://github.com/IBM/kui/commit/fd139d2)), closes [#5854](https://github.com/IBM/kui/issues/5854)
- **plugins/plugin-client-common:** "No events in the past hour" in sidecar has different bg color than other tabs ([ffba806](https://github.com/IBM/kui/commit/ffba806)), closes [#6075](https://github.com/IBM/kui/issues/6075)
- **plugins/plugin-client-common:** `open index.html` can smash kui's stylesheets ([2b38e9b](https://github.com/IBM/kui/commit/2b38e9b)), closes [#7101](https://github.com/IBM/kui/issues/7101)
- **plugins/plugin-client-common:** a few more patternfly navigation styling issues ([5511c1f](https://github.com/IBM/kui/commit/5511c1f)), closes [#6049](https://github.com/IBM/kui/issues/6049)
- **plugins/plugin-client-common:** Action button hover hysteresis/delay effect not working ([fac75dc](https://github.com/IBM/kui/commit/fac75dc)), closes [#5806](https://github.com/IBM/kui/issues/5806)
- **plugins/plugin-client-common:** active pty output doesn't have repl-context ([6b0929e](https://github.com/IBM/kui/commit/6b0929e)), closes [#5960](https://github.com/IBM/kui/issues/5960)
- **plugins/plugin-client-common:** bars in Histogram view may slightly overlap ([5180715](https://github.com/IBM/kui/commit/5180715)), closes [#7157](https://github.com/IBM/kui/issues/7157)
- **plugins/plugin-client-common:** blockquotes in commentary don't render well ([9be35fa](https://github.com/IBM/kui/commit/9be35fa)), closes [#5931](https://github.com/IBM/kui/issues/5931)
- **plugins/plugin-client-common:** bump to pick up string-similarity-coloring@1.0.5 ([97613a7](https://github.com/IBM/kui/commit/97613a7)), closes [#7181](https://github.com/IBM/kui/issues/7181)
- **plugins/plugin-client-common:** Bump to string-similiarity-coloring@1.0.6 to improve consistency of coloring across data sets ([5818dab](https://github.com/IBM/kui/commit/5818dab)), closes [#7183](https://github.com/IBM/kui/issues/7183)
- **plugins/plugin-client-common:** clicking on table or radio table may cause block to disappear ([1f2d489](https://github.com/IBM/kui/commit/1f2d489)), closes [#5783](https://github.com/IBM/kui/issues/5783)
- **plugins/plugin-client-common:** ClipboardTransfer emits errors when pasting non-json text ([6ff85c4](https://github.com/IBM/kui/commit/6ff85c4)), closes [#5836](https://github.com/IBM/kui/issues/5836)
- **plugins/plugin-client-common:** CodeSnippet component renders with zero contrast in dark themes ([10e40a9](https://github.com/IBM/kui/commit/10e40a9)), closes [#5886](https://github.com/IBM/kui/issues/5886)
- **plugins/plugin-client-common:** colored squares in status column of tables have odd alignment ([3e78540](https://github.com/IBM/kui/commit/3e78540)), closes [#5766](https://github.com/IBM/kui/issues/5766)
- **plugins/plugin-client-common:** commentary editor can overflow with long lines ([3475287](https://github.com/IBM/kui/commit/3475287)), closes [#5981](https://github.com/IBM/kui/issues/5981)
- **plugins/plugin-client-common:** Commentary editor is 5px tall when presented in mini split ([53074d1](https://github.com/IBM/kui/commit/53074d1)), closes [#5744](https://github.com/IBM/kui/issues/5744)
- **plugins/plugin-client-common:** Commentary markdown does not support kuiexec ([4663389](https://github.com/IBM/kui/commit/4663389)), closes [#5911](https://github.com/IBM/kui/issues/5911)
- **plugins/plugin-client-common:** creating a split with a 3-way split configuration results in radical shuffling ([9452b5a](https://github.com/IBM/kui/commit/9452b5a)), closes [#5794](https://github.com/IBM/kui/issues/5794)
- **plugins/plugin-client-common:** Custom Popup clients cannot specify noSettings and noHelp properties ([b50d5d2](https://github.com/IBM/kui/commit/b50d5d2))
- **plugins/plugin-client-common:** custom repl-prompt is misaligned with repl-output ([d12b203](https://github.com/IBM/kui/commit/d12b203)), closes [#6046](https://github.com/IBM/kui/issues/6046)
- **plugins/plugin-client-common:** deleting and re-creating a split results double commands ([dde6eaa](https://github.com/IBM/kui/commit/dde6eaa)), closes [#5876](https://github.com/IBM/kui/issues/5876)
- **plugins/plugin-client-common:** disable minisplit ([b32a940](https://github.com/IBM/kui/commit/b32a940))
- **plugins/plugin-client-common:** disable Timeline option for Tables ([e88ebb3](https://github.com/IBM/kui/commit/e88ebb3)), closes [#5864](https://github.com/IBM/kui/issues/5864)
- **plugins/plugin-client-common:** do not show the command rerun and remove button for offline kui ([309162f](https://github.com/IBM/kui/commit/309162f)), closes [#5917](https://github.com/IBM/kui/issues/5917)
- **plugins/plugin-client-common:** don't decorate code elements in top tab ([531e8b8](https://github.com/IBM/kui/commit/531e8b8)), closes [#5778](https://github.com/IBM/kui/issues/5778)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** double clicking on Commentary in minisplit often has the editor completely off screen ([c3504a0](https://github.com/IBM/kui/commit/c3504a0)), closes [#5897](https://github.com/IBM/kui/issues/5897)
- **plugins/plugin-client-common:** editing commentary gives a one-line monaco ([5f14268](https://github.com/IBM/kui/commit/5f14268)), closes [#5874](https://github.com/IBM/kui/issues/5874)
- **plugins/plugin-client-common:** editor doesn't grab focus for edit command ([9870267](https://github.com/IBM/kui/commit/9870267)), closes [#6090](https://github.com/IBM/kui/issues/6090)
- **plugins/plugin-client-common:** empty pty response yields blank line ([711bd05](https://github.com/IBM/kui/commit/711bd05)), closes [#5928](https://github.com/IBM/kui/issues/5928)
- **plugins/plugin-client-common:** enhance live grammy ([551b297](https://github.com/IBM/kui/commit/551b297)), closes [#7173](https://github.com/IBM/kui/issues/7173)
- **plugins/plugin-client-common:** enhance minisplit by updating the background color of scrollback and dark card ([fd15c5e](https://github.com/IBM/kui/commit/fd15c5e)), closes [#5989](https://github.com/IBM/kui/issues/5989)
- **plugins/plugin-client-common:** error blocks are not indented properly ([d137614](https://github.com/IBM/kui/commit/d137614)), closes [#5938](https://github.com/IBM/kui/issues/5938)
- **plugins/plugin-client-common:** Experimental tag is not centered ([e1fd930](https://github.com/IBM/kui/commit/e1fd930)), closes [#7131](https://github.com/IBM/kui/issues/7131)
- **plugins/plugin-client-common:** FancyPipeline renders prefix incorrectly ([7498abe](https://github.com/IBM/kui/commit/7498abe))
- **plugins/plugin-client-common:** focus a block upon moving or pasting it ([43c3d9a](https://github.com/IBM/kui/commit/43c3d9a)), closes [#5751](https://github.com/IBM/kui/issues/5751)
- **plugins/plugin-client-common:** grammy command can create an unbounded number of parallel network requests ([12966cf](https://github.com/IBM/kui/commit/12966cf)), closes [#7151](https://github.com/IBM/kui/issues/7151)
- **plugins/plugin-client-common:** grammy command should enforce UI ([5c26730](https://github.com/IBM/kui/commit/5c26730))
- **plugins/plugin-client-common:** group the notebooks together in the ls -l table ([1a783f3](https://github.com/IBM/kui/commit/1a783f3)), closes [#5977](https://github.com/IBM/kui/issues/5977)
- **plugins/plugin-client-common:** header inference logic does not copy over hide-in-sidecar hints ([34b11ed](https://github.com/IBM/kui/commit/34b11ed)), closes [#7053](https://github.com/IBM/kui/issues/7053)
- **plugins/plugin-client-common:** histogram animate is slow with large data ([54c93cf](https://github.com/IBM/kui/commit/54c93cf)), closes [#7193](https://github.com/IBM/kui/issues/7193)
- **plugins/plugin-client-common:** Histogram animation can still be laggy with a great many bars ([ae8d41b](https://github.com/IBM/kui/commit/ae8d41b)), closes [#7205](https://github.com/IBM/kui/issues/7205)
- **plugins/plugin-client-common:** Histogram's inline label could be off for short bars ([82a3b38](https://github.com/IBM/kui/commit/82a3b38)), closes [#7146](https://github.com/IBM/kui/issues/7146)
- **plugins/plugin-client-common:** histograms with a small number of bars can have overlapping bars ([80197f2](https://github.com/IBM/kui/commit/80197f2)), closes [#7209](https://github.com/IBM/kui/issues/7209)
- **plugins/plugin-client-common:** hovering over error block turns red to blue ([3dbddae](https://github.com/IBM/kui/commit/3dbddae)), closes [#5979](https://github.com/IBM/kui/issues/5979)
- **plugins/plugin-client-common:** If a command is issued in a mini split, the next block (in the mini split) is not focused ([a35e5c2](https://github.com/IBM/kui/commit/a35e5c2)), closes [#6067](https://github.com/IBM/kui/issues/6067)
- **plugins/plugin-client-common:** improve look of `code` snippets in Commentary ([493e004](https://github.com/IBM/kui/commit/493e004)), closes [#5768](https://github.com/IBM/kui/issues/5768)
- **plugins/plugin-client-common:** improve SequenceDiagram layout of gap, status, and duration columns ([9341ec7](https://github.com/IBM/kui/commit/9341ec7)), closes [#7028](https://github.com/IBM/kui/issues/7028)
- **plugins/plugin-client-common:** improve the error handling of grammy ([0918b71](https://github.com/IBM/kui/commit/0918b71)), closes [#7201](https://github.com/IBM/kui/issues/7201)
- **plugins/plugin-client-common:** improve the error-handling of grammy parsing histogram data ([8758f8d](https://github.com/IBM/kui/commit/8758f8d)), closes [#7177](https://github.com/IBM/kui/issues/7177)
- **plugins/plugin-client-common:** in browser clients, the prompt may not be initially focused ([76a4419](https://github.com/IBM/kui/commit/76a4419)), closes [#7056](https://github.com/IBM/kui/issues/7056)
- **plugins/plugin-client-common:** in dark themes, the inter-split gutter is not visible ([288eeae](https://github.com/IBM/kui/commit/288eeae)), closes [#6022](https://github.com/IBM/kui/issues/6022)
- **plugins/plugin-client-common:** in popup mode, drilldowns may not be visible ([c59f6d7](https://github.com/IBM/kui/commit/c59f6d7))
- **plugins/plugin-client-common:** in popup mode, terminal does not scroll to the bottom after command execution ([c9ea936](https://github.com/IBM/kui/commit/c9ea936))
- **plugins/plugin-client-common:** In some themes, grid inner text color can have low contrast. ([01f8698](https://github.com/IBM/kui/commit/01f8698)), closes [#6032](https://github.com/IBM/kui/issues/6032)
- **plugins/plugin-client-common:** in splits, spinner is not centered ([08c5b3c](https://github.com/IBM/kui/commit/08c5b3c)), closes [#7129](https://github.com/IBM/kui/issues/7129)
- **plugins/plugin-client-common:** increase contrast of unfocused left-stripes for blocks ([ab21295](https://github.com/IBM/kui/commit/ab21295)), closes [#5754](https://github.com/IBM/kui/issues/5754)
- **plugins/plugin-client-common:** inline sidecar should not have a min-width ([11a0cfb](https://github.com/IBM/kui/commit/11a0cfb)), closes [#6270](https://github.com/IBM/kui/issues/6270)
- **plugins/plugin-client-common:** Input timestamp should also hide when block is focused ([6e1ca6d](https://github.com/IBM/kui/commit/6e1ca6d)), closes [#5809](https://github.com/IBM/kui/issues/5809)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** linux can show unneeded scrollbars in tables ([4d49a23](https://github.com/IBM/kui/commit/4d49a23)), closes [#5884](https://github.com/IBM/kui/issues/5884)
- **plugins/plugin-client-common:** make popover-select widget narrower ([82d27d1](https://github.com/IBM/kui/commit/82d27d1)), closes [#7046](https://github.com/IBM/kui/issues/7046)
- **plugins/plugin-client-common:** markdown code has incorrect color in a split with inverse color ([c8c10af](https://github.com/IBM/kui/commit/c8c10af)), closes [#5902](https://github.com/IBM/kui/issues/5902)
- **plugins/plugin-client-common:** markdown inline code in table cells shows with scrollbars on linux and windows ([1ff88b9](https://github.com/IBM/kui/commit/1ff88b9)), closes [#5890](https://github.com/IBM/kui/issues/5890)
- **plugins/plugin-client-common:** monaco highlight color used by SourceRef has low contrast ([385f35e](https://github.com/IBM/kui/commit/385f35e)), closes [#5713](https://github.com/IBM/kui/issues/5713)
- **plugins/plugin-client-common:** offline notebooks have unnecessary buttons ([09d0af6](https://github.com/IBM/kui/commit/09d0af6)), closes [#7076](https://github.com/IBM/kui/issues/7076)
- **plugins/plugin-client-common:** opening monaco-editor component causes 1px of vertical scrolling at the root level ([e63782e](https://github.com/IBM/kui/commit/e63782e)), closes [#7113](https://github.com/IBM/kui/issues/7113)
- **plugins/plugin-client-common:** Output.tsx streaming to UI can be very slow ([37fdc9f](https://github.com/IBM/kui/commit/37fdc9f)), closes [#7350](https://github.com/IBM/kui/issues/7350)
- **plugins/plugin-client-common:** PatternFly assumes a 16px body font size, whereas the rest of Kui assumes 14px ([fa65b57](https://github.com/IBM/kui/commit/fa65b57)), closes [#6041](https://github.com/IBM/kui/issues/6041)
- **plugins/plugin-client-common:** Popup mode input stripe does not have reliable auto-focus behavior ([ac3935e](https://github.com/IBM/kui/commit/ac3935e)), closes [#6266](https://github.com/IBM/kui/issues/6266)
- **plugins/plugin-client-common:** RadioTable UI component can fail badly for models with no (optional!) nameIdx attr ([c457b92](https://github.com/IBM/kui/commit/c457b92)), closes [#7352](https://github.com/IBM/kui/issues/7352)
- **plugins/plugin-client-common:** regression in Commentary margin ([8a8f26f](https://github.com/IBM/kui/commit/8a8f26f)), closes [#7348](https://github.com/IBM/kui/issues/7348)
- cannot invoke grammy from headless mode ([4e73be4](https://github.com/IBM/kui/commit/4e73be4))
- in screenshot alert, the icon and title text are misaligned ([ff57573](https://github.com/IBM/kui/commit/ff57573)), closes [#6770](https://github.com/IBM/kui/issues/6770)
- invoking a non-popup window from headless kui will have incorrect uuid for splits ([f068b39](https://github.com/IBM/kui/commit/f068b39))
- **plugins/plugin-client-common:** `kubectl get -f` does not render well when in a minisplit ([d9f6548](https://github.com/IBM/kui/commit/d9f6548)), closes [#6750](https://github.com/IBM/kui/issues/6750)
- **plugins/plugin-client-common:** age field in event footer is underlined ([c733449](https://github.com/IBM/kui/commit/c733449)), closes [#6739](https://github.com/IBM/kui/issues/6739)
- **plugins/plugin-client-common:** block action buttons and timestamp may both be visible ([6e63cb7](https://github.com/IBM/kui/commit/6e63cb7)), closes [#5936](https://github.com/IBM/kui/issues/5936)
- **plugins/plugin-client-common:** Drilldown from table isn't always fully in view ([ba1222c](https://github.com/IBM/kui/commit/ba1222c)), closes [#6555](https://github.com/IBM/kui/issues/6555)
- **plugins/plugin-client-common:** Dropdown hover effect in PatternFly4 Dark has no contrast ([35eefb4](https://github.com/IBM/kui/commit/35eefb4)), closes [#6744](https://github.com/IBM/kui/issues/6744)
- **plugins/plugin-client-common:** Events in tables-as-grid wrap when not needed ([fd46054](https://github.com/IBM/kui/commit/fd46054)), closes [#6600](https://github.com/IBM/kui/issues/6600)
- **plugins/plugin-client-common:** Experimental badge has low contrast in PatternFly4 Light theme ([7c0bfff](https://github.com/IBM/kui/commit/7c0bfff)), closes [#6715](https://github.com/IBM/kui/issues/6715)
- **plugins/plugin-client-common:** improve platform compatibility of Home and End keys ([da7393f](https://github.com/IBM/kui/commit/da7393f)), closes [#3267](https://github.com/IBM/kui/issues/3267)
- **plugins/plugin-client-common:** Improve rendering of Source Reference UI ([278b28f](https://github.com/IBM/kui/commit/278b28f)), closes [#6582](https://github.com/IBM/kui/issues/6582)
- **plugins/plugin-client-common:** Leftover console logs in ScrollableTerminal ([4f4af0d](https://github.com/IBM/kui/commit/4f4af0d)), closes [#6755](https://github.com/IBM/kui/issues/6755)
- **plugins/plugin-client-common:** Markdown handling of consecutive img tags only shows first ([1578e58](https://github.com/IBM/kui/commit/1578e58)), closes [#6602](https://github.com/IBM/kui/issues/6602)
- **plugins/plugin-client-common:** Markdown image does not properly handle align attribute ([5c382f8](https://github.com/IBM/kui/commit/5c382f8)), closes [#6551](https://github.com/IBM/kui/issues/6551)
- **plugins/plugin-client-common:** Markdown renderer does not handle image height attribute ([4d49eb9](https://github.com/IBM/kui/commit/4d49eb9)), closes [#6613](https://github.com/IBM/kui/issues/6613)
- **plugins/plugin-client-common:** Markdown renderer does not properly render tables ([69d45a9](https://github.com/IBM/kui/commit/69d45a9)), closes [#6563](https://github.com/IBM/kui/issues/6563) [#4364](https://github.com/IBM/kui/issues/4364)
- **plugins/plugin-client-common:** markdown spacing regressions with h3 and h4 ([d674931](https://github.com/IBM/kui/commit/d674931)), closes [#6736](https://github.com/IBM/kui/issues/6736)
- **plugins/plugin-client-common:** Markdown: validateDomNesting console error ([97b2c17](https://github.com/IBM/kui/commit/97b2c17)), closes [#6577](https://github.com/IBM/kui/issues/6577)
- **plugins/plugin-client-common:** new PatternFly TopTabStripe impl changes colors when a NavResponse is displayed ([d2d6a53](https://github.com/IBM/kui/commit/d2d6a53)), closes [#6553](https://github.com/IBM/kui/issues/6553)
- **plugins/plugin-client-common:** new patternfly-based TopTabStripe behaves poorly with narrower windows ([fc97ab8](https://github.com/IBM/kui/commit/fc97ab8)), closes [#6549](https://github.com/IBM/kui/issues/6549)
- **plugins/plugin-client-common:** new tabs don't receive focus for 2 seconds ([1705870](https://github.com/IBM/kui/commit/1705870)), closes [#6668](https://github.com/IBM/kui/issues/6668)
- **plugins/plugin-client-common:** onclick handlers for ls should respond only to clicking on text ([8477386](https://github.com/IBM/kui/commit/8477386)), closes [#6567](https://github.com/IBM/kui/issues/6567)
- **plugins/plugin-client-common:** PatternFly NavResponse does not unexpand ([d1f9dc9](https://github.com/IBM/kui/commit/d1f9dc9)), closes [#6669](https://github.com/IBM/kui/issues/6669)
- **plugins/plugin-client-common:** pty output in the first block does not render ([9ec3996](https://github.com/IBM/kui/commit/9ec3996)), closes [#6758](https://github.com/IBM/kui/issues/6758)
- **plugins/plugin-client-common:** React warnings in console due to new Modal spi ([57f0cf6](https://github.com/IBM/kui/commit/57f0cf6)), closes [#6696](https://github.com/IBM/kui/issues/6696)
- **plugins/plugin-client-common:** reduce animations in SequenceDiagram ([3c469bd](https://github.com/IBM/kui/commit/3c469bd)), closes [#7133](https://github.com/IBM/kui/issues/7133)
- **plugins/plugin-client-common:** Remove superfluous padding around source ref items ([b821a2b](https://github.com/IBM/kui/commit/b821a2b)), closes [#6731](https://github.com/IBM/kui/issues/6731)
- **plugins/plugin-client-common:** Rendering of markdown files could be improved ([23d6e75](https://github.com/IBM/kui/commit/23d6e75)), closes [#6557](https://github.com/IBM/kui/issues/6557)
- **plugins/plugin-client-common:** repl context will overflow when scrollback has over 100 inputs ([9c84721](https://github.com/IBM/kui/commit/9c84721)), closes [#6646](https://github.com/IBM/kui/issues/6646)
- **plugins/plugin-client-common:** SequenceDiagram should use MB/sec rather than MBps ([7dd4ddf](https://github.com/IBM/kui/commit/7dd4ddf)), closes [#7111](https://github.com/IBM/kui/issues/7111)
- **plugins/plugin-client-common:** status stripe "dropdown" menus can have poor color contrast ([fda4ee6](https://github.com/IBM/kui/commit/fda4ee6)), closes [#6706](https://github.com/IBM/kui/issues/6706)
- **plugins/plugin-client-common:** tab completion can be flakey ([145d1a5](https://github.com/IBM/kui/commit/145d1a5)), closes [#6649](https://github.com/IBM/kui/issues/6649)
- **plugins/plugin-client-common:** tab completion does not render well in minisplits ([8eb0fbc](https://github.com/IBM/kui/commit/8eb0fbc)), closes [#6752](https://github.com/IBM/kui/issues/6752)
- **plugins/plugin-client-common:** tab-completion font-family regression ([13b3d49](https://github.com/IBM/kui/commit/13b3d49)), closes [#6751](https://github.com/IBM/kui/issues/6751)
- **plugins/plugin-client-common:** table and nav content are not left-aligned with breadcrumb ([a8b8015](https://github.com/IBM/kui/commit/a8b8015)), closes [#6741](https://github.com/IBM/kui/issues/6741)
- **plugins/plugin-client-common:** table drilldowns in popup act oddly ([9b01347](https://github.com/IBM/kui/commit/9b01347))
- commands can register evaluator option so core/repl will not redirect output ([d622221](https://github.com/IBM/kui/commit/d622221))
- keyboard history navigation does not work in Popup clients ([89197ba](https://github.com/IBM/kui/commit/89197ba)), closes [#6262](https://github.com/IBM/kui/issues/6262)
- LivePaginatedTable implements WatchPusher's update incorrectly ([a997e1e](https://github.com/IBM/kui/commit/a997e1e)), closes [#7203](https://github.com/IBM/kui/issues/7203)
- LivePaginatedTable.setBody can be very slow ([82acb4f](https://github.com/IBM/kui/commit/82acb4f)), closes [#7191](https://github.com/IBM/kui/issues/7191)
- **plugins/plugin-client-common:** "lost connection to your cluster" alert takes up the full window height ([71f2236](https://github.com/IBM/kui/commit/71f2236)), closes [#7018](https://github.com/IBM/kui/issues/7018)
- **plugins/plugin-client-common:** a few more small tweaks to welcome notebook ([27773cb](https://github.com/IBM/kui/commit/27773cb)), closes [#6829](https://github.com/IBM/kui/issues/6829)
- **plugins/plugin-client-common:** adjust TopTabStripe for lightweight ui themes ([00ee896](https://github.com/IBM/kui/commit/00ee896)), closes [#6204](https://github.com/IBM/kui/issues/6204)
- **plugins/plugin-client-common:** after Electron 10 update, ls output can render poorly ([1b7010b](https://github.com/IBM/kui/commit/1b7010b)), closes [#6147](https://github.com/IBM/kui/issues/6147)
- **plugins/plugin-client-common:** Block borders aren't quite right ([7050a02](https://github.com/IBM/kui/commit/7050a02)), closes [#6808](https://github.com/IBM/kui/issues/6808)
- **plugins/plugin-client-common:** blocks with Processing commands cannot be removed ([626c419](https://github.com/IBM/kui/commit/626c419)), closes [#6954](https://github.com/IBM/kui/issues/6954)
- **plugins/plugin-client-common:** clicking the editor in carbon accordion will change the accordion label ([ce3fe02](https://github.com/IBM/kui/commit/ce3fe02)), closes [#6107](https://github.com/IBM/kui/issues/6107)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([f93fe2b](https://github.com/IBM/kui/commit/f93fe2b)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** events in tree should stay scrolled to the bottom as events come in ([c5efedd](https://github.com/IBM/kui/commit/c5efedd)), closes [#6164](https://github.com/IBM/kui/issues/6164)
- **plugins/plugin-client-common:** events table doesn't handle long messages and narrow viewports ([ea90a34](https://github.com/IBM/kui/commit/ea90a34)), closes [#6831](https://github.com/IBM/kui/issues/6831)
- **plugins/plugin-client-common:** externalize PatternFly TreeView component to SPI ([486a02e](https://github.com/IBM/kui/commit/486a02e)), closes [#6134](https://github.com/IBM/kui/issues/6134)
- **plugins/plugin-client-common:** font size issues with lightweight ui in tree view ([575ced0](https://github.com/IBM/kui/commit/575ced0)), closes [#6228](https://github.com/IBM/kui/issues/6228) [#6229](https://github.com/IBM/kui/issues/6229)
- **plugins/plugin-client-common:** Grids in minisplits have horizontal overflow ([d2483fd](https://github.com/IBM/kui/commit/d2483fd)), closes [#6781](https://github.com/IBM/kui/issues/6781)
- **plugins/plugin-client-common:** height of TreeView events should match that of sidecar header ([bba1ccd](https://github.com/IBM/kui/commit/bba1ccd)), closes [#6174](https://github.com/IBM/kui/issues/6174)
- **plugins/plugin-client-common:** in carbon-based dark themes, the SourceRef expando text is not visible ([0b462f5](https://github.com/IBM/kui/commit/0b462f5)), closes [#6197](https://github.com/IBM/kui/issues/6197)
- **plugins/plugin-client-common:** in lightweight presentation mode, lighten up sidecar a bit ([c73c080](https://github.com/IBM/kui/commit/c73c080)), closes [#6202](https://github.com/IBM/kui/issues/6202) [#6201](https://github.com/IBM/kui/issues/6201)
- **plugins/plugin-client-common:** in lightweight themes, hover on sequence diagram rows may result in errant border-top ([679498f](https://github.com/IBM/kui/commit/679498f)), closes [#6251](https://github.com/IBM/kui/issues/6251)
- **plugins/plugin-client-common:** in lightweight ui themes, markdown content has odd font spacing ([b114221](https://github.com/IBM/kui/commit/b114221)), closes [#6249](https://github.com/IBM/kui/issues/6249)
- **plugins/plugin-client-common:** Increase entryDelay for table tooltips ([4e3739a](https://github.com/IBM/kui/commit/4e3739a)), closes [#6870](https://github.com/IBM/kui/issues/6870)
- **plugins/plugin-client-common:** input element is not distinct enough in lightweight ui themes with splits ([01b3e40](https://github.com/IBM/kui/commit/01b3e40)), closes [#6247](https://github.com/IBM/kui/issues/6247)
- **plugins/plugin-client-common:** isWidthConstrained is always true for nSplits > 1 ([7d832f2](https://github.com/IBM/kui/commit/7d832f2)), closes [#6782](https://github.com/IBM/kui/issues/6782)
- **plugins/plugin-client-common:** kubectl unified tables have a NAME column (all caps) ([419f35d](https://github.com/IBM/kui/commit/419f35d)), closes [#6820](https://github.com/IBM/kui/issues/6820)
- **plugins/plugin-client-common:** Live Histogram view consumes lots of CPU ([eda3167](https://github.com/IBM/kui/commit/eda3167)), closes [#7175](https://github.com/IBM/kui/issues/7175)
- **plugins/plugin-client-common:** live tables may never show "Last Updated" footer message ([477fa04](https://github.com/IBM/kui/commit/477fa04)), closes [#6845](https://github.com/IBM/kui/issues/6845)
- **plugins/plugin-client-common:** ls does not render markdown cells properly ([1083962](https://github.com/IBM/kui/commit/1083962)), closes [#7000](https://github.com/IBM/kui/issues/7000)
- **plugins/plugin-client-common:** Markdown kuiexec drilldowns do not work if Markdown isn't passed a REPL controller ([90652f3](https://github.com/IBM/kui/commit/90652f3)), closes [#6977](https://github.com/IBM/kui/issues/6977)
- **plugins/plugin-client-common:** Markdown links should have a tooltip ([9a1f2d9](https://github.com/IBM/kui/commit/9a1f2d9)), closes [#6939](https://github.com/IBM/kui/issues/6939)
- **plugins/plugin-client-common:** Markdown lists may lack bullets/numbers ([3db9eaa](https://github.com/IBM/kui/commit/3db9eaa)), closes [#6947](https://github.com/IBM/kui/issues/6947)
- **plugins/plugin-client-common:** Markdown renderer does not handle img tags with http src ([fe12530](https://github.com/IBM/kui/commit/fe12530)), closes [#6818](https://github.com/IBM/kui/issues/6818)
- **plugins/plugin-client-common:** Markdown rendering of images does not support percentage width or height ([6e75c40](https://github.com/IBM/kui/commit/6e75c40)), closes [#6822](https://github.com/IBM/kui/issues/6822)
- **plugins/plugin-client-common:** on windows, table breadcrumb has vertical scrollbars ([b2fda10](https://github.com/IBM/kui/commit/b2fda10)), closes [#6878](https://github.com/IBM/kui/issues/6878)
- **plugins/plugin-client-common:** popover has odd spacing and overflow ([12d2508](https://github.com/IBM/kui/commit/12d2508)), closes [#6809](https://github.com/IBM/kui/issues/6809)
- **plugins/plugin-client-common:** redirectToPlainSplitIfNeeded may favor smaller terminals ([58f9ab0](https://github.com/IBM/kui/commit/58f9ab0)), closes [#6930](https://github.com/IBM/kui/issues/6930)
- **plugins/plugin-client-common:** remove block border and refine input border for minisplits ([7b5ce5b](https://github.com/IBM/kui/commit/7b5ce5b)), closes [#6801](https://github.com/IBM/kui/issues/6801)
- **plugins/plugin-client-common:** restore Table sorting ([b590e6e](https://github.com/IBM/kui/commit/b590e6e)), closes [#6729](https://github.com/IBM/kui/issues/6729)
- **plugins/plugin-client-common:** Sidecar sticks to a short height when switching from Yaml -> Summary -> Yaml tab ([79e7df3](https://github.com/IBM/kui/commit/79e7df3)), closes [#6913](https://github.com/IBM/kui/issues/6913)
- **plugins/plugin-client-common:** sidecar top tabs may not have the proper sidecar header color ([dee76ed](https://github.com/IBM/kui/commit/dee76ed)), closes [#6841](https://github.com/IBM/kui/issues/6841)
- **plugins/plugin-client-common:** sometimes both the block action buttons and the timestamp are visible at the same time ([a3ece2b](https://github.com/IBM/kui/commit/a3ece2b)), closes [#5936](https://github.com/IBM/kui/issues/5936)
- **plugins/plugin-client-common:** spinner is off-center by 1px ([e8cea91](https://github.com/IBM/kui/commit/e8cea91)), closes [#6885](https://github.com/IBM/kui/issues/6885)
- **plugins/plugin-client-common:** Tab Completion view color codes partial completions if no slashes ([78010a8](https://github.com/IBM/kui/commit/78010a8)), closes [#6993](https://github.com/IBM/kui/issues/6993)
- ctrl+c then clear results in wrong command being executed ([b153110](https://github.com/IBM/kui/commit/b153110)), closes [#6979](https://github.com/IBM/kui/issues/6979)
- **plugins/plugin-client-common:** numeric responses may not be displayed ([93603cf](https://github.com/IBM/kui/commit/93603cf)), closes [#6982](https://github.com/IBM/kui/issues/6982)
- **plugins/plugin-client-common:** sidecar toolbar text can overflow ([048bd81](https://github.com/IBM/kui/commit/048bd81)), closes [#7114](https://github.com/IBM/kui/issues/7114)
- **plugins/plugin-client-common:** some grid cells display with no background color ([3d4a41d](https://github.com/IBM/kui/commit/3d4a41d)), closes [#6794](https://github.com/IBM/kui/issues/6794)
- **plugins/plugin-client-common:** spinner spacing regression ([605afa9](https://github.com/IBM/kui/commit/605afa9)), closes [#7155](https://github.com/IBM/kui/issues/7155)
- **plugins/plugin-client-common:** table clicks fail when the maximum number of splits is reached ([d2c6146](https://github.com/IBM/kui/commit/d2c6146)), closes [#6938](https://github.com/IBM/kui/issues/6938)
- **plugins/plugin-client-common:** Table header background color can be incorrect ([3249d89](https://github.com/IBM/kui/commit/3249d89)), closes [#6810](https://github.com/IBM/kui/issues/6810)
- **plugins/plugin-client-common:** Table header seems to float in front of dropdowns ([8a2b54b](https://github.com/IBM/kui/commit/8a2b54b)), closes [#6880](https://github.com/IBM/kui/issues/6880)
- **plugins/plugin-client-common:** Table onclick handlers applied to every cell ([d5a9c3a](https://github.com/IBM/kui/commit/d5a9c3a)), closes [#6792](https://github.com/IBM/kui/issues/6792)
- **plugins/plugin-client-common:** The pause watching icon should be grey ([a0de73a](https://github.com/IBM/kui/commit/a0de73a)), closes [#6931](https://github.com/IBM/kui/issues/6931)
- **plugins/plugin-client-common:** Tooltips for kuiexec markdown links have incorrect tooltip content ([e147fca](https://github.com/IBM/kui/commit/e147fca)), closes [#6958](https://github.com/IBM/kui/issues/6958)
- **plugins/plugin-client-common:** watched histograms do not register changes to files ([253f708](https://github.com/IBM/kui/commit/253f708)), closes [#7197](https://github.com/IBM/kui/issues/7197)
- **plugins/plugin-client-common:** when there're 3 splits, clicking table cells in the first split fail ([77dfb54](https://github.com/IBM/kui/commit/77dfb54)), closes [#6937](https://github.com/IBM/kui/issues/6937)
- **plugins/plugin-client-common:** when there're 3 splits, clicking table in the first split will create the 4th split ([b894b27](https://github.com/IBM/kui/commit/b894b27)), closes [#6932](https://github.com/IBM/kui/issues/6932)
- change new split keyboard shortcut from cltrOrMeta+U -> +Y ([9cac19d](https://github.com/IBM/kui/commit/9cac19d)), closes [#6876](https://github.com/IBM/kui/issues/6876)
- kubectl direct/get does not specify that get tables have the `onclickIdempotent` property ([31361ec](https://github.com/IBM/kui/commit/31361ec)), closes [#6778](https://github.com/IBM/kui/issues/6778)
- kui may try to open files of unbounded size in monaco-editor ([00197a5](https://github.com/IBM/kui/commit/00197a5)), closes [#7091](https://github.com/IBM/kui/issues/7091)
- LivePaginatedTable may drop updates ([4f8f510](https://github.com/IBM/kui/commit/4f8f510)), closes [#7137](https://github.com/IBM/kui/issues/7137)
- missing some theme alignment rules for pf-t-dark ([60486a2](https://github.com/IBM/kui/commit/60486a2)), closes [#7036](https://github.com/IBM/kui/issues/7036)
- Screenshot alert is not visible in narrower windows ([d94da68](https://github.com/IBM/kui/commit/d94da68)), closes [#6843](https://github.com/IBM/kui/issues/6843)
- Tree view badges can have low contrast ([9be1ae5](https://github.com/IBM/kui/commit/9be1ae5)), closes [#6245](https://github.com/IBM/kui/issues/6245)
- UpdateChecker does not render tables, lists, or relative image refs properly ([3e6ba75](https://github.com/IBM/kui/commit/3e6ba75)), closes [#6918](https://github.com/IBM/kui/issues/6918)
- **plugins/plugin-client-common:** in some cases, Editor may present "you are in edit mode" for readOnly instantiations ([e3e7c16](https://github.com/IBM/kui/commit/e3e7c16)), closes [#6116](https://github.com/IBM/kui/issues/6116)
- **plugins/plugin-client-common:** lightweight ui has a few remaining "heavy" elements ([afef54a](https://github.com/IBM/kui/commit/afef54a)), closes [#6195](https://github.com/IBM/kui/issues/6195)
- **plugins/plugin-client-common:** pack table rows more densely in lightweight UI themes ([bcb3f23](https://github.com/IBM/kui/commit/bcb3f23)), closes [#6217](https://github.com/IBM/kui/issues/6217)
- **plugins/plugin-client-common:** prompt focus may not be restored when switching tabs ([5e81db9](https://github.com/IBM/kui/commit/5e81db9)), closes [#6239](https://github.com/IBM/kui/issues/6239)
- **plugins/plugin-client-common:** RadioTable has small font size ([19f758a](https://github.com/IBM/kui/commit/19f758a)), closes [#6102](https://github.com/IBM/kui/issues/6102)
- **plugins/plugin-client-common:** remove clicks from NotebookImpl ([45f0be5](https://github.com/IBM/kui/commit/45f0be5)), closes [#5856](https://github.com/IBM/kui/issues/5856)
- **plugins/plugin-client-common:** remove leftover debugging in Scalar/index ([82b8e50](https://github.com/IBM/kui/commit/82b8e50)), closes [#5945](https://github.com/IBM/kui/issues/5945)
- **plugins/plugin-client-common:** removing previous blocks will cause errant rendering to edit command result ([6594e8c](https://github.com/IBM/kui/commit/6594e8c)), closes [#6093](https://github.com/IBM/kui/issues/6093)
- **plugins/plugin-client-common:** sidecar editor too-aggressively focuses ([8077cec](https://github.com/IBM/kui/commit/8077cec)), closes [#6104](https://github.com/IBM/kui/issues/6104)
- **plugins/plugin-client-common:** some small tweaks to Commentary headers would help ([b012f8d](https://github.com/IBM/kui/commit/b012f8d)), closes [#5893](https://github.com/IBM/kui/issues/5893)
- **plugins/plugin-client-common:** TabCompletion UI can fail ([cc3fb6d](https://github.com/IBM/kui/commit/cc3fb6d)), closes [#6130](https://github.com/IBM/kui/issues/6130)
- **plugins/plugin-client-common:** tables with inferred headers never allow for grid presentation ([a384783](https://github.com/IBM/kui/commit/a384783)), closes [#6763](https://github.com/IBM/kui/issues/6763)
- **plugins/plugin-client-common:** TreeView badges have poor contrast in patternfly themes ([8e0db86](https://github.com/IBM/kui/commit/8e0db86)), closes [#6149](https://github.com/IBM/kui/issues/6149)
- **plugins/plugin-client-common:** tweak sidecar button spacing a bit ([9bdf8a6](https://github.com/IBM/kui/commit/9bdf8a6)), closes [#6873](https://github.com/IBM/kui/issues/6873)
- the x in the offline badge is sometimes low contrast, especially in dark themes ([c60157c](https://github.com/IBM/kui/commit/c60157c)), closes [#6784](https://github.com/IBM/kui/issues/6784)
- **plugins/plugin-client-common:** update spinner to avoid console error messages ([caea507](https://github.com/IBM/kui/commit/caea507)), closes [#6146](https://github.com/IBM/kui/issues/6146)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-client-common:** With full-width blocks, PatternFly Tables have odd column spacing ([4062489](https://github.com/IBM/kui/commit/4062489)), closes [#6766](https://github.com/IBM/kui/issues/6766)
- **Plugins/plugin-client-common:** replayed notebooks don't always open scrolled to top ([6d71638](https://github.com/IBM/kui/commit/6d71638)), closes [#6824](https://github.com/IBM/kui/issues/6824)
- in minisplits, blocks that contain pty output may have excess whitespace ([d9299ae](https://github.com/IBM/kui/commit/d9299ae)), closes [#6759](https://github.com/IBM/kui/issues/6759)
- **plugins/plugin-client-common:** width-constrained NavResponse UI should spend more space on content ([309c6ff](https://github.com/IBM/kui/commit/309c6ff)), closes [#6742](https://github.com/IBM/kui/issues/6742)
- **plugins/plugin-kubectl:** events watching returns an empty table with just a streaming events footer ([fbeae76](https://github.com/IBM/kui/commit/fbeae76)), closes [#2771](https://github.com/IBM/kui/issues/2771)
- **plugins/plugin-kubectl:** show SourceRef when creating heterogeneous resources ([adb21c5](https://github.com/IBM/kui/commit/adb21c5)), closes [#6640](https://github.com/IBM/kui/issues/6640)
- ctrl+L in the first block makes the prompt inactive ([232e5e1](https://github.com/IBM/kui/commit/232e5e1)), closes [#6597](https://github.com/IBM/kui/issues/6597)
- In narrower windows, there is too much content in the StatusStripe ([453bc86](https://github.com/IBM/kui/commit/453bc86)), closes [#6570](https://github.com/IBM/kui/issues/6570)
- kubectl get -f --watch doesn't watch ([e45e8ee](https://github.com/IBM/kui/commit/e45e8ee)), closes [#6588](https://github.com/IBM/kui/issues/6588)
- kubectl kustomize can have bogus output ([8bf8ebe](https://github.com/IBM/kui/commit/8bf8ebe)), closes [#6114](https://github.com/IBM/kui/issues/6114)
- ls clicks that do another ls should not open a split ([fc0873b](https://github.com/IBM/kui/commit/fc0873b)), closes [#6565](https://github.com/IBM/kui/issues/6565)
- remove TreeResponse and PatternFly Tree Component ([e539a53](https://github.com/IBM/kui/commit/e539a53)), closes [#6581](https://github.com/IBM/kui/issues/6581) [#6328](https://github.com/IBM/kui/issues/6328)
- **plugins/plugin-client-common:** `ls` in minisplit has tall rows ([00b5e41](https://github.com/IBM/kui/commit/00b5e41)), closes [#6289](https://github.com/IBM/kui/issues/6289)
- **plugins/plugin-client-common:** a few minor UI glitches in Block css ([a25c72c](https://github.com/IBM/kui/commit/a25c72c)), closes [#6335](https://github.com/IBM/kui/issues/6335)
- **plugins/plugin-client-common:** blocks with no input or output shouldn't have a background color ([42b5b01](https://github.com/IBM/kui/commit/42b5b01)), closes [#6367](https://github.com/IBM/kui/issues/6367)
- **plugins/plugin-client-common:** DiffEditor does not respond to resize events ([7f88934](https://github.com/IBM/kui/commit/7f88934)), closes [#6365](https://github.com/IBM/kui/issues/6365)
- **plugins/plugin-client-common:** double whitespace may be removed from completed inputs ([fc0c0db](https://github.com/IBM/kui/commit/fc0c0db)), closes [#6279](https://github.com/IBM/kui/issues/6279)
- **plugins/plugin-client-common:** DropdownWidget does not obey `title` property ([e534cbc](https://github.com/IBM/kui/commit/e534cbc)), closes [#6393](https://github.com/IBM/kui/issues/6393)
- **plugins/plugin-client-common:** Experimental badge too tall for lightweight UI themes. ([57b1f51](https://github.com/IBM/kui/commit/57b1f51)), closes [#6284](https://github.com/IBM/kui/issues/6284)
- **plugins/plugin-client-common:** first-time edits of commentary may cause editor to lose focus ([81b55e0](https://github.com/IBM/kui/commit/81b55e0)), closes [#6545](https://github.com/IBM/kui/issues/6545)
- **plugins/plugin-client-common:** in minisplits, no margin between active block and previous response ([e20c115](https://github.com/IBM/kui/commit/e20c115)), closes [#6333](https://github.com/IBM/kui/issues/6333)
- **plugins/plugin-client-common:** in PatternFly Light theme, status stripe hovers and borders are not visible ([8bfc9a1](https://github.com/IBM/kui/commit/8bfc9a1)), closes [#6324](https://github.com/IBM/kui/issues/6324)
- **plugins/plugin-client-common:** in patternfly-based components, the CurrentContext widget has poor alignment ([c6f873c](https://github.com/IBM/kui/commit/c6f873c)), closes [#6494](https://github.com/IBM/kui/issues/6494)
- **plugins/plugin-client-common:** inverted color context in mini splits can have low contrast ([2541d74](https://github.com/IBM/kui/commit/2541d74)), closes [#6383](https://github.com/IBM/kui/issues/6383)
- **plugins/plugin-client-common:** kubectl help sometimes does not line wrap properly ([b66928b](https://github.com/IBM/kui/commit/b66928b)), closes [#6425](https://github.com/IBM/kui/issues/6425)
- **plugins/plugin-client-common:** LeftNav UIs can be too wide ([5dae64c](https://github.com/IBM/kui/commit/5dae64c)), closes [#6302](https://github.com/IBM/kui/issues/6302)
- **plugins/plugin-client-common:** ls ; ls has excessive vertical whitespace ([1b41c59](https://github.com/IBM/kui/commit/1b41c59)), closes [#6291](https://github.com/IBM/kui/issues/6291)
- **plugins/plugin-client-common:** Markdown component does not properly handle local relative image paths ([deb7b47](https://github.com/IBM/kui/commit/deb7b47)), closes [#6547](https://github.com/IBM/kui/issues/6547)
- **plugins/plugin-client-common:** minor Output alignment regression ([91442ad](https://github.com/IBM/kui/commit/91442ad)), closes [#6438](https://github.com/IBM/kui/issues/6438)
- **plugins/plugin-client-common:** monaco editor always consumes mouse wheel scrolling events ([bed75eb](https://github.com/IBM/kui/commit/bed75eb)), closes [#6480](https://github.com/IBM/kui/issues/6480)
- **plugins/plugin-client-common:** PatternFly themes are still using a carbon icon for Split ([4c05d28](https://github.com/IBM/kui/commit/4c05d28)), closes [#6322](https://github.com/IBM/kui/issues/6322)
- **plugins/plugin-client-common:** PatternFly's CodeSnippet rendering issues ([48f30fa](https://github.com/IBM/kui/commit/48f30fa)), closes [#6542](https://github.com/IBM/kui/issues/6542) [#6544](https://github.com/IBM/kui/issues/6544)
- use Dropdown component for RadioTable impl ([244b16a](https://github.com/IBM/kui/commit/244b16a)), closes [#6539](https://github.com/IBM/kui/issues/6539)
- **plugins/plugin-client-common:** as sequence diagram nRows grows, rows shrink, but fonts do not ([eac0220](https://github.com/IBM/kui/commit/eac0220)), closes [#6420](https://github.com/IBM/kui/issues/6420)
- **plugins/plugin-client-common:** patternfly popover close button has odd spacing ([e7c21fd](https://github.com/IBM/kui/commit/e7c21fd)), closes [#6345](https://github.com/IBM/kui/issues/6345)
- **plugins/plugin-client-common:** Popup mode client has a few status stripe rendering issues ([57bb8b2](https://github.com/IBM/kui/commit/57bb8b2)), closes [#6357](https://github.com/IBM/kui/issues/6357)
- **plugins/plugin-client-common:** processing block disappears in minisplits ([907a9d5](https://github.com/IBM/kui/commit/907a9d5)), closes [#6310](https://github.com/IBM/kui/issues/6310)
- **plugins/plugin-client-common:** red and green overlays in diff views are hard to see ([1843bff](https://github.com/IBM/kui/commit/1843bff)), closes [#6363](https://github.com/IBM/kui/issues/6363)
- **plugins/plugin-client-common:** Rendering glitches in carbon fonts for status stripe DropdownWidgets ([1ee18a6](https://github.com/IBM/kui/commit/1ee18a6)), closes [#6359](https://github.com/IBM/kui/issues/6359)
- **plugins/plugin-client-common:** Rendering of markdown incorrectly inherits white-space:nowrap from repl ([d66b8b2](https://github.com/IBM/kui/commit/d66b8b2)), closes [#6575](https://github.com/IBM/kui/issues/6575)
- **plugins/plugin-client-common:** show table click result in a new split ([fd1b3a1](https://github.com/IBM/kui/commit/fd1b3a1)), closes [#6477](https://github.com/IBM/kui/issues/6477)
- **plugins/plugin-client-common:** sidecar maximization is a bit off when in a split ([f103379](https://github.com/IBM/kui/commit/f103379)), closes [#6531](https://github.com/IBM/kui/issues/6531)
- kubectl contexts table has odd CURRENT column ([f6d0a98](https://github.com/IBM/kui/commit/f6d0a98)), closes [#6523](https://github.com/IBM/kui/issues/6523)
- **plugins/plugin-client-common:** patternfly Tree component does not load patternfly base ([c38961b](https://github.com/IBM/kui/commit/c38961b)), closes [#6502](https://github.com/IBM/kui/issues/6502)
- **plugins/plugin-client-common:** refine input UI for lightweight ui themes ([c479cdb](https://github.com/IBM/kui/commit/c479cdb)), closes [#6296](https://github.com/IBM/kui/issues/6296)
- **plugins/plugin-client-common:** sidecar toolbar text is not always vertically centered ([cbceee3](https://github.com/IBM/kui/commit/cbceee3)), closes [#6305](https://github.com/IBM/kui/issues/6305)
- **plugins/plugin-client-common:** table sorting may result in bad drilldown onclicks ([17d75c3](https://github.com/IBM/kui/commit/17d75c3)), closes [#6524](https://github.com/IBM/kui/issues/6524)
- in patternfly-based themes, CurrentContext DropDown renders poorly ([f1a3faf](https://github.com/IBM/kui/commit/f1a3faf)), closes [#6496](https://github.com/IBM/kui/issues/6496)
- **plugins/plugin-client-common:** sometimes response is not scrolled into view properly ([a2fae6a](https://github.com/IBM/kui/commit/a2fae6a)), closes [#6479](https://github.com/IBM/kui/issues/6479)
- Clean up the way patternfly fonts are incorporated into themes ([2ba49e9](https://github.com/IBM/kui/commit/2ba49e9)), closes [#6375](https://github.com/IBM/kui/issues/6375)
- DIffEditor should render inline when in terminal split ([b86b127](https://github.com/IBM/kui/commit/b86b127)), closes [#6366](https://github.com/IBM/kui/issues/6366)
- drilldown from an undeployed application in tree will issue a kubectl get with 404 ([309a9a0](https://github.com/IBM/kui/commit/309a9a0)), closes [#6331](https://github.com/IBM/kui/issues/6331)
- in patternfly4 light theme, the status stripe hovers background color are not visible ([a0e79d5](https://github.com/IBM/kui/commit/a0e79d5)), closes [#6361](https://github.com/IBM/kui/issues/6361)
- s3 job watcher sometimes fails due to startup issues ([8851d50](https://github.com/IBM/kui/commit/8851d50)), closes [#6411](https://github.com/IBM/kui/issues/6411)
- SequenceDiagram bar widths are pretty buggy ([6d1c458](https://github.com/IBM/kui/commit/6d1c458)), closes [#6408](https://github.com/IBM/kui/issues/6408)
- tree should support leaf node drilling down ([006b881](https://github.com/IBM/kui/commit/006b881)), closes [#6293](https://github.com/IBM/kui/issues/6293)
- UpdateChecker popover can be too height ([8f87488](https://github.com/IBM/kui/commit/8f87488)), closes [#6413](https://github.com/IBM/kui/issues/6413)
- **plugins/plugin-client-common:** TopTabStripe for Lightweight UI themes could be a bit lighter-weight ([8d0e144](https://github.com/IBM/kui/commit/8d0e144)), closes [#6398](https://github.com/IBM/kui/issues/6398)
- **plugins/plugin-kubectl:** event watcher doesn't render well in minisplit ([56176de](https://github.com/IBM/kui/commit/56176de)), closes [#6772](https://github.com/IBM/kui/issues/6772)
- **plugins/plugin-kubectl:** unlabeled resources shouldn’t have badge for children's count ([4e1fea6](https://github.com/IBM/kui/commit/4e1fea6)), closes [#6243](https://github.com/IBM/kui/issues/6243)
- @patternfly/react-core breaks the indentation of TreeView ([f5c5253](https://github.com/IBM/kui/commit/f5c5253)), closes [#6224](https://github.com/IBM/kui/issues/6224)
- A few more themes tweaks are needed ([03be3eb](https://github.com/IBM/kui/commit/03be3eb)), closes [#6034](https://github.com/IBM/kui/issues/6034)
- add Kui version and github link to client-notebook ([7b2562a](https://github.com/IBM/kui/commit/7b2562a)), closes [#5918](https://github.com/IBM/kui/issues/5918)
- block focus regressions ([881fa17](https://github.com/IBM/kui/commit/881fa17)), closes [#6072](https://github.com/IBM/kui/issues/6072)
- block timestamp in Light theme/lightweight ui has low contrast ([6ae08fd](https://github.com/IBM/kui/commit/6ae08fd)), closes [#6226](https://github.com/IBM/kui/issues/6226)
- blocks can still disappear if table row is clicked while the enclosing block is focused ([2173af1](https://github.com/IBM/kui/commit/2173af1)), closes [#5814](https://github.com/IBM/kui/issues/5814)
- default chart colors should not use blue-red diverging spectrum ([918ab9c](https://github.com/IBM/kui/commit/918ab9c)), closes [#6191](https://github.com/IBM/kui/issues/6191)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- don't show the `open` command for clicking files in `ls` table ([03ef269](https://github.com/IBM/kui/commit/03ef269)), closes [#5748](https://github.com/IBM/kui/issues/5748)
- for replayed notebooks, don’t show timestamp ([951abc5](https://github.com/IBM/kui/commit/951abc5)), closes [#5763](https://github.com/IBM/kui/issues/5763)
- ls comand is not snapshotable ([f04ca78](https://github.com/IBM/kui/commit/f04ca78)), closes [#5241](https://github.com/IBM/kui/issues/5241)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- Notebook title "Kui Setting" should be "Kui Settings" ([b14b130](https://github.com/IBM/kui/commit/b14b130)), closes [#5870](https://github.com/IBM/kui/issues/5870)
- PatternFly 2012.14 breaks the indentation of TreeView ([f052d71](https://github.com/IBM/kui/commit/f052d71)), closes [#6224](https://github.com/IBM/kui/issues/6224)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([3400431](https://github.com/IBM/kui/commit/3400431)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** for lightweight ui themes, also show block duration in highlight color ([da3a3a7](https://github.com/IBM/kui/commit/da3a3a7)), closes [#6222](https://github.com/IBM/kui/issues/6222)
- re-saving a notebook via File/Save application menu does not preserve notebook title ([7fb8b43](https://github.com/IBM/kui/commit/7fb8b43)), closes [#5777](https://github.com/IBM/kui/issues/5777)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- **plugin-client-common:** RadioTable onSelect changes do not always result in status stripe updates ([3549b7a](https://github.com/IBM/kui/commit/3549b7a)), closes [#5644](https://github.com/IBM/kui/issues/5644)
- **plugins/plugin-client-common:** Whem moving blocks, the moved block is not longer focused after the move ([fc13198](https://github.com/IBM/kui/commit/fc13198)), closes [#5612](https://github.com/IBM/kui/issues/5612)
- **plugins/plugin-client-common:** a few small refinements to "editing" UI for Inputs ([001236a](https://github.com/IBM/kui/commit/001236a)), closes [#5656](https://github.com/IBM/kui/issues/5656) [#5658](https://github.com/IBM/kui/issues/5658)
- **plugins/plugin-client-common:** Block Action buttons have poor contrast in dark themes ([f52511e](https://github.com/IBM/kui/commit/f52511e)), closes [#5590](https://github.com/IBM/kui/issues/5590)
- **plugins/plugin-client-common:** Block Actions should be top-aligned in output-only blocks ([55ce899](https://github.com/IBM/kui/commit/55ce899)), closes [#5595](https://github.com/IBM/kui/issues/5595)
- **plugins/plugin-client-common:** block left-border is not centered with In[1] text in minisplits ([4df61cc](https://github.com/IBM/kui/commit/4df61cc)), closes [#5585](https://github.com/IBM/kui/issues/5585)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** Commentary blocks are not focusable in minisplits ([1286b0d](https://github.com/IBM/kui/commit/1286b0d)), closes [#5594](https://github.com/IBM/kui/issues/5594)
- **plugins/plugin-client-common:** Commentary editor can easily overflow when editing in minisplit ([eb14074](https://github.com/IBM/kui/commit/eb14074)), closes [#5675](https://github.com/IBM/kui/issues/5675)
- **plugins/plugin-client-common:** Commentary editor should be full width always ([e0a164a](https://github.com/IBM/kui/commit/e0a164a)), closes [#5688](https://github.com/IBM/kui/issues/5688)
- **plugins/plugin-client-common:** Commentary is always full width ([1920fb9](https://github.com/IBM/kui/commit/1920fb9)), closes [#5705](https://github.com/IBM/kui/issues/5705)
- **plugins/plugin-client-common:** Do not focus Block when user expands SourceRef ([6642514](https://github.com/IBM/kui/commit/6642514)), closes [#5711](https://github.com/IBM/kui/issues/5711)
- **plugins/plugin-client-common:** don't show "2 rows" table header for short tables ([2350115](https://github.com/IBM/kui/commit/2350115)), closes [#5581](https://github.com/IBM/kui/issues/5581)
- **plugins/plugin-client-common:** don't show `isTabLayoutModificationResponse` and PresentedElseWhere response in MiniSplit ([a16767a](https://github.com/IBM/kui/commit/a16767a)), closes [#5690](https://github.com/IBM/kui/issues/5690)
- **plugins/plugin-client-common:** Editing Commentary should require double click ([efaded3](https://github.com/IBM/kui/commit/efaded3)), closes [#5686](https://github.com/IBM/kui/issues/5686)
- **plugins/plugin-client-common:** empty blocks have excessive height ([12c39b0](https://github.com/IBM/kui/commit/12c39b0)), closes [#5707](https://github.com/IBM/kui/issues/5707)
- **plugins/plugin-client-common:** h2 in Notebooks have double underline ([40a4bd1](https://github.com/IBM/kui/commit/40a4bd1)), closes [#5574](https://github.com/IBM/kui/issues/5574)
- **plugins/plugin-client-common:** improved focus behavior of terminals ([f5a3dd0](https://github.com/IBM/kui/commit/f5a3dd0)), closes [#5615](https://github.com/IBM/kui/issues/5615)
- **plugins/plugin-client-common:** input probably needs to word-wrap while in minisplits ([cde272d](https://github.com/IBM/kui/commit/cde272d)), closes [#5696](https://github.com/IBM/kui/issues/5696)
- **plugins/plugin-client-common:** input spinner is not visible in minisplits ([76eec59](https://github.com/IBM/kui/commit/76eec59)), closes [#5684](https://github.com/IBM/kui/issues/5684)
- **plugins/plugin-client-common:** lightweight ui: minisplits should not have the opacity filter ([96860f3](https://github.com/IBM/kui/commit/96860f3)), closes [#6198](https://github.com/IBM/kui/issues/6198)
- **plugins/plugin-client-common:** Lots of little layout issues, e.g. SimpleEditor is not fully width in minisplits ([5a9a1c6](https://github.com/IBM/kui/commit/5a9a1c6)), closes [#5679](https://github.com/IBM/kui/issues/5679) [#5680](https://github.com/IBM/kui/issues/5680)
- **plugins/plugin-client-common:** markdown with <a> inside <h1> renders with odd font size ([b5e3007](https://github.com/IBM/kui/commit/b5e3007)), closes [#5724](https://github.com/IBM/kui/issues/5724)
- **plugins/plugin-client-common:** never show "ok" ([d1b337a](https://github.com/IBM/kui/commit/d1b337a)), closes [#5697](https://github.com/IBM/kui/issues/5697)
- **plugins/plugin-client-common:** on switching tabs, active prompt isn't always focused ([5b28dd2](https://github.com/IBM/kui/commit/5b28dd2)), closes [#5637](https://github.com/IBM/kui/issues/5637)
- **plugins/plugin-client-common:** Output-only blocks probably don't need a re-execute button ([251a81c](https://github.com/IBM/kui/commit/251a81c)), closes [#5662](https://github.com/IBM/kui/issues/5662)
- **plugins/plugin-client-common:** PatternFly LeftNav view has excessive padding ([959d059](https://github.com/IBM/kui/commit/959d059)), closes [#6038](https://github.com/IBM/kui/issues/6038)
- **plugins/plugin-client-common:** presented elsewhere text is not vertically centered in block ([766d355](https://github.com/IBM/kui/commit/766d355)), closes [#5760](https://github.com/IBM/kui/issues/5760)
- **plugins/plugin-client-common:** RadioTable should scroll the selected row into view on render ([6eb45db](https://github.com/IBM/kui/commit/6eb45db)), closes [#5781](https://github.com/IBM/kui/issues/5781)
- **plugins/plugin-client-common:** re-snapshoting a notebook can fail ([4caff9c](https://github.com/IBM/kui/commit/4caff9c)), closes [#5736](https://github.com/IBM/kui/issues/5736)
- **plugins/plugin-client-common:** rendering of blockquotes in markdown is inconsistent ([edcc8d1](https://github.com/IBM/kui/commit/edcc8d1)), closes [#6043](https://github.com/IBM/kui/issues/6043)
- **plugins/plugin-client-common:** selecting text in prior Input causes selection to be lost and Input to enter edit mode ([4d977d2](https://github.com/IBM/kui/commit/4d977d2)), closes [#5792](https://github.com/IBM/kui/issues/5792)
- **plugins/plugin-client-common:** sequence diagram does not display well with lightweight ui ([e746cc6](https://github.com/IBM/kui/commit/e746cc6)), closes [#6189](https://github.com/IBM/kui/issues/6189)
- **plugins/plugin-client-common:** SequenceDiagram can overflow 100% width ([d631fd9](https://github.com/IBM/kui/commit/d631fd9)), closes [#6159](https://github.com/IBM/kui/issues/6159)
- **plugins/plugin-client-common:** SequenceDiagram may emit spurious console errors ([c0ba218](https://github.com/IBM/kui/commit/c0ba218)), closes [#6166](https://github.com/IBM/kui/issues/6166)
- **plugins/plugin-client-common:** sidecar markdown code snippet has poor color ([765f166](https://github.com/IBM/kui/commit/765f166)), closes [#5995](https://github.com/IBM/kui/issues/5995)
- **plugins/plugin-client-common:** small regression in top tab stripe height ([0b07d35](https://github.com/IBM/kui/commit/0b07d35)), closes [#6211](https://github.com/IBM/kui/issues/6211)
- **plugins/plugin-client-common:** status stripe "blue" color probably needs to be toned done ([137442f](https://github.com/IBM/kui/commit/137442f)), closes [#5772](https://github.com/IBM/kui/issues/5772)
- **plugins/plugin-client-common:** Tree Component tweaks ([2f21e22](https://github.com/IBM/kui/commit/2f21e22)), closes [#6158](https://github.com/IBM/kui/issues/6158) [#6157](https://github.com/IBM/kui/issues/6157)
- **plugins/plugin-client-common:** typo "soild" in Tree.scss ([1a64ccd](https://github.com/IBM/kui/commit/1a64ccd)), closes [#6172](https://github.com/IBM/kui/issues/6172)
- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- improve discovery of ibmcloud s3 credentials ([96d5bc0](https://github.com/IBM/kui/commit/96d5bc0)), closes [#5926](https://github.com/IBM/kui/issues/5926)
- improve error reporting from APIs ([edff6f1](https://github.com/IBM/kui/commit/edff6f1)), closes [#5950](https://github.com/IBM/kui/issues/5950)
- RadioTable should have option to not echo the onSelect command ([77d5050](https://github.com/IBM/kui/commit/77d5050)), closes [#5991](https://github.com/IBM/kui/issues/5991)
- Switching Carbon tabs can cause content to scroll off-viewport ([51a2aad](https://github.com/IBM/kui/commit/51a2aad)), closes [#6014](https://github.com/IBM/kui/issues/6014)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- **plugins/plugin-client-common:** restore hiding of In[1] in minisplit ([8d5c93f](https://github.com/IBM/kui/commit/8d5c93f)), closes [#5985](https://github.com/IBM/kui/issues/5985)
- **plugins/plugin-client-common:** saving a snapshot can fail with "cannot read property uuid of undefined" ([85fe1f3](https://github.com/IBM/kui/commit/85fe1f3)), closes [#5913](https://github.com/IBM/kui/issues/5913)
- **plugins/plugin-client-common:** sorting widgets in table header are wrapping ([e3520dc](https://github.com/IBM/kui/commit/e3520dc)), closes [#5976](https://github.com/IBM/kui/issues/5976)
- **plugins/plugin-client-common:** tab switching can be slow on windows ([09f9b7d](https://github.com/IBM/kui/commit/09f9b7d)), closes [#5907](https://github.com/IBM/kui/issues/5907)
- **plugins/plugin-client-common:** update the commentary in settings notebook to store the texts as command ([bbb8f6d](https://github.com/IBM/kui/commit/bbb8f6d)), closes [#5992](https://github.com/IBM/kui/issues/5992)
- tweak the input background and border to enhance the readability of notebooks ([3928768](https://github.com/IBM/kui/commit/3928768)), closes [#5982](https://github.com/IBM/kui/issues/5982)
- **plugins/plugin-client-common:** the alert showing lost connection has incorrect height ([1758758](https://github.com/IBM/kui/commit/1758758)), closes [#5905](https://github.com/IBM/kui/issues/5905)
- preferReExecute is lost when re-saving a notebook ([87c6c6f](https://github.com/IBM/kui/commit/87c6c6f)), closes [#5954](https://github.com/IBM/kui/issues/5954)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- **plugins/plugin-client-common:** welcome.json could use some wordsmithing ([e373ab4](https://github.com/IBM/kui/commit/e373ab4)), closes [#5895](https://github.com/IBM/kui/issues/5895)
- **plugins/plugin-client-common:** when replaying notebooks, tab should be scrolled to top ([6567412](https://github.com/IBM/kui/commit/6567412)), closes [#5860](https://github.com/IBM/kui/issues/5860)
- **plugins/plugin-client-common:** while editing Commentary, adding ``` causes a bad error ([097b1b0](https://github.com/IBM/kui/commit/097b1b0)), closes [#5682](https://github.com/IBM/kui/issues/5682)
- **plugins/plugin-client-common): regression validateDOMNesting(...:** <pre> cannot appear as a descendant of <p> ([1a2cccf](https://github.com/IBM/kui/commit/1a2cccf)), closes [#5900](https://github.com/IBM/kui/issues/5900)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- "created split" message should disappear when corresponding split is closed ([f8486f8](https://github.com/IBM/kui/commit/f8486f8)), closes [#5629](https://github.com/IBM/kui/issues/5629)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- new tab command can hang if title is provided ([a6c25c6](https://github.com/IBM/kui/commit/a6c25c6)), closes [#5624](https://github.com/IBM/kui/issues/5624)
- output only Actions should also render on hover ([cdbd105](https://github.com/IBM/kui/commit/cdbd105)), closes [#5652](https://github.com/IBM/kui/issues/5652)
- remove up/down actions buttons ([3c8a8a1](https://github.com/IBM/kui/commit/3c8a8a1)), closes [#5774](https://github.com/IBM/kui/issues/5774)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-client-common:** SequenceDiagram bars are too narrow ([a0ed13a](https://github.com/IBM/kui/commit/a0ed13a)), closes [#5544](https://github.com/IBM/kui/issues/5544)
- **plugins/plugin-client-common:** SourceRef does not respond to all tab layout changes ([d3e8b32](https://github.com/IBM/kui/commit/d3e8b32)), closes [#5552](https://github.com/IBM/kui/issues/5552)
- **plugins/plugin-client-common:** SourceRef viewer should hide liner numbers but show folding ([5f74a46](https://github.com/IBM/kui/commit/5f74a46)), closes [#5719](https://github.com/IBM/kui/issues/5719)
- **plugins/plugin-client-common:** StatusStripe is blank for second+ tabs ([0002dfb](https://github.com/IBM/kui/commit/0002dfb)), closes [#5546](https://github.com/IBM/kui/issues/5546)
- **plugins/plugin-client-common:** StatusStripe widgets can emit react error when switching to notebook tab ([485fcdf](https://github.com/IBM/kui/commit/485fcdf)), closes [#5639](https://github.com/IBM/kui/issues/5639)
- **plugins/plugin-client-common:** table cells with no onclick handler still issue a kui command ([4d8bf37](https://github.com/IBM/kui/commit/4d8bf37)), closes [#5721](https://github.com/IBM/kui/issues/5721)
- **plugins/plugin-client-common:** table is misaligned with command input ([50dc430](https://github.com/IBM/kui/commit/50dc430)), closes [#5734](https://github.com/IBM/kui/issues/5734)
- **plugins/plugin-client-common:** there is still too much whitespace after no-response commands ([268f159](https://github.com/IBM/kui/commit/268f159)), closes [#5742](https://github.com/IBM/kui/issues/5742)
- improved support for replaying splits ([8039a9d](https://github.com/IBM/kui/commit/8039a9d)), closes [#5535](https://github.com/IBM/kui/issues/5535)
- pty output has different indentation than kui command output ([30b10a3](https://github.com/IBM/kui/commit/30b10a3)), closes [#5542](https://github.com/IBM/kui/issues/5542)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- replay --freshen does not support multi-split notebooks ([afd070c](https://github.com/IBM/kui/commit/afd070c)), closes [#5571](https://github.com/IBM/kui/issues/5571) [#5572](https://github.com/IBM/kui/issues/5572)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- terminal clearing versus splits results in non-replayable splits ([8f9dc23](https://github.com/IBM/kui/commit/8f9dc23)), closes [#5626](https://github.com/IBM/kui/issues/5626)
- **plugins/plugin-client-common:** always place table events in the Card footer ([b667b28](https://github.com/IBM/kui/commit/b667b28)), closes [#5210](https://github.com/IBM/kui/issues/5210)
- **plugins/plugin-client-common:** avoid inner scrolling in Commentary cards ([d3ea558](https://github.com/IBM/kui/commit/d3ea558)), closes [#5517](https://github.com/IBM/kui/issues/5517)
- **plugins/plugin-client-common:** buggy header UI in dark themes in minisplits ([55aef48](https://github.com/IBM/kui/commit/55aef48)), closes [#5266](https://github.com/IBM/kui/issues/5266)
- **plugins/plugin-client-common:** clearing Terminal does not abort watchers ([34adb50](https://github.com/IBM/kui/commit/34adb50)), closes [#5116](https://github.com/IBM/kui/issues/5116)
- **plugins/plugin-client-common:** clicking 'remove' of a watchable response doesn't abort the underlying pty job ([7eb69fb](https://github.com/IBM/kui/commit/7eb69fb)), closes [#5090](https://github.com/IBM/kui/issues/5090)
- **plugins/plugin-client-common:** clicking on pod delete button can cause command to be executed in minisplit ([37f9019](https://github.com/IBM/kui/commit/37f9019)), closes [#5247](https://github.com/IBM/kui/issues/5247)
- **plugins/plugin-client-common:** clicking to focus on a split does not always cause full focus effect ([bc59bcf](https://github.com/IBM/kui/commit/bc59bcf)), closes [#5263](https://github.com/IBM/kui/issues/5263)
- **plugins/plugin-client-common:** close tabs doesn't produce the correct tab content ([6090887](https://github.com/IBM/kui/commit/6090887)), closes [#5220](https://github.com/IBM/kui/issues/5220)
- **plugins/plugin-client-common:** Commentary paragraphs have no separation ([6b77a13](https://github.com/IBM/kui/commit/6b77a13)), closes [#5531](https://github.com/IBM/kui/issues/5531)
- **plugins/plugin-client-common:** custom tab titles may have monospace font ([b34b5a4](https://github.com/IBM/kui/commit/b34b5a4)), closes [#5527](https://github.com/IBM/kui/issues/5527)
- **plugins/plugin-client-common:** remove active prompts in an offline notebook ([dd2b53f](https://github.com/IBM/kui/commit/dd2b53f)), closes [#5620](https://github.com/IBM/kui/issues/5620)
- notebook replay should scroll to top, and not display welcome message on every tab ([7ade801](https://github.com/IBM/kui/commit/7ade801)), closes [#5515](https://github.com/IBM/kui/issues/5515) [#5516](https://github.com/IBM/kui/issues/5516)
- tab new command should respond with ElsewhereCommentary response ([19a7e1d](https://github.com/IBM/kui/commit/19a7e1d)), closes [#5602](https://github.com/IBM/kui/issues/5602)
- **plugins/plugin-client-common:** SequenceDiagram can have NaNs in the UI ([ac476a6](https://github.com/IBM/kui/commit/ac476a6)), closes [#5559](https://github.com/IBM/kui/issues/5559)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** table bottom toolbar buttons lack padding ([79f0abe](https://github.com/IBM/kui/commit/79f0abe)), closes [#5554](https://github.com/IBM/kui/issues/5554)
- **plugins/plugin-client-common:** update welcome.json notebook to improve listing of available notebooks ([c6f89f4](https://github.com/IBM/kui/commit/c6f89f4)), closes [#5583](https://github.com/IBM/kui/issues/5583)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins-client-common:** the experimental tag should use sans serif ([143464a](https://github.com/IBM/kui/commit/143464a)), closes [#5363](https://github.com/IBM/kui/issues/5363)
- **plugins/plugin-client-common:** add support for titles in commentary ([fbe367c](https://github.com/IBM/kui/commit/fbe367c)), closes [#5434](https://github.com/IBM/kui/issues/5434)
- **plugins/plugin-client-common:** CSS no longer is reactive to narrow window ([4eb0a11](https://github.com/IBM/kui/commit/4eb0a11)), closes [#5290](https://github.com/IBM/kui/issues/5290)
- **plugins/plugin-client-common:** defer loading of both icon sets ([7d343b8](https://github.com/IBM/kui/commit/7d343b8)), closes [#5444](https://github.com/IBM/kui/issues/5444)
- **plugins/plugin-client-common:** don't line-wrap input elements in MiniSplits ([c929f5e](https://github.com/IBM/kui/commit/c929f5e)), closes [#5348](https://github.com/IBM/kui/issues/5348)
- **plugins/plugin-client-common:** don't use fixed maxHeight for Terminal tables ([0e23e22](https://github.com/IBM/kui/commit/0e23e22)), closes [#5206](https://github.com/IBM/kui/issues/5206)
- **plugins/plugin-client-common:** editor component does not respond to font zooming ([7b7e0f3](https://github.com/IBM/kui/commit/7b7e0f3)), closes [#5120](https://github.com/IBM/kui/issues/5120)
- **plugins/plugin-client-common:** Events drilldown from watch table does not always work ([09aee73](https://github.com/IBM/kui/commit/09aee73)), closes [#5204](https://github.com/IBM/kui/issues/5204)
- **plugins/plugin-client-common:** Events footer in minisplit tables lacks horizontal padding ([f22b1f7](https://github.com/IBM/kui/commit/f22b1f7)), closes [#5196](https://github.com/IBM/kui/issues/5196)
- **plugins/plugin-client-common:** Events should also be placed in table footer (not tbody) when sidecar is open or 2-way terminal split ([1391b1d](https://github.com/IBM/kui/commit/1391b1d)), closes [#5198](https://github.com/IBM/kui/issues/5198)
- **plugins/plugin-client-common:** improve behavior of up arrow for first command in MiniSplits ([ed199d4](https://github.com/IBM/kui/commit/ed199d4)), closes [#5297](https://github.com/IBM/kui/issues/5297)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** improve display of tables in side-by-side terminal splits ([5a32255](https://github.com/IBM/kui/commit/5a32255)), closes [#5201](https://github.com/IBM/kui/issues/5201)
- **plugins/plugin-client-common:** improve layout of In[1] with sidecar open ([263d59a](https://github.com/IBM/kui/commit/263d59a)), closes [#5482](https://github.com/IBM/kui/issues/5482)
- **plugins/plugin-client-common:** improve rendering of output only blocks ([664a8da](https://github.com/IBM/kui/commit/664a8da)), closes [#5467](https://github.com/IBM/kui/issues/5467)
- **plugins/plugin-client-common:** improve spacing of Event footer content ([d63a6f1](https://github.com/IBM/kui/commit/d63a6f1)), closes [#5178](https://github.com/IBM/kui/issues/5178)
- **plugins/plugin-client-common:** improve top tab bottom UI ([8ff4151](https://github.com/IBM/kui/commit/8ff4151)), closes [#5056](https://github.com/IBM/kui/issues/5056)
- **plugins/plugin-client-common:** in plain Terminals, tables should not inner scroll ([15fcbba](https://github.com/IBM/kui/commit/15fcbba)), closes [#5221](https://github.com/IBM/kui/issues/5221)
- **plugins/plugin-client-common:** input may not receive focus on tab switch ([7676792](https://github.com/IBM/kui/commit/7676792)), closes [#5102](https://github.com/IBM/kui/issues/5102)
- **plugins/plugin-client-common:** layout regressions from table screenshot PRs ([8004ee3](https://github.com/IBM/kui/commit/8004ee3)), closes [#5159](https://github.com/IBM/kui/issues/5159)
- **plugins/plugin-client-common:** minor improvements for ls -l output ([1b59c94](https://github.com/IBM/kui/commit/1b59c94)), closes [#5216](https://github.com/IBM/kui/issues/5216)
- **plugins/plugin-client-common:** minor spacing improvements for Commentary and Notebooks ([c473181](https://github.com/IBM/kui/commit/c473181)), closes [#5503](https://github.com/IBM/kui/issues/5503)
- **plugins/plugin-client-common:** only highlight the Active block in the focused split ([feffad4](https://github.com/IBM/kui/commit/feffad4)), closes [#5261](https://github.com/IBM/kui/issues/5261)
- **plugins/plugin-client-common:** place event footer outside of table scroll region for minisplits ([e4872b2](https://github.com/IBM/kui/commit/e4872b2)), closes [#5179](https://github.com/IBM/kui/issues/5179)
- **plugins/plugin-client-common:** present more than 2 footer lines in watch tables ([3e7a78f](https://github.com/IBM/kui/commit/3e7a78f)), closes [#5213](https://github.com/IBM/kui/issues/5213)
- **plugins/plugin-client-common:** pty commands fail in minisplits ([475ea74](https://github.com/IBM/kui/commit/475ea74)), closes [#5267](https://github.com/IBM/kui/issues/5267)
- **plugins/plugin-client-common:** RadioTable screenshots lack box shadow ([b0e0f2e](https://github.com/IBM/kui/commit/b0e0f2e)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** RadioTables in minisplits inner-scroll away the header row ([5296dcd](https://github.com/IBM/kui/commit/5296dcd)), closes [#5165](https://github.com/IBM/kui/issues/5165)
- **plugins/plugin-client-common:** reduce contrast of block left bars ([7c8d371](https://github.com/IBM/kui/commit/7c8d371)), closes [#5275](https://github.com/IBM/kui/issues/5275)
- **plugins/plugin-client-common:** refine Timeline a bit more ([4b12eec](https://github.com/IBM/kui/commit/4b12eec)), closes [#5409](https://github.com/IBM/kui/issues/5409)
- **plugins/plugin-client-common:** regression in columnar alignment of Input and Output ([cf1a836](https://github.com/IBM/kui/commit/cf1a836)), closes [#5507](https://github.com/IBM/kui/issues/5507)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- **plugins/plugin-client-common:** experiment tag has wrong color contrast in dark themes ([22bfb77](https://github.com/IBM/kui/commit/22bfb77)), closes [#5389](https://github.com/IBM/kui/issues/5389)
- **plugins/plugin-client-common:** Experimental badge should take up less space in minisplits ([268aeb3](https://github.com/IBM/kui/commit/268aeb3)), closes [#5373](https://github.com/IBM/kui/issues/5373)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve row hover effect for SequenceDiagram ([89dbe2a](https://github.com/IBM/kui/commit/89dbe2a)), closes [#5426](https://github.com/IBM/kui/issues/5426)
- **plugins/plugin-client-common:** inconsistent top padding above Cards ([1e1037f](https://github.com/IBM/kui/commit/1e1037f)), closes [#5299](https://github.com/IBM/kui/issues/5299)
- **plugins/plugin-client-common:** increase density of SequenceDiagram ([ae29488](https://github.com/IBM/kui/commit/ae29488)), closes [#5344](https://github.com/IBM/kui/issues/5344)
- **plugins/plugin-client-common:** long input lines should line wrap ([8804bb1](https://github.com/IBM/kui/commit/8804bb1)), closes [#5338](https://github.com/IBM/kui/issues/5338)
- **plugins/plugin-client-common:** multi-line paste executes commands out of order ([8f39c80](https://github.com/IBM/kui/commit/8f39c80)), closes [#5295](https://github.com/IBM/kui/issues/5295)
- **plugins/plugin-client-common:** restore history navigation behavior in minisplits ([26f49e8](https://github.com/IBM/kui/commit/26f49e8)), closes [#5375](https://github.com/IBM/kui/issues/5375)
- **plugins/plugin-client-common:** reverse-i-search incorrectly changes match as i type ([135d429](https://github.com/IBM/kui/commit/135d429)), closes [#5403](https://github.com/IBM/kui/issues/5403)
- **plugins/plugin-client-common:** SequenceDiagram bars may extend beyond the 100% line ([34d03bc](https://github.com/IBM/kui/commit/34d03bc)), closes [#5465](https://github.com/IBM/kui/issues/5465)
- **plugins/plugin-client-common:** switching table from Table to Timeline and back to Table does not work ([c924d67](https://github.com/IBM/kui/commit/c924d67)), closes [#5430](https://github.com/IBM/kui/issues/5430)
- **plugins/plugin-client-common:** tab completion UI does not render on separate line from input ([61b169b](https://github.com/IBM/kui/commit/61b169b)), closes [#5307](https://github.com/IBM/kui/issues/5307)
- **plugins/plugin-client-common:** table screenshots include a gray stripe at the top ([11a9fc3](https://github.com/IBM/kui/commit/11a9fc3)), closes [#5410](https://github.com/IBM/kui/issues/5410)
- **plugins/plugin-client-common:** TableCell view can fail when given empty duration cells ([04251be](https://github.com/IBM/kui/commit/04251be)), closes [#5332](https://github.com/IBM/kui/issues/5332)
- **plugins/plugin-client-common:** threshold for auto-grid is too low ([9cb76ee](https://github.com/IBM/kui/commit/9cb76ee)), closes [#5424](https://github.com/IBM/kui/issues/5424)
- **plugins/plugin-client-common:** Timeline may not render properly ([d66d728](https://github.com/IBM/kui/commit/d66d728)), closes [#5383](https://github.com/IBM/kui/issues/5383)
- **plugins/plugin-client-common:** Timeline should use stdev-based heat map ([5dd7427](https://github.com/IBM/kui/commit/5dd7427)), closes [#5395](https://github.com/IBM/kui/issues/5395)
- **plugins/plugin-client-common:** Timeline tooltip for cold starts has incorrect concurrency count ([bb54cb8](https://github.com/IBM/kui/commit/bb54cb8)), closes [#5390](https://github.com/IBM/kui/issues/5390)
- **plugins/plugin-client-common:** Timeline view renders poorly in MiniSplit ([07cd000](https://github.com/IBM/kui/commit/07cd000)), closes [#5379](https://github.com/IBM/kui/issues/5379)
- **plugins/plugin-client-common:** update SequenceDiagram view to display the duration of each interval ([0cf1fcf](https://github.com/IBM/kui/commit/0cf1fcf)), closes [#5470](https://github.com/IBM/kui/issues/5470)
- **plugins/plugin-ibmcloud:** ibmcloud ce job list does not support name filters ([5daa930](https://github.com/IBM/kui/commit/5daa930)), closes [#5450](https://github.com/IBM/kui/issues/5450)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- multiple command history regressions ([cbba96c](https://github.com/IBM/kui/commit/cbba96c)), closes [#5283](https://github.com/IBM/kui/issues/5283)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- switching splits does not participate in tab state ([6eb8db4](https://github.com/IBM/kui/commit/6eb8db4)), closes [#5272](https://github.com/IBM/kui/issues/5272)
- **plugins/plugin-client-common:** RadioTables can have gratuituous line wrapping ([9c39682](https://github.com/IBM/kui/commit/9c39682)), closes [#5139](https://github.com/IBM/kui/issues/5139)
- **plugins/plugin-client-common:** selected row in RadioTables in dark themes has low contrast ([f2c5834](https://github.com/IBM/kui/commit/f2c5834)), closes [#5161](https://github.com/IBM/kui/issues/5161)
- **plugins/plugin-client-common:** sidecar badges may not be flush-right ([5b54665](https://github.com/IBM/kui/commit/5b54665)), closes [#5175](https://github.com/IBM/kui/issues/5175)
- **plugins/plugin-client-common:** status column can be invisible in split tables ([c352103](https://github.com/IBM/kui/commit/c352103)), closes [#5244](https://github.com/IBM/kui/issues/5244)
- **plugins/plugin-client-common:** Tables with identical column names render incorrectly ([161dba2](https://github.com/IBM/kui/commit/161dba2)), closes [#5129](https://github.com/IBM/kui/issues/5129)
- **plugins/plugin-client-commong:** show RadioTable selected row in the table body and header breadcrumb ([811c21e](https://github.com/IBM/kui/commit/811c21e)), closes [#5239](https://github.com/IBM/kui/issues/5239)
- Editor component does not respond to tab layout changes ([9756336](https://github.com/IBM/kui/commit/9756336)), closes [#5231](https://github.com/IBM/kui/issues/5231) [#5232](https://github.com/IBM/kui/issues/5232)
- **plugins/plugin-client-common:** regression in table width with sidecar open ([5938806](https://github.com/IBM/kui/commit/5938806)), closes [#5194](https://github.com/IBM/kui/issues/5194)
- **plugins/plugin-client-common:** Tables should have a max-height and use inner scrolling for overflow ([642ef14](https://github.com/IBM/kui/commit/642ef14)), closes [#5153](https://github.com/IBM/kui/issues/5153)
- **plugins/plugin-client-common:** Terminal Block -> Screenshot of table does not capture box shadow ([ed812f3](https://github.com/IBM/kui/commit/ed812f3)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** Terminal focus changes unexpectedly ([866451c](https://github.com/IBM/kui/commit/866451c)), closes [#5170](https://github.com/IBM/kui/issues/5170)
- **plugins/plugin-client-common:** two MiniSplits with open sidecar are too short ([9e21ab9](https://github.com/IBM/kui/commit/9e21ab9)), closes [#5171](https://github.com/IBM/kui/issues/5171)
- **plugins/plugin-client-common:** watch tables might not be maximized in minisplits ([63420b2](https://github.com/IBM/kui/commit/63420b2)), closes [#5218](https://github.com/IBM/kui/issues/5218)
- **plugins/plugin-client-default:** improve debug logging of client properties ([4daba1f](https://github.com/IBM/kui/commit/4daba1f)), closes [#5088](https://github.com/IBM/kui/issues/5088)
- **plugins/plugin-core-support:** sidecar "window" buttons are too large ([33415d2](https://github.com/IBM/kui/commit/33415d2)), closes [#5094](https://github.com/IBM/kui/issues/5094)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- **plugins/plugin-client-common:** "No resources" in watch pane can occlude watch pane title ([e4fd93a](https://github.com/IBM/kui/commit/e4fd93a)), closes [#5064](https://github.com/IBM/kui/issues/5064)
- **plugins/plugin-client-common:** `ok` string appears at the end of MixResponse ([75606c5](https://github.com/IBM/kui/commit/75606c5)), closes [#5046](https://github.com/IBM/kui/issues/5046)
- **plugins/plugin-client-common:** a few more rem/em font-size issues ([133b347](https://github.com/IBM/kui/commit/133b347)), closes [#5058](https://github.com/IBM/kui/issues/5058)
- **plugins/plugin-client-common:** add error icon for error blocks ([5d9aeea](https://github.com/IBM/kui/commit/5d9aeea)), closes [#4907](https://github.com/IBM/kui/issues/4907)
- **plugins/plugin-client-common:** borders in top tab stripe are too light ([3908695](https://github.com/IBM/kui/commit/3908695)), closes [#5051](https://github.com/IBM/kui/issues/5051)
- **plugins/plugin-client-common:** carbon breadcrumbs may not have proper hover effect ([c8cd2d1](https://github.com/IBM/kui/commit/c8cd2d1)), closes [#4962](https://github.com/IBM/kui/issues/4962)
- **plugins/plugin-client-common:** decrease height of table footer ([5863622](https://github.com/IBM/kui/commit/5863622)), closes [#5072](https://github.com/IBM/kui/issues/5072)
- **plugins/plugin-client-common:** disableTableTitle also disables title of watch panes ([053cfb6](https://github.com/IBM/kui/commit/053cfb6)), closes [#5036](https://github.com/IBM/kui/issues/5036)
- **plugins/plugin-client-common:** double watch panes may open up ([7fb70f1](https://github.com/IBM/kui/commit/7fb70f1)), closes [#5034](https://github.com/IBM/kui/issues/5034)
- **plugins/plugin-client-common:** eliminate react "titleInHeader" console warnings ([8cf3797](https://github.com/IBM/kui/commit/8cf3797)), closes [#5078](https://github.com/IBM/kui/issues/5078)
- **plugins/plugin-client-common:** font size issues with LeftNavSidecar ([e17fc15](https://github.com/IBM/kui/commit/e17fc15)), closes [#5048](https://github.com/IBM/kui/issues/5048)
- **plugins/plugin-client-common:** improve Terminal screenshots by adding padding ([a9b7b26](https://github.com/IBM/kui/commit/a9b7b26)), closes [#4981](https://github.com/IBM/kui/issues/4981)
- **plugins/plugin-client-common:** in Popup mode, use > rather than / for prompt in bottom input ([1360bed](https://github.com/IBM/kui/commit/1360bed)), closes [#4887](https://github.com/IBM/kui/issues/4887)
- **plugins/plugin-client-common:** kubectl edit saves can result in unstyled notification ([5dc658e](https://github.com/IBM/kui/commit/5dc658e)), closes [#4930](https://github.com/IBM/kui/issues/4930)
- **plugins/plugin-client-common:** leftover debug printfs in table sorting ([9889b49](https://github.com/IBM/kui/commit/9889b49)), closes [#5030](https://github.com/IBM/kui/issues/5030)
- **plugins/plugin-client-common:** Light tables should use Carbon compact ([2309ec3](https://github.com/IBM/kui/commit/2309ec3)), closes [#5059](https://github.com/IBM/kui/issues/5059)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** one-row tables needn't offer column sorting UI ([5184fa1](https://github.com/IBM/kui/commit/5184fa1)), closes [#5050](https://github.com/IBM/kui/issues/5050)
- **plugins/plugin-client-common:** regression: non-empty repl output has 'ok' at the end ([103a0f9](https://github.com/IBM/kui/commit/103a0f9)), closes [#4924](https://github.com/IBM/kui/issues/4924)
- **plugins/plugin-client-common:** split button errors are not reported to the user ([fc4e2a2](https://github.com/IBM/kui/commit/fc4e2a2)), closes [#4876](https://github.com/IBM/kui/issues/4876)
- **plugins/plugin-client-common:** status cells of live tables do not always blink ([c94b05e](https://github.com/IBM/kui/commit/c94b05e)), closes [#4903](https://github.com/IBM/kui/issues/4903)
- **plugins/plugin-client-common:** watch pane grid cells too large ([225f937](https://github.com/IBM/kui/commit/225f937)), closes [#5070](https://github.com/IBM/kui/issues/5070)
- Card component does not render well in dark themes ([d96def0](https://github.com/IBM/kui/commit/d96def0)), closes [#4996](https://github.com/IBM/kui/issues/4996)
- clients should be able to enable watcher auto pinning without enabling splitTerminals ([bcade13](https://github.com/IBM/kui/commit/bcade13)), closes [#5002](https://github.com/IBM/kui/issues/5002)
- Confirm dialog color contrast issues ([da14c25](https://github.com/IBM/kui/commit/da14c25)), closes [#4995](https://github.com/IBM/kui/issues/4995)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- erratic scroll region behavior ([be0e2a0](https://github.com/IBM/kui/commit/be0e2a0)), closes [#4898](https://github.com/IBM/kui/issues/4898)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- increase contrast in watch pane ([246ecd2](https://github.com/IBM/kui/commit/246ecd2)), closes [#5000](https://github.com/IBM/kui/issues/5000) [#5001](https://github.com/IBM/kui/issues/5001)
- move default loadingDone icon into plugin-client-common ([39994bc](https://github.com/IBM/kui/commit/39994bc)), closes [#5026](https://github.com/IBM/kui/issues/5026)
- move patternfly alignment out of patternfly themes plugin ([6adbfd6](https://github.com/IBM/kui/commit/6adbfd6)), closes [#4988](https://github.com/IBM/kui/issues/4988)
- page-content p should not use text-align: justify ([2646f4b](https://github.com/IBM/kui/commit/2646f4b)), closes [#4908](https://github.com/IBM/kui/issues/4908)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- still see name-related breadcrumbs and short-name header with feature flag sidecarName 'heroText' ([1a8be9f](https://github.com/IBM/kui/commit/1a8be9f)), closes [#5013](https://github.com/IBM/kui/issues/5013)
- **plugins/plugin-client-common:** poor alignment of sidecar toolbar elements ([2307a46](https://github.com/IBM/kui/commit/2307a46)), closes [#4970](https://github.com/IBM/kui/issues/4970)
- **plugins/plugin-client-common:** reverse-i-search does not properly report no matches ([c16dad3](https://github.com/IBM/kui/commit/c16dad3)), closes [#4943](https://github.com/IBM/kui/issues/4943)
- **plugins/plugin-client-common:** Screenshot modal never goes away ([bbd1c98](https://github.com/IBM/kui/commit/bbd1c98)), closes [#4979](https://github.com/IBM/kui/issues/4979)
- **plugins/plugin-client-common:** spurious warning in the console re: Tag ([93982de](https://github.com/IBM/kui/commit/93982de)), closes [#4959](https://github.com/IBM/kui/issues/4959)
- **plugins/plugin-client-common:** UpdateNotification widget has invisible background color ([c0c1d82](https://github.com/IBM/kui/commit/c0c1d82)), closes [#4968](https://github.com/IBM/kui/issues/4968)
- **plugins/plugin-client-common:** WatchPane has incorrect padding ([e74bd7b](https://github.com/IBM/kui/commit/e74bd7b)), closes [#5015](https://github.com/IBM/kui/issues/5015)
- **plugins/plugin-patternfly-themes:** update theme alignment to patternfly v4 ([3784b96](https://github.com/IBM/kui/commit/3784b96)), closes [#4948](https://github.com/IBM/kui/issues/4948)
- upgrade @patternfly/react-core to latest ([0331533](https://github.com/IBM/kui/commit/0331533)), closes [#4937](https://github.com/IBM/kui/issues/4937)
- **plugins/plugn-client-common:** TopTabStripe stays blue after command execution completes ([68f5841](https://github.com/IBM/kui/commit/68f5841)), closes [#4883](https://github.com/IBM/kui/issues/4883)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- **plugins/plugin-client-common:** table container should only be width:100% for table not display-as-grid ([8f327cd](https://github.com/IBM/kui/commit/8f327cd)), closes [#4871](https://github.com/IBM/kui/issues/4871)
- split screen terminals sometimes incorrect handle exit ([d63cde7](https://github.com/IBM/kui/commit/d63cde7)), closes [#4860](https://github.com/IBM/kui/issues/4860)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** clicking the remove button of a repl block results in an error white screen ([49bfbcc](https://github.com/IBM/kui/commit/49bfbcc)), closes [#4855](https://github.com/IBM/kui/issues/4855)
- **plugins/plugin-client-common:** dropdown in sidecar theming and spacing tweaks ([1a48af3](https://github.com/IBM/kui/commit/1a48af3)), closes [#4680](https://github.com/IBM/kui/issues/4680)
- **plugins/plugin-client-common:** improve visibility of sidecar scrollbars ([827d75a](https://github.com/IBM/kui/commit/827d75a)), closes [#4667](https://github.com/IBM/kui/issues/4667)
- **plugins/plugin-client-common:** increase font size of status stripe ([2fab637](https://github.com/IBM/kui/commit/2fab637)), closes [#4698](https://github.com/IBM/kui/issues/4698)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** input element changes height with i-search and bottomInput ([abf9890](https://github.com/IBM/kui/commit/abf9890)), closes [#4685](https://github.com/IBM/kui/issues/4685)
- **plugins/plugin-client-common:** LeftNav sidecar nav column width inconsistency ([17e403f](https://github.com/IBM/kui/commit/17e403f)), closes [#4688](https://github.com/IBM/kui/issues/4688)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** LeftNavSidecar does not always reflect updated content ([0f2e1e1](https://github.com/IBM/kui/commit/0f2e1e1)), closes [#4727](https://github.com/IBM/kui/issues/4727) [#4732](https://github.com/IBM/kui/issues/4732)
- **plugins/plugin-client-common:** LeftNavSidecar font size and layout issues ([d9914f1](https://github.com/IBM/kui/commit/d9914f1)), closes [#4718](https://github.com/IBM/kui/issues/4718) [#4719](https://github.com/IBM/kui/issues/4719)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** move screenshot button out of status stripe ([0ef900b](https://github.com/IBM/kui/commit/0ef900b)), closes [#4556](https://github.com/IBM/kui/issues/4556)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** PatternFly DropDown rendering glitches ([8efedd8](https://github.com/IBM/kui/commit/8efedd8)), closes [#4649](https://github.com/IBM/kui/issues/4649) [#4651](https://github.com/IBM/kui/issues/4651)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** refine Loading component ([7a07ad3](https://github.com/IBM/kui/commit/7a07ad3)), closes [#4702](https://github.com/IBM/kui/issues/4702)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- **plugins/plugin-client-common:** Terminal screenshot odd w.r.t. auto-focus ([4b1c7d8](https://github.com/IBM/kui/commit/4b1c7d8)), closes [#4739](https://github.com/IBM/kui/issues/4739)
- **plugins/plugin-client-common:** top tab buttons should be owned by the top tab stripe ([9a45c43](https://github.com/IBM/kui/commit/9a45c43)), closes [#4690](https://github.com/IBM/kui/issues/4690)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** reverse the dependency of Card and DropDown ([00b8ecf](https://github.com/IBM/kui/commit/00b8ecf)), closes [#4641](https://github.com/IBM/kui/issues/4641)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- sidecar back/forward should be ordered by visitation rather than insertion ([fba613a](https://github.com/IBM/kui/commit/fba613a)), closes [#4746](https://github.com/IBM/kui/issues/4746)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** Screenshot button should not be offered inBrowser ([d1c2cfb](https://github.com/IBM/kui/commit/d1c2cfb)), closes [#4636](https://github.com/IBM/kui/issues/4636)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- TopNavSidecar doesn't return to the previous selected Tab when back button is hit ([32acee5](https://github.com/IBM/kui/commit/32acee5)), closes [#4745](https://github.com/IBM/kui/issues/4745)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** session init done message messes up Terminal scrolling ([7e80ac1](https://github.com/IBM/kui/commit/7e80ac1)), closes [#4683](https://github.com/IBM/kui/issues/4683)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** sidecar toolbar text incorrectly aligned ([ddd7460](https://github.com/IBM/kui/commit/ddd7460)), closes [#4659](https://github.com/IBM/kui/issues/4659)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** TopNavSidecar tabs easily overflow with narrower windows ([a555cd4](https://github.com/IBM/kui/commit/a555cd4)), closes [#4735](https://github.com/IBM/kui/issues/4735)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **plugins/plugin-client-common:** WatchPane has non-zero height even when empty ([67a7070](https://github.com/IBM/kui/commit/67a7070)), closes [#4629](https://github.com/IBM/kui/issues/4629)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- sidecar container selection kebab has different color with its menu ([639617a](https://github.com/IBM/kui/commit/639617a)), closes [#4676](https://github.com/IBM/kui/issues/4676)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugins-client-common:** Carbon Accordion spi should have more contrast ([c0de84d](https://github.com/IBM/kui/commit/c0de84d)), closes [#6111](https://github.com/IBM/kui/issues/6111)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- allow table drilldown to a new window ([96d1d0e](https://github.com/IBM/kui/commit/96d1d0e))
- **packages/core:** export prettyPrintBytes function ([5a3296f](https://github.com/IBM/kui/commit/5a3296f)), closes [#7364](https://github.com/IBM/kui/issues/7364)
- **packages/core:** improve display of pipes vs quotes and backslash escape ([d951f54](https://github.com/IBM/kui/commit/d951f54)), closes [#7195](https://github.com/IBM/kui/issues/7195)
- **plugins/plugin-client-common:** allow Clients to chose not to show the StatusStripe ([b3bac1c](https://github.com/IBM/kui/commit/b3bac1c)), closes [#7359](https://github.com/IBM/kui/issues/7359)
- **plugins/plugin-client-common:** enable monaco-editor word wrapping ([24e43f6](https://github.com/IBM/kui/commit/24e43f6)), closes [#7311](https://github.com/IBM/kui/issues/7311)
- **plugins/plugin-client-common:** export the command line rendering component ([eb8333e](https://github.com/IBM/kui/commit/eb8333e)), closes [#7365](https://github.com/IBM/kui/issues/7365)
- **plugins/plugin-client-common:** Improve sass mixins ([cd4143d](https://github.com/IBM/kui/commit/cd4143d)), closes [#7361](https://github.com/IBM/kui/issues/7361)
- add Kubernetes Dashboard Notebook ([9f62b63](https://github.com/IBM/kui/commit/9f62b63)), closes [#5617](https://github.com/IBM/kui/issues/5617) [#6915](https://github.com/IBM/kui/issues/6915) [#6917](https://github.com/IBM/kui/issues/6917)
- add typeahead to kubernetes context and namespace select widget ([ff9d273](https://github.com/IBM/kui/commit/ff9d273)), closes [#7034](https://github.com/IBM/kui/issues/7034)
- Allow command registrants to specify no semicolon expansion ([dbcaf87](https://github.com/IBM/kui/commit/dbcaf87)), closes [#6396](https://github.com/IBM/kui/issues/6396)
- cache files when watching a command ([77623cb](https://github.com/IBM/kui/commit/77623cb)), closes [#7163](https://github.com/IBM/kui/issues/7163)
- cd command handles VFS mounts ([b66a2fb](https://github.com/IBM/kui/commit/b66a2fb)), closes [#6988](https://github.com/IBM/kui/issues/6988)
- core/repl handles redirecting command output to files in VFS ([51889c1](https://github.com/IBM/kui/commit/51889c1))
- Expand kubectl direct watching to support heterogeneous use cases ([8df1ad3](https://github.com/IBM/kui/commit/8df1ad3)), closes [#6504](https://github.com/IBM/kui/issues/6504)
- Extend kubectl optimizations to table watching ([9a2bc74](https://github.com/IBM/kui/commit/9a2bc74)), closes [#6449](https://github.com/IBM/kui/issues/6449)
- group namespaces by internal/regular in CurrentNamespace ([be2d98f](https://github.com/IBM/kui/commit/be2d98f)), closes [#7058](https://github.com/IBM/kui/issues/7058)
- improve streaming ansi support from controllers to UI ([0d41c82](https://github.com/IBM/kui/commit/0d41c82))
- improve the split layout progression ([d3f2d6c](https://github.com/IBM/kui/commit/d3f2d6c)), closes [#6747](https://github.com/IBM/kui/issues/6747) [#6743](https://github.com/IBM/kui/issues/6743)
- improved support for commentary-from-file ([2efc70e](https://github.com/IBM/kui/commit/2efc70e)), closes [#7074](https://github.com/IBM/kui/issues/7074)
- initial support for using a kubectl proxy ([47b26be](https://github.com/IBM/kui/commit/47b26be)), closes [#6440](https://github.com/IBM/kui/issues/6440)
- Kui implementation of `watch` ([2cb3f98](https://github.com/IBM/kui/commit/2cb3f98)), closes [#6379](https://github.com/IBM/kui/issues/6379)
- SequenceDiagram shows row's message in the throughput column ([7d6cc9a](https://github.com/IBM/kui/commit/7d6cc9a))
- **plugins/plugin-client-common:** grammy should assign bar colors based on categories ([e679517](https://github.com/IBM/kui/commit/e679517)), closes [#7165](https://github.com/IBM/kui/issues/7165)
- Meta-click on table entries should open the drilldown in a different split ([fb89c29](https://github.com/IBM/kui/commit/fb89c29)), closes [#6403](https://github.com/IBM/kui/issues/6403)
- show buttons of related resources in sidecar footer ([e10f7f2](https://github.com/IBM/kui/commit/e10f7f2)), closes [#6856](https://github.com/IBM/kui/issues/6856)
- show placeholder text to explain that ctrl+d closes split ([065990d](https://github.com/IBM/kui/commit/065990d)), closes [#7060](https://github.com/IBM/kui/issues/7060)
- TopTab buttons should have improved tooltips ([5282612](https://github.com/IBM/kui/commit/5282612)), closes [#6806](https://github.com/IBM/kui/issues/6806)
- view table as histogram ([503c10a](https://github.com/IBM/kui/commit/503c10a)), closes [#7138](https://github.com/IBM/kui/issues/7138)
- **plugins/plugin-client-common:** add Select description and isDisabled props ([e0d1c37](https://github.com/IBM/kui/commit/e0d1c37)), closes [#7044](https://github.com/IBM/kui/issues/7044)
- **plugins/plugin-client-common:** allow easier rerunning of command from terminal ([c5384e0](https://github.com/IBM/kui/commit/c5384e0)), closes [#4570](https://github.com/IBM/kui/issues/4570)
- **plugins/plugin-client-common:** improve rendering of long pipeline command lines ([01d1ccd](https://github.com/IBM/kui/commit/01d1ccd)), closes [#7125](https://github.com/IBM/kui/issues/7125)
- **plugins/plugin-client-common:** last updated indicator in table footer ([5f91f75](https://github.com/IBM/kui/commit/5f91f75)), closes [#6783](https://github.com/IBM/kui/issues/6783)
- **plugins/plugin-client-common:** Processing command line should line wrap ([23f3f75](https://github.com/IBM/kui/commit/23f3f75)), closes [#7127](https://github.com/IBM/kui/issues/7127)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- revive "app" and "tier" columns from deprecated kubectl tree view ([cd642d9](https://github.com/IBM/kui/commit/cd642d9)), closes [#6591](https://github.com/IBM/kui/issues/6591)
- update core watch command to return watchable table ([aa0cf29](https://github.com/IBM/kui/commit/aa0cf29)), closes [#7119](https://github.com/IBM/kui/issues/7119)
- **plugins/plugin-client-common:** Improve notebook-style ui ([791160e](https://github.com/IBM/kui/commit/791160e)), closes [#5472](https://github.com/IBM/kui/issues/5472)
- **plugins/plugin-client-common:** improve presentation of sidecar-destined responses ([02b91e3](https://github.com/IBM/kui/commit/02b91e3)), closes [#5463](https://github.com/IBM/kui/issues/5463)
- **plugins/plugin-client-common:** SequenceDiagram should offer more information about input files ([b3c361e](https://github.com/IBM/kui/commit/b3c361e)), closes [#7037](https://github.com/IBM/kui/issues/7037)
- preserve changes of table view state in Notebook ([a2efb8a](https://github.com/IBM/kui/commit/a2efb8a)), closes [#5399](https://github.com/IBM/kui/issues/5399)
- use Select Component for Kubernetes Context and Namespace status stripe widgets ([0e1c25e](https://github.com/IBM/kui/commit/0e1c25e)), closes [#6920](https://github.com/IBM/kui/issues/6920)
- **plugins/plugin-client-common:** empty tables use PatternFly's "empty state" UI ([f7ccdf1](https://github.com/IBM/kui/commit/f7ccdf1)), closes [#6867](https://github.com/IBM/kui/issues/6867)
- ability to register an onClose handler when opening a tab ([58a36c3](https://github.com/IBM/kui/commit/58a36c3)), closes [#5670](https://github.com/IBM/kui/issues/5670)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add capability to click to edit/rerun a command ([4296933](https://github.com/IBM/kui/commit/4296933)), closes [#5654](https://github.com/IBM/kui/issues/5654)
- add delta summary to Tree ([95a0b4a](https://github.com/IBM/kui/commit/95a0b4a)), closes [#6329](https://github.com/IBM/kui/issues/6329)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- add unit support of TreeResponse as one of the contents in MultiModalResponse ([85ea2d5](https://github.com/IBM/kui/commit/85ea2d5)), closes [#6132](https://github.com/IBM/kui/issues/6132)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- clicking changed files in the `git status widget` should show `git diff` result in a DiffEditor ([3a199c7](https://github.com/IBM/kui/commit/3a199c7)), closes [#6348](https://github.com/IBM/kui/issues/6348)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- execute the command in url query when the browser app is loaded ([b0b95cf](https://github.com/IBM/kui/commit/b0b95cf)), closes [#5879](https://github.com/IBM/kui/issues/5879)
- Feature: improve support for parallelization across VFS operations ([e05d7e0](https://github.com/IBM/kui/commit/e05d7e0)), closes [#5831](https://github.com/IBM/kui/issues/5831)
- improve repl-block selection ([305b36f](https://github.com/IBM/kui/commit/305b36f)), closes [#5587](https://github.com/IBM/kui/issues/5587)
- Improve support for designing light themes ([b6c859f](https://github.com/IBM/kui/commit/b6c859f)), closes [#6372](https://github.com/IBM/kui/issues/6372)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- introduce reexec for rerunning commands ([fe80525](https://github.com/IBM/kui/commit/fe80525)), closes [#6026](https://github.com/IBM/kui/issues/6026)
- inverse splits ([38d2895](https://github.com/IBM/kui/commit/38d2895)), closes [#5537](https://github.com/IBM/kui/issues/5537)
- lightweight ui options for core themes ([cf96867](https://github.com/IBM/kui/commit/cf96867)), closes [#6187](https://github.com/IBM/kui/issues/6187)
- Make a notebook about making notebooks ([0d67947](https://github.com/IBM/kui/commit/0d67947)), closes [#6040](https://github.com/IBM/kui/issues/6040)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- pause and resume watchable jobs ([5d3f719](https://github.com/IBM/kui/commit/5d3f719)), closes [#1747](https://github.com/IBM/kui/issues/1747)
- port experimental scale-out grep to use new job controller ([45ce460](https://github.com/IBM/kui/commit/45ce460)), closes [#6280](https://github.com/IBM/kui/issues/6280)
- Refine Update Checker widget UI ([5c97479](https://github.com/IBM/kui/commit/5c97479)), closes [#6343](https://github.com/IBM/kui/issues/6343)
- save/restore pty command output ([2c291a9](https://github.com/IBM/kui/commit/2c291a9)), closes [#5314](https://github.com/IBM/kui/issues/5314)
- update CurrentContext widget to use Dropdown ([9520e5d](https://github.com/IBM/kui/commit/9520e5d)), closes [#6354](https://github.com/IBM/kui/issues/6354)
- use a Popover UI for git branch status stripe widget ([6bbf348](https://github.com/IBM/kui/commit/6bbf348)), closes [#6325](https://github.com/IBM/kui/issues/6325)
- use Accordion for SourceRef ([1b11736](https://github.com/IBM/kui/commit/1b11736)), closes [#6097](https://github.com/IBM/kui/issues/6097)
- use new Dropdown status stripe for CurrentNamespace widget ([0f7648c](https://github.com/IBM/kui/commit/0f7648c)), closes [#6351](https://github.com/IBM/kui/issues/6351)
- UX: Use Dropdown for theme switcher ([6cc6a47](https://github.com/IBM/kui/commit/6cc6a47)), closes [#6347](https://github.com/IBM/kui/issues/6347)
- **plugins/plugin-client-common:** allow clients to specify initial tab title ([e8e365f](https://github.com/IBM/kui/commit/e8e365f)), closes [#5539](https://github.com/IBM/kui/issues/5539)
- **plugins/plugin-client-common:** Allow user to specify CWD as prompt ([2b2e7a9](https://github.com/IBM/kui/commit/2b2e7a9)), closes [#6405](https://github.com/IBM/kui/issues/6405)
- **plugins/plugin-client-common:** allow users to insert command before a repl block ([e935092](https://github.com/IBM/kui/commit/e935092)), closes [#5576](https://github.com/IBM/kui/issues/5576)
- **plugins/plugin-client-common:** Allow users to opt in to default meta-click behavior ([13ea5b0](https://github.com/IBM/kui/commit/13ea5b0)), closes [#6406](https://github.com/IBM/kui/issues/6406)
- **plugins/plugin-client-common:** allow users to reorder blocks by MoveUp and MoveDown buttons ([f7f6918](https://github.com/IBM/kui/commit/f7f6918)), closes [#5589](https://github.com/IBM/kui/issues/5589)
- **plugins/plugin-client-common:** block-level copy/paste ([a72cf8d](https://github.com/IBM/kui/commit/a72cf8d)), closes [#5752](https://github.com/IBM/kui/issues/5752)
- **plugins/plugin-client-common:** edit a commentary response using SimpleEditor ([6d828c1](https://github.com/IBM/kui/commit/6d828c1)), closes [#5664](https://github.com/IBM/kui/issues/5664)
- **plugins/plugin-client-common:** error messages should format as markdown ([63ca4a7](https://github.com/IBM/kui/commit/63ca4a7)), closes [#5943](https://github.com/IBM/kui/issues/5943)
- **plugins/plugin-client-common:** for emacs users, it'd be nice if ctrl+backspace would delete prior "word" ([122eb88](https://github.com/IBM/kui/commit/122eb88)), closes [#6579](https://github.com/IBM/kui/issues/6579)
- **plugins/plugin-client-common:** improve action button UI for output-only blocks ([9cb99ad](https://github.com/IBM/kui/commit/9cb99ad)), closes [#5660](https://github.com/IBM/kui/issues/5660)
- **plugins/plugin-client-common:** Improve Commentary editing UI by adding real Done button ([1f544b5](https://github.com/IBM/kui/commit/1f544b5)), closes [#5667](https://github.com/IBM/kui/issues/5667)
- **plugins/plugin-client-common:** increase density of table content in minisplits ([8d6513f](https://github.com/IBM/kui/commit/8d6513f)), closes [#6790](https://github.com/IBM/kui/issues/6790)
- **plugins/plugin-client-common:** Output-only blocks should offer a Copy action button ([da4f85d](https://github.com/IBM/kui/commit/da4f85d)), closes [#5646](https://github.com/IBM/kui/issues/5646)
- **plugins/plugin-client-common:** Shift-enter or CmdCtrl+S to save within Commentary ([4cf496a](https://github.com/IBM/kui/commit/4cf496a)), closes [#6827](https://github.com/IBM/kui/issues/6827)
- **plugins/plugin-client-common:** SourceRef should be default-expanded in Notebooks? ([8ee26e8](https://github.com/IBM/kui/commit/8ee26e8)), closes [#5866](https://github.com/IBM/kui/issues/5866)
- **plugins/plugin-client-common:** split command should allow user to specify splice index ([75857e9](https://github.com/IBM/kui/commit/75857e9)), closes [#5746](https://github.com/IBM/kui/issues/5746)
- **plugins/plugin-client-common:** Tab completion should keep offering completions as I type ([67e44d3](https://github.com/IBM/kui/commit/67e44d3)), closes [#6472](https://github.com/IBM/kui/issues/6472)
- **plugins/plugin-client-common:** Table clickables should have better tooltip ([1eeaa01](https://github.com/IBM/kui/commit/1eeaa01)), closes [#6805](https://github.com/IBM/kui/issues/6805)
- **plugins/plugin-client-common:** User should be able to tab navigate through blocks ([54d3759](https://github.com/IBM/kui/commit/54d3759)), closes [#5717](https://github.com/IBM/kui/issues/5717)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- **plugins/plugin-kubectl:** Port kubectl pollers to use push, for homogeneous deletes ([82448d7](https://github.com/IBM/kui/commit/82448d7)), closes [#6481](https://github.com/IBM/kui/issues/6481) [#6486](https://github.com/IBM/kui/issues/6486)
- add a command to return the Card Component in Terminal ([d8d13ab](https://github.com/IBM/kui/commit/d8d13ab)), closes [#4973](https://github.com/IBM/kui/issues/4973)
- add alert command to display Alert component in Terminal ([495d3bb](https://github.com/IBM/kui/commit/495d3bb)), closes [#4957](https://github.com/IBM/kui/issues/4957)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add CommentaryReponse to snapshot/replay the response of commentary command ([7d13a93](https://github.com/IBM/kui/commit/7d13a93)), closes [#5439](https://github.com/IBM/kui/issues/5439)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add sequence diagram to table with timestamp columns ([e9028ee](https://github.com/IBM/kui/commit/e9028ee)), closes [#5336](https://github.com/IBM/kui/issues/5336)
- allow clients to modify the session lifecycle UI by providing custom strings ([3c78fd3](https://github.com/IBM/kui/commit/3c78fd3)), closes [#5019](https://github.com/IBM/kui/issues/5019)
- allow command registrations to express their experimental nature ([eb9f147](https://github.com/IBM/kui/commit/eb9f147)), closes [#5282](https://github.com/IBM/kui/issues/5282)
- allow subclasses of InputProvider to specify their own State ([c3fc88e](https://github.com/IBM/kui/commit/c3fc88e)), closes [#4756](https://github.com/IBM/kui/issues/4756)
- allow table model to specify a gridable column index ([f4ba8e6](https://github.com/IBM/kui/commit/f4ba8e6)), closes [#5278](https://github.com/IBM/kui/issues/5278)
- auto gridify large table ([bd22fa2](https://github.com/IBM/kui/commit/bd22fa2)), closes [#5305](https://github.com/IBM/kui/issues/5305)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- command history should be tab-specific ([1b987e0](https://github.com/IBM/kui/commit/1b987e0)), closes [#1299](https://github.com/IBM/kui/issues/1299)
- commentary command to add comments to REPL ([c304fd3](https://github.com/IBM/kui/commit/c304fd3)), closes [#5428](https://github.com/IBM/kui/issues/5428)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- initial/minimal snapshot/replay support ([bb7ae0f](https://github.com/IBM/kui/commit/bb7ae0f)), closes [#5280](https://github.com/IBM/kui/issues/5280)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- pass command line comments to commentary command ([a020db5](https://github.com/IBM/kui/commit/a020db5)), closes [#5459](https://github.com/IBM/kui/issues/5459)
- separate out themes into a new settings Notebook ([5180759](https://github.com/IBM/kui/commit/5180759)), closes [#5605](https://github.com/IBM/kui/issues/5605)
- snapshot freshening ([d5c8991](https://github.com/IBM/kui/commit/d5c8991)), closes [#5522](https://github.com/IBM/kui/issues/5522)
- support replaying in new tab ([04a2c67](https://github.com/IBM/kui/commit/04a2c67)), closes [#5509](https://github.com/IBM/kui/issues/5509)
- update ls to allow for presenting content from more limited VFS's such as tutorials ([a1ff1a4](https://github.com/IBM/kui/commit/a1ff1a4)), closes [#5497](https://github.com/IBM/kui/issues/5497)
- **plugins/plugin-client-common:** History navigation in minisplits should navigate In/Out pairs ([93eb2a4](https://github.com/IBM/kui/commit/93eb2a4)), closes [#5270](https://github.com/IBM/kui/issues/5270)
- **plugins/plugin-client-common:** show table row count in card header ([deadcfa](https://github.com/IBM/kui/commit/deadcfa)), closes [#5137](https://github.com/IBM/kui/issues/5137)
- **plugins/plugin-client-common:** use inner scrolling for RadioTables in main Terminals ([952f72a](https://github.com/IBM/kui/commit/952f72a)), closes [#5133](https://github.com/IBM/kui/issues/5133)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- shift Block UI to use a Notebook style of presentation ([dc0ee4b](https://github.com/IBM/kui/commit/dc0ee4b)), closes [#5258](https://github.com/IBM/kui/issues/5258)
- Timeline view for kubernetes Jobs ([b623e4e](https://github.com/IBM/kui/commit/b623e4e)), closes [#5370](https://github.com/IBM/kui/issues/5370)
- **plugins/plugin-client-common:** add support for Tags in StatusStripe ([d112c86](https://github.com/IBM/kui/commit/d112c86)), closes [#4951](https://github.com/IBM/kui/issues/4951)
- **plugins/plugin-client-common:** improve accessibility of "red" error grid cells ([8921292](https://github.com/IBM/kui/commit/8921292)), closes [#4938](https://github.com/IBM/kui/issues/4938)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- **plugins/plugin-client-common:** support client option for hero names in sidecar ([d4f6984](https://github.com/IBM/kui/commit/d4f6984)), closes [#4909](https://github.com/IBM/kui/issues/4909)
- **plugins/plugin-client-common:** use Cards to wrap kube tables and grids ([6698013](https://github.com/IBM/kui/commit/6698013)), closes [#5032](https://github.com/IBM/kui/issues/5032)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- update checker ([a7908d2](https://github.com/IBM/kui/commit/a7908d2)), closes [#4537](https://github.com/IBM/kui/issues/4537)
- Update default loadingDone to use Card component ([e1b4c61](https://github.com/IBM/kui/commit/e1b4c61)), closes [#4986](https://github.com/IBM/kui/issues/4986)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- <Kui> should allow for custom Input elements ([193a108](https://github.com/IBM/kui/commit/193a108)), closes [#4672](https://github.com/IBM/kui/issues/4672)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for <Kui noPromptContext/> and <Kui prompt=">"/> ([a92063d](https://github.com/IBM/kui/commit/a92063d)), closes [#4653](https://github.com/IBM/kui/issues/4653)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow <Kui/> users to provide custom views for session init ([1f35894](https://github.com/IBM/kui/commit/1f35894)), closes [#4596](https://github.com/IBM/kui/issues/4596)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- Dropdown spi and use in Terminal Block ([327917b](https://github.com/IBM/kui/commit/327917b)), closes [#4589](https://github.com/IBM/kui/issues/4589) [#4556](https://github.com/IBM/kui/issues/4556)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- RadioTable and port of the themes table to use it ([79a3e8e](https://github.com/IBM/kui/commit/79a3e8e)), closes [#4507](https://github.com/IBM/kui/issues/4507)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [10.2.0](https://github.com/IBM/kui/compare/v10.1.1-dev-20210223-062039...v10.2.0) (2021-02-24)

### Bug Fixes

- **plugins/plugin-client-common:** offline notebooks have unnecessary buttons ([09d0af6](https://github.com/IBM/kui/commit/09d0af6)), closes [#7076](https://github.com/IBM/kui/issues/7076)

### Features

- improved support for commentary-from-file ([2efc70e](https://github.com/IBM/kui/commit/2efc70e)), closes [#7074](https://github.com/IBM/kui/issues/7074)

## [10.1.1-dev-20210223-062039](https://github.com/IBM/kui/compare/v10.1.1-dev-20210221-141404...v10.1.1-dev-20210223-062039) (2021-02-23)

### Features

- show placeholder text to explain that ctrl+d closes split ([065990d](https://github.com/IBM/kui/commit/065990d)), closes [#7060](https://github.com/IBM/kui/issues/7060)

## [10.1.1-dev-20210221-141404](https://github.com/IBM/kui/compare/v10.1.1-dev-20210219-194602...v10.1.1-dev-20210221-141404) (2021-02-21)

### Features

- group namespaces by internal/regular in CurrentNamespace ([be2d98f](https://github.com/IBM/kui/commit/be2d98f)), closes [#7058](https://github.com/IBM/kui/issues/7058)

## [10.1.1-dev-20210219-194602](https://github.com/IBM/kui/compare/v10.1.1-dev-20210218-202429...v10.1.1-dev-20210219-194602) (2021-02-20)

### Bug Fixes

- **plugins/plugin-client-common:** header inference logic does not copy over hide-in-sidecar hints ([34b11ed](https://github.com/IBM/kui/commit/34b11ed)), closes [#7053](https://github.com/IBM/kui/issues/7053)
- **plugins/plugin-client-common:** in browser clients, the prompt may not be initially focused ([76a4419](https://github.com/IBM/kui/commit/76a4419)), closes [#7056](https://github.com/IBM/kui/issues/7056)

## [10.1.1-dev-20210218-202429](https://github.com/IBM/kui/compare/v10.1.1-dev-20210218-164854...v10.1.1-dev-20210218-202429) (2021-02-19)

### Bug Fixes

- **plugins/plugin-client-common:** make popover-select widget narrower ([82d27d1](https://github.com/IBM/kui/commit/82d27d1)), closes [#7046](https://github.com/IBM/kui/issues/7046)

## [10.1.1-dev-20210218-164854](https://github.com/IBM/kui/compare/v10.1.1-dev-20210218-131731...v10.1.1-dev-20210218-164854) (2021-02-18)

### Features

- **plugins/plugin-client-common:** add Select description and isDisabled props ([e0d1c37](https://github.com/IBM/kui/commit/e0d1c37)), closes [#7044](https://github.com/IBM/kui/issues/7044)
- **plugins/plugin-client-common:** SequenceDiagram should offer more information about input files ([b3c361e](https://github.com/IBM/kui/commit/b3c361e)), closes [#7037](https://github.com/IBM/kui/issues/7037)

## [10.1.1-dev-20210218-131731](https://github.com/IBM/kui/compare/v10.1.1-dev-20210216-094031...v10.1.1-dev-20210218-131731) (2021-02-18)

### Bug Fixes

- missing some theme alignment rules for pf-t-dark ([60486a2](https://github.com/IBM/kui/commit/60486a2)), closes [#7036](https://github.com/IBM/kui/issues/7036)
- **plugins/plugin-client-common:** "lost connection to your cluster" alert takes up the full window height ([71f2236](https://github.com/IBM/kui/commit/71f2236)), closes [#7018](https://github.com/IBM/kui/issues/7018)
- **plugins/plugin-client-common:** improve SequenceDiagram layout of gap, status, and duration columns ([9341ec7](https://github.com/IBM/kui/commit/9341ec7)), closes [#7028](https://github.com/IBM/kui/issues/7028)

### Features

- add typeahead to kubernetes context and namespace select widget ([ff9d273](https://github.com/IBM/kui/commit/ff9d273)), closes [#7034](https://github.com/IBM/kui/issues/7034)
- use Select Component for Kubernetes Context and Namespace status stripe widgets ([0e1c25e](https://github.com/IBM/kui/commit/0e1c25e)), closes [#6920](https://github.com/IBM/kui/issues/6920)

## [10.1.1-dev-20210216-094031](https://github.com/IBM/kui/compare/v10.1.1-dev-20210215-213847...v10.1.1-dev-20210216-094031) (2021-02-16)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.1.1-dev-20210215-213847](https://github.com/IBM/kui/compare/v10.1.1-dev-20210215-184959...v10.1.1-dev-20210215-213847) (2021-02-16)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.1.1-dev-20210215-184959](https://github.com/IBM/kui/compare/v10.1.1-dev-20210215-161454...v10.1.1-dev-20210215-184959) (2021-02-15)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.1.1-dev-20210215-161454](https://github.com/IBM/kui/compare/v10.1.1-dev-20210211-145439...v10.1.1-dev-20210215-161454) (2021-02-15)

**Note:** Version bump only for package @kui-shell/plugin-client-common

## [10.1.1-dev-20210211-145439](https://github.com/IBM/kui/compare/v4.5.0...v10.1.1-dev-20210211-145439) (2021-02-11)

### Bug Fixes

- **plugins-client-common:** bump carbon-components-react to 7.22 ([8b98791](https://github.com/IBM/kui/commit/8b98791)), closes [#6011](https://github.com/IBM/kui/issues/6011)
- **plugins-client-common:** the experimental tag should use sans serif ([143464a](https://github.com/IBM/kui/commit/143464a)), closes [#5363](https://github.com/IBM/kui/issues/5363)
- **plugins/plugin-client-common:** a few more small tweaks to welcome notebook ([27773cb](https://github.com/IBM/kui/commit/27773cb)), closes [#6829](https://github.com/IBM/kui/issues/6829)
- **plugins/plugin-client-common:** blocks with Processing commands cannot be removed ([626c419](https://github.com/IBM/kui/commit/626c419)), closes [#6954](https://github.com/IBM/kui/issues/6954)
- **plugins/plugin-client-common:** events table doesn't handle long messages and narrow viewports ([ea90a34](https://github.com/IBM/kui/commit/ea90a34)), closes [#6831](https://github.com/IBM/kui/issues/6831)
- **plugins/plugin-client-common:** Grids in minisplits have horizontal overflow ([d2483fd](https://github.com/IBM/kui/commit/d2483fd)), closes [#6781](https://github.com/IBM/kui/issues/6781)
- **plugins/plugin-client-common:** Increase entryDelay for table tooltips ([4e3739a](https://github.com/IBM/kui/commit/4e3739a)), closes [#6870](https://github.com/IBM/kui/issues/6870)
- **plugins/plugin-client-common:** isWidthConstrained is always true for nSplits > 1 ([7d832f2](https://github.com/IBM/kui/commit/7d832f2)), closes [#6782](https://github.com/IBM/kui/issues/6782)
- **plugins/plugin-client-common:** kubectl unified tables have a NAME column (all caps) ([419f35d](https://github.com/IBM/kui/commit/419f35d)), closes [#6820](https://github.com/IBM/kui/issues/6820)
- **plugins/plugin-client-common:** ls does not render markdown cells properly ([1083962](https://github.com/IBM/kui/commit/1083962)), closes [#7000](https://github.com/IBM/kui/issues/7000)
- **plugins/plugin-client-common:** Markdown links should have a tooltip ([9a1f2d9](https://github.com/IBM/kui/commit/9a1f2d9)), closes [#6939](https://github.com/IBM/kui/issues/6939)
- **plugins/plugin-client-common:** Tab Completion view color codes partial completions if no slashes ([78010a8](https://github.com/IBM/kui/commit/78010a8)), closes [#6993](https://github.com/IBM/kui/issues/6993)
- ctrl+c then clear results in wrong command being executed ([b153110](https://github.com/IBM/kui/commit/b153110)), closes [#6979](https://github.com/IBM/kui/issues/6979)
- **plugins/plugin-client-common:** Block borders aren't quite right ([7050a02](https://github.com/IBM/kui/commit/7050a02)), closes [#6808](https://github.com/IBM/kui/issues/6808)
- **plugins/plugin-client-common:** live tables may never show "Last Updated" footer message ([477fa04](https://github.com/IBM/kui/commit/477fa04)), closes [#6845](https://github.com/IBM/kui/issues/6845)
- **plugins/plugin-client-common:** Markdown kuiexec drilldowns do not work if Markdown isn't passed a REPL controller ([90652f3](https://github.com/IBM/kui/commit/90652f3)), closes [#6977](https://github.com/IBM/kui/issues/6977)
- **plugins/plugin-client-common:** Markdown lists may lack bullets/numbers ([3db9eaa](https://github.com/IBM/kui/commit/3db9eaa)), closes [#6947](https://github.com/IBM/kui/issues/6947)
- **plugins/plugin-client-common:** Markdown renderer does not handle img tags with http src ([fe12530](https://github.com/IBM/kui/commit/fe12530)), closes [#6818](https://github.com/IBM/kui/issues/6818)
- **plugins/plugin-client-common:** Markdown rendering of images does not support percentage width or height ([6e75c40](https://github.com/IBM/kui/commit/6e75c40)), closes [#6822](https://github.com/IBM/kui/issues/6822)
- **plugins/plugin-client-common:** numeric responses may not be displayed ([93603cf](https://github.com/IBM/kui/commit/93603cf)), closes [#6982](https://github.com/IBM/kui/issues/6982)
- **plugins/plugin-client-common:** on windows, table breadcrumb has vertical scrollbars ([b2fda10](https://github.com/IBM/kui/commit/b2fda10)), closes [#6878](https://github.com/IBM/kui/issues/6878)
- **plugins/plugin-client-common:** popover has odd spacing and overflow ([12d2508](https://github.com/IBM/kui/commit/12d2508)), closes [#6809](https://github.com/IBM/kui/issues/6809)
- **plugins/plugin-client-common:** redirectToPlainSplitIfNeeded may favor smaller terminals ([58f9ab0](https://github.com/IBM/kui/commit/58f9ab0)), closes [#6930](https://github.com/IBM/kui/issues/6930)
- **plugins/plugin-client-common:** remove block border and refine input border for minisplits ([7b5ce5b](https://github.com/IBM/kui/commit/7b5ce5b)), closes [#6801](https://github.com/IBM/kui/issues/6801)
- **plugins/plugin-client-common:** restore Table sorting ([b590e6e](https://github.com/IBM/kui/commit/b590e6e)), closes [#6729](https://github.com/IBM/kui/issues/6729)
- **plugins/plugin-client-common:** Sidecar sticks to a short height when switching from Yaml -> Summary -> Yaml tab ([79e7df3](https://github.com/IBM/kui/commit/79e7df3)), closes [#6913](https://github.com/IBM/kui/issues/6913)
- **plugins/plugin-client-common:** sidecar top tabs may not have the proper sidecar header color ([dee76ed](https://github.com/IBM/kui/commit/dee76ed)), closes [#6841](https://github.com/IBM/kui/issues/6841)
- **plugins/plugin-client-common:** some grid cells display with no background color ([3d4a41d](https://github.com/IBM/kui/commit/3d4a41d)), closes [#6794](https://github.com/IBM/kui/issues/6794)
- **plugins/plugin-client-common:** sometimes both the block action buttons and the timestamp are visible at the same time ([a3ece2b](https://github.com/IBM/kui/commit/a3ece2b)), closes [#5936](https://github.com/IBM/kui/issues/5936)
- **plugins/plugin-client-common:** spinner is off-center by 1px ([e8cea91](https://github.com/IBM/kui/commit/e8cea91)), closes [#6885](https://github.com/IBM/kui/issues/6885)
- **plugins/plugin-client-common:** table clicks fail when the maximum number of splits is reached ([d2c6146](https://github.com/IBM/kui/commit/d2c6146)), closes [#6938](https://github.com/IBM/kui/issues/6938)
- **plugins/plugin-client-common:** Table header background color can be incorrect ([3249d89](https://github.com/IBM/kui/commit/3249d89)), closes [#6810](https://github.com/IBM/kui/issues/6810)
- **plugins/plugin-client-common:** Table header seems to float in front of dropdowns ([8a2b54b](https://github.com/IBM/kui/commit/8a2b54b)), closes [#6880](https://github.com/IBM/kui/issues/6880)
- **plugins/plugin-client-common:** Table onclick handlers applied to every cell ([d5a9c3a](https://github.com/IBM/kui/commit/d5a9c3a)), closes [#6792](https://github.com/IBM/kui/issues/6792)
- **plugins/plugin-client-common:** The pause watching icon should be grey ([a0de73a](https://github.com/IBM/kui/commit/a0de73a)), closes [#6931](https://github.com/IBM/kui/issues/6931)
- **plugins/plugin-client-common:** Tooltips for kuiexec markdown links have incorrect tooltip content ([e147fca](https://github.com/IBM/kui/commit/e147fca)), closes [#6958](https://github.com/IBM/kui/issues/6958)
- **plugins/plugin-client-common:** when there're 3 splits, clicking table cells in the first split fail ([77dfb54](https://github.com/IBM/kui/commit/77dfb54)), closes [#6937](https://github.com/IBM/kui/issues/6937)
- **plugins/plugin-client-common:** when there're 3 splits, clicking table in the first split will create the 4th split ([b894b27](https://github.com/IBM/kui/commit/b894b27)), closes [#6932](https://github.com/IBM/kui/issues/6932)
- change new split keyboard shortcut from cltrOrMeta+U -> +Y ([9cac19d](https://github.com/IBM/kui/commit/9cac19d)), closes [#6876](https://github.com/IBM/kui/issues/6876)
- in screenshot alert, the icon and title text are misaligned ([ff57573](https://github.com/IBM/kui/commit/ff57573)), closes [#6770](https://github.com/IBM/kui/issues/6770)
- kubectl direct/get does not specify that get tables have the `onclickIdempotent` property ([31361ec](https://github.com/IBM/kui/commit/31361ec)), closes [#6778](https://github.com/IBM/kui/issues/6778)
- Screenshot alert is not visible in narrower windows ([d94da68](https://github.com/IBM/kui/commit/d94da68)), closes [#6843](https://github.com/IBM/kui/issues/6843)
- UpdateChecker does not render tables, lists, or relative image refs properly ([3e6ba75](https://github.com/IBM/kui/commit/3e6ba75)), closes [#6918](https://github.com/IBM/kui/issues/6918)
- **plugins/plugin-client-common:** `kubectl get -f` does not render well when in a minisplit ([d9f6548](https://github.com/IBM/kui/commit/d9f6548)), closes [#6750](https://github.com/IBM/kui/issues/6750)
- **plugins/plugin-client-common:** age field in event footer is underlined ([c733449](https://github.com/IBM/kui/commit/c733449)), closes [#6739](https://github.com/IBM/kui/issues/6739)
- **plugins/plugin-client-common:** block action buttons and timestamp may both be visible ([6e63cb7](https://github.com/IBM/kui/commit/6e63cb7)), closes [#5936](https://github.com/IBM/kui/issues/5936)
- **plugins/plugin-client-common:** Dropdown hover effect in PatternFly4 Dark has no contrast ([35eefb4](https://github.com/IBM/kui/commit/35eefb4)), closes [#6744](https://github.com/IBM/kui/issues/6744)
- **plugins/plugin-client-common:** Events in tables-as-grid wrap when not needed ([fd46054](https://github.com/IBM/kui/commit/fd46054)), closes [#6600](https://github.com/IBM/kui/issues/6600)
- **plugins/plugin-client-common:** Experimental badge has low contrast in PatternFly4 Light theme ([7c0bfff](https://github.com/IBM/kui/commit/7c0bfff)), closes [#6715](https://github.com/IBM/kui/issues/6715)
- **plugins/plugin-client-common:** improve platform compatibility of Home and End keys ([da7393f](https://github.com/IBM/kui/commit/da7393f)), closes [#3267](https://github.com/IBM/kui/issues/3267)
- **plugins/plugin-client-common:** Improve rendering of Source Reference UI ([278b28f](https://github.com/IBM/kui/commit/278b28f)), closes [#6582](https://github.com/IBM/kui/issues/6582)
- **plugins/plugin-client-common:** Leftover console logs in ScrollableTerminal ([4f4af0d](https://github.com/IBM/kui/commit/4f4af0d)), closes [#6755](https://github.com/IBM/kui/issues/6755)
- **plugins/plugin-client-common:** Markdown handling of consecutive img tags only shows first ([1578e58](https://github.com/IBM/kui/commit/1578e58)), closes [#6602](https://github.com/IBM/kui/issues/6602)
- **plugins/plugin-client-common:** Markdown renderer does not handle image height attribute ([4d49eb9](https://github.com/IBM/kui/commit/4d49eb9)), closes [#6613](https://github.com/IBM/kui/issues/6613)
- **plugins/plugin-client-common:** Markdown renderer does not properly render tables ([69d45a9](https://github.com/IBM/kui/commit/69d45a9)), closes [#6563](https://github.com/IBM/kui/issues/6563) [#4364](https://github.com/IBM/kui/issues/4364)
- **plugins/plugin-client-common:** markdown spacing regressions with h3 and h4 ([d674931](https://github.com/IBM/kui/commit/d674931)), closes [#6736](https://github.com/IBM/kui/issues/6736)
- **plugins/plugin-client-common:** Markdown: validateDomNesting console error ([97b2c17](https://github.com/IBM/kui/commit/97b2c17)), closes [#6577](https://github.com/IBM/kui/issues/6577)
- **plugins/plugin-client-common:** new tabs don't receive focus for 2 seconds ([1705870](https://github.com/IBM/kui/commit/1705870)), closes [#6668](https://github.com/IBM/kui/issues/6668)
- **plugins/plugin-client-common:** onclick handlers for ls should respond only to clicking on text ([8477386](https://github.com/IBM/kui/commit/8477386)), closes [#6567](https://github.com/IBM/kui/issues/6567)
- **plugins/plugin-client-common:** PatternFly NavResponse does not unexpand ([d1f9dc9](https://github.com/IBM/kui/commit/d1f9dc9)), closes [#6669](https://github.com/IBM/kui/issues/6669)
- **plugins/plugin-client-common:** pty output in the first block does not render ([9ec3996](https://github.com/IBM/kui/commit/9ec3996)), closes [#6758](https://github.com/IBM/kui/issues/6758)
- **plugins/plugin-client-common:** React warnings in console due to new Modal spi ([57f0cf6](https://github.com/IBM/kui/commit/57f0cf6)), closes [#6696](https://github.com/IBM/kui/issues/6696)
- **plugins/plugin-client-common:** Remove superfluous padding around source ref items ([b821a2b](https://github.com/IBM/kui/commit/b821a2b)), closes [#6731](https://github.com/IBM/kui/issues/6731)
- **plugins/plugin-client-common:** repl context will overflow when scrollback has over 100 inputs ([9c84721](https://github.com/IBM/kui/commit/9c84721)), closes [#6646](https://github.com/IBM/kui/issues/6646)
- **plugins/plugin-client-common:** status stripe "dropdown" menus can have poor color contrast ([fda4ee6](https://github.com/IBM/kui/commit/fda4ee6)), closes [#6706](https://github.com/IBM/kui/issues/6706)
- **plugins/plugin-client-common:** tab completion can be flakey ([145d1a5](https://github.com/IBM/kui/commit/145d1a5)), closes [#6649](https://github.com/IBM/kui/issues/6649)
- **plugins/plugin-client-common:** tab completion does not render well in minisplits ([8eb0fbc](https://github.com/IBM/kui/commit/8eb0fbc)), closes [#6752](https://github.com/IBM/kui/issues/6752)
- **plugins/plugin-client-common:** tab-completion font-family regression ([13b3d49](https://github.com/IBM/kui/commit/13b3d49)), closes [#6751](https://github.com/IBM/kui/issues/6751)
- **plugins/plugin-client-common:** table and nav content are not left-aligned with breadcrumb ([a8b8015](https://github.com/IBM/kui/commit/a8b8015)), closes [#6741](https://github.com/IBM/kui/issues/6741)
- **plugins/plugin-client-common:** tables with inferred headers never allow for grid presentation ([a384783](https://github.com/IBM/kui/commit/a384783)), closes [#6763](https://github.com/IBM/kui/issues/6763)
- **plugins/plugin-client-common:** tweak sidecar button spacing a bit ([9bdf8a6](https://github.com/IBM/kui/commit/9bdf8a6)), closes [#6873](https://github.com/IBM/kui/issues/6873)
- the x in the offline badge is sometimes low contrast, especially in dark themes ([c60157c](https://github.com/IBM/kui/commit/c60157c)), closes [#6784](https://github.com/IBM/kui/issues/6784)
- **plugins/plugin-client-common:** With full-width blocks, PatternFly Tables have odd column spacing ([4062489](https://github.com/IBM/kui/commit/4062489)), closes [#6766](https://github.com/IBM/kui/issues/6766)
- **Plugins/plugin-client-common:** replayed notebooks don't always open scrolled to top ([6d71638](https://github.com/IBM/kui/commit/6d71638)), closes [#6824](https://github.com/IBM/kui/issues/6824)
- in minisplits, blocks that contain pty output may have excess whitespace ([d9299ae](https://github.com/IBM/kui/commit/d9299ae)), closes [#6759](https://github.com/IBM/kui/issues/6759)
- **plugins/plugin-client-common:** a few minor UI glitches in Block css ([a25c72c](https://github.com/IBM/kui/commit/a25c72c)), closes [#6335](https://github.com/IBM/kui/issues/6335)
- **plugins/plugin-client-common:** as sequence diagram nRows grows, rows shrink, but fonts do not ([eac0220](https://github.com/IBM/kui/commit/eac0220)), closes [#6420](https://github.com/IBM/kui/issues/6420)
- **plugins/plugin-client-common:** blocks with no input or output shouldn't have a background color ([42b5b01](https://github.com/IBM/kui/commit/42b5b01)), closes [#6367](https://github.com/IBM/kui/issues/6367)
- **plugins/plugin-client-common:** DiffEditor does not respond to resize events ([7f88934](https://github.com/IBM/kui/commit/7f88934)), closes [#6365](https://github.com/IBM/kui/issues/6365)
- **plugins/plugin-client-common:** Drilldown from table isn't always fully in view ([ba1222c](https://github.com/IBM/kui/commit/ba1222c)), closes [#6555](https://github.com/IBM/kui/issues/6555)
- **plugins/plugin-client-common:** DropdownWidget does not obey `title` property ([e534cbc](https://github.com/IBM/kui/commit/e534cbc)), closes [#6393](https://github.com/IBM/kui/issues/6393)
- **plugins/plugin-client-common:** first-time edits of commentary may cause editor to lose focus ([81b55e0](https://github.com/IBM/kui/commit/81b55e0)), closes [#6545](https://github.com/IBM/kui/issues/6545)
- **plugins/plugin-client-common:** in minisplits, no margin between active block and previous response ([e20c115](https://github.com/IBM/kui/commit/e20c115)), closes [#6333](https://github.com/IBM/kui/issues/6333)
- **plugins/plugin-client-common:** in PatternFly Light theme, status stripe hovers and borders are not visible ([8bfc9a1](https://github.com/IBM/kui/commit/8bfc9a1)), closes [#6324](https://github.com/IBM/kui/issues/6324)
- **plugins/plugin-client-common:** in patternfly-based components, the CurrentContext widget has poor alignment ([c6f873c](https://github.com/IBM/kui/commit/c6f873c)), closes [#6494](https://github.com/IBM/kui/issues/6494)
- **plugins/plugin-client-common:** inverted color context in mini splits can have low contrast ([2541d74](https://github.com/IBM/kui/commit/2541d74)), closes [#6383](https://github.com/IBM/kui/issues/6383)
- **plugins/plugin-client-common:** kubectl help sometimes does not line wrap properly ([b66928b](https://github.com/IBM/kui/commit/b66928b)), closes [#6425](https://github.com/IBM/kui/issues/6425)
- **plugins/plugin-client-common:** LeftNav UIs can be too wide ([5dae64c](https://github.com/IBM/kui/commit/5dae64c)), closes [#6302](https://github.com/IBM/kui/issues/6302)
- **plugins/plugin-client-common:** Markdown component does not properly handle local relative image paths ([deb7b47](https://github.com/IBM/kui/commit/deb7b47)), closes [#6547](https://github.com/IBM/kui/issues/6547)
- **plugins/plugin-client-common:** Markdown image does not properly handle align attribute ([5c382f8](https://github.com/IBM/kui/commit/5c382f8)), closes [#6551](https://github.com/IBM/kui/issues/6551)
- **plugins/plugin-client-common:** minor Output alignment regression ([91442ad](https://github.com/IBM/kui/commit/91442ad)), closes [#6438](https://github.com/IBM/kui/issues/6438)
- **plugins/plugin-client-common:** monaco editor always consumes mouse wheel scrolling events ([bed75eb](https://github.com/IBM/kui/commit/bed75eb)), closes [#6480](https://github.com/IBM/kui/issues/6480)
- **plugins/plugin-client-common:** new PatternFly TopTabStripe impl changes colors when a NavResponse is displayed ([d2d6a53](https://github.com/IBM/kui/commit/d2d6a53)), closes [#6553](https://github.com/IBM/kui/issues/6553)
- **plugins/plugin-client-common:** new patternfly-based TopTabStripe behaves poorly with narrower windows ([fc97ab8](https://github.com/IBM/kui/commit/fc97ab8)), closes [#6549](https://github.com/IBM/kui/issues/6549)
- **plugins/plugin-client-common:** patternfly popover close button has odd spacing ([e7c21fd](https://github.com/IBM/kui/commit/e7c21fd)), closes [#6345](https://github.com/IBM/kui/issues/6345)
- **plugins/plugin-client-common:** PatternFly themes are still using a carbon icon for Split ([4c05d28](https://github.com/IBM/kui/commit/4c05d28)), closes [#6322](https://github.com/IBM/kui/issues/6322)
- **plugins/plugin-client-common:** patternfly Tree component does not load patternfly base ([c38961b](https://github.com/IBM/kui/commit/c38961b)), closes [#6502](https://github.com/IBM/kui/issues/6502)
- **plugins/plugin-client-common:** PatternFly's CodeSnippet rendering issues ([48f30fa](https://github.com/IBM/kui/commit/48f30fa)), closes [#6542](https://github.com/IBM/kui/issues/6542) [#6544](https://github.com/IBM/kui/issues/6544)
- **plugins/plugin-client-common:** Popup mode client has a few status stripe rendering issues ([57bb8b2](https://github.com/IBM/kui/commit/57bb8b2)), closes [#6357](https://github.com/IBM/kui/issues/6357)
- **plugins/plugin-client-common:** Rendering glitches in carbon fonts for status stripe DropdownWidgets ([1ee18a6](https://github.com/IBM/kui/commit/1ee18a6)), closes [#6359](https://github.com/IBM/kui/issues/6359)
- **plugins/plugin-client-common:** Rendering of markdown files could be improved ([23d6e75](https://github.com/IBM/kui/commit/23d6e75)), closes [#6557](https://github.com/IBM/kui/issues/6557)
- kubectl contexts table has odd CURRENT column ([f6d0a98](https://github.com/IBM/kui/commit/f6d0a98)), closes [#6523](https://github.com/IBM/kui/issues/6523)
- use Dropdown component for RadioTable impl ([244b16a](https://github.com/IBM/kui/commit/244b16a)), closes [#6539](https://github.com/IBM/kui/issues/6539)
- **plugins/plugin-client-common:** processing block disappears in minisplits ([907a9d5](https://github.com/IBM/kui/commit/907a9d5)), closes [#6310](https://github.com/IBM/kui/issues/6310)
- **plugins/plugin-client-common:** show table click result in a new split ([fd1b3a1](https://github.com/IBM/kui/commit/fd1b3a1)), closes [#6477](https://github.com/IBM/kui/issues/6477)
- **plugins/plugin-client-common:** sidecar maximization is a bit off when in a split ([f103379](https://github.com/IBM/kui/commit/f103379)), closes [#6531](https://github.com/IBM/kui/issues/6531)
- **plugins/plugin-client-common:** sidecar toolbar text is not always vertically centered ([cbceee3](https://github.com/IBM/kui/commit/cbceee3)), closes [#6305](https://github.com/IBM/kui/issues/6305)
- **plugins/plugin-client-common:** sometimes response is not scrolled into view properly ([a2fae6a](https://github.com/IBM/kui/commit/a2fae6a)), closes [#6479](https://github.com/IBM/kui/issues/6479)
- **plugins/plugin-client-common:** table sorting may result in bad drilldown onclicks ([17d75c3](https://github.com/IBM/kui/commit/17d75c3)), closes [#6524](https://github.com/IBM/kui/issues/6524)
- Clean up the way patternfly fonts are incorporated into themes ([2ba49e9](https://github.com/IBM/kui/commit/2ba49e9)), closes [#6375](https://github.com/IBM/kui/issues/6375)
- DIffEditor should render inline when in terminal split ([b86b127](https://github.com/IBM/kui/commit/b86b127)), closes [#6366](https://github.com/IBM/kui/issues/6366)
- drilldown from an undeployed application in tree will issue a kubectl get with 404 ([309a9a0](https://github.com/IBM/kui/commit/309a9a0)), closes [#6331](https://github.com/IBM/kui/issues/6331)
- in patternfly-based themes, CurrentContext DropDown renders poorly ([f1a3faf](https://github.com/IBM/kui/commit/f1a3faf)), closes [#6496](https://github.com/IBM/kui/issues/6496)
- in patternfly4 light theme, the status stripe hovers background color are not visible ([a0e79d5](https://github.com/IBM/kui/commit/a0e79d5)), closes [#6361](https://github.com/IBM/kui/issues/6361)
- s3 job watcher sometimes fails due to startup issues ([8851d50](https://github.com/IBM/kui/commit/8851d50)), closes [#6411](https://github.com/IBM/kui/issues/6411)
- SequenceDiagram bar widths are pretty buggy ([6d1c458](https://github.com/IBM/kui/commit/6d1c458)), closes [#6408](https://github.com/IBM/kui/issues/6408)
- UpdateChecker popover can be too height ([8f87488](https://github.com/IBM/kui/commit/8f87488)), closes [#6413](https://github.com/IBM/kui/issues/6413)
- **plugins/plugin-client-common:** red and green overlays in diff views are hard to see ([1843bff](https://github.com/IBM/kui/commit/1843bff)), closes [#6363](https://github.com/IBM/kui/issues/6363)
- **plugins/plugin-client-common:** TopTabStripe for Lightweight UI themes could be a bit lighter-weight ([8d0e144](https://github.com/IBM/kui/commit/8d0e144)), closes [#6398](https://github.com/IBM/kui/issues/6398)
- tree should support leaf node drilling down ([006b881](https://github.com/IBM/kui/commit/006b881)), closes [#6293](https://github.com/IBM/kui/issues/6293)
- **plugins/plugin-client-common:** "No events in the past hour" in sidecar has different bg color than other tabs ([ffba806](https://github.com/IBM/kui/commit/ffba806)), closes [#6075](https://github.com/IBM/kui/issues/6075)
- **plugins/plugin-client-common:** `ls` in minisplit has tall rows ([00b5e41](https://github.com/IBM/kui/commit/00b5e41)), closes [#6289](https://github.com/IBM/kui/issues/6289)
- **plugins/plugin-client-common:** a few more patternfly navigation styling issues ([5511c1f](https://github.com/IBM/kui/commit/5511c1f)), closes [#6049](https://github.com/IBM/kui/issues/6049)
- **plugins/plugin-client-common:** active pty output doesn't have repl-context ([6b0929e](https://github.com/IBM/kui/commit/6b0929e)), closes [#5960](https://github.com/IBM/kui/issues/5960)
- **plugins/plugin-client-common:** adjust TopTabStripe for lightweight ui themes ([00ee896](https://github.com/IBM/kui/commit/00ee896)), closes [#6204](https://github.com/IBM/kui/issues/6204)
- **plugins/plugin-client-common:** after Electron 10 update, ls output can render poorly ([1b7010b](https://github.com/IBM/kui/commit/1b7010b)), closes [#6147](https://github.com/IBM/kui/issues/6147)
- **plugins/plugin-client-common:** clicking the editor in carbon accordion will change the accordion label ([ce3fe02](https://github.com/IBM/kui/commit/ce3fe02)), closes [#6107](https://github.com/IBM/kui/issues/6107)
- **plugins/plugin-client-common:** colored squares in status column of tables have odd alignment ([3e78540](https://github.com/IBM/kui/commit/3e78540)), closes [#5766](https://github.com/IBM/kui/issues/5766)
- **plugins/plugin-client-common:** commentary editor can overflow with long lines ([3475287](https://github.com/IBM/kui/commit/3475287)), closes [#5981](https://github.com/IBM/kui/issues/5981)
- **plugins/plugin-client-common:** custom repl-prompt is misaligned with repl-output ([d12b203](https://github.com/IBM/kui/commit/d12b203)), closes [#6046](https://github.com/IBM/kui/issues/6046)
- **plugins/plugin-client-common:** editor doesn't grab focus for edit command ([9870267](https://github.com/IBM/kui/commit/9870267)), closes [#6090](https://github.com/IBM/kui/issues/6090)
- **plugins/plugin-client-common:** enhance minisplit by updating the background color of scrollback and dark card ([fd15c5e](https://github.com/IBM/kui/commit/fd15c5e)), closes [#5989](https://github.com/IBM/kui/issues/5989)
- **plugins/plugin-client-common:** externalize PatternFly TreeView component to SPI ([486a02e](https://github.com/IBM/kui/commit/486a02e)), closes [#6134](https://github.com/IBM/kui/issues/6134)
- **plugins/plugin-client-common:** group the notebooks together in the ls -l table ([1a783f3](https://github.com/IBM/kui/commit/1a783f3)), closes [#5977](https://github.com/IBM/kui/issues/5977)
- **plugins/plugin-client-common:** hovering over error block turns red to blue ([3dbddae](https://github.com/IBM/kui/commit/3dbddae)), closes [#5979](https://github.com/IBM/kui/issues/5979)
- **plugins/plugin-client-common:** If a command is issued in a mini split, the next block (in the mini split) is not focused ([a35e5c2](https://github.com/IBM/kui/commit/a35e5c2)), closes [#6067](https://github.com/IBM/kui/issues/6067)
- **plugins/plugin-client-common:** improve look of `code` snippets in Commentary ([493e004](https://github.com/IBM/kui/commit/493e004)), closes [#5768](https://github.com/IBM/kui/issues/5768)
- **plugins/plugin-client-common:** in dark themes, the inter-split gutter is not visible ([288eeae](https://github.com/IBM/kui/commit/288eeae)), closes [#6022](https://github.com/IBM/kui/issues/6022)
- **plugins/plugin-client-common:** in some cases, Editor may present "you are in edit mode" for readOnly instantiations ([e3e7c16](https://github.com/IBM/kui/commit/e3e7c16)), closes [#6116](https://github.com/IBM/kui/issues/6116)
- **plugins/plugin-client-common:** In some themes, grid inner text color can have low contrast. ([01f8698](https://github.com/IBM/kui/commit/01f8698)), closes [#6032](https://github.com/IBM/kui/issues/6032)
- **plugins/plugin-client-common:** PatternFly assumes a 16px body font size, whereas the rest of Kui assumes 14px ([fa65b57](https://github.com/IBM/kui/commit/fa65b57)), closes [#6041](https://github.com/IBM/kui/issues/6041)
- **plugins/plugin-client-common:** PatternFly LeftNav view has excessive padding ([959d059](https://github.com/IBM/kui/commit/959d059)), closes [#6038](https://github.com/IBM/kui/issues/6038)
- **plugins/plugin-client-common:** RadioTable has small font size ([19f758a](https://github.com/IBM/kui/commit/19f758a)), closes [#6102](https://github.com/IBM/kui/issues/6102)
- **plugins/plugin-client-common:** remove leftover debugging in Scalar/index ([82b8e50](https://github.com/IBM/kui/commit/82b8e50)), closes [#5945](https://github.com/IBM/kui/issues/5945)
- **plugins/plugin-client-common:** removing previous blocks will cause errant rendering to edit command result ([6594e8c](https://github.com/IBM/kui/commit/6594e8c)), closes [#6093](https://github.com/IBM/kui/issues/6093)
- **plugins/plugin-client-common:** sidecar editor too-aggressively focuses ([8077cec](https://github.com/IBM/kui/commit/8077cec)), closes [#6104](https://github.com/IBM/kui/issues/6104)
- **plugins/plugin-client-common:** TabCompletion UI can fail ([cc3fb6d](https://github.com/IBM/kui/commit/cc3fb6d)), closes [#6130](https://github.com/IBM/kui/issues/6130)
- **plugins/plugin-client-common:** TreeView badges have poor contrast in patternfly themes ([8e0db86](https://github.com/IBM/kui/commit/8e0db86)), closes [#6149](https://github.com/IBM/kui/issues/6149)
- **plugins/plugin-client-common:** update spinner to avoid console error messages ([caea507](https://github.com/IBM/kui/commit/caea507)), closes [#6146](https://github.com/IBM/kui/issues/6146)
- A few more themes tweaks are needed ([03be3eb](https://github.com/IBM/kui/commit/03be3eb)), closes [#6034](https://github.com/IBM/kui/issues/6034)
- block focus regressions ([881fa17](https://github.com/IBM/kui/commit/881fa17)), closes [#6072](https://github.com/IBM/kui/issues/6072)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- don't show the `open` command for clicking files in `ls` table ([03ef269](https://github.com/IBM/kui/commit/03ef269)), closes [#5748](https://github.com/IBM/kui/issues/5748)
- for replayed notebooks, don’t show timestamp ([951abc5](https://github.com/IBM/kui/commit/951abc5)), closes [#5763](https://github.com/IBM/kui/issues/5763)
- improve discovery of ibmcloud s3 credentials ([96d5bc0](https://github.com/IBM/kui/commit/96d5bc0)), closes [#5926](https://github.com/IBM/kui/issues/5926)
- improve error reporting from APIs ([edff6f1](https://github.com/IBM/kui/commit/edff6f1)), closes [#5950](https://github.com/IBM/kui/issues/5950)
- preferReExecute is lost when re-saving a notebook ([87c6c6f](https://github.com/IBM/kui/commit/87c6c6f)), closes [#5954](https://github.com/IBM/kui/issues/5954)
- Switching Carbon tabs can cause content to scroll off-viewport ([51a2aad](https://github.com/IBM/kui/commit/51a2aad)), closes [#6014](https://github.com/IBM/kui/issues/6014)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- **plugin-client-common:** RadioTable onSelect changes do not always result in status stripe updates ([3549b7a](https://github.com/IBM/kui/commit/3549b7a)), closes [#5644](https://github.com/IBM/kui/issues/5644)
- **plugin-client-common:** show the last input block in minisplit ([7997ef0](https://github.com/IBM/kui/commit/7997ef0)), closes [#5756](https://github.com/IBM/kui/issues/5756)
- **plugins/plugin-client-common:** "Drilled down to..." text is not aligned with the Input area ([fd139d2](https://github.com/IBM/kui/commit/fd139d2)), closes [#5854](https://github.com/IBM/kui/issues/5854)
- **plugins/plugin-client-common:** a few small refinements to "editing" UI for Inputs ([001236a](https://github.com/IBM/kui/commit/001236a)), closes [#5656](https://github.com/IBM/kui/issues/5656) [#5658](https://github.com/IBM/kui/issues/5658)
- **plugins/plugin-client-common:** Action button hover hysteresis/delay effect not working ([fac75dc](https://github.com/IBM/kui/commit/fac75dc)), closes [#5806](https://github.com/IBM/kui/issues/5806)
- **plugins/plugin-client-common:** blockquotes in commentary don't render well ([9be35fa](https://github.com/IBM/kui/commit/9be35fa)), closes [#5931](https://github.com/IBM/kui/issues/5931)
- **plugins/plugin-client-common:** clicking on table or radio table may cause block to disappear ([1f2d489](https://github.com/IBM/kui/commit/1f2d489)), closes [#5783](https://github.com/IBM/kui/issues/5783)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** ClipboardTransfer emits errors when pasting non-json text ([6ff85c4](https://github.com/IBM/kui/commit/6ff85c4)), closes [#5836](https://github.com/IBM/kui/issues/5836)
- **plugins/plugin-client-common:** Commentary editor can easily overflow when editing in minisplit ([eb14074](https://github.com/IBM/kui/commit/eb14074)), closes [#5675](https://github.com/IBM/kui/issues/5675)
- **plugins/plugin-client-common:** Commentary editor is 5px tall when presented in mini split ([53074d1](https://github.com/IBM/kui/commit/53074d1)), closes [#5744](https://github.com/IBM/kui/issues/5744)
- **plugins/plugin-client-common:** Commentary editor should be full width always ([e0a164a](https://github.com/IBM/kui/commit/e0a164a)), closes [#5688](https://github.com/IBM/kui/issues/5688)
- **plugins/plugin-client-common:** Commentary is always full width ([1920fb9](https://github.com/IBM/kui/commit/1920fb9)), closes [#5705](https://github.com/IBM/kui/issues/5705)
- **plugins/plugin-client-common:** Commentary markdown does not support kuiexec ([4663389](https://github.com/IBM/kui/commit/4663389)), closes [#5911](https://github.com/IBM/kui/issues/5911)
- **plugins/plugin-client-common:** creating a split with a 3-way split configuration results in radical shuffling ([9452b5a](https://github.com/IBM/kui/commit/9452b5a)), closes [#5794](https://github.com/IBM/kui/issues/5794)
- **plugins/plugin-client-common:** disable Timeline option for Tables ([e88ebb3](https://github.com/IBM/kui/commit/e88ebb3)), closes [#5864](https://github.com/IBM/kui/issues/5864)
- **plugins/plugin-client-common:** Do not focus Block when user expands SourceRef ([6642514](https://github.com/IBM/kui/commit/6642514)), closes [#5711](https://github.com/IBM/kui/issues/5711)
- **plugins/plugin-client-common:** do not show the command rerun and remove button for offline kui ([309162f](https://github.com/IBM/kui/commit/309162f)), closes [#5917](https://github.com/IBM/kui/issues/5917)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** don't show `isTabLayoutModificationResponse` and PresentedElseWhere response in MiniSplit ([a16767a](https://github.com/IBM/kui/commit/a16767a)), closes [#5690](https://github.com/IBM/kui/issues/5690)
- **plugins/plugin-client-common:** double clicking on Commentary in minisplit often has the editor completely off screen ([c3504a0](https://github.com/IBM/kui/commit/c3504a0)), closes [#5897](https://github.com/IBM/kui/issues/5897)
- **plugins/plugin-client-common:** Editing Commentary should require double click ([efaded3](https://github.com/IBM/kui/commit/efaded3)), closes [#5686](https://github.com/IBM/kui/issues/5686)
- **plugins/plugin-client-common:** empty blocks have excessive height ([12c39b0](https://github.com/IBM/kui/commit/12c39b0)), closes [#5707](https://github.com/IBM/kui/issues/5707)
- **plugins/plugin-client-common:** empty pty response yields blank line ([711bd05](https://github.com/IBM/kui/commit/711bd05)), closes [#5928](https://github.com/IBM/kui/issues/5928)
- **plugins/plugin-client-common:** error blocks are not indented properly ([d137614](https://github.com/IBM/kui/commit/d137614)), closes [#5938](https://github.com/IBM/kui/issues/5938)
- add Kui version and github link to client-notebook ([7b2562a](https://github.com/IBM/kui/commit/7b2562a)), closes [#5918](https://github.com/IBM/kui/issues/5918)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- **plugins/plugin-client-common:** CodeSnippet component renders with zero contrast in dark themes ([10e40a9](https://github.com/IBM/kui/commit/10e40a9)), closes [#5886](https://github.com/IBM/kui/issues/5886)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([3400431](https://github.com/IBM/kui/commit/3400431)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([f93fe2b](https://github.com/IBM/kui/commit/f93fe2b)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** deleting and re-creating a split results double commands ([dde6eaa](https://github.com/IBM/kui/commit/dde6eaa)), closes [#5876](https://github.com/IBM/kui/issues/5876)
- **plugins/plugin-client-common:** don't decorate code elements in top tab ([531e8b8](https://github.com/IBM/kui/commit/531e8b8)), closes [#5778](https://github.com/IBM/kui/issues/5778)
- **plugins/plugin-client-common:** double whitespace may be removed from completed inputs ([fc0c0db](https://github.com/IBM/kui/commit/fc0c0db)), closes [#6279](https://github.com/IBM/kui/issues/6279)
- **plugins/plugin-client-common:** editing commentary gives a one-line monaco ([5f14268](https://github.com/IBM/kui/commit/5f14268)), closes [#5874](https://github.com/IBM/kui/issues/5874)
- **plugins/plugin-client-common:** events in tree should stay scrolled to the bottom as events come in ([c5efedd](https://github.com/IBM/kui/commit/c5efedd)), closes [#6164](https://github.com/IBM/kui/issues/6164)
- **plugins/plugin-client-common:** Experimental badge too tall for lightweight UI themes. ([57b1f51](https://github.com/IBM/kui/commit/57b1f51)), closes [#6284](https://github.com/IBM/kui/issues/6284)
- **plugins/plugin-client-common:** focus a block upon moving or pasting it ([43c3d9a](https://github.com/IBM/kui/commit/43c3d9a)), closes [#5751](https://github.com/IBM/kui/issues/5751)
- **plugins/plugin-client-common:** font size issues with lightweight ui in tree view ([575ced0](https://github.com/IBM/kui/commit/575ced0)), closes [#6228](https://github.com/IBM/kui/issues/6228) [#6229](https://github.com/IBM/kui/issues/6229)
- **plugins/plugin-client-common:** for lightweight ui themes, also show block duration in highlight color ([da3a3a7](https://github.com/IBM/kui/commit/da3a3a7)), closes [#6222](https://github.com/IBM/kui/issues/6222)
- **plugins/plugin-client-common:** height of TreeView events should match that of sidecar header ([bba1ccd](https://github.com/IBM/kui/commit/bba1ccd)), closes [#6174](https://github.com/IBM/kui/issues/6174)
- **plugins/plugin-client-common:** improved focus behavior of terminals ([f5a3dd0](https://github.com/IBM/kui/commit/f5a3dd0)), closes [#5615](https://github.com/IBM/kui/issues/5615)
- **plugins/plugin-client-common:** in carbon-based dark themes, the SourceRef expando text is not visible ([0b462f5](https://github.com/IBM/kui/commit/0b462f5)), closes [#6197](https://github.com/IBM/kui/issues/6197)
- **plugins/plugin-client-common:** in lightweight presentation mode, lighten up sidecar a bit ([c73c080](https://github.com/IBM/kui/commit/c73c080)), closes [#6202](https://github.com/IBM/kui/issues/6202) [#6201](https://github.com/IBM/kui/issues/6201)
- **plugins/plugin-client-common:** in lightweight themes, hover on sequence diagram rows may result in errant border-top ([679498f](https://github.com/IBM/kui/commit/679498f)), closes [#6251](https://github.com/IBM/kui/issues/6251)
- **plugins/plugin-client-common:** in lightweight ui themes, markdown content has odd font spacing ([b114221](https://github.com/IBM/kui/commit/b114221)), closes [#6249](https://github.com/IBM/kui/issues/6249)
- **plugins/plugin-client-common:** increase contrast of unfocused left-stripes for blocks ([ab21295](https://github.com/IBM/kui/commit/ab21295)), closes [#5754](https://github.com/IBM/kui/issues/5754)
- **plugins/plugin-client-common:** inline sidecar should not have a min-width ([11a0cfb](https://github.com/IBM/kui/commit/11a0cfb)), closes [#6270](https://github.com/IBM/kui/issues/6270)
- **plugins/plugin-client-common:** input element is not distinct enough in lightweight ui themes with splits ([01b3e40](https://github.com/IBM/kui/commit/01b3e40)), closes [#6247](https://github.com/IBM/kui/issues/6247)
- **plugins/plugin-client-common:** input probably needs to word-wrap while in minisplits ([cde272d](https://github.com/IBM/kui/commit/cde272d)), closes [#5696](https://github.com/IBM/kui/issues/5696)
- **plugins/plugin-client-common:** input spinner is not visible in minisplits ([76eec59](https://github.com/IBM/kui/commit/76eec59)), closes [#5684](https://github.com/IBM/kui/issues/5684)
- **plugins/plugin-client-common:** Input timestamp should also hide when block is focused ([6e1ca6d](https://github.com/IBM/kui/commit/6e1ca6d)), closes [#5809](https://github.com/IBM/kui/issues/5809)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** linux can show unneeded scrollbars in tables ([4d49a23](https://github.com/IBM/kui/commit/4d49a23)), closes [#5884](https://github.com/IBM/kui/issues/5884)
- **plugins/plugin-client-common:** Lots of little layout issues, e.g. SimpleEditor is not fully width in minisplits ([5a9a1c6](https://github.com/IBM/kui/commit/5a9a1c6)), closes [#5679](https://github.com/IBM/kui/issues/5679) [#5680](https://github.com/IBM/kui/issues/5680)
- **plugins/plugin-client-common:** ls ; ls has excessive vertical whitespace ([1b41c59](https://github.com/IBM/kui/commit/1b41c59)), closes [#6291](https://github.com/IBM/kui/issues/6291)
- **plugins/plugin-client-common:** markdown code has incorrect color in a split with inverse color ([c8c10af](https://github.com/IBM/kui/commit/c8c10af)), closes [#5902](https://github.com/IBM/kui/issues/5902)
- **plugins/plugin-client-common:** markdown inline code in table cells shows with scrollbars on linux and windows ([1ff88b9](https://github.com/IBM/kui/commit/1ff88b9)), closes [#5890](https://github.com/IBM/kui/issues/5890)
- **plugins/plugin-client-common:** markdown with <a> inside <h1> renders with odd font size ([b5e3007](https://github.com/IBM/kui/commit/b5e3007)), closes [#5724](https://github.com/IBM/kui/issues/5724)
- **plugins/plugin-client-common:** monaco highlight color used by SourceRef has low contrast ([385f35e](https://github.com/IBM/kui/commit/385f35e)), closes [#5713](https://github.com/IBM/kui/issues/5713)
- **plugins/plugin-client-common:** never show "ok" ([d1b337a](https://github.com/IBM/kui/commit/d1b337a)), closes [#5697](https://github.com/IBM/kui/issues/5697)
- **plugins/plugin-client-common:** on switching tabs, active prompt isn't always focused ([5b28dd2](https://github.com/IBM/kui/commit/5b28dd2)), closes [#5637](https://github.com/IBM/kui/issues/5637)
- **plugins/plugin-client-common:** Output-only blocks probably don't need a re-execute button ([251a81c](https://github.com/IBM/kui/commit/251a81c)), closes [#5662](https://github.com/IBM/kui/issues/5662)
- **plugins/plugin-client-common:** Popup mode input stripe does not have reliable auto-focus behavior ([ac3935e](https://github.com/IBM/kui/commit/ac3935e)), closes [#6266](https://github.com/IBM/kui/issues/6266)
- **plugins/plugin-client-common:** presented elsewhere text is not vertically centered in block ([766d355](https://github.com/IBM/kui/commit/766d355)), closes [#5760](https://github.com/IBM/kui/issues/5760)
- **plugins/plugin-client-common:** prompt focus may not be restored when switching tabs ([5e81db9](https://github.com/IBM/kui/commit/5e81db9)), closes [#6239](https://github.com/IBM/kui/issues/6239)
- **plugins/plugin-client-common:** RadioTable should scroll the selected row into view on render ([6eb45db](https://github.com/IBM/kui/commit/6eb45db)), closes [#5781](https://github.com/IBM/kui/issues/5781)
- **plugins/plugin-client-common:** re-snapshoting a notebook can fail ([4caff9c](https://github.com/IBM/kui/commit/4caff9c)), closes [#5736](https://github.com/IBM/kui/issues/5736)
- **plugins/plugin-client-common:** refine input UI for lightweight ui themes ([c479cdb](https://github.com/IBM/kui/commit/c479cdb)), closes [#6296](https://github.com/IBM/kui/issues/6296)
- **plugins/plugin-client-common:** remove active prompts in an offline notebook ([dd2b53f](https://github.com/IBM/kui/commit/dd2b53f)), closes [#5620](https://github.com/IBM/kui/issues/5620)
- **plugins/plugin-client-common:** remove clicks from NotebookImpl ([45f0be5](https://github.com/IBM/kui/commit/45f0be5)), closes [#5856](https://github.com/IBM/kui/issues/5856)
- **plugins/plugin-client-common:** rendering of blockquotes in markdown is inconsistent ([edcc8d1](https://github.com/IBM/kui/commit/edcc8d1)), closes [#6043](https://github.com/IBM/kui/issues/6043)
- **plugins/plugin-client-common:** restore hiding of In[1] in minisplit ([8d5c93f](https://github.com/IBM/kui/commit/8d5c93f)), closes [#5985](https://github.com/IBM/kui/issues/5985)
- **plugins/plugin-client-common:** saving a snapshot can fail with "cannot read property uuid of undefined" ([85fe1f3](https://github.com/IBM/kui/commit/85fe1f3)), closes [#5913](https://github.com/IBM/kui/issues/5913)
- **plugins/plugin-client-common:** selecting text in prior Input causes selection to be lost and Input to enter edit mode ([4d977d2](https://github.com/IBM/kui/commit/4d977d2)), closes [#5792](https://github.com/IBM/kui/issues/5792)
- **plugins/plugin-client-common:** sidecar markdown code snippet has poor color ([765f166](https://github.com/IBM/kui/commit/765f166)), closes [#5995](https://github.com/IBM/kui/issues/5995)
- **plugins/plugin-client-common:** some small tweaks to Commentary headers would help ([b012f8d](https://github.com/IBM/kui/commit/b012f8d)), closes [#5893](https://github.com/IBM/kui/issues/5893)
- **plugins/plugin-client-common:** sorting widgets in table header are wrapping ([e3520dc](https://github.com/IBM/kui/commit/e3520dc)), closes [#5976](https://github.com/IBM/kui/issues/5976)
- **plugins/plugin-client-common:** SourceRef viewer should hide liner numbers but show folding ([5f74a46](https://github.com/IBM/kui/commit/5f74a46)), closes [#5719](https://github.com/IBM/kui/issues/5719)
- **plugins/plugin-client-common:** status stripe "blue" color probably needs to be toned done ([137442f](https://github.com/IBM/kui/commit/137442f)), closes [#5772](https://github.com/IBM/kui/issues/5772)
- **plugins/plugin-client-common:** tab switching can be slow on windows ([09f9b7d](https://github.com/IBM/kui/commit/09f9b7d)), closes [#5907](https://github.com/IBM/kui/issues/5907)
- **plugins/plugin-client-common:** table cells with no onclick handler still issue a kui command ([4d8bf37](https://github.com/IBM/kui/commit/4d8bf37)), closes [#5721](https://github.com/IBM/kui/issues/5721)
- **plugins/plugin-client-common:** table is misaligned with command input ([50dc430](https://github.com/IBM/kui/commit/50dc430)), closes [#5734](https://github.com/IBM/kui/issues/5734)
- **plugins/plugin-client-common:** the alert showing lost connection has incorrect height ([1758758](https://github.com/IBM/kui/commit/1758758)), closes [#5905](https://github.com/IBM/kui/issues/5905)
- **plugins/plugin-client-common:** there is still too much whitespace after no-response commands ([268f159](https://github.com/IBM/kui/commit/268f159)), closes [#5742](https://github.com/IBM/kui/issues/5742)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-client-common:** welcome.json could use some wordsmithing ([e373ab4](https://github.com/IBM/kui/commit/e373ab4)), closes [#5895](https://github.com/IBM/kui/issues/5895)
- **plugins/plugin-client-common:** when replaying notebooks, tab should be scrolled to top ([6567412](https://github.com/IBM/kui/commit/6567412)), closes [#5860](https://github.com/IBM/kui/issues/5860)
- **plugins/plugin-client-common:** width-constrained NavResponse UI should spend more space on content ([309c6ff](https://github.com/IBM/kui/commit/309c6ff)), closes [#6742](https://github.com/IBM/kui/issues/6742)
- **plugins/plugin-client-common): regression validateDOMNesting(...:** <pre> cannot appear as a descendant of <p> ([1a2cccf](https://github.com/IBM/kui/commit/1a2cccf)), closes [#5900](https://github.com/IBM/kui/issues/5900)
- **plugins/plugin-kubectl:** events watching returns an empty table with just a streaming events footer ([fbeae76](https://github.com/IBM/kui/commit/fbeae76)), closes [#2771](https://github.com/IBM/kui/issues/2771)
- **plugins/plugin-kubectl:** show SourceRef when creating heterogeneous resources ([adb21c5](https://github.com/IBM/kui/commit/adb21c5)), closes [#6640](https://github.com/IBM/kui/issues/6640)
- **plugins/plugins-client-common:** Carbon Accordion spi should have more contrast ([c0de84d](https://github.com/IBM/kui/commit/c0de84d)), closes [#6111](https://github.com/IBM/kui/issues/6111)
- "created split" message should disappear when corresponding split is closed ([f8486f8](https://github.com/IBM/kui/commit/f8486f8)), closes [#5629](https://github.com/IBM/kui/issues/5629)
- @patternfly/react-core breaks the indentation of TreeView ([f5c5253](https://github.com/IBM/kui/commit/f5c5253)), closes [#6224](https://github.com/IBM/kui/issues/6224)
- block timestamp in Light theme/lightweight ui has low contrast ([6ae08fd](https://github.com/IBM/kui/commit/6ae08fd)), closes [#6226](https://github.com/IBM/kui/issues/6226)
- blocks can still disappear if table row is clicked while the enclosing block is focused ([2173af1](https://github.com/IBM/kui/commit/2173af1)), closes [#5814](https://github.com/IBM/kui/issues/5814)
- ctrl+L in the first block makes the prompt inactive ([232e5e1](https://github.com/IBM/kui/commit/232e5e1)), closes [#6597](https://github.com/IBM/kui/issues/6597)
- default chart colors should not use blue-red diverging spectrum ([918ab9c](https://github.com/IBM/kui/commit/918ab9c)), closes [#6191](https://github.com/IBM/kui/issues/6191)
- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- In narrower windows, there is too much content in the StatusStripe ([453bc86](https://github.com/IBM/kui/commit/453bc86)), closes [#6570](https://github.com/IBM/kui/issues/6570)
- keyboard history navigation does not work in Popup clients ([89197ba](https://github.com/IBM/kui/commit/89197ba)), closes [#6262](https://github.com/IBM/kui/issues/6262)
- kubectl get -f --watch doesn't watch ([e45e8ee](https://github.com/IBM/kui/commit/e45e8ee)), closes [#6588](https://github.com/IBM/kui/issues/6588)
- kubectl kustomize can have bogus output ([8bf8ebe](https://github.com/IBM/kui/commit/8bf8ebe)), closes [#6114](https://github.com/IBM/kui/issues/6114)
- ls clicks that do another ls should not open a split ([fc0873b](https://github.com/IBM/kui/commit/fc0873b)), closes [#6565](https://github.com/IBM/kui/issues/6565)
- ls comand is not snapshotable ([f04ca78](https://github.com/IBM/kui/commit/f04ca78)), closes [#5241](https://github.com/IBM/kui/issues/5241)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- Notebook title "Kui Setting" should be "Kui Settings" ([b14b130](https://github.com/IBM/kui/commit/b14b130)), closes [#5870](https://github.com/IBM/kui/issues/5870)
- RadioTable should have option to not echo the onSelect command ([77d5050](https://github.com/IBM/kui/commit/77d5050)), closes [#5991](https://github.com/IBM/kui/issues/5991)
- **plugins/plugin-client-common:** update the commentary in settings notebook to store the texts as command ([bbb8f6d](https://github.com/IBM/kui/commit/bbb8f6d)), closes [#5992](https://github.com/IBM/kui/issues/5992)
- re-saving a notebook via File/Save application menu does not preserve notebook title ([7fb8b43](https://github.com/IBM/kui/commit/7fb8b43)), closes [#5777](https://github.com/IBM/kui/issues/5777)
- remove up/down actions buttons ([3c8a8a1](https://github.com/IBM/kui/commit/3c8a8a1)), closes [#5774](https://github.com/IBM/kui/issues/5774)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-client-common:** StatusStripe widgets can emit react error when switching to notebook tab ([485fcdf](https://github.com/IBM/kui/commit/485fcdf)), closes [#5639](https://github.com/IBM/kui/issues/5639)
- **plugins/plugin-client-common:** while editing Commentary, adding ``` causes a bad error ([097b1b0](https://github.com/IBM/kui/commit/097b1b0)), closes [#5682](https://github.com/IBM/kui/issues/5682)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- new tab command can hang if title is provided ([a6c25c6](https://github.com/IBM/kui/commit/a6c25c6)), closes [#5624](https://github.com/IBM/kui/issues/5624)
- output only Actions should also render on hover ([cdbd105](https://github.com/IBM/kui/commit/cdbd105)), closes [#5652](https://github.com/IBM/kui/issues/5652)
- PatternFly 2012.14 breaks the indentation of TreeView ([f052d71](https://github.com/IBM/kui/commit/f052d71)), closes [#6224](https://github.com/IBM/kui/issues/6224)
- tab new command should respond with ElsewhereCommentary response ([19a7e1d](https://github.com/IBM/kui/commit/19a7e1d)), closes [#5602](https://github.com/IBM/kui/issues/5602)
- **plugins/plugin-client-common:** Whem moving blocks, the moved block is not longer focused after the move ([fc13198](https://github.com/IBM/kui/commit/fc13198)), closes [#5612](https://github.com/IBM/kui/issues/5612)
- **plugins/plugin-client-common:** always place table events in the Card footer ([b667b28](https://github.com/IBM/kui/commit/b667b28)), closes [#5210](https://github.com/IBM/kui/issues/5210)
- **plugins/plugin-client-common:** buggy header UI in dark themes in minisplits ([55aef48](https://github.com/IBM/kui/commit/55aef48)), closes [#5266](https://github.com/IBM/kui/issues/5266)
- **plugins/plugin-client-common:** clicking on pod delete button can cause command to be executed in minisplit ([37f9019](https://github.com/IBM/kui/commit/37f9019)), closes [#5247](https://github.com/IBM/kui/issues/5247)
- **plugins/plugin-client-common:** clicking to focus on a split does not always cause full focus effect ([bc59bcf](https://github.com/IBM/kui/commit/bc59bcf)), closes [#5263](https://github.com/IBM/kui/issues/5263)
- **plugins/plugin-client-common:** close tabs doesn't produce the correct tab content ([6090887](https://github.com/IBM/kui/commit/6090887)), closes [#5220](https://github.com/IBM/kui/issues/5220)
- **plugins/plugin-client-common:** CSS no longer is reactive to narrow window ([4eb0a11](https://github.com/IBM/kui/commit/4eb0a11)), closes [#5290](https://github.com/IBM/kui/issues/5290)
- **plugins/plugin-client-common:** don't line-wrap input elements in MiniSplits ([c929f5e](https://github.com/IBM/kui/commit/c929f5e)), closes [#5348](https://github.com/IBM/kui/issues/5348)
- **plugins/plugin-client-common:** don't use fixed maxHeight for Terminal tables ([0e23e22](https://github.com/IBM/kui/commit/0e23e22)), closes [#5206](https://github.com/IBM/kui/issues/5206)
- **plugins/plugin-client-common:** Events drilldown from watch table does not always work ([09aee73](https://github.com/IBM/kui/commit/09aee73)), closes [#5204](https://github.com/IBM/kui/issues/5204)
- **plugins/plugin-client-common:** experiment tag has wrong color contrast in dark themes ([22bfb77](https://github.com/IBM/kui/commit/22bfb77)), closes [#5389](https://github.com/IBM/kui/issues/5389)
- **plugins/plugin-client-common:** Experimental badge should take up less space in minisplits ([268aeb3](https://github.com/IBM/kui/commit/268aeb3)), closes [#5373](https://github.com/IBM/kui/issues/5373)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve behavior of up arrow for first command in MiniSplits ([ed199d4](https://github.com/IBM/kui/commit/ed199d4)), closes [#5297](https://github.com/IBM/kui/issues/5297)
- **plugins/plugin-client-common:** improve display of tables in side-by-side terminal splits ([5a32255](https://github.com/IBM/kui/commit/5a32255)), closes [#5201](https://github.com/IBM/kui/issues/5201)
- **plugins/plugin-client-common:** in plain Terminals, tables should not inner scroll ([15fcbba](https://github.com/IBM/kui/commit/15fcbba)), closes [#5221](https://github.com/IBM/kui/issues/5221)
- **plugins/plugin-client-common:** inconsistent top padding above Cards ([1e1037f](https://github.com/IBM/kui/commit/1e1037f)), closes [#5299](https://github.com/IBM/kui/issues/5299)
- **plugins/plugin-client-common:** increase density of SequenceDiagram ([ae29488](https://github.com/IBM/kui/commit/ae29488)), closes [#5344](https://github.com/IBM/kui/issues/5344)
- **plugins/plugin-client-common:** long input lines should line wrap ([8804bb1](https://github.com/IBM/kui/commit/8804bb1)), closes [#5338](https://github.com/IBM/kui/issues/5338)
- **plugins/plugin-client-common:** minor improvements for ls -l output ([1b59c94](https://github.com/IBM/kui/commit/1b59c94)), closes [#5216](https://github.com/IBM/kui/issues/5216)
- **plugins/plugin-client-common:** multi-line paste executes commands out of order ([8f39c80](https://github.com/IBM/kui/commit/8f39c80)), closes [#5295](https://github.com/IBM/kui/issues/5295)
- **plugins/plugin-client-common:** only highlight the Active block in the focused split ([feffad4](https://github.com/IBM/kui/commit/feffad4)), closes [#5261](https://github.com/IBM/kui/issues/5261)
- **plugins/plugin-client-common:** present more than 2 footer lines in watch tables ([3e7a78f](https://github.com/IBM/kui/commit/3e7a78f)), closes [#5213](https://github.com/IBM/kui/issues/5213)
- **plugins/plugin-client-common:** pty commands fail in minisplits ([475ea74](https://github.com/IBM/kui/commit/475ea74)), closes [#5267](https://github.com/IBM/kui/issues/5267)
- **plugins/plugin-client-common:** reduce contrast of block left bars ([7c8d371](https://github.com/IBM/kui/commit/7c8d371)), closes [#5275](https://github.com/IBM/kui/issues/5275)
- **plugins/plugin-client-common:** refine Timeline a bit more ([4b12eec](https://github.com/IBM/kui/commit/4b12eec)), closes [#5409](https://github.com/IBM/kui/issues/5409)
- **plugins/plugin-client-common:** restore history navigation behavior in minisplits ([26f49e8](https://github.com/IBM/kui/commit/26f49e8)), closes [#5375](https://github.com/IBM/kui/issues/5375)
- **plugins/plugin-client-common:** reverse-i-search incorrectly changes match as i type ([135d429](https://github.com/IBM/kui/commit/135d429)), closes [#5403](https://github.com/IBM/kui/issues/5403)
- **plugins/plugin-client-common:** status column can be invisible in split tables ([c352103](https://github.com/IBM/kui/commit/c352103)), closes [#5244](https://github.com/IBM/kui/issues/5244)
- **plugins/plugin-client-common:** tab completion UI does not render on separate line from input ([61b169b](https://github.com/IBM/kui/commit/61b169b)), closes [#5307](https://github.com/IBM/kui/issues/5307)
- **plugins/plugin-client-common:** table screenshots include a gray stripe at the top ([11a9fc3](https://github.com/IBM/kui/commit/11a9fc3)), closes [#5410](https://github.com/IBM/kui/issues/5410)
- **plugins/plugin-client-common:** TableCell view can fail when given empty duration cells ([04251be](https://github.com/IBM/kui/commit/04251be)), closes [#5332](https://github.com/IBM/kui/issues/5332)
- **plugins/plugin-client-common:** Timeline may not render properly ([d66d728](https://github.com/IBM/kui/commit/d66d728)), closes [#5383](https://github.com/IBM/kui/issues/5383)
- **plugins/plugin-client-common:** Timeline should use stdev-based heat map ([5dd7427](https://github.com/IBM/kui/commit/5dd7427)), closes [#5395](https://github.com/IBM/kui/issues/5395)
- **plugins/plugin-client-common:** Timeline tooltip for cold starts has incorrect concurrency count ([bb54cb8](https://github.com/IBM/kui/commit/bb54cb8)), closes [#5390](https://github.com/IBM/kui/issues/5390)
- **plugins/plugin-client-common:** Timeline view renders poorly in MiniSplit ([07cd000](https://github.com/IBM/kui/commit/07cd000)), closes [#5379](https://github.com/IBM/kui/issues/5379)
- Editor component does not respond to tab layout changes ([9756336](https://github.com/IBM/kui/commit/9756336)), closes [#5231](https://github.com/IBM/kui/issues/5231) [#5232](https://github.com/IBM/kui/issues/5232)
- multiple command history regressions ([cbba96c](https://github.com/IBM/kui/commit/cbba96c)), closes [#5283](https://github.com/IBM/kui/issues/5283)
- switching splits does not participate in tab state ([6eb8db4](https://github.com/IBM/kui/commit/6eb8db4)), closes [#5272](https://github.com/IBM/kui/issues/5272)
- **plugins/plugin-client-common:** "No resources" in watch pane can occlude watch pane title ([e4fd93a](https://github.com/IBM/kui/commit/e4fd93a)), closes [#5064](https://github.com/IBM/kui/issues/5064)
- **plugins/plugin-client-common:** `ok` string appears at the end of MixResponse ([75606c5](https://github.com/IBM/kui/commit/75606c5)), closes [#5046](https://github.com/IBM/kui/issues/5046)
- **plugins/plugin-client-common:** a few more rem/em font-size issues ([133b347](https://github.com/IBM/kui/commit/133b347)), closes [#5058](https://github.com/IBM/kui/issues/5058)
- **plugins/plugin-client-common:** borders in top tab stripe are too light ([3908695](https://github.com/IBM/kui/commit/3908695)), closes [#5051](https://github.com/IBM/kui/issues/5051)
- **plugins/plugin-client-common:** clearing Terminal does not abort watchers ([34adb50](https://github.com/IBM/kui/commit/34adb50)), closes [#5116](https://github.com/IBM/kui/issues/5116)
- **plugins/plugin-client-common:** clicking 'remove' of a watchable response doesn't abort the underlying pty job ([7eb69fb](https://github.com/IBM/kui/commit/7eb69fb)), closes [#5090](https://github.com/IBM/kui/issues/5090)
- **plugins/plugin-client-common:** decrease height of table footer ([5863622](https://github.com/IBM/kui/commit/5863622)), closes [#5072](https://github.com/IBM/kui/issues/5072)
- **plugins/plugin-client-common:** disableTableTitle also disables title of watch panes ([053cfb6](https://github.com/IBM/kui/commit/053cfb6)), closes [#5036](https://github.com/IBM/kui/issues/5036)
- **plugins/plugin-client-common:** double watch panes may open up ([7fb70f1](https://github.com/IBM/kui/commit/7fb70f1)), closes [#5034](https://github.com/IBM/kui/issues/5034)
- **plugins/plugin-client-common:** editor component does not respond to font zooming ([7b7e0f3](https://github.com/IBM/kui/commit/7b7e0f3)), closes [#5120](https://github.com/IBM/kui/issues/5120)
- **plugins/plugin-client-common:** eliminate react "titleInHeader" console warnings ([8cf3797](https://github.com/IBM/kui/commit/8cf3797)), closes [#5078](https://github.com/IBM/kui/issues/5078)
- **plugins/plugin-client-common:** Events footer in minisplit tables lacks horizontal padding ([f22b1f7](https://github.com/IBM/kui/commit/f22b1f7)), closes [#5196](https://github.com/IBM/kui/issues/5196)
- **plugins/plugin-client-common:** Events should also be placed in table footer (not tbody) when sidecar is open or 2-way terminal split ([1391b1d](https://github.com/IBM/kui/commit/1391b1d)), closes [#5198](https://github.com/IBM/kui/issues/5198)
- **plugins/plugin-client-common:** font size issues with LeftNavSidecar ([e17fc15](https://github.com/IBM/kui/commit/e17fc15)), closes [#5048](https://github.com/IBM/kui/issues/5048)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** improve spacing of Event footer content ([d63a6f1](https://github.com/IBM/kui/commit/d63a6f1)), closes [#5178](https://github.com/IBM/kui/issues/5178)
- **plugins/plugin-client-common:** improve top tab bottom UI ([8ff4151](https://github.com/IBM/kui/commit/8ff4151)), closes [#5056](https://github.com/IBM/kui/issues/5056)
- **plugins/plugin-client-common:** input may not receive focus on tab switch ([7676792](https://github.com/IBM/kui/commit/7676792)), closes [#5102](https://github.com/IBM/kui/issues/5102)
- **plugins/plugin-client-common:** layout regressions from table screenshot PRs ([8004ee3](https://github.com/IBM/kui/commit/8004ee3)), closes [#5159](https://github.com/IBM/kui/issues/5159)
- **plugins/plugin-client-common:** leftover debug printfs in table sorting ([9889b49](https://github.com/IBM/kui/commit/9889b49)), closes [#5030](https://github.com/IBM/kui/issues/5030)
- **plugins/plugin-client-common:** Light tables should use Carbon compact ([2309ec3](https://github.com/IBM/kui/commit/2309ec3)), closes [#5059](https://github.com/IBM/kui/issues/5059)
- **plugins/plugin-client-common:** one-row tables needn't offer column sorting UI ([5184fa1](https://github.com/IBM/kui/commit/5184fa1)), closes [#5050](https://github.com/IBM/kui/issues/5050)
- **plugins/plugin-client-common:** place event footer outside of table scroll region for minisplits ([e4872b2](https://github.com/IBM/kui/commit/e4872b2)), closes [#5179](https://github.com/IBM/kui/issues/5179)
- **plugins/plugin-client-common:** RadioTable screenshots lack box shadow ([b0e0f2e](https://github.com/IBM/kui/commit/b0e0f2e)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** RadioTables can have gratuituous line wrapping ([9c39682](https://github.com/IBM/kui/commit/9c39682)), closes [#5139](https://github.com/IBM/kui/issues/5139)
- **plugins/plugin-client-common:** RadioTables in minisplits inner-scroll away the header row ([5296dcd](https://github.com/IBM/kui/commit/5296dcd)), closes [#5165](https://github.com/IBM/kui/issues/5165)
- **plugins/plugin-client-common:** regression in table width with sidecar open ([5938806](https://github.com/IBM/kui/commit/5938806)), closes [#5194](https://github.com/IBM/kui/issues/5194)
- **plugins/plugin-client-common:** selected row in RadioTables in dark themes has low contrast ([f2c5834](https://github.com/IBM/kui/commit/f2c5834)), closes [#5161](https://github.com/IBM/kui/issues/5161)
- **plugins/plugin-client-common:** sidecar badges may not be flush-right ([5b54665](https://github.com/IBM/kui/commit/5b54665)), closes [#5175](https://github.com/IBM/kui/issues/5175)
- **plugins/plugin-client-common:** Tables should have a max-height and use inner scrolling for overflow ([642ef14](https://github.com/IBM/kui/commit/642ef14)), closes [#5153](https://github.com/IBM/kui/issues/5153)
- **plugins/plugin-client-common:** Tables with identical column names render incorrectly ([161dba2](https://github.com/IBM/kui/commit/161dba2)), closes [#5129](https://github.com/IBM/kui/issues/5129)
- **plugins/plugin-client-common:** Terminal Block -> Screenshot of table does not capture box shadow ([ed812f3](https://github.com/IBM/kui/commit/ed812f3)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** Terminal focus changes unexpectedly ([866451c](https://github.com/IBM/kui/commit/866451c)), closes [#5170](https://github.com/IBM/kui/issues/5170)
- **plugins/plugin-client-common:** two MiniSplits with open sidecar are too short ([9e21ab9](https://github.com/IBM/kui/commit/9e21ab9)), closes [#5171](https://github.com/IBM/kui/issues/5171)
- **plugins/plugin-client-common:** watch pane grid cells too large ([225f937](https://github.com/IBM/kui/commit/225f937)), closes [#5070](https://github.com/IBM/kui/issues/5070)
- **plugins/plugin-client-common:** watch tables might not be maximized in minisplits ([63420b2](https://github.com/IBM/kui/commit/63420b2)), closes [#5218](https://github.com/IBM/kui/issues/5218)
- **plugins/plugin-client-commong:** show RadioTable selected row in the table body and header breadcrumb ([811c21e](https://github.com/IBM/kui/commit/811c21e)), closes [#5239](https://github.com/IBM/kui/issues/5239)
- **plugins/plugin-client-default:** improve debug logging of client properties ([4daba1f](https://github.com/IBM/kui/commit/4daba1f)), closes [#5088](https://github.com/IBM/kui/issues/5088)
- **plugins/plugin-core-support:** sidecar "window" buttons are too large ([33415d2](https://github.com/IBM/kui/commit/33415d2)), closes [#5094](https://github.com/IBM/kui/issues/5094)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- move default loadingDone icon into plugin-client-common ([39994bc](https://github.com/IBM/kui/commit/39994bc)), closes [#5026](https://github.com/IBM/kui/issues/5026)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- still see name-related breadcrumbs and short-name header with feature flag sidecarName 'heroText' ([1a8be9f](https://github.com/IBM/kui/commit/1a8be9f)), closes [#5013](https://github.com/IBM/kui/issues/5013)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- **plugins/plugin-client-common:** WatchPane has incorrect padding ([e74bd7b](https://github.com/IBM/kui/commit/e74bd7b)), closes [#5015](https://github.com/IBM/kui/issues/5015)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- Card component does not render well in dark themes ([d96def0](https://github.com/IBM/kui/commit/d96def0)), closes [#4996](https://github.com/IBM/kui/issues/4996)
- clients should be able to enable watcher auto pinning without enabling splitTerminals ([bcade13](https://github.com/IBM/kui/commit/bcade13)), closes [#5002](https://github.com/IBM/kui/issues/5002)
- Confirm dialog color contrast issues ([da14c25](https://github.com/IBM/kui/commit/da14c25)), closes [#4995](https://github.com/IBM/kui/issues/4995)
- increase contrast in watch pane ([246ecd2](https://github.com/IBM/kui/commit/246ecd2)), closes [#5000](https://github.com/IBM/kui/issues/5000) [#5001](https://github.com/IBM/kui/issues/5001)
- move patternfly alignment out of patternfly themes plugin ([6adbfd6](https://github.com/IBM/kui/commit/6adbfd6)), closes [#4988](https://github.com/IBM/kui/issues/4988)
- **plugins/plugin-client-common:** add error icon for error blocks ([5d9aeea](https://github.com/IBM/kui/commit/5d9aeea)), closes [#4907](https://github.com/IBM/kui/issues/4907)
- **plugins/plugin-client-common:** carbon breadcrumbs may not have proper hover effect ([c8cd2d1](https://github.com/IBM/kui/commit/c8cd2d1)), closes [#4962](https://github.com/IBM/kui/issues/4962)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** clicking the remove button of a repl block results in an error white screen ([49bfbcc](https://github.com/IBM/kui/commit/49bfbcc)), closes [#4855](https://github.com/IBM/kui/issues/4855)
- **plugins/plugin-client-common:** improve Terminal screenshots by adding padding ([a9b7b26](https://github.com/IBM/kui/commit/a9b7b26)), closes [#4981](https://github.com/IBM/kui/issues/4981)
- **plugins/plugin-client-common:** in Popup mode, use > rather than / for prompt in bottom input ([1360bed](https://github.com/IBM/kui/commit/1360bed)), closes [#4887](https://github.com/IBM/kui/issues/4887)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** kubectl edit saves can result in unstyled notification ([5dc658e](https://github.com/IBM/kui/commit/5dc658e)), closes [#4930](https://github.com/IBM/kui/issues/4930)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** poor alignment of sidecar toolbar elements ([2307a46](https://github.com/IBM/kui/commit/2307a46)), closes [#4970](https://github.com/IBM/kui/issues/4970)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** regression: non-empty repl output has 'ok' at the end ([103a0f9](https://github.com/IBM/kui/commit/103a0f9)), closes [#4924](https://github.com/IBM/kui/issues/4924)
- **plugins/plugin-client-common:** reverse-i-search does not properly report no matches ([c16dad3](https://github.com/IBM/kui/commit/c16dad3)), closes [#4943](https://github.com/IBM/kui/issues/4943)
- **plugins/plugin-client-common:** Screenshot modal never goes away ([bbd1c98](https://github.com/IBM/kui/commit/bbd1c98)), closes [#4979](https://github.com/IBM/kui/issues/4979)
- **plugins/plugin-client-common:** split button errors are not reported to the user ([fc4e2a2](https://github.com/IBM/kui/commit/fc4e2a2)), closes [#4876](https://github.com/IBM/kui/issues/4876)
- **plugins/plugin-client-common:** spurious warning in the console re: Tag ([93982de](https://github.com/IBM/kui/commit/93982de)), closes [#4959](https://github.com/IBM/kui/issues/4959)
- **plugins/plugin-client-common:** status cells of live tables do not always blink ([c94b05e](https://github.com/IBM/kui/commit/c94b05e)), closes [#4903](https://github.com/IBM/kui/issues/4903)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- **plugins/plugin-client-common:** UpdateNotification widget has invisible background color ([c0c1d82](https://github.com/IBM/kui/commit/c0c1d82)), closes [#4968](https://github.com/IBM/kui/issues/4968)
- **plugins/plugin-patternfly-themes:** update theme alignment to patternfly v4 ([3784b96](https://github.com/IBM/kui/commit/3784b96)), closes [#4948](https://github.com/IBM/kui/issues/4948)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- erratic scroll region behavior ([be0e2a0](https://github.com/IBM/kui/commit/be0e2a0)), closes [#4898](https://github.com/IBM/kui/issues/4898)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- page-content p should not use text-align: justify ([2646f4b](https://github.com/IBM/kui/commit/2646f4b)), closes [#4908](https://github.com/IBM/kui/issues/4908)
- split screen terminals sometimes incorrect handle exit ([d63cde7](https://github.com/IBM/kui/commit/d63cde7)), closes [#4860](https://github.com/IBM/kui/issues/4860)
- upgrade @patternfly/react-core to latest ([0331533](https://github.com/IBM/kui/commit/0331533)), closes [#4937](https://github.com/IBM/kui/issues/4937)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugn-client-common:** TopTabStripe stays blue after command execution completes ([68f5841](https://github.com/IBM/kui/commit/68f5841)), closes [#4883](https://github.com/IBM/kui/issues/4883)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** table container should only be width:100% for table not display-as-grid ([8f327cd](https://github.com/IBM/kui/commit/8f327cd)), closes [#4871](https://github.com/IBM/kui/issues/4871)
- **plugins/plugin-client-common:** top tab buttons should be owned by the top tab stripe ([9a45c43](https://github.com/IBM/kui/commit/9a45c43)), closes [#4690](https://github.com/IBM/kui/issues/4690)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- remove TreeResponse and PatternFly Tree Component ([e539a53](https://github.com/IBM/kui/commit/e539a53)), closes [#6581](https://github.com/IBM/kui/issues/6581) [#6328](https://github.com/IBM/kui/issues/6328)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar back/forward should be ordered by visitation rather than insertion ([fba613a](https://github.com/IBM/kui/commit/fba613a)), closes [#4746](https://github.com/IBM/kui/issues/4746)
- sidecar container selection kebab has different color with its menu ([639617a](https://github.com/IBM/kui/commit/639617a)), closes [#4676](https://github.com/IBM/kui/issues/4676)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- TopNavSidecar doesn't return to the previous selected Tab when back button is hit ([32acee5](https://github.com/IBM/kui/commit/32acee5)), closes [#4745](https://github.com/IBM/kui/issues/4745)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- Tree view badges can have low contrast ([9be1ae5](https://github.com/IBM/kui/commit/9be1ae5)), closes [#6245](https://github.com/IBM/kui/issues/6245)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** add support for titles in commentary ([fbe367c](https://github.com/IBM/kui/commit/fbe367c)), closes [#5434](https://github.com/IBM/kui/issues/5434)
- **plugins/plugin-client-common:** avoid inner scrolling in Commentary cards ([d3ea558](https://github.com/IBM/kui/commit/d3ea558)), closes [#5517](https://github.com/IBM/kui/issues/5517)
- **plugins/plugin-client-common:** Block Action buttons have poor contrast in dark themes ([f52511e](https://github.com/IBM/kui/commit/f52511e)), closes [#5590](https://github.com/IBM/kui/issues/5590)
- **plugins/plugin-client-common:** Block Actions should be top-aligned in output-only blocks ([55ce899](https://github.com/IBM/kui/commit/55ce899)), closes [#5595](https://github.com/IBM/kui/issues/5595)
- **plugins/plugin-client-common:** block left-border is not centered with In[1] text in minisplits ([4df61cc](https://github.com/IBM/kui/commit/4df61cc)), closes [#5585](https://github.com/IBM/kui/issues/5585)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** Commentary blocks are not focusable in minisplits ([1286b0d](https://github.com/IBM/kui/commit/1286b0d)), closes [#5594](https://github.com/IBM/kui/issues/5594)
- **plugins/plugin-client-common:** Commentary paragraphs have no separation ([6b77a13](https://github.com/IBM/kui/commit/6b77a13)), closes [#5531](https://github.com/IBM/kui/issues/5531)
- **plugins/plugin-client-common:** custom tab titles may have monospace font ([b34b5a4](https://github.com/IBM/kui/commit/b34b5a4)), closes [#5527](https://github.com/IBM/kui/issues/5527)
- **plugins/plugin-client-common:** defer loading of both icon sets ([7d343b8](https://github.com/IBM/kui/commit/7d343b8)), closes [#5444](https://github.com/IBM/kui/issues/5444)
- **plugins/plugin-client-common:** don't show "2 rows" table header for short tables ([2350115](https://github.com/IBM/kui/commit/2350115)), closes [#5581](https://github.com/IBM/kui/issues/5581)
- **plugins/plugin-client-common:** dropdown in sidecar theming and spacing tweaks ([1a48af3](https://github.com/IBM/kui/commit/1a48af3)), closes [#4680](https://github.com/IBM/kui/issues/4680)
- **plugins/plugin-client-common:** h2 in Notebooks have double underline ([40a4bd1](https://github.com/IBM/kui/commit/40a4bd1)), closes [#5574](https://github.com/IBM/kui/issues/5574)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve layout of In[1] with sidecar open ([263d59a](https://github.com/IBM/kui/commit/263d59a)), closes [#5482](https://github.com/IBM/kui/issues/5482)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** improve rendering of output only blocks ([664a8da](https://github.com/IBM/kui/commit/664a8da)), closes [#5467](https://github.com/IBM/kui/issues/5467)
- **plugins/plugin-client-common:** improve row hover effect for SequenceDiagram ([89dbe2a](https://github.com/IBM/kui/commit/89dbe2a)), closes [#5426](https://github.com/IBM/kui/issues/5426)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improve visibility of sidecar scrollbars ([827d75a](https://github.com/IBM/kui/commit/827d75a)), closes [#4667](https://github.com/IBM/kui/issues/4667)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** increase font size of status stripe ([2fab637](https://github.com/IBM/kui/commit/2fab637)), closes [#4698](https://github.com/IBM/kui/issues/4698)
- **plugins/plugin-client-common:** input element changes height with i-search and bottomInput ([abf9890](https://github.com/IBM/kui/commit/abf9890)), closes [#4685](https://github.com/IBM/kui/issues/4685)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** LeftNav sidecar nav column width inconsistency ([17e403f](https://github.com/IBM/kui/commit/17e403f)), closes [#4688](https://github.com/IBM/kui/issues/4688)
- **plugins/plugin-client-common:** LeftNavSidecar does not always reflect updated content ([0f2e1e1](https://github.com/IBM/kui/commit/0f2e1e1)), closes [#4727](https://github.com/IBM/kui/issues/4727) [#4732](https://github.com/IBM/kui/issues/4732)
- **plugins/plugin-client-common:** LeftNavSidecar font size and layout issues ([d9914f1](https://github.com/IBM/kui/commit/d9914f1)), closes [#4718](https://github.com/IBM/kui/issues/4718) [#4719](https://github.com/IBM/kui/issues/4719)
- **plugins/plugin-client-common:** lightweight ui has a few remaining "heavy" elements ([afef54a](https://github.com/IBM/kui/commit/afef54a)), closes [#6195](https://github.com/IBM/kui/issues/6195)
- **plugins/plugin-client-common:** lightweight ui: minisplits should not have the opacity filter ([96860f3](https://github.com/IBM/kui/commit/96860f3)), closes [#6198](https://github.com/IBM/kui/issues/6198)
- **plugins/plugin-client-common:** minor spacing improvements for Commentary and Notebooks ([c473181](https://github.com/IBM/kui/commit/c473181)), closes [#5503](https://github.com/IBM/kui/issues/5503)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** move screenshot button out of status stripe ([0ef900b](https://github.com/IBM/kui/commit/0ef900b)), closes [#4556](https://github.com/IBM/kui/issues/4556)
- **plugins/plugin-client-common:** pack table rows more densely in lightweight UI themes ([bcb3f23](https://github.com/IBM/kui/commit/bcb3f23)), closes [#6217](https://github.com/IBM/kui/issues/6217)
- **plugins/plugin-client-common:** PatternFly DropDown rendering glitches ([8efedd8](https://github.com/IBM/kui/commit/8efedd8)), closes [#4649](https://github.com/IBM/kui/issues/4649) [#4651](https://github.com/IBM/kui/issues/4651)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** refine Loading component ([7a07ad3](https://github.com/IBM/kui/commit/7a07ad3)), closes [#4702](https://github.com/IBM/kui/issues/4702)
- **plugins/plugin-client-common:** regression in columnar alignment of Input and Output ([cf1a836](https://github.com/IBM/kui/commit/cf1a836)), closes [#5507](https://github.com/IBM/kui/issues/5507)
- **plugins/plugin-client-common:** Rendering of markdown incorrectly inherits white-space:nowrap from repl ([d66b8b2](https://github.com/IBM/kui/commit/d66b8b2)), closes [#6575](https://github.com/IBM/kui/issues/6575)
- **plugins/plugin-client-common:** reverse the dependency of Card and DropDown ([00b8ecf](https://github.com/IBM/kui/commit/00b8ecf)), closes [#4641](https://github.com/IBM/kui/issues/4641)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- **plugins/plugin-client-common:** Screenshot button should not be offered inBrowser ([d1c2cfb](https://github.com/IBM/kui/commit/d1c2cfb)), closes [#4636](https://github.com/IBM/kui/issues/4636)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** sequence diagram does not display well with lightweight ui ([e746cc6](https://github.com/IBM/kui/commit/e746cc6)), closes [#6189](https://github.com/IBM/kui/issues/6189)
- **plugins/plugin-client-common:** SequenceDiagram bars are too narrow ([a0ed13a](https://github.com/IBM/kui/commit/a0ed13a)), closes [#5544](https://github.com/IBM/kui/issues/5544)
- **plugins/plugin-client-common:** SequenceDiagram can have NaNs in the UI ([ac476a6](https://github.com/IBM/kui/commit/ac476a6)), closes [#5559](https://github.com/IBM/kui/issues/5559)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** session init done message messes up Terminal scrolling ([7e80ac1](https://github.com/IBM/kui/commit/7e80ac1)), closes [#4683](https://github.com/IBM/kui/issues/4683)
- **plugins/plugin-client-common:** sidecar toolbar text incorrectly aligned ([ddd7460](https://github.com/IBM/kui/commit/ddd7460)), closes [#4659](https://github.com/IBM/kui/issues/4659)
- **plugins/plugin-client-common:** SourceRef does not respond to all tab layout changes ([d3e8b32](https://github.com/IBM/kui/commit/d3e8b32)), closes [#5552](https://github.com/IBM/kui/issues/5552)
- **plugins/plugin-client-common:** StatusStripe is blank for second+ tabs ([0002dfb](https://github.com/IBM/kui/commit/0002dfb)), closes [#5546](https://github.com/IBM/kui/issues/5546)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** Terminal screenshot odd w.r.t. auto-focus ([4b1c7d8](https://github.com/IBM/kui/commit/4b1c7d8)), closes [#4739](https://github.com/IBM/kui/issues/4739)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- **plugins/plugin-client-common:** TopNavSidecar tabs easily overflow with narrower windows ([a555cd4](https://github.com/IBM/kui/commit/a555cd4)), closes [#4735](https://github.com/IBM/kui/issues/4735)
- **plugins/plugin-client-common:** update welcome.json notebook to improve listing of available notebooks ([c6f89f4](https://github.com/IBM/kui/commit/c6f89f4)), closes [#5583](https://github.com/IBM/kui/issues/5583)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- improved support for replaying splits ([8039a9d](https://github.com/IBM/kui/commit/8039a9d)), closes [#5535](https://github.com/IBM/kui/issues/5535)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- notebook replay should scroll to top, and not display welcome message on every tab ([7ade801](https://github.com/IBM/kui/commit/7ade801)), closes [#5515](https://github.com/IBM/kui/issues/5515) [#5516](https://github.com/IBM/kui/issues/5516)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- pty output has different indentation than kui command output ([30b10a3](https://github.com/IBM/kui/commit/30b10a3)), closes [#5542](https://github.com/IBM/kui/issues/5542)
- replay --freshen does not support multi-split notebooks ([afd070c](https://github.com/IBM/kui/commit/afd070c)), closes [#5571](https://github.com/IBM/kui/issues/5571) [#5572](https://github.com/IBM/kui/issues/5572)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** SequenceDiagram bars may extend beyond the 100% line ([34d03bc](https://github.com/IBM/kui/commit/34d03bc)), closes [#5465](https://github.com/IBM/kui/issues/5465)
- **plugins/plugin-client-common:** SequenceDiagram can overflow 100% width ([d631fd9](https://github.com/IBM/kui/commit/d631fd9)), closes [#6159](https://github.com/IBM/kui/issues/6159)
- **plugins/plugin-client-common:** SequenceDiagram may emit spurious console errors ([c0ba218](https://github.com/IBM/kui/commit/c0ba218)), closes [#6166](https://github.com/IBM/kui/issues/6166)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** small regression in top tab stripe height ([0b07d35](https://github.com/IBM/kui/commit/0b07d35)), closes [#6211](https://github.com/IBM/kui/issues/6211)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** table bottom toolbar buttons lack padding ([79f0abe](https://github.com/IBM/kui/commit/79f0abe)), closes [#5554](https://github.com/IBM/kui/issues/5554)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** WatchPane has non-zero height even when empty ([67a7070](https://github.com/IBM/kui/commit/67a7070)), closes [#4629](https://github.com/IBM/kui/issues/4629)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** switching table from Table to Timeline and back to Table does not work ([c924d67](https://github.com/IBM/kui/commit/c924d67)), closes [#5430](https://github.com/IBM/kui/issues/5430)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** threshold for auto-grid is too low ([9cb76ee](https://github.com/IBM/kui/commit/9cb76ee)), closes [#5424](https://github.com/IBM/kui/issues/5424)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** Tree Component tweaks ([2f21e22](https://github.com/IBM/kui/commit/2f21e22)), closes [#6158](https://github.com/IBM/kui/issues/6158) [#6157](https://github.com/IBM/kui/issues/6157)
- **plugins/plugin-client-common:** typo "soild" in Tree.scss ([1a64ccd](https://github.com/IBM/kui/commit/1a64ccd)), closes [#6172](https://github.com/IBM/kui/issues/6172)
- **plugins/plugin-client-common:** update SequenceDiagram view to display the duration of each interval ([0cf1fcf](https://github.com/IBM/kui/commit/0cf1fcf)), closes [#5470](https://github.com/IBM/kui/issues/5470)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- **plugins/plugin-ibmcloud:** ibmcloud ce job list does not support name filters ([5daa930](https://github.com/IBM/kui/commit/5daa930)), closes [#5450](https://github.com/IBM/kui/issues/5450)
- **plugins/plugin-kubectl:** event watcher doesn't render well in minisplit ([56176de](https://github.com/IBM/kui/commit/56176de)), closes [#6772](https://github.com/IBM/kui/issues/6772)
- **plugins/plugin-kubectl:** unlabeled resources shouldn’t have badge for children's count ([4e1fea6](https://github.com/IBM/kui/commit/4e1fea6)), closes [#6243](https://github.com/IBM/kui/issues/6243)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- terminal clearing versus splits results in non-replayable splits ([8f9dc23](https://github.com/IBM/kui/commit/8f9dc23)), closes [#5626](https://github.com/IBM/kui/issues/5626)
- tweak the input background and border to enhance the readability of notebooks ([3928768](https://github.com/IBM/kui/commit/3928768)), closes [#5982](https://github.com/IBM/kui/issues/5982)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- cd command handles VFS mounts ([b66a2fb](https://github.com/IBM/kui/commit/b66a2fb)), closes [#6988](https://github.com/IBM/kui/issues/6988)
- **plugins/plugin-client-common:** empty tables use PatternFly's "empty state" UI ([f7ccdf1](https://github.com/IBM/kui/commit/f7ccdf1)), closes [#6867](https://github.com/IBM/kui/issues/6867)
- add Kubernetes Dashboard Notebook ([9f62b63](https://github.com/IBM/kui/commit/9f62b63)), closes [#5617](https://github.com/IBM/kui/issues/5617) [#6915](https://github.com/IBM/kui/issues/6915) [#6917](https://github.com/IBM/kui/issues/6917)
- introduce reexec for rerunning commands ([fe80525](https://github.com/IBM/kui/commit/fe80525)), closes [#6026](https://github.com/IBM/kui/issues/6026)
- pause and resume watchable jobs ([5d3f719](https://github.com/IBM/kui/commit/5d3f719)), closes [#1747](https://github.com/IBM/kui/issues/1747)
- preserve changes of table view state in Notebook ([a2efb8a](https://github.com/IBM/kui/commit/a2efb8a)), closes [#5399](https://github.com/IBM/kui/issues/5399)
- **plugins/plugin-client-common:** error messages should format as markdown ([63ca4a7](https://github.com/IBM/kui/commit/63ca4a7)), closes [#5943](https://github.com/IBM/kui/issues/5943)
- **plugins/plugin-client-common:** for emacs users, it'd be nice if ctrl+backspace would delete prior "word" ([122eb88](https://github.com/IBM/kui/commit/122eb88)), closes [#6579](https://github.com/IBM/kui/issues/6579)
- **plugins/plugin-client-common:** increase density of table content in minisplits ([8d6513f](https://github.com/IBM/kui/commit/8d6513f)), closes [#6790](https://github.com/IBM/kui/issues/6790)
- **plugins/plugin-client-common:** Table clickables should have better tooltip ([1eeaa01](https://github.com/IBM/kui/commit/1eeaa01)), closes [#6805](https://github.com/IBM/kui/issues/6805)
- add delta summary to Tree ([95a0b4a](https://github.com/IBM/kui/commit/95a0b4a)), closes [#6329](https://github.com/IBM/kui/issues/6329)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- add unit support of TreeResponse as one of the contents in MultiModalResponse ([85ea2d5](https://github.com/IBM/kui/commit/85ea2d5)), closes [#6132](https://github.com/IBM/kui/issues/6132)
- Allow command registrants to specify no semicolon expansion ([dbcaf87](https://github.com/IBM/kui/commit/dbcaf87)), closes [#6396](https://github.com/IBM/kui/issues/6396)
- clicking changed files in the `git status widget` should show `git diff` result in a DiffEditor ([3a199c7](https://github.com/IBM/kui/commit/3a199c7)), closes [#6348](https://github.com/IBM/kui/issues/6348)
- execute the command in url query when the browser app is loaded ([b0b95cf](https://github.com/IBM/kui/commit/b0b95cf)), closes [#5879](https://github.com/IBM/kui/issues/5879)
- Expand kubectl direct watching to support heterogeneous use cases ([8df1ad3](https://github.com/IBM/kui/commit/8df1ad3)), closes [#6504](https://github.com/IBM/kui/issues/6504)
- Improve support for designing light themes ([b6c859f](https://github.com/IBM/kui/commit/b6c859f)), closes [#6372](https://github.com/IBM/kui/issues/6372)
- improve the split layout progression ([d3f2d6c](https://github.com/IBM/kui/commit/d3f2d6c)), closes [#6747](https://github.com/IBM/kui/issues/6747) [#6743](https://github.com/IBM/kui/issues/6743)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- Kui implementation of `watch` ([2cb3f98](https://github.com/IBM/kui/commit/2cb3f98)), closes [#6379](https://github.com/IBM/kui/issues/6379)
- lightweight ui options for core themes ([cf96867](https://github.com/IBM/kui/commit/cf96867)), closes [#6187](https://github.com/IBM/kui/issues/6187)
- Make a notebook about making notebooks ([0d67947](https://github.com/IBM/kui/commit/0d67947)), closes [#6040](https://github.com/IBM/kui/issues/6040)
- Meta-click on table entries should open the drilldown in a different split ([fb89c29](https://github.com/IBM/kui/commit/fb89c29)), closes [#6403](https://github.com/IBM/kui/issues/6403)
- port experimental scale-out grep to use new job controller ([45ce460](https://github.com/IBM/kui/commit/45ce460)), closes [#6280](https://github.com/IBM/kui/issues/6280)
- revive "app" and "tier" columns from deprecated kubectl tree view ([cd642d9](https://github.com/IBM/kui/commit/cd642d9)), closes [#6591](https://github.com/IBM/kui/issues/6591)
- show buttons of related resources in sidecar footer ([e10f7f2](https://github.com/IBM/kui/commit/e10f7f2)), closes [#6856](https://github.com/IBM/kui/issues/6856)
- TopTab buttons should have improved tooltips ([5282612](https://github.com/IBM/kui/commit/5282612)), closes [#6806](https://github.com/IBM/kui/issues/6806)
- **plugins/plugin-client-common:** allow clients to specify initial tab title ([e8e365f](https://github.com/IBM/kui/commit/e8e365f)), closes [#5539](https://github.com/IBM/kui/issues/5539)
- **plugins/plugin-client-common:** Allow user to specify CWD as prompt ([2b2e7a9](https://github.com/IBM/kui/commit/2b2e7a9)), closes [#6405](https://github.com/IBM/kui/issues/6405)
- **plugins/plugin-client-common:** allow users to insert command before a repl block ([e935092](https://github.com/IBM/kui/commit/e935092)), closes [#5576](https://github.com/IBM/kui/issues/5576)
- **plugins/plugin-client-common:** Allow users to opt in to default meta-click behavior ([13ea5b0](https://github.com/IBM/kui/commit/13ea5b0)), closes [#6406](https://github.com/IBM/kui/issues/6406)
- **plugins/plugin-client-common:** allow users to reorder blocks by MoveUp and MoveDown buttons ([f7f6918](https://github.com/IBM/kui/commit/f7f6918)), closes [#5589](https://github.com/IBM/kui/issues/5589)
- **plugins/plugin-client-common:** improve action button UI for output-only blocks ([9cb99ad](https://github.com/IBM/kui/commit/9cb99ad)), closes [#5660](https://github.com/IBM/kui/issues/5660)
- **plugins/plugin-client-common:** last updated indicator in table footer ([5f91f75](https://github.com/IBM/kui/commit/5f91f75)), closes [#6783](https://github.com/IBM/kui/issues/6783)
- **plugins/plugin-client-common:** Shift-enter or CmdCtrl+S to save within Commentary ([4cf496a](https://github.com/IBM/kui/commit/4cf496a)), closes [#6827](https://github.com/IBM/kui/issues/6827)
- **plugins/plugin-client-common:** SourceRef should be default-expanded in Notebooks? ([8ee26e8](https://github.com/IBM/kui/commit/8ee26e8)), closes [#5866](https://github.com/IBM/kui/issues/5866)
- **plugins/plugin-client-common:** Tab completion should keep offering completions as I type ([67e44d3](https://github.com/IBM/kui/commit/67e44d3)), closes [#6472](https://github.com/IBM/kui/issues/6472)
- **plugins/plugin-kubectl:** Port kubectl pollers to use push, for homogeneous deletes ([82448d7](https://github.com/IBM/kui/commit/82448d7)), closes [#6481](https://github.com/IBM/kui/issues/6481) [#6486](https://github.com/IBM/kui/issues/6486)
- Extend kubectl optimizations to table watching ([9a2bc74](https://github.com/IBM/kui/commit/9a2bc74)), closes [#6449](https://github.com/IBM/kui/issues/6449)
- Feature: improve support for parallelization across VFS operations ([e05d7e0](https://github.com/IBM/kui/commit/e05d7e0)), closes [#5831](https://github.com/IBM/kui/issues/5831)
- initial support for using a kubectl proxy ([47b26be](https://github.com/IBM/kui/commit/47b26be)), closes [#6440](https://github.com/IBM/kui/issues/6440)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- Refine Update Checker widget UI ([5c97479](https://github.com/IBM/kui/commit/5c97479)), closes [#6343](https://github.com/IBM/kui/issues/6343)
- update CurrentContext widget to use Dropdown ([9520e5d](https://github.com/IBM/kui/commit/9520e5d)), closes [#6354](https://github.com/IBM/kui/issues/6354)
- use a Popover UI for git branch status stripe widget ([6bbf348](https://github.com/IBM/kui/commit/6bbf348)), closes [#6325](https://github.com/IBM/kui/issues/6325)
- use Accordion for SourceRef ([1b11736](https://github.com/IBM/kui/commit/1b11736)), closes [#6097](https://github.com/IBM/kui/issues/6097)
- use new Dropdown status stripe for CurrentNamespace widget ([0f7648c](https://github.com/IBM/kui/commit/0f7648c)), closes [#6351](https://github.com/IBM/kui/issues/6351)
- UX: Use Dropdown for theme switcher ([6cc6a47](https://github.com/IBM/kui/commit/6cc6a47)), closes [#6347](https://github.com/IBM/kui/issues/6347)
- **plugins/plugin-client-common:** block-level copy/paste ([a72cf8d](https://github.com/IBM/kui/commit/a72cf8d)), closes [#5752](https://github.com/IBM/kui/issues/5752)
- **plugins/plugin-client-common:** Output-only blocks should offer a Copy action button ([da4f85d](https://github.com/IBM/kui/commit/da4f85d)), closes [#5646](https://github.com/IBM/kui/issues/5646)
- **plugins/plugin-client-common:** split command should allow user to specify splice index ([75857e9](https://github.com/IBM/kui/commit/75857e9)), closes [#5746](https://github.com/IBM/kui/issues/5746)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- save/restore pty command output ([2c291a9](https://github.com/IBM/kui/commit/2c291a9)), closes [#5314](https://github.com/IBM/kui/issues/5314)
- **plugins/plugin-client-common:** edit a commentary response using SimpleEditor ([6d828c1](https://github.com/IBM/kui/commit/6d828c1)), closes [#5664](https://github.com/IBM/kui/issues/5664)
- **plugins/plugin-client-common:** Improve notebook-style ui ([791160e](https://github.com/IBM/kui/commit/791160e)), closes [#5472](https://github.com/IBM/kui/issues/5472)
- **plugins/plugin-client-common:** User should be able to tab navigate through blocks ([54d3759](https://github.com/IBM/kui/commit/54d3759)), closes [#5717](https://github.com/IBM/kui/issues/5717)
- ability to register an onClose handler when opening a tab ([58a36c3](https://github.com/IBM/kui/commit/58a36c3)), closes [#5670](https://github.com/IBM/kui/issues/5670)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- allow command registrations to express their experimental nature ([eb9f147](https://github.com/IBM/kui/commit/eb9f147)), closes [#5282](https://github.com/IBM/kui/issues/5282)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- add a command to return the Card Component in Terminal ([d8d13ab](https://github.com/IBM/kui/commit/d8d13ab)), closes [#4973](https://github.com/IBM/kui/issues/4973)
- add alert command to display Alert component in Terminal ([495d3bb](https://github.com/IBM/kui/commit/495d3bb)), closes [#4957](https://github.com/IBM/kui/issues/4957)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add sequence diagram to table with timestamp columns ([e9028ee](https://github.com/IBM/kui/commit/e9028ee)), closes [#5336](https://github.com/IBM/kui/issues/5336)
- allow clients to modify the session lifecycle UI by providing custom strings ([3c78fd3](https://github.com/IBM/kui/commit/3c78fd3)), closes [#5019](https://github.com/IBM/kui/issues/5019)
- allow table model to specify a gridable column index ([f4ba8e6](https://github.com/IBM/kui/commit/f4ba8e6)), closes [#5278](https://github.com/IBM/kui/issues/5278)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- command history should be tab-specific ([1b987e0](https://github.com/IBM/kui/commit/1b987e0)), closes [#1299](https://github.com/IBM/kui/issues/1299)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- **plugins/plugin-client-common:** add support for Tags in StatusStripe ([d112c86](https://github.com/IBM/kui/commit/d112c86)), closes [#4951](https://github.com/IBM/kui/issues/4951)
- **plugins/plugin-client-common:** History navigation in minisplits should navigate In/Out pairs ([93eb2a4](https://github.com/IBM/kui/commit/93eb2a4)), closes [#5270](https://github.com/IBM/kui/issues/5270)
- **plugins/plugin-client-common:** improve accessibility of "red" error grid cells ([8921292](https://github.com/IBM/kui/commit/8921292)), closes [#4938](https://github.com/IBM/kui/issues/4938)
- **plugins/plugin-client-common:** Improve Commentary editing UI by adding real Done button ([1f544b5](https://github.com/IBM/kui/commit/1f544b5)), closes [#5667](https://github.com/IBM/kui/issues/5667)
- **plugins/plugin-client-common:** show table row count in card header ([deadcfa](https://github.com/IBM/kui/commit/deadcfa)), closes [#5137](https://github.com/IBM/kui/issues/5137)
- **plugins/plugin-client-common:** support client option for hero names in sidecar ([d4f6984](https://github.com/IBM/kui/commit/d4f6984)), closes [#4909](https://github.com/IBM/kui/issues/4909)
- **plugins/plugin-client-common:** use Cards to wrap kube tables and grids ([6698013](https://github.com/IBM/kui/commit/6698013)), closes [#5032](https://github.com/IBM/kui/issues/5032)
- **plugins/plugin-client-common:** use inner scrolling for RadioTables in main Terminals ([952f72a](https://github.com/IBM/kui/commit/952f72a)), closes [#5133](https://github.com/IBM/kui/issues/5133)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- <Kui> should allow for custom Input elements ([193a108](https://github.com/IBM/kui/commit/193a108)), closes [#4672](https://github.com/IBM/kui/issues/4672)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add capability to click to edit/rerun a command ([4296933](https://github.com/IBM/kui/commit/4296933)), closes [#5654](https://github.com/IBM/kui/issues/5654)
- add CommentaryReponse to snapshot/replay the response of commentary command ([7d13a93](https://github.com/IBM/kui/commit/7d13a93)), closes [#5439](https://github.com/IBM/kui/issues/5439)
- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for <Kui noPromptContext/> and <Kui prompt=">"/> ([a92063d](https://github.com/IBM/kui/commit/a92063d)), closes [#4653](https://github.com/IBM/kui/issues/4653)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow <Kui/> users to provide custom views for session init ([1f35894](https://github.com/IBM/kui/commit/1f35894)), closes [#4596](https://github.com/IBM/kui/issues/4596)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow subclasses of InputProvider to specify their own State ([c3fc88e](https://github.com/IBM/kui/commit/c3fc88e)), closes [#4756](https://github.com/IBM/kui/issues/4756)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- auto gridify large table ([bd22fa2](https://github.com/IBM/kui/commit/bd22fa2)), closes [#5305](https://github.com/IBM/kui/issues/5305)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- commentary command to add comments to REPL ([c304fd3](https://github.com/IBM/kui/commit/c304fd3)), closes [#5428](https://github.com/IBM/kui/issues/5428)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- Dropdown spi and use in Terminal Block ([327917b](https://github.com/IBM/kui/commit/327917b)), closes [#4589](https://github.com/IBM/kui/issues/4589) [#4556](https://github.com/IBM/kui/issues/4556)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- improve repl-block selection ([305b36f](https://github.com/IBM/kui/commit/305b36f)), closes [#5587](https://github.com/IBM/kui/issues/5587)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- initial/minimal snapshot/replay support ([bb7ae0f](https://github.com/IBM/kui/commit/bb7ae0f)), closes [#5280](https://github.com/IBM/kui/issues/5280)
- inverse splits ([38d2895](https://github.com/IBM/kui/commit/38d2895)), closes [#5537](https://github.com/IBM/kui/issues/5537)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- pass command line comments to commentary command ([a020db5](https://github.com/IBM/kui/commit/a020db5)), closes [#5459](https://github.com/IBM/kui/issues/5459)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- RadioTable and port of the themes table to use it ([79a3e8e](https://github.com/IBM/kui/commit/79a3e8e)), closes [#4507](https://github.com/IBM/kui/issues/4507)
- separate out themes into a new settings Notebook ([5180759](https://github.com/IBM/kui/commit/5180759)), closes [#5605](https://github.com/IBM/kui/issues/5605)
- shift Block UI to use a Notebook style of presentation ([dc0ee4b](https://github.com/IBM/kui/commit/dc0ee4b)), closes [#5258](https://github.com/IBM/kui/issues/5258)
- snapshot freshening ([d5c8991](https://github.com/IBM/kui/commit/d5c8991)), closes [#5522](https://github.com/IBM/kui/issues/5522)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- support replaying in new tab ([04a2c67](https://github.com/IBM/kui/commit/04a2c67)), closes [#5509](https://github.com/IBM/kui/issues/5509)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- Timeline view for kubernetes Jobs ([b623e4e](https://github.com/IBM/kui/commit/b623e4e)), closes [#5370](https://github.com/IBM/kui/issues/5370)
- update checker ([a7908d2](https://github.com/IBM/kui/commit/a7908d2)), closes [#4537](https://github.com/IBM/kui/issues/4537)
- Update default loadingDone to use Card component ([e1b4c61](https://github.com/IBM/kui/commit/e1b4c61)), closes [#4986](https://github.com/IBM/kui/issues/4986)
- update ls to allow for presenting content from more limited VFS's such as tutorials ([a1ff1a4](https://github.com/IBM/kui/commit/a1ff1a4)), closes [#5497](https://github.com/IBM/kui/issues/5497)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- **plugins/plugin-client-common:** allow easier rerunning of command from terminal ([c5384e0](https://github.com/IBM/kui/commit/c5384e0)), closes [#4570](https://github.com/IBM/kui/issues/4570)
- **plugins/plugin-client-common:** improve presentation of sidecar-destined responses ([02b91e3](https://github.com/IBM/kui/commit/02b91e3)), closes [#5463](https://github.com/IBM/kui/issues/5463)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

## [10.0.1](https://github.com/IBM/kui/compare/v4.5.0...v10.0.1) (2021-02-01)

### Bug Fixes

- **plugin-client-common:** show the last input block in minisplit ([7997ef0](https://github.com/IBM/kui/commit/7997ef0)), closes [#5756](https://github.com/IBM/kui/issues/5756)
- **plugins/plugin-client-common:** "Drilled down to..." text is not aligned with the Input area ([fd139d2](https://github.com/IBM/kui/commit/fd139d2)), closes [#5854](https://github.com/IBM/kui/issues/5854)
- **plugins/plugin-client-common:** "No events in the past hour" in sidecar has different bg color than other tabs ([ffba806](https://github.com/IBM/kui/commit/ffba806)), closes [#6075](https://github.com/IBM/kui/issues/6075)
- **plugins/plugin-client-common:** Action button hover hysteresis/delay effect not working ([fac75dc](https://github.com/IBM/kui/commit/fac75dc)), closes [#5806](https://github.com/IBM/kui/issues/5806)
- **plugins/plugin-client-common:** clicking on table or radio table may cause block to disappear ([1f2d489](https://github.com/IBM/kui/commit/1f2d489)), closes [#5783](https://github.com/IBM/kui/issues/5783)
- **plugins/plugin-client-common:** ClipboardTransfer emits errors when pasting non-json text ([6ff85c4](https://github.com/IBM/kui/commit/6ff85c4)), closes [#5836](https://github.com/IBM/kui/issues/5836)
- **plugins/plugin-client-common:** CodeSnippet component renders with zero contrast in dark themes ([10e40a9](https://github.com/IBM/kui/commit/10e40a9)), closes [#5886](https://github.com/IBM/kui/issues/5886)
- **plugins/plugin-client-common:** colored squares in status column of tables have odd alignment ([3e78540](https://github.com/IBM/kui/commit/3e78540)), closes [#5766](https://github.com/IBM/kui/issues/5766)
- **plugins/plugin-client-common:** Commentary editor is 5px tall when presented in mini split ([53074d1](https://github.com/IBM/kui/commit/53074d1)), closes [#5744](https://github.com/IBM/kui/issues/5744)
- **plugins/plugin-client-common:** creating a split with a 3-way split configuration results in radical shuffling ([9452b5a](https://github.com/IBM/kui/commit/9452b5a)), closes [#5794](https://github.com/IBM/kui/issues/5794)
- **plugins/plugin-client-common:** deleting and re-creating a split results double commands ([dde6eaa](https://github.com/IBM/kui/commit/dde6eaa)), closes [#5876](https://github.com/IBM/kui/issues/5876)
- **plugins/plugin-client-common:** disable Timeline option for Tables ([e88ebb3](https://github.com/IBM/kui/commit/e88ebb3)), closes [#5864](https://github.com/IBM/kui/issues/5864)
- **plugins/plugin-client-common:** don't decorate code elements in top tab ([531e8b8](https://github.com/IBM/kui/commit/531e8b8)), closes [#5778](https://github.com/IBM/kui/issues/5778)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** editing commentary gives a one-line monaco ([5f14268](https://github.com/IBM/kui/commit/5f14268)), closes [#5874](https://github.com/IBM/kui/issues/5874)
- **plugins/plugin-client-common:** editor doesn't grab focus for edit command ([9870267](https://github.com/IBM/kui/commit/9870267)), closes [#6090](https://github.com/IBM/kui/issues/6090)
- block focus regressions ([881fa17](https://github.com/IBM/kui/commit/881fa17)), closes [#6072](https://github.com/IBM/kui/issues/6072)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- **plugins-client-common:** bump carbon-components-react to 7.22 ([8b98791](https://github.com/IBM/kui/commit/8b98791)), closes [#6011](https://github.com/IBM/kui/issues/6011)
- **plugins/plugin-client-common:** a few more patternfly navigation styling issues ([5511c1f](https://github.com/IBM/kui/commit/5511c1f)), closes [#6049](https://github.com/IBM/kui/issues/6049)
- **plugins/plugin-client-common:** active pty output doesn't have repl-context ([6b0929e](https://github.com/IBM/kui/commit/6b0929e)), closes [#5960](https://github.com/IBM/kui/issues/5960)
- **plugins/plugin-client-common:** blockquotes in commentary don't render well ([9be35fa](https://github.com/IBM/kui/commit/9be35fa)), closes [#5931](https://github.com/IBM/kui/issues/5931)
- **plugins/plugin-client-common:** commentary editor can overflow with long lines ([3475287](https://github.com/IBM/kui/commit/3475287)), closes [#5981](https://github.com/IBM/kui/issues/5981)
- **plugins/plugin-client-common:** Commentary markdown does not support kuiexec ([4663389](https://github.com/IBM/kui/commit/4663389)), closes [#5911](https://github.com/IBM/kui/issues/5911)
- **plugins/plugin-client-common:** custom repl-prompt is misaligned with repl-output ([d12b203](https://github.com/IBM/kui/commit/d12b203)), closes [#6046](https://github.com/IBM/kui/issues/6046)
- **plugins/plugin-client-common:** do not show the command rerun and remove button for offline kui ([309162f](https://github.com/IBM/kui/commit/309162f)), closes [#5917](https://github.com/IBM/kui/issues/5917)
- **plugins/plugin-client-common:** double clicking on Commentary in minisplit often has the editor completely off screen ([c3504a0](https://github.com/IBM/kui/commit/c3504a0)), closes [#5897](https://github.com/IBM/kui/issues/5897)
- **plugins/plugin-client-common:** empty pty response yields blank line ([711bd05](https://github.com/IBM/kui/commit/711bd05)), closes [#5928](https://github.com/IBM/kui/issues/5928)
- **plugins/plugin-client-common:** enhance minisplit by updating the background color of scrollback and dark card ([fd15c5e](https://github.com/IBM/kui/commit/fd15c5e)), closes [#5989](https://github.com/IBM/kui/issues/5989)
- **plugins/plugin-client-common:** error blocks are not indented properly ([d137614](https://github.com/IBM/kui/commit/d137614)), closes [#5938](https://github.com/IBM/kui/issues/5938)
- **plugins/plugin-client-common:** focus a block upon moving or pasting it ([43c3d9a](https://github.com/IBM/kui/commit/43c3d9a)), closes [#5751](https://github.com/IBM/kui/issues/5751)
- **plugins/plugin-client-common:** group the notebooks together in the ls -l table ([1a783f3](https://github.com/IBM/kui/commit/1a783f3)), closes [#5977](https://github.com/IBM/kui/issues/5977)
- **plugins/plugin-client-common:** hovering over error block turns red to blue ([3dbddae](https://github.com/IBM/kui/commit/3dbddae)), closes [#5979](https://github.com/IBM/kui/issues/5979)
- **plugins/plugin-client-common:** If a command is issued in a mini split, the next block (in the mini split) is not focused ([a35e5c2](https://github.com/IBM/kui/commit/a35e5c2)), closes [#6067](https://github.com/IBM/kui/issues/6067)
- **plugins/plugin-client-common:** improve look of `code` snippets in Commentary ([493e004](https://github.com/IBM/kui/commit/493e004)), closes [#5768](https://github.com/IBM/kui/issues/5768)
- **plugins/plugin-client-common:** in dark themes, the inter-split gutter is not visible ([288eeae](https://github.com/IBM/kui/commit/288eeae)), closes [#6022](https://github.com/IBM/kui/issues/6022)
- **plugins/plugin-client-common:** In some themes, grid inner text color can have low contrast. ([01f8698](https://github.com/IBM/kui/commit/01f8698)), closes [#6032](https://github.com/IBM/kui/issues/6032)
- **plugins/plugin-client-common:** increase contrast of unfocused left-stripes for blocks ([ab21295](https://github.com/IBM/kui/commit/ab21295)), closes [#5754](https://github.com/IBM/kui/issues/5754)
- **plugins/plugin-client-common:** Input timestamp should also hide when block is focused ([6e1ca6d](https://github.com/IBM/kui/commit/6e1ca6d)), closes [#5809](https://github.com/IBM/kui/issues/5809)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** linux can show unneeded scrollbars in tables ([4d49a23](https://github.com/IBM/kui/commit/4d49a23)), closes [#5884](https://github.com/IBM/kui/issues/5884)
- **plugins/plugin-client-common:** markdown code has incorrect color in a split with inverse color ([c8c10af](https://github.com/IBM/kui/commit/c8c10af)), closes [#5902](https://github.com/IBM/kui/issues/5902)
- **plugins/plugin-client-common:** markdown inline code in table cells shows with scrollbars on linux and windows ([1ff88b9](https://github.com/IBM/kui/commit/1ff88b9)), closes [#5890](https://github.com/IBM/kui/issues/5890)
- **plugins/plugin-client-common:** PatternFly assumes a 16px body font size, whereas the rest of Kui assumes 14px ([fa65b57](https://github.com/IBM/kui/commit/fa65b57)), closes [#6041](https://github.com/IBM/kui/issues/6041)
- **plugins/plugin-client-common:** PatternFly LeftNav view has excessive padding ([959d059](https://github.com/IBM/kui/commit/959d059)), closes [#6038](https://github.com/IBM/kui/issues/6038)
- **plugins/plugin-client-common:** presented elsewhere text is not vertically centered in block ([766d355](https://github.com/IBM/kui/commit/766d355)), closes [#5760](https://github.com/IBM/kui/issues/5760)
- **plugins/plugin-client-common:** remove clicks from NotebookImpl ([45f0be5](https://github.com/IBM/kui/commit/45f0be5)), closes [#5856](https://github.com/IBM/kui/issues/5856)
- **plugins/plugin-client-common:** rendering of blockquotes in markdown is inconsistent ([edcc8d1](https://github.com/IBM/kui/commit/edcc8d1)), closes [#6043](https://github.com/IBM/kui/issues/6043)
- A few more themes tweaks are needed ([03be3eb](https://github.com/IBM/kui/commit/03be3eb)), closes [#6034](https://github.com/IBM/kui/issues/6034)
- **plugins/plugin-client-common:** restore hiding of In[1] in minisplit ([8d5c93f](https://github.com/IBM/kui/commit/8d5c93f)), closes [#5985](https://github.com/IBM/kui/issues/5985)
- **plugins/plugin-client-common:** sidecar markdown code snippet has poor color ([765f166](https://github.com/IBM/kui/commit/765f166)), closes [#5995](https://github.com/IBM/kui/issues/5995)
- RadioTable should have option to not echo the onSelect command ([77d5050](https://github.com/IBM/kui/commit/77d5050)), closes [#5991](https://github.com/IBM/kui/issues/5991)
- **plugins/plugin-client-common:** saving a snapshot can fail with "cannot read property uuid of undefined" ([85fe1f3](https://github.com/IBM/kui/commit/85fe1f3)), closes [#5913](https://github.com/IBM/kui/issues/5913)
- **plugins/plugin-client-common:** some small tweaks to Commentary headers would help ([b012f8d](https://github.com/IBM/kui/commit/b012f8d)), closes [#5893](https://github.com/IBM/kui/issues/5893)
- **plugins/plugin-client-common:** sorting widgets in table header are wrapping ([e3520dc](https://github.com/IBM/kui/commit/e3520dc)), closes [#5976](https://github.com/IBM/kui/issues/5976)
- **plugins/plugin-client-common:** update the commentary in settings notebook to store the texts as command ([bbb8f6d](https://github.com/IBM/kui/commit/bbb8f6d)), closes [#5992](https://github.com/IBM/kui/issues/5992)
- improve error reporting from APIs ([edff6f1](https://github.com/IBM/kui/commit/edff6f1)), closes [#5950](https://github.com/IBM/kui/issues/5950)
- tweak the input background and border to enhance the readability of notebooks ([3928768](https://github.com/IBM/kui/commit/3928768)), closes [#5982](https://github.com/IBM/kui/issues/5982)
- **plugins/plugin-client-common:** the alert showing lost connection has incorrect height ([1758758](https://github.com/IBM/kui/commit/1758758)), closes [#5905](https://github.com/IBM/kui/issues/5905)
- preferReExecute is lost when re-saving a notebook ([87c6c6f](https://github.com/IBM/kui/commit/87c6c6f)), closes [#5954](https://github.com/IBM/kui/issues/5954)
- **plugins/plugin-client-common:** remove leftover debugging in Scalar/index ([82b8e50](https://github.com/IBM/kui/commit/82b8e50)), closes [#5945](https://github.com/IBM/kui/issues/5945)
- add Kui version and github link to client-notebook ([7b2562a](https://github.com/IBM/kui/commit/7b2562a)), closes [#5918](https://github.com/IBM/kui/issues/5918)
- improve discovery of ibmcloud s3 credentials ([96d5bc0](https://github.com/IBM/kui/commit/96d5bc0)), closes [#5926](https://github.com/IBM/kui/issues/5926)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- **plugins/plugin-client-common:** tab switching can be slow on windows ([09f9b7d](https://github.com/IBM/kui/commit/09f9b7d)), closes [#5907](https://github.com/IBM/kui/issues/5907)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-client-common:** welcome.json could use some wordsmithing ([e373ab4](https://github.com/IBM/kui/commit/e373ab4)), closes [#5895](https://github.com/IBM/kui/issues/5895)
- **plugins/plugin-client-common): regression validateDOMNesting(...:** <pre> cannot appear as a descendant of <p> ([1a2cccf](https://github.com/IBM/kui/commit/1a2cccf)), closes [#5900](https://github.com/IBM/kui/issues/5900)
- blocks can still disappear if table row is clicked while the enclosing block is focused ([2173af1](https://github.com/IBM/kui/commit/2173af1)), closes [#5814](https://github.com/IBM/kui/issues/5814)
- don't show the `open` command for clicking files in `ls` table ([03ef269](https://github.com/IBM/kui/commit/03ef269)), closes [#5748](https://github.com/IBM/kui/issues/5748)
- for replayed notebooks, don’t show timestamp ([951abc5](https://github.com/IBM/kui/commit/951abc5)), closes [#5763](https://github.com/IBM/kui/issues/5763)
- ls comand is not snapshotable ([f04ca78](https://github.com/IBM/kui/commit/f04ca78)), closes [#5241](https://github.com/IBM/kui/issues/5241)
- Notebook title "Kui Setting" should be "Kui Settings" ([b14b130](https://github.com/IBM/kui/commit/b14b130)), closes [#5870](https://github.com/IBM/kui/issues/5870)
- re-saving a notebook via File/Save application menu does not preserve notebook title ([7fb8b43](https://github.com/IBM/kui/commit/7fb8b43)), closes [#5777](https://github.com/IBM/kui/issues/5777)
- **plugins/plugin-client-common:** RadioTable should scroll the selected row into view on render ([6eb45db](https://github.com/IBM/kui/commit/6eb45db)), closes [#5781](https://github.com/IBM/kui/issues/5781)
- **plugins/plugin-client-common:** re-snapshoting a notebook can fail ([4caff9c](https://github.com/IBM/kui/commit/4caff9c)), closes [#5736](https://github.com/IBM/kui/issues/5736)
- **plugins/plugin-client-common:** there is still too much whitespace after no-response commands ([268f159](https://github.com/IBM/kui/commit/268f159)), closes [#5742](https://github.com/IBM/kui/issues/5742)
- **plugins/plugin-client-common:** when replaying notebooks, tab should be scrolled to top ([6567412](https://github.com/IBM/kui/commit/6567412)), closes [#5860](https://github.com/IBM/kui/issues/5860)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-client-common:** selecting text in prior Input causes selection to be lost and Input to enter edit mode ([4d977d2](https://github.com/IBM/kui/commit/4d977d2)), closes [#5792](https://github.com/IBM/kui/issues/5792)
- remove up/down actions buttons ([3c8a8a1](https://github.com/IBM/kui/commit/3c8a8a1)), closes [#5774](https://github.com/IBM/kui/issues/5774)
- **plugins/plugin-client-common:** status stripe "blue" color probably needs to be toned done ([137442f](https://github.com/IBM/kui/commit/137442f)), closes [#5772](https://github.com/IBM/kui/issues/5772)
- **plugins/plugin-client-common:** table is misaligned with command input ([50dc430](https://github.com/IBM/kui/commit/50dc430)), closes [#5734](https://github.com/IBM/kui/issues/5734)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- **plugin-client-common:** RadioTable onSelect changes do not always result in status stripe updates ([3549b7a](https://github.com/IBM/kui/commit/3549b7a)), closes [#5644](https://github.com/IBM/kui/issues/5644)
- **plugins/plugin-client-common:** Whem moving blocks, the moved block is not longer focused after the move ([fc13198](https://github.com/IBM/kui/commit/fc13198)), closes [#5612](https://github.com/IBM/kui/issues/5612)
- **plugins/plugin-client-common:** a few small refinements to "editing" UI for Inputs ([001236a](https://github.com/IBM/kui/commit/001236a)), closes [#5656](https://github.com/IBM/kui/issues/5656) [#5658](https://github.com/IBM/kui/issues/5658)
- **plugins/plugin-client-common:** Block Action buttons have poor contrast in dark themes ([f52511e](https://github.com/IBM/kui/commit/f52511e)), closes [#5590](https://github.com/IBM/kui/issues/5590)
- **plugins/plugin-client-common:** Block Actions should be top-aligned in output-only blocks ([55ce899](https://github.com/IBM/kui/commit/55ce899)), closes [#5595](https://github.com/IBM/kui/issues/5595)
- **plugins/plugin-client-common:** block left-border is not centered with In[1] text in minisplits ([4df61cc](https://github.com/IBM/kui/commit/4df61cc)), closes [#5585](https://github.com/IBM/kui/issues/5585)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** Commentary blocks are not focusable in minisplits ([1286b0d](https://github.com/IBM/kui/commit/1286b0d)), closes [#5594](https://github.com/IBM/kui/issues/5594)
- **plugins/plugin-client-common:** Commentary editor can easily overflow when editing in minisplit ([eb14074](https://github.com/IBM/kui/commit/eb14074)), closes [#5675](https://github.com/IBM/kui/issues/5675)
- **plugins/plugin-client-common:** Commentary editor should be full width always ([e0a164a](https://github.com/IBM/kui/commit/e0a164a)), closes [#5688](https://github.com/IBM/kui/issues/5688)
- **plugins/plugin-client-common:** Commentary is always full width ([1920fb9](https://github.com/IBM/kui/commit/1920fb9)), closes [#5705](https://github.com/IBM/kui/issues/5705)
- **plugins/plugin-client-common:** Do not focus Block when user expands SourceRef ([6642514](https://github.com/IBM/kui/commit/6642514)), closes [#5711](https://github.com/IBM/kui/issues/5711)
- **plugins/plugin-client-common:** don't show "2 rows" table header for short tables ([2350115](https://github.com/IBM/kui/commit/2350115)), closes [#5581](https://github.com/IBM/kui/issues/5581)
- **plugins/plugin-client-common:** don't show `isTabLayoutModificationResponse` and PresentedElseWhere response in MiniSplit ([a16767a](https://github.com/IBM/kui/commit/a16767a)), closes [#5690](https://github.com/IBM/kui/issues/5690)
- **plugins/plugin-client-common:** Editing Commentary should require double click ([efaded3](https://github.com/IBM/kui/commit/efaded3)), closes [#5686](https://github.com/IBM/kui/issues/5686)
- **plugins/plugin-client-common:** empty blocks have excessive height ([12c39b0](https://github.com/IBM/kui/commit/12c39b0)), closes [#5707](https://github.com/IBM/kui/issues/5707)
- **plugins/plugin-client-common:** improved focus behavior of terminals ([f5a3dd0](https://github.com/IBM/kui/commit/f5a3dd0)), closes [#5615](https://github.com/IBM/kui/issues/5615)
- **plugins/plugin-client-common:** input probably needs to word-wrap while in minisplits ([cde272d](https://github.com/IBM/kui/commit/cde272d)), closes [#5696](https://github.com/IBM/kui/issues/5696)
- **plugins/plugin-client-common:** input spinner is not visible in minisplits ([76eec59](https://github.com/IBM/kui/commit/76eec59)), closes [#5684](https://github.com/IBM/kui/issues/5684)
- **plugins/plugin-client-common:** Lots of little layout issues, e.g. SimpleEditor is not fully width in minisplits ([5a9a1c6](https://github.com/IBM/kui/commit/5a9a1c6)), closes [#5679](https://github.com/IBM/kui/issues/5679) [#5680](https://github.com/IBM/kui/issues/5680)
- **plugins/plugin-client-common:** markdown with <a> inside <h1> renders with odd font size ([b5e3007](https://github.com/IBM/kui/commit/b5e3007)), closes [#5724](https://github.com/IBM/kui/issues/5724)
- **plugins/plugin-client-common:** monaco highlight color used by SourceRef has low contrast ([385f35e](https://github.com/IBM/kui/commit/385f35e)), closes [#5713](https://github.com/IBM/kui/issues/5713)
- **plugins/plugin-client-common:** never show "ok" ([d1b337a](https://github.com/IBM/kui/commit/d1b337a)), closes [#5697](https://github.com/IBM/kui/issues/5697)
- **plugins/plugin-client-common:** on switching tabs, active prompt isn't always focused ([5b28dd2](https://github.com/IBM/kui/commit/5b28dd2)), closes [#5637](https://github.com/IBM/kui/issues/5637)
- **plugins/plugin-client-common:** Output-only blocks probably don't need a re-execute button ([251a81c](https://github.com/IBM/kui/commit/251a81c)), closes [#5662](https://github.com/IBM/kui/issues/5662)
- **plugins/plugin-client-common:** remove active prompts in an offline notebook ([dd2b53f](https://github.com/IBM/kui/commit/dd2b53f)), closes [#5620](https://github.com/IBM/kui/issues/5620)
- **plugins/plugin-client-common:** SourceRef viewer should hide liner numbers but show folding ([5f74a46](https://github.com/IBM/kui/commit/5f74a46)), closes [#5719](https://github.com/IBM/kui/issues/5719)
- **plugins/plugin-client-common:** StatusStripe widgets can emit react error when switching to notebook tab ([485fcdf](https://github.com/IBM/kui/commit/485fcdf)), closes [#5639](https://github.com/IBM/kui/issues/5639)
- **plugins/plugin-client-common:** table cells with no onclick handler still issue a kui command ([4d8bf37](https://github.com/IBM/kui/commit/4d8bf37)), closes [#5721](https://github.com/IBM/kui/issues/5721)
- **plugins/plugin-client-common:** while editing Commentary, adding ``` causes a bad error ([097b1b0](https://github.com/IBM/kui/commit/097b1b0)), closes [#5682](https://github.com/IBM/kui/issues/5682)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- "created split" message should disappear when corresponding split is closed ([f8486f8](https://github.com/IBM/kui/commit/f8486f8)), closes [#5629](https://github.com/IBM/kui/issues/5629)
- **plugins/plugin-client-common:** h2 in Notebooks have double underline ([40a4bd1](https://github.com/IBM/kui/commit/40a4bd1)), closes [#5574](https://github.com/IBM/kui/issues/5574)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- replay --freshen does not support multi-split notebooks ([afd070c](https://github.com/IBM/kui/commit/afd070c)), closes [#5571](https://github.com/IBM/kui/issues/5571) [#5572](https://github.com/IBM/kui/issues/5572)
- **plugins/plugin-client-common:** add support for titles in commentary ([fbe367c](https://github.com/IBM/kui/commit/fbe367c)), closes [#5434](https://github.com/IBM/kui/issues/5434)
- **plugins/plugin-client-common:** avoid inner scrolling in Commentary cards ([d3ea558](https://github.com/IBM/kui/commit/d3ea558)), closes [#5517](https://github.com/IBM/kui/issues/5517)
- **plugins/plugin-client-common:** Commentary paragraphs have no separation ([6b77a13](https://github.com/IBM/kui/commit/6b77a13)), closes [#5531](https://github.com/IBM/kui/issues/5531)
- **plugins/plugin-client-common:** custom tab titles may have monospace font ([b34b5a4](https://github.com/IBM/kui/commit/b34b5a4)), closes [#5527](https://github.com/IBM/kui/issues/5527)
- **plugins/plugin-client-common:** defer loading of both icon sets ([7d343b8](https://github.com/IBM/kui/commit/7d343b8)), closes [#5444](https://github.com/IBM/kui/issues/5444)
- **plugins/plugin-client-common:** experiment tag has wrong color contrast in dark themes ([22bfb77](https://github.com/IBM/kui/commit/22bfb77)), closes [#5389](https://github.com/IBM/kui/issues/5389)
- **plugins/plugin-client-common:** Experimental badge should take up less space in minisplits ([268aeb3](https://github.com/IBM/kui/commit/268aeb3)), closes [#5373](https://github.com/IBM/kui/issues/5373)
- **plugins/plugin-client-common:** improve layout of In[1] with sidecar open ([263d59a](https://github.com/IBM/kui/commit/263d59a)), closes [#5482](https://github.com/IBM/kui/issues/5482)
- **plugins/plugin-client-common:** improve rendering of output only blocks ([664a8da](https://github.com/IBM/kui/commit/664a8da)), closes [#5467](https://github.com/IBM/kui/issues/5467)
- **plugins/plugin-client-common:** improve row hover effect for SequenceDiagram ([89dbe2a](https://github.com/IBM/kui/commit/89dbe2a)), closes [#5426](https://github.com/IBM/kui/issues/5426)
- **plugins/plugin-client-common:** minor spacing improvements for Commentary and Notebooks ([c473181](https://github.com/IBM/kui/commit/c473181)), closes [#5503](https://github.com/IBM/kui/issues/5503)
- **plugins/plugin-client-common:** refine Timeline a bit more ([4b12eec](https://github.com/IBM/kui/commit/4b12eec)), closes [#5409](https://github.com/IBM/kui/issues/5409)
- **plugins/plugin-client-common:** regression in columnar alignment of Input and Output ([cf1a836](https://github.com/IBM/kui/commit/cf1a836)), closes [#5507](https://github.com/IBM/kui/issues/5507)
- **plugins/plugin-client-common:** reverse-i-search incorrectly changes match as i type ([135d429](https://github.com/IBM/kui/commit/135d429)), closes [#5403](https://github.com/IBM/kui/issues/5403)
- **plugins/plugin-client-common:** SequenceDiagram bars are too narrow ([a0ed13a](https://github.com/IBM/kui/commit/a0ed13a)), closes [#5544](https://github.com/IBM/kui/issues/5544)
- **plugins/plugin-client-common:** SequenceDiagram bars may extend beyond the 100% line ([34d03bc](https://github.com/IBM/kui/commit/34d03bc)), closes [#5465](https://github.com/IBM/kui/issues/5465)
- **plugins/plugin-client-common:** SequenceDiagram can have NaNs in the UI ([ac476a6](https://github.com/IBM/kui/commit/ac476a6)), closes [#5559](https://github.com/IBM/kui/issues/5559)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** SourceRef does not respond to all tab layout changes ([d3e8b32](https://github.com/IBM/kui/commit/d3e8b32)), closes [#5552](https://github.com/IBM/kui/issues/5552)
- **plugins/plugin-client-common:** spinner is off-center by 1px ([e8cea91](https://github.com/IBM/kui/commit/e8cea91)), closes [#6885](https://github.com/IBM/kui/issues/6885)
- change new split keyboard shortcut from cltrOrMeta+U -> +Y ([9cac19d](https://github.com/IBM/kui/commit/9cac19d)), closes [#6876](https://github.com/IBM/kui/issues/6876)
- **plugins/plugin-client-common:** `kubectl get -f` does not render well when in a minisplit ([d9f6548](https://github.com/IBM/kui/commit/d9f6548)), closes [#6750](https://github.com/IBM/kui/issues/6750)
- **plugins/plugin-client-common:** a few more small tweaks to welcome notebook ([27773cb](https://github.com/IBM/kui/commit/27773cb)), closes [#6829](https://github.com/IBM/kui/issues/6829)
- **plugins/plugin-client-common:** age field in event footer is underlined ([c733449](https://github.com/IBM/kui/commit/c733449)), closes [#6739](https://github.com/IBM/kui/issues/6739)
- **plugins/plugin-client-common:** Block borders aren't quite right ([7050a02](https://github.com/IBM/kui/commit/7050a02)), closes [#6808](https://github.com/IBM/kui/issues/6808)
- **plugins/plugin-client-common:** Dropdown hover effect in PatternFly4 Dark has no contrast ([35eefb4](https://github.com/IBM/kui/commit/35eefb4)), closes [#6744](https://github.com/IBM/kui/issues/6744)
- **plugins/plugin-client-common:** events table doesn't handle long messages and narrow viewports ([ea90a34](https://github.com/IBM/kui/commit/ea90a34)), closes [#6831](https://github.com/IBM/kui/issues/6831)
- **plugins/plugin-client-common:** Grids in minisplits have horizontal overflow ([d2483fd](https://github.com/IBM/kui/commit/d2483fd)), closes [#6781](https://github.com/IBM/kui/issues/6781)
- **plugins/plugin-client-common:** Increase entryDelay for table tooltips ([4e3739a](https://github.com/IBM/kui/commit/4e3739a)), closes [#6870](https://github.com/IBM/kui/issues/6870)
- **plugins/plugin-client-common:** isWidthConstrained is always true for nSplits > 1 ([7d832f2](https://github.com/IBM/kui/commit/7d832f2)), closes [#6782](https://github.com/IBM/kui/issues/6782)
- **plugins/plugin-client-common:** kubectl unified tables have a NAME column (all caps) ([419f35d](https://github.com/IBM/kui/commit/419f35d)), closes [#6820](https://github.com/IBM/kui/issues/6820)
- **plugins/plugin-client-common:** Leftover console logs in ScrollableTerminal ([4f4af0d](https://github.com/IBM/kui/commit/4f4af0d)), closes [#6755](https://github.com/IBM/kui/issues/6755)
- **plugins/plugin-client-common:** live tables may never show "Last Updated" footer message ([477fa04](https://github.com/IBM/kui/commit/477fa04)), closes [#6845](https://github.com/IBM/kui/issues/6845)
- **plugins/plugin-client-common:** Markdown renderer does not handle img tags with http src ([fe12530](https://github.com/IBM/kui/commit/fe12530)), closes [#6818](https://github.com/IBM/kui/issues/6818)
- **plugins/plugin-client-common:** Markdown rendering of images does not support percentage width or height ([6e75c40](https://github.com/IBM/kui/commit/6e75c40)), closes [#6822](https://github.com/IBM/kui/issues/6822)
- **plugins/plugin-client-common:** markdown spacing regressions with h3 and h4 ([d674931](https://github.com/IBM/kui/commit/d674931)), closes [#6736](https://github.com/IBM/kui/issues/6736)
- **plugins/plugin-client-common:** on windows, table breadcrumb has vertical scrollbars ([b2fda10](https://github.com/IBM/kui/commit/b2fda10)), closes [#6878](https://github.com/IBM/kui/issues/6878)
- **plugins/plugin-client-common:** popover has odd spacing and overflow ([12d2508](https://github.com/IBM/kui/commit/12d2508)), closes [#6809](https://github.com/IBM/kui/issues/6809)
- **plugins/plugin-client-common:** pty output in the first block does not render ([9ec3996](https://github.com/IBM/kui/commit/9ec3996)), closes [#6758](https://github.com/IBM/kui/issues/6758)
- **plugins/plugin-client-common:** remove block border and refine input border for minisplits ([7b5ce5b](https://github.com/IBM/kui/commit/7b5ce5b)), closes [#6801](https://github.com/IBM/kui/issues/6801)
- **plugins/plugin-client-common:** sidecar top tabs may not have the proper sidecar header color ([dee76ed](https://github.com/IBM/kui/commit/dee76ed)), closes [#6841](https://github.com/IBM/kui/issues/6841)
- **plugins/plugin-client-common:** some grid cells display with no background color ([3d4a41d](https://github.com/IBM/kui/commit/3d4a41d)), closes [#6794](https://github.com/IBM/kui/issues/6794)
- **plugins/plugin-client-common:** sometimes both the block action buttons and the timestamp are visible at the same time ([a3ece2b](https://github.com/IBM/kui/commit/a3ece2b)), closes [#5936](https://github.com/IBM/kui/issues/5936)
- **plugins/plugin-client-common:** StatusStripe is blank for second+ tabs ([0002dfb](https://github.com/IBM/kui/commit/0002dfb)), closes [#5546](https://github.com/IBM/kui/issues/5546)
- **plugins/plugin-client-common:** table bottom toolbar buttons lack padding ([79f0abe](https://github.com/IBM/kui/commit/79f0abe)), closes [#5554](https://github.com/IBM/kui/issues/5554)
- **plugins/plugin-client-common:** Table header background color can be incorrect ([3249d89](https://github.com/IBM/kui/commit/3249d89)), closes [#6810](https://github.com/IBM/kui/issues/6810)
- **plugins/plugin-client-common:** Table header seems to float in front of dropdowns ([8a2b54b](https://github.com/IBM/kui/commit/8a2b54b)), closes [#6880](https://github.com/IBM/kui/issues/6880)
- **plugins/plugin-client-common:** tweak sidecar button spacing a bit ([9bdf8a6](https://github.com/IBM/kui/commit/9bdf8a6)), closes [#6873](https://github.com/IBM/kui/issues/6873)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improved support for replaying splits ([8039a9d](https://github.com/IBM/kui/commit/8039a9d)), closes [#5535](https://github.com/IBM/kui/issues/5535)
- in minisplits, blocks that contain pty output may have excess whitespace ([d9299ae](https://github.com/IBM/kui/commit/d9299ae)), closes [#6759](https://github.com/IBM/kui/issues/6759)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- new tab command can hang if title is provided ([a6c25c6](https://github.com/IBM/kui/commit/a6c25c6)), closes [#5624](https://github.com/IBM/kui/issues/5624)
- notebook replay should scroll to top, and not display welcome message on every tab ([7ade801](https://github.com/IBM/kui/commit/7ade801)), closes [#5515](https://github.com/IBM/kui/issues/5515) [#5516](https://github.com/IBM/kui/issues/5516)
- output only Actions should also render on hover ([cdbd105](https://github.com/IBM/kui/commit/cdbd105)), closes [#5652](https://github.com/IBM/kui/issues/5652)
- pty output has different indentation than kui command output ([30b10a3](https://github.com/IBM/kui/commit/30b10a3)), closes [#5542](https://github.com/IBM/kui/issues/5542)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- Screenshot alert is not visible in narrower windows ([d94da68](https://github.com/IBM/kui/commit/d94da68)), closes [#6843](https://github.com/IBM/kui/issues/6843)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- tab new command should respond with ElsewhereCommentary response ([19a7e1d](https://github.com/IBM/kui/commit/19a7e1d)), closes [#5602](https://github.com/IBM/kui/issues/5602)
- terminal clearing versus splits results in non-replayable splits ([8f9dc23](https://github.com/IBM/kui/commit/8f9dc23)), closes [#5626](https://github.com/IBM/kui/issues/5626)
- the x in the offline badge is sometimes low contrast, especially in dark themes ([c60157c](https://github.com/IBM/kui/commit/c60157c)), closes [#6784](https://github.com/IBM/kui/issues/6784)
- **plugins/plugin-client-common:** tab completion does not render well in minisplits ([8eb0fbc](https://github.com/IBM/kui/commit/8eb0fbc)), closes [#6752](https://github.com/IBM/kui/issues/6752)
- **plugins/plugin-client-common:** tab-completion font-family regression ([13b3d49](https://github.com/IBM/kui/commit/13b3d49)), closes [#6751](https://github.com/IBM/kui/issues/6751)
- **plugins/plugin-client-common:** table and nav content are not left-aligned with breadcrumb ([a8b8015](https://github.com/IBM/kui/commit/a8b8015)), closes [#6741](https://github.com/IBM/kui/issues/6741)
- **plugins/plugin-client-common:** Table onclick handlers applied to every cell ([d5a9c3a](https://github.com/IBM/kui/commit/d5a9c3a)), closes [#6792](https://github.com/IBM/kui/issues/6792)
- **plugins/plugin-client-common:** tables with inferred headers never allow for grid presentation ([a384783](https://github.com/IBM/kui/commit/a384783)), closes [#6763](https://github.com/IBM/kui/issues/6763)
- **plugins/plugin-client-common:** width-constrained NavResponse UI should spend more space on content ([309c6ff](https://github.com/IBM/kui/commit/309c6ff)), closes [#6742](https://github.com/IBM/kui/issues/6742)
- **plugins/plugin-client-common:** With full-width blocks, PatternFly Tables have odd column spacing ([4062489](https://github.com/IBM/kui/commit/4062489)), closes [#6766](https://github.com/IBM/kui/issues/6766)
- **Plugins/plugin-client-common:** replayed notebooks don't always open scrolled to top ([6d71638](https://github.com/IBM/kui/commit/6d71638)), closes [#6824](https://github.com/IBM/kui/issues/6824)
- **plugins/plugin-kubectl:** event watcher doesn't render well in minisplit ([56176de](https://github.com/IBM/kui/commit/56176de)), closes [#6772](https://github.com/IBM/kui/issues/6772)
- in screenshot alert, the icon and title text are misaligned ([ff57573](https://github.com/IBM/kui/commit/ff57573)), closes [#6770](https://github.com/IBM/kui/issues/6770)
- kubectl direct/get does not specify that get tables have the `onclickIdempotent` property ([31361ec](https://github.com/IBM/kui/commit/31361ec)), closes [#6778](https://github.com/IBM/kui/issues/6778)
- **plugins/plugin-client-common:** block action buttons and timestamp may both be visible ([6e63cb7](https://github.com/IBM/kui/commit/6e63cb7)), closes [#5936](https://github.com/IBM/kui/issues/5936)
- **plugins/plugin-client-common:** Drilldown from table isn't always fully in view ([ba1222c](https://github.com/IBM/kui/commit/ba1222c)), closes [#6555](https://github.com/IBM/kui/issues/6555)
- **plugins/plugin-client-common:** Events in tables-as-grid wrap when not needed ([fd46054](https://github.com/IBM/kui/commit/fd46054)), closes [#6600](https://github.com/IBM/kui/issues/6600)
- **plugins/plugin-client-common:** Experimental badge has low contrast in PatternFly4 Light theme ([7c0bfff](https://github.com/IBM/kui/commit/7c0bfff)), closes [#6715](https://github.com/IBM/kui/issues/6715)
- **plugins/plugin-client-common:** first-time edits of commentary may cause editor to lose focus ([81b55e0](https://github.com/IBM/kui/commit/81b55e0)), closes [#6545](https://github.com/IBM/kui/issues/6545)
- **plugins/plugin-client-common:** improve platform compatibility of Home and End keys ([da7393f](https://github.com/IBM/kui/commit/da7393f)), closes [#3267](https://github.com/IBM/kui/issues/3267)
- **plugins/plugin-client-common:** Improve rendering of Source Reference UI ([278b28f](https://github.com/IBM/kui/commit/278b28f)), closes [#6582](https://github.com/IBM/kui/issues/6582)
- **plugins/plugin-client-common:** Markdown component does not properly handle local relative image paths ([deb7b47](https://github.com/IBM/kui/commit/deb7b47)), closes [#6547](https://github.com/IBM/kui/issues/6547)
- **plugins/plugin-client-common:** Markdown handling of consecutive img tags only shows first ([1578e58](https://github.com/IBM/kui/commit/1578e58)), closes [#6602](https://github.com/IBM/kui/issues/6602)
- **plugins/plugin-client-common:** Markdown image does not properly handle align attribute ([5c382f8](https://github.com/IBM/kui/commit/5c382f8)), closes [#6551](https://github.com/IBM/kui/issues/6551)
- **plugins/plugin-client-common:** Markdown renderer does not handle image height attribute ([4d49eb9](https://github.com/IBM/kui/commit/4d49eb9)), closes [#6613](https://github.com/IBM/kui/issues/6613)
- **plugins/plugin-client-common:** Markdown renderer does not properly render tables ([69d45a9](https://github.com/IBM/kui/commit/69d45a9)), closes [#6563](https://github.com/IBM/kui/issues/6563) [#4364](https://github.com/IBM/kui/issues/4364)
- **plugins/plugin-client-common:** Markdown: validateDomNesting console error ([97b2c17](https://github.com/IBM/kui/commit/97b2c17)), closes [#6577](https://github.com/IBM/kui/issues/6577)
- **plugins/plugin-client-common:** new PatternFly TopTabStripe impl changes colors when a NavResponse is displayed ([d2d6a53](https://github.com/IBM/kui/commit/d2d6a53)), closes [#6553](https://github.com/IBM/kui/issues/6553)
- **plugins/plugin-client-common:** new patternfly-based TopTabStripe behaves poorly with narrower windows ([fc97ab8](https://github.com/IBM/kui/commit/fc97ab8)), closes [#6549](https://github.com/IBM/kui/issues/6549)
- **plugins/plugin-client-common:** new tabs don't receive focus for 2 seconds ([1705870](https://github.com/IBM/kui/commit/1705870)), closes [#6668](https://github.com/IBM/kui/issues/6668)
- **plugins/plugin-client-common:** onclick handlers for ls should respond only to clicking on text ([8477386](https://github.com/IBM/kui/commit/8477386)), closes [#6567](https://github.com/IBM/kui/issues/6567)
- **plugins/plugin-client-common:** PatternFly NavResponse does not unexpand ([d1f9dc9](https://github.com/IBM/kui/commit/d1f9dc9)), closes [#6669](https://github.com/IBM/kui/issues/6669)
- **plugins/plugin-client-common:** patternfly Tree component does not load patternfly base ([c38961b](https://github.com/IBM/kui/commit/c38961b)), closes [#6502](https://github.com/IBM/kui/issues/6502)
- **plugins/plugin-client-common:** React warnings in console due to new Modal spi ([57f0cf6](https://github.com/IBM/kui/commit/57f0cf6)), closes [#6696](https://github.com/IBM/kui/issues/6696)
- **plugins/plugin-client-common:** Remove superfluous padding around source ref items ([b821a2b](https://github.com/IBM/kui/commit/b821a2b)), closes [#6731](https://github.com/IBM/kui/issues/6731)
- **plugins/plugin-client-common:** repl context will overflow when scrollback has over 100 inputs ([9c84721](https://github.com/IBM/kui/commit/9c84721)), closes [#6646](https://github.com/IBM/kui/issues/6646)
- **plugins/plugin-client-common:** status stripe "dropdown" menus can have poor color contrast ([fda4ee6](https://github.com/IBM/kui/commit/fda4ee6)), closes [#6706](https://github.com/IBM/kui/issues/6706)
- **plugins/plugin-client-common:** tab completion can be flakey ([145d1a5](https://github.com/IBM/kui/commit/145d1a5)), closes [#6649](https://github.com/IBM/kui/issues/6649)
- **plugins/plugin-kubectl:** events watching returns an empty table with just a streaming events footer ([fbeae76](https://github.com/IBM/kui/commit/fbeae76)), closes [#2771](https://github.com/IBM/kui/issues/2771)
- **plugins/plugin-kubectl:** show SourceRef when creating heterogeneous resources ([adb21c5](https://github.com/IBM/kui/commit/adb21c5)), closes [#6640](https://github.com/IBM/kui/issues/6640)
- ctrl+L in the first block makes the prompt inactive ([232e5e1](https://github.com/IBM/kui/commit/232e5e1)), closes [#6597](https://github.com/IBM/kui/issues/6597)
- In narrower windows, there is too much content in the StatusStripe ([453bc86](https://github.com/IBM/kui/commit/453bc86)), closes [#6570](https://github.com/IBM/kui/issues/6570)
- in patternfly-based themes, CurrentContext DropDown renders poorly ([f1a3faf](https://github.com/IBM/kui/commit/f1a3faf)), closes [#6496](https://github.com/IBM/kui/issues/6496)
- kubectl contexts table has odd CURRENT column ([f6d0a98](https://github.com/IBM/kui/commit/f6d0a98)), closes [#6523](https://github.com/IBM/kui/issues/6523)
- kubectl get -f --watch doesn't watch ([e45e8ee](https://github.com/IBM/kui/commit/e45e8ee)), closes [#6588](https://github.com/IBM/kui/issues/6588)
- kubectl kustomize can have bogus output ([8bf8ebe](https://github.com/IBM/kui/commit/8bf8ebe)), closes [#6114](https://github.com/IBM/kui/issues/6114)
- ls clicks that do another ls should not open a split ([fc0873b](https://github.com/IBM/kui/commit/fc0873b)), closes [#6565](https://github.com/IBM/kui/issues/6565)
- **plugins/plugin-client-common:** `ls` in minisplit has tall rows ([00b5e41](https://github.com/IBM/kui/commit/00b5e41)), closes [#6289](https://github.com/IBM/kui/issues/6289)
- **plugins/plugin-client-common:** a few minor UI glitches in Block css ([a25c72c](https://github.com/IBM/kui/commit/a25c72c)), closes [#6335](https://github.com/IBM/kui/issues/6335)
- **plugins/plugin-client-common:** as sequence diagram nRows grows, rows shrink, but fonts do not ([eac0220](https://github.com/IBM/kui/commit/eac0220)), closes [#6420](https://github.com/IBM/kui/issues/6420)
- **plugins/plugin-client-common:** blocks with no input or output shouldn't have a background color ([42b5b01](https://github.com/IBM/kui/commit/42b5b01)), closes [#6367](https://github.com/IBM/kui/issues/6367)
- **plugins/plugin-client-common:** DiffEditor does not respond to resize events ([7f88934](https://github.com/IBM/kui/commit/7f88934)), closes [#6365](https://github.com/IBM/kui/issues/6365)
- **plugins/plugin-client-common:** double whitespace may be removed from completed inputs ([fc0c0db](https://github.com/IBM/kui/commit/fc0c0db)), closes [#6279](https://github.com/IBM/kui/issues/6279)
- **plugins/plugin-client-common:** DropdownWidget does not obey `title` property ([e534cbc](https://github.com/IBM/kui/commit/e534cbc)), closes [#6393](https://github.com/IBM/kui/issues/6393)
- **plugins/plugin-client-common:** Experimental badge too tall for lightweight UI themes. ([57b1f51](https://github.com/IBM/kui/commit/57b1f51)), closes [#6284](https://github.com/IBM/kui/issues/6284)
- **plugins/plugin-client-common:** in lightweight themes, hover on sequence diagram rows may result in errant border-top ([679498f](https://github.com/IBM/kui/commit/679498f)), closes [#6251](https://github.com/IBM/kui/issues/6251)
- **plugins/plugin-client-common:** in lightweight ui themes, markdown content has odd font spacing ([b114221](https://github.com/IBM/kui/commit/b114221)), closes [#6249](https://github.com/IBM/kui/issues/6249)
- **plugins/plugin-client-common:** in minisplits, no margin between active block and previous response ([e20c115](https://github.com/IBM/kui/commit/e20c115)), closes [#6333](https://github.com/IBM/kui/issues/6333)
- **plugins/plugin-client-common:** in PatternFly Light theme, status stripe hovers and borders are not visible ([8bfc9a1](https://github.com/IBM/kui/commit/8bfc9a1)), closes [#6324](https://github.com/IBM/kui/issues/6324)
- **plugins/plugin-client-common:** in patternfly-based components, the CurrentContext widget has poor alignment ([c6f873c](https://github.com/IBM/kui/commit/c6f873c)), closes [#6494](https://github.com/IBM/kui/issues/6494)
- **plugins/plugin-client-common:** inline sidecar should not have a min-width ([11a0cfb](https://github.com/IBM/kui/commit/11a0cfb)), closes [#6270](https://github.com/IBM/kui/issues/6270)
- **plugins/plugin-client-common:** input element is not distinct enough in lightweight ui themes with splits ([01b3e40](https://github.com/IBM/kui/commit/01b3e40)), closes [#6247](https://github.com/IBM/kui/issues/6247)
- **plugins/plugin-client-common:** inverted color context in mini splits can have low contrast ([2541d74](https://github.com/IBM/kui/commit/2541d74)), closes [#6383](https://github.com/IBM/kui/issues/6383)
- **plugins/plugin-client-common:** kubectl help sometimes does not line wrap properly ([b66928b](https://github.com/IBM/kui/commit/b66928b)), closes [#6425](https://github.com/IBM/kui/issues/6425)
- **plugins/plugin-client-common:** LeftNav UIs can be too wide ([5dae64c](https://github.com/IBM/kui/commit/5dae64c)), closes [#6302](https://github.com/IBM/kui/issues/6302)
- **plugins/plugin-client-common:** ls ; ls has excessive vertical whitespace ([1b41c59](https://github.com/IBM/kui/commit/1b41c59)), closes [#6291](https://github.com/IBM/kui/issues/6291)
- **plugins/plugin-client-common:** minor Output alignment regression ([91442ad](https://github.com/IBM/kui/commit/91442ad)), closes [#6438](https://github.com/IBM/kui/issues/6438)
- **plugins/plugin-client-common:** monaco editor always consumes mouse wheel scrolling events ([bed75eb](https://github.com/IBM/kui/commit/bed75eb)), closes [#6480](https://github.com/IBM/kui/issues/6480)
- **plugins/plugin-client-common:** patternfly popover close button has odd spacing ([e7c21fd](https://github.com/IBM/kui/commit/e7c21fd)), closes [#6345](https://github.com/IBM/kui/issues/6345)
- **plugins/plugin-client-common:** Popup mode client has a few status stripe rendering issues ([57bb8b2](https://github.com/IBM/kui/commit/57bb8b2)), closes [#6357](https://github.com/IBM/kui/issues/6357)
- **plugins/plugin-client-common:** refine input UI for lightweight ui themes ([c479cdb](https://github.com/IBM/kui/commit/c479cdb)), closes [#6296](https://github.com/IBM/kui/issues/6296)
- **plugins/plugin-client-common:** Rendering glitches in carbon fonts for status stripe DropdownWidgets ([1ee18a6](https://github.com/IBM/kui/commit/1ee18a6)), closes [#6359](https://github.com/IBM/kui/issues/6359)
- **plugins/plugin-client-common:** sometimes response is not scrolled into view properly ([a2fae6a](https://github.com/IBM/kui/commit/a2fae6a)), closes [#6479](https://github.com/IBM/kui/issues/6479)
- Clean up the way patternfly fonts are incorporated into themes ([2ba49e9](https://github.com/IBM/kui/commit/2ba49e9)), closes [#6375](https://github.com/IBM/kui/issues/6375)
- DIffEditor should render inline when in terminal split ([b86b127](https://github.com/IBM/kui/commit/b86b127)), closes [#6366](https://github.com/IBM/kui/issues/6366)
- drilldown from an undeployed application in tree will issue a kubectl get with 404 ([309a9a0](https://github.com/IBM/kui/commit/309a9a0)), closes [#6331](https://github.com/IBM/kui/issues/6331)
- in patternfly4 light theme, the status stripe hovers background color are not visible ([a0e79d5](https://github.com/IBM/kui/commit/a0e79d5)), closes [#6361](https://github.com/IBM/kui/issues/6361)
- keyboard history navigation does not work in Popup clients ([89197ba](https://github.com/IBM/kui/commit/89197ba)), closes [#6262](https://github.com/IBM/kui/issues/6262)
- s3 job watcher sometimes fails due to startup issues ([8851d50](https://github.com/IBM/kui/commit/8851d50)), closes [#6411](https://github.com/IBM/kui/issues/6411)
- SequenceDiagram bar widths are pretty buggy ([6d1c458](https://github.com/IBM/kui/commit/6d1c458)), closes [#6408](https://github.com/IBM/kui/issues/6408)
- UpdateChecker popover can be too height ([8f87488](https://github.com/IBM/kui/commit/8f87488)), closes [#6413](https://github.com/IBM/kui/issues/6413)
- **plugins/plugin-client-common:** PatternFly themes are still using a carbon icon for Split ([4c05d28](https://github.com/IBM/kui/commit/4c05d28)), closes [#6322](https://github.com/IBM/kui/issues/6322)
- **plugins/plugin-client-common:** Popup mode input stripe does not have reliable auto-focus behavior ([ac3935e](https://github.com/IBM/kui/commit/ac3935e)), closes [#6266](https://github.com/IBM/kui/issues/6266)
- **plugins/plugin-client-common:** processing block disappears in minisplits ([907a9d5](https://github.com/IBM/kui/commit/907a9d5)), closes [#6310](https://github.com/IBM/kui/issues/6310)
- **plugins/plugin-client-common:** red and green overlays in diff views are hard to see ([1843bff](https://github.com/IBM/kui/commit/1843bff)), closes [#6363](https://github.com/IBM/kui/issues/6363)
- **plugins/plugin-client-common:** sidecar toolbar text is not always vertically centered ([cbceee3](https://github.com/IBM/kui/commit/cbceee3)), closes [#6305](https://github.com/IBM/kui/issues/6305)
- **plugins/plugin-client-common:** TopTabStripe for Lightweight UI themes could be a bit lighter-weight ([8d0e144](https://github.com/IBM/kui/commit/8d0e144)), closes [#6398](https://github.com/IBM/kui/issues/6398)
- tree should support leaf node drilling down ([006b881](https://github.com/IBM/kui/commit/006b881)), closes [#6293](https://github.com/IBM/kui/issues/6293)
- Tree view badges can have low contrast ([9be1ae5](https://github.com/IBM/kui/commit/9be1ae5)), closes [#6245](https://github.com/IBM/kui/issues/6245)
- **plugins/plugin-client-common:** font size issues with lightweight ui in tree view ([575ced0](https://github.com/IBM/kui/commit/575ced0)), closes [#6228](https://github.com/IBM/kui/issues/6228) [#6229](https://github.com/IBM/kui/issues/6229)
- **plugins/plugin-client-common:** prompt focus may not be restored when switching tabs ([5e81db9](https://github.com/IBM/kui/commit/5e81db9)), closes [#6239](https://github.com/IBM/kui/issues/6239)
- **plugins/plugin-kubectl:** unlabeled resources shouldn’t have badge for children's count ([4e1fea6](https://github.com/IBM/kui/commit/4e1fea6)), closes [#6243](https://github.com/IBM/kui/issues/6243)
- @patternfly/react-core breaks the indentation of TreeView ([f5c5253](https://github.com/IBM/kui/commit/f5c5253)), closes [#6224](https://github.com/IBM/kui/issues/6224)
- block timestamp in Light theme/lightweight ui has low contrast ([6ae08fd](https://github.com/IBM/kui/commit/6ae08fd)), closes [#6226](https://github.com/IBM/kui/issues/6226)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- PatternFly 2012.14 breaks the indentation of TreeView ([f052d71](https://github.com/IBM/kui/commit/f052d71)), closes [#6224](https://github.com/IBM/kui/issues/6224)
- **plugins/plugin-client-common:** adjust TopTabStripe for lightweight ui themes ([00ee896](https://github.com/IBM/kui/commit/00ee896)), closes [#6204](https://github.com/IBM/kui/issues/6204)
- **plugins/plugin-client-common:** after Electron 10 update, ls output can render poorly ([1b7010b](https://github.com/IBM/kui/commit/1b7010b)), closes [#6147](https://github.com/IBM/kui/issues/6147)
- **plugins/plugin-client-common:** clicking the editor in carbon accordion will change the accordion label ([ce3fe02](https://github.com/IBM/kui/commit/ce3fe02)), closes [#6107](https://github.com/IBM/kui/issues/6107)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([3400431](https://github.com/IBM/kui/commit/3400431)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([f93fe2b](https://github.com/IBM/kui/commit/f93fe2b)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** events in tree should stay scrolled to the bottom as events come in ([c5efedd](https://github.com/IBM/kui/commit/c5efedd)), closes [#6164](https://github.com/IBM/kui/issues/6164)
- **plugins/plugin-client-common:** externalize PatternFly TreeView component to SPI ([486a02e](https://github.com/IBM/kui/commit/486a02e)), closes [#6134](https://github.com/IBM/kui/issues/6134)
- **plugins/plugin-client-common:** for lightweight ui themes, also show block duration in highlight color ([da3a3a7](https://github.com/IBM/kui/commit/da3a3a7)), closes [#6222](https://github.com/IBM/kui/issues/6222)
- **plugins/plugin-client-common:** in carbon-based dark themes, the SourceRef expando text is not visible ([0b462f5](https://github.com/IBM/kui/commit/0b462f5)), closes [#6197](https://github.com/IBM/kui/issues/6197)
- **plugins/plugin-client-common:** in some cases, Editor may present "you are in edit mode" for readOnly instantiations ([e3e7c16](https://github.com/IBM/kui/commit/e3e7c16)), closes [#6116](https://github.com/IBM/kui/issues/6116)
- **plugins/plugin-client-common:** lightweight ui has a few remaining "heavy" elements ([afef54a](https://github.com/IBM/kui/commit/afef54a)), closes [#6195](https://github.com/IBM/kui/issues/6195)
- **plugins/plugin-client-common:** lightweight ui: minisplits should not have the opacity filter ([96860f3](https://github.com/IBM/kui/commit/96860f3)), closes [#6198](https://github.com/IBM/kui/issues/6198)
- **plugins/plugin-client-common:** pack table rows more densely in lightweight UI themes ([bcb3f23](https://github.com/IBM/kui/commit/bcb3f23)), closes [#6217](https://github.com/IBM/kui/issues/6217)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- remove TreeResponse and PatternFly Tree Component ([e539a53](https://github.com/IBM/kui/commit/e539a53)), closes [#6581](https://github.com/IBM/kui/issues/6581) [#6328](https://github.com/IBM/kui/issues/6328)
- **plugins/plugin-client-common:** height of TreeView events should match that of sidecar header ([bba1ccd](https://github.com/IBM/kui/commit/bba1ccd)), closes [#6174](https://github.com/IBM/kui/issues/6174)
- **plugins/plugin-client-common:** in lightweight presentation mode, lighten up sidecar a bit ([c73c080](https://github.com/IBM/kui/commit/c73c080)), closes [#6202](https://github.com/IBM/kui/issues/6202) [#6201](https://github.com/IBM/kui/issues/6201)
- **plugins/plugin-client-common:** PatternFly's CodeSnippet rendering issues ([48f30fa](https://github.com/IBM/kui/commit/48f30fa)), closes [#6542](https://github.com/IBM/kui/issues/6542) [#6544](https://github.com/IBM/kui/issues/6544)
- **plugins/plugin-client-common:** RadioTable has small font size ([19f758a](https://github.com/IBM/kui/commit/19f758a)), closes [#6102](https://github.com/IBM/kui/issues/6102)
- **plugins/plugin-client-common:** removing previous blocks will cause errant rendering to edit command result ([6594e8c](https://github.com/IBM/kui/commit/6594e8c)), closes [#6093](https://github.com/IBM/kui/issues/6093)
- **plugins/plugin-client-common:** Rendering of markdown files could be improved ([23d6e75](https://github.com/IBM/kui/commit/23d6e75)), closes [#6557](https://github.com/IBM/kui/issues/6557)
- **plugins/plugin-client-common:** Rendering of markdown incorrectly inherits white-space:nowrap from repl ([d66b8b2](https://github.com/IBM/kui/commit/d66b8b2)), closes [#6575](https://github.com/IBM/kui/issues/6575)
- **plugins/plugin-client-common:** sequence diagram does not display well with lightweight ui ([e746cc6](https://github.com/IBM/kui/commit/e746cc6)), closes [#6189](https://github.com/IBM/kui/issues/6189)
- **plugins/plugin-client-common:** small regression in top tab stripe height ([0b07d35](https://github.com/IBM/kui/commit/0b07d35)), closes [#6211](https://github.com/IBM/kui/issues/6211)
- default chart colors should not use blue-red diverging spectrum ([918ab9c](https://github.com/IBM/kui/commit/918ab9c)), closes [#6191](https://github.com/IBM/kui/issues/6191)
- use Dropdown component for RadioTable impl ([244b16a](https://github.com/IBM/kui/commit/244b16a)), closes [#6539](https://github.com/IBM/kui/issues/6539)
- **plugins/plugin-client-common:** SequenceDiagram can overflow 100% width ([d631fd9](https://github.com/IBM/kui/commit/d631fd9)), closes [#6159](https://github.com/IBM/kui/issues/6159)
- **plugins/plugin-client-common:** show table click result in a new split ([fd1b3a1](https://github.com/IBM/kui/commit/fd1b3a1)), closes [#6477](https://github.com/IBM/kui/issues/6477)
- **plugins/plugin-client-common:** sidecar editor too-aggressively focuses ([8077cec](https://github.com/IBM/kui/commit/8077cec)), closes [#6104](https://github.com/IBM/kui/issues/6104)
- **plugins/plugin-client-common:** sidecar maximization is a bit off when in a split ([f103379](https://github.com/IBM/kui/commit/f103379)), closes [#6531](https://github.com/IBM/kui/issues/6531)
- **plugins/plugin-client-common:** table sorting may result in bad drilldown onclicks ([17d75c3](https://github.com/IBM/kui/commit/17d75c3)), closes [#6524](https://github.com/IBM/kui/issues/6524)
- **plugins/plugin-client-common:** Tree Component tweaks ([2f21e22](https://github.com/IBM/kui/commit/2f21e22)), closes [#6158](https://github.com/IBM/kui/issues/6158) [#6157](https://github.com/IBM/kui/issues/6157)
- **plugins/plugin-client-common:** typo "soild" in Tree.scss ([1a64ccd](https://github.com/IBM/kui/commit/1a64ccd)), closes [#6172](https://github.com/IBM/kui/issues/6172)
- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- **plugins-client-common:** the experimental tag should use sans serif ([143464a](https://github.com/IBM/kui/commit/143464a)), closes [#5363](https://github.com/IBM/kui/issues/5363)
- **plugins/plugin-client-common:** add error icon for error blocks ([5d9aeea](https://github.com/IBM/kui/commit/5d9aeea)), closes [#4907](https://github.com/IBM/kui/issues/4907)
- **plugins/plugin-client-common:** always place table events in the Card footer ([b667b28](https://github.com/IBM/kui/commit/b667b28)), closes [#5210](https://github.com/IBM/kui/issues/5210)
- **plugins/plugin-client-common:** buggy header UI in dark themes in minisplits ([55aef48](https://github.com/IBM/kui/commit/55aef48)), closes [#5266](https://github.com/IBM/kui/issues/5266)
- **plugins/plugin-client-common:** carbon breadcrumbs may not have proper hover effect ([c8cd2d1](https://github.com/IBM/kui/commit/c8cd2d1)), closes [#4962](https://github.com/IBM/kui/issues/4962)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** clicking on pod delete button can cause command to be executed in minisplit ([37f9019](https://github.com/IBM/kui/commit/37f9019)), closes [#5247](https://github.com/IBM/kui/issues/5247)
- **plugins/plugin-client-common:** clicking the remove button of a repl block results in an error white screen ([49bfbcc](https://github.com/IBM/kui/commit/49bfbcc)), closes [#4855](https://github.com/IBM/kui/issues/4855)
- **plugins/plugin-client-common:** clicking to focus on a split does not always cause full focus effect ([bc59bcf](https://github.com/IBM/kui/commit/bc59bcf)), closes [#5263](https://github.com/IBM/kui/issues/5263)
- **plugins/plugin-client-common:** close tabs doesn't produce the correct tab content ([6090887](https://github.com/IBM/kui/commit/6090887)), closes [#5220](https://github.com/IBM/kui/issues/5220)
- **plugins/plugin-client-common:** CSS no longer is reactive to narrow window ([4eb0a11](https://github.com/IBM/kui/commit/4eb0a11)), closes [#5290](https://github.com/IBM/kui/issues/5290)
- **plugins/plugin-client-common:** don't line-wrap input elements in MiniSplits ([c929f5e](https://github.com/IBM/kui/commit/c929f5e)), closes [#5348](https://github.com/IBM/kui/issues/5348)
- **plugins/plugin-client-common:** don't use fixed maxHeight for Terminal tables ([0e23e22](https://github.com/IBM/kui/commit/0e23e22)), closes [#5206](https://github.com/IBM/kui/issues/5206)
- **plugins/plugin-client-common:** Events drilldown from watch table does not always work ([09aee73](https://github.com/IBM/kui/commit/09aee73)), closes [#5204](https://github.com/IBM/kui/issues/5204)
- **plugins/plugin-client-common:** Events footer in minisplit tables lacks horizontal padding ([f22b1f7](https://github.com/IBM/kui/commit/f22b1f7)), closes [#5196](https://github.com/IBM/kui/issues/5196)
- **plugins/plugin-client-common:** Events should also be placed in table footer (not tbody) when sidecar is open or 2-way terminal split ([1391b1d](https://github.com/IBM/kui/commit/1391b1d)), closes [#5198](https://github.com/IBM/kui/issues/5198)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve behavior of up arrow for first command in MiniSplits ([ed199d4](https://github.com/IBM/kui/commit/ed199d4)), closes [#5297](https://github.com/IBM/kui/issues/5297)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** improve display of tables in side-by-side terminal splits ([5a32255](https://github.com/IBM/kui/commit/5a32255)), closes [#5201](https://github.com/IBM/kui/issues/5201)
- **plugins/plugin-client-common:** improve spacing of Event footer content ([d63a6f1](https://github.com/IBM/kui/commit/d63a6f1)), closes [#5178](https://github.com/IBM/kui/issues/5178)
- **plugins/plugin-client-common:** improve Terminal screenshots by adding padding ([a9b7b26](https://github.com/IBM/kui/commit/a9b7b26)), closes [#4981](https://github.com/IBM/kui/issues/4981)
- **plugins/plugin-client-common:** in plain Terminals, tables should not inner scroll ([15fcbba](https://github.com/IBM/kui/commit/15fcbba)), closes [#5221](https://github.com/IBM/kui/issues/5221)
- **plugins/plugin-client-common:** in Popup mode, use > rather than / for prompt in bottom input ([1360bed](https://github.com/IBM/kui/commit/1360bed)), closes [#4887](https://github.com/IBM/kui/issues/4887)
- **plugins/plugin-client-common:** inconsistent top padding above Cards ([1e1037f](https://github.com/IBM/kui/commit/1e1037f)), closes [#5299](https://github.com/IBM/kui/issues/5299)
- **plugins/plugin-client-common:** increase density of SequenceDiagram ([ae29488](https://github.com/IBM/kui/commit/ae29488)), closes [#5344](https://github.com/IBM/kui/issues/5344)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** kubectl edit saves can result in unstyled notification ([5dc658e](https://github.com/IBM/kui/commit/5dc658e)), closes [#4930](https://github.com/IBM/kui/issues/4930)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** long input lines should line wrap ([8804bb1](https://github.com/IBM/kui/commit/8804bb1)), closes [#5338](https://github.com/IBM/kui/issues/5338)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** minor improvements for ls -l output ([1b59c94](https://github.com/IBM/kui/commit/1b59c94)), closes [#5216](https://github.com/IBM/kui/issues/5216)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** multi-line paste executes commands out of order ([8f39c80](https://github.com/IBM/kui/commit/8f39c80)), closes [#5295](https://github.com/IBM/kui/issues/5295)
- **plugins/plugin-client-common:** only highlight the Active block in the focused split ([feffad4](https://github.com/IBM/kui/commit/feffad4)), closes [#5261](https://github.com/IBM/kui/issues/5261)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** place event footer outside of table scroll region for minisplits ([e4872b2](https://github.com/IBM/kui/commit/e4872b2)), closes [#5179](https://github.com/IBM/kui/issues/5179)
- **plugins/plugin-client-common:** poor alignment of sidecar toolbar elements ([2307a46](https://github.com/IBM/kui/commit/2307a46)), closes [#4970](https://github.com/IBM/kui/issues/4970)
- **plugins/plugin-client-common:** present more than 2 footer lines in watch tables ([3e7a78f](https://github.com/IBM/kui/commit/3e7a78f)), closes [#5213](https://github.com/IBM/kui/issues/5213)
- **plugins/plugin-client-common:** pty commands fail in minisplits ([475ea74](https://github.com/IBM/kui/commit/475ea74)), closes [#5267](https://github.com/IBM/kui/issues/5267)
- **plugins/plugin-client-common:** reduce contrast of block left bars ([7c8d371](https://github.com/IBM/kui/commit/7c8d371)), closes [#5275](https://github.com/IBM/kui/issues/5275)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** regression in table width with sidecar open ([5938806](https://github.com/IBM/kui/commit/5938806)), closes [#5194](https://github.com/IBM/kui/issues/5194)
- **plugins/plugin-client-common:** regression: non-empty repl output has 'ok' at the end ([103a0f9](https://github.com/IBM/kui/commit/103a0f9)), closes [#4924](https://github.com/IBM/kui/issues/4924)
- **plugins/plugin-client-common:** restore history navigation behavior in minisplits ([26f49e8](https://github.com/IBM/kui/commit/26f49e8)), closes [#5375](https://github.com/IBM/kui/issues/5375)
- **plugins/plugin-client-common:** reverse-i-search does not properly report no matches ([c16dad3](https://github.com/IBM/kui/commit/c16dad3)), closes [#4943](https://github.com/IBM/kui/issues/4943)
- **plugins/plugin-client-common:** Screenshot modal never goes away ([bbd1c98](https://github.com/IBM/kui/commit/bbd1c98)), closes [#4979](https://github.com/IBM/kui/issues/4979)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- **plugins/plugin-client-common:** split button errors are not reported to the user ([fc4e2a2](https://github.com/IBM/kui/commit/fc4e2a2)), closes [#4876](https://github.com/IBM/kui/issues/4876)
- **plugins/plugin-client-common:** spurious warning in the console re: Tag ([93982de](https://github.com/IBM/kui/commit/93982de)), closes [#4959](https://github.com/IBM/kui/issues/4959)
- **plugins/plugin-client-common:** status cells of live tables do not always blink ([c94b05e](https://github.com/IBM/kui/commit/c94b05e)), closes [#4903](https://github.com/IBM/kui/issues/4903)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugin-client-common:** tab completion UI does not render on separate line from input ([61b169b](https://github.com/IBM/kui/commit/61b169b)), closes [#5307](https://github.com/IBM/kui/issues/5307)
- **plugins/plugin-client-common:** TableCell view can fail when given empty duration cells ([04251be](https://github.com/IBM/kui/commit/04251be)), closes [#5332](https://github.com/IBM/kui/issues/5332)
- Editor component does not respond to tab layout changes ([9756336](https://github.com/IBM/kui/commit/9756336)), closes [#5231](https://github.com/IBM/kui/issues/5231) [#5232](https://github.com/IBM/kui/issues/5232)
- multiple command history regressions ([cbba96c](https://github.com/IBM/kui/commit/cbba96c)), closes [#5283](https://github.com/IBM/kui/issues/5283)
- switching splits does not participate in tab state ([6eb8db4](https://github.com/IBM/kui/commit/6eb8db4)), closes [#5272](https://github.com/IBM/kui/issues/5272)
- **plugins/plugin-client-common:** "No resources" in watch pane can occlude watch pane title ([e4fd93a](https://github.com/IBM/kui/commit/e4fd93a)), closes [#5064](https://github.com/IBM/kui/issues/5064)
- **plugins/plugin-client-common:** `ok` string appears at the end of MixResponse ([75606c5](https://github.com/IBM/kui/commit/75606c5)), closes [#5046](https://github.com/IBM/kui/issues/5046)
- **plugins/plugin-client-common:** a few more rem/em font-size issues ([133b347](https://github.com/IBM/kui/commit/133b347)), closes [#5058](https://github.com/IBM/kui/issues/5058)
- **plugins/plugin-client-common:** borders in top tab stripe are too light ([3908695](https://github.com/IBM/kui/commit/3908695)), closes [#5051](https://github.com/IBM/kui/issues/5051)
- **plugins/plugin-client-common:** clearing Terminal does not abort watchers ([34adb50](https://github.com/IBM/kui/commit/34adb50)), closes [#5116](https://github.com/IBM/kui/issues/5116)
- **plugins/plugin-client-common:** clicking 'remove' of a watchable response doesn't abort the underlying pty job ([7eb69fb](https://github.com/IBM/kui/commit/7eb69fb)), closes [#5090](https://github.com/IBM/kui/issues/5090)
- **plugins/plugin-client-common:** decrease height of table footer ([5863622](https://github.com/IBM/kui/commit/5863622)), closes [#5072](https://github.com/IBM/kui/issues/5072)
- **plugins/plugin-client-common:** disableTableTitle also disables title of watch panes ([053cfb6](https://github.com/IBM/kui/commit/053cfb6)), closes [#5036](https://github.com/IBM/kui/issues/5036)
- **plugins/plugin-client-common:** double watch panes may open up ([7fb70f1](https://github.com/IBM/kui/commit/7fb70f1)), closes [#5034](https://github.com/IBM/kui/issues/5034)
- **plugins/plugin-client-common:** editor component does not respond to font zooming ([7b7e0f3](https://github.com/IBM/kui/commit/7b7e0f3)), closes [#5120](https://github.com/IBM/kui/issues/5120)
- **plugins/plugin-client-common:** eliminate react "titleInHeader" console warnings ([8cf3797](https://github.com/IBM/kui/commit/8cf3797)), closes [#5078](https://github.com/IBM/kui/issues/5078)
- **plugins/plugin-client-common:** font size issues with LeftNavSidecar ([e17fc15](https://github.com/IBM/kui/commit/e17fc15)), closes [#5048](https://github.com/IBM/kui/issues/5048)
- **plugins/plugin-client-common:** improve top tab bottom UI ([8ff4151](https://github.com/IBM/kui/commit/8ff4151)), closes [#5056](https://github.com/IBM/kui/issues/5056)
- **plugins/plugin-client-common:** input may not receive focus on tab switch ([7676792](https://github.com/IBM/kui/commit/7676792)), closes [#5102](https://github.com/IBM/kui/issues/5102)
- **plugins/plugin-client-common:** layout regressions from table screenshot PRs ([8004ee3](https://github.com/IBM/kui/commit/8004ee3)), closes [#5159](https://github.com/IBM/kui/issues/5159)
- **plugins/plugin-client-common:** leftover debug printfs in table sorting ([9889b49](https://github.com/IBM/kui/commit/9889b49)), closes [#5030](https://github.com/IBM/kui/issues/5030)
- **plugins/plugin-client-common:** Light tables should use Carbon compact ([2309ec3](https://github.com/IBM/kui/commit/2309ec3)), closes [#5059](https://github.com/IBM/kui/issues/5059)
- **plugins/plugin-client-common:** one-row tables needn't offer column sorting UI ([5184fa1](https://github.com/IBM/kui/commit/5184fa1)), closes [#5050](https://github.com/IBM/kui/issues/5050)
- **plugins/plugin-client-common:** RadioTable screenshots lack box shadow ([b0e0f2e](https://github.com/IBM/kui/commit/b0e0f2e)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** RadioTables can have gratuituous line wrapping ([9c39682](https://github.com/IBM/kui/commit/9c39682)), closes [#5139](https://github.com/IBM/kui/issues/5139)
- **plugins/plugin-client-common:** RadioTables in minisplits inner-scroll away the header row ([5296dcd](https://github.com/IBM/kui/commit/5296dcd)), closes [#5165](https://github.com/IBM/kui/issues/5165)
- **plugins/plugin-client-common:** selected row in RadioTables in dark themes has low contrast ([f2c5834](https://github.com/IBM/kui/commit/f2c5834)), closes [#5161](https://github.com/IBM/kui/issues/5161)
- **plugins/plugin-client-common:** sidecar badges may not be flush-right ([5b54665](https://github.com/IBM/kui/commit/5b54665)), closes [#5175](https://github.com/IBM/kui/issues/5175)
- **plugins/plugin-client-common:** status column can be invisible in split tables ([c352103](https://github.com/IBM/kui/commit/c352103)), closes [#5244](https://github.com/IBM/kui/issues/5244)
- **plugins/plugin-client-common:** Tables should have a max-height and use inner scrolling for overflow ([642ef14](https://github.com/IBM/kui/commit/642ef14)), closes [#5153](https://github.com/IBM/kui/issues/5153)
- **plugins/plugin-client-common:** Tables with identical column names render incorrectly ([161dba2](https://github.com/IBM/kui/commit/161dba2)), closes [#5129](https://github.com/IBM/kui/issues/5129)
- **plugins/plugin-client-common:** Terminal Block -> Screenshot of table does not capture box shadow ([ed812f3](https://github.com/IBM/kui/commit/ed812f3)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** Terminal focus changes unexpectedly ([866451c](https://github.com/IBM/kui/commit/866451c)), closes [#5170](https://github.com/IBM/kui/issues/5170)
- **plugins/plugin-client-common:** two MiniSplits with open sidecar are too short ([9e21ab9](https://github.com/IBM/kui/commit/9e21ab9)), closes [#5171](https://github.com/IBM/kui/issues/5171)
- **plugins/plugin-client-common:** watch pane grid cells too large ([225f937](https://github.com/IBM/kui/commit/225f937)), closes [#5070](https://github.com/IBM/kui/issues/5070)
- **plugins/plugin-client-common:** watch tables might not be maximized in minisplits ([63420b2](https://github.com/IBM/kui/commit/63420b2)), closes [#5218](https://github.com/IBM/kui/issues/5218)
- **plugins/plugin-client-commong:** show RadioTable selected row in the table body and header breadcrumb ([811c21e](https://github.com/IBM/kui/commit/811c21e)), closes [#5239](https://github.com/IBM/kui/issues/5239)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- Card component does not render well in dark themes ([d96def0](https://github.com/IBM/kui/commit/d96def0)), closes [#4996](https://github.com/IBM/kui/issues/4996)
- clients should be able to enable watcher auto pinning without enabling splitTerminals ([bcade13](https://github.com/IBM/kui/commit/bcade13)), closes [#5002](https://github.com/IBM/kui/issues/5002)
- move default loadingDone icon into plugin-client-common ([39994bc](https://github.com/IBM/kui/commit/39994bc)), closes [#5026](https://github.com/IBM/kui/issues/5026)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-client-common:** WatchPane has incorrect padding ([e74bd7b](https://github.com/IBM/kui/commit/e74bd7b)), closes [#5015](https://github.com/IBM/kui/issues/5015)
- **plugins/plugin-client-default:** improve debug logging of client properties ([4daba1f](https://github.com/IBM/kui/commit/4daba1f)), closes [#5088](https://github.com/IBM/kui/issues/5088)
- **plugins/plugin-core-support:** sidecar "window" buttons are too large ([33415d2](https://github.com/IBM/kui/commit/33415d2)), closes [#5094](https://github.com/IBM/kui/issues/5094)
- Confirm dialog color contrast issues ([da14c25](https://github.com/IBM/kui/commit/da14c25)), closes [#4995](https://github.com/IBM/kui/issues/4995)
- increase contrast in watch pane ([246ecd2](https://github.com/IBM/kui/commit/246ecd2)), closes [#5000](https://github.com/IBM/kui/issues/5000) [#5001](https://github.com/IBM/kui/issues/5001)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- move patternfly alignment out of patternfly themes plugin ([6adbfd6](https://github.com/IBM/kui/commit/6adbfd6)), closes [#4988](https://github.com/IBM/kui/issues/4988)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- still see name-related breadcrumbs and short-name header with feature flag sidecarName 'heroText' ([1a8be9f](https://github.com/IBM/kui/commit/1a8be9f)), closes [#5013](https://github.com/IBM/kui/issues/5013)
- **plugins/plugin-client-common:** UpdateNotification widget has invisible background color ([c0c1d82](https://github.com/IBM/kui/commit/c0c1d82)), closes [#4968](https://github.com/IBM/kui/issues/4968)
- **plugins/plugin-patternfly-themes:** update theme alignment to patternfly v4 ([3784b96](https://github.com/IBM/kui/commit/3784b96)), closes [#4948](https://github.com/IBM/kui/issues/4948)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- erratic scroll region behavior ([be0e2a0](https://github.com/IBM/kui/commit/be0e2a0)), closes [#4898](https://github.com/IBM/kui/issues/4898)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- page-content p should not use text-align: justify ([2646f4b](https://github.com/IBM/kui/commit/2646f4b)), closes [#4908](https://github.com/IBM/kui/issues/4908)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- sidecar back/forward should be ordered by visitation rather than insertion ([fba613a](https://github.com/IBM/kui/commit/fba613a)), closes [#4746](https://github.com/IBM/kui/issues/4746)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- split screen terminals sometimes incorrect handle exit ([d63cde7](https://github.com/IBM/kui/commit/d63cde7)), closes [#4860](https://github.com/IBM/kui/issues/4860)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- TopNavSidecar doesn't return to the previous selected Tab when back button is hit ([32acee5](https://github.com/IBM/kui/commit/32acee5)), closes [#4745](https://github.com/IBM/kui/issues/4745)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- upgrade @patternfly/react-core to latest ([0331533](https://github.com/IBM/kui/commit/0331533)), closes [#4937](https://github.com/IBM/kui/issues/4937)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** dropdown in sidecar theming and spacing tweaks ([1a48af3](https://github.com/IBM/kui/commit/1a48af3)), closes [#4680](https://github.com/IBM/kui/issues/4680)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** improve visibility of sidecar scrollbars ([827d75a](https://github.com/IBM/kui/commit/827d75a)), closes [#4667](https://github.com/IBM/kui/issues/4667)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** increase font size of status stripe ([2fab637](https://github.com/IBM/kui/commit/2fab637)), closes [#4698](https://github.com/IBM/kui/issues/4698)
- **plugins/plugin-client-common:** input element changes height with i-search and bottomInput ([abf9890](https://github.com/IBM/kui/commit/abf9890)), closes [#4685](https://github.com/IBM/kui/issues/4685)
- **plugins/plugin-client-common:** LeftNav sidecar nav column width inconsistency ([17e403f](https://github.com/IBM/kui/commit/17e403f)), closes [#4688](https://github.com/IBM/kui/issues/4688)
- **plugins/plugin-client-common:** LeftNavSidecar does not always reflect updated content ([0f2e1e1](https://github.com/IBM/kui/commit/0f2e1e1)), closes [#4727](https://github.com/IBM/kui/issues/4727) [#4732](https://github.com/IBM/kui/issues/4732)
- **plugins/plugin-client-common:** LeftNavSidecar font size and layout issues ([d9914f1](https://github.com/IBM/kui/commit/d9914f1)), closes [#4718](https://github.com/IBM/kui/issues/4718) [#4719](https://github.com/IBM/kui/issues/4719)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** move screenshot button out of status stripe ([0ef900b](https://github.com/IBM/kui/commit/0ef900b)), closes [#4556](https://github.com/IBM/kui/issues/4556)
- **plugins/plugin-client-common:** PatternFly DropDown rendering glitches ([8efedd8](https://github.com/IBM/kui/commit/8efedd8)), closes [#4649](https://github.com/IBM/kui/issues/4649) [#4651](https://github.com/IBM/kui/issues/4651)
- **plugins/plugin-client-common:** refine Loading component ([7a07ad3](https://github.com/IBM/kui/commit/7a07ad3)), closes [#4702](https://github.com/IBM/kui/issues/4702)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** reverse the dependency of Card and DropDown ([00b8ecf](https://github.com/IBM/kui/commit/00b8ecf)), closes [#4641](https://github.com/IBM/kui/issues/4641)
- **plugins/plugin-client-common:** Screenshot button should not be offered inBrowser ([d1c2cfb](https://github.com/IBM/kui/commit/d1c2cfb)), closes [#4636](https://github.com/IBM/kui/issues/4636)
- **plugins/plugin-client-common:** SequenceDiagram may emit spurious console errors ([c0ba218](https://github.com/IBM/kui/commit/c0ba218)), closes [#6166](https://github.com/IBM/kui/issues/6166)
- **plugins/plugin-client-common:** session init done message messes up Terminal scrolling ([7e80ac1](https://github.com/IBM/kui/commit/7e80ac1)), closes [#4683](https://github.com/IBM/kui/issues/4683)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** sidecar toolbar text incorrectly aligned ([ddd7460](https://github.com/IBM/kui/commit/ddd7460)), closes [#4659](https://github.com/IBM/kui/issues/4659)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- **plugins/plugin-client-common:** TabCompletion UI can fail ([cc3fb6d](https://github.com/IBM/kui/commit/cc3fb6d)), closes [#6130](https://github.com/IBM/kui/issues/6130)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** table container should only be width:100% for table not display-as-grid ([8f327cd](https://github.com/IBM/kui/commit/8f327cd)), closes [#4871](https://github.com/IBM/kui/issues/4871)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- **plugins/plugin-client-common:** Terminal screenshot odd w.r.t. auto-focus ([4b1c7d8](https://github.com/IBM/kui/commit/4b1c7d8)), closes [#4739](https://github.com/IBM/kui/issues/4739)
- **plugins/plugin-client-common:** top tab buttons should be owned by the top tab stripe ([9a45c43](https://github.com/IBM/kui/commit/9a45c43)), closes [#4690](https://github.com/IBM/kui/issues/4690)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** TopNavSidecar tabs easily overflow with narrower windows ([a555cd4](https://github.com/IBM/kui/commit/a555cd4)), closes [#4735](https://github.com/IBM/kui/issues/4735)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **plugins/plugin-client-common:** TreeView badges have poor contrast in patternfly themes ([8e0db86](https://github.com/IBM/kui/commit/8e0db86)), closes [#6149](https://github.com/IBM/kui/issues/6149)
- **plugins/plugin-client-common:** update spinner to avoid console error messages ([caea507](https://github.com/IBM/kui/commit/caea507)), closes [#6146](https://github.com/IBM/kui/issues/6146)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar container selection kebab has different color with its menu ([639617a](https://github.com/IBM/kui/commit/639617a)), closes [#4676](https://github.com/IBM/kui/issues/4676)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- **plugins/plugin-client-common:** WatchPane has non-zero height even when empty ([67a7070](https://github.com/IBM/kui/commit/67a7070)), closes [#4629](https://github.com/IBM/kui/issues/4629)
- **plugins/plugn-client-common:** TopTabStripe stays blue after command execution completes ([68f5841](https://github.com/IBM/kui/commit/68f5841)), closes [#4883](https://github.com/IBM/kui/issues/4883)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- Switching Carbon tabs can cause content to scroll off-viewport ([51a2aad](https://github.com/IBM/kui/commit/51a2aad)), closes [#6014](https://github.com/IBM/kui/issues/6014)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugins-client-common:** Carbon Accordion spi should have more contrast ([c0de84d](https://github.com/IBM/kui/commit/c0de84d)), closes [#6111](https://github.com/IBM/kui/issues/6111)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** switching table from Table to Timeline and back to Table does not work ([c924d67](https://github.com/IBM/kui/commit/c924d67)), closes [#5430](https://github.com/IBM/kui/issues/5430)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** table screenshots include a gray stripe at the top ([11a9fc3](https://github.com/IBM/kui/commit/11a9fc3)), closes [#5410](https://github.com/IBM/kui/issues/5410)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** threshold for auto-grid is too low ([9cb76ee](https://github.com/IBM/kui/commit/9cb76ee)), closes [#5424](https://github.com/IBM/kui/issues/5424)
- **plugins/plugin-client-common:** Timeline may not render properly ([d66d728](https://github.com/IBM/kui/commit/d66d728)), closes [#5383](https://github.com/IBM/kui/issues/5383)
- **plugins/plugin-client-common:** Timeline should use stdev-based heat map ([5dd7427](https://github.com/IBM/kui/commit/5dd7427)), closes [#5395](https://github.com/IBM/kui/issues/5395)
- **plugins/plugin-client-common:** Timeline tooltip for cold starts has incorrect concurrency count ([bb54cb8](https://github.com/IBM/kui/commit/bb54cb8)), closes [#5390](https://github.com/IBM/kui/issues/5390)
- **plugins/plugin-client-common:** Timeline view renders poorly in MiniSplit ([07cd000](https://github.com/IBM/kui/commit/07cd000)), closes [#5379](https://github.com/IBM/kui/issues/5379)
- **plugins/plugin-client-common:** update SequenceDiagram view to display the duration of each interval ([0cf1fcf](https://github.com/IBM/kui/commit/0cf1fcf)), closes [#5470](https://github.com/IBM/kui/issues/5470)
- **plugins/plugin-client-common:** update welcome.json notebook to improve listing of available notebooks ([c6f89f4](https://github.com/IBM/kui/commit/c6f89f4)), closes [#5583](https://github.com/IBM/kui/issues/5583)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- **plugins/plugin-ibmcloud:** ibmcloud ce job list does not support name filters ([5daa930](https://github.com/IBM/kui/commit/5daa930)), closes [#5450](https://github.com/IBM/kui/issues/5450)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-client-common:** Table clickables should have better tooltip ([1eeaa01](https://github.com/IBM/kui/commit/1eeaa01)), closes [#6805](https://github.com/IBM/kui/issues/6805)
- show buttons of related resources in sidecar footer ([e10f7f2](https://github.com/IBM/kui/commit/e10f7f2)), closes [#6856](https://github.com/IBM/kui/issues/6856)
- TopTab buttons should have improved tooltips ([5282612](https://github.com/IBM/kui/commit/5282612)), closes [#6806](https://github.com/IBM/kui/issues/6806)
- **plugins/plugin-client-common:** for emacs users, it'd be nice if ctrl+backspace would delete prior "word" ([122eb88](https://github.com/IBM/kui/commit/122eb88)), closes [#6579](https://github.com/IBM/kui/issues/6579)
- **plugins/plugin-client-common:** increase density of table content in minisplits ([8d6513f](https://github.com/IBM/kui/commit/8d6513f)), closes [#6790](https://github.com/IBM/kui/issues/6790)
- **plugins/plugin-client-common:** last updated indicator in table footer ([5f91f75](https://github.com/IBM/kui/commit/5f91f75)), closes [#6783](https://github.com/IBM/kui/issues/6783)
- **plugins/plugin-client-common:** Shift-enter or CmdCtrl+S to save within Commentary ([4cf496a](https://github.com/IBM/kui/commit/4cf496a)), closes [#6827](https://github.com/IBM/kui/issues/6827)
- add delta summary to Tree ([95a0b4a](https://github.com/IBM/kui/commit/95a0b4a)), closes [#6329](https://github.com/IBM/kui/issues/6329)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- add unit support of TreeResponse as one of the contents in MultiModalResponse ([85ea2d5](https://github.com/IBM/kui/commit/85ea2d5)), closes [#6132](https://github.com/IBM/kui/issues/6132)
- Allow command registrants to specify no semicolon expansion ([dbcaf87](https://github.com/IBM/kui/commit/dbcaf87)), closes [#6396](https://github.com/IBM/kui/issues/6396)
- clicking changed files in the `git status widget` should show `git diff` result in a DiffEditor ([3a199c7](https://github.com/IBM/kui/commit/3a199c7)), closes [#6348](https://github.com/IBM/kui/issues/6348)
- execute the command in url query when the browser app is loaded ([b0b95cf](https://github.com/IBM/kui/commit/b0b95cf)), closes [#5879](https://github.com/IBM/kui/issues/5879)
- Expand kubectl direct watching to support heterogeneous use cases ([8df1ad3](https://github.com/IBM/kui/commit/8df1ad3)), closes [#6504](https://github.com/IBM/kui/issues/6504)
- Extend kubectl optimizations to table watching ([9a2bc74](https://github.com/IBM/kui/commit/9a2bc74)), closes [#6449](https://github.com/IBM/kui/issues/6449)
- improve the split layout progression ([d3f2d6c](https://github.com/IBM/kui/commit/d3f2d6c)), closes [#6747](https://github.com/IBM/kui/issues/6747) [#6743](https://github.com/IBM/kui/issues/6743)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- initial support for using a kubectl proxy ([47b26be](https://github.com/IBM/kui/commit/47b26be)), closes [#6440](https://github.com/IBM/kui/issues/6440)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- introduce reexec for rerunning commands ([fe80525](https://github.com/IBM/kui/commit/fe80525)), closes [#6026](https://github.com/IBM/kui/issues/6026)
- lightweight ui options for core themes ([cf96867](https://github.com/IBM/kui/commit/cf96867)), closes [#6187](https://github.com/IBM/kui/issues/6187)
- revive "app" and "tier" columns from deprecated kubectl tree view ([cd642d9](https://github.com/IBM/kui/commit/cd642d9)), closes [#6591](https://github.com/IBM/kui/issues/6591)
- **plugins/plugin-client-common:** Allow user to specify CWD as prompt ([2b2e7a9](https://github.com/IBM/kui/commit/2b2e7a9)), closes [#6405](https://github.com/IBM/kui/issues/6405)
- **plugins/plugin-client-common:** Allow users to opt in to default meta-click behavior ([13ea5b0](https://github.com/IBM/kui/commit/13ea5b0)), closes [#6406](https://github.com/IBM/kui/issues/6406)
- **plugins/plugin-client-common:** Tab completion should keep offering completions as I type ([67e44d3](https://github.com/IBM/kui/commit/67e44d3)), closes [#6472](https://github.com/IBM/kui/issues/6472)
- **plugins/plugin-kubectl:** Port kubectl pollers to use push, for homogeneous deletes ([82448d7](https://github.com/IBM/kui/commit/82448d7)), closes [#6481](https://github.com/IBM/kui/issues/6481) [#6486](https://github.com/IBM/kui/issues/6486)
- Improve support for designing light themes ([b6c859f](https://github.com/IBM/kui/commit/b6c859f)), closes [#6372](https://github.com/IBM/kui/issues/6372)
- Kui implementation of `watch` ([2cb3f98](https://github.com/IBM/kui/commit/2cb3f98)), closes [#6379](https://github.com/IBM/kui/issues/6379)
- Make a notebook about making notebooks ([0d67947](https://github.com/IBM/kui/commit/0d67947)), closes [#6040](https://github.com/IBM/kui/issues/6040)
- Meta-click on table entries should open the drilldown in a different split ([fb89c29](https://github.com/IBM/kui/commit/fb89c29)), closes [#6403](https://github.com/IBM/kui/issues/6403)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- port experimental scale-out grep to use new job controller ([45ce460](https://github.com/IBM/kui/commit/45ce460)), closes [#6280](https://github.com/IBM/kui/issues/6280)
- Refine Update Checker widget UI ([5c97479](https://github.com/IBM/kui/commit/5c97479)), closes [#6343](https://github.com/IBM/kui/issues/6343)
- update CurrentContext widget to use Dropdown ([9520e5d](https://github.com/IBM/kui/commit/9520e5d)), closes [#6354](https://github.com/IBM/kui/issues/6354)
- use a Popover UI for git branch status stripe widget ([6bbf348](https://github.com/IBM/kui/commit/6bbf348)), closes [#6325](https://github.com/IBM/kui/issues/6325)
- use Accordion for SourceRef ([1b11736](https://github.com/IBM/kui/commit/1b11736)), closes [#6097](https://github.com/IBM/kui/issues/6097)
- use new Dropdown status stripe for CurrentNamespace widget ([0f7648c](https://github.com/IBM/kui/commit/0f7648c)), closes [#6351](https://github.com/IBM/kui/issues/6351)
- UX: Use Dropdown for theme switcher ([6cc6a47](https://github.com/IBM/kui/commit/6cc6a47)), closes [#6347](https://github.com/IBM/kui/issues/6347)
- **plugins/plugin-client-common:** error messages should format as markdown ([63ca4a7](https://github.com/IBM/kui/commit/63ca4a7)), closes [#5943](https://github.com/IBM/kui/issues/5943)
- **plugins/plugin-client-common:** SourceRef should be default-expanded in Notebooks? ([8ee26e8](https://github.com/IBM/kui/commit/8ee26e8)), closes [#5866](https://github.com/IBM/kui/issues/5866)
- Feature: improve support for parallelization across VFS operations ([e05d7e0](https://github.com/IBM/kui/commit/e05d7e0)), closes [#5831](https://github.com/IBM/kui/issues/5831)
- **plugins/plugin-client-common:** block-level copy/paste ([a72cf8d](https://github.com/IBM/kui/commit/a72cf8d)), closes [#5752](https://github.com/IBM/kui/issues/5752)
- **plugins/plugin-client-common:** split command should allow user to specify splice index ([75857e9](https://github.com/IBM/kui/commit/75857e9)), closes [#5746](https://github.com/IBM/kui/issues/5746)
- save/restore pty command output ([2c291a9](https://github.com/IBM/kui/commit/2c291a9)), closes [#5314](https://github.com/IBM/kui/issues/5314)
- **plugins/plugin-client-common:** allow clients to specify initial tab title ([e8e365f](https://github.com/IBM/kui/commit/e8e365f)), closes [#5539](https://github.com/IBM/kui/issues/5539)
- **plugins/plugin-client-common:** allow users to insert command before a repl block ([e935092](https://github.com/IBM/kui/commit/e935092)), closes [#5576](https://github.com/IBM/kui/issues/5576)
- **plugins/plugin-client-common:** Output-only blocks should offer a Copy action button ([da4f85d](https://github.com/IBM/kui/commit/da4f85d)), closes [#5646](https://github.com/IBM/kui/issues/5646)
- **plugins/plugin-client-common:** User should be able to tab navigate through blocks ([54d3759](https://github.com/IBM/kui/commit/54d3759)), closes [#5717](https://github.com/IBM/kui/issues/5717)
- ability to register an onClose handler when opening a tab ([58a36c3](https://github.com/IBM/kui/commit/58a36c3)), closes [#5670](https://github.com/IBM/kui/issues/5670)
- **plugins/plugin-client-common:** edit a commentary response using SimpleEditor ([6d828c1](https://github.com/IBM/kui/commit/6d828c1)), closes [#5664](https://github.com/IBM/kui/issues/5664)
- **plugins/plugin-client-common:** improve action button UI for output-only blocks ([9cb99ad](https://github.com/IBM/kui/commit/9cb99ad)), closes [#5660](https://github.com/IBM/kui/issues/5660)
- **plugins/plugin-client-common:** Improve Commentary editing UI by adding real Done button ([1f544b5](https://github.com/IBM/kui/commit/1f544b5)), closes [#5667](https://github.com/IBM/kui/issues/5667)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add capability to click to edit/rerun a command ([4296933](https://github.com/IBM/kui/commit/4296933)), closes [#5654](https://github.com/IBM/kui/issues/5654)
- add CommentaryReponse to snapshot/replay the response of commentary command ([7d13a93](https://github.com/IBM/kui/commit/7d13a93)), closes [#5439](https://github.com/IBM/kui/issues/5439)
- allow command registrations to express their experimental nature ([eb9f147](https://github.com/IBM/kui/commit/eb9f147)), closes [#5282](https://github.com/IBM/kui/issues/5282)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- commentary command to add comments to REPL ([c304fd3](https://github.com/IBM/kui/commit/c304fd3)), closes [#5428](https://github.com/IBM/kui/issues/5428)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- improve repl-block selection ([305b36f](https://github.com/IBM/kui/commit/305b36f)), closes [#5587](https://github.com/IBM/kui/issues/5587)
- inverse splits ([38d2895](https://github.com/IBM/kui/commit/38d2895)), closes [#5537](https://github.com/IBM/kui/issues/5537)
- separate out themes into a new settings Notebook ([5180759](https://github.com/IBM/kui/commit/5180759)), closes [#5605](https://github.com/IBM/kui/issues/5605)
- **plugins/plugin-client-common:** allow easier rerunning of command from terminal ([c5384e0](https://github.com/IBM/kui/commit/c5384e0)), closes [#4570](https://github.com/IBM/kui/issues/4570)
- **plugins/plugin-client-common:** allow users to reorder blocks by MoveUp and MoveDown buttons ([f7f6918](https://github.com/IBM/kui/commit/f7f6918)), closes [#5589](https://github.com/IBM/kui/issues/5589)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- initial/minimal snapshot/replay support ([bb7ae0f](https://github.com/IBM/kui/commit/bb7ae0f)), closes [#5280](https://github.com/IBM/kui/issues/5280)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- pass command line comments to commentary command ([a020db5](https://github.com/IBM/kui/commit/a020db5)), closes [#5459](https://github.com/IBM/kui/issues/5459)
- snapshot freshening ([d5c8991](https://github.com/IBM/kui/commit/d5c8991)), closes [#5522](https://github.com/IBM/kui/issues/5522)
- support replaying in new tab ([04a2c67](https://github.com/IBM/kui/commit/04a2c67)), closes [#5509](https://github.com/IBM/kui/issues/5509)
- update ls to allow for presenting content from more limited VFS's such as tutorials ([a1ff1a4](https://github.com/IBM/kui/commit/a1ff1a4)), closes [#5497](https://github.com/IBM/kui/issues/5497)
- **plugins/plugin-client-common:** Improve notebook-style ui ([791160e](https://github.com/IBM/kui/commit/791160e)), closes [#5472](https://github.com/IBM/kui/issues/5472)
- **plugins/plugin-client-common:** improve presentation of sidecar-destined responses ([02b91e3](https://github.com/IBM/kui/commit/02b91e3)), closes [#5463](https://github.com/IBM/kui/issues/5463)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- <Kui> should allow for custom Input elements ([193a108](https://github.com/IBM/kui/commit/193a108)), closes [#4672](https://github.com/IBM/kui/issues/4672)
- add alert command to display Alert component in Terminal ([495d3bb](https://github.com/IBM/kui/commit/495d3bb)), closes [#4957](https://github.com/IBM/kui/issues/4957)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add sequence diagram to table with timestamp columns ([e9028ee](https://github.com/IBM/kui/commit/e9028ee)), closes [#5336](https://github.com/IBM/kui/issues/5336)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow table model to specify a gridable column index ([f4ba8e6](https://github.com/IBM/kui/commit/f4ba8e6)), closes [#5278](https://github.com/IBM/kui/issues/5278)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- Dropdown spi and use in Terminal Block ([327917b](https://github.com/IBM/kui/commit/327917b)), closes [#4589](https://github.com/IBM/kui/issues/4589) [#4556](https://github.com/IBM/kui/issues/4556)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- RadioTable and port of the themes table to use it ([79a3e8e](https://github.com/IBM/kui/commit/79a3e8e)), closes [#4507](https://github.com/IBM/kui/issues/4507)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- auto gridify large table ([bd22fa2](https://github.com/IBM/kui/commit/bd22fa2)), closes [#5305](https://github.com/IBM/kui/issues/5305)
- **plugins/plugin-client-common:** History navigation in minisplits should navigate In/Out pairs ([93eb2a4](https://github.com/IBM/kui/commit/93eb2a4)), closes [#5270](https://github.com/IBM/kui/issues/5270)
- add a command to return the Card Component in Terminal ([d8d13ab](https://github.com/IBM/kui/commit/d8d13ab)), closes [#4973](https://github.com/IBM/kui/issues/4973)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add support for <Kui noPromptContext/> and <Kui prompt=">"/> ([a92063d](https://github.com/IBM/kui/commit/a92063d)), closes [#4653](https://github.com/IBM/kui/issues/4653)
- allow <Kui/> users to provide custom views for session init ([1f35894](https://github.com/IBM/kui/commit/1f35894)), closes [#4596](https://github.com/IBM/kui/issues/4596)
- allow clients to modify the session lifecycle UI by providing custom strings ([3c78fd3](https://github.com/IBM/kui/commit/3c78fd3)), closes [#5019](https://github.com/IBM/kui/issues/5019)
- allow subclasses of InputProvider to specify their own State ([c3fc88e](https://github.com/IBM/kui/commit/c3fc88e)), closes [#4756](https://github.com/IBM/kui/issues/4756)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- command history should be tab-specific ([1b987e0](https://github.com/IBM/kui/commit/1b987e0)), closes [#1299](https://github.com/IBM/kui/issues/1299)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- shift Block UI to use a Notebook style of presentation ([dc0ee4b](https://github.com/IBM/kui/commit/dc0ee4b)), closes [#5258](https://github.com/IBM/kui/issues/5258)
- Timeline view for kubernetes Jobs ([b623e4e](https://github.com/IBM/kui/commit/b623e4e)), closes [#5370](https://github.com/IBM/kui/issues/5370)
- **plugins/plugin-client-common:** add support for Tags in StatusStripe ([d112c86](https://github.com/IBM/kui/commit/d112c86)), closes [#4951](https://github.com/IBM/kui/issues/4951)
- **plugins/plugin-client-common:** improve accessibility of "red" error grid cells ([8921292](https://github.com/IBM/kui/commit/8921292)), closes [#4938](https://github.com/IBM/kui/issues/4938)
- **plugins/plugin-client-common:** show table row count in card header ([deadcfa](https://github.com/IBM/kui/commit/deadcfa)), closes [#5137](https://github.com/IBM/kui/issues/5137)
- **plugins/plugin-client-common:** use inner scrolling for RadioTables in main Terminals ([952f72a](https://github.com/IBM/kui/commit/952f72a)), closes [#5133](https://github.com/IBM/kui/issues/5133)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- **plugins/plugin-client-common:** use Cards to wrap kube tables and grids ([6698013](https://github.com/IBM/kui/commit/6698013)), closes [#5032](https://github.com/IBM/kui/issues/5032)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- update checker ([a7908d2](https://github.com/IBM/kui/commit/a7908d2)), closes [#4537](https://github.com/IBM/kui/issues/4537)
- Update default loadingDone to use Card component ([e1b4c61](https://github.com/IBM/kui/commit/e1b4c61)), closes [#4986](https://github.com/IBM/kui/issues/4986)
- **plugins/plugin-client-common:** support client option for hero names in sidecar ([d4f6984](https://github.com/IBM/kui/commit/d4f6984)), closes [#4909](https://github.com/IBM/kui/issues/4909)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [9.3.0](https://github.com/IBM/kui/compare/v4.5.0...v9.3.0) (2020-12-11)

### Bug Fixes

- **plugins/plugin-client-common:** "No resources" in watch pane can occlude watch pane title ([e4fd93a](https://github.com/IBM/kui/commit/e4fd93a)), closes [#5064](https://github.com/IBM/kui/issues/5064)
- **plugins/plugin-client-common:** font size issues with lightweight ui in tree view ([575ced0](https://github.com/IBM/kui/commit/575ced0)), closes [#6228](https://github.com/IBM/kui/issues/6228) [#6229](https://github.com/IBM/kui/issues/6229)
- **plugins/plugin-client-common:** inverted color context in mini splits can have low contrast ([2541d74](https://github.com/IBM/kui/commit/2541d74)), closes [#6383](https://github.com/IBM/kui/issues/6383)
- Clean up the way patternfly fonts are incorporated into themes ([2ba49e9](https://github.com/IBM/kui/commit/2ba49e9)), closes [#6375](https://github.com/IBM/kui/issues/6375)
- DIffEditor should render inline when in terminal split ([b86b127](https://github.com/IBM/kui/commit/b86b127)), closes [#6366](https://github.com/IBM/kui/issues/6366)
- drilldown from an undeployed application in tree will issue a kubectl get with 404 ([309a9a0](https://github.com/IBM/kui/commit/309a9a0)), closes [#6331](https://github.com/IBM/kui/issues/6331)
- **plugins/plugin-client-common:** a few minor UI glitches in Block css ([a25c72c](https://github.com/IBM/kui/commit/a25c72c)), closes [#6335](https://github.com/IBM/kui/issues/6335)
- **plugins/plugin-client-common:** blocks with no input or output shouldn't have a background color ([42b5b01](https://github.com/IBM/kui/commit/42b5b01)), closes [#6367](https://github.com/IBM/kui/issues/6367)
- **plugins/plugin-client-common:** DiffEditor does not respond to resize events ([7f88934](https://github.com/IBM/kui/commit/7f88934)), closes [#6365](https://github.com/IBM/kui/issues/6365)
- **plugins/plugin-client-common:** LeftNav UIs can be too wide ([5dae64c](https://github.com/IBM/kui/commit/5dae64c)), closes [#6302](https://github.com/IBM/kui/issues/6302)
- **plugins/plugin-client-common:** PatternFly themes are still using a carbon icon for Split ([4c05d28](https://github.com/IBM/kui/commit/4c05d28)), closes [#6322](https://github.com/IBM/kui/issues/6322)
- **plugins/plugin-client-common:** red and green overlays in diff views are hard to see ([1843bff](https://github.com/IBM/kui/commit/1843bff)), closes [#6363](https://github.com/IBM/kui/issues/6363)
- in patternfly4 light theme, the status stripe hovers background color are not visible ([a0e79d5](https://github.com/IBM/kui/commit/a0e79d5)), closes [#6361](https://github.com/IBM/kui/issues/6361)
- **plugins/plugin-client-common:** `ls` in minisplit has tall rows ([00b5e41](https://github.com/IBM/kui/commit/00b5e41)), closes [#6289](https://github.com/IBM/kui/issues/6289)
- **plugins/plugin-client-common:** double whitespace may be removed from completed inputs ([fc0c0db](https://github.com/IBM/kui/commit/fc0c0db)), closes [#6279](https://github.com/IBM/kui/issues/6279)
- **plugins/plugin-client-common:** Experimental badge too tall for lightweight UI themes. ([57b1f51](https://github.com/IBM/kui/commit/57b1f51)), closes [#6284](https://github.com/IBM/kui/issues/6284)
- **plugins/plugin-client-common:** in lightweight themes, hover on sequence diagram rows may result in errant border-top ([679498f](https://github.com/IBM/kui/commit/679498f)), closes [#6251](https://github.com/IBM/kui/issues/6251)
- **plugins/plugin-client-common:** in lightweight ui themes, markdown content has odd font spacing ([b114221](https://github.com/IBM/kui/commit/b114221)), closes [#6249](https://github.com/IBM/kui/issues/6249)
- **plugins/plugin-client-common:** in minisplits, no margin between active block and previous response ([e20c115](https://github.com/IBM/kui/commit/e20c115)), closes [#6333](https://github.com/IBM/kui/issues/6333)
- **plugins/plugin-client-common:** in PatternFly Light theme, status stripe hovers and borders are not visible ([8bfc9a1](https://github.com/IBM/kui/commit/8bfc9a1)), closes [#6324](https://github.com/IBM/kui/issues/6324)
- **plugins/plugin-client-common:** inline sidecar should not have a min-width ([11a0cfb](https://github.com/IBM/kui/commit/11a0cfb)), closes [#6270](https://github.com/IBM/kui/issues/6270)
- **plugins/plugin-client-common:** input element is not distinct enough in lightweight ui themes with splits ([01b3e40](https://github.com/IBM/kui/commit/01b3e40)), closes [#6247](https://github.com/IBM/kui/issues/6247)
- **plugins/plugin-client-common:** ls ; ls has excessive vertical whitespace ([1b41c59](https://github.com/IBM/kui/commit/1b41c59)), closes [#6291](https://github.com/IBM/kui/issues/6291)
- **plugins/plugin-client-common:** patternfly popover close button has odd spacing ([e7c21fd](https://github.com/IBM/kui/commit/e7c21fd)), closes [#6345](https://github.com/IBM/kui/issues/6345)
- **plugins/plugin-client-common:** Popup mode client has a few status stripe rendering issues ([57bb8b2](https://github.com/IBM/kui/commit/57bb8b2)), closes [#6357](https://github.com/IBM/kui/issues/6357)
- **plugins/plugin-client-common:** Popup mode input stripe does not have reliable auto-focus behavior ([ac3935e](https://github.com/IBM/kui/commit/ac3935e)), closes [#6266](https://github.com/IBM/kui/issues/6266)
- **plugins/plugin-client-common:** processing block disappears in minisplits ([907a9d5](https://github.com/IBM/kui/commit/907a9d5)), closes [#6310](https://github.com/IBM/kui/issues/6310)
- **plugins/plugin-client-common:** refine input UI for lightweight ui themes ([c479cdb](https://github.com/IBM/kui/commit/c479cdb)), closes [#6296](https://github.com/IBM/kui/issues/6296)
- **plugins/plugin-client-common:** Rendering glitches in carbon fonts for status stripe DropdownWidgets ([1ee18a6](https://github.com/IBM/kui/commit/1ee18a6)), closes [#6359](https://github.com/IBM/kui/issues/6359)
- **plugins/plugin-client-common:** sidecar toolbar text is not always vertically centered ([cbceee3](https://github.com/IBM/kui/commit/cbceee3)), closes [#6305](https://github.com/IBM/kui/issues/6305)
- @patternfly/react-core breaks the indentation of TreeView ([f5c5253](https://github.com/IBM/kui/commit/f5c5253)), closes [#6224](https://github.com/IBM/kui/issues/6224)
- block timestamp in Light theme/lightweight ui has low contrast ([6ae08fd](https://github.com/IBM/kui/commit/6ae08fd)), closes [#6226](https://github.com/IBM/kui/issues/6226)
- keyboard history navigation does not work in Popup clients ([89197ba](https://github.com/IBM/kui/commit/89197ba)), closes [#6262](https://github.com/IBM/kui/issues/6262)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- PatternFly 2012.14 breaks the indentation of TreeView ([f052d71](https://github.com/IBM/kui/commit/f052d71)), closes [#6224](https://github.com/IBM/kui/issues/6224)
- **plugins/plugin-client-common:** adjust TopTabStripe for lightweight ui themes ([00ee896](https://github.com/IBM/kui/commit/00ee896)), closes [#6204](https://github.com/IBM/kui/issues/6204)
- **plugins/plugin-client-common:** after Electron 10 update, ls output can render poorly ([1b7010b](https://github.com/IBM/kui/commit/1b7010b)), closes [#6147](https://github.com/IBM/kui/issues/6147)
- **plugins/plugin-client-common:** clicking the editor in carbon accordion will change the accordion label ([ce3fe02](https://github.com/IBM/kui/commit/ce3fe02)), closes [#6107](https://github.com/IBM/kui/issues/6107)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([3400431](https://github.com/IBM/kui/commit/3400431)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([f93fe2b](https://github.com/IBM/kui/commit/f93fe2b)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** for lightweight ui themes, also show block duration in highlight color ([da3a3a7](https://github.com/IBM/kui/commit/da3a3a7)), closes [#6222](https://github.com/IBM/kui/issues/6222)
- **plugins/plugin-client-common:** pack table rows more densely in lightweight UI themes ([bcb3f23](https://github.com/IBM/kui/commit/bcb3f23)), closes [#6217](https://github.com/IBM/kui/issues/6217)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- tree should support leaf node drilling down ([006b881](https://github.com/IBM/kui/commit/006b881)), closes [#6293](https://github.com/IBM/kui/issues/6293)
- Tree view badges can have low contrast ([9be1ae5](https://github.com/IBM/kui/commit/9be1ae5)), closes [#6245](https://github.com/IBM/kui/issues/6245)
- **plugins-client-common:** bump carbon-components-react to 7.22 ([8b98791](https://github.com/IBM/kui/commit/8b98791)), closes [#6011](https://github.com/IBM/kui/issues/6011)
- **plugins/plugin-client-common:** "No events in the past hour" in sidecar has different bg color than other tabs ([ffba806](https://github.com/IBM/kui/commit/ffba806)), closes [#6075](https://github.com/IBM/kui/issues/6075)
- **plugins/plugin-client-common:** a few more patternfly navigation styling issues ([5511c1f](https://github.com/IBM/kui/commit/5511c1f)), closes [#6049](https://github.com/IBM/kui/issues/6049)
- **plugins/plugin-client-common:** active pty output doesn't have repl-context ([6b0929e](https://github.com/IBM/kui/commit/6b0929e)), closes [#5960](https://github.com/IBM/kui/issues/5960)
- **plugins/plugin-client-common:** blockquotes in commentary don't render well ([9be35fa](https://github.com/IBM/kui/commit/9be35fa)), closes [#5931](https://github.com/IBM/kui/issues/5931)
- **plugins/plugin-client-common:** commentary editor can overflow with long lines ([3475287](https://github.com/IBM/kui/commit/3475287)), closes [#5981](https://github.com/IBM/kui/issues/5981)
- **plugins/plugin-client-common:** custom repl-prompt is misaligned with repl-output ([d12b203](https://github.com/IBM/kui/commit/d12b203)), closes [#6046](https://github.com/IBM/kui/issues/6046)
- **plugins/plugin-client-common:** double clicking on Commentary in minisplit often has the editor completely off screen ([c3504a0](https://github.com/IBM/kui/commit/c3504a0)), closes [#5897](https://github.com/IBM/kui/issues/5897)
- **plugins/plugin-client-common:** editor doesn't grab focus for edit command ([9870267](https://github.com/IBM/kui/commit/9870267)), closes [#6090](https://github.com/IBM/kui/issues/6090)
- **plugins/plugin-client-common:** empty pty response yields blank line ([711bd05](https://github.com/IBM/kui/commit/711bd05)), closes [#5928](https://github.com/IBM/kui/issues/5928)
- **plugins/plugin-client-common:** enhance minisplit by updating the background color of scrollback and dark card ([fd15c5e](https://github.com/IBM/kui/commit/fd15c5e)), closes [#5989](https://github.com/IBM/kui/issues/5989)
- **plugins/plugin-client-common:** error blocks are not indented properly ([d137614](https://github.com/IBM/kui/commit/d137614)), closes [#5938](https://github.com/IBM/kui/issues/5938)
- **plugins/plugin-client-common:** events in tree should stay scrolled to the bottom as events come in ([c5efedd](https://github.com/IBM/kui/commit/c5efedd)), closes [#6164](https://github.com/IBM/kui/issues/6164)
- **plugins/plugin-client-common:** externalize PatternFly TreeView component to SPI ([486a02e](https://github.com/IBM/kui/commit/486a02e)), closes [#6134](https://github.com/IBM/kui/issues/6134)
- **plugins/plugin-client-common:** group the notebooks together in the ls -l table ([1a783f3](https://github.com/IBM/kui/commit/1a783f3)), closes [#5977](https://github.com/IBM/kui/issues/5977)
- **plugins/plugin-client-common:** height of TreeView events should match that of sidecar header ([bba1ccd](https://github.com/IBM/kui/commit/bba1ccd)), closes [#6174](https://github.com/IBM/kui/issues/6174)
- **plugins/plugin-client-common:** hovering over error block turns red to blue ([3dbddae](https://github.com/IBM/kui/commit/3dbddae)), closes [#5979](https://github.com/IBM/kui/issues/5979)
- **plugins/plugin-client-common:** If a command is issued in a mini split, the next block (in the mini split) is not focused ([a35e5c2](https://github.com/IBM/kui/commit/a35e5c2)), closes [#6067](https://github.com/IBM/kui/issues/6067)
- **plugins/plugin-client-common:** in carbon-based dark themes, the SourceRef expando text is not visible ([0b462f5](https://github.com/IBM/kui/commit/0b462f5)), closes [#6197](https://github.com/IBM/kui/issues/6197)
- **plugins/plugin-client-common:** in dark themes, the inter-split gutter is not visible ([288eeae](https://github.com/IBM/kui/commit/288eeae)), closes [#6022](https://github.com/IBM/kui/issues/6022)
- **plugins/plugin-client-common:** in lightweight presentation mode, lighten up sidecar a bit ([c73c080](https://github.com/IBM/kui/commit/c73c080)), closes [#6202](https://github.com/IBM/kui/issues/6202) [#6201](https://github.com/IBM/kui/issues/6201)
- **plugins/plugin-client-common:** in some cases, Editor may present "you are in edit mode" for readOnly instantiations ([e3e7c16](https://github.com/IBM/kui/commit/e3e7c16)), closes [#6116](https://github.com/IBM/kui/issues/6116)
- **plugins/plugin-client-common:** In some themes, grid inner text color can have low contrast. ([01f8698](https://github.com/IBM/kui/commit/01f8698)), closes [#6032](https://github.com/IBM/kui/issues/6032)
- **plugins/plugin-client-common:** lightweight ui has a few remaining "heavy" elements ([afef54a](https://github.com/IBM/kui/commit/afef54a)), closes [#6195](https://github.com/IBM/kui/issues/6195)
- **plugins/plugin-client-common:** lightweight ui: minisplits should not have the opacity filter ([96860f3](https://github.com/IBM/kui/commit/96860f3)), closes [#6198](https://github.com/IBM/kui/issues/6198)
- **plugins/plugin-client-common:** PatternFly LeftNav view has excessive padding ([959d059](https://github.com/IBM/kui/commit/959d059)), closes [#6038](https://github.com/IBM/kui/issues/6038)
- **plugins/plugin-client-common:** prompt focus may not be restored when switching tabs ([5e81db9](https://github.com/IBM/kui/commit/5e81db9)), closes [#6239](https://github.com/IBM/kui/issues/6239)
- **plugins/plugin-client-common:** RadioTable has small font size ([19f758a](https://github.com/IBM/kui/commit/19f758a)), closes [#6102](https://github.com/IBM/kui/issues/6102)
- **plugins/plugin-client-common:** remove leftover debugging in Scalar/index ([82b8e50](https://github.com/IBM/kui/commit/82b8e50)), closes [#5945](https://github.com/IBM/kui/issues/5945)
- **plugins/plugin-client-common:** removing previous blocks will cause errant rendering to edit command result ([6594e8c](https://github.com/IBM/kui/commit/6594e8c)), closes [#6093](https://github.com/IBM/kui/issues/6093)
- **plugins/plugin-client-common:** sequence diagram does not display well with lightweight ui ([e746cc6](https://github.com/IBM/kui/commit/e746cc6)), closes [#6189](https://github.com/IBM/kui/issues/6189)
- **plugins/plugin-client-common:** small regression in top tab stripe height ([0b07d35](https://github.com/IBM/kui/commit/0b07d35)), closes [#6211](https://github.com/IBM/kui/issues/6211)
- A few more themes tweaks are needed ([03be3eb](https://github.com/IBM/kui/commit/03be3eb)), closes [#6034](https://github.com/IBM/kui/issues/6034)
- block focus regressions ([881fa17](https://github.com/IBM/kui/commit/881fa17)), closes [#6072](https://github.com/IBM/kui/issues/6072)
- default chart colors should not use blue-red diverging spectrum ([918ab9c](https://github.com/IBM/kui/commit/918ab9c)), closes [#6191](https://github.com/IBM/kui/issues/6191)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- **plugins/plugin-client-common:** PatternFly assumes a 16px body font size, whereas the rest of Kui assumes 14px ([fa65b57](https://github.com/IBM/kui/commit/fa65b57)), closes [#6041](https://github.com/IBM/kui/issues/6041)
- **plugins/plugin-client-common:** rendering of blockquotes in markdown is inconsistent ([edcc8d1](https://github.com/IBM/kui/commit/edcc8d1)), closes [#6043](https://github.com/IBM/kui/issues/6043)
- **plugins/plugin-client-common:** restore hiding of In[1] in minisplit ([8d5c93f](https://github.com/IBM/kui/commit/8d5c93f)), closes [#5985](https://github.com/IBM/kui/issues/5985)
- **plugins/plugin-client-common:** SequenceDiagram can overflow 100% width ([d631fd9](https://github.com/IBM/kui/commit/d631fd9)), closes [#6159](https://github.com/IBM/kui/issues/6159)
- **plugins/plugin-client-common:** SequenceDiagram may emit spurious console errors ([c0ba218](https://github.com/IBM/kui/commit/c0ba218)), closes [#6166](https://github.com/IBM/kui/issues/6166)
- **plugins/plugin-client-common:** sidecar editor too-aggressively focuses ([8077cec](https://github.com/IBM/kui/commit/8077cec)), closes [#6104](https://github.com/IBM/kui/issues/6104)
- **plugins/plugin-client-common:** sidecar markdown code snippet has poor color ([765f166](https://github.com/IBM/kui/commit/765f166)), closes [#5995](https://github.com/IBM/kui/issues/5995)
- **plugins/plugin-client-common:** Tree Component tweaks ([2f21e22](https://github.com/IBM/kui/commit/2f21e22)), closes [#6158](https://github.com/IBM/kui/issues/6158) [#6157](https://github.com/IBM/kui/issues/6157)
- **plugins/plugin-client-common:** TreeView badges have poor contrast in patternfly themes ([8e0db86](https://github.com/IBM/kui/commit/8e0db86)), closes [#6149](https://github.com/IBM/kui/issues/6149)
- **plugins/plugin-client-common:** typo "soild" in Tree.scss ([1a64ccd](https://github.com/IBM/kui/commit/1a64ccd)), closes [#6172](https://github.com/IBM/kui/issues/6172)
- **plugins/plugin-kubectl:** unlabeled resources shouldn’t have badge for children's count ([4e1fea6](https://github.com/IBM/kui/commit/4e1fea6)), closes [#6243](https://github.com/IBM/kui/issues/6243)
- add Kui version and github link to client-notebook ([7b2562a](https://github.com/IBM/kui/commit/7b2562a)), closes [#5918](https://github.com/IBM/kui/issues/5918)
- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- improve discovery of ibmcloud s3 credentials ([96d5bc0](https://github.com/IBM/kui/commit/96d5bc0)), closes [#5926](https://github.com/IBM/kui/issues/5926)
- RadioTable should have option to not echo the onSelect command ([77d5050](https://github.com/IBM/kui/commit/77d5050)), closes [#5991](https://github.com/IBM/kui/issues/5991)
- **plugins/plugin-client-common:** do not show the command rerun and remove button for offline kui ([309162f](https://github.com/IBM/kui/commit/309162f)), closes [#5917](https://github.com/IBM/kui/issues/5917)
- **plugins/plugin-client-common:** sorting widgets in table header are wrapping ([e3520dc](https://github.com/IBM/kui/commit/e3520dc)), closes [#5976](https://github.com/IBM/kui/issues/5976)
- **plugins/plugin-client-common:** update spinner to avoid console error messages ([caea507](https://github.com/IBM/kui/commit/caea507)), closes [#6146](https://github.com/IBM/kui/issues/6146)
- **plugins/plugin-client-common:** update the commentary in settings notebook to store the texts as command ([bbb8f6d](https://github.com/IBM/kui/commit/bbb8f6d)), closes [#5992](https://github.com/IBM/kui/issues/5992)
- improve error reporting from APIs ([edff6f1](https://github.com/IBM/kui/commit/edff6f1)), closes [#5950](https://github.com/IBM/kui/issues/5950)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- tweak the input background and border to enhance the readability of notebooks ([3928768](https://github.com/IBM/kui/commit/3928768)), closes [#5982](https://github.com/IBM/kui/issues/5982)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- **plugins/plugin-client-common:** "Drilled down to..." text is not aligned with the Input area ([fd139d2](https://github.com/IBM/kui/commit/fd139d2)), closes [#5854](https://github.com/IBM/kui/issues/5854)
- **plugins/plugin-client-common:** Action button hover hysteresis/delay effect not working ([fac75dc](https://github.com/IBM/kui/commit/fac75dc)), closes [#5806](https://github.com/IBM/kui/issues/5806)
- **plugins/plugin-client-common:** clicking on table or radio table may cause block to disappear ([1f2d489](https://github.com/IBM/kui/commit/1f2d489)), closes [#5783](https://github.com/IBM/kui/issues/5783)
- **plugins/plugin-client-common:** ClipboardTransfer emits errors when pasting non-json text ([6ff85c4](https://github.com/IBM/kui/commit/6ff85c4)), closes [#5836](https://github.com/IBM/kui/issues/5836)
- **plugins/plugin-client-common:** CodeSnippet component renders with zero contrast in dark themes ([10e40a9](https://github.com/IBM/kui/commit/10e40a9)), closes [#5886](https://github.com/IBM/kui/issues/5886)
- **plugins/plugin-client-common:** Commentary markdown does not support kuiexec ([4663389](https://github.com/IBM/kui/commit/4663389)), closes [#5911](https://github.com/IBM/kui/issues/5911)
- **plugins/plugin-client-common:** creating a split with a 3-way split configuration results in radical shuffling ([9452b5a](https://github.com/IBM/kui/commit/9452b5a)), closes [#5794](https://github.com/IBM/kui/issues/5794)
- **plugins/plugin-client-common:** deleting and re-creating a split results double commands ([dde6eaa](https://github.com/IBM/kui/commit/dde6eaa)), closes [#5876](https://github.com/IBM/kui/issues/5876)
- **plugins/plugin-client-common:** disable Timeline option for Tables ([e88ebb3](https://github.com/IBM/kui/commit/e88ebb3)), closes [#5864](https://github.com/IBM/kui/issues/5864)
- **plugins/plugin-client-common:** don't decorate code elements in top tab ([531e8b8](https://github.com/IBM/kui/commit/531e8b8)), closes [#5778](https://github.com/IBM/kui/issues/5778)
- **plugins/plugin-client-common:** editing commentary gives a one-line monaco ([5f14268](https://github.com/IBM/kui/commit/5f14268)), closes [#5874](https://github.com/IBM/kui/issues/5874)
- **plugins/plugin-client-common:** focus a block upon moving or pasting it ([43c3d9a](https://github.com/IBM/kui/commit/43c3d9a)), closes [#5751](https://github.com/IBM/kui/issues/5751)
- **plugins/plugin-client-common:** Input timestamp should also hide when block is focused ([6e1ca6d](https://github.com/IBM/kui/commit/6e1ca6d)), closes [#5809](https://github.com/IBM/kui/issues/5809)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** linux can show unneeded scrollbars in tables ([4d49a23](https://github.com/IBM/kui/commit/4d49a23)), closes [#5884](https://github.com/IBM/kui/issues/5884)
- **plugins/plugin-client-common:** markdown code has incorrect color in a split with inverse color ([c8c10af](https://github.com/IBM/kui/commit/c8c10af)), closes [#5902](https://github.com/IBM/kui/issues/5902)
- **plugins/plugin-client-common:** markdown inline code in table cells shows with scrollbars on linux and windows ([1ff88b9](https://github.com/IBM/kui/commit/1ff88b9)), closes [#5890](https://github.com/IBM/kui/issues/5890)
- **plugins/plugin-client-common:** RadioTable should scroll the selected row into view on render ([6eb45db](https://github.com/IBM/kui/commit/6eb45db)), closes [#5781](https://github.com/IBM/kui/issues/5781)
- **plugins/plugin-client-common:** remove clicks from NotebookImpl ([45f0be5](https://github.com/IBM/kui/commit/45f0be5)), closes [#5856](https://github.com/IBM/kui/issues/5856)
- **plugins/plugin-client-common:** saving a snapshot can fail with "cannot read property uuid of undefined" ([85fe1f3](https://github.com/IBM/kui/commit/85fe1f3)), closes [#5913](https://github.com/IBM/kui/issues/5913)
- **plugins/plugin-client-common:** selecting text in prior Input causes selection to be lost and Input to enter edit mode ([4d977d2](https://github.com/IBM/kui/commit/4d977d2)), closes [#5792](https://github.com/IBM/kui/issues/5792)
- **plugins/plugin-client-common:** some small tweaks to Commentary headers would help ([b012f8d](https://github.com/IBM/kui/commit/b012f8d)), closes [#5893](https://github.com/IBM/kui/issues/5893)
- **plugins/plugin-client-common:** tab switching can be slow on windows ([09f9b7d](https://github.com/IBM/kui/commit/09f9b7d)), closes [#5907](https://github.com/IBM/kui/issues/5907)
- **plugins/plugin-client-common:** TabCompletion UI can fail ([cc3fb6d](https://github.com/IBM/kui/commit/cc3fb6d)), closes [#6130](https://github.com/IBM/kui/issues/6130)
- **plugins/plugin-client-common:** the alert showing lost connection has incorrect height ([1758758](https://github.com/IBM/kui/commit/1758758)), closes [#5905](https://github.com/IBM/kui/issues/5905)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-client-common:** welcome.json could use some wordsmithing ([e373ab4](https://github.com/IBM/kui/commit/e373ab4)), closes [#5895](https://github.com/IBM/kui/issues/5895)
- **plugins/plugin-client-common): regression validateDOMNesting(...:** <pre> cannot appear as a descendant of <p> ([1a2cccf](https://github.com/IBM/kui/commit/1a2cccf)), closes [#5900](https://github.com/IBM/kui/issues/5900)
- blocks can still disappear if table row is clicked while the enclosing block is focused ([2173af1](https://github.com/IBM/kui/commit/2173af1)), closes [#5814](https://github.com/IBM/kui/issues/5814)
- ls comand is not snapshotable ([f04ca78](https://github.com/IBM/kui/commit/f04ca78)), closes [#5241](https://github.com/IBM/kui/issues/5241)
- Notebook title "Kui Setting" should be "Kui Settings" ([b14b130](https://github.com/IBM/kui/commit/b14b130)), closes [#5870](https://github.com/IBM/kui/issues/5870)
- preferReExecute is lost when re-saving a notebook ([87c6c6f](https://github.com/IBM/kui/commit/87c6c6f)), closes [#5954](https://github.com/IBM/kui/issues/5954)
- re-saving a notebook via File/Save application menu does not preserve notebook title ([7fb8b43](https://github.com/IBM/kui/commit/7fb8b43)), closes [#5777](https://github.com/IBM/kui/issues/5777)
- Switching Carbon tabs can cause content to scroll off-viewport ([51a2aad](https://github.com/IBM/kui/commit/51a2aad)), closes [#6014](https://github.com/IBM/kui/issues/6014)
- **plugins/plugin-client-common:** when replaying notebooks, tab should be scrolled to top ([6567412](https://github.com/IBM/kui/commit/6567412)), closes [#5860](https://github.com/IBM/kui/issues/5860)
- **plugins/plugins-client-common:** Carbon Accordion spi should have more contrast ([c0de84d](https://github.com/IBM/kui/commit/c0de84d)), closes [#6111](https://github.com/IBM/kui/issues/6111)
- remove up/down actions buttons ([3c8a8a1](https://github.com/IBM/kui/commit/3c8a8a1)), closes [#5774](https://github.com/IBM/kui/issues/5774)
- **plugin-client-common:** show the last input block in minisplit ([7997ef0](https://github.com/IBM/kui/commit/7997ef0)), closes [#5756](https://github.com/IBM/kui/issues/5756)
- **plugins/plugin-client-common:** a few small refinements to "editing" UI for Inputs ([001236a](https://github.com/IBM/kui/commit/001236a)), closes [#5656](https://github.com/IBM/kui/issues/5656) [#5658](https://github.com/IBM/kui/issues/5658)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** colored squares in status column of tables have odd alignment ([3e78540](https://github.com/IBM/kui/commit/3e78540)), closes [#5766](https://github.com/IBM/kui/issues/5766)
- **plugins/plugin-client-common:** Commentary editor can easily overflow when editing in minisplit ([eb14074](https://github.com/IBM/kui/commit/eb14074)), closes [#5675](https://github.com/IBM/kui/issues/5675)
- **plugins/plugin-client-common:** Commentary editor is 5px tall when presented in mini split ([53074d1](https://github.com/IBM/kui/commit/53074d1)), closes [#5744](https://github.com/IBM/kui/issues/5744)
- **plugins/plugin-client-common:** Commentary editor should be full width always ([e0a164a](https://github.com/IBM/kui/commit/e0a164a)), closes [#5688](https://github.com/IBM/kui/issues/5688)
- **plugins/plugin-client-common:** Commentary is always full width ([1920fb9](https://github.com/IBM/kui/commit/1920fb9)), closes [#5705](https://github.com/IBM/kui/issues/5705)
- **plugins/plugin-client-common:** Do not focus Block when user expands SourceRef ([6642514](https://github.com/IBM/kui/commit/6642514)), closes [#5711](https://github.com/IBM/kui/issues/5711)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** don't show `isTabLayoutModificationResponse` and PresentedElseWhere response in MiniSplit ([a16767a](https://github.com/IBM/kui/commit/a16767a)), closes [#5690](https://github.com/IBM/kui/issues/5690)
- **plugins/plugin-client-common:** Editing Commentary should require double click ([efaded3](https://github.com/IBM/kui/commit/efaded3)), closes [#5686](https://github.com/IBM/kui/issues/5686)
- **plugins/plugin-client-common:** empty blocks have excessive height ([12c39b0](https://github.com/IBM/kui/commit/12c39b0)), closes [#5707](https://github.com/IBM/kui/issues/5707)
- **plugins/plugin-client-common:** improve look of `code` snippets in Commentary ([493e004](https://github.com/IBM/kui/commit/493e004)), closes [#5768](https://github.com/IBM/kui/issues/5768)
- **plugins/plugin-client-common:** increase contrast of unfocused left-stripes for blocks ([ab21295](https://github.com/IBM/kui/commit/ab21295)), closes [#5754](https://github.com/IBM/kui/issues/5754)
- **plugins/plugin-client-common:** input probably needs to word-wrap while in minisplits ([cde272d](https://github.com/IBM/kui/commit/cde272d)), closes [#5696](https://github.com/IBM/kui/issues/5696)
- **plugins/plugin-client-common:** input spinner is not visible in minisplits ([76eec59](https://github.com/IBM/kui/commit/76eec59)), closes [#5684](https://github.com/IBM/kui/issues/5684)
- **plugins/plugin-client-common:** Lots of little layout issues, e.g. SimpleEditor is not fully width in minisplits ([5a9a1c6](https://github.com/IBM/kui/commit/5a9a1c6)), closes [#5679](https://github.com/IBM/kui/issues/5679) [#5680](https://github.com/IBM/kui/issues/5680)
- **plugins/plugin-client-common:** markdown with <a> inside <h1> renders with odd font size ([b5e3007](https://github.com/IBM/kui/commit/b5e3007)), closes [#5724](https://github.com/IBM/kui/issues/5724)
- **plugins/plugin-client-common:** monaco highlight color used by SourceRef has low contrast ([385f35e](https://github.com/IBM/kui/commit/385f35e)), closes [#5713](https://github.com/IBM/kui/issues/5713)
- **plugins/plugin-client-common:** never show "ok" ([d1b337a](https://github.com/IBM/kui/commit/d1b337a)), closes [#5697](https://github.com/IBM/kui/issues/5697)
- **plugins/plugin-client-common:** Output-only blocks probably don't need a re-execute button ([251a81c](https://github.com/IBM/kui/commit/251a81c)), closes [#5662](https://github.com/IBM/kui/issues/5662)
- **plugins/plugin-client-common:** presented elsewhere text is not vertically centered in block ([766d355](https://github.com/IBM/kui/commit/766d355)), closes [#5760](https://github.com/IBM/kui/issues/5760)
- **plugins/plugin-client-common:** status stripe "blue" color probably needs to be toned done ([137442f](https://github.com/IBM/kui/commit/137442f)), closes [#5772](https://github.com/IBM/kui/issues/5772)
- don't show the `open` command for clicking files in `ls` table ([03ef269](https://github.com/IBM/kui/commit/03ef269)), closes [#5748](https://github.com/IBM/kui/issues/5748)
- for replayed notebooks, don’t show timestamp ([951abc5](https://github.com/IBM/kui/commit/951abc5)), closes [#5763](https://github.com/IBM/kui/issues/5763)
- output only Actions should also render on hover ([cdbd105](https://github.com/IBM/kui/commit/cdbd105)), closes [#5652](https://github.com/IBM/kui/issues/5652)
- **plugin-client-common:** RadioTable onSelect changes do not always result in status stripe updates ([3549b7a](https://github.com/IBM/kui/commit/3549b7a)), closes [#5644](https://github.com/IBM/kui/issues/5644)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- **plugins/plugin-client-common:** Whem moving blocks, the moved block is not longer focused after the move ([fc13198](https://github.com/IBM/kui/commit/fc13198)), closes [#5612](https://github.com/IBM/kui/issues/5612)
- **plugins/plugin-client-common:** avoid inner scrolling in Commentary cards ([d3ea558](https://github.com/IBM/kui/commit/d3ea558)), closes [#5517](https://github.com/IBM/kui/issues/5517)
- **plugins/plugin-client-common:** Block Action buttons have poor contrast in dark themes ([f52511e](https://github.com/IBM/kui/commit/f52511e)), closes [#5590](https://github.com/IBM/kui/issues/5590)
- **plugins/plugin-client-common:** Block Actions should be top-aligned in output-only blocks ([55ce899](https://github.com/IBM/kui/commit/55ce899)), closes [#5595](https://github.com/IBM/kui/issues/5595)
- **plugins/plugin-client-common:** block left-border is not centered with In[1] text in minisplits ([4df61cc](https://github.com/IBM/kui/commit/4df61cc)), closes [#5585](https://github.com/IBM/kui/issues/5585)
- **plugins/plugin-client-common:** Commentary blocks are not focusable in minisplits ([1286b0d](https://github.com/IBM/kui/commit/1286b0d)), closes [#5594](https://github.com/IBM/kui/issues/5594)
- **plugins/plugin-client-common:** Commentary paragraphs have no separation ([6b77a13](https://github.com/IBM/kui/commit/6b77a13)), closes [#5531](https://github.com/IBM/kui/issues/5531)
- **plugins/plugin-client-common:** custom tab titles may have monospace font ([b34b5a4](https://github.com/IBM/kui/commit/b34b5a4)), closes [#5527](https://github.com/IBM/kui/issues/5527)
- **plugins/plugin-client-common:** don't show "2 rows" table header for short tables ([2350115](https://github.com/IBM/kui/commit/2350115)), closes [#5581](https://github.com/IBM/kui/issues/5581)
- **plugins/plugin-client-common:** h2 in Notebooks have double underline ([40a4bd1](https://github.com/IBM/kui/commit/40a4bd1)), closes [#5574](https://github.com/IBM/kui/issues/5574)
- **plugins/plugin-client-common:** improved focus behavior of terminals ([f5a3dd0](https://github.com/IBM/kui/commit/f5a3dd0)), closes [#5615](https://github.com/IBM/kui/issues/5615)
- **plugins/plugin-client-common:** on switching tabs, active prompt isn't always focused ([5b28dd2](https://github.com/IBM/kui/commit/5b28dd2)), closes [#5637](https://github.com/IBM/kui/issues/5637)
- **plugins/plugin-client-common:** re-snapshoting a notebook can fail ([4caff9c](https://github.com/IBM/kui/commit/4caff9c)), closes [#5736](https://github.com/IBM/kui/issues/5736)
- **plugins/plugin-client-common:** SequenceDiagram bars are too narrow ([a0ed13a](https://github.com/IBM/kui/commit/a0ed13a)), closes [#5544](https://github.com/IBM/kui/issues/5544)
- **plugins/plugin-client-common:** SourceRef does not respond to all tab layout changes ([d3e8b32](https://github.com/IBM/kui/commit/d3e8b32)), closes [#5552](https://github.com/IBM/kui/issues/5552)
- **plugins/plugin-client-common:** StatusStripe is blank for second+ tabs ([0002dfb](https://github.com/IBM/kui/commit/0002dfb)), closes [#5546](https://github.com/IBM/kui/issues/5546)
- **plugins/plugin-client-common:** StatusStripe widgets can emit react error when switching to notebook tab ([485fcdf](https://github.com/IBM/kui/commit/485fcdf)), closes [#5639](https://github.com/IBM/kui/issues/5639)
- "created split" message should disappear when corresponding split is closed ([f8486f8](https://github.com/IBM/kui/commit/f8486f8)), closes [#5629](https://github.com/IBM/kui/issues/5629)
- **plugins-client-common:** the experimental tag should use sans serif ([143464a](https://github.com/IBM/kui/commit/143464a)), closes [#5363](https://github.com/IBM/kui/issues/5363)
- **plugins/plugin-client-common:** defer loading of both icon sets ([7d343b8](https://github.com/IBM/kui/commit/7d343b8)), closes [#5444](https://github.com/IBM/kui/issues/5444)
- **plugins/plugin-client-common:** don't line-wrap input elements in MiniSplits ([c929f5e](https://github.com/IBM/kui/commit/c929f5e)), closes [#5348](https://github.com/IBM/kui/issues/5348)
- **plugins/plugin-client-common:** experiment tag has wrong color contrast in dark themes ([22bfb77](https://github.com/IBM/kui/commit/22bfb77)), closes [#5389](https://github.com/IBM/kui/issues/5389)
- **plugins/plugin-client-common:** Experimental badge should take up less space in minisplits ([268aeb3](https://github.com/IBM/kui/commit/268aeb3)), closes [#5373](https://github.com/IBM/kui/issues/5373)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** improve behavior of up arrow for first command in MiniSplits ([ed199d4](https://github.com/IBM/kui/commit/ed199d4)), closes [#5297](https://github.com/IBM/kui/issues/5297)
- **plugins/plugin-client-common:** improve layout of In[1] with sidecar open ([263d59a](https://github.com/IBM/kui/commit/263d59a)), closes [#5482](https://github.com/IBM/kui/issues/5482)
- **plugins/plugin-client-common:** improve rendering of output only blocks ([664a8da](https://github.com/IBM/kui/commit/664a8da)), closes [#5467](https://github.com/IBM/kui/issues/5467)
- **plugins/plugin-client-common:** improve row hover effect for SequenceDiagram ([89dbe2a](https://github.com/IBM/kui/commit/89dbe2a)), closes [#5426](https://github.com/IBM/kui/issues/5426)
- **plugins/plugin-client-common:** inconsistent top padding above Cards ([1e1037f](https://github.com/IBM/kui/commit/1e1037f)), closes [#5299](https://github.com/IBM/kui/issues/5299)
- **plugins/plugin-client-common:** increase density of SequenceDiagram ([ae29488](https://github.com/IBM/kui/commit/ae29488)), closes [#5344](https://github.com/IBM/kui/issues/5344)
- **plugins/plugin-client-common:** long input lines should line wrap ([8804bb1](https://github.com/IBM/kui/commit/8804bb1)), closes [#5338](https://github.com/IBM/kui/issues/5338)
- **plugins/plugin-client-common:** minor spacing improvements for Commentary and Notebooks ([c473181](https://github.com/IBM/kui/commit/c473181)), closes [#5503](https://github.com/IBM/kui/issues/5503)
- **plugins/plugin-client-common:** regression in columnar alignment of Input and Output ([cf1a836](https://github.com/IBM/kui/commit/cf1a836)), closes [#5507](https://github.com/IBM/kui/issues/5507)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- **plugins/plugin-client-common:** refine Timeline a bit more ([4b12eec](https://github.com/IBM/kui/commit/4b12eec)), closes [#5409](https://github.com/IBM/kui/issues/5409)
- **plugins/plugin-client-common:** restore history navigation behavior in minisplits ([26f49e8](https://github.com/IBM/kui/commit/26f49e8)), closes [#5375](https://github.com/IBM/kui/issues/5375)
- **plugins/plugin-client-common:** reverse-i-search incorrectly changes match as i type ([135d429](https://github.com/IBM/kui/commit/135d429)), closes [#5403](https://github.com/IBM/kui/issues/5403)
- **plugins/plugin-client-common:** SequenceDiagram bars may extend beyond the 100% line ([34d03bc](https://github.com/IBM/kui/commit/34d03bc)), closes [#5465](https://github.com/IBM/kui/issues/5465)
- **plugins/plugin-client-common:** tab completion UI does not render on separate line from input ([61b169b](https://github.com/IBM/kui/commit/61b169b)), closes [#5307](https://github.com/IBM/kui/issues/5307)
- **plugins/plugin-client-common:** table screenshots include a gray stripe at the top ([11a9fc3](https://github.com/IBM/kui/commit/11a9fc3)), closes [#5410](https://github.com/IBM/kui/issues/5410)
- **plugins/plugin-client-common:** TableCell view can fail when given empty duration cells ([04251be](https://github.com/IBM/kui/commit/04251be)), closes [#5332](https://github.com/IBM/kui/issues/5332)
- **plugins/plugin-client-common:** update SequenceDiagram view to display the duration of each interval ([0cf1fcf](https://github.com/IBM/kui/commit/0cf1fcf)), closes [#5470](https://github.com/IBM/kui/issues/5470)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- **plugins/plugin-client-common:** switching table from Table to Timeline and back to Table does not work ([c924d67](https://github.com/IBM/kui/commit/c924d67)), closes [#5430](https://github.com/IBM/kui/issues/5430)
- **plugins/plugin-client-common:** threshold for auto-grid is too low ([9cb76ee](https://github.com/IBM/kui/commit/9cb76ee)), closes [#5424](https://github.com/IBM/kui/issues/5424)
- **plugins/plugin-client-common:** Timeline may not render properly ([d66d728](https://github.com/IBM/kui/commit/d66d728)), closes [#5383](https://github.com/IBM/kui/issues/5383)
- **plugins/plugin-client-common:** Timeline tooltip for cold starts has incorrect concurrency count ([bb54cb8](https://github.com/IBM/kui/commit/bb54cb8)), closes [#5390](https://github.com/IBM/kui/issues/5390)
- **plugins/plugin-ibmcloud:** ibmcloud ce job list does not support name filters ([5daa930](https://github.com/IBM/kui/commit/5daa930)), closes [#5450](https://github.com/IBM/kui/issues/5450)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- improved support for replaying splits ([8039a9d](https://github.com/IBM/kui/commit/8039a9d)), closes [#5535](https://github.com/IBM/kui/issues/5535)
- new tab command can hang if title is provided ([a6c25c6](https://github.com/IBM/kui/commit/a6c25c6)), closes [#5624](https://github.com/IBM/kui/issues/5624)
- notebook replay should scroll to top, and not display welcome message on every tab ([7ade801](https://github.com/IBM/kui/commit/7ade801)), closes [#5515](https://github.com/IBM/kui/issues/5515) [#5516](https://github.com/IBM/kui/issues/5516)
- pty output has different indentation than kui command output ([30b10a3](https://github.com/IBM/kui/commit/30b10a3)), closes [#5542](https://github.com/IBM/kui/issues/5542)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- tab new command should respond with ElsewhereCommentary response ([19a7e1d](https://github.com/IBM/kui/commit/19a7e1d)), closes [#5602](https://github.com/IBM/kui/issues/5602)
- terminal clearing versus splits results in non-replayable splits ([8f9dc23](https://github.com/IBM/kui/commit/8f9dc23)), closes [#5626](https://github.com/IBM/kui/issues/5626)
- **plugins/plugin-client-common:** add support for titles in commentary ([fbe367c](https://github.com/IBM/kui/commit/fbe367c)), closes [#5434](https://github.com/IBM/kui/issues/5434)
- **plugins/plugin-client-common:** always place table events in the Card footer ([b667b28](https://github.com/IBM/kui/commit/b667b28)), closes [#5210](https://github.com/IBM/kui/issues/5210)
- **plugins/plugin-client-common:** buggy header UI in dark themes in minisplits ([55aef48](https://github.com/IBM/kui/commit/55aef48)), closes [#5266](https://github.com/IBM/kui/issues/5266)
- **plugins/plugin-client-common:** clicking on pod delete button can cause command to be executed in minisplit ([37f9019](https://github.com/IBM/kui/commit/37f9019)), closes [#5247](https://github.com/IBM/kui/issues/5247)
- **plugins/plugin-client-common:** close tabs doesn't produce the correct tab content ([6090887](https://github.com/IBM/kui/commit/6090887)), closes [#5220](https://github.com/IBM/kui/issues/5220)
- **plugins/plugin-client-common:** CSS no longer is reactive to narrow window ([4eb0a11](https://github.com/IBM/kui/commit/4eb0a11)), closes [#5290](https://github.com/IBM/kui/issues/5290)
- **plugins/plugin-client-common:** don't use fixed maxHeight for Terminal tables ([0e23e22](https://github.com/IBM/kui/commit/0e23e22)), closes [#5206](https://github.com/IBM/kui/issues/5206)
- **plugins/plugin-client-common:** Events footer in minisplit tables lacks horizontal padding ([f22b1f7](https://github.com/IBM/kui/commit/f22b1f7)), closes [#5196](https://github.com/IBM/kui/issues/5196)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** layout regressions from table screenshot PRs ([8004ee3](https://github.com/IBM/kui/commit/8004ee3)), closes [#5159](https://github.com/IBM/kui/issues/5159)
- **plugins/plugin-client-common:** multi-line paste executes commands out of order ([8f39c80](https://github.com/IBM/kui/commit/8f39c80)), closes [#5295](https://github.com/IBM/kui/issues/5295)
- **plugins/plugin-client-common:** remove active prompts in an offline notebook ([dd2b53f](https://github.com/IBM/kui/commit/dd2b53f)), closes [#5620](https://github.com/IBM/kui/issues/5620)
- **plugins/plugin-client-common:** SequenceDiagram can have NaNs in the UI ([ac476a6](https://github.com/IBM/kui/commit/ac476a6)), closes [#5559](https://github.com/IBM/kui/issues/5559)
- **plugins/plugin-client-common:** SourceRef viewer should hide liner numbers but show folding ([5f74a46](https://github.com/IBM/kui/commit/5f74a46)), closes [#5719](https://github.com/IBM/kui/issues/5719)
- **plugins/plugin-client-common:** table bottom toolbar buttons lack padding ([79f0abe](https://github.com/IBM/kui/commit/79f0abe)), closes [#5554](https://github.com/IBM/kui/issues/5554)
- **plugins/plugin-client-common:** table cells with no onclick handler still issue a kui command ([4d8bf37](https://github.com/IBM/kui/commit/4d8bf37)), closes [#5721](https://github.com/IBM/kui/issues/5721)
- **plugins/plugin-client-common:** table is misaligned with command input ([50dc430](https://github.com/IBM/kui/commit/50dc430)), closes [#5734](https://github.com/IBM/kui/issues/5734)
- **plugins/plugin-client-common:** there is still too much whitespace after no-response commands ([268f159](https://github.com/IBM/kui/commit/268f159)), closes [#5742](https://github.com/IBM/kui/issues/5742)
- **plugins/plugin-client-common:** update welcome.json notebook to improve listing of available notebooks ([c6f89f4](https://github.com/IBM/kui/commit/c6f89f4)), closes [#5583](https://github.com/IBM/kui/issues/5583)
- multiple command history regressions ([cbba96c](https://github.com/IBM/kui/commit/cbba96c)), closes [#5283](https://github.com/IBM/kui/issues/5283)
- replay --freshen does not support multi-split notebooks ([afd070c](https://github.com/IBM/kui/commit/afd070c)), closes [#5571](https://github.com/IBM/kui/issues/5571) [#5572](https://github.com/IBM/kui/issues/5572)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- **plugins/plugin-client-common:** `ok` string appears at the end of MixResponse ([75606c5](https://github.com/IBM/kui/commit/75606c5)), closes [#5046](https://github.com/IBM/kui/issues/5046)
- **plugins/plugin-client-common:** a few more rem/em font-size issues ([133b347](https://github.com/IBM/kui/commit/133b347)), closes [#5058](https://github.com/IBM/kui/issues/5058)
- **plugins/plugin-client-common:** borders in top tab stripe are too light ([3908695](https://github.com/IBM/kui/commit/3908695)), closes [#5051](https://github.com/IBM/kui/issues/5051)
- **plugins/plugin-client-common:** clearing Terminal does not abort watchers ([34adb50](https://github.com/IBM/kui/commit/34adb50)), closes [#5116](https://github.com/IBM/kui/issues/5116)
- **plugins/plugin-client-common:** clicking 'remove' of a watchable response doesn't abort the underlying pty job ([7eb69fb](https://github.com/IBM/kui/commit/7eb69fb)), closes [#5090](https://github.com/IBM/kui/issues/5090)
- **plugins/plugin-client-common:** clicking to focus on a split does not always cause full focus effect ([bc59bcf](https://github.com/IBM/kui/commit/bc59bcf)), closes [#5263](https://github.com/IBM/kui/issues/5263)
- **plugins/plugin-client-common:** decrease height of table footer ([5863622](https://github.com/IBM/kui/commit/5863622)), closes [#5072](https://github.com/IBM/kui/issues/5072)
- **plugins/plugin-client-common:** disableTableTitle also disables title of watch panes ([053cfb6](https://github.com/IBM/kui/commit/053cfb6)), closes [#5036](https://github.com/IBM/kui/issues/5036)
- **plugins/plugin-client-common:** double watch panes may open up ([7fb70f1](https://github.com/IBM/kui/commit/7fb70f1)), closes [#5034](https://github.com/IBM/kui/issues/5034)
- **plugins/plugin-client-common:** editor component does not respond to font zooming ([7b7e0f3](https://github.com/IBM/kui/commit/7b7e0f3)), closes [#5120](https://github.com/IBM/kui/issues/5120)
- **plugins/plugin-client-common:** eliminate react "titleInHeader" console warnings ([8cf3797](https://github.com/IBM/kui/commit/8cf3797)), closes [#5078](https://github.com/IBM/kui/issues/5078)
- **plugins/plugin-client-common:** Events drilldown from watch table does not always work ([09aee73](https://github.com/IBM/kui/commit/09aee73)), closes [#5204](https://github.com/IBM/kui/issues/5204)
- **plugins/plugin-client-common:** Events should also be placed in table footer (not tbody) when sidecar is open or 2-way terminal split ([1391b1d](https://github.com/IBM/kui/commit/1391b1d)), closes [#5198](https://github.com/IBM/kui/issues/5198)
- **plugins/plugin-client-common:** font size issues with LeftNavSidecar ([e17fc15](https://github.com/IBM/kui/commit/e17fc15)), closes [#5048](https://github.com/IBM/kui/issues/5048)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** improve display of tables in side-by-side terminal splits ([5a32255](https://github.com/IBM/kui/commit/5a32255)), closes [#5201](https://github.com/IBM/kui/issues/5201)
- **plugins/plugin-client-common:** improve spacing of Event footer content ([d63a6f1](https://github.com/IBM/kui/commit/d63a6f1)), closes [#5178](https://github.com/IBM/kui/issues/5178)
- **plugins/plugin-client-common:** improve top tab bottom UI ([8ff4151](https://github.com/IBM/kui/commit/8ff4151)), closes [#5056](https://github.com/IBM/kui/issues/5056)
- **plugins/plugin-client-common:** input may not receive focus on tab switch ([7676792](https://github.com/IBM/kui/commit/7676792)), closes [#5102](https://github.com/IBM/kui/issues/5102)
- **plugins/plugin-client-common:** leftover debug printfs in table sorting ([9889b49](https://github.com/IBM/kui/commit/9889b49)), closes [#5030](https://github.com/IBM/kui/issues/5030)
- **plugins/plugin-client-common:** Light tables should use Carbon compact ([2309ec3](https://github.com/IBM/kui/commit/2309ec3)), closes [#5059](https://github.com/IBM/kui/issues/5059)
- **plugins/plugin-client-common:** minor improvements for ls -l output ([1b59c94](https://github.com/IBM/kui/commit/1b59c94)), closes [#5216](https://github.com/IBM/kui/issues/5216)
- **plugins/plugin-client-common:** one-row tables needn't offer column sorting UI ([5184fa1](https://github.com/IBM/kui/commit/5184fa1)), closes [#5050](https://github.com/IBM/kui/issues/5050)
- **plugins/plugin-client-common:** only highlight the Active block in the focused split ([feffad4](https://github.com/IBM/kui/commit/feffad4)), closes [#5261](https://github.com/IBM/kui/issues/5261)
- **plugins/plugin-client-common:** pty commands fail in minisplits ([475ea74](https://github.com/IBM/kui/commit/475ea74)), closes [#5267](https://github.com/IBM/kui/issues/5267)
- **plugins/plugin-client-common:** RadioTable screenshots lack box shadow ([b0e0f2e](https://github.com/IBM/kui/commit/b0e0f2e)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** RadioTables can have gratuituous line wrapping ([9c39682](https://github.com/IBM/kui/commit/9c39682)), closes [#5139](https://github.com/IBM/kui/issues/5139)
- **plugins/plugin-client-common:** reduce contrast of block left bars ([7c8d371](https://github.com/IBM/kui/commit/7c8d371)), closes [#5275](https://github.com/IBM/kui/issues/5275)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** Tables should have a max-height and use inner scrolling for overflow ([642ef14](https://github.com/IBM/kui/commit/642ef14)), closes [#5153](https://github.com/IBM/kui/issues/5153)
- **plugins/plugin-client-common:** Tables with identical column names render incorrectly ([161dba2](https://github.com/IBM/kui/commit/161dba2)), closes [#5129](https://github.com/IBM/kui/issues/5129)
- **plugins/plugin-client-common:** Terminal Block -> Screenshot of table does not capture box shadow ([ed812f3](https://github.com/IBM/kui/commit/ed812f3)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** watch pane grid cells too large ([225f937](https://github.com/IBM/kui/commit/225f937)), closes [#5070](https://github.com/IBM/kui/issues/5070)
- **plugins/plugin-client-common:** WatchPane has incorrect padding ([e74bd7b](https://github.com/IBM/kui/commit/e74bd7b)), closes [#5015](https://github.com/IBM/kui/issues/5015)
- **plugins/plugin-client-common:** while editing Commentary, adding ``` causes a bad error ([097b1b0](https://github.com/IBM/kui/commit/097b1b0)), closes [#5682](https://github.com/IBM/kui/issues/5682)
- **plugins/plugin-client-default:** improve debug logging of client properties ([4daba1f](https://github.com/IBM/kui/commit/4daba1f)), closes [#5088](https://github.com/IBM/kui/issues/5088)
- **plugins/plugin-core-support:** sidecar "window" buttons are too large ([33415d2](https://github.com/IBM/kui/commit/33415d2)), closes [#5094](https://github.com/IBM/kui/issues/5094)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- Card component does not render well in dark themes ([d96def0](https://github.com/IBM/kui/commit/d96def0)), closes [#4996](https://github.com/IBM/kui/issues/4996)
- clients should be able to enable watcher auto pinning without enabling splitTerminals ([bcade13](https://github.com/IBM/kui/commit/bcade13)), closes [#5002](https://github.com/IBM/kui/issues/5002)
- Confirm dialog color contrast issues ([da14c25](https://github.com/IBM/kui/commit/da14c25)), closes [#4995](https://github.com/IBM/kui/issues/4995)
- Editor component does not respond to tab layout changes ([9756336](https://github.com/IBM/kui/commit/9756336)), closes [#5231](https://github.com/IBM/kui/issues/5231) [#5232](https://github.com/IBM/kui/issues/5232)
- increase contrast in watch pane ([246ecd2](https://github.com/IBM/kui/commit/246ecd2)), closes [#5000](https://github.com/IBM/kui/issues/5000) [#5001](https://github.com/IBM/kui/issues/5001)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- move default loadingDone icon into plugin-client-common ([39994bc](https://github.com/IBM/kui/commit/39994bc)), closes [#5026](https://github.com/IBM/kui/issues/5026)
- move patternfly alignment out of patternfly themes plugin ([6adbfd6](https://github.com/IBM/kui/commit/6adbfd6)), closes [#4988](https://github.com/IBM/kui/issues/4988)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- **plugins/plugin-client-common:** add error icon for error blocks ([5d9aeea](https://github.com/IBM/kui/commit/5d9aeea)), closes [#4907](https://github.com/IBM/kui/issues/4907)
- **plugins/plugin-client-common:** carbon breadcrumbs may not have proper hover effect ([c8cd2d1](https://github.com/IBM/kui/commit/c8cd2d1)), closes [#4962](https://github.com/IBM/kui/issues/4962)
- **plugins/plugin-client-common:** clicking the remove button of a repl block results in an error white screen ([49bfbcc](https://github.com/IBM/kui/commit/49bfbcc)), closes [#4855](https://github.com/IBM/kui/issues/4855)
- **plugins/plugin-client-common:** improve Terminal screenshots by adding padding ([a9b7b26](https://github.com/IBM/kui/commit/a9b7b26)), closes [#4981](https://github.com/IBM/kui/issues/4981)
- **plugins/plugin-client-common:** in Popup mode, use > rather than / for prompt in bottom input ([1360bed](https://github.com/IBM/kui/commit/1360bed)), closes [#4887](https://github.com/IBM/kui/issues/4887)
- **plugins/plugin-client-common:** kubectl edit saves can result in unstyled notification ([5dc658e](https://github.com/IBM/kui/commit/5dc658e)), closes [#4930](https://github.com/IBM/kui/issues/4930)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** poor alignment of sidecar toolbar elements ([2307a46](https://github.com/IBM/kui/commit/2307a46)), closes [#4970](https://github.com/IBM/kui/issues/4970)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** regression: non-empty repl output has 'ok' at the end ([103a0f9](https://github.com/IBM/kui/commit/103a0f9)), closes [#4924](https://github.com/IBM/kui/issues/4924)
- **plugins/plugin-client-common:** reverse-i-search does not properly report no matches ([c16dad3](https://github.com/IBM/kui/commit/c16dad3)), closes [#4943](https://github.com/IBM/kui/issues/4943)
- **plugins/plugin-client-common:** Screenshot modal never goes away ([bbd1c98](https://github.com/IBM/kui/commit/bbd1c98)), closes [#4979](https://github.com/IBM/kui/issues/4979)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- **plugins/plugin-client-common:** spurious warning in the console re: Tag ([93982de](https://github.com/IBM/kui/commit/93982de)), closes [#4959](https://github.com/IBM/kui/issues/4959)
- **plugins/plugin-client-common:** status cells of live tables do not always blink ([c94b05e](https://github.com/IBM/kui/commit/c94b05e)), closes [#4903](https://github.com/IBM/kui/issues/4903)
- **plugins/plugin-client-common:** UpdateNotification widget has invisible background color ([c0c1d82](https://github.com/IBM/kui/commit/c0c1d82)), closes [#4968](https://github.com/IBM/kui/issues/4968)
- **plugins/plugin-patternfly-themes:** update theme alignment to patternfly v4 ([3784b96](https://github.com/IBM/kui/commit/3784b96)), closes [#4948](https://github.com/IBM/kui/issues/4948)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- erratic scroll region behavior ([be0e2a0](https://github.com/IBM/kui/commit/be0e2a0)), closes [#4898](https://github.com/IBM/kui/issues/4898)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- page-content p should not use text-align: justify ([2646f4b](https://github.com/IBM/kui/commit/2646f4b)), closes [#4908](https://github.com/IBM/kui/issues/4908)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- still see name-related breadcrumbs and short-name header with feature flag sidecarName 'heroText' ([1a8be9f](https://github.com/IBM/kui/commit/1a8be9f)), closes [#5013](https://github.com/IBM/kui/issues/5013)
- upgrade @patternfly/react-core to latest ([0331533](https://github.com/IBM/kui/commit/0331533)), closes [#4937](https://github.com/IBM/kui/issues/4937)
- **plugins/plugin-client-common:** split button errors are not reported to the user ([fc4e2a2](https://github.com/IBM/kui/commit/fc4e2a2)), closes [#4876](https://github.com/IBM/kui/issues/4876)
- **plugins/plugin-client-common:** table container should only be width:100% for table not display-as-grid ([8f327cd](https://github.com/IBM/kui/commit/8f327cd)), closes [#4871](https://github.com/IBM/kui/issues/4871)
- **plugins/plugn-client-common:** TopTabStripe stays blue after command execution completes ([68f5841](https://github.com/IBM/kui/commit/68f5841)), closes [#4883](https://github.com/IBM/kui/issues/4883)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- split screen terminals sometimes incorrect handle exit ([d63cde7](https://github.com/IBM/kui/commit/d63cde7)), closes [#4860](https://github.com/IBM/kui/issues/4860)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** reverse the dependency of Card and DropDown ([00b8ecf](https://github.com/IBM/kui/commit/00b8ecf)), closes [#4641](https://github.com/IBM/kui/issues/4641)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- **plugins/plugin-client-common:** top tab buttons should be owned by the top tab stripe ([9a45c43](https://github.com/IBM/kui/commit/9a45c43)), closes [#4690](https://github.com/IBM/kui/issues/4690)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- sidecar back/forward should be ordered by visitation rather than insertion ([fba613a](https://github.com/IBM/kui/commit/fba613a)), closes [#4746](https://github.com/IBM/kui/issues/4746)
- sidecar container selection kebab has different color with its menu ([639617a](https://github.com/IBM/kui/commit/639617a)), closes [#4676](https://github.com/IBM/kui/issues/4676)
- TopNavSidecar doesn't return to the previous selected Tab when back button is hit ([32acee5](https://github.com/IBM/kui/commit/32acee5)), closes [#4745](https://github.com/IBM/kui/issues/4745)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** dropdown in sidecar theming and spacing tweaks ([1a48af3](https://github.com/IBM/kui/commit/1a48af3)), closes [#4680](https://github.com/IBM/kui/issues/4680)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** improve visibility of sidecar scrollbars ([827d75a](https://github.com/IBM/kui/commit/827d75a)), closes [#4667](https://github.com/IBM/kui/issues/4667)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** increase font size of status stripe ([2fab637](https://github.com/IBM/kui/commit/2fab637)), closes [#4698](https://github.com/IBM/kui/issues/4698)
- **plugins/plugin-client-common:** input element changes height with i-search and bottomInput ([abf9890](https://github.com/IBM/kui/commit/abf9890)), closes [#4685](https://github.com/IBM/kui/issues/4685)
- **plugins/plugin-client-common:** LeftNav sidecar nav column width inconsistency ([17e403f](https://github.com/IBM/kui/commit/17e403f)), closes [#4688](https://github.com/IBM/kui/issues/4688)
- **plugins/plugin-client-common:** LeftNavSidecar does not always reflect updated content ([0f2e1e1](https://github.com/IBM/kui/commit/0f2e1e1)), closes [#4727](https://github.com/IBM/kui/issues/4727) [#4732](https://github.com/IBM/kui/issues/4732)
- **plugins/plugin-client-common:** LeftNavSidecar font size and layout issues ([d9914f1](https://github.com/IBM/kui/commit/d9914f1)), closes [#4718](https://github.com/IBM/kui/issues/4718) [#4719](https://github.com/IBM/kui/issues/4719)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** move screenshot button out of status stripe ([0ef900b](https://github.com/IBM/kui/commit/0ef900b)), closes [#4556](https://github.com/IBM/kui/issues/4556)
- **plugins/plugin-client-common:** PatternFly DropDown rendering glitches ([8efedd8](https://github.com/IBM/kui/commit/8efedd8)), closes [#4649](https://github.com/IBM/kui/issues/4649) [#4651](https://github.com/IBM/kui/issues/4651)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** refine Loading component ([7a07ad3](https://github.com/IBM/kui/commit/7a07ad3)), closes [#4702](https://github.com/IBM/kui/issues/4702)
- **plugins/plugin-client-common:** Screenshot button should not be offered inBrowser ([d1c2cfb](https://github.com/IBM/kui/commit/d1c2cfb)), closes [#4636](https://github.com/IBM/kui/issues/4636)
- **plugins/plugin-client-common:** session init done message messes up Terminal scrolling ([7e80ac1](https://github.com/IBM/kui/commit/7e80ac1)), closes [#4683](https://github.com/IBM/kui/issues/4683)
- **plugins/plugin-client-common:** sidecar toolbar text incorrectly aligned ([ddd7460](https://github.com/IBM/kui/commit/ddd7460)), closes [#4659](https://github.com/IBM/kui/issues/4659)
- **plugins/plugin-client-common:** Terminal screenshot odd w.r.t. auto-focus ([4b1c7d8](https://github.com/IBM/kui/commit/4b1c7d8)), closes [#4739](https://github.com/IBM/kui/issues/4739)
- **plugins/plugin-client-common:** TopNavSidecar tabs easily overflow with narrower windows ([a555cd4](https://github.com/IBM/kui/commit/a555cd4)), closes [#4735](https://github.com/IBM/kui/issues/4735)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane has non-zero height even when empty ([67a7070](https://github.com/IBM/kui/commit/67a7070)), closes [#4629](https://github.com/IBM/kui/issues/4629)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- switching splits does not participate in tab state ([6eb8db4](https://github.com/IBM/kui/commit/6eb8db4)), closes [#5272](https://github.com/IBM/kui/issues/5272)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** in plain Terminals, tables should not inner scroll ([15fcbba](https://github.com/IBM/kui/commit/15fcbba)), closes [#5221](https://github.com/IBM/kui/issues/5221)
- **plugins/plugin-client-common:** place event footer outside of table scroll region for minisplits ([e4872b2](https://github.com/IBM/kui/commit/e4872b2)), closes [#5179](https://github.com/IBM/kui/issues/5179)
- **plugins/plugin-client-common:** present more than 2 footer lines in watch tables ([3e7a78f](https://github.com/IBM/kui/commit/3e7a78f)), closes [#5213](https://github.com/IBM/kui/issues/5213)
- **plugins/plugin-client-common:** RadioTables in minisplits inner-scroll away the header row ([5296dcd](https://github.com/IBM/kui/commit/5296dcd)), closes [#5165](https://github.com/IBM/kui/issues/5165)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** regression in table width with sidecar open ([5938806](https://github.com/IBM/kui/commit/5938806)), closes [#5194](https://github.com/IBM/kui/issues/5194)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** selected row in RadioTables in dark themes has low contrast ([f2c5834](https://github.com/IBM/kui/commit/f2c5834)), closes [#5161](https://github.com/IBM/kui/issues/5161)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** sidecar badges may not be flush-right ([5b54665](https://github.com/IBM/kui/commit/5b54665)), closes [#5175](https://github.com/IBM/kui/issues/5175)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-client-common:** status column can be invisible in split tables ([c352103](https://github.com/IBM/kui/commit/c352103)), closes [#5244](https://github.com/IBM/kui/issues/5244)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** Terminal focus changes unexpectedly ([866451c](https://github.com/IBM/kui/commit/866451c)), closes [#5170](https://github.com/IBM/kui/issues/5170)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** Timeline should use stdev-based heat map ([5dd7427](https://github.com/IBM/kui/commit/5dd7427)), closes [#5395](https://github.com/IBM/kui/issues/5395)
- **plugins/plugin-client-common:** Timeline view renders poorly in MiniSplit ([07cd000](https://github.com/IBM/kui/commit/07cd000)), closes [#5379](https://github.com/IBM/kui/issues/5379)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- **plugins/plugin-client-common:** two MiniSplits with open sidecar are too short ([9e21ab9](https://github.com/IBM/kui/commit/9e21ab9)), closes [#5171](https://github.com/IBM/kui/issues/5171)
- **plugins/plugin-client-common:** watch tables might not be maximized in minisplits ([63420b2](https://github.com/IBM/kui/commit/63420b2)), closes [#5218](https://github.com/IBM/kui/issues/5218)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-commong:** show RadioTable selected row in the table body and header breadcrumb ([811c21e](https://github.com/IBM/kui/commit/811c21e)), closes [#5239](https://github.com/IBM/kui/issues/5239)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- ability to register an onClose handler when opening a tab ([58a36c3](https://github.com/IBM/kui/commit/58a36c3)), closes [#5670](https://github.com/IBM/kui/issues/5670)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add capability to click to edit/rerun a command ([4296933](https://github.com/IBM/kui/commit/4296933)), closes [#5654](https://github.com/IBM/kui/issues/5654)
- add delta summary to Tree ([95a0b4a](https://github.com/IBM/kui/commit/95a0b4a)), closes [#6329](https://github.com/IBM/kui/issues/6329)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- add unit support of TreeResponse as one of the contents in MultiModalResponse ([85ea2d5](https://github.com/IBM/kui/commit/85ea2d5)), closes [#6132](https://github.com/IBM/kui/issues/6132)
- clicking changed files in the `git status widget` should show `git diff` result in a DiffEditor ([3a199c7](https://github.com/IBM/kui/commit/3a199c7)), closes [#6348](https://github.com/IBM/kui/issues/6348)
- execute the command in url query when the browser app is loaded ([b0b95cf](https://github.com/IBM/kui/commit/b0b95cf)), closes [#5879](https://github.com/IBM/kui/issues/5879)
- Feature: improve support for parallelization across VFS operations ([e05d7e0](https://github.com/IBM/kui/commit/e05d7e0)), closes [#5831](https://github.com/IBM/kui/issues/5831)
- Improve support for designing light themes ([b6c859f](https://github.com/IBM/kui/commit/b6c859f)), closes [#6372](https://github.com/IBM/kui/issues/6372)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- introduce reexec for rerunning commands ([fe80525](https://github.com/IBM/kui/commit/fe80525)), closes [#6026](https://github.com/IBM/kui/issues/6026)
- Kui implementation of `watch` ([2cb3f98](https://github.com/IBM/kui/commit/2cb3f98)), closes [#6379](https://github.com/IBM/kui/issues/6379)
- lightweight ui options for core themes ([cf96867](https://github.com/IBM/kui/commit/cf96867)), closes [#6187](https://github.com/IBM/kui/issues/6187)
- Make a notebook about making notebooks ([0d67947](https://github.com/IBM/kui/commit/0d67947)), closes [#6040](https://github.com/IBM/kui/issues/6040)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- port experimental scale-out grep to use new job controller ([45ce460](https://github.com/IBM/kui/commit/45ce460)), closes [#6280](https://github.com/IBM/kui/issues/6280)
- Refine Update Checker widget UI ([5c97479](https://github.com/IBM/kui/commit/5c97479)), closes [#6343](https://github.com/IBM/kui/issues/6343)
- save/restore pty command output ([2c291a9](https://github.com/IBM/kui/commit/2c291a9)), closes [#5314](https://github.com/IBM/kui/issues/5314)
- update CurrentContext widget to use Dropdown ([9520e5d](https://github.com/IBM/kui/commit/9520e5d)), closes [#6354](https://github.com/IBM/kui/issues/6354)
- use a Popover UI for git branch status stripe widget ([6bbf348](https://github.com/IBM/kui/commit/6bbf348)), closes [#6325](https://github.com/IBM/kui/issues/6325)
- use Accordion for SourceRef ([1b11736](https://github.com/IBM/kui/commit/1b11736)), closes [#6097](https://github.com/IBM/kui/issues/6097)
- use new Dropdown status stripe for CurrentNamespace widget ([0f7648c](https://github.com/IBM/kui/commit/0f7648c)), closes [#6351](https://github.com/IBM/kui/issues/6351)
- UX: Use Dropdown for theme switcher ([6cc6a47](https://github.com/IBM/kui/commit/6cc6a47)), closes [#6347](https://github.com/IBM/kui/issues/6347)
- **plugins/plugin-client-common:** allow users to reorder blocks by MoveUp and MoveDown buttons ([f7f6918](https://github.com/IBM/kui/commit/f7f6918)), closes [#5589](https://github.com/IBM/kui/issues/5589)
- **plugins/plugin-client-common:** block-level copy/paste ([a72cf8d](https://github.com/IBM/kui/commit/a72cf8d)), closes [#5752](https://github.com/IBM/kui/issues/5752)
- **plugins/plugin-client-common:** edit a commentary response using SimpleEditor ([6d828c1](https://github.com/IBM/kui/commit/6d828c1)), closes [#5664](https://github.com/IBM/kui/issues/5664)
- **plugins/plugin-client-common:** error messages should format as markdown ([63ca4a7](https://github.com/IBM/kui/commit/63ca4a7)), closes [#5943](https://github.com/IBM/kui/issues/5943)
- **plugins/plugin-client-common:** improve action button UI for output-only blocks ([9cb99ad](https://github.com/IBM/kui/commit/9cb99ad)), closes [#5660](https://github.com/IBM/kui/issues/5660)
- **plugins/plugin-client-common:** Improve Commentary editing UI by adding real Done button ([1f544b5](https://github.com/IBM/kui/commit/1f544b5)), closes [#5667](https://github.com/IBM/kui/issues/5667)
- **plugins/plugin-client-common:** Output-only blocks should offer a Copy action button ([da4f85d](https://github.com/IBM/kui/commit/da4f85d)), closes [#5646](https://github.com/IBM/kui/issues/5646)
- **plugins/plugin-client-common:** SourceRef should be default-expanded in Notebooks? ([8ee26e8](https://github.com/IBM/kui/commit/8ee26e8)), closes [#5866](https://github.com/IBM/kui/issues/5866)
- **plugins/plugin-client-common:** split command should allow user to specify splice index ([75857e9](https://github.com/IBM/kui/commit/75857e9)), closes [#5746](https://github.com/IBM/kui/issues/5746)
- **plugins/plugin-client-common:** User should be able to tab navigate through blocks ([54d3759](https://github.com/IBM/kui/commit/54d3759)), closes [#5717](https://github.com/IBM/kui/issues/5717)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- add CommentaryReponse to snapshot/replay the response of commentary command ([7d13a93](https://github.com/IBM/kui/commit/7d13a93)), closes [#5439](https://github.com/IBM/kui/issues/5439)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- improve repl-block selection ([305b36f](https://github.com/IBM/kui/commit/305b36f)), closes [#5587](https://github.com/IBM/kui/issues/5587)
- **plugins/plugin-client-common:** allow users to insert command before a repl block ([e935092](https://github.com/IBM/kui/commit/e935092)), closes [#5576](https://github.com/IBM/kui/issues/5576)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- **plugins/plugin-client-common:** allow clients to specify initial tab title ([e8e365f](https://github.com/IBM/kui/commit/e8e365f)), closes [#5539](https://github.com/IBM/kui/issues/5539)
- add sequence diagram to table with timestamp columns ([e9028ee](https://github.com/IBM/kui/commit/e9028ee)), closes [#5336](https://github.com/IBM/kui/issues/5336)
- allow command registrations to express their experimental nature ([eb9f147](https://github.com/IBM/kui/commit/eb9f147)), closes [#5282](https://github.com/IBM/kui/issues/5282)
- allow table model to specify a gridable column index ([f4ba8e6](https://github.com/IBM/kui/commit/f4ba8e6)), closes [#5278](https://github.com/IBM/kui/issues/5278)
- auto gridify large table ([bd22fa2](https://github.com/IBM/kui/commit/bd22fa2)), closes [#5305](https://github.com/IBM/kui/issues/5305)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- command history should be tab-specific ([1b987e0](https://github.com/IBM/kui/commit/1b987e0)), closes [#1299](https://github.com/IBM/kui/issues/1299)
- commentary command to add comments to REPL ([c304fd3](https://github.com/IBM/kui/commit/c304fd3)), closes [#5428](https://github.com/IBM/kui/issues/5428)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- inverse splits ([38d2895](https://github.com/IBM/kui/commit/38d2895)), closes [#5537](https://github.com/IBM/kui/issues/5537)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- snapshot freshening ([d5c8991](https://github.com/IBM/kui/commit/d5c8991)), closes [#5522](https://github.com/IBM/kui/issues/5522)
- support replaying in new tab ([04a2c67](https://github.com/IBM/kui/commit/04a2c67)), closes [#5509](https://github.com/IBM/kui/issues/5509)
- update ls to allow for presenting content from more limited VFS's such as tutorials ([a1ff1a4](https://github.com/IBM/kui/commit/a1ff1a4)), closes [#5497](https://github.com/IBM/kui/issues/5497)
- **plugins/plugin-client-common:** allow easier rerunning of command from terminal ([c5384e0](https://github.com/IBM/kui/commit/c5384e0)), closes [#4570](https://github.com/IBM/kui/issues/4570)
- **plugins/plugin-client-common:** History navigation in minisplits should navigate In/Out pairs ([93eb2a4](https://github.com/IBM/kui/commit/93eb2a4)), closes [#5270](https://github.com/IBM/kui/issues/5270)
- **plugins/plugin-client-common:** Improve notebook-style ui ([791160e](https://github.com/IBM/kui/commit/791160e)), closes [#5472](https://github.com/IBM/kui/issues/5472)
- **plugins/plugin-client-common:** improve presentation of sidecar-destined responses ([02b91e3](https://github.com/IBM/kui/commit/02b91e3)), closes [#5463](https://github.com/IBM/kui/issues/5463)
- **plugins/plugin-client-common:** show table row count in card header ([deadcfa](https://github.com/IBM/kui/commit/deadcfa)), closes [#5137](https://github.com/IBM/kui/issues/5137)
- **plugins/plugin-client-common:** use inner scrolling for RadioTables in main Terminals ([952f72a](https://github.com/IBM/kui/commit/952f72a)), closes [#5133](https://github.com/IBM/kui/issues/5133)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- <Kui> should allow for custom Input elements ([193a108](https://github.com/IBM/kui/commit/193a108)), closes [#4672](https://github.com/IBM/kui/issues/4672)
- add a command to return the Card Component in Terminal ([d8d13ab](https://github.com/IBM/kui/commit/d8d13ab)), closes [#4973](https://github.com/IBM/kui/issues/4973)
- add alert command to display Alert component in Terminal ([495d3bb](https://github.com/IBM/kui/commit/495d3bb)), closes [#4957](https://github.com/IBM/kui/issues/4957)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for <Kui noPromptContext/> and <Kui prompt=">"/> ([a92063d](https://github.com/IBM/kui/commit/a92063d)), closes [#4653](https://github.com/IBM/kui/issues/4653)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow <Kui/> users to provide custom views for session init ([1f35894](https://github.com/IBM/kui/commit/1f35894)), closes [#4596](https://github.com/IBM/kui/issues/4596)
- allow clients to modify the session lifecycle UI by providing custom strings ([3c78fd3](https://github.com/IBM/kui/commit/3c78fd3)), closes [#5019](https://github.com/IBM/kui/issues/5019)
- allow subclasses of InputProvider to specify their own State ([c3fc88e](https://github.com/IBM/kui/commit/c3fc88e)), closes [#4756](https://github.com/IBM/kui/issues/4756)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- Dropdown spi and use in Terminal Block ([327917b](https://github.com/IBM/kui/commit/327917b)), closes [#4589](https://github.com/IBM/kui/issues/4589) [#4556](https://github.com/IBM/kui/issues/4556)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- initial/minimal snapshot/replay support ([bb7ae0f](https://github.com/IBM/kui/commit/bb7ae0f)), closes [#5280](https://github.com/IBM/kui/issues/5280)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- pass command line comments to commentary command ([a020db5](https://github.com/IBM/kui/commit/a020db5)), closes [#5459](https://github.com/IBM/kui/issues/5459)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- RadioTable and port of the themes table to use it ([79a3e8e](https://github.com/IBM/kui/commit/79a3e8e)), closes [#4507](https://github.com/IBM/kui/issues/4507)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- Timeline view for kubernetes Jobs ([b623e4e](https://github.com/IBM/kui/commit/b623e4e)), closes [#5370](https://github.com/IBM/kui/issues/5370)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- separate out themes into a new settings Notebook ([5180759](https://github.com/IBM/kui/commit/5180759)), closes [#5605](https://github.com/IBM/kui/issues/5605)
- shift Block UI to use a Notebook style of presentation ([dc0ee4b](https://github.com/IBM/kui/commit/dc0ee4b)), closes [#5258](https://github.com/IBM/kui/issues/5258)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- **plugins/plugin-client-common:** improve accessibility of "red" error grid cells ([8921292](https://github.com/IBM/kui/commit/8921292)), closes [#4938](https://github.com/IBM/kui/issues/4938)
- **plugins/plugin-client-common:** support client option for hero names in sidecar ([d4f6984](https://github.com/IBM/kui/commit/d4f6984)), closes [#4909](https://github.com/IBM/kui/issues/4909)
- **plugins/plugin-client-common:** use Cards to wrap kube tables and grids ([6698013](https://github.com/IBM/kui/commit/6698013)), closes [#5032](https://github.com/IBM/kui/issues/5032)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- update checker ([a7908d2](https://github.com/IBM/kui/commit/a7908d2)), closes [#4537](https://github.com/IBM/kui/issues/4537)
- Update default loadingDone to use Card component ([e1b4c61](https://github.com/IBM/kui/commit/e1b4c61)), closes [#4986](https://github.com/IBM/kui/issues/4986)
- **plugins/plugin-client-common:** add support for Tags in StatusStripe ([d112c86](https://github.com/IBM/kui/commit/d112c86)), closes [#4951](https://github.com/IBM/kui/issues/4951)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [9.2.0](https://github.com/IBM/kui/compare/v4.5.0...v9.2.0) (2020-11-25)

### Bug Fixes

- improve discovery of ibmcloud s3 credentials ([96d5bc0](https://github.com/IBM/kui/commit/96d5bc0)), closes [#5926](https://github.com/IBM/kui/issues/5926)
- monaco diff view colors are not themed ([eed2527](https://github.com/IBM/kui/commit/eed2527)), closes [#6232](https://github.com/IBM/kui/issues/6232)
- **plugin-client-common:** RadioTable onSelect changes do not always result in status stripe updates ([3549b7a](https://github.com/IBM/kui/commit/3549b7a)), closes [#5644](https://github.com/IBM/kui/issues/5644)
- **plugins-client-common:** bump carbon-components-react to 7.22 ([8b98791](https://github.com/IBM/kui/commit/8b98791)), closes [#6011](https://github.com/IBM/kui/issues/6011)
- **plugins-client-common:** the experimental tag should use sans serif ([143464a](https://github.com/IBM/kui/commit/143464a)), closes [#5363](https://github.com/IBM/kui/issues/5363)
- **plugins/plugin-client-common:** Whem moving blocks, the moved block is not longer focused after the move ([fc13198](https://github.com/IBM/kui/commit/fc13198)), closes [#5612](https://github.com/IBM/kui/issues/5612)
- **plugins/plugin-client-common:** "No events in the past hour" in sidecar has different bg color than other tabs ([ffba806](https://github.com/IBM/kui/commit/ffba806)), closes [#6075](https://github.com/IBM/kui/issues/6075)
- **plugins/plugin-client-common:** "No resources" in watch pane can occlude watch pane title ([e4fd93a](https://github.com/IBM/kui/commit/e4fd93a)), closes [#5064](https://github.com/IBM/kui/issues/5064)
- **plugins/plugin-client-common:** a few more patternfly navigation styling issues ([5511c1f](https://github.com/IBM/kui/commit/5511c1f)), closes [#6049](https://github.com/IBM/kui/issues/6049)
- **plugins/plugin-client-common:** a few small refinements to "editing" UI for Inputs ([001236a](https://github.com/IBM/kui/commit/001236a)), closes [#5656](https://github.com/IBM/kui/issues/5656) [#5658](https://github.com/IBM/kui/issues/5658)
- **plugins/plugin-client-common:** active pty output doesn't have repl-context ([6b0929e](https://github.com/IBM/kui/commit/6b0929e)), closes [#5960](https://github.com/IBM/kui/issues/5960)
- **plugins/plugin-client-common:** add support for titles in commentary ([fbe367c](https://github.com/IBM/kui/commit/fbe367c)), closes [#5434](https://github.com/IBM/kui/issues/5434)
- **plugins/plugin-client-common:** always place table events in the Card footer ([b667b28](https://github.com/IBM/kui/commit/b667b28)), closes [#5210](https://github.com/IBM/kui/issues/5210)
- **plugins/plugin-client-common:** avoid inner scrolling in Commentary cards ([d3ea558](https://github.com/IBM/kui/commit/d3ea558)), closes [#5517](https://github.com/IBM/kui/issues/5517)
- **plugins/plugin-client-common:** Block Action buttons have poor contrast in dark themes ([f52511e](https://github.com/IBM/kui/commit/f52511e)), closes [#5590](https://github.com/IBM/kui/issues/5590)
- **plugins/plugin-client-common:** Block Actions should be top-aligned in output-only blocks ([55ce899](https://github.com/IBM/kui/commit/55ce899)), closes [#5595](https://github.com/IBM/kui/issues/5595)
- **plugins/plugin-client-common:** block left-border is not centered with In[1] text in minisplits ([4df61cc](https://github.com/IBM/kui/commit/4df61cc)), closes [#5585](https://github.com/IBM/kui/issues/5585)
- **plugins/plugin-client-common:** buggy header UI in dark themes in minisplits ([55aef48](https://github.com/IBM/kui/commit/55aef48)), closes [#5266](https://github.com/IBM/kui/issues/5266)
- **plugins/plugin-client-common:** clicking on pod delete button can cause command to be executed in minisplit ([37f9019](https://github.com/IBM/kui/commit/37f9019)), closes [#5247](https://github.com/IBM/kui/issues/5247)
- **plugins/plugin-client-common:** clicking the editor in carbon accordion will change the accordion label ([ce3fe02](https://github.com/IBM/kui/commit/ce3fe02)), closes [#6107](https://github.com/IBM/kui/issues/6107)
- **plugins/plugin-client-common:** clicking to focus on a split does not always cause full focus effect ([bc59bcf](https://github.com/IBM/kui/commit/bc59bcf)), closes [#5263](https://github.com/IBM/kui/issues/5263)
- **plugins/plugin-client-common:** close tabs doesn't produce the correct tab content ([6090887](https://github.com/IBM/kui/commit/6090887)), closes [#5220](https://github.com/IBM/kui/issues/5220)
- **plugins/plugin-client-common:** Commentary blocks are not focusable in minisplits ([1286b0d](https://github.com/IBM/kui/commit/1286b0d)), closes [#5594](https://github.com/IBM/kui/issues/5594)
- **plugins/plugin-client-common:** Commentary editor can easily overflow when editing in minisplit ([eb14074](https://github.com/IBM/kui/commit/eb14074)), closes [#5675](https://github.com/IBM/kui/issues/5675)
- **plugins/plugin-client-common:** commentary editor can overflow with long lines ([3475287](https://github.com/IBM/kui/commit/3475287)), closes [#5981](https://github.com/IBM/kui/issues/5981)
- **plugins/plugin-client-common:** Commentary editor should be full width always ([e0a164a](https://github.com/IBM/kui/commit/e0a164a)), closes [#5688](https://github.com/IBM/kui/issues/5688)
- **plugins/plugin-client-common:** Commentary paragraphs have no separation ([6b77a13](https://github.com/IBM/kui/commit/6b77a13)), closes [#5531](https://github.com/IBM/kui/issues/5531)
- **plugins/plugin-client-common:** CSS no longer is reactive to narrow window ([4eb0a11](https://github.com/IBM/kui/commit/4eb0a11)), closes [#5290](https://github.com/IBM/kui/issues/5290)
- **plugins/plugin-client-common:** custom repl-prompt is misaligned with repl-output ([d12b203](https://github.com/IBM/kui/commit/d12b203)), closes [#6046](https://github.com/IBM/kui/issues/6046)
- **plugins/plugin-client-common:** custom tab titles may have monospace font ([b34b5a4](https://github.com/IBM/kui/commit/b34b5a4)), closes [#5527](https://github.com/IBM/kui/issues/5527)
- **plugins/plugin-client-common:** defer loading of both icon sets ([7d343b8](https://github.com/IBM/kui/commit/7d343b8)), closes [#5444](https://github.com/IBM/kui/issues/5444)
- **plugins/plugin-client-common:** don't line-wrap input elements in MiniSplits ([c929f5e](https://github.com/IBM/kui/commit/c929f5e)), closes [#5348](https://github.com/IBM/kui/issues/5348)
- **plugins/plugin-client-common:** don't show "2 rows" table header for short tables ([2350115](https://github.com/IBM/kui/commit/2350115)), closes [#5581](https://github.com/IBM/kui/issues/5581)
- **plugins/plugin-client-common:** Editing Commentary should require double click ([efaded3](https://github.com/IBM/kui/commit/efaded3)), closes [#5686](https://github.com/IBM/kui/issues/5686)
- **plugins/plugin-client-common:** editor doesn't grab focus for edit command ([9870267](https://github.com/IBM/kui/commit/9870267)), closes [#6090](https://github.com/IBM/kui/issues/6090)
- **plugins/plugin-client-common:** enhance minisplit by updating the background color of scrollback and dark card ([fd15c5e](https://github.com/IBM/kui/commit/fd15c5e)), closes [#5989](https://github.com/IBM/kui/issues/5989)
- **plugins/plugin-client-common:** experiment tag has wrong color contrast in dark themes ([22bfb77](https://github.com/IBM/kui/commit/22bfb77)), closes [#5389](https://github.com/IBM/kui/issues/5389)
- **plugins/plugin-client-common:** Experimental badge should take up less space in minisplits ([268aeb3](https://github.com/IBM/kui/commit/268aeb3)), closes [#5373](https://github.com/IBM/kui/issues/5373)
- **plugins/plugin-client-common:** font size issues with lightweight ui in tree view ([575ced0](https://github.com/IBM/kui/commit/575ced0)), closes [#6228](https://github.com/IBM/kui/issues/6228) [#6229](https://github.com/IBM/kui/issues/6229)
- @patternfly/react-core breaks the indentation of TreeView ([f5c5253](https://github.com/IBM/kui/commit/f5c5253)), closes [#6224](https://github.com/IBM/kui/issues/6224)
- block timestamp in Light theme/lightweight ui has low contrast ([6ae08fd](https://github.com/IBM/kui/commit/6ae08fd)), closes [#6226](https://github.com/IBM/kui/issues/6226)
- **plugins/plugin-client-common:** adjust TopTabStripe for lightweight ui themes ([00ee896](https://github.com/IBM/kui/commit/00ee896)), closes [#6204](https://github.com/IBM/kui/issues/6204)
- **plugins/plugin-client-common:** after Electron 10 update, ls output can render poorly ([1b7010b](https://github.com/IBM/kui/commit/1b7010b)), closes [#6147](https://github.com/IBM/kui/issues/6147)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([3400431](https://github.com/IBM/kui/commit/3400431)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** externalize PatternFly TreeView component to SPI ([486a02e](https://github.com/IBM/kui/commit/486a02e)), closes [#6134](https://github.com/IBM/kui/issues/6134)
- **plugins/plugin-client-common:** for lightweight ui themes, also show block duration in highlight color ([da3a3a7](https://github.com/IBM/kui/commit/da3a3a7)), closes [#6222](https://github.com/IBM/kui/issues/6222)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** group the notebooks together in the ls -l table ([1a783f3](https://github.com/IBM/kui/commit/1a783f3)), closes [#5977](https://github.com/IBM/kui/issues/5977)
- **plugins/plugin-client-common:** h2 in Notebooks have double underline ([40a4bd1](https://github.com/IBM/kui/commit/40a4bd1)), closes [#5574](https://github.com/IBM/kui/issues/5574)
- **plugins/plugin-client-common:** height of TreeView events should match that of sidecar header ([bba1ccd](https://github.com/IBM/kui/commit/bba1ccd)), closes [#6174](https://github.com/IBM/kui/issues/6174)
- **plugins/plugin-client-common:** hovering over error block turns red to blue ([3dbddae](https://github.com/IBM/kui/commit/3dbddae)), closes [#5979](https://github.com/IBM/kui/issues/5979)
- **plugins/plugin-client-common:** If a command is issued in a mini split, the next block (in the mini split) is not focused ([a35e5c2](https://github.com/IBM/kui/commit/a35e5c2)), closes [#6067](https://github.com/IBM/kui/issues/6067)
- **plugins/plugin-client-common:** improve behavior of up arrow for first command in MiniSplits ([ed199d4](https://github.com/IBM/kui/commit/ed199d4)), closes [#5297](https://github.com/IBM/kui/issues/5297)
- **plugins/plugin-client-common:** improve layout of In[1] with sidecar open ([263d59a](https://github.com/IBM/kui/commit/263d59a)), closes [#5482](https://github.com/IBM/kui/issues/5482)
- **plugins/plugin-client-common:** improve rendering of output only blocks ([664a8da](https://github.com/IBM/kui/commit/664a8da)), closes [#5467](https://github.com/IBM/kui/issues/5467)
- **plugins/plugin-client-common:** improve row hover effect for SequenceDiagram ([89dbe2a](https://github.com/IBM/kui/commit/89dbe2a)), closes [#5426](https://github.com/IBM/kui/issues/5426)
- **plugins/plugin-client-common:** improved focus behavior of terminals ([f5a3dd0](https://github.com/IBM/kui/commit/f5a3dd0)), closes [#5615](https://github.com/IBM/kui/issues/5615)
- **plugins/plugin-client-common:** in dark themes, the inter-split gutter is not visible ([288eeae](https://github.com/IBM/kui/commit/288eeae)), closes [#6022](https://github.com/IBM/kui/issues/6022)
- **plugins/plugin-client-common:** in plain Terminals, tables should not inner scroll ([15fcbba](https://github.com/IBM/kui/commit/15fcbba)), closes [#5221](https://github.com/IBM/kui/issues/5221)
- **plugins/plugin-client-common:** In some themes, grid inner text color can have low contrast. ([01f8698](https://github.com/IBM/kui/commit/01f8698)), closes [#6032](https://github.com/IBM/kui/issues/6032)
- **plugins/plugin-client-common:** inconsistent top padding above Cards ([1e1037f](https://github.com/IBM/kui/commit/1e1037f)), closes [#5299](https://github.com/IBM/kui/issues/5299)
- **plugins/plugin-client-common:** increase density of SequenceDiagram ([ae29488](https://github.com/IBM/kui/commit/ae29488)), closes [#5344](https://github.com/IBM/kui/issues/5344)
- **plugins/plugin-client-common:** input spinner is not visible in minisplits ([76eec59](https://github.com/IBM/kui/commit/76eec59)), closes [#5684](https://github.com/IBM/kui/issues/5684)
- **plugins/plugin-client-common:** lightweight ui has a few remaining "heavy" elements ([afef54a](https://github.com/IBM/kui/commit/afef54a)), closes [#6195](https://github.com/IBM/kui/issues/6195)
- **plugins/plugin-client-common:** long input lines should line wrap ([8804bb1](https://github.com/IBM/kui/commit/8804bb1)), closes [#5338](https://github.com/IBM/kui/issues/5338)
- **plugins/plugin-client-common:** Lots of little layout issues, e.g. SimpleEditor is not fully width in minisplits ([5a9a1c6](https://github.com/IBM/kui/commit/5a9a1c6)), closes [#5679](https://github.com/IBM/kui/issues/5679) [#5680](https://github.com/IBM/kui/issues/5680)
- **plugins/plugin-client-common:** minor improvements for ls -l output ([1b59c94](https://github.com/IBM/kui/commit/1b59c94)), closes [#5216](https://github.com/IBM/kui/issues/5216)
- **plugins/plugin-client-common:** minor spacing improvements for Commentary and Notebooks ([c473181](https://github.com/IBM/kui/commit/c473181)), closes [#5503](https://github.com/IBM/kui/issues/5503)
- **plugins/plugin-client-common:** multi-line paste executes commands out of order ([8f39c80](https://github.com/IBM/kui/commit/8f39c80)), closes [#5295](https://github.com/IBM/kui/issues/5295)
- **plugins/plugin-client-common:** on switching tabs, active prompt isn't always focused ([5b28dd2](https://github.com/IBM/kui/commit/5b28dd2)), closes [#5637](https://github.com/IBM/kui/issues/5637)
- **plugins/plugin-client-common:** only highlight the Active block in the focused split ([feffad4](https://github.com/IBM/kui/commit/feffad4)), closes [#5261](https://github.com/IBM/kui/issues/5261)
- **plugins/plugin-client-common:** Output-only blocks probably don't need a re-execute button ([251a81c](https://github.com/IBM/kui/commit/251a81c)), closes [#5662](https://github.com/IBM/kui/issues/5662)
- **plugins/plugin-client-common:** pack table rows more densely in lightweight UI themes ([bcb3f23](https://github.com/IBM/kui/commit/bcb3f23)), closes [#6217](https://github.com/IBM/kui/issues/6217)
- refine tree label categoriazation of kubectl ([1973a43](https://github.com/IBM/kui/commit/1973a43)), closes [#6185](https://github.com/IBM/kui/issues/6185)
- **plugins/plugin-client-common:** core themes should use fixed tab names ([f93fe2b](https://github.com/IBM/kui/commit/f93fe2b)), closes [#6208](https://github.com/IBM/kui/issues/6208)
- **plugins/plugin-client-common:** events in tree should stay scrolled to the bottom as events come in ([c5efedd](https://github.com/IBM/kui/commit/c5efedd)), closes [#6164](https://github.com/IBM/kui/issues/6164)
- **plugins/plugin-client-common:** in carbon-based dark themes, the SourceRef expando text is not visible ([0b462f5](https://github.com/IBM/kui/commit/0b462f5)), closes [#6197](https://github.com/IBM/kui/issues/6197)
- **plugins/plugin-client-common:** in lightweight presentation mode, lighten up sidecar a bit ([c73c080](https://github.com/IBM/kui/commit/c73c080)), closes [#6202](https://github.com/IBM/kui/issues/6202) [#6201](https://github.com/IBM/kui/issues/6201)
- **plugins/plugin-client-common:** in some cases, Editor may present "you are in edit mode" for readOnly instantiations ([e3e7c16](https://github.com/IBM/kui/commit/e3e7c16)), closes [#6116](https://github.com/IBM/kui/issues/6116)
- **plugins/plugin-client-common:** lightweight ui: minisplits should not have the opacity filter ([96860f3](https://github.com/IBM/kui/commit/96860f3)), closes [#6198](https://github.com/IBM/kui/issues/6198)
- **plugins/plugin-client-common:** PatternFly assumes a 16px body font size, whereas the rest of Kui assumes 14px ([fa65b57](https://github.com/IBM/kui/commit/fa65b57)), closes [#6041](https://github.com/IBM/kui/issues/6041)
- **plugins/plugin-client-common:** PatternFly LeftNav view has excessive padding ([959d059](https://github.com/IBM/kui/commit/959d059)), closes [#6038](https://github.com/IBM/kui/issues/6038)
- **plugins/plugin-client-common:** present more than 2 footer lines in watch tables ([3e7a78f](https://github.com/IBM/kui/commit/3e7a78f)), closes [#5213](https://github.com/IBM/kui/issues/5213)
- **plugins/plugin-client-common:** pty commands fail in minisplits ([475ea74](https://github.com/IBM/kui/commit/475ea74)), closes [#5267](https://github.com/IBM/kui/issues/5267)
- **plugins/plugin-client-common:** RadioTable has small font size ([19f758a](https://github.com/IBM/kui/commit/19f758a)), closes [#6102](https://github.com/IBM/kui/issues/6102)
- **plugins/plugin-client-common:** reduce contrast of block left bars ([7c8d371](https://github.com/IBM/kui/commit/7c8d371)), closes [#5275](https://github.com/IBM/kui/issues/5275)
- **plugins/plugin-client-common:** refine Timeline a bit more ([4b12eec](https://github.com/IBM/kui/commit/4b12eec)), closes [#5409](https://github.com/IBM/kui/issues/5409)
- **plugins/plugin-client-common:** regression in columnar alignment of Input and Output ([cf1a836](https://github.com/IBM/kui/commit/cf1a836)), closes [#5507](https://github.com/IBM/kui/issues/5507)
- **plugins/plugin-client-common:** removing previous blocks will cause errant rendering to edit command result ([6594e8c](https://github.com/IBM/kui/commit/6594e8c)), closes [#6093](https://github.com/IBM/kui/issues/6093)
- **plugins/plugin-client-common:** rendering of blockquotes in markdown is inconsistent ([edcc8d1](https://github.com/IBM/kui/commit/edcc8d1)), closes [#6043](https://github.com/IBM/kui/issues/6043)
- **plugins/plugin-client-common:** restore history navigation behavior in minisplits ([26f49e8](https://github.com/IBM/kui/commit/26f49e8)), closes [#5375](https://github.com/IBM/kui/issues/5375)
- **plugins/plugin-client-common:** reverse-i-search incorrectly changes match as i type ([135d429](https://github.com/IBM/kui/commit/135d429)), closes [#5403](https://github.com/IBM/kui/issues/5403)
- **plugins/plugin-client-common:** sequence diagram does not display well with lightweight ui ([e746cc6](https://github.com/IBM/kui/commit/e746cc6)), closes [#6189](https://github.com/IBM/kui/issues/6189)
- **plugins/plugin-client-common:** SequenceDiagram bars are too narrow ([a0ed13a](https://github.com/IBM/kui/commit/a0ed13a)), closes [#5544](https://github.com/IBM/kui/issues/5544)
- **plugins/plugin-client-common:** SequenceDiagram bars may extend beyond the 100% line ([34d03bc](https://github.com/IBM/kui/commit/34d03bc)), closes [#5465](https://github.com/IBM/kui/issues/5465)
- **plugins/plugin-client-common:** SequenceDiagram can overflow 100% width ([d631fd9](https://github.com/IBM/kui/commit/d631fd9)), closes [#6159](https://github.com/IBM/kui/issues/6159)
- **plugins/plugin-client-common:** sidecar editor too-aggressively focuses ([8077cec](https://github.com/IBM/kui/commit/8077cec)), closes [#6104](https://github.com/IBM/kui/issues/6104)
- **plugins/plugin-client-common:** small regression in top tab stripe height ([0b07d35](https://github.com/IBM/kui/commit/0b07d35)), closes [#6211](https://github.com/IBM/kui/issues/6211)
- A few more themes tweaks are needed ([03be3eb](https://github.com/IBM/kui/commit/03be3eb)), closes [#6034](https://github.com/IBM/kui/issues/6034)
- block focus regressions ([881fa17](https://github.com/IBM/kui/commit/881fa17)), closes [#6072](https://github.com/IBM/kui/issues/6072)
- default chart colors should not use blue-red diverging spectrum ([918ab9c](https://github.com/IBM/kui/commit/918ab9c)), closes [#6191](https://github.com/IBM/kui/issues/6191)
- **plugins/plugin-client-common:** SequenceDiagram may emit spurious console errors ([c0ba218](https://github.com/IBM/kui/commit/c0ba218)), closes [#6166](https://github.com/IBM/kui/issues/6166)
- **plugins/plugin-client-common:** SourceRef does not respond to all tab layout changes ([d3e8b32](https://github.com/IBM/kui/commit/d3e8b32)), closes [#5552](https://github.com/IBM/kui/issues/5552)
- **plugins/plugin-client-common:** status column can be invisible in split tables ([c352103](https://github.com/IBM/kui/commit/c352103)), closes [#5244](https://github.com/IBM/kui/issues/5244)
- **plugins/plugin-client-common:** StatusStripe is blank for second+ tabs ([0002dfb](https://github.com/IBM/kui/commit/0002dfb)), closes [#5546](https://github.com/IBM/kui/issues/5546)
- **plugins/plugin-client-common:** StatusStripe widgets can emit react error when switching to notebook tab ([485fcdf](https://github.com/IBM/kui/commit/485fcdf)), closes [#5639](https://github.com/IBM/kui/issues/5639)
- **plugins/plugin-client-common:** tab completion UI does not render on separate line from input ([61b169b](https://github.com/IBM/kui/commit/61b169b)), closes [#5307](https://github.com/IBM/kui/issues/5307)
- **plugins/plugin-client-common:** table bottom toolbar buttons lack padding ([79f0abe](https://github.com/IBM/kui/commit/79f0abe)), closes [#5554](https://github.com/IBM/kui/issues/5554)
- **plugins/plugin-client-common:** TableCell view can fail when given empty duration cells ([04251be](https://github.com/IBM/kui/commit/04251be)), closes [#5332](https://github.com/IBM/kui/issues/5332)
- **plugins/plugin-client-common:** Timeline may not render properly ([d66d728](https://github.com/IBM/kui/commit/d66d728)), closes [#5383](https://github.com/IBM/kui/issues/5383)
- **plugins/plugin-client-common:** Timeline view renders poorly in MiniSplit ([07cd000](https://github.com/IBM/kui/commit/07cd000)), closes [#5379](https://github.com/IBM/kui/issues/5379)
- **plugins/plugin-client-common:** Tree Component tweaks ([2f21e22](https://github.com/IBM/kui/commit/2f21e22)), closes [#6158](https://github.com/IBM/kui/issues/6158) [#6157](https://github.com/IBM/kui/issues/6157)
- **plugins/plugin-client-common:** TreeView badges have poor contrast in patternfly themes ([8e0db86](https://github.com/IBM/kui/commit/8e0db86)), closes [#6149](https://github.com/IBM/kui/issues/6149)
- **plugins/plugin-client-common:** typo "soild" in Tree.scss ([1a64ccd](https://github.com/IBM/kui/commit/1a64ccd)), closes [#6172](https://github.com/IBM/kui/issues/6172)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- events in tree are presented out of temporal order ([b3ba61e](https://github.com/IBM/kui/commit/b3ba61e)), closes [#6168](https://github.com/IBM/kui/issues/6168)
- **plugins/plugin-client-common:** sidecar markdown code snippet has poor color ([765f166](https://github.com/IBM/kui/commit/765f166)), closes [#5995](https://github.com/IBM/kui/issues/5995)
- **plugins/plugin-client-common:** update spinner to avoid console error messages ([caea507](https://github.com/IBM/kui/commit/caea507)), closes [#6146](https://github.com/IBM/kui/issues/6146)
- RadioTable should have option to not echo the onSelect command ([77d5050](https://github.com/IBM/kui/commit/77d5050)), closes [#5991](https://github.com/IBM/kui/issues/5991)
- UI glitches of Tree ([fc5af7a](https://github.com/IBM/kui/commit/fc5af7a)), closes [#6138](https://github.com/IBM/kui/issues/6138)
- **plugins/plugin-client-common:** restore hiding of In[1] in minisplit ([8d5c93f](https://github.com/IBM/kui/commit/8d5c93f)), closes [#5985](https://github.com/IBM/kui/issues/5985)
- **plugins/plugin-client-common:** TabCompletion UI can fail ([cc3fb6d](https://github.com/IBM/kui/commit/cc3fb6d)), closes [#6130](https://github.com/IBM/kui/issues/6130)
- Switching Carbon tabs can cause content to scroll off-viewport ([51a2aad](https://github.com/IBM/kui/commit/51a2aad)), closes [#6014](https://github.com/IBM/kui/issues/6014)
- **plugins/plugin-client-common:** the alert showing lost connection has incorrect height ([1758758](https://github.com/IBM/kui/commit/1758758)), closes [#5905](https://github.com/IBM/kui/issues/5905)
- **plugins/plugin-client-common:** update the commentary in settings notebook to store the texts as command ([bbb8f6d](https://github.com/IBM/kui/commit/bbb8f6d)), closes [#5992](https://github.com/IBM/kui/issues/5992)
- tweak the input background and border to enhance the readability of notebooks ([3928768](https://github.com/IBM/kui/commit/3928768)), closes [#5982](https://github.com/IBM/kui/issues/5982)
- **plugin-client-common:** show the last input block in minisplit ([7997ef0](https://github.com/IBM/kui/commit/7997ef0)), closes [#5756](https://github.com/IBM/kui/issues/5756)
- **plugins/plugin-client-common:** "Drilled down to..." text is not aligned with the Input area ([fd139d2](https://github.com/IBM/kui/commit/fd139d2)), closes [#5854](https://github.com/IBM/kui/issues/5854)
- **plugins/plugin-client-common:** Action button hover hysteresis/delay effect not working ([fac75dc](https://github.com/IBM/kui/commit/fac75dc)), closes [#5806](https://github.com/IBM/kui/issues/5806)
- **plugins/plugin-client-common:** blockquotes in commentary don't render well ([9be35fa](https://github.com/IBM/kui/commit/9be35fa)), closes [#5931](https://github.com/IBM/kui/issues/5931)
- **plugins/plugin-client-common:** clicking on table or radio table may cause block to disappear ([1f2d489](https://github.com/IBM/kui/commit/1f2d489)), closes [#5783](https://github.com/IBM/kui/issues/5783)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** ClipboardTransfer emits errors when pasting non-json text ([6ff85c4](https://github.com/IBM/kui/commit/6ff85c4)), closes [#5836](https://github.com/IBM/kui/issues/5836)
- **plugins/plugin-client-common:** colored squares in status column of tables have odd alignment ([3e78540](https://github.com/IBM/kui/commit/3e78540)), closes [#5766](https://github.com/IBM/kui/issues/5766)
- **plugins/plugin-client-common:** Commentary editor is 5px tall when presented in mini split ([53074d1](https://github.com/IBM/kui/commit/53074d1)), closes [#5744](https://github.com/IBM/kui/issues/5744)
- **plugins/plugin-client-common:** Commentary is always full width ([1920fb9](https://github.com/IBM/kui/commit/1920fb9)), closes [#5705](https://github.com/IBM/kui/issues/5705)
- **plugins/plugin-client-common:** Commentary markdown does not support kuiexec ([4663389](https://github.com/IBM/kui/commit/4663389)), closes [#5911](https://github.com/IBM/kui/issues/5911)
- **plugins/plugin-client-common:** creating a split with a 3-way split configuration results in radical shuffling ([9452b5a](https://github.com/IBM/kui/commit/9452b5a)), closes [#5794](https://github.com/IBM/kui/issues/5794)
- **plugins/plugin-client-common:** disable Timeline option for Tables ([e88ebb3](https://github.com/IBM/kui/commit/e88ebb3)), closes [#5864](https://github.com/IBM/kui/issues/5864)
- **plugins/plugin-client-common:** Do not focus Block when user expands SourceRef ([6642514](https://github.com/IBM/kui/commit/6642514)), closes [#5711](https://github.com/IBM/kui/issues/5711)
- **plugins/plugin-client-common:** do not show the command rerun and remove button for offline kui ([309162f](https://github.com/IBM/kui/commit/309162f)), closes [#5917](https://github.com/IBM/kui/issues/5917)
- **plugins/plugin-client-common:** don't decorate code elements in top tab ([531e8b8](https://github.com/IBM/kui/commit/531e8b8)), closes [#5778](https://github.com/IBM/kui/issues/5778)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** don't show `isTabLayoutModificationResponse` and PresentedElseWhere response in MiniSplit ([a16767a](https://github.com/IBM/kui/commit/a16767a)), closes [#5690](https://github.com/IBM/kui/issues/5690)
- **plugins/plugin-client-common:** double clicking on Commentary in minisplit often has the editor completely off screen ([c3504a0](https://github.com/IBM/kui/commit/c3504a0)), closes [#5897](https://github.com/IBM/kui/issues/5897)
- **plugins/plugin-client-common:** empty blocks have excessive height ([12c39b0](https://github.com/IBM/kui/commit/12c39b0)), closes [#5707](https://github.com/IBM/kui/issues/5707)
- **plugins/plugin-client-common:** empty pty response yields blank line ([711bd05](https://github.com/IBM/kui/commit/711bd05)), closes [#5928](https://github.com/IBM/kui/issues/5928)
- **plugins/plugin-client-common:** error blocks are not indented properly ([d137614](https://github.com/IBM/kui/commit/d137614)), closes [#5938](https://github.com/IBM/kui/issues/5938)
- add Kui version and github link to client-notebook ([7b2562a](https://github.com/IBM/kui/commit/7b2562a)), closes [#5918](https://github.com/IBM/kui/issues/5918)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- **plugins/plugin-client-common:** CodeSnippet component renders with zero contrast in dark themes ([10e40a9](https://github.com/IBM/kui/commit/10e40a9)), closes [#5886](https://github.com/IBM/kui/issues/5886)
- **plugins/plugin-client-common:** deleting and re-creating a split results double commands ([dde6eaa](https://github.com/IBM/kui/commit/dde6eaa)), closes [#5876](https://github.com/IBM/kui/issues/5876)
- **plugins/plugin-client-common:** editing commentary gives a one-line monaco ([5f14268](https://github.com/IBM/kui/commit/5f14268)), closes [#5874](https://github.com/IBM/kui/issues/5874)
- **plugins/plugin-client-common:** focus a block upon moving or pasting it ([43c3d9a](https://github.com/IBM/kui/commit/43c3d9a)), closes [#5751](https://github.com/IBM/kui/issues/5751)
- **plugins/plugin-client-common:** increase contrast of unfocused left-stripes for blocks ([ab21295](https://github.com/IBM/kui/commit/ab21295)), closes [#5754](https://github.com/IBM/kui/issues/5754)
- **plugins/plugin-client-common:** input probably needs to word-wrap while in minisplits ([cde272d](https://github.com/IBM/kui/commit/cde272d)), closes [#5696](https://github.com/IBM/kui/issues/5696)
- **plugins/plugin-client-common:** Input timestamp should also hide when block is focused ([6e1ca6d](https://github.com/IBM/kui/commit/6e1ca6d)), closes [#5809](https://github.com/IBM/kui/issues/5809)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** linux can show unneeded scrollbars in tables ([4d49a23](https://github.com/IBM/kui/commit/4d49a23)), closes [#5884](https://github.com/IBM/kui/issues/5884)
- **plugins/plugin-client-common:** markdown code has incorrect color in a split with inverse color ([c8c10af](https://github.com/IBM/kui/commit/c8c10af)), closes [#5902](https://github.com/IBM/kui/issues/5902)
- **plugins/plugin-client-common:** markdown inline code in table cells shows with scrollbars on linux and windows ([1ff88b9](https://github.com/IBM/kui/commit/1ff88b9)), closes [#5890](https://github.com/IBM/kui/issues/5890)
- **plugins/plugin-client-common:** markdown with <a> inside <h1> renders with odd font size ([b5e3007](https://github.com/IBM/kui/commit/b5e3007)), closes [#5724](https://github.com/IBM/kui/issues/5724)
- **plugins/plugin-client-common:** monaco highlight color used by SourceRef has low contrast ([385f35e](https://github.com/IBM/kui/commit/385f35e)), closes [#5713](https://github.com/IBM/kui/issues/5713)
- **plugins/plugin-client-common:** presented elsewhere text is not vertically centered in block ([766d355](https://github.com/IBM/kui/commit/766d355)), closes [#5760](https://github.com/IBM/kui/issues/5760)
- **plugins/plugin-client-common:** RadioTable should scroll the selected row into view on render ([6eb45db](https://github.com/IBM/kui/commit/6eb45db)), closes [#5781](https://github.com/IBM/kui/issues/5781)
- **plugins/plugin-client-common:** remove clicks from NotebookImpl ([45f0be5](https://github.com/IBM/kui/commit/45f0be5)), closes [#5856](https://github.com/IBM/kui/issues/5856)
- **plugins/plugin-client-common:** saving a snapshot can fail with "cannot read property uuid of undefined" ([85fe1f3](https://github.com/IBM/kui/commit/85fe1f3)), closes [#5913](https://github.com/IBM/kui/issues/5913)
- **plugins/plugin-client-common:** selecting text in prior Input causes selection to be lost and Input to enter edit mode ([4d977d2](https://github.com/IBM/kui/commit/4d977d2)), closes [#5792](https://github.com/IBM/kui/issues/5792)
- **plugins/plugin-client-common:** some small tweaks to Commentary headers would help ([b012f8d](https://github.com/IBM/kui/commit/b012f8d)), closes [#5893](https://github.com/IBM/kui/issues/5893)
- **plugins/plugin-client-common:** sorting widgets in table header are wrapping ([e3520dc](https://github.com/IBM/kui/commit/e3520dc)), closes [#5976](https://github.com/IBM/kui/issues/5976)
- **plugins/plugin-client-common:** tab switching can be slow on windows ([09f9b7d](https://github.com/IBM/kui/commit/09f9b7d)), closes [#5907](https://github.com/IBM/kui/issues/5907)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-client-common:** welcome.json could use some wordsmithing ([e373ab4](https://github.com/IBM/kui/commit/e373ab4)), closes [#5895](https://github.com/IBM/kui/issues/5895)
- **plugins/plugin-client-common:** when replaying notebooks, tab should be scrolled to top ([6567412](https://github.com/IBM/kui/commit/6567412)), closes [#5860](https://github.com/IBM/kui/issues/5860)
- **plugins/plugin-client-common): regression validateDOMNesting(...:** <pre> cannot appear as a descendant of <p> ([1a2cccf](https://github.com/IBM/kui/commit/1a2cccf)), closes [#5900](https://github.com/IBM/kui/issues/5900)
- blocks can still disappear if table row is clicked while the enclosing block is focused ([2173af1](https://github.com/IBM/kui/commit/2173af1)), closes [#5814](https://github.com/IBM/kui/issues/5814)
- don't show the `open` command for clicking files in `ls` table ([03ef269](https://github.com/IBM/kui/commit/03ef269)), closes [#5748](https://github.com/IBM/kui/issues/5748)
- for replayed notebooks, don’t show timestamp ([951abc5](https://github.com/IBM/kui/commit/951abc5)), closes [#5763](https://github.com/IBM/kui/issues/5763)
- improve error reporting from APIs ([edff6f1](https://github.com/IBM/kui/commit/edff6f1)), closes [#5950](https://github.com/IBM/kui/issues/5950)
- ls comand is not snapshotable ([f04ca78](https://github.com/IBM/kui/commit/f04ca78)), closes [#5241](https://github.com/IBM/kui/issues/5241)
- Notebook title "Kui Setting" should be "Kui Settings" ([b14b130](https://github.com/IBM/kui/commit/b14b130)), closes [#5870](https://github.com/IBM/kui/issues/5870)
- preferReExecute is lost when re-saving a notebook ([87c6c6f](https://github.com/IBM/kui/commit/87c6c6f)), closes [#5954](https://github.com/IBM/kui/issues/5954)
- re-saving a notebook via File/Save application menu does not preserve notebook title ([7fb8b43](https://github.com/IBM/kui/commit/7fb8b43)), closes [#5777](https://github.com/IBM/kui/issues/5777)
- remove up/down actions buttons ([3c8a8a1](https://github.com/IBM/kui/commit/3c8a8a1)), closes [#5774](https://github.com/IBM/kui/issues/5774)
- **plugins/plugin-client-common:** improve look of `code` snippets in Commentary ([493e004](https://github.com/IBM/kui/commit/493e004)), closes [#5768](https://github.com/IBM/kui/issues/5768)
- **plugins/plugin-client-common:** never show "ok" ([d1b337a](https://github.com/IBM/kui/commit/d1b337a)), closes [#5697](https://github.com/IBM/kui/issues/5697)
- **plugins/plugin-client-common:** re-snapshoting a notebook can fail ([4caff9c](https://github.com/IBM/kui/commit/4caff9c)), closes [#5736](https://github.com/IBM/kui/issues/5736)
- **plugins/plugin-client-common:** remove leftover debugging in Scalar/index ([82b8e50](https://github.com/IBM/kui/commit/82b8e50)), closes [#5945](https://github.com/IBM/kui/issues/5945)
- **plugins/plugin-client-common:** SourceRef viewer should hide liner numbers but show folding ([5f74a46](https://github.com/IBM/kui/commit/5f74a46)), closes [#5719](https://github.com/IBM/kui/issues/5719)
- **plugins/plugin-client-common:** status stripe "blue" color probably needs to be toned done ([137442f](https://github.com/IBM/kui/commit/137442f)), closes [#5772](https://github.com/IBM/kui/issues/5772)
- **plugins/plugin-client-common:** table cells with no onclick handler still issue a kui command ([4d8bf37](https://github.com/IBM/kui/commit/4d8bf37)), closes [#5721](https://github.com/IBM/kui/issues/5721)
- **plugins/plugin-client-common:** table is misaligned with command input ([50dc430](https://github.com/IBM/kui/commit/50dc430)), closes [#5734](https://github.com/IBM/kui/issues/5734)
- **plugins/plugin-client-common:** there is still too much whitespace after no-response commands ([268f159](https://github.com/IBM/kui/commit/268f159)), closes [#5742](https://github.com/IBM/kui/issues/5742)
- **plugins/plugin-client-common:** while editing Commentary, adding ``` causes a bad error ([097b1b0](https://github.com/IBM/kui/commit/097b1b0)), closes [#5682](https://github.com/IBM/kui/issues/5682)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- **plugins/plugins-client-common:** Carbon Accordion spi should have more contrast ([c0de84d](https://github.com/IBM/kui/commit/c0de84d)), closes [#6111](https://github.com/IBM/kui/issues/6111)
- "created split" message should disappear when corresponding split is closed ([f8486f8](https://github.com/IBM/kui/commit/f8486f8)), closes [#5629](https://github.com/IBM/kui/issues/5629)
- Editor component does not respond to tab layout changes ([9756336](https://github.com/IBM/kui/commit/9756336)), closes [#5231](https://github.com/IBM/kui/issues/5231) [#5232](https://github.com/IBM/kui/issues/5232)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- improved support for replaying splits ([8039a9d](https://github.com/IBM/kui/commit/8039a9d)), closes [#5535](https://github.com/IBM/kui/issues/5535)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- multiple command history regressions ([cbba96c](https://github.com/IBM/kui/commit/cbba96c)), closes [#5283](https://github.com/IBM/kui/issues/5283)
- new tab command can hang if title is provided ([a6c25c6](https://github.com/IBM/kui/commit/a6c25c6)), closes [#5624](https://github.com/IBM/kui/issues/5624)
- notebook replay should scroll to top, and not display welcome message on every tab ([7ade801](https://github.com/IBM/kui/commit/7ade801)), closes [#5515](https://github.com/IBM/kui/issues/5515) [#5516](https://github.com/IBM/kui/issues/5516)
- output only Actions should also render on hover ([cdbd105](https://github.com/IBM/kui/commit/cdbd105)), closes [#5652](https://github.com/IBM/kui/issues/5652)
- pty output has different indentation than kui command output ([30b10a3](https://github.com/IBM/kui/commit/30b10a3)), closes [#5542](https://github.com/IBM/kui/issues/5542)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- replay --freshen does not support multi-split notebooks ([afd070c](https://github.com/IBM/kui/commit/afd070c)), closes [#5571](https://github.com/IBM/kui/issues/5571) [#5572](https://github.com/IBM/kui/issues/5572)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- switching splits does not participate in tab state ([6eb8db4](https://github.com/IBM/kui/commit/6eb8db4)), closes [#5272](https://github.com/IBM/kui/issues/5272)
- tab new command should respond with ElsewhereCommentary response ([19a7e1d](https://github.com/IBM/kui/commit/19a7e1d)), closes [#5602](https://github.com/IBM/kui/issues/5602)
- terminal clearing versus splits results in non-replayable splits ([8f9dc23](https://github.com/IBM/kui/commit/8f9dc23)), closes [#5626](https://github.com/IBM/kui/issues/5626)
- **plugins/plugin-client-common:** `ok` string appears at the end of MixResponse ([75606c5](https://github.com/IBM/kui/commit/75606c5)), closes [#5046](https://github.com/IBM/kui/issues/5046)
- **plugins/plugin-client-common:** a few more rem/em font-size issues ([133b347](https://github.com/IBM/kui/commit/133b347)), closes [#5058](https://github.com/IBM/kui/issues/5058)
- **plugins/plugin-client-common:** borders in top tab stripe are too light ([3908695](https://github.com/IBM/kui/commit/3908695)), closes [#5051](https://github.com/IBM/kui/issues/5051)
- **plugins/plugin-client-common:** clearing Terminal does not abort watchers ([34adb50](https://github.com/IBM/kui/commit/34adb50)), closes [#5116](https://github.com/IBM/kui/issues/5116)
- **plugins/plugin-client-common:** clicking 'remove' of a watchable response doesn't abort the underlying pty job ([7eb69fb](https://github.com/IBM/kui/commit/7eb69fb)), closes [#5090](https://github.com/IBM/kui/issues/5090)
- **plugins/plugin-client-common:** decrease height of table footer ([5863622](https://github.com/IBM/kui/commit/5863622)), closes [#5072](https://github.com/IBM/kui/issues/5072)
- **plugins/plugin-client-common:** disableTableTitle also disables title of watch panes ([053cfb6](https://github.com/IBM/kui/commit/053cfb6)), closes [#5036](https://github.com/IBM/kui/issues/5036)
- **plugins/plugin-client-common:** don't use fixed maxHeight for Terminal tables ([0e23e22](https://github.com/IBM/kui/commit/0e23e22)), closes [#5206](https://github.com/IBM/kui/issues/5206)
- **plugins/plugin-client-common:** double watch panes may open up ([7fb70f1](https://github.com/IBM/kui/commit/7fb70f1)), closes [#5034](https://github.com/IBM/kui/issues/5034)
- **plugins/plugin-client-common:** editor component does not respond to font zooming ([7b7e0f3](https://github.com/IBM/kui/commit/7b7e0f3)), closes [#5120](https://github.com/IBM/kui/issues/5120)
- **plugins/plugin-client-common:** eliminate react "titleInHeader" console warnings ([8cf3797](https://github.com/IBM/kui/commit/8cf3797)), closes [#5078](https://github.com/IBM/kui/issues/5078)
- **plugins/plugin-client-common:** Events drilldown from watch table does not always work ([09aee73](https://github.com/IBM/kui/commit/09aee73)), closes [#5204](https://github.com/IBM/kui/issues/5204)
- **plugins/plugin-client-common:** Events footer in minisplit tables lacks horizontal padding ([f22b1f7](https://github.com/IBM/kui/commit/f22b1f7)), closes [#5196](https://github.com/IBM/kui/issues/5196)
- **plugins/plugin-client-common:** Events should also be placed in table footer (not tbody) when sidecar is open or 2-way terminal split ([1391b1d](https://github.com/IBM/kui/commit/1391b1d)), closes [#5198](https://github.com/IBM/kui/issues/5198)
- **plugins/plugin-client-common:** font size issues with LeftNavSidecar ([e17fc15](https://github.com/IBM/kui/commit/e17fc15)), closes [#5048](https://github.com/IBM/kui/issues/5048)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** improve display of tables in side-by-side terminal splits ([5a32255](https://github.com/IBM/kui/commit/5a32255)), closes [#5201](https://github.com/IBM/kui/issues/5201)
- **plugins/plugin-client-common:** improve spacing of Event footer content ([d63a6f1](https://github.com/IBM/kui/commit/d63a6f1)), closes [#5178](https://github.com/IBM/kui/issues/5178)
- **plugins/plugin-client-common:** improve Terminal screenshots by adding padding ([a9b7b26](https://github.com/IBM/kui/commit/a9b7b26)), closes [#4981](https://github.com/IBM/kui/issues/4981)
- **plugins/plugin-client-common:** improve top tab bottom UI ([8ff4151](https://github.com/IBM/kui/commit/8ff4151)), closes [#5056](https://github.com/IBM/kui/issues/5056)
- **plugins/plugin-client-common:** input may not receive focus on tab switch ([7676792](https://github.com/IBM/kui/commit/7676792)), closes [#5102](https://github.com/IBM/kui/issues/5102)
- **plugins/plugin-client-common:** layout regressions from table screenshot PRs ([8004ee3](https://github.com/IBM/kui/commit/8004ee3)), closes [#5159](https://github.com/IBM/kui/issues/5159)
- **plugins/plugin-client-common:** leftover debug printfs in table sorting ([9889b49](https://github.com/IBM/kui/commit/9889b49)), closes [#5030](https://github.com/IBM/kui/issues/5030)
- **plugins/plugin-client-common:** Light tables should use Carbon compact ([2309ec3](https://github.com/IBM/kui/commit/2309ec3)), closes [#5059](https://github.com/IBM/kui/issues/5059)
- **plugins/plugin-client-common:** one-row tables needn't offer column sorting UI ([5184fa1](https://github.com/IBM/kui/commit/5184fa1)), closes [#5050](https://github.com/IBM/kui/issues/5050)
- **plugins/plugin-client-common:** place event footer outside of table scroll region for minisplits ([e4872b2](https://github.com/IBM/kui/commit/e4872b2)), closes [#5179](https://github.com/IBM/kui/issues/5179)
- **plugins/plugin-client-common:** RadioTable screenshots lack box shadow ([b0e0f2e](https://github.com/IBM/kui/commit/b0e0f2e)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** RadioTables can have gratuituous line wrapping ([9c39682](https://github.com/IBM/kui/commit/9c39682)), closes [#5139](https://github.com/IBM/kui/issues/5139)
- **plugins/plugin-client-common:** RadioTables in minisplits inner-scroll away the header row ([5296dcd](https://github.com/IBM/kui/commit/5296dcd)), closes [#5165](https://github.com/IBM/kui/issues/5165)
- **plugins/plugin-client-common:** regression in table width with sidecar open ([5938806](https://github.com/IBM/kui/commit/5938806)), closes [#5194](https://github.com/IBM/kui/issues/5194)
- **plugins/plugin-client-common:** remove active prompts in an offline notebook ([dd2b53f](https://github.com/IBM/kui/commit/dd2b53f)), closes [#5620](https://github.com/IBM/kui/issues/5620)
- **plugins/plugin-client-common:** selected row in RadioTables in dark themes has low contrast ([f2c5834](https://github.com/IBM/kui/commit/f2c5834)), closes [#5161](https://github.com/IBM/kui/issues/5161)
- **plugins/plugin-client-common:** SequenceDiagram can have NaNs in the UI ([ac476a6](https://github.com/IBM/kui/commit/ac476a6)), closes [#5559](https://github.com/IBM/kui/issues/5559)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-client-common:** sidecar badges may not be flush-right ([5b54665](https://github.com/IBM/kui/commit/5b54665)), closes [#5175](https://github.com/IBM/kui/issues/5175)
- **plugins/plugin-client-common:** switching table from Table to Timeline and back to Table does not work ([c924d67](https://github.com/IBM/kui/commit/c924d67)), closes [#5430](https://github.com/IBM/kui/issues/5430)
- **plugins/plugin-client-common:** table screenshots include a gray stripe at the top ([11a9fc3](https://github.com/IBM/kui/commit/11a9fc3)), closes [#5410](https://github.com/IBM/kui/issues/5410)
- **plugins/plugin-client-common:** Tables should have a max-height and use inner scrolling for overflow ([642ef14](https://github.com/IBM/kui/commit/642ef14)), closes [#5153](https://github.com/IBM/kui/issues/5153)
- **plugins/plugin-client-common:** Tables with identical column names render incorrectly ([161dba2](https://github.com/IBM/kui/commit/161dba2)), closes [#5129](https://github.com/IBM/kui/issues/5129)
- **plugins/plugin-client-common:** Terminal Block -> Screenshot of table does not capture box shadow ([ed812f3](https://github.com/IBM/kui/commit/ed812f3)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** Terminal focus changes unexpectedly ([866451c](https://github.com/IBM/kui/commit/866451c)), closes [#5170](https://github.com/IBM/kui/issues/5170)
- **plugins/plugin-client-common:** threshold for auto-grid is too low ([9cb76ee](https://github.com/IBM/kui/commit/9cb76ee)), closes [#5424](https://github.com/IBM/kui/issues/5424)
- **plugins/plugin-client-common:** Timeline should use stdev-based heat map ([5dd7427](https://github.com/IBM/kui/commit/5dd7427)), closes [#5395](https://github.com/IBM/kui/issues/5395)
- **plugins/plugin-client-common:** Timeline tooltip for cold starts has incorrect concurrency count ([bb54cb8](https://github.com/IBM/kui/commit/bb54cb8)), closes [#5390](https://github.com/IBM/kui/issues/5390)
- **plugins/plugin-client-common:** two MiniSplits with open sidecar are too short ([9e21ab9](https://github.com/IBM/kui/commit/9e21ab9)), closes [#5171](https://github.com/IBM/kui/issues/5171)
- **plugins/plugin-client-common:** update SequenceDiagram view to display the duration of each interval ([0cf1fcf](https://github.com/IBM/kui/commit/0cf1fcf)), closes [#5470](https://github.com/IBM/kui/issues/5470)
- **plugins/plugin-client-common:** update welcome.json notebook to improve listing of available notebooks ([c6f89f4](https://github.com/IBM/kui/commit/c6f89f4)), closes [#5583](https://github.com/IBM/kui/issues/5583)
- **plugins/plugin-client-common:** watch pane grid cells too large ([225f937](https://github.com/IBM/kui/commit/225f937)), closes [#5070](https://github.com/IBM/kui/issues/5070)
- **plugins/plugin-client-common:** watch tables might not be maximized in minisplits ([63420b2](https://github.com/IBM/kui/commit/63420b2)), closes [#5218](https://github.com/IBM/kui/issues/5218)
- **plugins/plugin-client-commong:** show RadioTable selected row in the table body and header breadcrumb ([811c21e](https://github.com/IBM/kui/commit/811c21e)), closes [#5239](https://github.com/IBM/kui/issues/5239)
- **plugins/plugin-client-default:** improve debug logging of client properties ([4daba1f](https://github.com/IBM/kui/commit/4daba1f)), closes [#5088](https://github.com/IBM/kui/issues/5088)
- **plugins/plugin-ibmcloud:** ibmcloud ce job list does not support name filters ([5daa930](https://github.com/IBM/kui/commit/5daa930)), closes [#5450](https://github.com/IBM/kui/issues/5450)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- Card component does not render well in dark themes ([d96def0](https://github.com/IBM/kui/commit/d96def0)), closes [#4996](https://github.com/IBM/kui/issues/4996)
- clients should be able to enable watcher auto pinning without enabling splitTerminals ([bcade13](https://github.com/IBM/kui/commit/bcade13)), closes [#5002](https://github.com/IBM/kui/issues/5002)
- Confirm dialog color contrast issues ([da14c25](https://github.com/IBM/kui/commit/da14c25)), closes [#4995](https://github.com/IBM/kui/issues/4995)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- increase contrast in watch pane ([246ecd2](https://github.com/IBM/kui/commit/246ecd2)), closes [#5000](https://github.com/IBM/kui/issues/5000) [#5001](https://github.com/IBM/kui/issues/5001)
- move default loadingDone icon into plugin-client-common ([39994bc](https://github.com/IBM/kui/commit/39994bc)), closes [#5026](https://github.com/IBM/kui/issues/5026)
- move patternfly alignment out of patternfly themes plugin ([6adbfd6](https://github.com/IBM/kui/commit/6adbfd6)), closes [#4988](https://github.com/IBM/kui/issues/4988)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- still see name-related breadcrumbs and short-name header with feature flag sidecarName 'heroText' ([1a8be9f](https://github.com/IBM/kui/commit/1a8be9f)), closes [#5013](https://github.com/IBM/kui/issues/5013)
- **plugins/plugin-client-common:** add error icon for error blocks ([5d9aeea](https://github.com/IBM/kui/commit/5d9aeea)), closes [#4907](https://github.com/IBM/kui/issues/4907)
- **plugins/plugin-client-common:** carbon breadcrumbs may not have proper hover effect ([c8cd2d1](https://github.com/IBM/kui/commit/c8cd2d1)), closes [#4962](https://github.com/IBM/kui/issues/4962)
- **plugins/plugin-client-common:** kubectl edit saves can result in unstyled notification ([5dc658e](https://github.com/IBM/kui/commit/5dc658e)), closes [#4930](https://github.com/IBM/kui/issues/4930)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** poor alignment of sidecar toolbar elements ([2307a46](https://github.com/IBM/kui/commit/2307a46)), closes [#4970](https://github.com/IBM/kui/issues/4970)
- **plugins/plugin-client-common:** regression: non-empty repl output has 'ok' at the end ([103a0f9](https://github.com/IBM/kui/commit/103a0f9)), closes [#4924](https://github.com/IBM/kui/issues/4924)
- **plugins/plugin-client-common:** reverse-i-search does not properly report no matches ([c16dad3](https://github.com/IBM/kui/commit/c16dad3)), closes [#4943](https://github.com/IBM/kui/issues/4943)
- **plugins/plugin-client-common:** Screenshot modal never goes away ([bbd1c98](https://github.com/IBM/kui/commit/bbd1c98)), closes [#4979](https://github.com/IBM/kui/issues/4979)
- **plugins/plugin-client-common:** spurious warning in the console re: Tag ([93982de](https://github.com/IBM/kui/commit/93982de)), closes [#4959](https://github.com/IBM/kui/issues/4959)
- **plugins/plugin-client-common:** status cells of live tables do not always blink ([c94b05e](https://github.com/IBM/kui/commit/c94b05e)), closes [#4903](https://github.com/IBM/kui/issues/4903)
- **plugins/plugin-client-common:** UpdateNotification widget has invisible background color ([c0c1d82](https://github.com/IBM/kui/commit/c0c1d82)), closes [#4968](https://github.com/IBM/kui/issues/4968)
- **plugins/plugin-client-common:** WatchPane has incorrect padding ([e74bd7b](https://github.com/IBM/kui/commit/e74bd7b)), closes [#5015](https://github.com/IBM/kui/issues/5015)
- **plugins/plugin-patternfly-themes:** update theme alignment to patternfly v4 ([3784b96](https://github.com/IBM/kui/commit/3784b96)), closes [#4948](https://github.com/IBM/kui/issues/4948)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- erratic scroll region behavior ([be0e2a0](https://github.com/IBM/kui/commit/be0e2a0)), closes [#4898](https://github.com/IBM/kui/issues/4898)
- page-content p should not use text-align: justify ([2646f4b](https://github.com/IBM/kui/commit/2646f4b)), closes [#4908](https://github.com/IBM/kui/issues/4908)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** clicking the remove button of a repl block results in an error white screen ([49bfbcc](https://github.com/IBM/kui/commit/49bfbcc)), closes [#4855](https://github.com/IBM/kui/issues/4855)
- **plugins/plugin-client-common:** in Popup mode, use > rather than / for prompt in bottom input ([1360bed](https://github.com/IBM/kui/commit/1360bed)), closes [#4887](https://github.com/IBM/kui/issues/4887)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- **plugins/plugin-client-common:** split button errors are not reported to the user ([fc4e2a2](https://github.com/IBM/kui/commit/fc4e2a2)), closes [#4876](https://github.com/IBM/kui/issues/4876)
- **plugins/plugin-client-common:** table container should only be width:100% for table not display-as-grid ([8f327cd](https://github.com/IBM/kui/commit/8f327cd)), closes [#4871](https://github.com/IBM/kui/issues/4871)
- **plugins/plugin-client-common:** top tab buttons should be owned by the top tab stripe ([9a45c43](https://github.com/IBM/kui/commit/9a45c43)), closes [#4690](https://github.com/IBM/kui/issues/4690)
- **plugins/plugn-client-common:** TopTabStripe stays blue after command execution completes ([68f5841](https://github.com/IBM/kui/commit/68f5841)), closes [#4883](https://github.com/IBM/kui/issues/4883)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- sidecar back/forward should be ordered by visitation rather than insertion ([fba613a](https://github.com/IBM/kui/commit/fba613a)), closes [#4746](https://github.com/IBM/kui/issues/4746)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- split screen terminals sometimes incorrect handle exit ([d63cde7](https://github.com/IBM/kui/commit/d63cde7)), closes [#4860](https://github.com/IBM/kui/issues/4860)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- TopNavSidecar doesn't return to the previous selected Tab when back button is hit ([32acee5](https://github.com/IBM/kui/commit/32acee5)), closes [#4745](https://github.com/IBM/kui/issues/4745)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** dropdown in sidecar theming and spacing tweaks ([1a48af3](https://github.com/IBM/kui/commit/1a48af3)), closes [#4680](https://github.com/IBM/kui/issues/4680)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** improve visibility of sidecar scrollbars ([827d75a](https://github.com/IBM/kui/commit/827d75a)), closes [#4667](https://github.com/IBM/kui/issues/4667)
- **plugins/plugin-client-common:** increase font size of status stripe ([2fab637](https://github.com/IBM/kui/commit/2fab637)), closes [#4698](https://github.com/IBM/kui/issues/4698)
- **plugins/plugin-client-common:** input element changes height with i-search and bottomInput ([abf9890](https://github.com/IBM/kui/commit/abf9890)), closes [#4685](https://github.com/IBM/kui/issues/4685)
- **plugins/plugin-client-common:** LeftNav sidecar nav column width inconsistency ([17e403f](https://github.com/IBM/kui/commit/17e403f)), closes [#4688](https://github.com/IBM/kui/issues/4688)
- **plugins/plugin-client-common:** LeftNavSidecar does not always reflect updated content ([0f2e1e1](https://github.com/IBM/kui/commit/0f2e1e1)), closes [#4727](https://github.com/IBM/kui/issues/4727) [#4732](https://github.com/IBM/kui/issues/4732)
- **plugins/plugin-client-common:** LeftNavSidecar font size and layout issues ([d9914f1](https://github.com/IBM/kui/commit/d9914f1)), closes [#4718](https://github.com/IBM/kui/issues/4718) [#4719](https://github.com/IBM/kui/issues/4719)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** move screenshot button out of status stripe ([0ef900b](https://github.com/IBM/kui/commit/0ef900b)), closes [#4556](https://github.com/IBM/kui/issues/4556)
- **plugins/plugin-client-common:** PatternFly DropDown rendering glitches ([8efedd8](https://github.com/IBM/kui/commit/8efedd8)), closes [#4649](https://github.com/IBM/kui/issues/4649) [#4651](https://github.com/IBM/kui/issues/4651)
- **plugins/plugin-client-common:** refine Loading component ([7a07ad3](https://github.com/IBM/kui/commit/7a07ad3)), closes [#4702](https://github.com/IBM/kui/issues/4702)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- **plugins/plugin-client-common:** session init done message messes up Terminal scrolling ([7e80ac1](https://github.com/IBM/kui/commit/7e80ac1)), closes [#4683](https://github.com/IBM/kui/issues/4683)
- **plugins/plugin-client-common:** sidecar toolbar text incorrectly aligned ([ddd7460](https://github.com/IBM/kui/commit/ddd7460)), closes [#4659](https://github.com/IBM/kui/issues/4659)
- **plugins/plugin-client-common:** Terminal screenshot odd w.r.t. auto-focus ([4b1c7d8](https://github.com/IBM/kui/commit/4b1c7d8)), closes [#4739](https://github.com/IBM/kui/issues/4739)
- **plugins/plugin-client-common:** TopNavSidecar tabs easily overflow with narrower windows ([a555cd4](https://github.com/IBM/kui/commit/a555cd4)), closes [#4735](https://github.com/IBM/kui/issues/4735)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- sidecar container selection kebab has different color with its menu ([639617a](https://github.com/IBM/kui/commit/639617a)), closes [#4676](https://github.com/IBM/kui/issues/4676)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- **plugins/plugin-client-common:** reverse the dependency of Card and DropDown ([00b8ecf](https://github.com/IBM/kui/commit/00b8ecf)), closes [#4641](https://github.com/IBM/kui/issues/4641)
- **plugins/plugin-client-common:** Screenshot button should not be offered inBrowser ([d1c2cfb](https://github.com/IBM/kui/commit/d1c2cfb)), closes [#4636](https://github.com/IBM/kui/issues/4636)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane has non-zero height even when empty ([67a7070](https://github.com/IBM/kui/commit/67a7070)), closes [#4629](https://github.com/IBM/kui/issues/4629)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- **plugins/plugin-core-support:** sidecar "window" buttons are too large ([33415d2](https://github.com/IBM/kui/commit/33415d2)), closes [#5094](https://github.com/IBM/kui/issues/5094)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- upgrade @patternfly/react-core to latest ([0331533](https://github.com/IBM/kui/commit/0331533)), closes [#4937](https://github.com/IBM/kui/issues/4937)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add CommentaryReponse to snapshot/replay the response of commentary command ([7d13a93](https://github.com/IBM/kui/commit/7d13a93)), closes [#5439](https://github.com/IBM/kui/issues/5439)
- add events to sidecar tree ([dd4d552](https://github.com/IBM/kui/commit/dd4d552)), closes [#6140](https://github.com/IBM/kui/issues/6140)
- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- add unit support of TreeResponse as one of the contents in MultiModalResponse ([85ea2d5](https://github.com/IBM/kui/commit/85ea2d5)), closes [#6132](https://github.com/IBM/kui/issues/6132)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- execute the command in url query when the browser app is loaded ([b0b95cf](https://github.com/IBM/kui/commit/b0b95cf)), closes [#5879](https://github.com/IBM/kui/issues/5879)
- Feature: improve support for parallelization across VFS operations ([e05d7e0](https://github.com/IBM/kui/commit/e05d7e0)), closes [#5831](https://github.com/IBM/kui/issues/5831)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- in `kubectl get -f` tree, use Monaco DiffEditor show the preview of dry-run changes ([99266e8](https://github.com/IBM/kui/commit/99266e8)), closes [#6181](https://github.com/IBM/kui/issues/6181) [#6154](https://github.com/IBM/kui/issues/6154)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- introduce reexec for rerunning commands ([fe80525](https://github.com/IBM/kui/commit/fe80525)), closes [#6026](https://github.com/IBM/kui/issues/6026)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- lightweight ui options for core themes ([cf96867](https://github.com/IBM/kui/commit/cf96867)), closes [#6187](https://github.com/IBM/kui/issues/6187)
- **plugins/plugin-client-common:** allow clients to specify initial tab title ([e8e365f](https://github.com/IBM/kui/commit/e8e365f)), closes [#5539](https://github.com/IBM/kui/issues/5539)
- **plugins/plugin-client-common:** allow users to insert command before a repl block ([e935092](https://github.com/IBM/kui/commit/e935092)), closes [#5576](https://github.com/IBM/kui/issues/5576)
- **plugins/plugin-client-common:** allow users to reorder blocks by MoveUp and MoveDown buttons ([f7f6918](https://github.com/IBM/kui/commit/f7f6918)), closes [#5589](https://github.com/IBM/kui/issues/5589)
- **plugins/plugin-client-common:** edit a commentary response using SimpleEditor ([6d828c1](https://github.com/IBM/kui/commit/6d828c1)), closes [#5664](https://github.com/IBM/kui/issues/5664)
- **plugins/plugin-client-common:** improve action button UI for output-only blocks ([9cb99ad](https://github.com/IBM/kui/commit/9cb99ad)), closes [#5660](https://github.com/IBM/kui/issues/5660)
- **plugins/plugin-client-common:** Improve Commentary editing UI by adding real Done button ([1f544b5](https://github.com/IBM/kui/commit/1f544b5)), closes [#5667](https://github.com/IBM/kui/issues/5667)
- **plugins/plugin-client-common:** Output-only blocks should offer a Copy action button ([da4f85d](https://github.com/IBM/kui/commit/da4f85d)), closes [#5646](https://github.com/IBM/kui/issues/5646)
- **plugins/plugin-client-common:** User should be able to tab navigate through blocks ([54d3759](https://github.com/IBM/kui/commit/54d3759)), closes [#5717](https://github.com/IBM/kui/issues/5717)
- **plugins/plugin-kubectl:** kubectl get -f can use Tree to present structured result ([f94a22f](https://github.com/IBM/kui/commit/f94a22f)), closes [#6136](https://github.com/IBM/kui/issues/6136)
- Make a notebook about making notebooks ([0d67947](https://github.com/IBM/kui/commit/0d67947)), closes [#6040](https://github.com/IBM/kui/issues/6040)
- Move in OpenWhisk plugin from the external repo ([b9c5867](https://github.com/IBM/kui/commit/b9c5867)), closes [#6109](https://github.com/IBM/kui/issues/6109)
- use Accordion for SourceRef ([1b11736](https://github.com/IBM/kui/commit/1b11736)), closes [#6097](https://github.com/IBM/kui/issues/6097)
- **plugins/plugin-client-common:** block-level copy/paste ([a72cf8d](https://github.com/IBM/kui/commit/a72cf8d)), closes [#5752](https://github.com/IBM/kui/issues/5752)
- **plugins/plugin-client-common:** error messages should format as markdown ([63ca4a7](https://github.com/IBM/kui/commit/63ca4a7)), closes [#5943](https://github.com/IBM/kui/issues/5943)
- **plugins/plugin-client-common:** SourceRef should be default-expanded in Notebooks? ([8ee26e8](https://github.com/IBM/kui/commit/8ee26e8)), closes [#5866](https://github.com/IBM/kui/issues/5866)
- **plugins/plugin-client-common:** split command should allow user to specify splice index ([75857e9](https://github.com/IBM/kui/commit/75857e9)), closes [#5746](https://github.com/IBM/kui/issues/5746)
- ability to register an onClose handler when opening a tab ([58a36c3](https://github.com/IBM/kui/commit/58a36c3)), closes [#5670](https://github.com/IBM/kui/issues/5670)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add capability to click to edit/rerun a command ([4296933](https://github.com/IBM/kui/commit/4296933)), closes [#5654](https://github.com/IBM/kui/issues/5654)
- add sequence diagram to table with timestamp columns ([e9028ee](https://github.com/IBM/kui/commit/e9028ee)), closes [#5336](https://github.com/IBM/kui/issues/5336)
- allow command registrations to express their experimental nature ([eb9f147](https://github.com/IBM/kui/commit/eb9f147)), closes [#5282](https://github.com/IBM/kui/issues/5282)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow table model to specify a gridable column index ([f4ba8e6](https://github.com/IBM/kui/commit/f4ba8e6)), closes [#5278](https://github.com/IBM/kui/issues/5278)
- auto gridify large table ([bd22fa2](https://github.com/IBM/kui/commit/bd22fa2)), closes [#5305](https://github.com/IBM/kui/issues/5305)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- command history should be tab-specific ([1b987e0](https://github.com/IBM/kui/commit/1b987e0)), closes [#1299](https://github.com/IBM/kui/issues/1299)
- commentary command to add comments to REPL ([c304fd3](https://github.com/IBM/kui/commit/c304fd3)), closes [#5428](https://github.com/IBM/kui/issues/5428)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- improve repl-block selection ([305b36f](https://github.com/IBM/kui/commit/305b36f)), closes [#5587](https://github.com/IBM/kui/issues/5587)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- initial/minimal snapshot/replay support ([bb7ae0f](https://github.com/IBM/kui/commit/bb7ae0f)), closes [#5280](https://github.com/IBM/kui/issues/5280)
- inverse splits ([38d2895](https://github.com/IBM/kui/commit/38d2895)), closes [#5537](https://github.com/IBM/kui/issues/5537)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- pass command line comments to commentary command ([a020db5](https://github.com/IBM/kui/commit/a020db5)), closes [#5459](https://github.com/IBM/kui/issues/5459)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- save/restore pty command output ([2c291a9](https://github.com/IBM/kui/commit/2c291a9)), closes [#5314](https://github.com/IBM/kui/issues/5314)
- separate out themes into a new settings Notebook ([5180759](https://github.com/IBM/kui/commit/5180759)), closes [#5605](https://github.com/IBM/kui/issues/5605)
- shift Block UI to use a Notebook style of presentation ([dc0ee4b](https://github.com/IBM/kui/commit/dc0ee4b)), closes [#5258](https://github.com/IBM/kui/issues/5258)
- snapshot freshening ([d5c8991](https://github.com/IBM/kui/commit/d5c8991)), closes [#5522](https://github.com/IBM/kui/issues/5522)
- support replaying in new tab ([04a2c67](https://github.com/IBM/kui/commit/04a2c67)), closes [#5509](https://github.com/IBM/kui/issues/5509)
- update ls to allow for presenting content from more limited VFS's such as tutorials ([a1ff1a4](https://github.com/IBM/kui/commit/a1ff1a4)), closes [#5497](https://github.com/IBM/kui/issues/5497)
- **plugins/plugin-client-common:** allow easier rerunning of command from terminal ([c5384e0](https://github.com/IBM/kui/commit/c5384e0)), closes [#4570](https://github.com/IBM/kui/issues/4570)
- **plugins/plugin-client-common:** History navigation in minisplits should navigate In/Out pairs ([93eb2a4](https://github.com/IBM/kui/commit/93eb2a4)), closes [#5270](https://github.com/IBM/kui/issues/5270)
- **plugins/plugin-client-common:** Improve notebook-style ui ([791160e](https://github.com/IBM/kui/commit/791160e)), closes [#5472](https://github.com/IBM/kui/issues/5472)
- **plugins/plugin-client-common:** improve presentation of sidecar-destined responses ([02b91e3](https://github.com/IBM/kui/commit/02b91e3)), closes [#5463](https://github.com/IBM/kui/issues/5463)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- Timeline view for kubernetes Jobs ([b623e4e](https://github.com/IBM/kui/commit/b623e4e)), closes [#5370](https://github.com/IBM/kui/issues/5370)
- **plugins/plugin-client-common:** show table row count in card header ([deadcfa](https://github.com/IBM/kui/commit/deadcfa)), closes [#5137](https://github.com/IBM/kui/issues/5137)
- **plugins/plugin-client-common:** use Cards to wrap kube tables and grids ([6698013](https://github.com/IBM/kui/commit/6698013)), closes [#5032](https://github.com/IBM/kui/issues/5032)
- **plugins/plugin-client-common:** use inner scrolling for RadioTables in main Terminals ([952f72a](https://github.com/IBM/kui/commit/952f72a)), closes [#5133](https://github.com/IBM/kui/issues/5133)
- <Kui> should allow for custom Input elements ([193a108](https://github.com/IBM/kui/commit/193a108)), closes [#4672](https://github.com/IBM/kui/issues/4672)
- add a command to return the Card Component in Terminal ([d8d13ab](https://github.com/IBM/kui/commit/d8d13ab)), closes [#4973](https://github.com/IBM/kui/issues/4973)
- add alert command to display Alert component in Terminal ([495d3bb](https://github.com/IBM/kui/commit/495d3bb)), closes [#4957](https://github.com/IBM/kui/issues/4957)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for <Kui noPromptContext/> and <Kui prompt=">"/> ([a92063d](https://github.com/IBM/kui/commit/a92063d)), closes [#4653](https://github.com/IBM/kui/issues/4653)
- allow <Kui/> users to provide custom views for session init ([1f35894](https://github.com/IBM/kui/commit/1f35894)), closes [#4596](https://github.com/IBM/kui/issues/4596)
- allow clients to modify the session lifecycle UI by providing custom strings ([3c78fd3](https://github.com/IBM/kui/commit/3c78fd3)), closes [#5019](https://github.com/IBM/kui/issues/5019)
- allow subclasses of InputProvider to specify their own State ([c3fc88e](https://github.com/IBM/kui/commit/c3fc88e)), closes [#4756](https://github.com/IBM/kui/issues/4756)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- Update default loadingDone to use Card component ([e1b4c61](https://github.com/IBM/kui/commit/e1b4c61)), closes [#4986](https://github.com/IBM/kui/issues/4986)
- **plugins/plugin-client-common:** add support for Tags in StatusStripe ([d112c86](https://github.com/IBM/kui/commit/d112c86)), closes [#4951](https://github.com/IBM/kui/issues/4951)
- **plugins/plugin-client-common:** improve accessibility of "red" error grid cells ([8921292](https://github.com/IBM/kui/commit/8921292)), closes [#4938](https://github.com/IBM/kui/issues/4938)
- **plugins/plugin-client-common:** support client option for hero names in sidecar ([d4f6984](https://github.com/IBM/kui/commit/d4f6984)), closes [#4909](https://github.com/IBM/kui/issues/4909)
- Dropdown spi and use in Terminal Block ([327917b](https://github.com/IBM/kui/commit/327917b)), closes [#4589](https://github.com/IBM/kui/issues/4589) [#4556](https://github.com/IBM/kui/issues/4556)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- RadioTable and port of the themes table to use it ([79a3e8e](https://github.com/IBM/kui/commit/79a3e8e)), closes [#4507](https://github.com/IBM/kui/issues/4507)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- update checker ([a7908d2](https://github.com/IBM/kui/commit/a7908d2)), closes [#4537](https://github.com/IBM/kui/issues/4537)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [9.1.0](https://github.com/IBM/kui/compare/v4.5.0...v9.1.0) (2020-10-26)

### Bug Fixes

- **plugin-client-common:** RadioTable onSelect changes do not always result in status stripe updates ([3549b7a](https://github.com/IBM/kui/commit/3549b7a)), closes [#5644](https://github.com/IBM/kui/issues/5644)
- **plugin-client-common:** show the last input block in minisplit ([7997ef0](https://github.com/IBM/kui/commit/7997ef0)), closes [#5756](https://github.com/IBM/kui/issues/5756)
- **plugins/plugin-client-common:** Whem moving blocks, the moved block is not longer focused after the move ([fc13198](https://github.com/IBM/kui/commit/fc13198)), closes [#5612](https://github.com/IBM/kui/issues/5612)
- **plugins/plugin-client-common:** "No events in the past hour" in sidecar has different bg color than other tabs ([ffba806](https://github.com/IBM/kui/commit/ffba806)), closes [#6075](https://github.com/IBM/kui/issues/6075)
- block focus regressions ([881fa17](https://github.com/IBM/kui/commit/881fa17)), closes [#6072](https://github.com/IBM/kui/issues/6072)
- don't show "Created a split" when clicking on the New Split button ([80192d5](https://github.com/IBM/kui/commit/80192d5)), closes [#6001](https://github.com/IBM/kui/issues/6001)
- **plugins-client-common:** bump carbon-components-react to 7.22 ([8b98791](https://github.com/IBM/kui/commit/8b98791)), closes [#6011](https://github.com/IBM/kui/issues/6011)
- **plugins/plugin-client-common:** "Drilled down to..." text is not aligned with the Input area ([fd139d2](https://github.com/IBM/kui/commit/fd139d2)), closes [#5854](https://github.com/IBM/kui/issues/5854)
- **plugins/plugin-client-common:** a few more patternfly navigation styling issues ([5511c1f](https://github.com/IBM/kui/commit/5511c1f)), closes [#6049](https://github.com/IBM/kui/issues/6049)
- **plugins/plugin-client-common:** a few small refinements to "editing" UI for Inputs ([001236a](https://github.com/IBM/kui/commit/001236a)), closes [#5656](https://github.com/IBM/kui/issues/5656) [#5658](https://github.com/IBM/kui/issues/5658)
- **plugins/plugin-client-common:** Action button hover hysteresis/delay effect not working ([fac75dc](https://github.com/IBM/kui/commit/fac75dc)), closes [#5806](https://github.com/IBM/kui/issues/5806)
- **plugins/plugin-client-common:** active pty output doesn't have repl-context ([6b0929e](https://github.com/IBM/kui/commit/6b0929e)), closes [#5960](https://github.com/IBM/kui/issues/5960)
- **plugins/plugin-client-common:** Block Action buttons have poor contrast in dark themes ([f52511e](https://github.com/IBM/kui/commit/f52511e)), closes [#5590](https://github.com/IBM/kui/issues/5590)
- **plugins/plugin-client-common:** Block Actions should be top-aligned in output-only blocks ([55ce899](https://github.com/IBM/kui/commit/55ce899)), closes [#5595](https://github.com/IBM/kui/issues/5595)
- **plugins/plugin-client-common:** block left-border is not centered with In[1] text in minisplits ([4df61cc](https://github.com/IBM/kui/commit/4df61cc)), closes [#5585](https://github.com/IBM/kui/issues/5585)
- **plugins/plugin-client-common:** blockquotes in commentary don't render well ([9be35fa](https://github.com/IBM/kui/commit/9be35fa)), closes [#5931](https://github.com/IBM/kui/issues/5931)
- **plugins/plugin-client-common:** clicking on table or radio table may cause block to disappear ([1f2d489](https://github.com/IBM/kui/commit/1f2d489)), closes [#5783](https://github.com/IBM/kui/issues/5783)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** ClipboardTransfer emits errors when pasting non-json text ([6ff85c4](https://github.com/IBM/kui/commit/6ff85c4)), closes [#5836](https://github.com/IBM/kui/issues/5836)
- **plugins/plugin-client-common:** CodeSnippet component renders with zero contrast in dark themes ([10e40a9](https://github.com/IBM/kui/commit/10e40a9)), closes [#5886](https://github.com/IBM/kui/issues/5886)
- **plugins/plugin-client-common:** colored squares in status column of tables have odd alignment ([3e78540](https://github.com/IBM/kui/commit/3e78540)), closes [#5766](https://github.com/IBM/kui/issues/5766)
- **plugins/plugin-client-common:** Commentary blocks are not focusable in minisplits ([1286b0d](https://github.com/IBM/kui/commit/1286b0d)), closes [#5594](https://github.com/IBM/kui/issues/5594)
- **plugins/plugin-client-common:** Commentary editor can easily overflow when editing in minisplit ([eb14074](https://github.com/IBM/kui/commit/eb14074)), closes [#5675](https://github.com/IBM/kui/issues/5675)
- **plugins/plugin-client-common:** commentary editor can overflow with long lines ([3475287](https://github.com/IBM/kui/commit/3475287)), closes [#5981](https://github.com/IBM/kui/issues/5981)
- **plugins/plugin-client-common:** Commentary editor is 5px tall when presented in mini split ([53074d1](https://github.com/IBM/kui/commit/53074d1)), closes [#5744](https://github.com/IBM/kui/issues/5744)
- **plugins/plugin-client-common:** Commentary editor should be full width always ([e0a164a](https://github.com/IBM/kui/commit/e0a164a)), closes [#5688](https://github.com/IBM/kui/issues/5688)
- **plugins/plugin-client-common:** Commentary is always full width ([1920fb9](https://github.com/IBM/kui/commit/1920fb9)), closes [#5705](https://github.com/IBM/kui/issues/5705)
- **plugins/plugin-client-common:** Commentary markdown does not support kuiexec ([4663389](https://github.com/IBM/kui/commit/4663389)), closes [#5911](https://github.com/IBM/kui/issues/5911)
- **plugins/plugin-client-common:** creating a split with a 3-way split configuration results in radical shuffling ([9452b5a](https://github.com/IBM/kui/commit/9452b5a)), closes [#5794](https://github.com/IBM/kui/issues/5794)
- **plugins/plugin-client-common:** custom repl-prompt is misaligned with repl-output ([d12b203](https://github.com/IBM/kui/commit/d12b203)), closes [#6046](https://github.com/IBM/kui/issues/6046)
- **plugins/plugin-client-common:** deleting and re-creating a split results double commands ([dde6eaa](https://github.com/IBM/kui/commit/dde6eaa)), closes [#5876](https://github.com/IBM/kui/issues/5876)
- **plugins/plugin-client-common:** disable Timeline option for Tables ([e88ebb3](https://github.com/IBM/kui/commit/e88ebb3)), closes [#5864](https://github.com/IBM/kui/issues/5864)
- **plugins/plugin-client-common:** Do not focus Block when user expands SourceRef ([6642514](https://github.com/IBM/kui/commit/6642514)), closes [#5711](https://github.com/IBM/kui/issues/5711)
- **plugins/plugin-client-common:** do not show the command rerun and remove button for offline kui ([309162f](https://github.com/IBM/kui/commit/309162f)), closes [#5917](https://github.com/IBM/kui/issues/5917)
- **plugins/plugin-client-common:** don't decorate code elements in top tab ([531e8b8](https://github.com/IBM/kui/commit/531e8b8)), closes [#5778](https://github.com/IBM/kui/issues/5778)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** don't show "2 rows" table header for short tables ([2350115](https://github.com/IBM/kui/commit/2350115)), closes [#5581](https://github.com/IBM/kui/issues/5581)
- **plugins/plugin-client-common:** don't show `isTabLayoutModificationResponse` and PresentedElseWhere response in MiniSplit ([a16767a](https://github.com/IBM/kui/commit/a16767a)), closes [#5690](https://github.com/IBM/kui/issues/5690)
- **plugins/plugin-client-common:** double clicking on Commentary in minisplit often has the editor completely off screen ([c3504a0](https://github.com/IBM/kui/commit/c3504a0)), closes [#5897](https://github.com/IBM/kui/issues/5897)
- **plugins/plugin-client-common:** editing commentary gives a one-line monaco ([5f14268](https://github.com/IBM/kui/commit/5f14268)), closes [#5874](https://github.com/IBM/kui/issues/5874)
- **plugins/plugin-client-common:** Editing Commentary should require double click ([efaded3](https://github.com/IBM/kui/commit/efaded3)), closes [#5686](https://github.com/IBM/kui/issues/5686)
- **plugins/plugin-client-common:** empty blocks have excessive height ([12c39b0](https://github.com/IBM/kui/commit/12c39b0)), closes [#5707](https://github.com/IBM/kui/issues/5707)
- **plugins/plugin-client-common:** empty pty response yields blank line ([711bd05](https://github.com/IBM/kui/commit/711bd05)), closes [#5928](https://github.com/IBM/kui/issues/5928)
- **plugins/plugin-client-common:** enhance minisplit by updating the background color of scrollback and dark card ([fd15c5e](https://github.com/IBM/kui/commit/fd15c5e)), closes [#5989](https://github.com/IBM/kui/issues/5989)
- **plugins/plugin-client-common:** error blocks are not indented properly ([d137614](https://github.com/IBM/kui/commit/d137614)), closes [#5938](https://github.com/IBM/kui/issues/5938)
- **plugins/plugin-client-common:** focus a block upon moving or pasting it ([43c3d9a](https://github.com/IBM/kui/commit/43c3d9a)), closes [#5751](https://github.com/IBM/kui/issues/5751)
- **plugins/plugin-client-common:** group the notebooks together in the ls -l table ([1a783f3](https://github.com/IBM/kui/commit/1a783f3)), closes [#5977](https://github.com/IBM/kui/issues/5977)
- **plugins/plugin-client-common:** hovering over error block turns red to blue ([3dbddae](https://github.com/IBM/kui/commit/3dbddae)), closes [#5979](https://github.com/IBM/kui/issues/5979)
- **plugins/plugin-client-common:** If a command is issued in a mini split, the next block (in the mini split) is not focused ([a35e5c2](https://github.com/IBM/kui/commit/a35e5c2)), closes [#6067](https://github.com/IBM/kui/issues/6067)
- **plugins/plugin-client-common:** improved focus behavior of terminals ([f5a3dd0](https://github.com/IBM/kui/commit/f5a3dd0)), closes [#5615](https://github.com/IBM/kui/issues/5615)
- **plugins/plugin-client-common:** in dark themes, the inter-split gutter is not visible ([288eeae](https://github.com/IBM/kui/commit/288eeae)), closes [#6022](https://github.com/IBM/kui/issues/6022)
- **plugins/plugin-client-common:** In some themes, grid inner text color can have low contrast. ([01f8698](https://github.com/IBM/kui/commit/01f8698)), closes [#6032](https://github.com/IBM/kui/issues/6032)
- **plugins/plugin-client-common:** increase contrast of unfocused left-stripes for blocks ([ab21295](https://github.com/IBM/kui/commit/ab21295)), closes [#5754](https://github.com/IBM/kui/issues/5754)
- **plugins/plugin-client-common:** input probably needs to word-wrap while in minisplits ([cde272d](https://github.com/IBM/kui/commit/cde272d)), closes [#5696](https://github.com/IBM/kui/issues/5696)
- **plugins/plugin-client-common:** input spinner is not visible in minisplits ([76eec59](https://github.com/IBM/kui/commit/76eec59)), closes [#5684](https://github.com/IBM/kui/issues/5684)
- **plugins/plugin-client-common:** Input timestamp should also hide when block is focused ([6e1ca6d](https://github.com/IBM/kui/commit/6e1ca6d)), closes [#5809](https://github.com/IBM/kui/issues/5809)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** linux can show unneeded scrollbars in tables ([4d49a23](https://github.com/IBM/kui/commit/4d49a23)), closes [#5884](https://github.com/IBM/kui/issues/5884)
- **plugins/plugin-client-common:** Lots of little layout issues, e.g. SimpleEditor is not fully width in minisplits ([5a9a1c6](https://github.com/IBM/kui/commit/5a9a1c6)), closes [#5679](https://github.com/IBM/kui/issues/5679) [#5680](https://github.com/IBM/kui/issues/5680)
- **plugins/plugin-client-common:** markdown inline code in table cells shows with scrollbars on linux and windows ([1ff88b9](https://github.com/IBM/kui/commit/1ff88b9)), closes [#5890](https://github.com/IBM/kui/issues/5890)
- **plugins/plugin-client-common:** markdown with <a> inside <h1> renders with odd font size ([b5e3007](https://github.com/IBM/kui/commit/b5e3007)), closes [#5724](https://github.com/IBM/kui/issues/5724)
- **plugins/plugin-client-common:** monaco highlight color used by SourceRef has low contrast ([385f35e](https://github.com/IBM/kui/commit/385f35e)), closes [#5713](https://github.com/IBM/kui/issues/5713)
- **plugins/plugin-client-common:** PatternFly assumes a 16px body font size, whereas the rest of Kui assumes 14px ([fa65b57](https://github.com/IBM/kui/commit/fa65b57)), closes [#6041](https://github.com/IBM/kui/issues/6041)
- **plugins/plugin-client-common:** PatternFly LeftNav view has excessive padding ([959d059](https://github.com/IBM/kui/commit/959d059)), closes [#6038](https://github.com/IBM/kui/issues/6038)
- **plugins/plugin-client-common:** presented elsewhere text is not vertically centered in block ([766d355](https://github.com/IBM/kui/commit/766d355)), closes [#5760](https://github.com/IBM/kui/issues/5760)
- **plugins/plugin-client-common:** RadioTable should scroll the selected row into view on render ([6eb45db](https://github.com/IBM/kui/commit/6eb45db)), closes [#5781](https://github.com/IBM/kui/issues/5781)
- **plugins/plugin-client-common:** rendering of blockquotes in markdown is inconsistent ([edcc8d1](https://github.com/IBM/kui/commit/edcc8d1)), closes [#6043](https://github.com/IBM/kui/issues/6043)
- A few more themes tweaks are needed ([03be3eb](https://github.com/IBM/kui/commit/03be3eb)), closes [#6034](https://github.com/IBM/kui/issues/6034)
- **plugins/plugin-client-common:** restore hiding of In[1] in minisplit ([8d5c93f](https://github.com/IBM/kui/commit/8d5c93f)), closes [#5985](https://github.com/IBM/kui/issues/5985)
- **plugins/plugin-client-common:** selecting text in prior Input causes selection to be lost and Input to enter edit mode ([4d977d2](https://github.com/IBM/kui/commit/4d977d2)), closes [#5792](https://github.com/IBM/kui/issues/5792)
- **plugins/plugin-client-common:** sidecar markdown code snippet has poor color ([765f166](https://github.com/IBM/kui/commit/765f166)), closes [#5995](https://github.com/IBM/kui/issues/5995)
- add Kui version and github link to client-notebook ([7b2562a](https://github.com/IBM/kui/commit/7b2562a)), closes [#5918](https://github.com/IBM/kui/issues/5918)
- blocks can still disappear if table row is clicked while the enclosing block is focused ([2173af1](https://github.com/IBM/kui/commit/2173af1)), closes [#5814](https://github.com/IBM/kui/issues/5814)
- don't show the `open` command for clicking files in `ls` table ([03ef269](https://github.com/IBM/kui/commit/03ef269)), closes [#5748](https://github.com/IBM/kui/issues/5748)
- for replayed notebooks, don’t show timestamp ([951abc5](https://github.com/IBM/kui/commit/951abc5)), closes [#5763](https://github.com/IBM/kui/issues/5763)
- improve discovery of ibmcloud s3 credentials ([96d5bc0](https://github.com/IBM/kui/commit/96d5bc0)), closes [#5926](https://github.com/IBM/kui/issues/5926)
- improve error reporting from APIs ([edff6f1](https://github.com/IBM/kui/commit/edff6f1)), closes [#5950](https://github.com/IBM/kui/issues/5950)
- RadioTable should have option to not echo the onSelect command ([77d5050](https://github.com/IBM/kui/commit/77d5050)), closes [#5991](https://github.com/IBM/kui/issues/5991)
- **plugins/plugin-client-common:** sorting widgets in table header are wrapping ([e3520dc](https://github.com/IBM/kui/commit/e3520dc)), closes [#5976](https://github.com/IBM/kui/issues/5976)
- **plugins/plugin-client-common:** update the commentary in settings notebook to store the texts as command ([bbb8f6d](https://github.com/IBM/kui/commit/bbb8f6d)), closes [#5992](https://github.com/IBM/kui/issues/5992)
- ls comand is not snapshotable ([f04ca78](https://github.com/IBM/kui/commit/f04ca78)), closes [#5241](https://github.com/IBM/kui/issues/5241)
- Notebook title "Kui Setting" should be "Kui Settings" ([b14b130](https://github.com/IBM/kui/commit/b14b130)), closes [#5870](https://github.com/IBM/kui/issues/5870)
- re-saving a notebook via File/Save application menu does not preserve notebook title ([7fb8b43](https://github.com/IBM/kui/commit/7fb8b43)), closes [#5777](https://github.com/IBM/kui/issues/5777)
- remove up/down actions buttons ([3c8a8a1](https://github.com/IBM/kui/commit/3c8a8a1)), closes [#5774](https://github.com/IBM/kui/issues/5774)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- store the commentary text result to the command when editing is done ([5a3f5e8](https://github.com/IBM/kui/commit/5a3f5e8)), closes [#5916](https://github.com/IBM/kui/issues/5916) [#5672](https://github.com/IBM/kui/issues/5672)
- tweak the input background and border to enhance the readability of notebooks ([3928768](https://github.com/IBM/kui/commit/3928768)), closes [#5982](https://github.com/IBM/kui/issues/5982)
- **plugins/plugin-client-common:** improve look of `code` snippets in Commentary ([493e004](https://github.com/IBM/kui/commit/493e004)), closes [#5768](https://github.com/IBM/kui/issues/5768)
- **plugins/plugin-client-common:** markdown code has incorrect color in a split with inverse color ([c8c10af](https://github.com/IBM/kui/commit/c8c10af)), closes [#5902](https://github.com/IBM/kui/issues/5902)
- **plugins/plugin-client-common:** never show "ok" ([d1b337a](https://github.com/IBM/kui/commit/d1b337a)), closes [#5697](https://github.com/IBM/kui/issues/5697)
- **plugins/plugin-client-common:** on switching tabs, active prompt isn't always focused ([5b28dd2](https://github.com/IBM/kui/commit/5b28dd2)), closes [#5637](https://github.com/IBM/kui/issues/5637)
- **plugins/plugin-client-common:** Output-only blocks probably don't need a re-execute button ([251a81c](https://github.com/IBM/kui/commit/251a81c)), closes [#5662](https://github.com/IBM/kui/issues/5662)
- **plugins/plugin-client-common:** re-snapshoting a notebook can fail ([4caff9c](https://github.com/IBM/kui/commit/4caff9c)), closes [#5736](https://github.com/IBM/kui/issues/5736)
- **plugins/plugin-client-common:** remove active prompts in an offline notebook ([dd2b53f](https://github.com/IBM/kui/commit/dd2b53f)), closes [#5620](https://github.com/IBM/kui/issues/5620)
- **plugins/plugin-client-common:** remove clicks from NotebookImpl ([45f0be5](https://github.com/IBM/kui/commit/45f0be5)), closes [#5856](https://github.com/IBM/kui/issues/5856)
- **plugins/plugin-client-common:** SourceRef viewer should hide liner numbers but show folding ([5f74a46](https://github.com/IBM/kui/commit/5f74a46)), closes [#5719](https://github.com/IBM/kui/issues/5719)
- **plugins/plugin-client-common:** status stripe "blue" color probably needs to be toned done ([137442f](https://github.com/IBM/kui/commit/137442f)), closes [#5772](https://github.com/IBM/kui/issues/5772)
- **plugins/plugin-client-common:** tab switching can be slow on windows ([09f9b7d](https://github.com/IBM/kui/commit/09f9b7d)), closes [#5907](https://github.com/IBM/kui/issues/5907)
- **plugins/plugin-client-common:** table cells with no onclick handler still issue a kui command ([4d8bf37](https://github.com/IBM/kui/commit/4d8bf37)), closes [#5721](https://github.com/IBM/kui/issues/5721)
- **plugins/plugin-client-common:** table is misaligned with command input ([50dc430](https://github.com/IBM/kui/commit/50dc430)), closes [#5734](https://github.com/IBM/kui/issues/5734)
- **plugins/plugin-client-common:** the alert showing lost connection has incorrect height ([1758758](https://github.com/IBM/kui/commit/1758758)), closes [#5905](https://github.com/IBM/kui/issues/5905)
- preferReExecute is lost when re-saving a notebook ([87c6c6f](https://github.com/IBM/kui/commit/87c6c6f)), closes [#5954](https://github.com/IBM/kui/issues/5954)
- **plugins/plugin-client-common:** remove leftover debugging in Scalar/index ([82b8e50](https://github.com/IBM/kui/commit/82b8e50)), closes [#5945](https://github.com/IBM/kui/issues/5945)
- **plugins/plugin-client-common:** saving a snapshot can fail with "cannot read property uuid of undefined" ([85fe1f3](https://github.com/IBM/kui/commit/85fe1f3)), closes [#5913](https://github.com/IBM/kui/issues/5913)
- **plugins/plugin-client-common:** some small tweaks to Commentary headers would help ([b012f8d](https://github.com/IBM/kui/commit/b012f8d)), closes [#5893](https://github.com/IBM/kui/issues/5893)
- **plugins/plugin-client-common:** there is still too much whitespace after no-response commands ([268f159](https://github.com/IBM/kui/commit/268f159)), closes [#5742](https://github.com/IBM/kui/issues/5742)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-client-common:** welcome.json could use some wordsmithing ([e373ab4](https://github.com/IBM/kui/commit/e373ab4)), closes [#5895](https://github.com/IBM/kui/issues/5895)
- **plugins/plugin-client-common:** when replaying notebooks, tab should be scrolled to top ([6567412](https://github.com/IBM/kui/commit/6567412)), closes [#5860](https://github.com/IBM/kui/issues/5860)
- "created split" message should disappear when corresponding split is closed ([f8486f8](https://github.com/IBM/kui/commit/f8486f8)), closes [#5629](https://github.com/IBM/kui/issues/5629)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- **plugins/plugin-client-common:** while editing Commentary, adding ``` causes a bad error ([097b1b0](https://github.com/IBM/kui/commit/097b1b0)), closes [#5682](https://github.com/IBM/kui/issues/5682)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- new tab command can hang if title is provided ([a6c25c6](https://github.com/IBM/kui/commit/a6c25c6)), closes [#5624](https://github.com/IBM/kui/issues/5624)
- output only Actions should also render on hover ([cdbd105](https://github.com/IBM/kui/commit/cdbd105)), closes [#5652](https://github.com/IBM/kui/issues/5652)
- **plugins/plugin-client-common:** StatusStripe widgets can emit react error when switching to notebook tab ([485fcdf](https://github.com/IBM/kui/commit/485fcdf)), closes [#5639](https://github.com/IBM/kui/issues/5639)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- tab new command should respond with ElsewhereCommentary response ([19a7e1d](https://github.com/IBM/kui/commit/19a7e1d)), closes [#5602](https://github.com/IBM/kui/issues/5602)
- terminal clearing versus splits results in non-replayable splits ([8f9dc23](https://github.com/IBM/kui/commit/8f9dc23)), closes [#5626](https://github.com/IBM/kui/issues/5626)
- **plugins/plugin-client-common:** "No resources" in watch pane can occlude watch pane title ([e4fd93a](https://github.com/IBM/kui/commit/e4fd93a)), closes [#5064](https://github.com/IBM/kui/issues/5064)
- **plugins/plugin-client-common:** `ok` string appears at the end of MixResponse ([75606c5](https://github.com/IBM/kui/commit/75606c5)), closes [#5046](https://github.com/IBM/kui/issues/5046)
- **plugins/plugin-client-common:** a few more rem/em font-size issues ([133b347](https://github.com/IBM/kui/commit/133b347)), closes [#5058](https://github.com/IBM/kui/issues/5058)
- **plugins/plugin-client-common:** always place table events in the Card footer ([b667b28](https://github.com/IBM/kui/commit/b667b28)), closes [#5210](https://github.com/IBM/kui/issues/5210)
- **plugins/plugin-client-common:** clearing Terminal does not abort watchers ([34adb50](https://github.com/IBM/kui/commit/34adb50)), closes [#5116](https://github.com/IBM/kui/issues/5116)
- **plugins/plugin-client-common:** clicking 'remove' of a watchable response doesn't abort the underlying pty job ([7eb69fb](https://github.com/IBM/kui/commit/7eb69fb)), closes [#5090](https://github.com/IBM/kui/issues/5090)
- **plugins/plugin-client-common:** clicking on pod delete button can cause command to be executed in minisplit ([37f9019](https://github.com/IBM/kui/commit/37f9019)), closes [#5247](https://github.com/IBM/kui/issues/5247)
- **plugins/plugin-client-common:** decrease height of table footer ([5863622](https://github.com/IBM/kui/commit/5863622)), closes [#5072](https://github.com/IBM/kui/issues/5072)
- **plugins/plugin-client-common:** editor component does not respond to font zooming ([7b7e0f3](https://github.com/IBM/kui/commit/7b7e0f3)), closes [#5120](https://github.com/IBM/kui/issues/5120)
- **plugins/plugin-client-common:** eliminate react "titleInHeader" console warnings ([8cf3797](https://github.com/IBM/kui/commit/8cf3797)), closes [#5078](https://github.com/IBM/kui/issues/5078)
- **plugins/plugin-client-common:** h2 in Notebooks have double underline ([40a4bd1](https://github.com/IBM/kui/commit/40a4bd1)), closes [#5574](https://github.com/IBM/kui/issues/5574)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- replay --freshen does not support multi-split notebooks ([afd070c](https://github.com/IBM/kui/commit/afd070c)), closes [#5571](https://github.com/IBM/kui/issues/5571) [#5572](https://github.com/IBM/kui/issues/5572)
- **plugins-client-common:** the experimental tag should use sans serif ([143464a](https://github.com/IBM/kui/commit/143464a)), closes [#5363](https://github.com/IBM/kui/issues/5363)
- **plugins/plugin-client-common:** add support for titles in commentary ([fbe367c](https://github.com/IBM/kui/commit/fbe367c)), closes [#5434](https://github.com/IBM/kui/issues/5434)
- **plugins/plugin-client-common:** avoid inner scrolling in Commentary cards ([d3ea558](https://github.com/IBM/kui/commit/d3ea558)), closes [#5517](https://github.com/IBM/kui/issues/5517)
- **plugins/plugin-client-common:** buggy header UI in dark themes in minisplits ([55aef48](https://github.com/IBM/kui/commit/55aef48)), closes [#5266](https://github.com/IBM/kui/issues/5266)
- **plugins/plugin-client-common:** clicking to focus on a split does not always cause full focus effect ([bc59bcf](https://github.com/IBM/kui/commit/bc59bcf)), closes [#5263](https://github.com/IBM/kui/issues/5263)
- **plugins/plugin-client-common:** Commentary paragraphs have no separation ([6b77a13](https://github.com/IBM/kui/commit/6b77a13)), closes [#5531](https://github.com/IBM/kui/issues/5531)
- **plugins/plugin-client-common:** CSS no longer is reactive to narrow window ([4eb0a11](https://github.com/IBM/kui/commit/4eb0a11)), closes [#5290](https://github.com/IBM/kui/issues/5290)
- **plugins/plugin-client-common:** custom tab titles may have monospace font ([b34b5a4](https://github.com/IBM/kui/commit/b34b5a4)), closes [#5527](https://github.com/IBM/kui/issues/5527)
- **plugins/plugin-client-common:** defer loading of both icon sets ([7d343b8](https://github.com/IBM/kui/commit/7d343b8)), closes [#5444](https://github.com/IBM/kui/issues/5444)
- **plugins/plugin-client-common:** don't line-wrap input elements in MiniSplits ([c929f5e](https://github.com/IBM/kui/commit/c929f5e)), closes [#5348](https://github.com/IBM/kui/issues/5348)
- **plugins/plugin-client-common:** experiment tag has wrong color contrast in dark themes ([22bfb77](https://github.com/IBM/kui/commit/22bfb77)), closes [#5389](https://github.com/IBM/kui/issues/5389)
- **plugins/plugin-client-common:** Experimental badge should take up less space in minisplits ([268aeb3](https://github.com/IBM/kui/commit/268aeb3)), closes [#5373](https://github.com/IBM/kui/issues/5373)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve behavior of up arrow for first command in MiniSplits ([ed199d4](https://github.com/IBM/kui/commit/ed199d4)), closes [#5297](https://github.com/IBM/kui/issues/5297)
- **plugins/plugin-client-common:** improve layout of In[1] with sidecar open ([263d59a](https://github.com/IBM/kui/commit/263d59a)), closes [#5482](https://github.com/IBM/kui/issues/5482)
- **plugins/plugin-client-common:** improve rendering of output only blocks ([664a8da](https://github.com/IBM/kui/commit/664a8da)), closes [#5467](https://github.com/IBM/kui/issues/5467)
- **plugins/plugin-client-common:** improve row hover effect for SequenceDiagram ([89dbe2a](https://github.com/IBM/kui/commit/89dbe2a)), closes [#5426](https://github.com/IBM/kui/issues/5426)
- **plugins/plugin-client-common:** inconsistent top padding above Cards ([1e1037f](https://github.com/IBM/kui/commit/1e1037f)), closes [#5299](https://github.com/IBM/kui/issues/5299)
- **plugins/plugin-client-common:** increase density of SequenceDiagram ([ae29488](https://github.com/IBM/kui/commit/ae29488)), closes [#5344](https://github.com/IBM/kui/issues/5344)
- **plugins/plugin-client-common:** long input lines should line wrap ([8804bb1](https://github.com/IBM/kui/commit/8804bb1)), closes [#5338](https://github.com/IBM/kui/issues/5338)
- **plugins/plugin-client-common:** minor spacing improvements for Commentary and Notebooks ([c473181](https://github.com/IBM/kui/commit/c473181)), closes [#5503](https://github.com/IBM/kui/issues/5503)
- **plugins/plugin-client-common:** multi-line paste executes commands out of order ([8f39c80](https://github.com/IBM/kui/commit/8f39c80)), closes [#5295](https://github.com/IBM/kui/issues/5295)
- **plugins/plugin-client-common:** only highlight the Active block in the focused split ([feffad4](https://github.com/IBM/kui/commit/feffad4)), closes [#5261](https://github.com/IBM/kui/issues/5261)
- **plugins/plugin-client-common:** pty commands fail in minisplits ([475ea74](https://github.com/IBM/kui/commit/475ea74)), closes [#5267](https://github.com/IBM/kui/issues/5267)
- **plugins/plugin-client-common:** reduce contrast of block left bars ([7c8d371](https://github.com/IBM/kui/commit/7c8d371)), closes [#5275](https://github.com/IBM/kui/issues/5275)
- **plugins/plugin-client-common:** refine Timeline a bit more ([4b12eec](https://github.com/IBM/kui/commit/4b12eec)), closes [#5409](https://github.com/IBM/kui/issues/5409)
- **plugins/plugin-client-common:** regression in columnar alignment of Input and Output ([cf1a836](https://github.com/IBM/kui/commit/cf1a836)), closes [#5507](https://github.com/IBM/kui/issues/5507)
- **plugins/plugin-client-common:** restore history navigation behavior in minisplits ([26f49e8](https://github.com/IBM/kui/commit/26f49e8)), closes [#5375](https://github.com/IBM/kui/issues/5375)
- **plugins/plugin-client-common:** reverse-i-search incorrectly changes match as i type ([135d429](https://github.com/IBM/kui/commit/135d429)), closes [#5403](https://github.com/IBM/kui/issues/5403)
- **plugins/plugin-client-common:** SequenceDiagram bars are too narrow ([a0ed13a](https://github.com/IBM/kui/commit/a0ed13a)), closes [#5544](https://github.com/IBM/kui/issues/5544)
- **plugins/plugin-client-common:** SequenceDiagram bars may extend beyond the 100% line ([34d03bc](https://github.com/IBM/kui/commit/34d03bc)), closes [#5465](https://github.com/IBM/kui/issues/5465)
- **plugins/plugin-client-common:** SequenceDiagram can have NaNs in the UI ([ac476a6](https://github.com/IBM/kui/commit/ac476a6)), closes [#5559](https://github.com/IBM/kui/issues/5559)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** SourceRef does not respond to all tab layout changes ([d3e8b32](https://github.com/IBM/kui/commit/d3e8b32)), closes [#5552](https://github.com/IBM/kui/issues/5552)
- **plugins/plugin-client-common:** StatusStripe is blank for second+ tabs ([0002dfb](https://github.com/IBM/kui/commit/0002dfb)), closes [#5546](https://github.com/IBM/kui/issues/5546)
- **plugins/plugin-client-common:** table bottom toolbar buttons lack padding ([79f0abe](https://github.com/IBM/kui/commit/79f0abe)), closes [#5554](https://github.com/IBM/kui/issues/5554)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- improved support for replaying splits ([8039a9d](https://github.com/IBM/kui/commit/8039a9d)), closes [#5535](https://github.com/IBM/kui/issues/5535)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- multiple command history regressions ([cbba96c](https://github.com/IBM/kui/commit/cbba96c)), closes [#5283](https://github.com/IBM/kui/issues/5283)
- notebook replay should scroll to top, and not display welcome message on every tab ([7ade801](https://github.com/IBM/kui/commit/7ade801)), closes [#5515](https://github.com/IBM/kui/issues/5515) [#5516](https://github.com/IBM/kui/issues/5516)
- pty output has different indentation than kui command output ([30b10a3](https://github.com/IBM/kui/commit/30b10a3)), closes [#5542](https://github.com/IBM/kui/issues/5542)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-client-common:** status column can be invisible in split tables ([c352103](https://github.com/IBM/kui/commit/c352103)), closes [#5244](https://github.com/IBM/kui/issues/5244)
- **plugins/plugin-client-common:** switching table from Table to Timeline and back to Table does not work ([c924d67](https://github.com/IBM/kui/commit/c924d67)), closes [#5430](https://github.com/IBM/kui/issues/5430)
- **plugins/plugin-client-common:** tab completion UI does not render on separate line from input ([61b169b](https://github.com/IBM/kui/commit/61b169b)), closes [#5307](https://github.com/IBM/kui/issues/5307)
- **plugins/plugin-client-common:** table screenshots include a gray stripe at the top ([11a9fc3](https://github.com/IBM/kui/commit/11a9fc3)), closes [#5410](https://github.com/IBM/kui/issues/5410)
- **plugins/plugin-client-common:** TableCell view can fail when given empty duration cells ([04251be](https://github.com/IBM/kui/commit/04251be)), closes [#5332](https://github.com/IBM/kui/issues/5332)
- **plugins/plugin-client-common:** threshold for auto-grid is too low ([9cb76ee](https://github.com/IBM/kui/commit/9cb76ee)), closes [#5424](https://github.com/IBM/kui/issues/5424)
- **plugins/plugin-client-common:** Timeline may not render properly ([d66d728](https://github.com/IBM/kui/commit/d66d728)), closes [#5383](https://github.com/IBM/kui/issues/5383)
- **plugins/plugin-client-common:** Timeline should use stdev-based heat map ([5dd7427](https://github.com/IBM/kui/commit/5dd7427)), closes [#5395](https://github.com/IBM/kui/issues/5395)
- **plugins/plugin-client-common:** Timeline tooltip for cold starts has incorrect concurrency count ([bb54cb8](https://github.com/IBM/kui/commit/bb54cb8)), closes [#5390](https://github.com/IBM/kui/issues/5390)
- **plugins/plugin-client-common:** Timeline view renders poorly in MiniSplit ([07cd000](https://github.com/IBM/kui/commit/07cd000)), closes [#5379](https://github.com/IBM/kui/issues/5379)
- **plugins/plugin-client-common:** update SequenceDiagram view to display the duration of each interval ([0cf1fcf](https://github.com/IBM/kui/commit/0cf1fcf)), closes [#5470](https://github.com/IBM/kui/issues/5470)
- **plugins/plugin-client-commong:** show RadioTable selected row in the table body and header breadcrumb ([811c21e](https://github.com/IBM/kui/commit/811c21e)), closes [#5239](https://github.com/IBM/kui/issues/5239)
- **plugins/plugin-ibmcloud:** ibmcloud ce job list does not support name filters ([5daa930](https://github.com/IBM/kui/commit/5daa930)), closes [#5450](https://github.com/IBM/kui/issues/5450)
- Editor component does not respond to tab layout changes ([9756336](https://github.com/IBM/kui/commit/9756336)), closes [#5231](https://github.com/IBM/kui/issues/5231) [#5232](https://github.com/IBM/kui/issues/5232)
- **plugins/plugin-client-common:** borders in top tab stripe are too light ([3908695](https://github.com/IBM/kui/commit/3908695)), closes [#5051](https://github.com/IBM/kui/issues/5051)
- **plugins/plugin-client-common:** close tabs doesn't produce the correct tab content ([6090887](https://github.com/IBM/kui/commit/6090887)), closes [#5220](https://github.com/IBM/kui/issues/5220)
- **plugins/plugin-client-common:** disableTableTitle also disables title of watch panes ([053cfb6](https://github.com/IBM/kui/commit/053cfb6)), closes [#5036](https://github.com/IBM/kui/issues/5036)
- **plugins/plugin-client-common:** don't use fixed maxHeight for Terminal tables ([0e23e22](https://github.com/IBM/kui/commit/0e23e22)), closes [#5206](https://github.com/IBM/kui/issues/5206)
- **plugins/plugin-client-common:** double watch panes may open up ([7fb70f1](https://github.com/IBM/kui/commit/7fb70f1)), closes [#5034](https://github.com/IBM/kui/issues/5034)
- **plugins/plugin-client-common:** Events drilldown from watch table does not always work ([09aee73](https://github.com/IBM/kui/commit/09aee73)), closes [#5204](https://github.com/IBM/kui/issues/5204)
- **plugins/plugin-client-common:** Events footer in minisplit tables lacks horizontal padding ([f22b1f7](https://github.com/IBM/kui/commit/f22b1f7)), closes [#5196](https://github.com/IBM/kui/issues/5196)
- **plugins/plugin-client-common:** Events should also be placed in table footer (not tbody) when sidecar is open or 2-way terminal split ([1391b1d](https://github.com/IBM/kui/commit/1391b1d)), closes [#5198](https://github.com/IBM/kui/issues/5198)
- **plugins/plugin-client-common:** font size issues with LeftNavSidecar ([e17fc15](https://github.com/IBM/kui/commit/e17fc15)), closes [#5048](https://github.com/IBM/kui/issues/5048)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** improve display of tables in side-by-side terminal splits ([5a32255](https://github.com/IBM/kui/commit/5a32255)), closes [#5201](https://github.com/IBM/kui/issues/5201)
- **plugins/plugin-client-common:** improve spacing of Event footer content ([d63a6f1](https://github.com/IBM/kui/commit/d63a6f1)), closes [#5178](https://github.com/IBM/kui/issues/5178)
- **plugins/plugin-client-common:** improve top tab bottom UI ([8ff4151](https://github.com/IBM/kui/commit/8ff4151)), closes [#5056](https://github.com/IBM/kui/issues/5056)
- **plugins/plugin-client-common:** in plain Terminals, tables should not inner scroll ([15fcbba](https://github.com/IBM/kui/commit/15fcbba)), closes [#5221](https://github.com/IBM/kui/issues/5221)
- **plugins/plugin-client-common:** input may not receive focus on tab switch ([7676792](https://github.com/IBM/kui/commit/7676792)), closes [#5102](https://github.com/IBM/kui/issues/5102)
- **plugins/plugin-client-common:** layout regressions from table screenshot PRs ([8004ee3](https://github.com/IBM/kui/commit/8004ee3)), closes [#5159](https://github.com/IBM/kui/issues/5159)
- **plugins/plugin-client-common:** leftover debug printfs in table sorting ([9889b49](https://github.com/IBM/kui/commit/9889b49)), closes [#5030](https://github.com/IBM/kui/issues/5030)
- **plugins/plugin-client-common:** Light tables should use Carbon compact ([2309ec3](https://github.com/IBM/kui/commit/2309ec3)), closes [#5059](https://github.com/IBM/kui/issues/5059)
- **plugins/plugin-client-common:** minor improvements for ls -l output ([1b59c94](https://github.com/IBM/kui/commit/1b59c94)), closes [#5216](https://github.com/IBM/kui/issues/5216)
- **plugins/plugin-client-common:** one-row tables needn't offer column sorting UI ([5184fa1](https://github.com/IBM/kui/commit/5184fa1)), closes [#5050](https://github.com/IBM/kui/issues/5050)
- **plugins/plugin-client-common:** place event footer outside of table scroll region for minisplits ([e4872b2](https://github.com/IBM/kui/commit/e4872b2)), closes [#5179](https://github.com/IBM/kui/issues/5179)
- **plugins/plugin-client-common:** present more than 2 footer lines in watch tables ([3e7a78f](https://github.com/IBM/kui/commit/3e7a78f)), closes [#5213](https://github.com/IBM/kui/issues/5213)
- **plugins/plugin-client-common:** RadioTable screenshots lack box shadow ([b0e0f2e](https://github.com/IBM/kui/commit/b0e0f2e)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** RadioTables can have gratuituous line wrapping ([9c39682](https://github.com/IBM/kui/commit/9c39682)), closes [#5139](https://github.com/IBM/kui/issues/5139)
- **plugins/plugin-client-common:** RadioTables in minisplits inner-scroll away the header row ([5296dcd](https://github.com/IBM/kui/commit/5296dcd)), closes [#5165](https://github.com/IBM/kui/issues/5165)
- **plugins/plugin-client-common:** regression in table width with sidecar open ([5938806](https://github.com/IBM/kui/commit/5938806)), closes [#5194](https://github.com/IBM/kui/issues/5194)
- **plugins/plugin-client-common:** selected row in RadioTables in dark themes has low contrast ([f2c5834](https://github.com/IBM/kui/commit/f2c5834)), closes [#5161](https://github.com/IBM/kui/issues/5161)
- **plugins/plugin-client-common:** sidecar badges may not be flush-right ([5b54665](https://github.com/IBM/kui/commit/5b54665)), closes [#5175](https://github.com/IBM/kui/issues/5175)
- **plugins/plugin-client-common:** Tables should have a max-height and use inner scrolling for overflow ([642ef14](https://github.com/IBM/kui/commit/642ef14)), closes [#5153](https://github.com/IBM/kui/issues/5153)
- **plugins/plugin-client-common:** Tables with identical column names render incorrectly ([161dba2](https://github.com/IBM/kui/commit/161dba2)), closes [#5129](https://github.com/IBM/kui/issues/5129)
- **plugins/plugin-client-common:** Terminal Block -> Screenshot of table does not capture box shadow ([ed812f3](https://github.com/IBM/kui/commit/ed812f3)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** Terminal focus changes unexpectedly ([866451c](https://github.com/IBM/kui/commit/866451c)), closes [#5170](https://github.com/IBM/kui/issues/5170)
- **plugins/plugin-client-common:** two MiniSplits with open sidecar are too short ([9e21ab9](https://github.com/IBM/kui/commit/9e21ab9)), closes [#5171](https://github.com/IBM/kui/issues/5171)
- **plugins/plugin-client-common:** update welcome.json notebook to improve listing of available notebooks ([c6f89f4](https://github.com/IBM/kui/commit/c6f89f4)), closes [#5583](https://github.com/IBM/kui/issues/5583)
- **plugins/plugin-client-common:** watch pane grid cells too large ([225f937](https://github.com/IBM/kui/commit/225f937)), closes [#5070](https://github.com/IBM/kui/issues/5070)
- **plugins/plugin-client-common:** watch tables might not be maximized in minisplits ([63420b2](https://github.com/IBM/kui/commit/63420b2)), closes [#5218](https://github.com/IBM/kui/issues/5218)
- **plugins/plugin-client-common:** WatchPane has incorrect padding ([e74bd7b](https://github.com/IBM/kui/commit/e74bd7b)), closes [#5015](https://github.com/IBM/kui/issues/5015)
- **plugins/plugin-client-common): regression validateDOMNesting(...:** <pre> cannot appear as a descendant of <p> ([1a2cccf](https://github.com/IBM/kui/commit/1a2cccf)), closes [#5900](https://github.com/IBM/kui/issues/5900)
- **plugins/plugin-client-default:** improve debug logging of client properties ([4daba1f](https://github.com/IBM/kui/commit/4daba1f)), closes [#5088](https://github.com/IBM/kui/issues/5088)
- **plugins/plugin-core-support:** sidecar "window" buttons are too large ([33415d2](https://github.com/IBM/kui/commit/33415d2)), closes [#5094](https://github.com/IBM/kui/issues/5094)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- Card component does not render well in dark themes ([d96def0](https://github.com/IBM/kui/commit/d96def0)), closes [#4996](https://github.com/IBM/kui/issues/4996)
- clients should be able to enable watcher auto pinning without enabling splitTerminals ([bcade13](https://github.com/IBM/kui/commit/bcade13)), closes [#5002](https://github.com/IBM/kui/issues/5002)
- Confirm dialog color contrast issues ([da14c25](https://github.com/IBM/kui/commit/da14c25)), closes [#4995](https://github.com/IBM/kui/issues/4995)
- increase contrast in watch pane ([246ecd2](https://github.com/IBM/kui/commit/246ecd2)), closes [#5000](https://github.com/IBM/kui/issues/5000) [#5001](https://github.com/IBM/kui/issues/5001)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- move default loadingDone icon into plugin-client-common ([39994bc](https://github.com/IBM/kui/commit/39994bc)), closes [#5026](https://github.com/IBM/kui/issues/5026)
- move patternfly alignment out of patternfly themes plugin ([6adbfd6](https://github.com/IBM/kui/commit/6adbfd6)), closes [#4988](https://github.com/IBM/kui/issues/4988)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- still see name-related breadcrumbs and short-name header with feature flag sidecarName 'heroText' ([1a8be9f](https://github.com/IBM/kui/commit/1a8be9f)), closes [#5013](https://github.com/IBM/kui/issues/5013)
- **plugins/plugin-client-common:** add error icon for error blocks ([5d9aeea](https://github.com/IBM/kui/commit/5d9aeea)), closes [#4907](https://github.com/IBM/kui/issues/4907)
- **plugins/plugin-client-common:** carbon breadcrumbs may not have proper hover effect ([c8cd2d1](https://github.com/IBM/kui/commit/c8cd2d1)), closes [#4962](https://github.com/IBM/kui/issues/4962)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** clicking the remove button of a repl block results in an error white screen ([49bfbcc](https://github.com/IBM/kui/commit/49bfbcc)), closes [#4855](https://github.com/IBM/kui/issues/4855)
- **plugins/plugin-client-common:** dropdown in sidecar theming and spacing tweaks ([1a48af3](https://github.com/IBM/kui/commit/1a48af3)), closes [#4680](https://github.com/IBM/kui/issues/4680)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** improve Terminal screenshots by adding padding ([a9b7b26](https://github.com/IBM/kui/commit/a9b7b26)), closes [#4981](https://github.com/IBM/kui/issues/4981)
- **plugins/plugin-client-common:** improve visibility of sidecar scrollbars ([827d75a](https://github.com/IBM/kui/commit/827d75a)), closes [#4667](https://github.com/IBM/kui/issues/4667)
- **plugins/plugin-client-common:** in Popup mode, use > rather than / for prompt in bottom input ([1360bed](https://github.com/IBM/kui/commit/1360bed)), closes [#4887](https://github.com/IBM/kui/issues/4887)
- **plugins/plugin-client-common:** increase font size of status stripe ([2fab637](https://github.com/IBM/kui/commit/2fab637)), closes [#4698](https://github.com/IBM/kui/issues/4698)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** input element changes height with i-search and bottomInput ([abf9890](https://github.com/IBM/kui/commit/abf9890)), closes [#4685](https://github.com/IBM/kui/issues/4685)
- **plugins/plugin-client-common:** kubectl edit saves can result in unstyled notification ([5dc658e](https://github.com/IBM/kui/commit/5dc658e)), closes [#4930](https://github.com/IBM/kui/issues/4930)
- **plugins/plugin-client-common:** LeftNav sidecar nav column width inconsistency ([17e403f](https://github.com/IBM/kui/commit/17e403f)), closes [#4688](https://github.com/IBM/kui/issues/4688)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** LeftNavSidecar does not always reflect updated content ([0f2e1e1](https://github.com/IBM/kui/commit/0f2e1e1)), closes [#4727](https://github.com/IBM/kui/issues/4727) [#4732](https://github.com/IBM/kui/issues/4732)
- **plugins/plugin-client-common:** LeftNavSidecar font size and layout issues ([d9914f1](https://github.com/IBM/kui/commit/d9914f1)), closes [#4718](https://github.com/IBM/kui/issues/4718) [#4719](https://github.com/IBM/kui/issues/4719)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** move screenshot button out of status stripe ([0ef900b](https://github.com/IBM/kui/commit/0ef900b)), closes [#4556](https://github.com/IBM/kui/issues/4556)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** poor alignment of sidecar toolbar elements ([2307a46](https://github.com/IBM/kui/commit/2307a46)), closes [#4970](https://github.com/IBM/kui/issues/4970)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** refine Loading component ([7a07ad3](https://github.com/IBM/kui/commit/7a07ad3)), closes [#4702](https://github.com/IBM/kui/issues/4702)
- **plugins/plugin-client-common:** regression: non-empty repl output has 'ok' at the end ([103a0f9](https://github.com/IBM/kui/commit/103a0f9)), closes [#4924](https://github.com/IBM/kui/issues/4924)
- **plugins/plugin-client-common:** reverse-i-search does not properly report no matches ([c16dad3](https://github.com/IBM/kui/commit/c16dad3)), closes [#4943](https://github.com/IBM/kui/issues/4943)
- **plugins/plugin-client-common:** Screenshot modal never goes away ([bbd1c98](https://github.com/IBM/kui/commit/bbd1c98)), closes [#4979](https://github.com/IBM/kui/issues/4979)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- **plugins/plugin-client-common:** session init done message messes up Terminal scrolling ([7e80ac1](https://github.com/IBM/kui/commit/7e80ac1)), closes [#4683](https://github.com/IBM/kui/issues/4683)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- **plugins/plugin-client-common:** spurious warning in the console re: Tag ([93982de](https://github.com/IBM/kui/commit/93982de)), closes [#4959](https://github.com/IBM/kui/issues/4959)
- **plugins/plugin-client-common:** status cells of live tables do not always blink ([c94b05e](https://github.com/IBM/kui/commit/c94b05e)), closes [#4903](https://github.com/IBM/kui/issues/4903)
- **plugins/plugin-client-common:** Terminal screenshot odd w.r.t. auto-focus ([4b1c7d8](https://github.com/IBM/kui/commit/4b1c7d8)), closes [#4739](https://github.com/IBM/kui/issues/4739)
- **plugins/plugin-client-common:** top tab buttons should be owned by the top tab stripe ([9a45c43](https://github.com/IBM/kui/commit/9a45c43)), closes [#4690](https://github.com/IBM/kui/issues/4690)
- **plugins/plugin-client-common:** TopNavSidecar tabs easily overflow with narrower windows ([a555cd4](https://github.com/IBM/kui/commit/a555cd4)), closes [#4735](https://github.com/IBM/kui/issues/4735)
- **plugins/plugin-client-common:** UpdateNotification widget has invisible background color ([c0c1d82](https://github.com/IBM/kui/commit/c0c1d82)), closes [#4968](https://github.com/IBM/kui/issues/4968)
- **plugins/plugin-patternfly-themes:** update theme alignment to patternfly v4 ([3784b96](https://github.com/IBM/kui/commit/3784b96)), closes [#4948](https://github.com/IBM/kui/issues/4948)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- erratic scroll region behavior ([be0e2a0](https://github.com/IBM/kui/commit/be0e2a0)), closes [#4898](https://github.com/IBM/kui/issues/4898)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- page-content p should not use text-align: justify ([2646f4b](https://github.com/IBM/kui/commit/2646f4b)), closes [#4908](https://github.com/IBM/kui/issues/4908)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar container selection kebab has different color with its menu ([639617a](https://github.com/IBM/kui/commit/639617a)), closes [#4676](https://github.com/IBM/kui/issues/4676)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- switching splits does not participate in tab state ([6eb8db4](https://github.com/IBM/kui/commit/6eb8db4)), closes [#5272](https://github.com/IBM/kui/issues/5272)
- upgrade @patternfly/react-core to latest ([0331533](https://github.com/IBM/kui/commit/0331533)), closes [#4937](https://github.com/IBM/kui/issues/4937)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** sidecar toolbar text incorrectly aligned ([ddd7460](https://github.com/IBM/kui/commit/ddd7460)), closes [#4659](https://github.com/IBM/kui/issues/4659)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** PatternFly DropDown rendering glitches ([8efedd8](https://github.com/IBM/kui/commit/8efedd8)), closes [#4649](https://github.com/IBM/kui/issues/4649) [#4651](https://github.com/IBM/kui/issues/4651)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- **plugins/plugin-client-common:** reverse the dependency of Card and DropDown ([00b8ecf](https://github.com/IBM/kui/commit/00b8ecf)), closes [#4641](https://github.com/IBM/kui/issues/4641)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- **plugins/plugin-client-common:** Screenshot button should not be offered inBrowser ([d1c2cfb](https://github.com/IBM/kui/commit/d1c2cfb)), closes [#4636](https://github.com/IBM/kui/issues/4636)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** split button errors are not reported to the user ([fc4e2a2](https://github.com/IBM/kui/commit/fc4e2a2)), closes [#4876](https://github.com/IBM/kui/issues/4876)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- **plugins/plugin-client-common:** table container should only be width:100% for table not display-as-grid ([8f327cd](https://github.com/IBM/kui/commit/8f327cd)), closes [#4871](https://github.com/IBM/kui/issues/4871)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane has non-zero height even when empty ([67a7070](https://github.com/IBM/kui/commit/67a7070)), closes [#4629](https://github.com/IBM/kui/issues/4629)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- **plugins/plugn-client-common:** TopTabStripe stays blue after command execution completes ([68f5841](https://github.com/IBM/kui/commit/68f5841)), closes [#4883](https://github.com/IBM/kui/issues/4883)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- sidecar back/forward should be ordered by visitation rather than insertion ([fba613a](https://github.com/IBM/kui/commit/fba613a)), closes [#4746](https://github.com/IBM/kui/issues/4746)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- split screen terminals sometimes incorrect handle exit ([d63cde7](https://github.com/IBM/kui/commit/d63cde7)), closes [#4860](https://github.com/IBM/kui/issues/4860)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- TopNavSidecar doesn't return to the previous selected Tab when back button is hit ([32acee5](https://github.com/IBM/kui/commit/32acee5)), closes [#4745](https://github.com/IBM/kui/issues/4745)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add a command to return the Card Component in Terminal ([d8d13ab](https://github.com/IBM/kui/commit/d8d13ab)), closes [#4973](https://github.com/IBM/kui/issues/4973)
- execute the command in url query when the browser app is loaded ([b0b95cf](https://github.com/IBM/kui/commit/b0b95cf)), closes [#5879](https://github.com/IBM/kui/issues/5879)
- Feature: improve support for parallelization across VFS operations ([e05d7e0](https://github.com/IBM/kui/commit/e05d7e0)), closes [#5831](https://github.com/IBM/kui/issues/5831)
- inline sidecar ([2c3afeb](https://github.com/IBM/kui/commit/2c3afeb)), closes [#6007](https://github.com/IBM/kui/issues/6007)
- introduce reexec for rerunning commands ([fe80525](https://github.com/IBM/kui/commit/fe80525)), closes [#6026](https://github.com/IBM/kui/issues/6026)
- Make a notebook about making notebooks ([0d67947](https://github.com/IBM/kui/commit/0d67947)), closes [#6040](https://github.com/IBM/kui/issues/6040)
- **plugins/plugin-client-common:** allow clients to specify initial tab title ([e8e365f](https://github.com/IBM/kui/commit/e8e365f)), closes [#5539](https://github.com/IBM/kui/issues/5539)
- **plugins/plugin-client-common:** allow users to insert command before a repl block ([e935092](https://github.com/IBM/kui/commit/e935092)), closes [#5576](https://github.com/IBM/kui/issues/5576)
- **plugins/plugin-client-common:** allow users to reorder blocks by MoveUp and MoveDown buttons ([f7f6918](https://github.com/IBM/kui/commit/f7f6918)), closes [#5589](https://github.com/IBM/kui/issues/5589)
- **plugins/plugin-client-common:** block-level copy/paste ([a72cf8d](https://github.com/IBM/kui/commit/a72cf8d)), closes [#5752](https://github.com/IBM/kui/issues/5752)
- **plugins/plugin-client-common:** edit a commentary response using SimpleEditor ([6d828c1](https://github.com/IBM/kui/commit/6d828c1)), closes [#5664](https://github.com/IBM/kui/issues/5664)
- **plugins/plugin-client-common:** error messages should format as markdown ([63ca4a7](https://github.com/IBM/kui/commit/63ca4a7)), closes [#5943](https://github.com/IBM/kui/issues/5943)
- **plugins/plugin-client-common:** improve action button UI for output-only blocks ([9cb99ad](https://github.com/IBM/kui/commit/9cb99ad)), closes [#5660](https://github.com/IBM/kui/issues/5660)
- **plugins/plugin-client-common:** Improve notebook-style ui ([791160e](https://github.com/IBM/kui/commit/791160e)), closes [#5472](https://github.com/IBM/kui/issues/5472)
- **plugins/plugin-client-common:** improve presentation of sidecar-destined responses ([02b91e3](https://github.com/IBM/kui/commit/02b91e3)), closes [#5463](https://github.com/IBM/kui/issues/5463)
- **plugins/plugin-client-common:** SourceRef should be default-expanded in Notebooks? ([8ee26e8](https://github.com/IBM/kui/commit/8ee26e8)), closes [#5866](https://github.com/IBM/kui/issues/5866)
- **plugins/plugin-client-common:** split command should allow user to specify splice index ([75857e9](https://github.com/IBM/kui/commit/75857e9)), closes [#5746](https://github.com/IBM/kui/issues/5746)
- add capability to click to edit/rerun a command ([4296933](https://github.com/IBM/kui/commit/4296933)), closes [#5654](https://github.com/IBM/kui/issues/5654)
- save/restore pty command output ([2c291a9](https://github.com/IBM/kui/commit/2c291a9)), closes [#5314](https://github.com/IBM/kui/issues/5314)
- **plugins/plugin-client-common:** User should be able to tab navigate through blocks ([54d3759](https://github.com/IBM/kui/commit/54d3759)), closes [#5717](https://github.com/IBM/kui/issues/5717)
- ability to register an onClose handler when opening a tab ([58a36c3](https://github.com/IBM/kui/commit/58a36c3)), closes [#5670](https://github.com/IBM/kui/issues/5670)
- **plugins/plugin-client-common:** Improve Commentary editing UI by adding real Done button ([1f544b5](https://github.com/IBM/kui/commit/1f544b5)), closes [#5667](https://github.com/IBM/kui/issues/5667)
- **plugins/plugin-client-common:** Output-only blocks should offer a Copy action button ([da4f85d](https://github.com/IBM/kui/commit/da4f85d)), closes [#5646](https://github.com/IBM/kui/issues/5646)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add alert command to display Alert component in Terminal ([495d3bb](https://github.com/IBM/kui/commit/495d3bb)), closes [#4957](https://github.com/IBM/kui/issues/4957)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add CommentaryReponse to snapshot/replay the response of commentary command ([7d13a93](https://github.com/IBM/kui/commit/7d13a93)), closes [#5439](https://github.com/IBM/kui/issues/5439)
- add sequence diagram to table with timestamp columns ([e9028ee](https://github.com/IBM/kui/commit/e9028ee)), closes [#5336](https://github.com/IBM/kui/issues/5336)
- allow clients to modify the session lifecycle UI by providing custom strings ([3c78fd3](https://github.com/IBM/kui/commit/3c78fd3)), closes [#5019](https://github.com/IBM/kui/issues/5019)
- allow command registrations to express their experimental nature ([eb9f147](https://github.com/IBM/kui/commit/eb9f147)), closes [#5282](https://github.com/IBM/kui/issues/5282)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow table model to specify a gridable column index ([f4ba8e6](https://github.com/IBM/kui/commit/f4ba8e6)), closes [#5278](https://github.com/IBM/kui/issues/5278)
- auto gridify large table ([bd22fa2](https://github.com/IBM/kui/commit/bd22fa2)), closes [#5305](https://github.com/IBM/kui/issues/5305)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- command history should be tab-specific ([1b987e0](https://github.com/IBM/kui/commit/1b987e0)), closes [#1299](https://github.com/IBM/kui/issues/1299)
- commentary command to add comments to REPL ([c304fd3](https://github.com/IBM/kui/commit/c304fd3)), closes [#5428](https://github.com/IBM/kui/issues/5428)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- improve repl-block selection ([305b36f](https://github.com/IBM/kui/commit/305b36f)), closes [#5587](https://github.com/IBM/kui/issues/5587)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- initial/minimal snapshot/replay support ([bb7ae0f](https://github.com/IBM/kui/commit/bb7ae0f)), closes [#5280](https://github.com/IBM/kui/issues/5280)
- inverse splits ([38d2895](https://github.com/IBM/kui/commit/38d2895)), closes [#5537](https://github.com/IBM/kui/issues/5537)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- pass command line comments to commentary command ([a020db5](https://github.com/IBM/kui/commit/a020db5)), closes [#5459](https://github.com/IBM/kui/issues/5459)
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- separate out themes into a new settings Notebook ([5180759](https://github.com/IBM/kui/commit/5180759)), closes [#5605](https://github.com/IBM/kui/issues/5605)
- snapshot freshening ([d5c8991](https://github.com/IBM/kui/commit/d5c8991)), closes [#5522](https://github.com/IBM/kui/issues/5522)
- support replaying in new tab ([04a2c67](https://github.com/IBM/kui/commit/04a2c67)), closes [#5509](https://github.com/IBM/kui/issues/5509)
- Update default loadingDone to use Card component ([e1b4c61](https://github.com/IBM/kui/commit/e1b4c61)), closes [#4986](https://github.com/IBM/kui/issues/4986)
- update ls to allow for presenting content from more limited VFS's such as tutorials ([a1ff1a4](https://github.com/IBM/kui/commit/a1ff1a4)), closes [#5497](https://github.com/IBM/kui/issues/5497)
- **plugins/plugin-client-common:** add support for Tags in StatusStripe ([d112c86](https://github.com/IBM/kui/commit/d112c86)), closes [#4951](https://github.com/IBM/kui/issues/4951)
- **plugins/plugin-client-common:** allow easier rerunning of command from terminal ([c5384e0](https://github.com/IBM/kui/commit/c5384e0)), closes [#4570](https://github.com/IBM/kui/issues/4570)
- **plugins/plugin-client-common:** History navigation in minisplits should navigate In/Out pairs ([93eb2a4](https://github.com/IBM/kui/commit/93eb2a4)), closes [#5270](https://github.com/IBM/kui/issues/5270)
- **plugins/plugin-client-common:** improve accessibility of "red" error grid cells ([8921292](https://github.com/IBM/kui/commit/8921292)), closes [#4938](https://github.com/IBM/kui/issues/4938)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-client-common:** show table row count in card header ([deadcfa](https://github.com/IBM/kui/commit/deadcfa)), closes [#5137](https://github.com/IBM/kui/issues/5137)
- **plugins/plugin-client-common:** support client option for hero names in sidecar ([d4f6984](https://github.com/IBM/kui/commit/d4f6984)), closes [#4909](https://github.com/IBM/kui/issues/4909)
- **plugins/plugin-client-common:** use Cards to wrap kube tables and grids ([6698013](https://github.com/IBM/kui/commit/6698013)), closes [#5032](https://github.com/IBM/kui/issues/5032)
- **plugins/plugin-client-common:** use inner scrolling for RadioTables in main Terminals ([952f72a](https://github.com/IBM/kui/commit/952f72a)), closes [#5133](https://github.com/IBM/kui/issues/5133)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- <Kui> should allow for custom Input elements ([193a108](https://github.com/IBM/kui/commit/193a108)), closes [#4672](https://github.com/IBM/kui/issues/4672)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for <Kui noPromptContext/> and <Kui prompt=">"/> ([a92063d](https://github.com/IBM/kui/commit/a92063d)), closes [#4653](https://github.com/IBM/kui/issues/4653)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow <Kui/> users to provide custom views for session init ([1f35894](https://github.com/IBM/kui/commit/1f35894)), closes [#4596](https://github.com/IBM/kui/issues/4596)
- allow subclasses of InputProvider to specify their own State ([c3fc88e](https://github.com/IBM/kui/commit/c3fc88e)), closes [#4756](https://github.com/IBM/kui/issues/4756)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- Dropdown spi and use in Terminal Block ([327917b](https://github.com/IBM/kui/commit/327917b)), closes [#4589](https://github.com/IBM/kui/issues/4589) [#4556](https://github.com/IBM/kui/issues/4556)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- RadioTable and port of the themes table to use it ([79a3e8e](https://github.com/IBM/kui/commit/79a3e8e)), closes [#4507](https://github.com/IBM/kui/issues/4507)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- shift Block UI to use a Notebook style of presentation ([dc0ee4b](https://github.com/IBM/kui/commit/dc0ee4b)), closes [#5258](https://github.com/IBM/kui/issues/5258)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- Timeline view for kubernetes Jobs ([b623e4e](https://github.com/IBM/kui/commit/b623e4e)), closes [#5370](https://github.com/IBM/kui/issues/5370)
- update checker ([a7908d2](https://github.com/IBM/kui/commit/a7908d2)), closes [#4537](https://github.com/IBM/kui/issues/4537)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [9.0.0](https://github.com/IBM/kui/compare/v4.5.0...v9.0.0) (2020-10-08)

### Bug Fixes

- **plugin-client-common:** show the last input block in minisplit ([7997ef0](https://github.com/IBM/kui/commit/7997ef0)), closes [#5756](https://github.com/IBM/kui/issues/5756)
- **plugins/plugin-client-common:** "Drilled down to..." text is not aligned with the Input area ([fd139d2](https://github.com/IBM/kui/commit/fd139d2)), closes [#5854](https://github.com/IBM/kui/issues/5854)
- **plugins/plugin-client-common:** Action button hover hysteresis/delay effect not working ([fac75dc](https://github.com/IBM/kui/commit/fac75dc)), closes [#5806](https://github.com/IBM/kui/issues/5806)
- **plugins/plugin-client-common:** clicking on table or radio table may cause block to disappear ([1f2d489](https://github.com/IBM/kui/commit/1f2d489)), closes [#5783](https://github.com/IBM/kui/issues/5783)
- **plugins/plugin-client-common:** clicking the split button may cause the current processing block to disappear ([aa2b40c](https://github.com/IBM/kui/commit/aa2b40c)), closes [#5703](https://github.com/IBM/kui/issues/5703)
- **plugins/plugin-client-common:** ClipboardTransfer emits errors when pasting non-json text ([6ff85c4](https://github.com/IBM/kui/commit/6ff85c4)), closes [#5836](https://github.com/IBM/kui/issues/5836)
- **plugins/plugin-client-common:** CodeSnippet component renders with zero contrast in dark themes ([10e40a9](https://github.com/IBM/kui/commit/10e40a9)), closes [#5886](https://github.com/IBM/kui/issues/5886)
- **plugins/plugin-client-common:** colored squares in status column of tables have odd alignment ([3e78540](https://github.com/IBM/kui/commit/3e78540)), closes [#5766](https://github.com/IBM/kui/issues/5766)
- **plugins/plugin-client-common:** Commentary editor is 5px tall when presented in mini split ([53074d1](https://github.com/IBM/kui/commit/53074d1)), closes [#5744](https://github.com/IBM/kui/issues/5744)
- **plugins/plugin-client-common:** Commentary is always full width ([1920fb9](https://github.com/IBM/kui/commit/1920fb9)), closes [#5705](https://github.com/IBM/kui/issues/5705)
- **plugins/plugin-client-common:** Commentary markdown does not support kuiexec ([4663389](https://github.com/IBM/kui/commit/4663389)), closes [#5911](https://github.com/IBM/kui/issues/5911)
- **plugins/plugin-client-common:** creating a split with a 3-way split configuration results in radical shuffling ([9452b5a](https://github.com/IBM/kui/commit/9452b5a)), closes [#5794](https://github.com/IBM/kui/issues/5794)
- **plugins/plugin-client-common:** deleting and re-creating a split results double commands ([dde6eaa](https://github.com/IBM/kui/commit/dde6eaa)), closes [#5876](https://github.com/IBM/kui/issues/5876)
- **plugins/plugin-client-common:** disable Timeline option for Tables ([e88ebb3](https://github.com/IBM/kui/commit/e88ebb3)), closes [#5864](https://github.com/IBM/kui/issues/5864)
- **plugins/plugin-client-common:** Do not focus Block when user expands SourceRef ([6642514](https://github.com/IBM/kui/commit/6642514)), closes [#5711](https://github.com/IBM/kui/issues/5711)
- **plugins/plugin-client-common:** don't decorate code elements in top tab ([531e8b8](https://github.com/IBM/kui/commit/531e8b8)), closes [#5778](https://github.com/IBM/kui/issues/5778)
- **plugins/plugin-client-common:** don't offer Grid option for 1-row tables ([a2a6f8d](https://github.com/IBM/kui/commit/a2a6f8d)), closes [#5474](https://github.com/IBM/kui/issues/5474)
- **plugins/plugin-client-common:** don't show `isTabLayoutModificationResponse` and PresentedElseWhere response in MiniSplit ([a16767a](https://github.com/IBM/kui/commit/a16767a)), closes [#5690](https://github.com/IBM/kui/issues/5690)
- **plugins/plugin-client-common:** editing commentary gives a one-line monaco ([5f14268](https://github.com/IBM/kui/commit/5f14268)), closes [#5874](https://github.com/IBM/kui/issues/5874)
- **plugins/plugin-client-common:** empty blocks have excessive height ([12c39b0](https://github.com/IBM/kui/commit/12c39b0)), closes [#5707](https://github.com/IBM/kui/issues/5707)
- **plugins/plugin-client-common:** focus a block upon moving or pasting it ([43c3d9a](https://github.com/IBM/kui/commit/43c3d9a)), closes [#5751](https://github.com/IBM/kui/issues/5751)
- **plugins/plugin-client-common:** improve look of `code` snippets in Commentary ([493e004](https://github.com/IBM/kui/commit/493e004)), closes [#5768](https://github.com/IBM/kui/issues/5768)
- **plugins/plugin-client-common:** increase contrast of unfocused left-stripes for blocks ([ab21295](https://github.com/IBM/kui/commit/ab21295)), closes [#5754](https://github.com/IBM/kui/issues/5754)
- **plugins/plugin-client-common:** Input timestamp should also hide when block is focused ([6e1ca6d](https://github.com/IBM/kui/commit/6e1ca6d)), closes [#5809](https://github.com/IBM/kui/issues/5809)
- **plugins/plugin-client-common:** isReplay bit on Blocks is not set for snapshots ([c6d1633](https://github.com/IBM/kui/commit/c6d1633)), closes [#5868](https://github.com/IBM/kui/issues/5868)
- **plugins/plugin-client-common:** linux can show unneeded scrollbars in tables ([4d49a23](https://github.com/IBM/kui/commit/4d49a23)), closes [#5884](https://github.com/IBM/kui/issues/5884)
- **plugins/plugin-client-common:** markdown code has incorrect color in a split with inverse color ([c8c10af](https://github.com/IBM/kui/commit/c8c10af)), closes [#5902](https://github.com/IBM/kui/issues/5902)
- **plugins/plugin-client-common:** markdown inline code in table cells shows with scrollbars on linux and windows ([1ff88b9](https://github.com/IBM/kui/commit/1ff88b9)), closes [#5890](https://github.com/IBM/kui/issues/5890)
- **plugins/plugin-client-common:** markdown with <a> inside <h1> renders with odd font size ([b5e3007](https://github.com/IBM/kui/commit/b5e3007)), closes [#5724](https://github.com/IBM/kui/issues/5724)
- **plugins/plugin-client-common:** monaco highlight color used by SourceRef has low contrast ([385f35e](https://github.com/IBM/kui/commit/385f35e)), closes [#5713](https://github.com/IBM/kui/issues/5713)
- **plugins/plugin-client-common:** presented elsewhere text is not vertically centered in block ([766d355](https://github.com/IBM/kui/commit/766d355)), closes [#5760](https://github.com/IBM/kui/issues/5760)
- **plugins/plugin-client-common:** RadioTable should scroll the selected row into view on render ([6eb45db](https://github.com/IBM/kui/commit/6eb45db)), closes [#5781](https://github.com/IBM/kui/issues/5781)
- **plugins/plugin-client-common:** re-snapshoting a notebook can fail ([4caff9c](https://github.com/IBM/kui/commit/4caff9c)), closes [#5736](https://github.com/IBM/kui/issues/5736)
- **plugins/plugin-client-common:** remove clicks from NotebookImpl ([45f0be5](https://github.com/IBM/kui/commit/45f0be5)), closes [#5856](https://github.com/IBM/kui/issues/5856)
- **plugins/plugin-client-common:** saving a snapshot can fail with "cannot read property uuid of undefined" ([85fe1f3](https://github.com/IBM/kui/commit/85fe1f3)), closes [#5913](https://github.com/IBM/kui/issues/5913)
- **plugins/plugin-client-common:** selecting text in prior Input causes selection to be lost and Input to enter edit mode ([4d977d2](https://github.com/IBM/kui/commit/4d977d2)), closes [#5792](https://github.com/IBM/kui/issues/5792)
- **plugins/plugin-client-common:** some small tweaks to Commentary headers would help ([b012f8d](https://github.com/IBM/kui/commit/b012f8d)), closes [#5893](https://github.com/IBM/kui/issues/5893)
- **plugins/plugin-client-common:** SourceRef viewer should hide liner numbers but show folding ([5f74a46](https://github.com/IBM/kui/commit/5f74a46)), closes [#5719](https://github.com/IBM/kui/issues/5719)
- **plugins/plugin-client-common:** status stripe "blue" color probably needs to be toned done ([137442f](https://github.com/IBM/kui/commit/137442f)), closes [#5772](https://github.com/IBM/kui/issues/5772)
- **plugins/plugin-client-common:** tab switching can be slow on windows ([09f9b7d](https://github.com/IBM/kui/commit/09f9b7d)), closes [#5907](https://github.com/IBM/kui/issues/5907)
- **plugins/plugin-client-common:** table cells with no onclick handler still issue a kui command ([4d8bf37](https://github.com/IBM/kui/commit/4d8bf37)), closes [#5721](https://github.com/IBM/kui/issues/5721)
- **plugins/plugin-client-common:** table is misaligned with command input ([50dc430](https://github.com/IBM/kui/commit/50dc430)), closes [#5734](https://github.com/IBM/kui/issues/5734)
- **plugins/plugin-client-common:** there is still too much whitespace after no-response commands ([268f159](https://github.com/IBM/kui/commit/268f159)), closes [#5742](https://github.com/IBM/kui/issues/5742)
- **plugins/plugin-client-common:** update welcome.json to describe kui, not just notebooks ([96330c4](https://github.com/IBM/kui/commit/96330c4)), closes [#5878](https://github.com/IBM/kui/issues/5878)
- **plugins/plugin-client-common:** welcome.json could use some wordsmithing ([e373ab4](https://github.com/IBM/kui/commit/e373ab4)), closes [#5895](https://github.com/IBM/kui/issues/5895)
- **plugins/plugin-client-common): regression validateDOMNesting(...:** <pre> cannot appear as a descendant of <p> ([1a2cccf](https://github.com/IBM/kui/commit/1a2cccf)), closes [#5900](https://github.com/IBM/kui/issues/5900)
- Notebook title "Kui Setting" should be "Kui Settings" ([b14b130](https://github.com/IBM/kui/commit/b14b130)), closes [#5870](https://github.com/IBM/kui/issues/5870)
- re-saving a notebook via File/Save application menu does not preserve notebook title ([7fb8b43](https://github.com/IBM/kui/commit/7fb8b43)), closes [#5777](https://github.com/IBM/kui/issues/5777)
- **plugin-client-common:** RadioTable onSelect changes do not always result in status stripe updates ([3549b7a](https://github.com/IBM/kui/commit/3549b7a)), closes [#5644](https://github.com/IBM/kui/issues/5644)
- **plugins/plugin-client-common:** Whem moving blocks, the moved block is not longer focused after the move ([fc13198](https://github.com/IBM/kui/commit/fc13198)), closes [#5612](https://github.com/IBM/kui/issues/5612)
- **plugins/plugin-client-common:** a few small refinements to "editing" UI for Inputs ([001236a](https://github.com/IBM/kui/commit/001236a)), closes [#5656](https://github.com/IBM/kui/issues/5656) [#5658](https://github.com/IBM/kui/issues/5658)
- **plugins/plugin-client-common:** avoid inner scrolling in Commentary cards ([d3ea558](https://github.com/IBM/kui/commit/d3ea558)), closes [#5517](https://github.com/IBM/kui/issues/5517)
- **plugins/plugin-client-common:** Block Action buttons have poor contrast in dark themes ([f52511e](https://github.com/IBM/kui/commit/f52511e)), closes [#5590](https://github.com/IBM/kui/issues/5590)
- **plugins/plugin-client-common:** Block Actions should be top-aligned in output-only blocks ([55ce899](https://github.com/IBM/kui/commit/55ce899)), closes [#5595](https://github.com/IBM/kui/issues/5595)
- **plugins/plugin-client-common:** block left-border is not centered with In[1] text in minisplits ([4df61cc](https://github.com/IBM/kui/commit/4df61cc)), closes [#5585](https://github.com/IBM/kui/issues/5585)
- **plugins/plugin-client-common:** Commentary blocks are not focusable in minisplits ([1286b0d](https://github.com/IBM/kui/commit/1286b0d)), closes [#5594](https://github.com/IBM/kui/issues/5594)
- **plugins/plugin-client-common:** Commentary editor can easily overflow when editing in minisplit ([eb14074](https://github.com/IBM/kui/commit/eb14074)), closes [#5675](https://github.com/IBM/kui/issues/5675)
- **plugins/plugin-client-common:** Commentary editor should be full width always ([e0a164a](https://github.com/IBM/kui/commit/e0a164a)), closes [#5688](https://github.com/IBM/kui/issues/5688)
- **plugins/plugin-client-common:** Commentary paragraphs have no separation ([6b77a13](https://github.com/IBM/kui/commit/6b77a13)), closes [#5531](https://github.com/IBM/kui/issues/5531)
- **plugins/plugin-client-common:** custom tab titles may have monospace font ([b34b5a4](https://github.com/IBM/kui/commit/b34b5a4)), closes [#5527](https://github.com/IBM/kui/issues/5527)
- **plugins/plugin-client-common:** don't show "2 rows" table header for short tables ([2350115](https://github.com/IBM/kui/commit/2350115)), closes [#5581](https://github.com/IBM/kui/issues/5581)
- **plugins/plugin-client-common:** Editing Commentary should require double click ([efaded3](https://github.com/IBM/kui/commit/efaded3)), closes [#5686](https://github.com/IBM/kui/issues/5686)
- **plugins/plugin-client-common:** h2 in Notebooks have double underline ([40a4bd1](https://github.com/IBM/kui/commit/40a4bd1)), closes [#5574](https://github.com/IBM/kui/issues/5574)
- **plugins/plugin-client-common:** improve layout of In[1] with sidecar open ([263d59a](https://github.com/IBM/kui/commit/263d59a)), closes [#5482](https://github.com/IBM/kui/issues/5482)
- **plugins/plugin-client-common:** improve rendering of output only blocks ([664a8da](https://github.com/IBM/kui/commit/664a8da)), closes [#5467](https://github.com/IBM/kui/issues/5467)
- **plugins/plugin-client-common:** improved focus behavior of terminals ([f5a3dd0](https://github.com/IBM/kui/commit/f5a3dd0)), closes [#5615](https://github.com/IBM/kui/issues/5615)
- **plugins/plugin-client-common:** input probably needs to word-wrap while in minisplits ([cde272d](https://github.com/IBM/kui/commit/cde272d)), closes [#5696](https://github.com/IBM/kui/issues/5696)
- **plugins/plugin-client-common:** input spinner is not visible in minisplits ([76eec59](https://github.com/IBM/kui/commit/76eec59)), closes [#5684](https://github.com/IBM/kui/issues/5684)
- **plugins/plugin-client-common:** Lots of little layout issues, e.g. SimpleEditor is not fully width in minisplits ([5a9a1c6](https://github.com/IBM/kui/commit/5a9a1c6)), closes [#5679](https://github.com/IBM/kui/issues/5679) [#5680](https://github.com/IBM/kui/issues/5680)
- **plugins/plugin-client-common:** minor spacing improvements for Commentary and Notebooks ([c473181](https://github.com/IBM/kui/commit/c473181)), closes [#5503](https://github.com/IBM/kui/issues/5503)
- **plugins/plugin-client-common:** never show "ok" ([d1b337a](https://github.com/IBM/kui/commit/d1b337a)), closes [#5697](https://github.com/IBM/kui/issues/5697)
- **plugins/plugin-client-common:** on switching tabs, active prompt isn't always focused ([5b28dd2](https://github.com/IBM/kui/commit/5b28dd2)), closes [#5637](https://github.com/IBM/kui/issues/5637)
- **plugins/plugin-client-common:** Output-only blocks probably don't need a re-execute button ([251a81c](https://github.com/IBM/kui/commit/251a81c)), closes [#5662](https://github.com/IBM/kui/issues/5662)
- **plugins/plugin-client-common:** regression in columnar alignment of Input and Output ([cf1a836](https://github.com/IBM/kui/commit/cf1a836)), closes [#5507](https://github.com/IBM/kui/issues/5507)
- **plugins/plugin-client-common:** SequenceDiagram bars are too narrow ([a0ed13a](https://github.com/IBM/kui/commit/a0ed13a)), closes [#5544](https://github.com/IBM/kui/issues/5544)
- **plugins/plugin-client-common:** StatusStripe widgets can emit react error when switching to notebook tab ([485fcdf](https://github.com/IBM/kui/commit/485fcdf)), closes [#5639](https://github.com/IBM/kui/issues/5639)
- **plugins/plugin-client-common:** when replaying notebooks, tab should be scrolled to top ([6567412](https://github.com/IBM/kui/commit/6567412)), closes [#5860](https://github.com/IBM/kui/issues/5860)
- **plugins/plugin-client-common:** while editing Commentary, adding ``` causes a bad error ([097b1b0](https://github.com/IBM/kui/commit/097b1b0)), closes [#5682](https://github.com/IBM/kui/issues/5682)
- **plugins/plugin-kubectl:** kubectl delete ns m1 m2 m3 m4 results in a one-row table ([97a33a4](https://github.com/IBM/kui/commit/97a33a4)), closes [#5694](https://github.com/IBM/kui/issues/5694)
- "created split" message should disappear when corresponding split is closed ([f8486f8](https://github.com/IBM/kui/commit/f8486f8)), closes [#5629](https://github.com/IBM/kui/issues/5629)
- blocks can still disappear if table row is clicked while the enclosing block is focused ([2173af1](https://github.com/IBM/kui/commit/2173af1)), closes [#5814](https://github.com/IBM/kui/issues/5814)
- don't show the `open` command for clicking files in `ls` table ([03ef269](https://github.com/IBM/kui/commit/03ef269)), closes [#5748](https://github.com/IBM/kui/issues/5748)
- for replayed notebooks, don’t show timestamp ([951abc5](https://github.com/IBM/kui/commit/951abc5)), closes [#5763](https://github.com/IBM/kui/issues/5763)
- improve the discoverability of repl-block action buttons ([470da34](https://github.com/IBM/kui/commit/470da34)), closes [#5604](https://github.com/IBM/kui/issues/5604)
- improve the replayability of terminal splitting ([67811cd](https://github.com/IBM/kui/commit/67811cd)), closes [#5564](https://github.com/IBM/kui/issues/5564)
- improved support for replaying splits ([8039a9d](https://github.com/IBM/kui/commit/8039a9d)), closes [#5535](https://github.com/IBM/kui/issues/5535)
- JS console may contain xtermjs error messages when sidecar is minimized ([a568528](https://github.com/IBM/kui/commit/a568528)), closes [#5454](https://github.com/IBM/kui/issues/5454)
- ls comand is not snapshotable ([f04ca78](https://github.com/IBM/kui/commit/f04ca78)), closes [#5241](https://github.com/IBM/kui/issues/5241)
- new tab command can hang if title is provided ([a6c25c6](https://github.com/IBM/kui/commit/a6c25c6)), closes [#5624](https://github.com/IBM/kui/issues/5624)
- notebook replay should scroll to top, and not display welcome message on every tab ([7ade801](https://github.com/IBM/kui/commit/7ade801)), closes [#5515](https://github.com/IBM/kui/issues/5515) [#5516](https://github.com/IBM/kui/issues/5516)
- output only Actions should also render on hover ([cdbd105](https://github.com/IBM/kui/commit/cdbd105)), closes [#5652](https://github.com/IBM/kui/issues/5652)
- pty output has different indentation than kui command output ([30b10a3](https://github.com/IBM/kui/commit/30b10a3)), closes [#5542](https://github.com/IBM/kui/issues/5542)
- RadioTables are not replayable ([d0dd00e](https://github.com/IBM/kui/commit/d0dd00e)), closes [#5599](https://github.com/IBM/kui/issues/5599)
- remove up/down actions buttons ([3c8a8a1](https://github.com/IBM/kui/commit/3c8a8a1)), closes [#5774](https://github.com/IBM/kui/issues/5774)
- replay --freshen does not support multi-split notebooks ([afd070c](https://github.com/IBM/kui/commit/afd070c)), closes [#5571](https://github.com/IBM/kui/issues/5571) [#5572](https://github.com/IBM/kui/issues/5572)
- sidecar shouldn't be opened automatically when replay ([8d4cf8c](https://github.com/IBM/kui/commit/8d4cf8c)), closes [#5730](https://github.com/IBM/kui/issues/5730)
- snapshot and replay of table clicks for Notebook v1 ([1a87dbf](https://github.com/IBM/kui/commit/1a87dbf)), closes [#5821](https://github.com/IBM/kui/issues/5821)
- snapshot command throws errors when capturing watch responses ([600f049](https://github.com/IBM/kui/commit/600f049)), closes [#5452](https://github.com/IBM/kui/issues/5452)
- tab new command should respond with ElsewhereCommentary response ([19a7e1d](https://github.com/IBM/kui/commit/19a7e1d)), closes [#5602](https://github.com/IBM/kui/issues/5602)
- terminal clearing versus splits results in non-replayable splits ([8f9dc23](https://github.com/IBM/kui/commit/8f9dc23)), closes [#5626](https://github.com/IBM/kui/issues/5626)
- **plugins-client-common:** the experimental tag should use sans serif ([143464a](https://github.com/IBM/kui/commit/143464a)), closes [#5363](https://github.com/IBM/kui/issues/5363)
- **plugins/plugin-client-common:** add support for titles in commentary ([fbe367c](https://github.com/IBM/kui/commit/fbe367c)), closes [#5434](https://github.com/IBM/kui/issues/5434)
- **plugins/plugin-client-common:** always place table events in the Card footer ([b667b28](https://github.com/IBM/kui/commit/b667b28)), closes [#5210](https://github.com/IBM/kui/issues/5210)
- **plugins/plugin-client-common:** buggy header UI in dark themes in minisplits ([55aef48](https://github.com/IBM/kui/commit/55aef48)), closes [#5266](https://github.com/IBM/kui/issues/5266)
- **plugins/plugin-client-common:** clicking on pod delete button can cause command to be executed in minisplit ([37f9019](https://github.com/IBM/kui/commit/37f9019)), closes [#5247](https://github.com/IBM/kui/issues/5247)
- **plugins/plugin-client-common:** clicking to focus on a split does not always cause full focus effect ([bc59bcf](https://github.com/IBM/kui/commit/bc59bcf)), closes [#5263](https://github.com/IBM/kui/issues/5263)
- **plugins/plugin-client-common:** close tabs doesn't produce the correct tab content ([6090887](https://github.com/IBM/kui/commit/6090887)), closes [#5220](https://github.com/IBM/kui/issues/5220)
- **plugins/plugin-client-common:** CSS no longer is reactive to narrow window ([4eb0a11](https://github.com/IBM/kui/commit/4eb0a11)), closes [#5290](https://github.com/IBM/kui/issues/5290)
- **plugins/plugin-client-common:** defer loading of both icon sets ([7d343b8](https://github.com/IBM/kui/commit/7d343b8)), closes [#5444](https://github.com/IBM/kui/issues/5444)
- **plugins/plugin-client-common:** don't line-wrap input elements in MiniSplits ([c929f5e](https://github.com/IBM/kui/commit/c929f5e)), closes [#5348](https://github.com/IBM/kui/issues/5348)
- **plugins/plugin-client-common:** don't use fixed maxHeight for Terminal tables ([0e23e22](https://github.com/IBM/kui/commit/0e23e22)), closes [#5206](https://github.com/IBM/kui/issues/5206)
- **plugins/plugin-client-common:** Events drilldown from watch table does not always work ([09aee73](https://github.com/IBM/kui/commit/09aee73)), closes [#5204](https://github.com/IBM/kui/issues/5204)
- **plugins/plugin-client-common:** Events footer in minisplit tables lacks horizontal padding ([f22b1f7](https://github.com/IBM/kui/commit/f22b1f7)), closes [#5196](https://github.com/IBM/kui/issues/5196)
- **plugins/plugin-client-common:** Events should also be placed in table footer (not tbody) when sidecar is open or 2-way terminal split ([1391b1d](https://github.com/IBM/kui/commit/1391b1d)), closes [#5198](https://github.com/IBM/kui/issues/5198)
- **plugins/plugin-client-common:** experiment tag has wrong color contrast in dark themes ([22bfb77](https://github.com/IBM/kui/commit/22bfb77)), closes [#5389](https://github.com/IBM/kui/issues/5389)
- **plugins/plugin-client-common:** Experimental badge should take up less space in minisplits ([268aeb3](https://github.com/IBM/kui/commit/268aeb3)), closes [#5373](https://github.com/IBM/kui/issues/5373)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve behavior of up arrow for first command in MiniSplits ([ed199d4](https://github.com/IBM/kui/commit/ed199d4)), closes [#5297](https://github.com/IBM/kui/issues/5297)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** improve display of tables in side-by-side terminal splits ([5a32255](https://github.com/IBM/kui/commit/5a32255)), closes [#5201](https://github.com/IBM/kui/issues/5201)
- **plugins/plugin-client-common:** improve row hover effect for SequenceDiagram ([89dbe2a](https://github.com/IBM/kui/commit/89dbe2a)), closes [#5426](https://github.com/IBM/kui/issues/5426)
- **plugins/plugin-client-common:** improve spacing of Event footer content ([d63a6f1](https://github.com/IBM/kui/commit/d63a6f1)), closes [#5178](https://github.com/IBM/kui/issues/5178)
- **plugins/plugin-client-common:** in plain Terminals, tables should not inner scroll ([15fcbba](https://github.com/IBM/kui/commit/15fcbba)), closes [#5221](https://github.com/IBM/kui/issues/5221)
- **plugins/plugin-client-common:** inconsistent top padding above Cards ([1e1037f](https://github.com/IBM/kui/commit/1e1037f)), closes [#5299](https://github.com/IBM/kui/issues/5299)
- **plugins/plugin-client-common:** increase density of SequenceDiagram ([ae29488](https://github.com/IBM/kui/commit/ae29488)), closes [#5344](https://github.com/IBM/kui/issues/5344)
- **plugins/plugin-client-common:** long input lines should line wrap ([8804bb1](https://github.com/IBM/kui/commit/8804bb1)), closes [#5338](https://github.com/IBM/kui/issues/5338)
- **plugins/plugin-client-common:** minor improvements for ls -l output ([1b59c94](https://github.com/IBM/kui/commit/1b59c94)), closes [#5216](https://github.com/IBM/kui/issues/5216)
- **plugins/plugin-client-common:** multi-line paste executes commands out of order ([8f39c80](https://github.com/IBM/kui/commit/8f39c80)), closes [#5295](https://github.com/IBM/kui/issues/5295)
- **plugins/plugin-client-common:** only highlight the Active block in the focused split ([feffad4](https://github.com/IBM/kui/commit/feffad4)), closes [#5261](https://github.com/IBM/kui/issues/5261)
- **plugins/plugin-client-common:** place event footer outside of table scroll region for minisplits ([e4872b2](https://github.com/IBM/kui/commit/e4872b2)), closes [#5179](https://github.com/IBM/kui/issues/5179)
- **plugins/plugin-client-common:** present more than 2 footer lines in watch tables ([3e7a78f](https://github.com/IBM/kui/commit/3e7a78f)), closes [#5213](https://github.com/IBM/kui/issues/5213)
- **plugins/plugin-client-common:** pty commands fail in minisplits ([475ea74](https://github.com/IBM/kui/commit/475ea74)), closes [#5267](https://github.com/IBM/kui/issues/5267)
- **plugins/plugin-client-common:** reduce contrast of block left bars ([7c8d371](https://github.com/IBM/kui/commit/7c8d371)), closes [#5275](https://github.com/IBM/kui/issues/5275)
- **plugins/plugin-client-common:** refine Timeline a bit more ([4b12eec](https://github.com/IBM/kui/commit/4b12eec)), closes [#5409](https://github.com/IBM/kui/issues/5409)
- **plugins/plugin-client-common:** regression in table width with sidecar open ([5938806](https://github.com/IBM/kui/commit/5938806)), closes [#5194](https://github.com/IBM/kui/issues/5194)
- **plugins/plugin-client-common:** restore history navigation behavior in minisplits ([26f49e8](https://github.com/IBM/kui/commit/26f49e8)), closes [#5375](https://github.com/IBM/kui/issues/5375)
- **plugins/plugin-client-common:** reverse-i-search incorrectly changes match as i type ([135d429](https://github.com/IBM/kui/commit/135d429)), closes [#5403](https://github.com/IBM/kui/issues/5403)
- **plugins/plugin-client-common:** switching table from Table to Timeline and back to Table does not work ([c924d67](https://github.com/IBM/kui/commit/c924d67)), closes [#5430](https://github.com/IBM/kui/issues/5430)
- **plugins/plugin-client-common:** tab completion UI does not render on separate line from input ([61b169b](https://github.com/IBM/kui/commit/61b169b)), closes [#5307](https://github.com/IBM/kui/issues/5307)
- **plugins/plugin-client-common:** threshold for auto-grid is too low ([9cb76ee](https://github.com/IBM/kui/commit/9cb76ee)), closes [#5424](https://github.com/IBM/kui/issues/5424)
- grid colors are sometimes off ([e66f56f](https://github.com/IBM/kui/commit/e66f56f)), closes [#5422](https://github.com/IBM/kui/issues/5422)
- **plugins/plugin-client-common:** "No resources" in watch pane can occlude watch pane title ([e4fd93a](https://github.com/IBM/kui/commit/e4fd93a)), closes [#5064](https://github.com/IBM/kui/issues/5064)
- **plugins/plugin-client-common:** `ok` string appears at the end of MixResponse ([75606c5](https://github.com/IBM/kui/commit/75606c5)), closes [#5046](https://github.com/IBM/kui/issues/5046)
- **plugins/plugin-client-common:** a few more rem/em font-size issues ([133b347](https://github.com/IBM/kui/commit/133b347)), closes [#5058](https://github.com/IBM/kui/issues/5058)
- **plugins/plugin-client-common:** add error icon for error blocks ([5d9aeea](https://github.com/IBM/kui/commit/5d9aeea)), closes [#4907](https://github.com/IBM/kui/issues/4907)
- **plugins/plugin-client-common:** borders in top tab stripe are too light ([3908695](https://github.com/IBM/kui/commit/3908695)), closes [#5051](https://github.com/IBM/kui/issues/5051)
- **plugins/plugin-client-common:** carbon breadcrumbs may not have proper hover effect ([c8cd2d1](https://github.com/IBM/kui/commit/c8cd2d1)), closes [#4962](https://github.com/IBM/kui/issues/4962)
- **plugins/plugin-client-common:** clearing Terminal does not abort watchers ([34adb50](https://github.com/IBM/kui/commit/34adb50)), closes [#5116](https://github.com/IBM/kui/issues/5116)
- **plugins/plugin-client-common:** clicking 'remove' of a watchable response doesn't abort the underlying pty job ([7eb69fb](https://github.com/IBM/kui/commit/7eb69fb)), closes [#5090](https://github.com/IBM/kui/issues/5090)
- **plugins/plugin-client-common:** decrease height of table footer ([5863622](https://github.com/IBM/kui/commit/5863622)), closes [#5072](https://github.com/IBM/kui/issues/5072)
- **plugins/plugin-client-common:** disableTableTitle also disables title of watch panes ([053cfb6](https://github.com/IBM/kui/commit/053cfb6)), closes [#5036](https://github.com/IBM/kui/issues/5036)
- **plugins/plugin-client-common:** double watch panes may open up ([7fb70f1](https://github.com/IBM/kui/commit/7fb70f1)), closes [#5034](https://github.com/IBM/kui/issues/5034)
- **plugins/plugin-client-common:** editor component does not respond to font zooming ([7b7e0f3](https://github.com/IBM/kui/commit/7b7e0f3)), closes [#5120](https://github.com/IBM/kui/issues/5120)
- **plugins/plugin-client-common:** eliminate react "titleInHeader" console warnings ([8cf3797](https://github.com/IBM/kui/commit/8cf3797)), closes [#5078](https://github.com/IBM/kui/issues/5078)
- **plugins/plugin-client-common:** font size issues with LeftNavSidecar ([e17fc15](https://github.com/IBM/kui/commit/e17fc15)), closes [#5048](https://github.com/IBM/kui/issues/5048)
- **plugins/plugin-client-common:** improve Terminal screenshots by adding padding ([a9b7b26](https://github.com/IBM/kui/commit/a9b7b26)), closes [#4981](https://github.com/IBM/kui/issues/4981)
- **plugins/plugin-client-common:** improve top tab bottom UI ([8ff4151](https://github.com/IBM/kui/commit/8ff4151)), closes [#5056](https://github.com/IBM/kui/issues/5056)
- **plugins/plugin-client-common:** input may not receive focus on tab switch ([7676792](https://github.com/IBM/kui/commit/7676792)), closes [#5102](https://github.com/IBM/kui/issues/5102)
- **plugins/plugin-client-common:** kubectl edit saves can result in unstyled notification ([5dc658e](https://github.com/IBM/kui/commit/5dc658e)), closes [#4930](https://github.com/IBM/kui/issues/4930)
- **plugins/plugin-client-common:** layout regressions from table screenshot PRs ([8004ee3](https://github.com/IBM/kui/commit/8004ee3)), closes [#5159](https://github.com/IBM/kui/issues/5159)
- **plugins/plugin-client-common:** leftover debug printfs in table sorting ([9889b49](https://github.com/IBM/kui/commit/9889b49)), closes [#5030](https://github.com/IBM/kui/issues/5030)
- **plugins/plugin-client-common:** Light tables should use Carbon compact ([2309ec3](https://github.com/IBM/kui/commit/2309ec3)), closes [#5059](https://github.com/IBM/kui/issues/5059)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** one-row tables needn't offer column sorting UI ([5184fa1](https://github.com/IBM/kui/commit/5184fa1)), closes [#5050](https://github.com/IBM/kui/issues/5050)
- **plugins/plugin-client-common:** poor alignment of sidecar toolbar elements ([2307a46](https://github.com/IBM/kui/commit/2307a46)), closes [#4970](https://github.com/IBM/kui/issues/4970)
- **plugins/plugin-client-common:** RadioTable screenshots lack box shadow ([b0e0f2e](https://github.com/IBM/kui/commit/b0e0f2e)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** RadioTables can have gratuituous line wrapping ([9c39682](https://github.com/IBM/kui/commit/9c39682)), closes [#5139](https://github.com/IBM/kui/issues/5139)
- **plugins/plugin-client-common:** RadioTables in minisplits inner-scroll away the header row ([5296dcd](https://github.com/IBM/kui/commit/5296dcd)), closes [#5165](https://github.com/IBM/kui/issues/5165)
- **plugins/plugin-client-common:** regression: non-empty repl output has 'ok' at the end ([103a0f9](https://github.com/IBM/kui/commit/103a0f9)), closes [#4924](https://github.com/IBM/kui/issues/4924)
- **plugins/plugin-client-common:** remove active prompts in an offline notebook ([dd2b53f](https://github.com/IBM/kui/commit/dd2b53f)), closes [#5620](https://github.com/IBM/kui/issues/5620)
- **plugins/plugin-client-common:** reverse-i-search does not properly report no matches ([c16dad3](https://github.com/IBM/kui/commit/c16dad3)), closes [#4943](https://github.com/IBM/kui/issues/4943)
- **plugins/plugin-client-common:** selected row in RadioTables in dark themes has low contrast ([f2c5834](https://github.com/IBM/kui/commit/f2c5834)), closes [#5161](https://github.com/IBM/kui/issues/5161)
- **plugins/plugin-client-common:** SequenceDiagram bars may extend beyond the 100% line ([34d03bc](https://github.com/IBM/kui/commit/34d03bc)), closes [#5465](https://github.com/IBM/kui/issues/5465)
- **plugins/plugin-client-common:** SequenceDiagram can have NaNs in the UI ([ac476a6](https://github.com/IBM/kui/commit/ac476a6)), closes [#5559](https://github.com/IBM/kui/issues/5559)
- **plugins/plugin-client-common:** SequenceDiagram UI refinements ([5d8c3f7](https://github.com/IBM/kui/commit/5d8c3f7)), closes [#5557](https://github.com/IBM/kui/issues/5557)
- **plugins/plugin-client-common:** sidecar badges may not be flush-right ([5b54665](https://github.com/IBM/kui/commit/5b54665)), closes [#5175](https://github.com/IBM/kui/issues/5175)
- **plugins/plugin-client-common:** SourceRef does not respond to all tab layout changes ([d3e8b32](https://github.com/IBM/kui/commit/d3e8b32)), closes [#5552](https://github.com/IBM/kui/issues/5552)
- **plugins/plugin-client-common:** spurious warning in the console re: Tag ([93982de](https://github.com/IBM/kui/commit/93982de)), closes [#4959](https://github.com/IBM/kui/issues/4959)
- **plugins/plugin-client-common:** status column can be invisible in split tables ([c352103](https://github.com/IBM/kui/commit/c352103)), closes [#5244](https://github.com/IBM/kui/issues/5244)
- **plugins/plugin-client-common:** StatusStripe is blank for second+ tabs ([0002dfb](https://github.com/IBM/kui/commit/0002dfb)), closes [#5546](https://github.com/IBM/kui/issues/5546)
- **plugins/plugin-client-common:** table bottom toolbar buttons lack padding ([79f0abe](https://github.com/IBM/kui/commit/79f0abe)), closes [#5554](https://github.com/IBM/kui/issues/5554)
- **plugins/plugin-client-common:** table screenshots include a gray stripe at the top ([11a9fc3](https://github.com/IBM/kui/commit/11a9fc3)), closes [#5410](https://github.com/IBM/kui/issues/5410)
- **plugins/plugin-client-common:** TableCell view can fail when given empty duration cells ([04251be](https://github.com/IBM/kui/commit/04251be)), closes [#5332](https://github.com/IBM/kui/issues/5332)
- **plugins/plugin-client-common:** Tables should have a max-height and use inner scrolling for overflow ([642ef14](https://github.com/IBM/kui/commit/642ef14)), closes [#5153](https://github.com/IBM/kui/issues/5153)
- **plugins/plugin-client-common:** Tables with identical column names render incorrectly ([161dba2](https://github.com/IBM/kui/commit/161dba2)), closes [#5129](https://github.com/IBM/kui/issues/5129)
- **plugins/plugin-client-common:** Terminal Block -> Screenshot of table does not capture box shadow ([ed812f3](https://github.com/IBM/kui/commit/ed812f3)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** Terminal focus changes unexpectedly ([866451c](https://github.com/IBM/kui/commit/866451c)), closes [#5170](https://github.com/IBM/kui/issues/5170)
- **plugins/plugin-client-common:** Timeline may not render properly ([d66d728](https://github.com/IBM/kui/commit/d66d728)), closes [#5383](https://github.com/IBM/kui/issues/5383)
- **plugins/plugin-client-common:** Timeline should use stdev-based heat map ([5dd7427](https://github.com/IBM/kui/commit/5dd7427)), closes [#5395](https://github.com/IBM/kui/issues/5395)
- **plugins/plugin-client-common:** Timeline tooltip for cold starts has incorrect concurrency count ([bb54cb8](https://github.com/IBM/kui/commit/bb54cb8)), closes [#5390](https://github.com/IBM/kui/issues/5390)
- **plugins/plugin-client-common:** Timeline view renders poorly in MiniSplit ([07cd000](https://github.com/IBM/kui/commit/07cd000)), closes [#5379](https://github.com/IBM/kui/issues/5379)
- **plugins/plugin-client-common:** two MiniSplits with open sidecar are too short ([9e21ab9](https://github.com/IBM/kui/commit/9e21ab9)), closes [#5171](https://github.com/IBM/kui/issues/5171)
- **plugins/plugin-client-common:** update SequenceDiagram view to display the duration of each interval ([0cf1fcf](https://github.com/IBM/kui/commit/0cf1fcf)), closes [#5470](https://github.com/IBM/kui/issues/5470)
- **plugins/plugin-client-common:** update welcome.json notebook to improve listing of available notebooks ([c6f89f4](https://github.com/IBM/kui/commit/c6f89f4)), closes [#5583](https://github.com/IBM/kui/issues/5583)
- **plugins/plugin-client-common:** watch pane grid cells too large ([225f937](https://github.com/IBM/kui/commit/225f937)), closes [#5070](https://github.com/IBM/kui/issues/5070)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- Card component does not render well in dark themes ([d96def0](https://github.com/IBM/kui/commit/d96def0)), closes [#4996](https://github.com/IBM/kui/issues/4996)
- clients should be able to enable watcher auto pinning without enabling splitTerminals ([bcade13](https://github.com/IBM/kui/commit/bcade13)), closes [#5002](https://github.com/IBM/kui/issues/5002)
- move default loadingDone icon into plugin-client-common ([39994bc](https://github.com/IBM/kui/commit/39994bc)), closes [#5026](https://github.com/IBM/kui/issues/5026)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- **plugins/plugin-client-common:** WatchPane has incorrect padding ([e74bd7b](https://github.com/IBM/kui/commit/e74bd7b)), closes [#5015](https://github.com/IBM/kui/issues/5015)
- **plugins/plugin-client-default:** improve debug logging of client properties ([4daba1f](https://github.com/IBM/kui/commit/4daba1f)), closes [#5088](https://github.com/IBM/kui/issues/5088)
- **plugins/plugin-core-support:** sidecar "window" buttons are too large ([33415d2](https://github.com/IBM/kui/commit/33415d2)), closes [#5094](https://github.com/IBM/kui/issues/5094)
- Confirm dialog color contrast issues ([da14c25](https://github.com/IBM/kui/commit/da14c25)), closes [#4995](https://github.com/IBM/kui/issues/4995)
- Editor component does not respond to tab layout changes ([9756336](https://github.com/IBM/kui/commit/9756336)), closes [#5231](https://github.com/IBM/kui/issues/5231) [#5232](https://github.com/IBM/kui/issues/5232)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- increase contrast in watch pane ([246ecd2](https://github.com/IBM/kui/commit/246ecd2)), closes [#5000](https://github.com/IBM/kui/issues/5000) [#5001](https://github.com/IBM/kui/issues/5001)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- move patternfly alignment out of patternfly themes plugin ([6adbfd6](https://github.com/IBM/kui/commit/6adbfd6)), closes [#4988](https://github.com/IBM/kui/issues/4988)
- multiple command history regressions ([cbba96c](https://github.com/IBM/kui/commit/cbba96c)), closes [#5283](https://github.com/IBM/kui/issues/5283)
- page-content p should not use text-align: justify ([2646f4b](https://github.com/IBM/kui/commit/2646f4b)), closes [#4908](https://github.com/IBM/kui/issues/4908)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- restore status stripe to default behavior on terminal clear ([128ec92](https://github.com/IBM/kui/commit/128ec92)), closes [#5495](https://github.com/IBM/kui/issues/5495)
- still see name-related breadcrumbs and short-name header with feature flag sidecarName 'heroText' ([1a8be9f](https://github.com/IBM/kui/commit/1a8be9f)), closes [#5013](https://github.com/IBM/kui/issues/5013)
- switching splits does not participate in tab state ([6eb8db4](https://github.com/IBM/kui/commit/6eb8db4)), closes [#5272](https://github.com/IBM/kui/issues/5272)
- vfs fixes for multi-source copying and for s3 globbing ([893902e](https://github.com/IBM/kui/commit/893902e)), closes [#5511](https://github.com/IBM/kui/issues/5511)
- **plugins/plugin-client-common:** Screenshot modal never goes away ([bbd1c98](https://github.com/IBM/kui/commit/bbd1c98)), closes [#4979](https://github.com/IBM/kui/issues/4979)
- **plugins/plugin-client-common:** status cells of live tables do not always blink ([c94b05e](https://github.com/IBM/kui/commit/c94b05e)), closes [#4903](https://github.com/IBM/kui/issues/4903)
- **plugins/plugin-client-common:** UpdateNotification widget has invisible background color ([c0c1d82](https://github.com/IBM/kui/commit/c0c1d82)), closes [#4968](https://github.com/IBM/kui/issues/4968)
- **plugins/plugin-client-common:** watch tables might not be maximized in minisplits ([63420b2](https://github.com/IBM/kui/commit/63420b2)), closes [#5218](https://github.com/IBM/kui/issues/5218)
- **plugins/plugin-client-commong:** show RadioTable selected row in the table body and header breadcrumb ([811c21e](https://github.com/IBM/kui/commit/811c21e)), closes [#5239](https://github.com/IBM/kui/issues/5239)
- **plugins/plugin-ibmcloud:** ibmcloud ce job list does not support name filters ([5daa930](https://github.com/IBM/kui/commit/5daa930)), closes [#5450](https://github.com/IBM/kui/issues/5450)
- **plugins/plugin-patternfly-themes:** update theme alignment to patternfly v4 ([3784b96](https://github.com/IBM/kui/commit/3784b96)), closes [#4948](https://github.com/IBM/kui/issues/4948)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- erratic scroll region behavior ([be0e2a0](https://github.com/IBM/kui/commit/be0e2a0)), closes [#4898](https://github.com/IBM/kui/issues/4898)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** clicking the remove button of a repl block results in an error white screen ([49bfbcc](https://github.com/IBM/kui/commit/49bfbcc)), closes [#4855](https://github.com/IBM/kui/issues/4855)
- **plugins/plugin-client-common:** dropdown in sidecar theming and spacing tweaks ([1a48af3](https://github.com/IBM/kui/commit/1a48af3)), closes [#4680](https://github.com/IBM/kui/issues/4680)
- **plugins/plugin-client-common:** improve visibility of sidecar scrollbars ([827d75a](https://github.com/IBM/kui/commit/827d75a)), closes [#4667](https://github.com/IBM/kui/issues/4667)
- **plugins/plugin-client-common:** in Popup mode, use > rather than / for prompt in bottom input ([1360bed](https://github.com/IBM/kui/commit/1360bed)), closes [#4887](https://github.com/IBM/kui/issues/4887)
- **plugins/plugin-client-common:** increase font size of status stripe ([2fab637](https://github.com/IBM/kui/commit/2fab637)), closes [#4698](https://github.com/IBM/kui/issues/4698)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** input element changes height with i-search and bottomInput ([abf9890](https://github.com/IBM/kui/commit/abf9890)), closes [#4685](https://github.com/IBM/kui/issues/4685)
- **plugins/plugin-client-common:** LeftNav sidecar nav column width inconsistency ([17e403f](https://github.com/IBM/kui/commit/17e403f)), closes [#4688](https://github.com/IBM/kui/issues/4688)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** LeftNavSidecar does not always reflect updated content ([0f2e1e1](https://github.com/IBM/kui/commit/0f2e1e1)), closes [#4727](https://github.com/IBM/kui/issues/4727) [#4732](https://github.com/IBM/kui/issues/4732)
- **plugins/plugin-client-common:** LeftNavSidecar font size and layout issues ([d9914f1](https://github.com/IBM/kui/commit/d9914f1)), closes [#4718](https://github.com/IBM/kui/issues/4718) [#4719](https://github.com/IBM/kui/issues/4719)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** move screenshot button out of status stripe ([0ef900b](https://github.com/IBM/kui/commit/0ef900b)), closes [#4556](https://github.com/IBM/kui/issues/4556)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** PatternFly DropDown rendering glitches ([8efedd8](https://github.com/IBM/kui/commit/8efedd8)), closes [#4649](https://github.com/IBM/kui/issues/4649) [#4651](https://github.com/IBM/kui/issues/4651)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** refine Loading component ([7a07ad3](https://github.com/IBM/kui/commit/7a07ad3)), closes [#4702](https://github.com/IBM/kui/issues/4702)
- **plugins/plugin-client-common:** reverse the dependency of Card and DropDown ([00b8ecf](https://github.com/IBM/kui/commit/00b8ecf)), closes [#4641](https://github.com/IBM/kui/issues/4641)
- **plugins/plugin-client-common:** Screenshot button should not be offered inBrowser ([d1c2cfb](https://github.com/IBM/kui/commit/d1c2cfb)), closes [#4636](https://github.com/IBM/kui/issues/4636)
- **plugins/plugin-client-common:** session init done message messes up Terminal scrolling ([7e80ac1](https://github.com/IBM/kui/commit/7e80ac1)), closes [#4683](https://github.com/IBM/kui/issues/4683)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- **plugins/plugin-client-common:** sidecar toolbar text incorrectly aligned ([ddd7460](https://github.com/IBM/kui/commit/ddd7460)), closes [#4659](https://github.com/IBM/kui/issues/4659)
- **plugins/plugin-client-common:** split button errors are not reported to the user ([fc4e2a2](https://github.com/IBM/kui/commit/fc4e2a2)), closes [#4876](https://github.com/IBM/kui/issues/4876)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- **plugins/plugin-client-common:** Terminal screenshot odd w.r.t. auto-focus ([4b1c7d8](https://github.com/IBM/kui/commit/4b1c7d8)), closes [#4739](https://github.com/IBM/kui/issues/4739)
- **plugins/plugin-client-common:** top tab buttons should be owned by the top tab stripe ([9a45c43](https://github.com/IBM/kui/commit/9a45c43)), closes [#4690](https://github.com/IBM/kui/issues/4690)
- **plugins/plugn-client-common:** TopTabStripe stays blue after command execution completes ([68f5841](https://github.com/IBM/kui/commit/68f5841)), closes [#4883](https://github.com/IBM/kui/issues/4883)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- pexecs serviced by now-removed splits fail ([f6176a1](https://github.com/IBM/kui/commit/f6176a1)), closes [#4875](https://github.com/IBM/kui/issues/4875)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- **plugins/plugin-client-common:** table container should only be width:100% for table not display-as-grid ([8f327cd](https://github.com/IBM/kui/commit/8f327cd)), closes [#4871](https://github.com/IBM/kui/issues/4871)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- improve error reporting for kubectl apply ([fe21671](https://github.com/IBM/kui/commit/fe21671)), closes [#4605](https://github.com/IBM/kui/issues/4605)
- Input element throws react error ([e6bb21b](https://github.com/IBM/kui/commit/e6bb21b)), closes [#4765](https://github.com/IBM/kui/issues/4765)
- kubectl api-resources has duplicate rows and odd pagination behavior ([e740270](https://github.com/IBM/kui/commit/e740270)), closes [#4626](https://github.com/IBM/kui/issues/4626)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- kubectl edit in sidecar doesn't show success message when a resource is applied ([cc59503](https://github.com/IBM/kui/commit/cc59503)), closes [#4691](https://github.com/IBM/kui/issues/4691)
- kubectl Logs tab should use an xterm ([9aa0176](https://github.com/IBM/kui/commit/9aa0176)), closes [#4750](https://github.com/IBM/kui/issues/4750) [#4747](https://github.com/IBM/kui/issues/4747)
- place namespace breadcrumb first ([5d3b2e4](https://github.com/IBM/kui/commit/5d3b2e4)), closes [#4699](https://github.com/IBM/kui/issues/4699)
- sidecar back/forward should be ordered by visitation rather than insertion ([fba613a](https://github.com/IBM/kui/commit/fba613a)), closes [#4746](https://github.com/IBM/kui/issues/4746)
- sidecar container selection kebab has different color with its menu ([639617a](https://github.com/IBM/kui/commit/639617a)), closes [#4676](https://github.com/IBM/kui/issues/4676)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- split screen terminals sometimes incorrect handle exit ([d63cde7](https://github.com/IBM/kui/commit/d63cde7)), closes [#4860](https://github.com/IBM/kui/issues/4860)
- summary tab is not read-only for kubectl edit command ([9f7ff82](https://github.com/IBM/kui/commit/9f7ff82)), closes [#4809](https://github.com/IBM/kui/issues/4809)
- TopNavSidecar doesn't return to the previous selected Tab when back button is hit ([32acee5](https://github.com/IBM/kui/commit/32acee5)), closes [#4745](https://github.com/IBM/kui/issues/4745)
- TopNavSidecar tabs should auto-pause and auto-focus when switching ([2b00dd9](https://github.com/IBM/kui/commit/2b00dd9)), closes [#4741](https://github.com/IBM/kui/issues/4741) [#4748](https://github.com/IBM/kui/issues/4748)
- **plugins/plugin-client-common:** TopNavSidecar tabs easily overflow with narrower windows ([a555cd4](https://github.com/IBM/kui/commit/a555cd4)), closes [#4735](https://github.com/IBM/kui/issues/4735)
- **plugins/plugin-client-common:** WatchPane has non-zero height even when empty ([67a7070](https://github.com/IBM/kui/commit/67a7070)), closes [#4629](https://github.com/IBM/kui/issues/4629)
- reduce No log data followed by log data behavior in kube logs ([e1c0624](https://github.com/IBM/kui/commit/e1c0624)), closes [#4624](https://github.com/IBM/kui/issues/4624)
- replace Containers with Logs tab ([00e8786](https://github.com/IBM/kui/commit/00e8786)), closes [#4603](https://github.com/IBM/kui/issues/4603)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- **plugin-client-common:** PaginatedTable clicks on page N+1 activate handlers on first page ([f5f6045](https://github.com/IBM/kui/commit/f5f6045)), closes [#3999](https://github.com/IBM/kui/issues/3999)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** LeftNavSidecar does not support font zooming ([7008857](https://github.com/IBM/kui/commit/7008857)), closes [#4001](https://github.com/IBM/kui/issues/4001)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** badge/STATUS column is always monospace ([b53e8f9](https://github.com/IBM/kui/commit/b53e8f9)), closes [#4056](https://github.com/IBM/kui/issues/4056)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** css regression of sidecar-header in popup mode ([6112f94](https://github.com/IBM/kui/commit/6112f94)), closes [#4061](https://github.com/IBM/kui/issues/4061)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** improve consistency of button hover effects ([2e96c8c](https://github.com/IBM/kui/commit/2e96c8c)), closes [#3986](https://github.com/IBM/kui/issues/3986)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** live tables too thin when sidecar is open ([ccd41f0](https://github.com/IBM/kui/commit/ccd41f0)), closes [#4029](https://github.com/IBM/kui/issues/4029) [#4031](https://github.com/IBM/kui/issues/4031)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- improve contrast of top tab stripe versus sidecar title stripe ([ee9eb63](https://github.com/IBM/kui/commit/ee9eb63)), closes [#3956](https://github.com/IBM/kui/issues/3956)
- improve presentation with narrow windows ([cb23c63](https://github.com/IBM/kui/commit/cb23c63)), closes [#3954](https://github.com/IBM/kui/issues/3954)
- **packages/core:** restore CommandStringContent as one of FunctionThatProducesContent types ([1e32b93](https://github.com/IBM/kui/commit/1e32b93)), closes [#3687](https://github.com/IBM/kui/issues/3687)
- **plugins/plugin-client-common:** improve Screenshot UI ([bc2102a](https://github.com/IBM/kui/commit/bc2102a)), closes [#3734](https://github.com/IBM/kui/issues/3734)
- Popup client should place InputStripe inside of StatusStripe ([a09138d](https://github.com/IBM/kui/commit/a09138d)), closes [#3949](https://github.com/IBM/kui/issues/3949)
- **plugins/plugin-carbon-themes:** carbon themes do not fully apply ([1659157](https://github.com/IBM/kui/commit/1659157)), closes [#3740](https://github.com/IBM/kui/issues/3740)
- **plugins/plugin-client-common:** active PTY easily loses focus ([8ca12e8](https://github.com/IBM/kui/commit/8ca12e8)), closes [#3945](https://github.com/IBM/kui/issues/3945)
- **plugins/plugin-client-common:** horizontal scrollbar can flash on and off ([3c26eca](https://github.com/IBM/kui/commit/3c26eca)), closes [#3937](https://github.com/IBM/kui/issues/3937)
- multiple fixes for screenshot toast notification UI ([8725e0b](https://github.com/IBM/kui/commit/8725e0b)), closes [#3933](https://github.com/IBM/kui/issues/3933)
- **plugins/plugin-client-common:** clean up screenshot notification UI ([9ddec1a](https://github.com/IBM/kui/commit/9ddec1a)), closes [#3699](https://github.com/IBM/kui/issues/3699)
- **plugins/plugin-client-common:** improve error handling of hackFocus ([a16b680](https://github.com/IBM/kui/commit/a16b680)), closes [#3769](https://github.com/IBM/kui/issues/3769)
- **plugins/plugin-client-common:** improve error handling of Scalar.tsx ([53cd8e5](https://github.com/IBM/kui/commit/53cd8e5)), closes [#3781](https://github.com/IBM/kui/issues/3781)
- **plugins/plugin-client-common:** improve Markdown styling of ul ([e60d592](https://github.com/IBM/kui/commit/e60d592)), closes [#3865](https://github.com/IBM/kui/issues/3865)
- **plugins/plugin-client-common:** misaligned svgs in paginated table ([7a201c2](https://github.com/IBM/kui/commit/7a201c2)), closes [#3702](https://github.com/IBM/kui/issues/3702)
- **plugins/plugin-client-common:** small tweaks to h3 headers in Markdown content ([3eee334](https://github.com/IBM/kui/commit/3eee334)), closes [#3918](https://github.com/IBM/kui/issues/3918)
- **plugins/plugin-client-common:** SplitPane layout issues with electron 7 ([b81b75d](https://github.com/IBM/kui/commit/b81b75d)), closes [#3914](https://github.com/IBM/kui/issues/3914)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- restore support for quiet table clicks ([b8d4e51](https://github.com/IBM/kui/commit/b8d4e51)), closes [#3894](https://github.com/IBM/kui/issues/3894)
- **plugins/plugin-client-common:** clear console should restore active prompt value ([23afefd](https://github.com/IBM/kui/commit/23afefd)), closes [#3797](https://github.com/IBM/kui/issues/3797)
- **plugins/plugin-client-common:** closing first tab can close entire window ([6ef836d](https://github.com/IBM/kui/commit/6ef836d)), closes [#3896](https://github.com/IBM/kui/issues/3896)
- improve Terminal horizontal alignment for carbon themes ([fe7c8bb](https://github.com/IBM/kui/commit/fe7c8bb)), closes [#3891](https://github.com/IBM/kui/issues/3891)
- **plugins/plugin-client-common:** improve Scalar renderer error handling ([c42fd6a](https://github.com/IBM/kui/commit/c42fd6a)), closes [#3765](https://github.com/IBM/kui/issues/3765)
- **plugins/plugin-client-common:** improved fix for status stripe icon spacing ([fe9eab2](https://github.com/IBM/kui/commit/fe9eab2)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** keyboard shortcuts for TopTabStripe aren't working ([24d074f](https://github.com/IBM/kui/commit/24d074f)), closes [#3643](https://github.com/IBM/kui/issues/3643)
- **plugins/plugin-client-common:** odd border-left in prompt for light themes ([a9f8af3](https://github.com/IBM/kui/commit/a9f8af3)), closes [#3752](https://github.com/IBM/kui/issues/3752)
- **plugins/plugin-client-common:** remove old min-width-date-like css class ([b075b7b](https://github.com/IBM/kui/commit/b075b7b)), closes [#3767](https://github.com/IBM/kui/issues/3767)
- **plugins/plugin-client-common:** screenshot notification never goes away ([9a8ad4f](https://github.com/IBM/kui/commit/9a8ad4f)), closes [#3705](https://github.com/IBM/kui/issues/3705)
- **plugins/plugin-client-common:** shorten top tabs ([da02499](https://github.com/IBM/kui/commit/da02499)), closes [#3872](https://github.com/IBM/kui/issues/3872)
- eliminate use of custom <tab> tag ([00e2728](https://github.com/IBM/kui/commit/00e2728)), closes [#3777](https://github.com/IBM/kui/issues/3777)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm on its own should render in sidecar ([4b82517](https://github.com/IBM/kui/commit/4b82517)), closes [#4010](https://github.com/IBM/kui/issues/4010)
- improve CodeSnippet rendering in Markdown ([9df43d0](https://github.com/IBM/kui/commit/9df43d0)), closes [#3863](https://github.com/IBM/kui/issues/3863)
- improve contrast of table Pagination component in light themes ([41246c3](https://github.com/IBM/kui/commit/41246c3)), closes [#4038](https://github.com/IBM/kui/issues/4038)
- improve Form layout ([2003622](https://github.com/IBM/kui/commit/2003622)), closes [#4034](https://github.com/IBM/kui/issues/4034)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- improved color contrast in bottom stripe light themes (on hover) ([58681b8](https://github.com/IBM/kui/commit/58681b8)), closes [#4081](https://github.com/IBM/kui/issues/4081)
- kubectl summary form clipping ([7ea65e8](https://github.com/IBM/kui/commit/7ea65e8)), closes [#4093](https://github.com/IBM/kui/issues/4093)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- paginated tables always take up full width ([f0fe792](https://github.com/IBM/kui/commit/f0fe792)), closes [#3859](https://github.com/IBM/kui/issues/3859)
- pick a winner if more than one tab completion enumerator has offerings ([fbd6696](https://github.com/IBM/kui/commit/fbd6696)), closes [#3736](https://github.com/IBM/kui/issues/3736)
- plugin-client-command/default are publishing tsbuildinfo ([0ad3f2a](https://github.com/IBM/kui/commit/0ad3f2a)), closes [#3846](https://github.com/IBM/kui/issues/3846)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- reverse-i-search does not always terminate with current completion ([e05d905](https://github.com/IBM/kui/commit/e05d905)), closes [#3799](https://github.com/IBM/kui/issues/3799)
- some code is dependent on the existence of static config files ([cdc6487](https://github.com/IBM/kui/commit/cdc6487)), closes [#3813](https://github.com/IBM/kui/issues/3813)
- stop loading the entire carbon-components.min.css ([5ecba14](https://github.com/IBM/kui/commit/5ecba14)), closes [#3744](https://github.com/IBM/kui/issues/3744)
- TabContent constructor sometimes calls this.setState ([5a72470](https://github.com/IBM/kui/commit/5a72470)), closes [#3844](https://github.com/IBM/kui/issues/3844)
- table model should not allow raw HTML Node ([39c87ce](https://github.com/IBM/kui/commit/39c87ce)), closes [#3785](https://github.com/IBM/kui/issues/3785)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- use more standard TopTabStripe UI ([c390dff](https://github.com/IBM/kui/commit/c390dff)), closes [#3867](https://github.com/IBM/kui/issues/3867)
- **plugins/plugin-carbon-themes:** color contrast issues in carbon gray 10 ([0211b54](https://github.com/IBM/kui/commit/0211b54)), closes [#3775](https://github.com/IBM/kui/issues/3775)
- **plugins/plugin-client-common:** active+processing tab is not properly colored ([56bc759](https://github.com/IBM/kui/commit/56bc759)), closes [#3827](https://github.com/IBM/kui/issues/3827)
- **plugins/plugin-client-common:** improve focus preservation of active prompt ([1ef2153](https://github.com/IBM/kui/commit/1ef2153)), closes [#3805](https://github.com/IBM/kui/issues/3805)
- **plugins/plugin-client-common:** inBrowser, prompt should be basename ([f47d03c](https://github.com/IBM/kui/commit/f47d03c)), closes [#3815](https://github.com/IBM/kui/issues/3815)
- **plugins/plugin-client-common:** input element clips with larger font sizes ([c62678b](https://github.com/IBM/kui/commit/c62678b)), closes [#4026](https://github.com/IBM/kui/issues/4026)
- **plugins/plugin-client-common:** re-implement "sidecar-visible" attribute of Terminal ([6d280ab](https://github.com/IBM/kui/commit/6d280ab)), closes [#3833](https://github.com/IBM/kui/issues/3833)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** status stripe left-pad missing ([58d0613](https://github.com/IBM/kui/commit/58d0613)), closes [#3724](https://github.com/IBM/kui/issues/3724)
- **plugins/plugin-client-common:** stop using value prop for uncontrolled input element ([fdbfaff](https://github.com/IBM/kui/commit/fdbfaff)), closes [#3778](https://github.com/IBM/kui/issues/3778)
- **plugins/plugin-client-common:** streaming output does not scroll terminal ([63891d6](https://github.com/IBM/kui/commit/63891d6)), closes [#3760](https://github.com/IBM/kui/issues/3760)
- **plugins/plugin-client-common:** Tab uses strings rather than numbers for Close16 dimensions ([786447c](https://github.com/IBM/kui/commit/786447c)), closes [#3771](https://github.com/IBM/kui/issues/3771)
- **plugins/plugin-client-common:** Tab.tsx does not render "processing" state ([1ae0ab5](https://github.com/IBM/kui/commit/1ae0ab5)), closes [#3646](https://github.com/IBM/kui/issues/3646)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-client-common:** text-selection is not working in repl ([5672e02](https://github.com/IBM/kui/commit/5672e02)), closes [#3738](https://github.com/IBM/kui/issues/3738) [#3739](https://github.com/IBM/kui/issues/3739) [#3741](https://github.com/IBM/kui/issues/3741)
- **plugins/plugin-client-common:** top tabs disappear with narrower windows ([4184247](https://github.com/IBM/kui/commit/4184247)), closes [#3842](https://github.com/IBM/kui/issues/3842)
- **plugins/plugin-client-common:** When command completes, TopTab doesn't change the process state ([f8139ac](https://github.com/IBM/kui/commit/f8139ac)), closes [#3707](https://github.com/IBM/kui/issues/3707)
- **plugins/plugin-client-common:** yellow badges in sidecar have low contrast ([325d23f](https://github.com/IBM/kui/commit/325d23f)), closes [#4050](https://github.com/IBM/kui/issues/4050)
- **plugins/plugin-client-default:** improve table layout for radio tables ([75e1e70](https://github.com/IBM/kui/commit/75e1e70)), closes [#3596](https://github.com/IBM/kui/issues/3596)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugin-kubectl:** remove leftover debugging printf in kubectl help ([39ab52f](https://github.com/IBM/kui/commit/39ab52f)), closes [#4083](https://github.com/IBM/kui/issues/4083)
- **plugins/plugin-wskflow:** bump jquery to 3.5.0 ([6ace265](https://github.com/IBM/kui/commit/6ace265)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- eliminate the the use of symlink of adding css files to build stage ([dad4987](https://github.com/IBM/kui/commit/dad4987)), closes [#3567](https://github.com/IBM/kui/issues/3567)
- STATUS cell not centered when sidecar is open ([4fb507a](https://github.com/IBM/kui/commit/4fb507a)), closes [#4059](https://github.com/IBM/kui/issues/4059)
- status stripe refinements ([1394043](https://github.com/IBM/kui/commit/1394043)), closes [#4069](https://github.com/IBM/kui/issues/4069) [#4069](https://github.com/IBM/kui/issues/4069)
- tables overflow horizontally when sidecar is open ([2d6bc95](https://github.com/IBM/kui/commit/2d6bc95)), closes [#4016](https://github.com/IBM/kui/issues/4016)
- text selection in active xterms for light themes is not visible ([ace9ec9](https://github.com/IBM/kui/commit/ace9ec9)), closes [#4087](https://github.com/IBM/kui/issues/4087)
- upgrade @patternfly/react-core to latest ([0331533](https://github.com/IBM/kui/commit/0331533)), closes [#4937](https://github.com/IBM/kui/issues/4937)
- when sidecar is open, only show status badge, not status text ([3214db2](https://github.com/IBM/kui/commit/3214db2)), closes [#4058](https://github.com/IBM/kui/issues/4058)

### chore

- clean up directory structure ([70d19e9](https://github.com/IBM/kui/commit/70d19e9)), closes [#4301](https://github.com/IBM/kui/issues/4301)
- kui client cleanup ([b4c3984](https://github.com/IBM/kui/commit/b4c3984)), closes [#3974](https://github.com/IBM/kui/issues/3974)

### Features

- add alert command to display Alert component in Terminal ([495d3bb](https://github.com/IBM/kui/commit/495d3bb)), closes [#4957](https://github.com/IBM/kui/issues/4957)
- execute the command in url query when the browser app is loaded ([b0b95cf](https://github.com/IBM/kui/commit/b0b95cf)), closes [#5879](https://github.com/IBM/kui/issues/5879)
- **plugins/plugin-client-common:** allow users to insert command before a repl block ([e935092](https://github.com/IBM/kui/commit/e935092)), closes [#5576](https://github.com/IBM/kui/issues/5576)
- **plugins/plugin-client-common:** allow users to reorder blocks by MoveUp and MoveDown buttons ([f7f6918](https://github.com/IBM/kui/commit/f7f6918)), closes [#5589](https://github.com/IBM/kui/issues/5589)
- **plugins/plugin-client-common:** SourceRef should be default-expanded in Notebooks? ([8ee26e8](https://github.com/IBM/kui/commit/8ee26e8)), closes [#5866](https://github.com/IBM/kui/issues/5866)
- Feature: improve support for parallelization across VFS operations ([e05d7e0](https://github.com/IBM/kui/commit/e05d7e0)), closes [#5831](https://github.com/IBM/kui/issues/5831)
- **plugins/plugin-client-common:** allow clients to specify initial tab title ([e8e365f](https://github.com/IBM/kui/commit/e8e365f)), closes [#5539](https://github.com/IBM/kui/issues/5539)
- **plugins/plugin-client-common:** block-level copy/paste ([a72cf8d](https://github.com/IBM/kui/commit/a72cf8d)), closes [#5752](https://github.com/IBM/kui/issues/5752)
- **plugins/plugin-client-common:** edit a commentary response using SimpleEditor ([6d828c1](https://github.com/IBM/kui/commit/6d828c1)), closes [#5664](https://github.com/IBM/kui/issues/5664)
- **plugins/plugin-client-common:** improve action button UI for output-only blocks ([9cb99ad](https://github.com/IBM/kui/commit/9cb99ad)), closes [#5660](https://github.com/IBM/kui/issues/5660)
- **plugins/plugin-client-common:** Output-only blocks should offer a Copy action button ([da4f85d](https://github.com/IBM/kui/commit/da4f85d)), closes [#5646](https://github.com/IBM/kui/issues/5646)
- **plugins/plugin-client-common:** split command should allow user to specify splice index ([75857e9](https://github.com/IBM/kui/commit/75857e9)), closes [#5746](https://github.com/IBM/kui/issues/5746)
- initial support for capturing input files and showing them in the UI ([5744bf4](https://github.com/IBM/kui/commit/5744bf4)), closes [#5513](https://github.com/IBM/kui/issues/5513)
- notebook client ([4b64133](https://github.com/IBM/kui/commit/4b64133)), closes [#5501](https://github.com/IBM/kui/issues/5501)
- save/restore pty command output ([2c291a9](https://github.com/IBM/kui/commit/2c291a9)), closes [#5314](https://github.com/IBM/kui/issues/5314)
- **plugins/plugin-client-common:** Improve notebook-style ui ([791160e](https://github.com/IBM/kui/commit/791160e)), closes [#5472](https://github.com/IBM/kui/issues/5472)
- **plugins/plugin-client-common:** improve presentation of sidecar-destined responses ([02b91e3](https://github.com/IBM/kui/commit/02b91e3)), closes [#5463](https://github.com/IBM/kui/issues/5463)
- **plugins/plugin-client-common:** User should be able to tab navigate through blocks ([54d3759](https://github.com/IBM/kui/commit/54d3759)), closes [#5717](https://github.com/IBM/kui/issues/5717)
- ability to register an onClose handler when opening a tab ([58a36c3](https://github.com/IBM/kui/commit/58a36c3)), closes [#5670](https://github.com/IBM/kui/issues/5670)
- **plugins/plugin-client-common:** add support for Tags in StatusStripe ([d112c86](https://github.com/IBM/kui/commit/d112c86)), closes [#4951](https://github.com/IBM/kui/issues/4951)
- **plugins/plugin-client-common:** improve accessibility of "red" error grid cells ([8921292](https://github.com/IBM/kui/commit/8921292)), closes [#4938](https://github.com/IBM/kui/issues/4938)
- **plugins/plugin-client-common:** Improve Commentary editing UI by adding real Done button ([1f544b5](https://github.com/IBM/kui/commit/1f544b5)), closes [#5667](https://github.com/IBM/kui/issues/5667)
- **plugins/plugin-client-common:** support client option for hero names in sidecar ([d4f6984](https://github.com/IBM/kui/commit/d4f6984)), closes [#4909](https://github.com/IBM/kui/issues/4909)
- <Kui> should allow for custom Input elements ([193a108](https://github.com/IBM/kui/commit/193a108)), closes [#4672](https://github.com/IBM/kui/issues/4672)
- add a command to return the Card Component in Terminal ([d8d13ab](https://github.com/IBM/kui/commit/d8d13ab)), closes [#4973](https://github.com/IBM/kui/issues/4973)
- add a prefer-re-execution option to snapshot ([af7b98b](https://github.com/IBM/kui/commit/af7b98b)), closes [#5622](https://github.com/IBM/kui/issues/5622)
- add button to WatchPane to show table back in terminal ([dc22591](https://github.com/IBM/kui/commit/dc22591)), closes [#4530](https://github.com/IBM/kui/issues/4530)
- add capability to click to edit/rerun a command ([4296933](https://github.com/IBM/kui/commit/4296933)), closes [#5654](https://github.com/IBM/kui/issues/5654)
- add capability to show welcome widget to new users in Terminal ([0c33e6e](https://github.com/IBM/kui/commit/0c33e6e)), closes [#4990](https://github.com/IBM/kui/issues/4990) [#5007](https://github.com/IBM/kui/issues/5007)
- add CommentaryReponse to snapshot/replay the response of commentary command ([7d13a93](https://github.com/IBM/kui/commit/7d13a93)), closes [#5439](https://github.com/IBM/kui/issues/5439)
- add history to sidecar views ([b1e5543](https://github.com/IBM/kui/commit/b1e5543)), closes [#3960](https://github.com/IBM/kui/issues/3960)
- add isSelected and Divider to log container selection menu ([59bdaa5](https://github.com/IBM/kui/commit/59bdaa5)), closes [#4647](https://github.com/IBM/kui/issues/4647)
- add krew support ([f87cb6c](https://github.com/IBM/kui/commit/f87cb6c)), closes [#4199](https://github.com/IBM/kui/issues/4199)
- add labels to summary mode ([95f731d](https://github.com/IBM/kui/commit/95f731d)), closes [#4041](https://github.com/IBM/kui/issues/4041) [#4040](https://github.com/IBM/kui/issues/4040)
- add Patternfly Breadcrumb support ([91e0504](https://github.com/IBM/kui/commit/91e0504)), closes [#4381](https://github.com/IBM/kui/issues/4381)
- add Patternfly Navigation for LeftNavSidecar ([a4a7a97](https://github.com/IBM/kui/commit/a4a7a97)), closes [#4387](https://github.com/IBM/kui/issues/4387)
- add Retry button to sidecar toolbar when log streaming stopped abnormally ([47872f4](https://github.com/IBM/kui/commit/47872f4)), closes [#4755](https://github.com/IBM/kui/issues/4755)
- add sequence diagram to table with timestamp columns ([e9028ee](https://github.com/IBM/kui/commit/e9028ee)), closes [#5336](https://github.com/IBM/kui/issues/5336)
- add Show Owner Reference button for kube resources ([80ea40f](https://github.com/IBM/kui/commit/80ea40f)), closes [#4106](https://github.com/IBM/kui/issues/4106)
- add Stop Watching capability to WatchPane ([09043c1](https://github.com/IBM/kui/commit/09043c1)), closes [#4554](https://github.com/IBM/kui/issues/4554)
- add support for <Kui noPromptContext/> and <Kui prompt=">"/> ([a92063d](https://github.com/IBM/kui/commit/a92063d)), closes [#4653](https://github.com/IBM/kui/issues/4653)
- add support for Toolbar Buttons ([f55b8c6](https://github.com/IBM/kui/commit/f55b8c6)), closes [#4103](https://github.com/IBM/kui/issues/4103) [#4105](https://github.com/IBM/kui/issues/4105)
- allow <Kui/> users to provide custom views for session init ([1f35894](https://github.com/IBM/kui/commit/1f35894)), closes [#4596](https://github.com/IBM/kui/issues/4596)
- allow clients to modify the session lifecycle UI by providing custom strings ([3c78fd3](https://github.com/IBM/kui/commit/3c78fd3)), closes [#5019](https://github.com/IBM/kui/issues/5019)
- allow command registrations to express their experimental nature ([eb9f147](https://github.com/IBM/kui/commit/eb9f147)), closes [#5282](https://github.com/IBM/kui/issues/5282)
- allow controllers to control the color of the status stripe ([708570c](https://github.com/IBM/kui/commit/708570c)), closes [#5490](https://github.com/IBM/kui/issues/5490)
- allow subclasses of InputProvider to specify their own State ([c3fc88e](https://github.com/IBM/kui/commit/c3fc88e)), closes [#4756](https://github.com/IBM/kui/issues/4756)
- allow table model to specify a gridable column index ([f4ba8e6](https://github.com/IBM/kui/commit/f4ba8e6)), closes [#5278](https://github.com/IBM/kui/issues/5278)
- allow themes to dictate Kui client properties ([2b41873](https://github.com/IBM/kui/commit/2b41873)), closes [#4409](https://github.com/IBM/kui/issues/4409)
- allow users to select container in kubectl Logs ([f4304c5](https://github.com/IBM/kui/commit/f4304c5)), closes [#4627](https://github.com/IBM/kui/issues/4627)
- auto gridify large table ([bd22fa2](https://github.com/IBM/kui/commit/bd22fa2)), closes [#5305](https://github.com/IBM/kui/issues/5305)
- background new tabs ([be9f986](https://github.com/IBM/kui/commit/be9f986)), closes [#5550](https://github.com/IBM/kui/issues/5550)
- bottom input ([c6d2af0](https://github.com/IBM/kui/commit/c6d2af0)), closes [#3729](https://github.com/IBM/kui/issues/3729)
- carbon tables ([237e9a5](https://github.com/IBM/kui/commit/237e9a5)), closes [#3632](https://github.com/IBM/kui/issues/3632)
- clicking on events in watch table should drill down to events ([c6dc99f](https://github.com/IBM/kui/commit/c6dc99f)), closes [#5173](https://github.com/IBM/kui/issues/5173)
- cold start delays ([83abd14](https://github.com/IBM/kui/commit/83abd14)), closes [#5356](https://github.com/IBM/kui/issues/5356)
- command history should be tab-specific ([1b987e0](https://github.com/IBM/kui/commit/1b987e0)), closes [#1299](https://github.com/IBM/kui/issues/1299)
- commentary command to add comments to REPL ([c304fd3](https://github.com/IBM/kui/commit/c304fd3)), closes [#5428](https://github.com/IBM/kui/issues/5428)
- custom tab titles ([fd780df](https://github.com/IBM/kui/commit/fd780df)), closes [#5525](https://github.com/IBM/kui/issues/5525)
- decrease default size of popup window ([a210ac4](https://github.com/IBM/kui/commit/a210ac4)), closes [#4192](https://github.com/IBM/kui/issues/4192) [#4193](https://github.com/IBM/kui/issues/4193)
- Dropdown spi and use in Terminal Block ([327917b](https://github.com/IBM/kui/commit/327917b)), closes [#4589](https://github.com/IBM/kui/issues/4589) [#4556](https://github.com/IBM/kui/issues/4556)
- enhance table UI ([519beb1](https://github.com/IBM/kui/commit/519beb1)), closes [#4023](https://github.com/IBM/kui/issues/4023)
- for popup windows, show command as placeholder text in input stripe ([a897042](https://github.com/IBM/kui/commit/a897042)), closes [#3899](https://github.com/IBM/kui/issues/3899)
- ibmcloud plugin ([aa0f72f](https://github.com/IBM/kui/commit/aa0f72f)), closes [#4353](https://github.com/IBM/kui/issues/4353)
- improve kubectl edit experience ([4c4a1c9](https://github.com/IBM/kui/commit/4c4a1c9)), closes [#4783](https://github.com/IBM/kui/issues/4783)
- improve pagination and toolbar UIs of PaginatedTable ([08062e9](https://github.com/IBM/kui/commit/08062e9)), closes [#1456](https://github.com/IBM/kui/issues/1456)
- improve rendering of kubectl subcommand help ([e36ed29](https://github.com/IBM/kui/commit/e36ed29)), closes [#4824](https://github.com/IBM/kui/issues/4824)
- improve repl-block selection ([305b36f](https://github.com/IBM/kui/commit/305b36f)), closes [#5587](https://github.com/IBM/kui/issues/5587)
- initial typeahead for commands ([7ba313a](https://github.com/IBM/kui/commit/7ba313a)), closes [#5437](https://github.com/IBM/kui/issues/5437)
- initial/minimal snapshot/replay support ([bb7ae0f](https://github.com/IBM/kui/commit/bb7ae0f)), closes [#5280](https://github.com/IBM/kui/issues/5280)
- inverse splits ([38d2895](https://github.com/IBM/kui/commit/38d2895)), closes [#5537](https://github.com/IBM/kui/issues/5537)
- kubectl edit via kui's editor ([414e813](https://github.com/IBM/kui/commit/414e813)), closes [#762](https://github.com/IBM/kui/issues/762)
- kubectl tables should show official kind in title ([06eec95](https://github.com/IBM/kui/commit/06eec95)), closes [#4127](https://github.com/IBM/kui/issues/4127)
- Kui client should support self-bootstrapping of Kui ([3bbf8e8](https://github.com/IBM/kui/commit/3bbf8e8)), closes [#4277](https://github.com/IBM/kui/issues/4277)
- left-navigation sidecar ([f88329e](https://github.com/IBM/kui/commit/f88329e)), closes [#3635](https://github.com/IBM/kui/issues/3635)
- line highlights on editor save, used for k edit apply errors ([3efa6a5](https://github.com/IBM/kui/commit/3efa6a5)), closes [#4795](https://github.com/IBM/kui/issues/4795)
- MiniSplits ([70b8441](https://github.com/IBM/kui/commit/70b8441)), closes [#5112](https://github.com/IBM/kui/issues/5112)
- only enable WatchPane based on a feature flag ([eb80d0e](https://github.com/IBM/kui/commit/eb80d0e)), closes [#4678](https://github.com/IBM/kui/issues/4678) [#4604](https://github.com/IBM/kui/issues/4604)
- pass command line comments to commentary command ([a020db5](https://github.com/IBM/kui/commit/a020db5)), closes [#5459](https://github.com/IBM/kui/issues/5459)
- patternfly4 dark theme ([3dff5a5](https://github.com/IBM/kui/commit/3dff5a5)), closes [#4419](https://github.com/IBM/kui/issues/4419)
- pin a watchable terminal response in a split pane ([662f413](https://github.com/IBM/kui/commit/662f413)), closes [#4865](https://github.com/IBM/kui/issues/4865) [#4573](https://github.com/IBM/kui/issues/4573) [#4885](https://github.com/IBM/kui/issues/4885) [#4894](https://github.com/IBM/kui/issues/4894)
- Popup client ([063c363](https://github.com/IBM/kui/commit/063c363)), closes [#3886](https://github.com/IBM/kui/issues/3886)
- port kubectl get ns to RadioTable ([be0eabf](https://github.com/IBM/kui/commit/be0eabf)), closes [#4510](https://github.com/IBM/kui/issues/4510) [#4511](https://github.com/IBM/kui/issues/4511)
- RadioTable and port of the themes table to use it ([79a3e8e](https://github.com/IBM/kui/commit/79a3e8e)), closes [#4507](https://github.com/IBM/kui/issues/4507)
- react helpers ([f6bea1f](https://github.com/IBM/kui/commit/f6bea1f))
- refine kubectl contexts table; add support for RadioTable row titles ([11bb074](https://github.com/IBM/kui/commit/11bb074)), closes [#5131](https://github.com/IBM/kui/issues/5131)
- refine sidecar minimization ([ead3b41](https://github.com/IBM/kui/commit/ead3b41)), closes [#3958](https://github.com/IBM/kui/issues/3958)
- resizable sidecar ([0b8a22e](https://github.com/IBM/kui/commit/0b8a22e)), closes [#2484](https://github.com/IBM/kui/issues/2484)
- s3 plugin, and vfs ([970ba6e](https://github.com/IBM/kui/commit/970ba6e)), closes [#5319](https://github.com/IBM/kui/issues/5319)
- separate out themes into a new settings Notebook ([5180759](https://github.com/IBM/kui/commit/5180759)), closes [#5605](https://github.com/IBM/kui/issues/5605)
- snapshot freshening ([d5c8991](https://github.com/IBM/kui/commit/d5c8991)), closes [#5522](https://github.com/IBM/kui/issues/5522)
- SPI for icons ([3d034e3](https://github.com/IBM/kui/commit/3d034e3)), closes [#4441](https://github.com/IBM/kui/issues/4441) [#4364](https://github.com/IBM/kui/issues/4364)
- split screen Terminal ([3a6b422](https://github.com/IBM/kui/commit/3a6b422)), closes [#4814](https://github.com/IBM/kui/issues/4814) [#4821](https://github.com/IBM/kui/issues/4821)
- support replaying in new tab ([04a2c67](https://github.com/IBM/kui/commit/04a2c67)), closes [#5509](https://github.com/IBM/kui/issues/5509)
- target kubectl logs and kubectl exec to Logs and Terminal tabs ([409e632](https://github.com/IBM/kui/commit/409e632)), closes [#4762](https://github.com/IBM/kui/issues/4762)
- Timeline view for kubernetes Jobs ([b623e4e](https://github.com/IBM/kui/commit/b623e4e)), closes [#5370](https://github.com/IBM/kui/issues/5370)
- top tab buttons ([ff8cfba](https://github.com/IBM/kui/commit/ff8cfba)), closes [#4434](https://github.com/IBM/kui/issues/4434)
- update checker ([a7908d2](https://github.com/IBM/kui/commit/a7908d2)), closes [#4537](https://github.com/IBM/kui/issues/4537)
- update ls to allow for presenting content from more limited VFS's such as tutorials ([a1ff1a4](https://github.com/IBM/kui/commit/a1ff1a4)), closes [#5497](https://github.com/IBM/kui/issues/5497)
- **plugins/plugin-kubectl:** kubectl events tab ([2d71f24](https://github.com/IBM/kui/commit/2d71f24)), closes [#4706](https://github.com/IBM/kui/issues/4706)
- watcher panel for open-ended watch jobs ([6dfe7df](https://github.com/IBM/kui/commit/6dfe7df)), closes [#4503](https://github.com/IBM/kui/issues/4503)
- **plugins/plugin-client-common:** accordion blocks in Terminal ([eb2f285](https://github.com/IBM/kui/commit/eb2f285)), closes [#3726](https://github.com/IBM/kui/issues/3726)
- **plugins/plugin-client-common:** allow easier rerunning of command from terminal ([c5384e0](https://github.com/IBM/kui/commit/c5384e0)), closes [#4570](https://github.com/IBM/kui/issues/4570)
- **plugins/plugin-client-common:** History navigation in minisplits should navigate In/Out pairs ([93eb2a4](https://github.com/IBM/kui/commit/93eb2a4)), closes [#5270](https://github.com/IBM/kui/issues/5270)
- **plugins/plugin-client-common:** improved SequenceDiagram view ([1e2fb41](https://github.com/IBM/kui/commit/1e2fb41)), closes [#5342](https://github.com/IBM/kui/issues/5342)
- **plugins/plugin-client-common:** show table row count in card header ([deadcfa](https://github.com/IBM/kui/commit/deadcfa)), closes [#5137](https://github.com/IBM/kui/issues/5137)
- **plugins/plugin-client-common:** use Cards to wrap kube tables and grids ([6698013](https://github.com/IBM/kui/commit/6698013)), closes [#5032](https://github.com/IBM/kui/issues/5032)
- **plugins/plugin-client-common:** use inner scrolling for RadioTables in main Terminals ([952f72a](https://github.com/IBM/kui/commit/952f72a)), closes [#5133](https://github.com/IBM/kui/issues/5133)
- **plugins/plugin-ibmcloud:** initial CodeEngine support ([677faca](https://github.com/IBM/kui/commit/677faca)), closes [#5302](https://github.com/IBM/kui/issues/5302) [#5303](https://github.com/IBM/kui/issues/5303)
- **plugins/plugin-kubectl:** add status column to kube deployment table ([1d35040](https://github.com/IBM/kui/commit/1d35040)), closes [#5476](https://github.com/IBM/kui/issues/5476)
- **plugins/plugin-kubectl:** initial `kubectl job list` improvement for visualizing Job execution ([06030b0](https://github.com/IBM/kui/commit/06030b0)), closes [#5397](https://github.com/IBM/kui/issues/5397)
- **plugins/plugin-kubectl:** port kubectl contexts table to RadioTable ([3cb4dcb](https://github.com/IBM/kui/commit/3cb4dcb)), closes [#4513](https://github.com/IBM/kui/issues/4513)
- render kubectl summary tab using forms ([d88436e](https://github.com/IBM/kui/commit/d88436e)), closes [#4014](https://github.com/IBM/kui/issues/4014)
- shift Block UI to use a Notebook style of presentation ([dc0ee4b](https://github.com/IBM/kui/commit/dc0ee4b)), closes [#5258](https://github.com/IBM/kui/issues/5258)
- spi for CodeSnippet ([105cf2b](https://github.com/IBM/kui/commit/105cf2b)), closes [#4478](https://github.com/IBM/kui/issues/4478)
- StatusStripe should respond to font zooming ([26ba443](https://github.com/IBM/kui/commit/26ba443)), closes [#4242](https://github.com/IBM/kui/issues/4242)
- support for events in table footer ([51669af](https://github.com/IBM/kui/commit/51669af)), closes [#5115](https://github.com/IBM/kui/issues/5115)
- Update default loadingDone to use Card component ([e1b4c61](https://github.com/IBM/kui/commit/e1b4c61)), closes [#4986](https://github.com/IBM/kui/issues/4986)
- use breadcrumbs for TopNavSidecar naming ([5a4611e](https://github.com/IBM/kui/commit/5a4611e)), closes [#4043](https://github.com/IBM/kui/issues/4043) [#3657](https://github.com/IBM/kui/issues/3657) [#4044](https://github.com/IBM/kui/issues/4044)
- **plugins/plugin-client-common:** add styling for blockquotes in Markdown ([b3fa5c6](https://github.com/IBM/kui/commit/b3fa5c6)), closes [#3925](https://github.com/IBM/kui/issues/3925)
- use Carbon Components UIShell for TopTabStripe ([8d7619d](https://github.com/IBM/kui/commit/8d7619d)), closes [#3819](https://github.com/IBM/kui/issues/3819)

### BREAKING CHANGES

- removes support for inBrowserOk
- removes plugin-editor, now in plugin-client-common
- this PR removes plugins/plugin-client-default
- this moves plugin-sidecar and plugin-carbon-tables into plugin-client-common

# [8.12.0](https://github.com/IBM/kui/compare/v4.5.0...v8.12.0) (2020-08-20)

### Bug Fixes

- **plugins-client-common:** the experimental tag should use sans serif ([143464a](https://github.com/IBM/kui/commit/143464a)), closes [#5363](https://github.com/IBM/kui/issues/5363)
- **plugins/plugin-client-common:** always place table events in the Card footer ([b667b28](https://github.com/IBM/kui/commit/b667b28)), closes [#5210](https://github.com/IBM/kui/issues/5210)
- **plugins/plugin-client-common:** buggy header UI in dark themes in minisplits ([55aef48](https://github.com/IBM/kui/commit/55aef48)), closes [#5266](https://github.com/IBM/kui/issues/5266)
- **plugins/plugin-client-common:** clicking on pod delete button can cause command to be executed in minisplit ([37f9019](https://github.com/IBM/kui/commit/37f9019)), closes [#5247](https://github.com/IBM/kui/issues/5247)
- **plugins/plugin-client-common:** clicking to focus on a split does not always cause full focus effect ([bc59bcf](https://github.com/IBM/kui/commit/bc59bcf)), closes [#5263](https://github.com/IBM/kui/issues/5263)
- **plugins/plugin-client-common:** close tabs doesn't produce the correct tab content ([6090887](https://github.com/IBM/kui/commit/6090887)), closes [#5220](https://github.com/IBM/kui/issues/5220)
- **plugins/plugin-client-common:** CSS no longer is reactive to narrow window ([4eb0a11](https://github.com/IBM/kui/commit/4eb0a11)), closes [#5290](https://github.com/IBM/kui/issues/5290)
- **plugins/plugin-client-common:** don't line-wrap input elements in MiniSplits ([c929f5e](https://github.com/IBM/kui/commit/c929f5e)), closes [#5348](https://github.com/IBM/kui/issues/5348)
- **plugins/plugin-client-common:** don't use fixed maxHeight for Terminal tables ([0e23e22](https://github.com/IBM/kui/commit/0e23e22)), closes [#5206](https://github.com/IBM/kui/issues/5206)
- **plugins/plugin-client-common:** Events drilldown from watch table does not always work ([09aee73](https://github.com/IBM/kui/commit/09aee73)), closes [#5204](https://github.com/IBM/kui/issues/5204)
- **plugins/plugin-client-common:** Events should also be placed in table footer (not tbody) when sidecar is open or 2-way terminal split ([1391b1d](https://github.com/IBM/kui/commit/1391b1d)), closes [#5198](https://github.com/IBM/kui/issues/5198)
- **plugins/plugin-client-common:** experiment tag has wrong color contrast in dark themes ([22bfb77](https://github.com/IBM/kui/commit/22bfb77)), closes [#5389](https://github.com/IBM/kui/issues/5389)
- **plugins/plugin-client-common:** Experimental badge should take up less space in minisplits ([268aeb3](https://github.com/IBM/kui/commit/268aeb3)), closes [#5373](https://github.com/IBM/kui/issues/5373)
- **plugins/plugin-client-common:** for now, switch interval chart to duration chart ([ea21221](https://github.com/IBM/kui/commit/ea21221)), closes [#5340](https://github.com/IBM/kui/issues/5340)
- **plugins/plugin-client-common:** Grid regression: grid colors not right ([d1aa46d](https://github.com/IBM/kui/commit/d1aa46d)), closes [#5285](https://github.com/IBM/kui/issues/5285)
- **plugins/plugin-client-common:** improve behavior of up arrow for first command in MiniSplits ([ed199d4](https://github.com/IBM/kui/commit/ed199d4)), closes [#5297](https://github.com/IBM/kui/issues/5297)
- **plugins/plugin-client-common:** improve display of tables in side-by-side terminal splits ([5a32255](https://github.com/IBM/kui/commit/5a32255)), closes [#5201](https://github.com/IBM/kui/issues/5201)
- **plugins/plugin-client-common:** in plain Terminals, tables should not inner scroll ([15fcbba](https://github.com/IBM/kui/commit/15fcbba)), closes [#5221](https://github.com/IBM/kui/issues/5221)
- **plugins/plugin-client-common:** inconsistent top padding above Cards ([1e1037f](https://github.com/IBM/kui/commit/1e1037f)), closes [#5299](https://github.com/IBM/kui/issues/5299)
- **plugins/plugin-client-common:** increase density of SequenceDiagram ([ae29488](https://github.com/IBM/kui/commit/ae29488)), closes [#5344](https://github.com/IBM/kui/issues/5344)
- **plugins/plugin-client-common:** long input lines should line wrap ([8804bb1](https://github.com/IBM/kui/commit/8804bb1)), closes [#5338](https://github.com/IBM/kui/issues/5338)
- **plugins/plugin-client-common:** minor improvements for ls -l output ([1b59c94](https://github.com/IBM/kui/commit/1b59c94)), closes [#5216](https://github.com/IBM/kui/issues/5216)
- **plugins/plugin-client-common:** multi-line paste executes commands out of order ([8f39c80](https://github.com/IBM/kui/commit/8f39c80)), closes [#5295](https://github.com/IBM/kui/issues/5295)
- **plugins/plugin-client-common:** only highlight the Active block in the focused split ([feffad4](https://github.com/IBM/kui/commit/feffad4)), closes [#5261](https://github.com/IBM/kui/issues/5261)
- **plugins/plugin-client-common:** present more than 2 footer lines in watch tables ([3e7a78f](https://github.com/IBM/kui/commit/3e7a78f)), closes [#5213](https://github.com/IBM/kui/issues/5213)
- **plugins/plugin-client-common:** pty commands fail in minisplits ([475ea74](https://github.com/IBM/kui/commit/475ea74)), closes [#5267](https://github.com/IBM/kui/issues/5267)
- **plugins/plugin-client-common:** reduce contrast of block left bars ([7c8d371](https://github.com/IBM/kui/commit/7c8d371)), closes [#5275](https://github.com/IBM/kui/issues/5275)
- **plugins/plugin-client-common:** restore history navigation behavior in minisplits ([26f49e8](https://github.com/IBM/kui/commit/26f49e8)), closes [#5375](https://github.com/IBM/kui/issues/5375)
- **plugins/plugin-client-common:** reverse-i-search incorrectly changes match as i type ([135d429](https://github.com/IBM/kui/commit/135d429)), closes [#5403](https://github.com/IBM/kui/issues/5403)
- **plugins/plugin-client-common:** status column can be invisible in split tables ([c352103](https://github.com/IBM/kui/commit/c352103)), closes [#5244](https://github.com/IBM/kui/issues/5244)
- **plugins/plugin-client-common:** tab completion UI does not render on separate line from input ([61b169b](https://github.com/IBM/kui/commit/61b169b)), closes [#5307](https://github.com/IBM/kui/issues/5307)
- **plugins/plugin-client-common:** TableCell view can fail when given empty duration cells ([04251be](https://github.com/IBM/kui/commit/04251be)), closes [#5332](https://github.com/IBM/kui/issues/5332)
- **plugins/plugin-client-common:** Timeline may not render properly ([d66d728](https://github.com/IBM/kui/commit/d66d728)), closes [#5383](https://github.com/IBM/kui/issues/5383)
- **plugins/plugin-client-common:** Timeline should use stdev-based heat map ([5dd7427](https://github.com/IBM/kui/commit/5dd7427)), closes [#5395](https://github.com/IBM/kui/issues/5395)
- **plugins/plugin-client-common:** Timeline tooltip for cold starts has incorrect concurrency count ([bb54cb8](https://github.com/IBM/kui/commit/bb54cb8)), closes [#5390](https://github.com/IBM/kui/issues/5390)
- **plugins/plugin-client-common:** Timeline view renders poorly in MiniSplit ([07cd000](https://github.com/IBM/kui/commit/07cd000)), closes [#5379](https://github.com/IBM/kui/issues/5379)
- Editor component does not respond to tab layout changes ([9756336](https://github.com/IBM/kui/commit/9756336)), closes [#5231](https://github.com/IBM/kui/issues/5231) [#5232](https://github.com/IBM/kui/issues/5232)
- multiple command history regressions ([cbba96c](https://github.com/IBM/kui/commit/cbba96c)), closes [#5283](https://github.com/IBM/kui/issues/5283)
- switching splits does not participate in tab state ([6eb8db4](https://github.com/IBM/kui/commit/6eb8db4)), closes [#5272](https://github.com/IBM/kui/issues/5272)
- **plugins/plugin-client-common:** "No resources" in watch pane can occlude watch pane title ([e4fd93a](https://github.com/IBM/kui/commit/e4fd93a)), closes [#5064](https://github.com/IBM/kui/issues/5064)
- **plugins/plugin-client-common:** `ok` string appears at the end of MixResponse ([75606c5](https://github.com/IBM/kui/commit/75606c5)), closes [#5046](https://github.com/IBM/kui/issues/5046)
- **plugins/plugin-client-common:** a few more rem/em font-size issues ([133b347](https://github.com/IBM/kui/commit/133b347)), closes [#5058](https://github.com/IBM/kui/issues/5058)
- **plugins/plugin-client-common:** borders in top tab stripe are too light ([3908695](https://github.com/IBM/kui/commit/3908695)), closes [#5051](https://github.com/IBM/kui/issues/5051)
- **plugins/plugin-client-common:** clearing Terminal does not abort watchers ([34adb50](https://github.com/IBM/kui/commit/34adb50)), closes [#5116](https://github.com/IBM/kui/issues/5116)
- **plugins/plugin-client-common:** clicking 'remove' of a watchable response doesn't abort the underlying pty job ([7eb69fb](https://github.com/IBM/kui/commit/7eb69fb)), closes [#5090](https://github.com/IBM/kui/issues/5090)
- **plugins/plugin-client-common:** decrease height of table footer ([5863622](https://github.com/IBM/kui/commit/5863622)), closes [#5072](https://github.com/IBM/kui/issues/5072)
- **plugins/plugin-client-common:** disableTableTitle also disables title of watch panes ([053cfb6](https://github.com/IBM/kui/commit/053cfb6)), closes [#5036](https://github.com/IBM/kui/issues/5036)
- **plugins/plugin-client-common:** double watch panes may open up ([7fb70f1](https://github.com/IBM/kui/commit/7fb70f1)), closes [#5034](https://github.com/IBM/kui/issues/5034)
- **plugins/plugin-client-common:** editor component does not respond to font zooming ([7b7e0f3](https://github.com/IBM/kui/commit/7b7e0f3)), closes [#5120](https://github.com/IBM/kui/issues/5120)
- **plugins/plugin-client-common:** eliminate react "titleInHeader" console warnings ([8cf3797](https://github.com/IBM/kui/commit/8cf3797)), closes [#5078](https://github.com/IBM/kui/issues/5078)
- **plugins/plugin-client-common:** Events footer in minisplit tables lacks horizontal padding ([f22b1f7](https://github.com/IBM/kui/commit/f22b1f7)), closes [#5196](https://github.com/IBM/kui/issues/5196)
- **plugins/plugin-client-common:** font size issues with LeftNavSidecar ([e17fc15](https://github.com/IBM/kui/commit/e17fc15)), closes [#5048](https://github.com/IBM/kui/issues/5048)
- **plugins/plugin-client-common:** improve display of empty watch tables ([4cc16be](https://github.com/IBM/kui/commit/4cc16be)), closes [#5176](https://github.com/IBM/kui/issues/5176)
- **plugins/plugin-client-common:** improve spacing of Event footer content ([d63a6f1](https://github.com/IBM/kui/commit/d63a6f1)), closes [#5178](https://github.com/IBM/kui/issues/5178)
- **plugins/plugin-client-common:** improve top tab bottom UI ([8ff4151](https://github.com/IBM/kui/commit/8ff4151)), closes [#5056](https://github.com/IBM/kui/issues/5056)
- **plugins/plugin-client-common:** input may not receive focus on tab switch ([7676792](https://github.com/IBM/kui/commit/7676792)), closes [#5102](https://github.com/IBM/kui/issues/5102)
- **plugins/plugin-client-common:** layout regressions from table screenshot PRs ([8004ee3](https://github.com/IBM/kui/commit/8004ee3)), closes [#5159](https://github.com/IBM/kui/issues/5159)
- **plugins/plugin-client-common:** leftover debug printfs in table sorting ([9889b49](https://github.com/IBM/kui/commit/9889b49)), closes [#5030](https://github.com/IBM/kui/issues/5030)
- **plugins/plugin-client-common:** Light tables should use Carbon compact ([2309ec3](https://github.com/IBM/kui/commit/2309ec3)), closes [#5059](https://github.com/IBM/kui/issues/5059)
- **plugins/plugin-client-common:** one-row tables needn't offer column sorting UI ([5184fa1](https://github.com/IBM/kui/commit/5184fa1)), closes [#5050](https://github.com/IBM/kui/issues/5050)
- **plugins/plugin-client-common:** place event footer outside of table scroll region for minisplits ([e4872b2](https://github.com/IBM/kui/commit/e4872b2)), closes [#5179](https://github.com/IBM/kui/issues/5179)
- **plugins/plugin-client-common:** RadioTable screenshots lack box shadow ([b0e0f2e](https://github.com/IBM/kui/commit/b0e0f2e)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** RadioTables can have gratuituous line wrapping ([9c39682](https://github.com/IBM/kui/commit/9c39682)), closes [#5139](https://github.com/IBM/kui/issues/5139)
- **plugins/plugin-client-common:** RadioTables in minisplits inner-scroll away the header row ([5296dcd](https://github.com/IBM/kui/commit/5296dcd)), closes [#5165](https://github.com/IBM/kui/issues/5165)
- **plugins/plugin-client-common:** regression in table width with sidecar open ([5938806](https://github.com/IBM/kui/commit/5938806)), closes [#5194](https://github.com/IBM/kui/issues/5194)
- **plugins/plugin-client-common:** selected row in RadioTables in dark themes has low contrast ([f2c5834](https://github.com/IBM/kui/commit/f2c5834)), closes [#5161](https://github.com/IBM/kui/issues/5161)
- **plugins/plugin-client-common:** sidecar badges may not be flush-right ([5b54665](https://github.com/IBM/kui/commit/5b54665)), closes [#5175](https://github.com/IBM/kui/issues/5175)
- **plugins/plugin-client-common:** Tables should have a max-height and use inner scrolling for overflow ([642ef14](https://github.com/IBM/kui/commit/642ef14)), closes [#5153](https://github.com/IBM/kui/issues/5153)
- **plugins/plugin-client-common:** Tables with identical column names render incorrectly ([161dba2](https://github.com/IBM/kui/commit/161dba2)), closes [#5129](https://github.com/IBM/kui/issues/5129)
- **plugins/plugin-client-common:** Terminal Block -> Screenshot of table does not capture box shadow ([ed812f3](https://github.com/IBM/kui/commit/ed812f3)), closes [#5142](https://github.com/IBM/kui/issues/5142)
- **plugins/plugin-client-common:** Terminal focus changes unexpectedly ([866451c](https://github.com/IBM/kui/commit/866451c)), closes [#5170](https://github.com/IBM/kui/issues/5170)
- **plugins/plugin-client-common:** two MiniSplits with open sidecar are too short ([9e21ab9](https://github.com/IBM/kui/commit/9e21ab9)), closes [#5171](https://github.com/IBM/kui/issues/5171)
- **plugins/plugin-client-common:** watch pane grid cells too large ([225f937](https://github.com/IBM/kui/commit/225f937)), closes [#5070](https://github.com/IBM/kui/issues/5070)
- **plugins/plugin-client-common:** watch tables might not be maximized in minisplits ([63420b2](https://github.com/IBM/kui/commit/63420b2)), closes [#5218](https://github.com/IBM/kui/issues/5218)
- **plugins/plugin-client-commong:** show RadioTable selected row in the table body and header breadcrumb ([811c21e](https://github.com/IBM/kui/commit/811c21e)), closes [#5239](https://github.com/IBM/kui/issues/5239)
- **plugins/plugin-client-default:** improve debug logging of client properties ([4daba1f](https://github.com/IBM/kui/commit/4daba1f)), closes [#5088](https://github.com/IBM/kui/issues/5088)
- **plugins/plugin-core-support:** sidecar "window" buttons are too large ([33415d2](https://github.com/IBM/kui/commit/33415d2)), closes [#5094](https://github.com/IBM/kui/issues/5094)
- **plugins/plugin-kubectl:** CurrentNamespace/Context widgets not live ([93ac829](https://github.com/IBM/kui/commit/93ac829)), closes [#5144](https://github.com/IBM/kui/issues/5144)
- kubectl help misformats helm help tables ([ff36755](https://github.com/IBM/kui/commit/ff36755)), closes [#5080](https://github.com/IBM/kui/issues/5080)
- move default loadingDone icon into plugin-client-common ([39994bc](https://github.com/IBM/kui/commit/39994bc)), closes [#5026](https://github.com/IBM/kui/issues/5026)
- multiple issues with tab switching versus status stripe widgets ([8c8a6ec](https://github.com/IBM/kui/commit/8c8a6ec)), closes [#5101](https://github.com/IBM/kui/issues/5101)
- reduce custom CSS rules for table UI ([56f69cb](https://github.com/IBM/kui/commit/56f69cb)), closes [#5024](https://github.com/IBM/kui/issues/5024)
- still see name-related breadcrumbs and short-name header with feature flag sidecarName 'heroText' ([1a8be9f](https://github.com/IBM/kui/commit/1a8be9f)), closes [#5013](https://github.com/IBM/kui/issues/5013)
- **plugins/plugin-client-common:** WatchPane has incorrect padding ([e74bd7b](https://github.com/IBM/kui/commit/e74bd7b)), closes [#5015](https://github.com/IBM/kui/issues/5015)
- Card component does not render well in dark themes ([d96def0](https://github.com/IBM/kui/commit/d96def0)), closes [#4996](https://github.com/IBM/kui/issues/4996)
- clients should be able to enable watcher auto pinning without enabling splitTerminals ([bcade13](https://github.com/IBM/kui/commit/bcade13)), closes [#5002](https://github.com/IBM/kui/issues/5002)
- Confirm dialog color contrast issues ([da14c25](https://github.com/IBM/kui/commit/da14c25)), closes [#4995](https://github.com/IBM/kui/issues/4995)
- increase contrast in watch pane ([246ecd2](https://github.com/IBM/kui/commit/246ecd2)), closes [#5000](https://github.com/IBM/kui/issues/5000) [#5001](https://github.com/IBM/kui/issues/5001)
- move patternfly alignment out of patternfly themes plugin ([6adbfd6](https://github.com/IBM/kui/commit/6adbfd6)), closes [#4988](https://github.com/IBM/kui/issues/4988)
- **plugins/plugin-client-common:** add error icon for error blocks ([5d9aeea](https://github.com/IBM/kui/commit/5d9aeea)), closes [#4907](https://github.com/IBM/kui/issues/4907)
- **plugins/plugin-client-common:** carbon breadcrumbs may not have proper hover effect ([c8cd2d1](https://github.com/IBM/kui/commit/c8cd2d1)), closes [#4962](https://github.com/IBM/kui/issues/4962)
- **plugins/plugin-client-common:** clicking the remove button of a repl block results in an error white screen ([49bfbcc](https://github.com/IBM/kui/commit/49bfbcc)), closes [#4855](https://github.com/IBM/kui/issues/4855)
- **plugins/plugin-client-common:** improve Terminal screenshots by adding padding ([a9b7b26](https://github.com/IBM/kui/commit/a9b7b26)), closes [#4981](https://github.com/IBM/kui/issues/4981)
- **plugins/plugin-client-common:** in Popup mode, use > rather than / for prompt in bottom input ([1360bed](https://github.com/IBM/kui/commit/1360bed)), closes [#4887](https://github.com/IBM/kui/issues/4887)
- **plugins/plugin-client-common:** kubectl edit saves can result in unstyled notification ([5dc658e](https://github.com/IBM/kui/commit/5dc658e)), closes [#4930](https://github.com/IBM/kui/issues/4930)
- **plugins/plugin-client-common:** LeftNavSidecar content section can take over full width ([7252ad4](https://github.com/IBM/kui/commit/7252ad4)), closes [#4831](https://github.com/IBM/kui/issues/4831)
- **plugins/plugin-client-common:** make Close a top-level button in watch panes ([3c14da5](https://github.com/IBM/kui/commit/3c14da5)), closes [#4945](https://github.com/IBM/kui/issues/4945)
- **plugins/plugin-client-common:** missed i18n strings in Dropdown menus ([7490b34](https://github.com/IBM/kui/commit/7490b34)), closes [#4850](https://github.com/IBM/kui/issues/4850)
- **plugins/plugin-client-common:** poor alignment of sidecar toolbar elements ([2307a46](https://github.com/IBM/kui/commit/2307a46)), closes [#4970](https://github.com/IBM/kui/issues/4970)
- **plugins/plugin-client-common:** reduce verbosity of logging in Eval.tsx ([03876db](https://github.com/IBM/kui/commit/03876db)), closes [#4829](https://github.com/IBM/kui/issues/4829)
- **plugins/plugin-client-common:** regression: non-empty repl output has 'ok' at the end ([103a0f9](https://github.com/IBM/kui/commit/103a0f9)), closes [#4924](https://github.com/IBM/kui/issues/4924)
- **plugins/plugin-client-common:** reverse-i-search does not properly report no matches ([c16dad3](https://github.com/IBM/kui/commit/c16dad3)), closes [#4943](https://github.com/IBM/kui/issues/4943)
- **plugins/plugin-client-common:** Screenshot modal never goes away ([bbd1c98](https://github.com/IBM/kui/commit/bbd1c98)), closes [#4979](https://github.com/IBM/kui/issues/4979)
- **plugins/plugin-client-common:** split button errors are not reported to the user ([fc4e2a2](https://github.com/IBM/kui/commit/fc4e2a2)), closes [#4876](https://github.com/IBM/kui/issues/4876)
- **plugins/plugin-client-common:** spurious warning in the console re: Tag ([93982de](https://github.com/IBM/kui/commit/93982de)), closes [#4959](https://github.com/IBM/kui/issues/4959)
- **plugins/plugin-client-common:** status cells of live tables do not always blink ([c94b05e](https://github.com/IBM/kui/commit/c94b05e)), closes [#4903](https://github.com/IBM/kui/issues/4903)
- **plugins/plugin-client-common:** UpdateNotification widget has invisible background color ([c0c1d82](https://github.com/IBM/kui/commit/c0c1d82)), closes [#4968](https://github.com/IBM/kui/issues/4968)
- **plugins/plugin-patternfly-themes:** update theme alignment to patternfly v4 ([3784b96](https://github.com/IBM/kui/commit/3784b96)), closes [#4948](https://github.com/IBM/kui/issues/4948)
- don't blink yellow forever for kubectl events ([a59ee86](https://github.com/IBM/kui/commit/a59ee86)), closes [#4869](https://github.com/IBM/kui/issues/4869)
- empty watch tables/grids should show 'No resources' ([c0bfe99](https://github.com/IBM/kui/commit/c0bfe99)), closes [#4884](https://github.com/IBM/kui/issues/4884)
- erratic scroll region behavior ([be0e2a0](https://github.com/IBM/kui/commit/be0e2a0)), closes [#4898](https://github.com/IBM/kui/issues/4898)
- improve hover effect for status stripe buttons ([50ced8f](https://github.com/IBM/kui/commit/50ced8f)), closes [#4896](https://github.com/IBM/kui/issues/4896)
- kubectl edit apply twice does not work ([1976134](https://github.com/IBM/kui/commit/1976134)), closes [#4797](https://github.com/IBM/kui/issues/4797)
- page-content p should not use text-align: justify ([2646f4b](https://github.com/IBM/kui/commit/2646f4b)), closes [#4908](https://github.com/IBM/kui/issues/4908)
- split screen terminals sometimes incorrect handle exit ([d63cde7](https://github.com/IBM/kui/commit/d63cde7)), closes [#4860](https://github.com/IBM/kui/issues/4860)
- upgrade @patternfly/react-core to latest ([0331533](https://github.com/IBM/kui/commit/0331533)), closes [#4937](https://github.com/IBM/kui/issues/4937)
- **plugins/plugin-client-common:** Screenshot results in a react console error ([725aae5](https://github.com/IBM/kui/commit/725aae5)), closes [#4826](https://github.com/IBM/kui/issues/4826)
- **plugins/plugin-client-common:** sidecar does not resopnd to Escape reliably ([cc27c4b](https://github.com/IBM/kui/commit/cc27c4b)), closes [#4774](https://github.com/IBM/kui/issues/4774) [#4804](https://github.com/IBM/kui/issues/4804)
- **plugins/plugn-client-common:** TopTabStripe stays blue after command execution completes ([68f5841](https://github.com/IBM/kui/commit/68f5841)), closes [#4883](https://github.com/IBM/kui/issues/4883)
- sidecar toolbar can't due justice to longer error messages ([e67e0c9](https://github.com/IBM/kui/commit/e67e0c9)), closes [#4789](https://github.com/IBM/kui/issues/4789)
- **plugins/plugin-client-common:** long RadioTables should offer indication as to selectability of rows ([02c9ea6](https://github.com/IBM/kui/commit/02c9ea6)), closes [#4793](https://github.com/IBM/kui/issues/4793)
- allow user to disable table title by feature flags, and disable table pagination ([5450512](https://github.com/IBM/kui/commit/5450512)), closes [#4640](https://github.com/IBM/kui/issues/4640) [#4655](https://github.com/IBM/kui/issues/4655)
- **plugins/plugin-client-common:** Carbon RadioTable can have odd row-hover effect ([0aedb27](https://github.com/IBM/kui/commit/0aedb27)), closes [#4780](https://github.com/IBM/kui/issues/4780)
- **plugins/plugin-client-common:** Input can appear blank when processing ([d6b6326](https://github.com/IBM/kui/commit/d6b6326)), closes [#4778](https://github.com/IBM/kui/issues/4778)
- **plugins/plugin-client-common:** opening TopNavSidecar results in react Warning in console ([d627272](https://github.com/IBM/kui/commit/d627272)), closes [#3802](https://github.com/IBM/kui/issues/3802)
- **plugins/plugin-client-common:** stop using Carbon's TooltipIcon for DropDown ([be04d20](https://github.com/IBM/kui/commit/be04d20)), closes [#4767](https://github.com/IBM/kui/issues/4767)
- **plugins/plugin-client-common:** TabCompletion can throw a console error ([4f877aa](https://github.com/IBM/kui/commit/4f877aa)), closes [#4785](https://github.com/IBM/kui/issues/4785)
- avoid recomputing tabs when switching back and forth ([cf5e41f](https://github.com/IBM/kui/commit/cf5e41f)), closes [#4666](https://github.com/IBM/kui/issues/4666)
- control+w should not close window on linux and windows ([f80c3e4](https://github.com/IBM/kui/commit/f80c3e4)), closes [#4638](https://github.com/IBM/kui/issues/4638)
- eliminate assumptions that "default" is the default kube namespace ([4eb392d](https://github.com/IBM/kui/commit/4eb392d)), closes [#4764](https://github.com/IBM/kui/issues/4764)
- improve accessibility of table in grid form ([0ade4f7](https://github.com/IBM/kui/commit/0ade4f7)), closes [#4601](https://github.com/IBM/kui/issues/4601)
- **plugin/plugin-client-common:** improvements for patternfly icons ([8941dd0](https://github.com/IBM/kui/commit/8941dd0)), closes [#4471](https://github.com/IBM/kui/issues/4471)
- **plugins/plugin-client-common:** avoid patternfly breadcrumb wrap when used in sidecar ([00ee158](https://github.com/IBM/kui/commit/00ee158)), closes [#4431](https://github.com/IBM/kui/issues/4431)
- **plugins/plugin-client-common:** breadcrumb fonts can be too large, and double zoom ([2e1ce11](https://github.com/IBM/kui/commit/2e1ce11)), closes [#4519](https://github.com/IBM/kui/issues/4519)
- **plugins/plugin-client-common:** carbon breadcrumb secondary text color ([23711f6](https://github.com/IBM/kui/commit/23711f6)), closes [#4575](https://github.com/IBM/kui/issues/4575)
- **plugins/plugin-client-common:** components choice does not reset to default on theme switch ([1434f8b](https://github.com/IBM/kui/commit/1434f8b)), closes [#4423](https://github.com/IBM/kui/issues/4423)
- **plugins/plugin-client-common:** don't use a bright color for terminal prompt ([0d97d98](https://github.com/IBM/kui/commit/0d97d98)), closes [#4427](https://github.com/IBM/kui/issues/4427)
- **plugins/plugin-client-common:** don't use text-02 for finished Inputs ([eb3e549](https://github.com/IBM/kui/commit/eb3e549)), closes [#4600](https://github.com/IBM/kui/issues/4600)
- **plugins/plugin-client-common:** DropDown theme alignment issues ([ef75baf](https://github.com/IBM/kui/commit/ef75baf)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** Eval component throws console errors ([2c52dfb](https://github.com/IBM/kui/commit/2c52dfb)), closes [#4462](https://github.com/IBM/kui/issues/4462)
- **plugins/plugin-client-common:** improved fix for sidecar not showing updates ([19153a7](https://github.com/IBM/kui/commit/19153a7)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- **plugins/plugin-client-common:** improved rendering of markdown links ([3cbe638](https://github.com/IBM/kui/commit/3cbe638)), closes [#4448](https://github.com/IBM/kui/issues/4448)
- **plugins/plugin-client-common:** in narrow windows, TabContent window buttons collide with sidecar window buttons ([d377254](https://github.com/IBM/kui/commit/d377254)), closes [#4459](https://github.com/IBM/kui/issues/4459)
- **plugins/plugin-client-common:** Markdown can fail for headings with nested links ([995b129](https://github.com/IBM/kui/commit/995b129)), closes [#4468](https://github.com/IBM/kui/issues/4468)
- **plugins/plugin-client-common:** more DropDown theming fixes ([7d874a6](https://github.com/IBM/kui/commit/7d874a6)), closes [#4618](https://github.com/IBM/kui/issues/4618)
- **plugins/plugin-client-common:** move leftover carbon scss import for CodeSnippet spi ([f8513ef](https://github.com/IBM/kui/commit/f8513ef)), closes [#4483](https://github.com/IBM/kui/issues/4483)
- **plugins/plugin-client-common:** reverse-i-search text too small ([e488662](https://github.com/IBM/kui/commit/e488662)), closes [#4616](https://github.com/IBM/kui/issues/4616)
- productName in carbon theme shouldn't have hover effect ([3159cd9](https://github.com/IBM/kui/commit/3159cd9)), closes [#4592](https://github.com/IBM/kui/issues/4592)
- some UI elements missing from editor UI ([797f527](https://github.com/IBM/kui/commit/797f527)), closes [#4582](https://github.com/IBM/kui/issues/4582)
- **plugins/plugin-client-common:** override carbon's -webkit-font-smoothing: antialiased ([c114252](https://github.com/IBM/kui/commit/c114252)), closes [#4414](https://github.com/IBM/kui/issues/4414)
- **plugins/plugin-client-common:** PatternFly RadioTable impl lacks header and proper column alignment ([a432728](https://github.com/IBM/kui/commit/a432728)), closes [#4528](https://github.com/IBM/kui/issues/4528)
- **plugins/plugin-client-common:** radio table font size and zooming issues ([6a9d4e7](https://github.com/IBM/kui/commit/6a9d4e7)), closes [#4521](https://github.com/IBM/kui/issues/4521)
- **plugins/plugin-client-common:** RadioTable in some dark themes has poor contrast for sub-text ([a94b8c2](https://github.com/IBM/kui/commit/a94b8c2)), closes [#4541](https://github.com/IBM/kui/issues/4541)
- **plugins/plugin-client-common:** RadioTable should use [@badge-only](https://github.com/badge-only) mixin ([3c327cc](https://github.com/IBM/kui/commit/3c327cc)), closes [#4552](https://github.com/IBM/kui/issues/4552)
- **plugins/plugin-client-common:** RadioTable UI improvements for PatternFly ([1489310](https://github.com/IBM/kui/commit/1489310)), closes [#4539](https://github.com/IBM/kui/issues/4539)
- **plugins/plugin-client-common:** remove background color from tables in light themes ([87651e0](https://github.com/IBM/kui/commit/87651e0)), closes [#4421](https://github.com/IBM/kui/issues/4421)
- **plugins/plugin-client-common:** remove radio support from PaginatedTable ([5bf052e](https://github.com/IBM/kui/commit/5bf052e)), closes [#4515](https://github.com/IBM/kui/issues/4515)
- **plugins/plugin-client-common:** remove use of carbon <Content/> from LeftNavSidecar ([b0fcd3e](https://github.com/IBM/kui/commit/b0fcd3e)), closes [#4464](https://github.com/IBM/kui/issues/4464)
- **plugins/plugin-client-common:** sidecar breadcrumb font too small ([506b6a4](https://github.com/IBM/kui/commit/506b6a4)), closes [#4499](https://github.com/IBM/kui/issues/4499)
- **plugins/plugin-client-common:** some status stripe icons are not vertically centered ([595eec7](https://github.com/IBM/kui/commit/595eec7)), closes [#4404](https://github.com/IBM/kui/issues/4404)
- **plugins/plugin-client-common:** tweaks to WatchPane layout and typogrpahy ([a716bdc](https://github.com/IBM/kui/commit/a716bdc)), closes [#4549](https://github.com/IBM/kui/issues/4549)
- **plugins/plugin-client-common:** WatchPane spacing fixes ([b3bd998](https://github.com/IBM/kui/commit/b3bd998)), closes [#4547](https://github.com/IBM/kui/issues/4547)
- **plugins/plugin-client-common:** with reverse-i-search many errors in console on key press ([794a2d0](https://github.com/IBM/kui/commit/794a2d0)), closes [#4564](https://github.com/IBM/kui/issues/4564)
- **plugins/plugin-kubectl:** k get events -w bombs ([20c2caf](https://github.com/IBM/kui/commit/20c2caf)), closes [#4557](https://github.com/IBM/kui/issues/4557)
- clicking on certain links in kubectl help result in odd behavior ([035894b](https://github.com/IBM/kui/commit/035894b)), closes [#4473](https://github.com/IBM/kui/issues/4473)
- hitting escape on initial page load toggles open empty sidecar ([8fbdce5](https://github.com/IBM/kui/commit/8fbdce5)), closes [#4487](https://github.com/IBM/kui/issues/4487)
- improve alignment of icons ([221d0f9](https://github.com/IBM/kui/commit/221d0f9)), closes [#4555](https://github.com/IBM/kui/issues/4555)
- js and ts files do not get syntax coloring ([d66e71f](https://github.com/IBM/kui/commit/d66e71f)), closes [#4450](https://github.com/IBM/kui/issues/4450)
- optimize kubectl watch load on apiserver ([3f7a32f](https://github.com/IBM/kui/commit/3f7a32f)), closes [#4494](https://github.com/IBM/kui/issues/4494)
- patternfly Navigation missing theme alignment ([047f292](https://github.com/IBM/kui/commit/047f292)), closes [#4399](https://github.com/IBM/kui/issues/4399)
- pty/client performance tweaks ([d86458c](https://github.com/IBM/kui/commit/d86458c)), closes [#4397](https://github.com/IBM/kui/issues/4397)
- TopNavSidecar does not always show updates ([251e5c4](https://github.com/IBM/kui/commit/251e5c4)), closes [#4524](https://github.com/IBM/kui/issues/4524)
- use 30/70 split for LeftNavSidecar ([9a43d0b](https://github.com/IBM/kui/commit/9a43d0b)), closes [#4454](https://github.com/IBM/kui/issues/4454) [#4455](https://github.com/IBM/kui/issues/4455)
- **plugins/plugin-client-common:** links in LeftNavSidecar should not have horizontal padding ([233aae6](https://github.com/IBM/kui/commit/233aae6)), closes [#4337](https://github.com/IBM/kui/issues/4337)
- **plugins/plugin-client-common:** improve color contrast of green badges in sidecar ([f65be60](https://github.com/IBM/kui/commit/f65be60)), closes [#4370](https://github.com/IBM/kui/issues/4370)
- **plugins/plugin-client-common:** sidecar toolbar button svgs are not themed ([327d01d](https://github.com/IBM/kui/commit/327d01d)), closes [#4372](https://github.com/IBM/kui/issues/4372)
- **plugins/plugin-client-common:** sidecar window buttons oddly shift when sidecar is maximized ([bbf7ecd](https://github.com/IBM/kui/commit/bbf7ecd)), closes [#4374](https://github.com/IBM/kui/issues/4374)
- **plugins/plugin-client-common:** Table loads before breadcrumbs, oddly ([cb8a97d](https://github.com/IBM/kui/commit/cb8a97d)), closes [#4385](https://github.com/IBM/kui/issues/4385)
- > prompt text has poor vertical alignment ([9a796b3](https://github.com/IBM/kui/commit/9a796b3)), closes [#4237](https://github.com/IBM/kui/issues/4237)
- a few more tweaks to prompt ([7bf658a](https://github.com/IBM/kui/commit/7bf658a)), closes [#4250](https://github.com/IBM/kui/issues/4250)
- add support for hiding elements at higher zoom levels ([7d2a7e0](https://github.com/IBM/kui/commit/7d2a7e0)), closes [#4232](https://github.com/IBM/kui/issues/4232)
- make inBrowserOk the default ([2a3c811](https://github.com/IBM/kui/commit/2a3c811)), closes [#4275](https://github.com/IBM/kui/issues/4275)
- prompt text alignment issues ([75a3efe](https://github.com/IBM/kui/commit/75a3efe)), closes [#4368](https://github.com/IBM/kui/issues/4368)
- PTY behaves oddly when switching tabs ([700cdda](https://github.com/IBM/kui/commit/700cdda)), closes [#2579](https://github.com/IBM/kui/issues/2579)
- sidecar views do not respect tab-specificity ([5a1cae2](https://github.com/IBM/kui/commit/5a1cae2)), closes [#4362](https://github.com/IBM/kui/issues/4362)
- **plugins/plugin-client-common:** Breadcrumbs in Sidecar can clip at higher font zoom levels ([3b381d7](https://github.com/IBM/kui/commit/3b381d7)), closes [#4230](https://github.com/IBM/kui/issues/4230)
- **plugins/plugin-client-common:** captured screenshots can show hover effect ([d48370b](https://github.com/IBM/kui/commit/d48370b)), closes [#4153](https://github.com/IBM/kui/issues/4153)
- **plugins/plugin-client-common:** captured screenshots sometimes have residual sepia tones ([97172c6](https://github.com/IBM/kui/commit/97172c6)), closes [#4170](https://github.com/IBM/kui/issues/4170)
- **plugins/plugin-client-common:** combine top toolbar and header of PaginatedTable UI ([3e1a1a7](https://github.com/IBM/kui/commit/3e1a1a7)), closes [#4131](https://github.com/IBM/kui/issues/4131)
- **plugins/plugin-client-common:** ctrl+l does not clear screen in popup mode ([33fcd82](https://github.com/IBM/kui/commit/33fcd82)), closes [#4269](https://github.com/IBM/kui/issues/4269)
- **plugins/plugin-client-common:** escape key close both Confirm and the Sidecar ([f9739ec](https://github.com/IBM/kui/commit/f9739ec)), closes [#4215](https://github.com/IBM/kui/issues/4215)
- **plugins/plugin-client-common:** escape key should not toggle open closed sidecar ([bfa96ed](https://github.com/IBM/kui/commit/bfa96ed)), closes [#4218](https://github.com/IBM/kui/issues/4218)
- **plugins/plugin-client-common:** escape should not toggle sidecar visibility in popup mode ([2d9b36b](https://github.com/IBM/kui/commit/2d9b36b)), closes [#4211](https://github.com/IBM/kui/issues/4211)
- **plugins/plugin-client-common:** in popup mode, make sure repl is visible after command execution ([0134952](https://github.com/IBM/kui/commit/0134952)), closes [#4183](https://github.com/IBM/kui/issues/4183)
- **plugins/plugin-client-common:** prompt can oddly shift to left with large font sizes ([10c91f0](https://github.com/IBM/kui/commit/10c91f0)), closes [#4231](https://github.com/IBM/kui/issues/4231)
- **plugins/plugin-client-common:** repeated ctrl+r does not continue active reverse-i-search ([4e292cc](https://github.com/IBM/kui/commit/4e292cc)), closes [#4216](https://github.com/IBM/kui/issues/4216)
- **plugins/plugin-client-common:** sidecar history should respect PWD ([b122cc1](https://github.com/IBM/kui/commit/b122cc1)), closes [#4202](https://github.com/IBM/kui/issues/4202)
- **plugins/plugin-client-common:** Table paginator does not allow traversal to last page ([1916d9d](https://github.com/IBM/kui/commit/1916d9d)), closes [#4358](https://github.com/IBM/kui/issues/4358)
- **plugins/plugin-client-common:** tooltips can render below other UI elements ([6dd4808](https://github.com/IBM/kui/commit/6dd4808)), closes [#4159](https://github.com/IBM/kui/issues/4159)
- **plugins/plugin-client-common:** topTabNames property does not always obey theme ([c79f9f8](https://github.com/IBM/kui/commit/c79f9f8)), closes [#4314](https://github.com/IBM/kui/issues/4314)
- **Plugins/plugin-client-common:** Tab.tsx throws console error for new users ([14d8895](https://github.com/IBM/kui/commit/14d8895)), closes [#4318](https://github.com/IBM/kui/issues/4318)
- eliminate complex nesting of NavResponse model ([e849ae7](https://github.com/IBM/kui/commit/e849ae7)), closes [#4205](https://github.com/IBM/kui/issues/4205)
- font zooming issues ([5442532](https://github.com/IBM/kui/commit/5442532)), closes [#4176](https://github.com/IBM/kui/issues/4176) [#4177](https://github.com/IBM/kui/issues/4177)
- improve handling of narrower windows ([7a32591](https://github.com/IBM/kui/commit/7a32591)), closes [#4181](https://github.com/IBM/kui/issues/4181)
- lighten up the PaginatedTable UI ([eccf23b](https://github.com/IBM/kui/commit/eccf23b)), closes [#4155](https://github.com/IBM/kui/issues/4155)
- multiple tab completion bugs ([5513712](https://github.com/IBM/kui/commit/5513712)), closes [#4281](https://github.com/IBM/kui/issues/4281)
- remove use of inline styling in Form.tsx ([23121b2](https://github.com/IBM/kui/commit/23121b2)), closes [#4112](https://github.com/IBM/kui/issues/4112)
- reverse-i-search text should be monospace ([4c0bd05](https://github.com/IBM/kui/commit/4c0bd05)), closes [#4254](https://github.com/IBM/kui/issues/4254)
- sidecar Toolbar component renders empty if there is no Toolbar content ([14c27ba](https://github.com/IBM/kui/commit/14c27ba)), closes [#4229](https://github.com/IBM/kui/issues/4229)
- **plugins/plugin-client-common:** with narrow windows, hide sidecar resize thumb ([a7c72e8](https://github.com/IBM/kui/commit/a7c72e8)), closes [#4179](https://github.com/IBM/kui/issues/4179)
- table status grid layout seems buggy ([7da6ff3](https://github.com/IBM/kui/commit/7da6ff3)), closes [#4143](https://github.com/IBM/kui/issues/4143)
- **plugins/plugin-client-common:** table bottom toolbar missing grid buttons, poor alignment and height ([44e1018](https://github.com/IBM/kui/commit/44e1018)), closes [#4133](https://github.com/IBM/kui/issues/4133)
- **plugins/plugin-kubectl:** kubectl watch tables can be misparsed ([cb3e1c2](https://github.com/IBM/kui/commit/cb3e1c2)), closes [#4139](https://github.com/IBM/kui/issues/4139)
- **plugins/plugni-client-common:** improve contrast of Toolbar tooltips ([a167f3b](https://github.com/IBM/kui/commit/a167f3b)), closes [#4108](https://github.com/IBM/kui/issues/4108)
- breadcrumb in TopNavSidecar isn't zoomable ([2642f39](https://github.com/IBM/kui/commit/2642f39)), closes [#4091](https://github.com/IBM/kui/issues/4091)
- improve kubectl breadcrumb detection ([6cacfe6](https://github.com/IBM/kui/commit/6cacfe6)), closes [#4099](https://github.com/IBM/kui/issues/4099)
- **plugins/plugin-client-common:** reduce size of sidecar window buttons ([79336ad](https://github.com/IBM/kui/commit/79336ad)), closes [#4074](https://github.com/IBM/kui/issues/4074)
- **plugins/plugin-client-common:** TopNavSidecar renders poorly with narrower windows ([4be1068](https://github.com/IBM/kui/commit/4be1068)), closes [#4095](https://github.com/IBM/kui/issues/4095)
- cmd+w doesn't closes the window when there's only 1 tab ([f2868a9](https://github.com/IBM/kui/commit/f2868a9)), closes [#3884](https://github.com/IBM/kui/issues/3884)
- disable pagination and use word-break in sidecar sidecar carbon-tables ([8d4ff4f](https://github.com/IBM/kui/commit/8d4ff4f)), closes [#3882](https://github.com/IBM/kui/issues/3882)
- Form component sometimes has too-small TextInputs ([21d841d](https://github.com/IBM/kui/commit/21d841d)), closes [#4036](https://github.com/IBM/kui/issues/4036)
- helm o