"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _context = _interopRequireDefault(require("./context"));

var _Block = _interopRequireDefault(require("../Views/Terminal/Block"));

var _BlockModel = require("../Views/Terminal/Block/BlockModel");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class InputStripe extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this._blockRef = _react.default.createRef();

    _core.eventBus.onCommandComplete(this.props.uuid, this.onOutputRender.bind(this));

    this.state = {
      idx: 0,
      model: (0, _BlockModel.Active)()
    };
  }
  /** Command has completed in our tab */


  onOutputRender() {
    this.setState(curState => ({
      idx: curState.idx + 1,
      model: (0, _BlockModel.Active)()
    }));
  }

  doFocus() {
    if (this._blockRef.current) {
      this._blockRef.current.doFocus();
    }
  }

  render() {
    return _react.default.createElement(_context.default.Provider, {
      value: {
        prompt: this.props.prompt || '\u276f'
      }
    }, _react.default.createElement("div", {
      className: "kui--input-stripe repl"
    }, _react.default.createElement(_Block.default, {
      ref: this._blockRef,
      idx: this.state.idx,
      uuid: this.props.uuid,
      tab: this.props.tab,
      model: this.state.model,
      noOutput: true,
      noPromptContext: true,
      isFocused: true,
      promptPlaceholder: this.props.promptPlaceholder
    }, this.props.children)));
  }

}

exports.default = InputStripe;