"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _Settings = _interopRequireDefault(require("./Settings"));

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _Tooltip = _interopRequireDefault(require("../../spi/Tooltip"));

var _MeterWidgets = _interopRequireDefault(require("./MeterWidgets"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
}; // FIXME:

/* eslint-disable react/prop-types */


const Markdown = _react.default.lazy(() => Promise.resolve().then(() => require('../../Content/Markdown')));

const strings = (0, _core.i18n)('plugin-client-common');
/** see https://github.com/microsoft/TypeScript/issues/10485 */

function hasType(evt) {
  return evt.type !== undefined;
}

class StatusStripe extends _react.default.PureComponent {
  constructor(props) {
    super(props);
    this.helpRef = _react.default.createRef();

    _core.eventBus.onStatusStripeChangeRequest(this.onChangeRequest.bind(this));

    this.state = this.withStateDefaults(props);
  }
  /** Overlay default values for required state variables */


  withStateDefaults(evt) {
    if (hasType(evt)) {
      return evt;
    } else {
      return Object.assign({}, evt, {
        type: 'default'
      });
    }
  }
  /** Status Stripe change request */


  onChangeRequest(evt) {
    this.setState(this.withStateDefaults(evt));
  }
  /**
   * User has clicked on the Settings icon.
   *
   */


  doAbout() {
    return __awaiter(this, void 0, void 0, function* () {
      (0, _core.pexecInCurrentTab)('about');
    });
  }
  /**
   * If the Client offers no status stripe widgets, we should insert a
   * filler, so that the Settings icon is presented flush-right.
   *
   */


  filler() {
    return _react.default.createElement("div", {
      style: {
        flex: 1
      }
    });
  }
  /**
   * Render the current State.message, if any
   *
   */


  message() {
    if (this.state.type !== 'default' && this.state.message) {
      return _react.default.createElement("div", {
        className: "kui--status-stripe-element left-pad kui--status-stripe-message-element"
      }, _react.default.createElement(Markdown, {
        source: this.state.message
      }));
    }
  }
  /**
   * Render any widgets specified by the client. Note how we don't
   * show widgets if we were given a message. See
   * https://github.com/IBM/kui/issues/5490
   *
   */


  widgets() {
    if (this.state.type !== 'default' || _react.default.Children.count(this.props.children) === 0) {
      return this.filler();
    } else {
      return this.props.children;
    }
  }

  className() {
    return 'kui--status-stripe' + (this.state.type === 'default' ? ' kui--inverted-color-context' : '');
  }

  render() {
    return _react.default.createElement(_react.default.Suspense, {
      fallback: _react.default.createElement("div", null)
    }, _react.default.createElement("div", {
      className: this.className(),
      id: "kui--status-stripe",
      "data-type": this.state.type
    }, this.message(), this.widgets(), _react.default.createElement(_MeterWidgets.default, {
      className: "kui--hide-in-narrower-windows"
    }, !this.props.noSettings && _react.default.createElement(_Settings.default, null)), !this.props.noHelp && _react.default.createElement("div", {
      className: "kui--status-stripe-button"
    }, _react.default.createElement("a", {
      href: "#",
      className: "kui--tab-navigatable kui--status-stripe-element-clickable kui--status-stripe-element",
      id: "help-button",
      "aria-label": "Help",
      tabIndex: 0,
      ref: this.helpRef,
      onClick: () => this.doAbout()
    }, _react.default.createElement(_Icons.default, {
      icon: "Help"
    })), _react.default.createElement(_Tooltip.default, {
      reference: this.helpRef,
      position: "top"
    }, strings('Click for help')))));
  }

}

exports.default = StatusStripe;