"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _reactCore = require("@patternfly/react-core");

var _context = _interopRequireDefault(require("../context"));

var _NewTabButton = _interopRequireDefault(require("./NewTabButton"));

var _Tab = _interopRequireDefault(require("./Tab"));

var _SplitTerminalButton = _interopRequireDefault(require("./SplitTerminalButton"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class TopTabStripe extends _react.default.PureComponent {
  componentDidMount() {
    this.addKeyboardListeners();
  }
  /**
   * Register any keyboard event listeners
   *
   */


  addKeyboardListeners() {
    if ((0, _core.inElectron)()) {
      // switch tabs based on keyboard events
      document.addEventListener('keydown', event => {
        if (event.metaKey && event.shiftKey) {
          // shift-command+[]: switch to previous or next
          const whichDir = event.key;

          if (whichDir === '[' || whichDir === ']') {
            const newIdx = whichDir === '[' ? this.props.activeIdx - 1 : this.props.activeIdx + 1;
            this.props.onSwitchTab(newIdx);
          }

          event.stopPropagation();
          return;
        }

        if (event.ctrlKey) {
          // ctrl+PgUp/PgDown: switch to previous or next
          const whichDir = event.keyCode;

          if (whichDir === _core.KeyCodes.PAGEUP || whichDir === _core.KeyCodes.PAGEDOWN) {
            const newIdx = whichDir === _core.KeyCodes.PAGEUP ? this.props.activeIdx - 1 : this.props.activeIdx + 1;
            this.props.onSwitchTab(newIdx);
          }

          event.stopPropagation();
          return;
        }

        if (event.metaKey) {
          // meta+number: switch to tab by index
          const whichTabStr = event.key;

          if (/\d/.test(whichTabStr)) {
            event.stopPropagation();
            const whichTabIdx = parseInt(whichTabStr, 10);
            this.props.onSwitchTab(whichTabIdx - 1);
          }
        }
      });
    }
  }
  /** Render tabs */


  tabs() {
    return _react.default.createElement(_react.default.Fragment, null, _react.default.createElement(_reactCore.Nav, {
      "aria-label": "Tabs",
      variant: "horizontal",
      className: "kui--header-tabs"
    }, _react.default.createElement(_reactCore.NavList, {
      className: "kui--tab-list"
    }, this.props.tabs.map((tab, idx) => _react.default.createElement(_Tab.default, Object.assign({}, this.props, {
      key: idx,
      idx: idx,
      uuid: tab.uuid,
      title: tab.title,
      closeable: this.props.tabs.length > 1,
      active: idx === this.props.activeIdx,
      onCloseTab: idx => this.props.onCloseTab(idx),
      onSwitchTab: idx => this.props.onSwitchTab(idx)
    }))))), !(0, _core.isOfflineClient)() && _react.default.createElement("div", {
      className: "kui--top-tab-buttons"
    }, _react.default.createElement(_NewTabButton.default, {
      onNewTab: this.props.onNewTab
    }), _react.default.createElement(_SplitTerminalButton.default, null)));
  }

  headerName() {
    return _react.default.createElement(_context.default.Consumer, null, config => _react.default.createElement("div", {
      prefix: "",
      className: "kui--header--name"
    }, config.productName || 'Kui'));
  }

  header() {
    const logoProps = {
      /*      href: 'https://patternfly.org',
      onClick: () => console.log('clicked logo'),
      target: '_blank' */
    };
    return _react.default.createElement(_reactCore.PageHeader, {
      className: "kui--top-tab-stripe-header",
      logo: this.headerName(),
      logoProps: logoProps,
      topNav: this.tabs()
    });
  }
  /**
   * React render handler
   *
   */


  render() {
    return _react.default.createElement(_reactCore.Page, {
      "aria-label": "Header",
      className: "kui--top-tab-stripe",
      header: this.header(),
      mainContainerId: "kui--top-tab-stripe-main"
    });
  }

}

exports.default = TopTabStripe;