"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = renderHeader;

var _react = _interopRequireDefault(require("react"));

var _reactTable = require("@patternfly/react-table");

var _sort = require("./sort");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * Render the TableHeader part
 *
 */
function renderHeader(kuiHeader, isSortable, activeSortIdx, direction, onSort) {
  const th = (key, value, cidx, outerCSS, css) => {
    const dataKey = key || value;
    const sortParam = isSortable && (0, _sort.isSortableCol)(dataKey) ? {
      sort: {
        sortBy: {
          index: activeSortIdx,
          direction
        },
        onSort: (_, clickColIdx, clickDir) => onSort(dataKey, cidx, clickColIdx, clickDir),
        columnIndex: cidx
      }
    } : {}; // nowrap seems to be needed to avoid PatternFly using a "truncate"
    // mode; see TableCell, where we set "fitContent" as the modifier
    // for the cells; but that alone seems to cause truncation in the
    // header :( hence this "nowrap". A bit puzzling.

    return _react.default.createElement(_reactTable.Th, Object.assign({
      key: key || value,
      "data-key": key || value,
      className: `kui--header-cell ${outerCSS || ''}`,
      modifier: "nowrap"
    }, sortParam), css ? _react.default.createElement("span", {
      className: css
    }, value) : value);
  };

  return _react.default.createElement(_reactTable.Thead, null, _react.default.createElement(_reactTable.Tr, null, th(kuiHeader.key, kuiHeader.name, 0, kuiHeader.outerCSS, kuiHeader.css), kuiHeader.attributes.map((attr, cidx) => th(attr.key, attr.value, cidx + 1, attr.outerCSS, attr.css))));
}