"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _Icons = _interopRequireDefault(require("../../spi/Icons"));

var _ToolbarButton = _interopRequireDefault(require("./ToolbarButton"));

var _Markdown = _interopRequireDefault(require("../../Content/Markdown"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/** helper to ensure exhaustiveness of the switch statement below */
// eslint-disable-next-line @typescript-eslint/no-unused-vars
function assertUnreachable(x) {
  throw new Error('Did not expect to get here');
}

class Toolbar extends _react.default.PureComponent {
  icon() {
    if (this.props.toolbarText) {
      const {
        type
      } = this.props.toolbarText;

      switch (type) {
        case 'info':
          return _react.default.createElement(_Icons.default, {
            icon: "Info"
          });

        case 'success':
          return _react.default.createElement(_Icons.default, {
            icon: "Checkmark"
          });

        case 'warning':
          return _react.default.createElement(_Icons.default, {
            icon: "Warning"
          });

        case 'error':
          return _react.default.createElement(_Icons.default, {
            icon: "Error"
          });
      } // this bit of magic ensures exhaustiveness of the switch;
      // reference: https://stackoverflow.com/a/39419171


      return assertUnreachable(type);
    }
  }

  buttons() {
    if (this.props.buttons) {
      return this.props.buttons.sort() // sort alphabetically first
      .sort((a, b) => {
        return (a.order || 0) - (b.order || 0);
      }).map((button, idx) => _react.default.createElement(_ToolbarButton.default, {
        tab: this.props.tab,
        execUUID: this.props.execUUID,
        button: button,
        response: this.props.response,
        args: this.props.args,
        key: idx
      }));
    }
  }

  render() {
    try {
      return _react.default.createElement("div", {
        className: "sidecar-bottom-stripe-toolbar"
      }, _react.default.createElement("div", {
        className: "sidecar-toolbar-text",
        "data-location-bottom": this.props.bottom || undefined,
        "data-type": this.props.toolbarText && this.props.toolbarText.type
      }, _react.default.createElement("div", {
        className: "sidecar-toolbar-text-icon"
      }, this.icon()), this.props.toolbarText && (typeof this.props.toolbarText.text === 'string' ? _react.default.createElement(_Markdown.default, {
        source: this.props.toolbarText.text,
        className: "sidecar-toolbar-text-content"
      }) : _react.default.createElement("div", {
        className: "sidecar-toolbar-text-content",
        dangerouslySetInnerHTML: {
          __html: this.props.toolbarText.text.innerHTML
        }
      }))), _react.default.createElement("div", {
        className: "sidecar-bottom-stripe-mode-bits sidecar-bottom-stripe-button-container",
        "data-location-bottom": this.props.bottom || undefined
      }, _react.default.createElement("div", {
        className: "fill-container flex-layout flush-right flex-align-stretch"
      }, this.buttons())));
    } catch (err) {
      console.error(err);
      return _react.default.createElement("div", null);
    }
  }

}

exports.default = Toolbar;