"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = onKeyPress;

var _BlockModel = require("./BlockModel");

/*
 * Copyright 2017 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }

  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }

    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }

    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }

    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};

function onKeyPress(event) {
  return __awaiter(this, void 0, void 0, function* () {
    const char = event.key;

    if (char === 'Enter') {
      // user typed Enter; we've finished Reading, now Evalute
      const {
        doEval
      } = yield Promise.resolve().then(() => require('@kui-shell/core')); // Do we already have an execUUID? if so, this means we are in the
      // midst of a command re-execution. In order to have the command
      // response flow back to the same block, we have to reuse the
      // execUUID. See https://github.com/IBM/kui/issues/5814

      const execUUID = (0, _BlockModel.hasUUID)(this.props.model) ? this.props.model.execUUID : undefined; // see https://github.com/IBM/kui/issues/6311

      this.setState({
        isReEdit: false
      });
      doEval(this.props.tab, this.props._block, this.state.prompt.value.trim(), execUUID); //                                                                        ^^^^ reusing execUUID
    }
  });
}