"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _reactCore = require("@patternfly/react-core");

var _2 = require("..");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
class PatternflyBreadcrumb extends _react.default.PureComponent {
  render() {
    const currentPageIdx = (0, _2.getCurrentPageIdx)(this.props);
    return _react.default.createElement(_reactCore.Breadcrumb, {
      className: "kui--breadcrumb"
    }, this.props.breadcrumbs.map((_, idx) => {
      const onClick = _.command && (() => this.props.repl.pexec(_.command));

      return _react.default.createElement(_reactCore.BreadcrumbItem, {
        to: onClick ? '#' : undefined,
        key: idx,
        className: [_.className, 'kui--breadcrumb-item', _.deemphasize && 'kui--secondary-breadcrumb', idx === currentPageIdx && 'kui--current-page-breadcrumb'].filter(_ => _).join(' '),
        isActive: idx === this.props.breadcrumbs.length - 1,
        onClick: onClick
      }, _.label);
    }));
  }

}

exports.default = PatternflyBreadcrumb;