"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _core = require("@kui-shell/core");

var _reactCore = require("@patternfly/react-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2020 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
const strings = (0, _core.i18n)('plugin-client-common');

class PatternFlyExpandableSection extends _react.default.PureComponent {
  constructor(props) {
    super(props);

    this.onToggle = isExpanded => {
      if (this.props.onToggle) {
        this.props.onToggle(isExpanded);
      }

      this.setState({
        isExpanded
      });
    };

    this.state = {
      isExpanded: this.props.expanded || false
    };
  }

  toggleText() {
    return this.state.isExpanded ? this.props.showLess || strings('Show Less') : this.props.showMore || strings('Show More');
  }

  render() {
    const {
      isExpanded
    } = this.state;
    const className = 'kui--expandable-section' + (this.props.className ? ' ' + this.props.className : '');
    return _react.default.createElement(_reactCore.ExpandableSection, {
      className: className,
      toggleText: this.toggleText(),
      onToggle: this.onToggle,
      isExpanded: isExpanded
    }, isExpanded && this.props.children);
  }

}

exports.default = PatternFlyExpandableSection;