"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = PatternFlyModal;

var _react = _interopRequireDefault(require("react"));

var _reactCore = require("@patternfly/react-core");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

/*
 * Copyright 2021 The Kubernetes Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
function PatternFlyModal(props) {
  return _react.default.createElement(_reactCore.Modal, {
    id: props.id,
    isOpen: props.isOpen,
    title: props.title,
    titleIconVariant: props.titleIconVariant,
    variant: "small",
    onClose: props.onClose,
    actions: [_react.default.createElement(_reactCore.Button, {
      key: "confirm",
      variant: "primary",
      className: "kui--modal-btn--primary",
      onClick: props.onSubmit
    }, props.primaryButtonText), _react.default.createElement(_reactCore.Button, {
      key: "cancel",
      variant: "link",
      className: "kui--modal-btn--secondary",
      onClick: props.onClose
    }, props.secondaryButtonText)]
  }, props.children);
}